<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

if (!isset($links_permissions["can_admin_links"]) or !$links_permissions["can_admin_links"]) {
	print_no_permission();
	exit;
}

/* ===========================================================================*/
// Summarise file information
/* ===========================================================================*/

if ($this_action == "admin" and $adminset == "filetypes") {

	$navbits[""] = $vbphrase['ll_menu_admmime'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	cache_LDMmimetype();

	$myft = array();
	$mygaps = array();

    $allow_upload_in_cats = array();
    $allow_image_in_cats = array();

	foreach ($ldm_mimetype_cache as $type=>$mime) {
		$myft[$type] = array('upload'=>0, 'image'=>0, 'media'=>array(), 'size'=>$mime['size'], 'mimetype'=>$mime['mimetype'], 'count'=>0);
	}

    foreach ($ldm_master_settings['upload_filetypes'] as $thiscatid=>$thisuploadfiletypes) {
		if ($thisuploadfiletypes) {
   			foreach (explode(',', preg_replace("/\s/","", $thisuploadfiletypes["setting"])) as $type) {
   			    if ($type) {
   			        $allow_upload_in_cats[$thiscatid][$type] = 1;
   			    }
   			}
		}
	}
    foreach ($ldm_master_settings['image_filetypes'] as $thiscatid=>$thisimagefiletypes) {
		if ($thisimagefiletypes) {
   			foreach (explode(',', preg_replace("/\s/","", $thisimagefiletypes["setting"])) as $type) {
   			    if ($type) {
   			        $allow_image_in_cats[$thiscatid][$type] = 1;
    				if (!isset($myft[$type])) {
    					$mygaps[$type]['image'] = $vbphrase['ll_yes'];
	    			}
   			    }
   			}
		}
	}

	require_once(DIR . '/includes/local_links_players.php');
	load_ldm_players();

	foreach ($ldm_players as $id=>$thisplayer) {
		foreach (explode(',', preg_replace("/\s/","", $thisplayer['filetypes_played'])) as $type) {
			if ($type) {
				if (isset($myft[$type])) {
					$myft[$type]['media'][] = $thisplayer;
				}
				else {
					$mygaps[$type]['media'][] = $thisplayer;
				}
			}
		}
	}

    $restrict_usergroups = array();
	$asb = $vbulletin->db->query_read("
		SELECT extension
		FROM ".TABLE_PREFIX."attachmentpermission
		WHERE attachmentpermissions=0
	");
	while ($row=$vbulletin->db->fetch_array($asb)) {
	    $restrict_usergroups[$row['extension']] = 1;
	}

    if (!isset($allow_upload_in_cats[$BASE_CAT])) { // default case: use only the admin/attachments table
   		foreach ($ldm_mimetype_cache as $type=>$mime) {
   		    $myft[$type]['upload'] = "";
   		    if ($ldm_mimetype_cache[$type]['enabled']) {
        		$myft[$type]['upload'] = isset($restrict_usergroups[$type]) ? $vbphrase['ll_withugrestrictions'] : $vbphrase['ll_yes'];
        	}
	    }
	}
	else { // more complex case
   		foreach ($ldm_mimetype_cache as $type=>$mime) {
   		    $myft[$type]['upload'] = "";
   		    if (isset($allow_upload_in_cats[$BASE_CAT][$type])) {
        		$myft[$type]['upload'] = isset($restrict_usergroups[$type]) ? $vbphrase['ll_withugrestrictions'] : $vbphrase['ll_yes'];
        	}
        }
    }

    if (!isset($allow_image_in_cats[$BASE_CAT])) { // default case: use only the admin/attachments table
   		foreach ($ldm_mimetype_cache as $type=>$mime) {
   		    $myft[$type]['image'] = "";
   		    if ($ldm_mimetype_cache[$type]['enabled']) {
        		$myft[$type]['image'] = isset($restrict_usergroups[$type]) ? $vbphrase['ll_withugrestrictions'] : $vbphrase['ll_yes'];
        	}
	    }
	}
	else { // more complex case
   		foreach ($ldm_mimetype_cache as $type=>$mime) {
   		    $myft[$type]['image'] = "";
   		    if (isset($allow_image_in_cats[$BASE_CAT][$type])) {
        		$myft[$type]['image'] = isset($restrict_usergroups[$type]) ? $vbphrase['ll_withugrestrictions'] : $vbphrase['ll_yes'];
        	}
        }
    }

	$upload_override = "";
	if (count($allow_upload_in_cats)) {
        $upload_override = array_keys($allow_upload_in_cats);
        foreach ($upload_override as $i=>$j) {
            if ($j>0) {
                $upload_override[$i] =
                '<a target="_blank" title='.$vbphrase['ll_editcat'].'" href="'.$LINKS_SCRIPT.'.php?action=editcat&amp;catid='.$j.'">'.$linkscat[$j]['catname'].'</a>';
            }
            else {
                unset($upload_override[$i]);
            }
        }
        $upload_override = construct_phrase($vbphrase['ll_admin_can_customise'], implode(', ', $upload_override));
	}

	$image_override = "";
	if (count($allow_image_in_cats)) {
        $image_override = array_keys($allow_image_in_cats);
        foreach ($image_override as $i=>$j) {
            if ($j>0) {
                $image_override[$i] =
                '<a target="_blank" title='.$vbphrase['ll_editcat'].'" href="'.$LINKS_SCRIPT.'.php?action=editcat&amp;catid='.$j.'">'.$linkscat[$j]['catname'].'</a>';
            }
            else {
                unset($image_override[$i]);
            }
        }
        $image_override = construct_phrase($vbphrase['ll_admin_can_customise'], implode(', ', $image_override));
	}

// Gather list of files in upload and thumbs directories
    $files = array();
    require_once(DIR . '/includes/local_links_misc.php');
    $filetypes = array_keys($vbulletin->attachmentcache);

    foreach (array('upload_dir', 'thumbs_dir', ) as $key) {
        if ($links_defaults[$key]) {
    	    ldm_read_directory($links_defaults[$key], $filetypes, $d_list, $f_list, $skipped, 10);
	        foreach ($f_list as $thisfile=>$thisval) {
	            $files[ldm_make_filename($links_defaults[$key], $thisfile)] = 0;
	        }
	    }
	}

// Scan the contents of the entries table
	$ldmft = array();
	$asb = $vbulletin->db->query_read("
		SELECT linkurl, linkfile, linksize, linkstatus, linkimg, linkimgthumb
		FROM ".THIS_TABLE."linkslink
	");
	while ($row=$vbulletin->db->fetch_array($asb)) {
		$linkurl = $row['linkurl'];
		$linkfile = $row['linkfile'];
		$linkimg = $row['linkimg'];
		$linkimgthumb = $row['linkimgthumb'];
		$urlInfo = ldm_parse_url($linkurl);
		$dfname   = ($linkfile ? $linkfile : basename($urlInfo['path']));
		$type	  = strtolower(file_extension($dfname));
		if ($type) {
			$ldmft[$type]['count']++;
			$ldmft[$type]['size'] += $row['linksize'];
			if ($row['linkstatus']==$LINK_UPLOAD) {
				$ldmft[$type]['uploads'] ++;
				$ldmft[$type]['uploadsize'] += $row['linksize'];
			}
		}
	    if ($linkurl and isset($files[$linkurl])) {
	        $files[$linkurl] += 1;
	    }
	    if ($linkimg and isset($files[$linkimg])) {
	        $files[$linkimg] += 1;
	    }
	    if ($linkimgthumb and isset($files[$linkimgthumb])) {
	        $files[$linkimgthumb] += 1;
	    }
	}
	ksort($ldmft);

// Scan the contents of the entities table
    $asb = $vbulletin->db->query_read("
	    SELECT entityvalue, entitytype
		FROM ".THIS_TABLE."linksentities
		WHERE entitytype IN (" .
		ENTITY_TYPE_URL . "," . ENTITY_TYPE_MEDIA . "," . ENTITY_TYPE_UPLOAD . "," .
        ENTITY_TYPE_MEDIAUPLOAD . "," . ENTITY_TYPE_IMAGE . "," . ENTITY_TYPE_IMAGEUPLOAD .
        ")
	");
    while ($row=$vbulletin->db->fetch_array($asb)) {
    	$entityvalue = $row['entityvalue'];
    	if ($entityvalue and isset($files[$entityvalue])) {
	        $files[$entityvalue] += 1;
	    }
	}

    $orphanfiles = 0;
    $uploadfiles = 0;
    foreach ($files as $thisfile=>$thiscount) {
        $uploadfiles++;
        if ($thiscount==0 and preg_match(":\d{18}\.[a-z0-9]+$:i", $thisfile)) {
            $orphanfiles ++;
        }
    }

	$players = "";
	$mimevalid = 1;
	$alt = 1;

	foreach ($ldmft as $type=>$thisldmft) {
		$filecount = $thisldmft['count'];

		if (isset($ldm_mimetype_cache[$type]['mimetype'])) {
			$mimetype = implode(',', $ldm_mimetype_cache[$type]['mimetype']);
		}
		else {
			$mimetype = $vbphrase['ll_admin_handle_link'];
		}

		$mimecount = $filecount;
		$mimesize = ldm_format_bytes($thisldmft['size'], 1);
		$mimeimage = "";

		if (!$thisldmft['uploads']) {
		    $thisldmft['uploads'] = 0;
		}
		$mimeupload = $thisldmft['uploads'] .'/' . ldm_format_bytes($thisldmft['uploadsize'], 0);
		eval("\$filecounts .= \"".fetch_template('links_admin_onemimetype')."\";");

		if (isset($myft[$type])) {
			$myft[$type]['count'] = $filecount;
			unset($ldmft[$type]);
		}
		else {
			if (isset($mygaps[$type])) {
				$mygaps[$type]['count'] = $filecount;
				unset($ldmft[$type]);
			}
			$mydls[$type]['count'] = $filecount;
		}
	}

	$alt = 1;
	$mimetypeinfo = "";
	foreach ($myft as $type=>$mime) {
		$mimetype = "";
		if (isset($ldm_mimetype_cache[$type]['mimetype'])) {
			$mimetype = implode(',', $ldm_mimetype_cache[$type]['mimetype']);
		}
		$players = "";
		if (is_array($mime['media'])) {
			$ply = array();
			foreach ($mime['media'] as $thisplayer) {
				$ply[$thisplayer['name']] = -$thisplayer['priority'];
			}
			asort($ply);
			foreach ($ply as $k=>$p) {
				$p = -$p;
				$players .= ($players ? '<br />' : '').$k.' ('.$p.')';
			}
		}
		$mimevalid = preg_match("/Content-type:/i", $mimetype);
		$mimecount = $mime['count'];
		$mimeupload = $mime['upload'];
		$mimeimage = $mime['image'];
		$mimesize = ldm_format_bytes($mime['size'], 0);
		eval("\$mimetypeinfo .= \"".fetch_template('links_admin_onemimetype')."\";");
	}

	$mimetypegaps = "";
	foreach ($mygaps as $type=>$mime) {
		$mimetype = "";
		$players = "";
		if (is_array($mime['media'])) {
			$ply = array();
			foreach ($mime['media'] as $thisplayer) {
				$ply[$thisplayer['name']] = -$thisplayer['priority'];
			}
			asort($ply);
			foreach ($ply as $k=>$p) {
				$p = -$p;
				$players .= ($players ? '<br />' : '').$k.' ('.$p.')';
			}
		}
		$mimecount = $mime[count];
		$mimeupload = "";
		$mimeimage = $mime['image'];
		$mimesize = "";
		eval("\$mimetypegaps .= \"".fetch_template('links_admin_onemimetype')."\";");
	}

	unset($mygaps);
	unset($myft);

}

/* ===========================================================================*/
// Follow-up action
/* ===========================================================================*/

if ($this_action == "doadmin" and isset($_REQUEST["dofiletypes"])) {

	$vbulletin->input->clean_array_gpc('r', array(
		'deleteorphans' => TYPE_INT,
	));

	$url  = ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl'].
	    "action=admin&amp;set=filetypes";

	if ($vbulletin->GPC['deleteorphans']==1) {

// Gather list of files in upload and thumbs directories
        $files = array();
        require_once(DIR . '/includes/local_links_misc.php');
        $filetypes = array_keys($vbulletin->attachmentcache);

        foreach (array('upload_dir', 'thumbs_dir', ) as $key) {
            if ($links_defaults[$key]) {
        	    ldm_read_directory($links_defaults[$key], $filetypes, $d_list, $f_list, $skipped, 10);
	            foreach ($f_list as $thisfile=>$thisval) {
	                $files[ldm_make_filename($links_defaults[$key], $thisfile)] = 0;
	            }
	        }
	    }

// Scan the contents of the entries table
    	$asb = $vbulletin->db->query_read("
	    	SELECT linkurl, linkimg, linkimgthumb
		    FROM ".THIS_TABLE."linkslink
	    ");
    	while ($row=$vbulletin->db->fetch_array($asb)) {
    		$linkurl = $row['linkurl'];
    		$linkimg = $row['linkimg'];
	    	$linkimgthumb = $row['linkimgthumb'];
    	    if ($linkurl and isset($files[$linkurl])) {
	            $files[$linkurl] += 1;
	        }
    	    if ($linkimg and isset($files[$linkimg])) {
	            $files[$linkimg] += 1;
	        }
	        if ($linkimgthumb and isset($files[$linkimgthumb])) {
	            $files[$linkimgthumb] += 1;
	        }
	    }

// Scan the contents of the entities table
    	$asb = $vbulletin->db->query_read("
	    	SELECT entityvalue, entitytype
		    FROM ".THIS_TABLE."linksentities
		    WHERE entitytype IN (" .
		    ENTITY_TYPE_URL . "," . ENTITY_TYPE_MEDIA . "," . ENTITY_TYPE_UPLOAD . "," .
            ENTITY_TYPE_MEDIAUPLOAD . "," . ENTITY_TYPE_IMAGE . "," . ENTITY_TYPE_IMAGEUPLOAD .
            ")
	    ");
    	while ($row=$vbulletin->db->fetch_array($asb)) {
    		$entityvalue = $row['entityvalue'];
    	    if ($entityvalue and isset($files[$entityvalue])) {
	            $files[$entityvalue] += 1;
	        }
	    }

        foreach ($files as $thisfile=>$thiscount) {
            if ($thiscount==0 and preg_match(":\d{18}\.[a-z0-9]+$:i", $thisfile)) {
                $fullfile = ldm_get_local_filename($thisfile);
        		@unlink($fullfile);
            }
        }
	}

	eval(print_standard_redirect($vbphrase['ll_deleted'],0));
	exit;

}

?>