<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

if (!isset($links_permissions["can_admin_links"]) or !$links_permissions["can_admin_links"]) {
	print_no_permission();
	exit;
}

require_once(DIR . '/includes/local_links_entities.php');

/* ===========================================================================*/
// Manage entities
/* ===========================================================================*/

if ($this_action == "admin" and $adminset == "entities") {

	$navbits[""] = $vbphrase['ll_menu_adments'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$entitybits = $newentitybits = "";
	$entity_definitions = unserialize($ldm_master_settings['entity_definitions'][-1]['setting']);

	$show['entitybits'] = $show['sysentitybits'] = $show['sysentitybits'] = 0;

	$ENTITY_TYPE_YESNO = ENTITY_TYPE_YESNO;
	$ENTITY_TYPE_TEXT = ENTITY_TYPE_TEXT;
	$ENTITY_TYPE_URL = ENTITY_TYPE_URL;
	$ENTITY_TYPE_MEDIA = ENTITY_TYPE_MEDIA;
	$ENTITY_TYPE_HIDDEN = ENTITY_TYPE_HIDDEN;
	$ENTITY_TYPE_UPLOAD = ENTITY_TYPE_UPLOAD;
	$ENTITY_TYPE_MEDIAUPLOAD = ENTITY_TYPE_MEDIAUPLOAD;
	$ENTITY_TYPE_IMAGE = ENTITY_TYPE_IMAGE;
	$ENTITY_TYPE_IMAGEUPLOAD = ENTITY_TYPE_IMAGEUPLOAD;

	$display_entities = $ldm_master_settings['display_entities'];
	unset($display_entities[-1]);
	$configs = array();
	if (count($display_entities)) {
		foreach (array_keys($display_entities) as $ts) {
			$configs[] = "<a href='".$LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=editcat&amp;catid=".
				$ts."' title='".$vbphrase['ll_editcat'].
				' '.$linkscat[$ts]['catname_clean']."' target='_blank'>" .$ts. "</a>";
		}
		$display_entities_set = construct_phrase($vbphrase['ll_admin_can_customise'],implode(', ', $configs)).
					'<br /><input type="checkbox" name="display_entities_revert" value="1" /> '.
					$vbphrase['ll_revert_cats'];
	}
	else {
		$display_entities_set = construct_phrase($vbphrase['ll_admin_can_customise'], $vbphrase['ll_none']);
	}

// Read the entity data table
	$query = "
		SELECT entityname, COUNT(linkid) AS entitycount, entitygroup, entitytype
		FROM ". THIS_TABLE . "linksentities
		GROUP BY entityname
		";
	$asb = $vbulletin->db->query_read($query);
	$entities = array();
	while ($rec=$vbulletin->db->fetch_array($asb)) {
		$entities[$rec['entityname']]['entitygroup'] = $rec['entitygroup'];
		$entities[$rec['entityname']]['entitycount'] = $rec['entitycount'];
		$entities[$rec['entityname']]['entitytype'] = $rec['entitytype'];
	}

	ldm_check_entity_consistency($entities, $entity_definitions);

	foreach ($entity_definitions['groups'] as $entitygroupid=>$thisgroup) {

		$entity_group = $thisgroup['entitygroup'];
		$entity_group_order = $thisgroup['entitygrouporder'];
		$entity_group_collapse = $thisgroup['entitygroupcollapse'];
		$entity_group_hidden = $thisgroup['entitygrouphidden'];
		$entity_state = -1; // insert break
		eval('$entitybits .= "' . fetch_template('links_admin_oneentity') . '";');

		$entitybit = array();
		foreach ($entity_definitions['entities'] as $thisid=>$thisentity) {
			if ($thisentity['entitygroup']!=$entity_group) {
				continue;
			}
			$show['entitybits'] = 1;
			$entity_name = $thisentity['entityname'];
			$entity_type = $thisentity['entitytype'];
			$entity_display = $thisentity['displayorder'];
			$entity_required = $thisentity['required'];
			$entity_state = 0; // Fully kosher
			$entity_seq = $thisid;
			$entity_count = $thisentity['entitycount'];
			eval('$entitybit[$entity_display] .= "' . fetch_template('links_admin_oneentity') . '";');
		}
		if (count($entitybit)) {
			ksort($entitybit);
			$entitybits .= implode('', $entitybit);
		}
	}

// Give user the option to create some new entities

	$entity_group = $vbphrase['ll_entities_new'];
	$entity_group_order = $thisgroup['entitygrouporder'];
	$entity_state = -2; // insert break
	eval('$newentitybits .= "' . fetch_template('links_admin_oneentity') . '";');

	$entity_name = "";
	$entity_type = $ENTITY_TYPE_TEXT;
	$entity_count = 0;
	$entity_new = 1;
	$entity_state = 2; // New entity
	$entity_group = '';
	for ($entity_display=1; $entity_display<=3; $entity_display++) {
		$entity_seq = $entity_display;
		$show['newentitybits'] = 1;
		eval('$newentitybits .= "' . fetch_template('links_admin_oneentity') . '";');
	}

// Highlight any category overrides
	$entity_overrides = array_keys($ldm_master_settings['entity_definitions']);

	$configs = array();
	if (count($display_entities)) {
		foreach (array_keys($display_entities) as $ts) {
			$configs[] = "<a href='".$LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=editcat&amp;catid=".
				$ts."' title='".$vbphrase['ll_editcat'].
				' '.$linkscat[$ts]['catname_clean']."' target='_blank'>" .$ts. "</a>";
		}
		$display_entities_set = construct_phrase($vbphrase['ll_admin_can_customise'],implode(', ', $configs)).
					'<br /><input type="checkbox" name="display_entities_revert" value="1" /> '.
					$vbphrase['ll_revert_cats'];
	}
	else {
		$display_entities_set = construct_phrase($vbphrase['ll_admin_can_customise'], $vbphrase['ll_none']);
	}

// Warn admin in case of any problems
    $entityadminmessage = "";
    foreach ($ldm_master_settings['allow_add_multi'] as $thiscatid=>$thisvalue) {
        if ($thisvalue['setting']>1) {
            $entityadminmessage = $vbphrase['ll_admin_entities_warning_addmulti'];
            break;
        }
    }

	$configs = array();
	if (count($entity_overrides)>1) {
		foreach ($entity_overrides as $thisent=>$thiscat) {
			if ($thiscat>0) {
				$configs[] = "<a href='".$LINKS_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=editcat&amp;catid=".
					$thiscat."' title='".$vbphrase['ll_editcat'].
					' '.$linkscat[$ts]['catname_clean']."' target='_blank'>" .$thiscat. "</a>";
			}
		}
		$overrideentityrevt = construct_phrase($vbphrase['ll_admin_can_customise'],implode(', ', $configs)).
					'<br /><input type="checkbox" name="entity_groups_revert" value="1" /> '.
					$vbphrase['ll_revert_cats'];
	}
	else {
		$overrideentityrevt = construct_phrase($vbphrase['ll_admin_can_customise'], $vbphrase['ll_none']);
	}

}

/* ===========================================================================*/
// Follow-up action: Do Entities
/* ===========================================================================*/

if ($this_action == "doadmin" and isset($_REQUEST["doentities"])) {

	$url  = ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."action=admin&amp;set=entities";

	$vbulletin->input->clean_array_gpc('p', array(
		'display_entities' => TYPE_INT,
		'display_entities_revert' => TYPE_INT,
		'entity' => TYPE_ARRAY_ARRAY,
		'entitygroup' => TYPE_ARRAY_ARRAY,
		'entity_groups_revert' => TYPE_INT,
		'newentity' => TYPE_ARRAY_ARRAY,
	));

	$entity_group_updates = $vbulletin->GPC['entitygroup'];
	$entity_updates = $vbulletin->GPC['entity'];
	$entity_new = $vbulletin->GPC['newentity'];

	$entity_definitions = unserialize(ldm_lookup_setting(-1, 'entity_definitions'));
	$next_entityid = count($entity_definitions['entities']) ? max(array_keys($entity_definitions['entities']))+1 : 1;

	$new_entity_definitions = array();
	$next_new_entity_definitions = 1;

	$is_error = 0;

	foreach ($entity_updates as $thisentity) {
		$thisid = $thisentity['entityseq'];

		if ($thisentity['entitydelete'] or $thisentity['entityvaluesdelete']) {
			$query = "
				DELETE FROM ".THIS_TABLE."linksentities
				WHERE entityname = '".$vbulletin->db->escape_string($entity_definitions['entities'][$thisid]['entityname'])."'
				";
			$vbulletin->db->query_write($query);
		}

		if ($thisentity['entitydelete']) {
			unset($entity_definitions['entities'][$thisid]);
		}

	}

	foreach ($entity_updates as $thisentity) {
		if ($thisentity['entitydelete']) {
			continue;
		}
		$thisid = $thisentity['entityseq'];
		if ($thisentity['entityrename']) {
			if (!$thisentity['entitygroup']) {
				$is_error += 1;
			}
			foreach ($entity_definitions['entities'] as $oldid=>$oldentity) {
				if ($oldid!=$thisid and $thisentity['entityrename']==$oldentity['entityname']) {
					$is_error += 1; // Cant have multiple entries wih the same name
					break;
				}
			}
		}
	}

	foreach ($entity_new as $thisentity) {
		if ($thisentity['entityname']) {
			if (!$thisentity['entitygroup']) {
				$is_error += 1;
			}
			foreach ($entity_definitions['entities'] as $oldentity) {
				if ($thisentity['entityname']==$oldentity['entityname']) {
					$is_error += 1;
					break;
				}
			}
		}
	}

	if ($is_error>0) {
		eval(standard_error($vbphrase['ll_error_invalidentities'].$vbphrase['ll_goback']));
		exit;
	}

	foreach ($entity_updates as $thisentity) {
		if ($thisentity['entitydelete']) {
			continue;
		}

		$thisid = $thisentity['entityseq'];
		if ($thisentity['entityrename']) {
			if ($entity_definitions['entities'][$thisid]['entityname']!=$thisentity['entityrename'] or
				$entity_definitions['entities'][$thisid]['entitygroup']!=$thisentity['entitygroup'] or
				$entity_definitions['entities'][$thisid]['entitytype']!=$thisentity['entitytype'] ) {
				$query = "
					UPDATE ".THIS_TABLE."linksentities
					SET
						entityname = '".$vbulletin->db->escape_string($thisentity['entityrename'])."',
						entitygroup = '".$vbulletin->db->escape_string($thisentity['entitygroup'])."',
						entitytype = '".intval($thisentity['entitytype'])."'
						WHERE entityname = '".$vbulletin->db->escape_string($entity_definitions['entities'][$thisid]['entityname'])."'
					";
				$vbulletin->db->query_write($query);
			}
			$entity_definitions['entities'][$thisid]['entityname'] = $thisentity['entityrename'];
			$entity_definitions['entities'][$thisid]['entitygroup'] = $thisentity['entitygroup'];
			$entity_definitions['entities'][$thisid]['entitytype'] = $thisentity['entitytype'];
			$entity_definitions['entities'][$thisid]['displayorder'] = $thisentity['displayorder'];
			$entity_definitions['entities'][$thisid]['required'] = intval($thisentity['required']);
		}
	}

	foreach ($entity_new as $thisentity) {
		if ($thisentity['entityname']) {
			$entity_definitions['entities'][] = array(
				'entityname'=>$thisentity['entityname'],
				'entitytype'=>intval($thisentity['entitytype']),
				'entitygroup'=>$thisentity['entitygroup'],
				'displayorder'=>$thisentity['displayorder'],
				'required'=>intval($thisentity['required']),
			);
		}
	}

	uasort($entity_definitions['entities'], 'ldm_entity_sort');

	$entity_definitions['groups'] = $entity_group_updates;
	foreach ($entity_definitions['entities'] as $thisentity) {
		$found = 0;
		foreach ($entity_definitions['groups'] as $thisgroup) {
			if ($thisentity['entitygroup']==$thisgroup['entitygroup']) {
				$found = 1;
				break;
			}
		}
		if (!$found) {
			if (count($entity_definitions['groups'])) {
				$nextkey = max(0, max(array_keys($entity_definitions['groups']))+1);
			}
			else {
				$nextkey = 1;
			}
			$entity_definitions['groups'][$nextkey] = array(
				'entitygroupid' => $nextkey,
				'entitygroup' => $thisentity['entitygroup'],
				'entitygrouporder' => ($thisentity['entitygroup']==ENTITY_ADMIN_GROUP ? -1 : 1),
				'entitycount' => 0,
				);
		}
	}

	uasort($entity_definitions['groups'], 'ldm_entitygroup_sort');

	ldm_update_setting(-1, 'display_entities', $vbulletin->GPC['display_entities']);
	ldm_update_setting(-1, 'entity_definitions', serialize($entity_definitions));

	if ($vbulletin->GPC['entity_groups_revert']==1) {
		$query = "
			DELETE FROM ".THIS_TABLE."linksadmin
			WHERE settingname='entity_definitions'
			AND catid>0
		";
		$vbulletin->db->query_write($query);
	}

	if ($vbulletin->GPC['display_entities_revert']==1) {
		$query = "
			DELETE FROM ".THIS_TABLE."linksadmin
			WHERE settingname='display_entities'
			AND catid>0
		";
		$vbulletin->db->query_write($query);
	}

	ldm_force_entity_consistency();

	eval(print_standard_redirect($vbphrase['ll_accepted'],0));
	exit;

}

?>