<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

if (!isset($links_permissions["can_admin_links"]) or !$links_permissions["can_admin_links"]) {
	print_no_permission();
	exit;
}

function ldm_admincategorytree($parent, $expand) {
	global $linkscat, $adminset, $pagenumber, $ldm_icon_cache;
	global $vbulletin, $vbphrase, $stylevar;
	global $forum;
	global $ADMIN_SCRIPT, $LINKS_SCRIPT;

	$tree  = array();
	$expanded = "";
	if (count($expand)) {
		$expanded = "&amp;expand=".implode(',', $expand);
	}

	if ($parent==-1) {
		ldm_build_cat_children();
	}

	foreach ($linkscat[$parent]['childlist'] as $thischild) {
		$thiscat = $linkscat[$thischild];
		if ($thiscat['parentid'] == $parent) {

			if (count($thiscat['childlist'])) {
				$state = in_array($thiscat['catid'], $expand) ? 1 : -1;
			}
			else {
				$state = 0;
			}

			$depth = preg_replace("/[^,]/", "", $thiscat['parentlist']);
			$depth = preg_replace("/,/", "-", $depth);
			$depth = $depth ? $depth." " : $depth;
			$thisforum = (int) $thiscat['catforum'];
			if ($forum[$thisforum]) {
				$hasforum = $forum[$thisforum];
			}
			else {
				$hasforum = 0;
			}
			$catsync_err = 0;
			if ($thiscat['catsyncdir']) {
				$fulldir = ldm_cleanto_fopen($thiscat['catsyncdir']);
				if ($dir_handle = @opendir($fulldir)) {
					closedir($dir_handle);
				}
				else {
					$catsync_err = 1;
				}
			}
			eval('$tree[] = "' . fetch_template('links_admin_category') . '";');
			if ($state>0) {
				$tree = array_merge($tree, ldm_admincategorytree($thiscat['catid'], $expand));
			}
		}
	}

	return $tree;
}

/* ===========================================================================*/
// Category Mass Edits
/* ===========================================================================*/

if ($this_action == "admin" and $adminset == "categories") {

	$vbulletin->input->clean_array_gpc('r', array(
		'expand' => TYPE_STR,
		'toggle' => TYPE_INT,
	));

	$expand = array();
	if ($vbulletin->GPC_exists['expand']) {
		$expand = explode(',', $vbulletin->GPC['expand']);
		foreach ($expand as $k=>$v) {
			if (!ldm_catid_is_valid($expand[$k])) {
				unset($expand[$k]);
			}
		}
	}

	if ($vbulletin->GPC_exists['toggle']) {
		$toggle = $vbulletin->GPC['toggle'];
		$toggle_set = array_search($toggle, $expand);
		if (FALSE !== $toggle_set) {
			unset($expand[$toggle_set]);
		}
		else {
			$expand[] = $toggle;
		}
	}
	$expanded = implode(',', $expand);

	$vbulletin->url = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."set=categories";
	if (count($expand)) {
		$vbulletin->url .= "&amp;expand=".$expanded;
	}
	$catscript = $vbulletin->url;

	$navbits[""] = $vbphrase['ll_menu_admcats'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$errcat = 0;
	$numcat = 0;
	foreach ($linkscat as $catid=>$thiscat) {
		$numcat ++;
		if ($linkscat[$catid]['parentid'] == $BASE_CAT) continue;
		if ($linkscat[$catid]['parentid'] > 0 and isset($linkscat[$linkscat[$catid]['parentid']])) continue;
		$errcat += 1;
	}
	ldm_fix_cat_parentlist(); // just in case

	$ncat = 0;
	$cattree = ldm_admincategorytree(-1, $expand);

	$start = ($pagenumber-1)*$perpage;
	$end = $start+$perpage-1;
	$k = $start;
	$linkstats['catlist'] = '';
	while ($k<=$end) {
		$linkstats['catlist'] .= $cattree[$k];
		$k++;
	}
	$pagenav = construct_page_nav($pagenumber, $perpage, count($cattree), $catscript, "&amp;pp=$perpage");

// moved to permissions page...
//	require_once(DIR . '/includes/adminfunctions_forums.php');
//	ldm_get_adminforumperms();

}


/* ===========================================================================*/
// Follow-up action: Do (Mass Edit) Categories
/* ===========================================================================*/

if ($this_action == "doadmin" and isset($_REQUEST["docategories"])) {

	$vbulletin->input->clean_array_gpc('p', array(
		'allpages' => TYPE_INT,
		'catid_p' => TYPE_ARRAY_INT,
		'confirm' => TYPE_INT,
		'disp_p' => TYPE_ARRAY_INT,
		'docategories' => TYPE_STR,
		'expand' => TYPE_STR,
		'force_permissions' => TYPE_INT,
		'pforum' => TYPE_INT,
		'set' => TYPE_STR,
	));

    require_once(DIR . '/includes/local_links_bitcache.php');

	$expand = $vbulletin->GPC_exists['expand'] ? $vbulletin->GPC['expand'] : "";
	$allpages = $vbulletin->GPC_exists['allpages'] ? $vbulletin->GPC['allpages'] : "";

	$vbulletin->url = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."set=".$vbulletin->GPC['set'].($expand ? "&expand=".$expand : "");

	$to_process = array(0);

	if ($allpages) {
		foreach ($linkscat as $thiscat) {
			if ($thiscat['catid']) {
				$to_process[] = $thiscat['catid'];
			}
		}
	}
	else {
		foreach ($linkscat as $thiscat) {
			if (isset($vbulletin->GPC['catid_p'][$thiscat['catid']])) {
				$to_process[] = $thiscat['catid'];
			}
		}
	}

	$action = $vbulletin->GPC['docategories'];
	switch ($action) {

	case 'close':
		$to_close = implode(',', $to_process);
		$vbulletin->db->query_write("
			UPDATE ".THIS_TABLE."linkscat SET
			catclosed=1
			WHERE catid IN (".$to_close.")
			");
		ldm_datastore_markdirty('ldm_cats');
		break;

	case 'open':
		$to_open = implode(',', $to_process);
		$vbulletin->db->query_write("
			UPDATE ".THIS_TABLE."linkscat SET
			catclosed=0
			WHERE catid IN (".$to_open.")
			");
		ldm_datastore_markdirty('ldm_cats');
		break;

	case 'desync':
		$to_desync = implode(',', $to_process);
		$vbulletin->db->query_write("
			UPDATE ".THIS_TABLE."linkscat SET
			catsyncdir=''
			WHERE catid IN (".$to_desync.")
			");
		ldm_datastore_markdirty('ldm_cats');
		break;

	case 'displayorder':
		foreach ($vbulletin->GPC['disp_p'] as $this_cat=>$this_display) {
			if (isset($linkscat[$this_cat]) and $linkscat[$this_cat]['displayorder']!=$this_display) {
				$vbulletin->db->query_write("
					UPDATE ".THIS_TABLE."linkscat SET
					displayorder='".$this_display."'
					WHERE catid=".$this_cat."
					");
			}
		}
        ldm_clear_bitcache();
		ldm_datastore_markdirty('ldm_cats');
		break;

	case 'forum':
		$to_forum = implode(',', $to_process);
		$new_forum = $vbulletin->GPC['pforum'];
		if (!ldm_forumid_is_valid($new_forum)) {
			break;
		}
		if ($vbulletin->GPC['force_permissions']==1) {
			$query = "
				SELECT
				link.linkid AS linkid, ltoc.catid AS linkcatid
				FROM ".THIS_TABLE."linkslink AS link
				LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
				ON link.linkid = ltoc.linkid
				WHERE ltoc.catid IN (".$to_forum.")
				";
			$link_forum = array(0);
			$asb = $vbulletin->db->query_read($query);
			while ($row=$vbulletin->db->fetch_array($asb)) {
				$link_forum[] = $row['linkid'];
			}
			$vbulletin->db->query_write("
				UPDATE ".THIS_TABLE."linkslink SET
				linkforum='".$new_forum."'
				WHERE linkid IN (".implode(',', $link_forum).")
				");
			unset($link_forum);
		}
		$vbulletin->db->query_write("
			UPDATE ".THIS_TABLE."linkscat SET
			catforum='".$new_forum."'
			WHERE catid IN (".$to_forum.")
			");
        ldm_clear_bitcache();
		ldm_datastore_markdirty('ldm_cats');
		break;

	case 'empty':
	case 'delete':
		switch ($vbulletin->GPC['confirm']) {
		case 0:
			$hidden = "";
			$cats = array();
			$count = 0;
			foreach ($vbulletin->GPC['catid_p'] as $catid_p=>$catid_v) {
				$hidden .= '<input type="hidden" name="catid_p['.$catid_p.']" value="'.$catid_v.'"> ';
				if (isset($linkscat[$catid_p])) {
					$cats[] = $linkscat[$catid_p]['catname_clean'].' ('.$catid_p.')';
					$count++;
				}
			}
			if ($count) {
				$confirm = construct_phrase($vbphrase['ll_confirm_category'], $action, implode(', ',$cats));
				eval("\$output  = \"".fetch_template('links_admin_category_confirm')."\";");
				print_output($output);
			}
			break;

		case 1:
        	require_once(DIR . '/includes/local_links_misc.php');
			if ($action=='delete') {
				ldm_empty_category($to_process, 1);
				ldm_delete_category($to_process);
			}
			else {
				ldm_empty_category($to_process, 0);
			}
			ldm_fix_cat_count();
			break;

		default:
        	eval(print_standard_redirect($vbphrase['ll_cancelled'],0));
        	exit;

		}
        ldm_clear_bitcache();
		break;

	}

	eval(print_standard_redirect($vbphrase['ll_settingsupdated'],0));

}

?>