<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

if (!isset($links_permissions["can_admin_links"]) or !$links_permissions["can_admin_links"]) {
	print_no_permission();
	exit;
}

/* ===========================================================================*/
// Main command function
/* ===========================================================================*/

if ($this_action == "admin" and $adminset == "bandwidth") {

	$navbits[""] = $vbphrase['ll_menu_admband'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');

	$admin_settings = $vbulletin->db->query_first("
		SELECT *
		FROM ".THIS_TABLE."linksadmin
		WHERE settingname='bandwidth_limit'
		LIMIT 1
	");

	if ($admin_settings['setting']) {
		$bandwidth = unserialize($admin_settings['setting']);
	}

	cache_LDMusergroup();

	foreach ($ldm_usergroup_cache as $usergroupid => $title) {
		if (!isset($bandwidth[$usergroupid]['bytesdaily']))  $bandwidth[$usergroupid]['bytesdaily']    = 0;
		if (!isset($bandwidth[$usergroupid]['bytesenable'])) $bandwidth[$usergroupid]['bytesenable']   = 0;
		if (!isset($bandwidth[$usergroupid]['filesdaily']))  $bandwidth[$usergroupid]['filesdaily']    = 0;
		if (!isset($bandwidth[$usergroupid]['filesenable'])) $bandwidth[$usergroupid]['filesenable']   = 0;
		if (!isset($bandwidth[$usergroupid]['carryforward'])) $bandwidth[$usergroupid]['carryforward'] = 1;
		if (!isset($bandwidth[$usergroupid]['uploadlimit'])) $bandwidth[$usergroupid]['uploadlimit'] = 0;
		$bandwidth[$usergroupid]['bytes'] = ldm_encode_bytes(ldm_decode_bytes($bandwidth[$usergroupid]['bytesdaily'])*$bandwidth[$usergroupid]['carryforward']);
		$bandwidth[$usergroupid]['files'] = $bandwidth[$usergroupid]['filesdaily'] * $bandwidth[$usergroupid]['carryforward'];
		$bandwidth[$usergroupid]['uploadlimit'] = ldm_encode_bytes(ldm_decode_bytes($bandwidth[$usergroupid]['uploadlimit']));
		if (!isset($bandwidth[$usergroupid]['uploadenable'])) $bandwidth[$usergroupid]['uploadenable']   = 0;
		$bandwidth[$usergroupid]['can_bypass_hit_recording'] = 0;
		foreach ($ldm_master_settings['can_bypass_hit_recording'] as $bypasscat=>$bypassperms) {
			if (in_array($usergroupid, explode(',', $bypassperms['setting']))) {
				$bandwidth[$usergroupid]['can_bypass_hit_recording'] = 1;
			}
		}
		$bandwidth[$usergroupid]['can_bypass_bandwidth_limits'] = 0;
		foreach ($ldm_master_settings['can_bypass_bandwidth_limits'] as $bypasscat=>$bypassperms) {
			if (in_array($usergroupid, explode(',', $bypassperms['setting']))) {
				$bandwidth[$usergroupid]['can_bypass_bandwidth_limits'] = 1;
			}
		}
	}

	$bandwidthbit_usergroup1 = "";
	foreach ($ldm_usergroup_cache as $usergroupid=>$title) {
		$band =& $bandwidth[$usergroupid];
		$fileschecked = ($band['filesenable'] ? 'checked="checked"' : '');
		$byteschecked = ($band['bytesenable'] ? 'checked="checked"' : '');
		$uploadchecked = ($band['uploadenable'] ? 'checked="checked"' : '');
		eval('$bandwidthbit_usergroup1 .= "' . fetch_template('links_admin_bandwidth_usergroup1') . '";');
	}

	$restrictbyipchecked = $bandwidth[-1]['restrictbyip'];
	eval('$bandwidthbit_other = "' . fetch_template('links_admin_bandwidth_other') . '";');

	$time0 = TIMENOW;
	$time24 = $time0 - 24*60*60;
	$usage = array();
	$totusage = array();
	$totusage['fileshittot'] = $totusage['fileshit'] = $totusage['byteshit'] =0;
	$query = "
		SELECT dl.username AS username, dl.userid AS userid, dl.bytes AS bytes, user.usergroupid AS usergroupid
		FROM " . THIS_TABLE . "linksdownloads AS dl
		LEFT JOIN " . TABLE_PREFIX . "user AS user
		ON dl.userid=user.userid
		WHERE dl.usertime>'".$time24."'
		AND dl.linkid>0
		ORDER BY username
		";
	$asb = $vbulletin->db->query_read($query);
	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		$totusage['fileshittot'] += 1;
		$usage[$myrow['userid']]['usergroupid'] = $myrow['usergroupid'];
		$usage[$myrow['userid']]['fileshittot'] += 1;
		if ($myrow['bytes']!=0) {
			$totusage['fileshit'] += 1;
			$usage[$myrow['userid']]['fileshit'] += 1;
		}
		$usage[$myrow['userid']]['byteshit'] += $myrow['bytes'];
		$usage[$myrow['userid']]['username'] = $myrow['username'];
		$totusage['byteshit'] += $myrow['bytes'];
	}

	$usagebit = "";
	foreach ($usage AS $userid=>$user) {
		$thisfiles = $user['fileshit'];
		$thisfilestot = $user['fileshittot'];
		$thisbytes = ldm_format_bytes($user['byteshit'], 1);
		$thisuser = unhtmlentities($user['username']);
		$thisusergroup = $user['usergroupid'];
		$thisuser_bytes = $vbphrase['ll_nolimit'];
		if ($bandwidth[$thisusergroup]['bytesenable']) {
			$thisuser_bytes = ldm_format_bytes(ldm_decode_bytes($bandwidth[$thisusergroup]['bytes']), 1);
		}
		$thisuser_files = $vbphrase['ll_nolimit'];
		if ($bandwidth[$thisusergroup]['filesenable']) {
			$thisuser_files = $bandwidth[$thisusergroup]['files'];
		}
		eval('$usagebit .= "' . fetch_template('links_admin_bandwidth_use') . '";');
	}

	$totusage['byteshit'] = ldm_format_bytes($totusage['byteshit'], 2);

	$uploadsbit = "";
	$query = "
		SELECT link.linkusername AS linkusername, link.linkuserid AS linkuserid, COUNT(link.linksize) AS linkuploads,
			SUM(link.linksize) AS linkuploadsize, user.usergroupid AS usergroupid
		FROM " . THIS_TABLE . "linkslink AS link
		LEFT JOIN " . TABLE_PREFIX . "user AS user
		ON link.linkuserid=user.userid
		WHERE linkstatus=".$LINK_UPLOAD."
		GROUP BY linkusername
		ORDER BY linkusername
		";
	$asb = $vbulletin->db->query_read($query);

	$totusage['uploadusers'] = 0;
	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		$totusage['uploadusers'] += 1;
		$totusage['filesupload'] += $myrow['linkuploads'];
		$totusage['bytesupload'] += $myrow['linkuploadsize'];
		$myrow['linkuploadsize'] = ldm_format_bytes($myrow['linkuploadsize'], 1);
		$thisuser_upload = $vbphrase['ll_nolimit'];
		if ($bandwidth[$thisusergroup]['uploadenable']) {
			$thisuser_upload = ldm_format_bytes(ldm_decode_bytes($bandwidth[$myrow['usergroupid']]['uploadlimit']), 1);
		}
		eval('$uploadsbit .= "' . fetch_template('links_admin_bandwidth_uploads') . '";');
	}

	$totusage['bytesupload'] = ldm_format_bytes($totusage['bytesupload'], 1);
	$totusage['bytesmaxspace'] = ($links_defaults['upload_maxspace'] ? ldm_format_bytes(ldm_decode_bytes($links_defaults['upload_maxspace'])) : $vbphrase[ll_band_nolimit]);
}


/* ===========================================================================*/
// Follow-up Action
/* ===========================================================================*/

if ($this_action == "doadmin" and isset($_REQUEST["dobandwidth"])) {

	$vbulletin->input->clean_array_gpc('p', array(
		'bytes' => TYPE_ARRAY_STR,
		'bytesenable' => TYPE_ARRAY_INT,
		'carryforward' => TYPE_ARRAY_INT,
		'files' => TYPE_ARRAY_STR,
		'filesenable' => TYPE_ARRAY_INT,
		'restrictbyip' => TYPE_BOOL,
		'resetuser' => TYPE_ARRAY_BOOL,
		'uploadlimit' => TYPE_ARRAY_STR,
		'uploadenable' => TYPE_ARRAY_INT,
	));

	$admin_settings = $vbulletin->db->query_first("
		SELECT *
		FROM ".THIS_TABLE."linksadmin
		WHERE settingname='bandwidth_limit'
		LIMIT 1
	");

	if ($admin_settings['setting']) {
		$bandwidth = unserialize($admin_settings['setting']);
	}

	cache_LDMusergroup();

	foreach ($ldm_usergroup_cache as $k=>$v) {

		if (!isset($bandwidth[$k]['carryforward'])) {
			$bandwidth[$k]['carryforward']	= 1;
		}
		if (isset($vbulletin->GPC['carryforward'][$k])) {
			$bandwidth[$k]['carryforward']	= max($vbulletin->GPC['carryforward'][$k], 1);
		}

		if (!isset($bandwidth[$k]['bytesdaily'])) {
			$bandwidth[$k]['bytesdaily']	= 0;
		}
		if (isset($vbulletin->GPC['bytes'][$k])) {
			$this_bytes = ldm_decode_bytes($vbulletin->GPC['bytes'][$k]);
			if (this_bytes<0) {
				eval(standard_error(construct_phrase($vbphrase['ll_error_decodebytes'], $v)));
			}
			$bandwidth[$k]['bytesdaily']	= max($this_bytes/$bandwidth[$k]['carryforward'], 0);
		}

		if (!isset($bandwidth[$k]['bytesenable'])) {
			$bandwidth[$k]['bytesenable']	= 0;
		}
		if (isset($vbulletin->GPC['bytesenable'][$k])) {
			$bandwidth[$k]['bytesenable']	= $vbulletin->GPC['bytesenable'][$k] ? 1 : 0;
		}
		else {
			$bandwidth[$k]['bytesenable'] = 0;
		}

		if (!isset($bandwidth[$k]['filesdaily'])) {
			$bandwidth[$k]['filesdaily']	= 0;
		}
		if (isset($vbulletin->GPC['files'][$k])) {
			$bandwidth[$k]['filesdaily']	= max($vbulletin->GPC['files'][$k]/$bandwidth[$k]['carryforward'], 0);
		}

		if (!isset($bandwidth[$k]['filesenable'])) {
			$bandwidth[$k]['filesenable']	= 0;
		}
		if (isset($vbulletin->GPC['filesenable'][$k])) {
			$bandwidth[$k]['filesenable']	= $vbulletin->GPC['filesenable'][$k] ? 1 : 0;
		}
		else {
			$bandwidth[$k]['filesenable'] = 0;
		}

		if (!isset($bandwidth[$k]['uploadlimit'])) {
			$bandwidth[$k]['uploadlimit']	= 0;
		}
		if (isset($vbulletin->GPC['uploadlimit'][$k])) {
			$this_bytes = ldm_decode_bytes($vbulletin->GPC['uploadlimit'][$k]);
			if (this_bytes<0) {
				eval(standard_error(construct_phrase($vbphrase['ll_error_decodebytes'], $v)));
			}
			$bandwidth[$k]['uploadlimit']	= max($this_bytes, 0);
		}

		if (!isset($bandwidth[$k]['uploadenable'])) {
			$bandwidth[$k]['uploadenable']	= 0;
		}
		if (isset($vbulletin->GPC['uploadenable'][$k])) {
			$bandwidth[$k]['uploadenable']	= $vbulletin->GPC['uploadenable'][$k] ? 1 : 0;
		}
		else {
			$bandwidth[$k]['uploadenable'] = 0;
		}

	}

// General restrictions
	$bandwidth[-1]['restrictbyip']= $vbulletin->GPC['restrictbyip'];

	$vbulletin->db->query_write("
		UPDATE ".THIS_TABLE."linksadmin
		SET
			setting='".$vbulletin->db->escape_string(serialize($bandwidth))."'
		WHERE settingname='bandwidth_limit'
		LIMIT 1
	");

	ldm_datastore_markdirty('ldm_admin');

// Individual user resets
	$toreset = array();
	foreach ($vbulletin->GPC['resetuser'] as $kuserid) {
		if ($kuserid) {
			$toreset[] = $kuserid;
		}
	}

	if (count($toreset)) {
		$time24 = TIMENOW - 24*60*60;
		$query = "
			DELETE FROM ".THIS_TABLE. "linksdownloads
			WHERE usertime>'".$time24."'
			AND userid IN (".implode(",", $toreset).")
			";
		$asb = $vbulletin->db->query_write($query);
	}

	$url = $ADMIN_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."set=".$adminset;
	eval(print_standard_redirect($vbphrase['ll_settingsupdated'],0));

	exit;

}

?>