<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. By all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

/* ===========================================================================*/
// Functions required primarily in the actions module
/* ===========================================================================*/

/**
* Insert/update a rating
*
* @param	int		entry id
*/

function ldm_insert_rate($linkid, $rateid, $linkvote, $message, $messageusername, $messageuserid) {
	global $vbulletin, $vbphrase, $links_defaults;

	$thisvote = max(0,$linkvote);
	if ($linkvote==-2) { // see if we've already got a rating registered
		unset($rec);
		$rec = $vbulletin->db->query_first("
			SELECT linkvote
			FROM ".THIS_TABLE."linksrate
			WHERE linkid='".$linkid."'
			AND linkuserid='".$messageuserid."'
			LIMIT 1
			");
		if (isset($rec['linkvote'])) {
			$thisvote = $rec['linkvote'];
		}
	}

	if ($rateid>0) {
		$vbulletin->db->query_write("
			UPDATE ".THIS_TABLE."linksrate
			SET
				lcomment = '".$vbulletin->db->escape_string($message)."',
				linkuserid='".$messageuserid."',
				linkusername='".$vbulletin->db->escape_string($messageusername)."'
			WHERE lrate = ".$rateid."
		");
	}
	else {
		$time = TIMENOW;
		$vbulletin->db->query_write("
			INSERT INTO ".THIS_TABLE."linksrate
			SET
				linkid='".$linkid."',
				linkuserid='".$messageuserid."',
				linkusername='".$vbulletin->db->escape_string($messageusername)."',
				linkvote='".intval($thisvote)."',
				lcomment='".$vbulletin->db->escape_string($message)."',
				ltime='".$time."'
		");
	}

	$vbulletin->db->query_write("
		UPDATE ".THIS_TABLE."linksrate
		SET
			linkvote='".intval($thisvote)."'
		WHERE linkid='".$linkid."'
		AND linkuserid='".$messageuserid."'
		"); // ensure consistency

	$rates = ldm_fix_rating_counts($linkid);

	if ($links_defaults['autocreate_active'] and
		$links_defaults['autocreate_sync_comments'] and
		$message and
		!$rateid) {

// Post a message if we already have an associated thread and the new message isn't blank

		$row = $vbulletin->db->query_first("
			SELECT *
			FROM ".THIS_TABLE."linkslink
			WHERE linkid=".$linkid."
			LIMIT 1
			");

		$forumid = ($links_defaults['autocreate_forum']>0 ? $links_defaults['autocreate_forum'] : $row['linkforum']);
		$linkdesc = $row['linkdesc'];
		$linkname = $row['linkname'];
		$linkimg = $row['linkimg'];

		$threadid = 0;
		if ($row['linkthread']>0) {
			$threadid = $row['linkthread'];
		}
// Legacy test - don't try too hard - use the last threadid, if any, in the description provided it is in the correct forum
		elseif ($row['linkthread']==0 and $forumid>0 and $links_defaults['autocreate_both_ways']) {
			if ($nmatches = preg_match_all("/\[thread=(\d+)\]/i", $row['linkdesc'], $match)) {
				$threadid = $match[1][$nmatches-1];
				$thisthread = $vbulletin->db->query_first("
					SELECT forumid
					FROM ".TABLE_PREFIX."thread
					WHERE threadid=".$threadid."
					LIMIT 1
					");
				if ($thisthread['forumid']==$forumid) {
					$vbulletin->db->query_write("
						UPDATE ".THIS_TABLE."linkslink
						SET linkthread = '".intval($threadid)."'
						WHERE linkid=".$linkid."
						");
				}
				else {
					$threadid = 0;
				}
			}
		}

		if ($threadid) {
			require_once(DIR . '/includes/local_links_forumsinterface.php');
			$gotolink = ldm_make_filename($vbulletin->options['bburl'], LINKS_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'linkid='.$linkid);
			$post_message = construct_phrase($vbphrase['ldm_post_addrating_body'], $message, $gotolink, $linkname);
			$dateadded = ldm_date($vbulletin->options['dateformat'], TIMENOW);
			$catname = $linkscat["$catid"]["catname_clean"];
			$post_title = construct_phrase($vbphrase['ldm_post_addrating_title'], $linkname, $catname, $dateadded);
			ldm_append_post(
				$post_title,
				$post_message,
				$thisvote,
				$forumid,
				$threadid,
				$messageusername,
				$messageuserid,
				$newpost);
		}

	}

	return $rates;

}

/**
* Correct the cached ratings information for an entry
*
* @param	int		entry id
*/

function ldm_fix_rating_counts($linkid) {
	global $vbulletin;

	$asb = $vbulletin->db->query_read("
		SELECT linkuserid, linkvote
		FROM ".THIS_TABLE."linksrate
		WHERE linkvote>0
		AND linkid=".intval($linkid)."
	");

	$rates = array();
// count only one vote per user
	while ($row = $vbulletin->db->fetch_array($asb)) {
		$rates[$row['linkid']][$row['linkuserid']] = $row['linkvote'];
	}

	$newrates = array('numcomment'=>0, 'numrate'=>0, 'totrate'=>0,);
	foreach ($rates as $thislinkid=>$theserates) {
		foreach ($theserates as $thisrate) {
			$newrates['numrate'] += 1;
			$newrates['totrate'] += $thisrate;
		}
	}
// count all the non-blank comments
	$asb = $vbulletin->db->query_read("
		SELECT linkid, COUNT(lcomment) AS numcomment
		FROM ".THIS_TABLE."linksrate
		WHERE lcomment!=''
		AND linkid=".intval($linkid)."
		GROUP BY linkid
	");
	while ($row = $vbulletin->db->fetch_array($asb)) {
		$newrates['numcomment'] = $row['numcomment'];
	}

	$query = "
		UPDATE ".THIS_TABLE."linkslink
		SET numcomment=".$newrates['numcomment'].", numrate=".$newrates['numrate'].", totrate=".$newrates['totrate']."
		WHERE linkid=".$linkid."
	";
	$asb = $vbulletin->db->query_write($query);
	$vbulletin->db->free_result($asb);

	return $newrates;

}

/**
* Notify users of outcome of moderation
*
* @param	int		entry id
* @param	int		category id
* @param	int		entry accepted/declined
*/

function ldm_notify_moderated($linkid, $catid, $accept) {
	global $vbulletin, $vbphrase;
	global $LINKS_SCRIPT;

	$asb = $vbulletin->db->query_read("
		SELECT	user.userid AS userid, user.username AS username,
				user.email AS email, user.options AS options,
				links.linkname AS linkname, links.linkurl AS linkurl
		FROM ".TABLE_PREFIX."user AS user
		LEFT JOIN ".THIS_TABLE."linkslink AS links
		ON user.userid = links.linkuserid
		WHERE links.linkid = '".$linkid."'
		");

	while ($myrow = $vbulletin->db->fetch_array($asb)) {
		if ($sent[$myrow['email']]) continue;
		if (!$myrow['email']) continue;
		if (!$myrow['options'] & $vbulletin->bf_misc_useroptions['adminemail']) continue;

		$subject = construct_phrase($vbphrase['ll_admin_entryaccepted_subject'], $vbulletin->options['bbtitle']);
		if ($accept) {
			$message = construct_phrase($vbphrase['ll_admin_entryaccepted_body'],
				$myrow['username'], $myrow['linkname'], $myrow['linkurl'],
				ldm_make_filename($vbulletin->options['bburl'],$LINKS_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'catid='.$catid.'&linkid='.$linkid)
				);
		}
		else {
			$message = construct_phrase($vbphrase['ll_admin_entrydeclined_body'],
				$myrow['username'], $myrow['linkname'], $myrow['linkurl']
			);
		}

		$message = preg_replace("/(\\n|\\\\n)/s", "\n", $message);

		($hook = vBulletinHook::fetch_hook('ldm_editlink_sendmoderatedemail')) ? eval($hook) : false;

		vbmail($myrow['email'], $subject, $message, true);
	}

}

/**
* Notify users who have downloaded an entry that the entry has changed
*
* @param	int		entry id
* @param	int		category id
*/

function ldm_notify_updated($linkid, $catid) {
	global $vbulletin, $vbphrase;
	global $LINKS_SCRIPT;

	$query = "
		SELECT linkid, linkname
		FROM ".THIS_TABLE."linkslink
		WHERE linkid = '".intval($linkid)."'
		LIMIT 1
		";
	$myrow = $vbulletin->db->query_first($query);
	$subject = construct_phrase($vbphrase['ll_admin_entryupdated_subject'], $vbulletin->options['bbtitle']);
	$message = construct_phrase($vbphrase['ll_admin_entryupdated_body'], $myrow['linkname'],
					ldm_make_filename($vbulletin->options['bburl'],$LINKS_SCRIPT.'.php?'.$vbulletin->session->vars['sessionurl'].'catid='.$catid.'&linkid='.$linkid)
					);
	$message = preg_replace("/(\\n|\\\\n)/s", "\n", $message);

	($hook = vBulletinHook::fetch_hook('ldm_editlink_sendupdatedemail')) ? eval($hook) : false;

	$sent = array();
	$query = "
		SELECT	user.userid AS userid, user.email AS email, user.options AS options, downloads.linkid AS linkid
		FROM ".TABLE_PREFIX."user AS user
		LEFT JOIN ".THIS_TABLE."linksdownloads AS downloads
		ON user.userid=downloads.userid
		WHERE downloads.linkid = '".intval($linkid)."'
		";
	$asb = $vbulletin->db->query_read($query);
	while ($myrow=$vbulletin->db->fetch_array($asb)) {
		if ($sent[$myrow['email']]) continue;
		if (!$myrow['email']) continue;
		if (!$myrow['options'] & $vbulletin->bf_misc_useroptions['adminemail']) continue;
		vbmail($myrow['email'], $subject, $message, true);
		$sent[$myrow['email']] = 1;
	}

}

/**
* Validate an upload FILE and if successful move it into user's upload directory
*
* @param	&arr	GPC array
* @param	&str	returns set to moved file location
* @param	str	    allowed filetypes
* @param	&str	returns set to error message if any
* @param	str		if set, subdirectory in which to store upload
* @return	bool	error status
*/

function ldm_process_upload(&$GPC, &$linkurl, $filetypes, &$errorstatus, $dir="") {
	global $links_defaults, $links_permissions, $ldm_mimetype_cache;
	global $LDM_environment;
	global $vbulletin, $vbphrase;

    require_once(DIR . '/includes/local_links_misc.php');
	require_once(DIR . '/includes/functions_file.php');
    require_once(DIR . '/includes/local_links_images.php');

	($hook = vBulletinHook::fetch_hook('ldm_upload_precheck')) ? eval($hook) : false;

	if (!$links_permissions['can_upload_files'] or !$links_defaults['upload_enabled']) {
		$errorstatus = $vbphrase['ll_error_upload_21']; // uploads prohibited
		return 0;
	}

	switch ($GPC['error']) {
	case 0:  break;
	case 1:  // upload too large (php.ini)
	case 2:  // upload too large (form)
	case 3:  // partial upload
	case 4:  // no upload
	case 6:  // missing temporary directory
	case 7:  // can't create temporary file
		$errorstatus = $vbphrase['ll_error_upload_'.$GPC['error']];
		return 0;
	default: // general failure
		$errorstatus = $vbphrase['ll_error_upload_99'];
		return 0;
	}

	if (!$GPC['name'] or !$GPC['tmp_name'] or !$GPC['size']) {
		$errorstatus = $vbphrase['ll_error_upload_4'];
		return 0;
	}

	cache_LDMmimetype();
	$type = file_extension($GPC['name']);

    $maxsize = ldm_max_allowed_upload($type, $filetypes);

	if (!$type or !$maxsize) {
		$errorstatus = construct_phrase($vbphrase['ll_error_upload_23'], $type); // invalid filetype
		return 0;
	}

	if ($maxsize<$GPC['size']) {
		$errorstatus = $vbphrase['ll_error_upload_24']; // upload too large
		return 0;
	}

	if (!is_uploaded_file($GPC['tmp_name'])) {
		$errorstatus = $vbphrase['ll_error_upload_25']; // someone's playing silly games
		return 0;
	}

	$userid = intval($vbulletin->userinfo['userid']);
	$path = ldm_make_filename($links_defaults['upload_dir'], ($dir ? $dir : implode('/', preg_split('//', $userid,  -1, PREG_SPLIT_NO_EMPTY))));

	$fullpath = ldm_get_local_filename($path);
	if (!ldm_create_directory($fullpath, $links_defaults['secure_nullindexfile'])) {
			$errorstatus = $vbphrase['ll_error_upload_26']; // can't create user directory
			return 0;
	}

	for ($k=0; $k<999; $k++) { // should never require more than one or two passes...
		$file = ldm_make_filename($path, rand(1000,9999).TIMENOW.rand(1000,9999).'.'.$type);
		$fullfile = ldm_get_local_filename($file);
		if (!file_exists($fullfile)) break;
	}

// useful if people want a different file naming convention for uploads
	($hook = vBulletinHook::fetch_hook('ldm_upload_filesave')) ? eval($hook) : false;

	if (file_exists($fullfile)) {
		$errorstatus = $vbphrase['ll_error_upload_27'];
		return 0;
	}

	if (!@move_uploaded_file($GPC['tmp_name'], $fullfile)) {
		$errorstatus = $vbphrase['ll_error_upload_27'];
		return 0;
	}
	@chmod($fullfile, 0644);

	$linkurl = $file;
	$errorstatus = "";
	return 1;
}

/**
* Check whether a string is likely to be a valid filename across all systems and fix if necessary
*
* @param	&str	string to test
* @param	int		if true, fix the string
* @return	int		0=ok, 1=fixed
*/

function ldm_fix_filename(&$filename, $fix=0) {
	$invalids = array("\\", "/", ":", "%", "$", "*", "|", "?", "\"", "<", ">");
	$fixed = 0;
	foreach ($invalids as $invalid) {
		if (strpos($filename, $invalid) !== FALSE) {
			$fixed = 1;
			if ($fix) {
				$filename = str_replace($invalid, "", $filename);
			}
		}
	}
	return $fixed;
}

?>