/*======================================================================*\
// Javascript functions used in LDM
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
\*======================================================================*/

/**
* Hide all 'object_N' except the k-th
*
* @param	string	Object prefix
* @param	int		Object to display
* @param	int		Total number of objects to scan
*/

function ldm_show(object, k, n) {
	for (var i=1; i <= n; i++) {
		obj = fetch_object(object+i);
		if (i==k) {
			obj.style.display = '';
		}
		else {
			obj.style.display = 'none';
		}
	}
}

/**
* Flip visibility of 'object'
*
* @param	string	Object
*/

function ldm_flip(object) {
	obj = document.getElementById(object);
	if (obj.style.display == 'none') {
		obj.style.display = ''
	}
	else {
		obj.style.display = 'none'
	}
}

/**
* Restrict textbox to maxlen characters
*
* @param	string	Field name
* @param	int		Maximum length of text
*/

function ldm_textLimit(field, maxlen) {
	if (field.value.length > maxlen) {
		field.value = field.value.substring(0, maxlen);
	}
}

/**
* Force field to contain only valid DOI characters
*
* @param	string	Field name
*/

function ldm_textDOI(field) {
	field.value = field.value.replace(/[^a-zA-Z0-9-_]+/g, "");
}

/**
* Create a popup window pointing to given url
*
* @param	string	URL
*/

function ldm_popup(URL) {
	window.open(URL, 'player', 'width=$links_defaults[musicbox_standalone_width],height=$links_defaults[musicbox_standalone_height],scrollbars=yes,toolbar=no,personalbar=no,location=no,directories=no,statusbar=no,menubar=no,status=no,resizable=yes,left=60,screenX=60,top=100,screenY=100');
}

/**
* Resize textbox to be given size
*
* @param	int		Rows
* @param	int		columns
* @param	string	Field id
*/

function ldm_resize_area(rows, cols, id) {
	var area = fetch_object(id);
	if (typeof area.orig_rows == 'undefined') {
		area.orig_rows = area.rows;
		area.orig_cols = area.cols;
	}

	var newrows = area.rows + rows;
	var newcols = area.cols + cols;

	if (newrows >= area.orig_rows && newcols >= area.orig_cols) {
		area.rows = newrows;
		area.cols = newcols;
	}

	return false;
}

/**
* Set height and width attributes for object id
*
* @param	int		Height
* @param	int		Width
* @param	string	Field id
*/

function ldm_size_style(height, width, id) {
	var myobj = fetch_object(id);
	myobj.style.height = height;
	myobj.style.width = width;
	return false;
}

/**
* Trap and disable enter key
*
*/

function ldm_noenter() {
	return !(window.event && window.event.keyCode == 13);
}

/**
* Set all fields within form object called X_revert to the current value of the form's allbox
*
* @param	string	Form object
*/

function ldm_toggle_all_revert(formobj)
{
	setto = formobj.allbox.checked;
	is_revert = "";
	for (var i =0; i < formobj.elements.length; i++)
	{
		var elm = formobj.elements[i];
		elm_re = new RegExp("^.+_revert$");
		is_revert = elm.name.replace(elm_re, 'revert');
		if (is_revert == "revert")
		{
			elm.checked = setto;
		}
	}
}

/**
* Set form field with given id to the inverse of the given settingId
*
* @param	string	Field to set
* @param	string	Field to read
*/

function ldm_flip_field(fieldid, settingid)
{
	setto = document.getElementById(settingid).checked;
	document.getElementById(fieldid).disabled = !setto;
}

/**
* When two values match, enable field with given settingid
*
* @param	?		Value 1
* @param	?		Value 2
* @param	string	Field id
*/

function ldm_enable_onequal(selectvalue, matchvalue, settingid)
{
	if (selectvalue == matchvalue)
	{
		settingid.disabled = false;
	}
	else {
		settingid.disabled = true;
	}
}

/**
* Trigger a form-based download
*
* @param	string	Linkid
* @param	string	Catid
*/

function ldm_downloadme(myform, linkid, catid) {
	var downloadform = document.getElementById(myform);
	downloadform.linkid.value = linkid;
	downloadform.catid.value = catid;
	downloadform.submit();
}


/**
* Post a message on the Firefox console
*
* @param	string	message
*/

function ldm_console_alert(msg) {
	try {
		console.debug(msg);
	} catch(e) {}
}

/**
* Return value of given form field
*
* @param	string	field
*/

function ldm_formfield_value(formField) {
	switch (formField.type) {
		case 'text':
		case 'textarea':
		case 'select-one':
		case 'hidden':
			if (formField.value)
				return formField.value;
			return false;
		case 'radio':
		case 'checkbox':
			if (formField.checked) {
				return formField.value;
			}
			return false;
		default:
			return false;
	}
}

/**
* Clear a form
*
* @param	string	form
*/

function ldm_clearform(form) {
	var els = form.elements;
	for (var i=0;i<els.length;i++) {
		switch (els[i].type) {
		case 'text':
		case 'textarea':
			els[i].value = ""
			break;
		case 'radio':
		case 'checkbox':
			els[i].checked = false;
			break;
		default:
			break;
		}
	}
}

/**
* Check a value and display another object or not according to whether value is blank
*
* @param	string	id to check
* @param	string	id to set
* @param	string	display mode if blank
* @param	string	display mode if not blank
*/

function ldm_show_onvalue(thisid, thatid, modeblank, modenotblank) {
	var val = document.getElementById(thisid).value;
	val = val.replace(/^\s+|\s+$/g,"");
	if (val.length==0) {
		document.getElementById(thatid).style.display = modeblank;
	}
	else {
		document.getElementById(thatid).style.display = modenotblank;
	}
}

/**
* Process a form and submit provided certain values are set
*
* @param	string	form
* @param	string	script to submit form to
* @param	string	action variable ('do=action')
* @param	string	repeat as necessary, form will not be submitted unless at least one of these fields is set
*/

function ldm_ajax_form() {
	ldm_update_Handler = new vB_AJAX_Handler(true);
	ldm_update_Handler .onreadystatechange(ldm_ajax_form_updater);

	var form = arguments[0];
	var script = arguments[1];
	var action = arguments[2];

	var sendthis = 'do='+action;
	var els = form.elements;

	var havevalues = 1;
	if (arguments.length>3) {
		havevalues = 0;
	}

	for (var i=0; i<els.length; i++) {
		var thisvalue = ldm_formfield_value(els[i]);
		var thisname = els[i].name;
		if (thisvalue) {
			var thispair = thisname + '=' + thisvalue;
			sendthis = sendthis + '&' + thispair;
			if (arguments.length>3) {
				for (j=3; j<arguments.length; j++) {
					if (thisname==arguments[j]) {
						havevalues = 1;
					}
				}
			}
		}
	}

	if (havevalues==1) {
		ldm_update_Handler .send(script, sendthis);
	}
	return 0;

}

/**
* Action routine used by ldm_ajax_form
*
*/

function ldm_ajax_form_updater() {

	var ldm_var = new Array();
	var ldm_val = new Array();
	var doalert = 0;

	if (ldm_update_Handler.handler.readyState == 4 && ldm_update_Handler.handler.status == 200 && ldm_update_Handler.handler.responseText) {
		try {
			eval(ldm_update_Handler.handler.responseText);
		} catch (e) {
			window.alert('Error: ' + e.description + ' :: ' + ldm_update_Handler.handler.responseText);
			return;
		}
		if (doalert) {
			window.alert(doalert);
			return;
		}

		for (var i=0; i<ldm_var.length; i++) {
			document.getElementById(ldm_var[i]).innerHTML = ldm_val[i];
		}

	}
}


if (location.search.substring(1)=="focuswin") {
	window.focus();
}

