﻿/**
* Record when JW players are instantiated and tell them to trap state changes
*
*/

var ldm_JWplayers = new Array();

function playerReady(obj) {
	var nexti = ldm_JWplayers.length;
	ldm_JWplayers[nexti] = new Array();
	ldm_JWplayers[nexti].who = obj.id;
	ldm_JWplayers[nexti].state = "CREATED";

	var playerid = document.getElementById(obj.id);
	playerid.addModelListener("STATE", "ldm_JWstateTracker");
};

/**
* Track what JW players are doing and tell everyone else to stop
* when someone starts playing
*
*/

function ldm_JWstateTracker(obj) {
	if (obj.newstate == "PLAYING") {
		for (var i=0; i<ldm_JWplayers.length; i++) {
			if (ldm_JWplayers[i].who == obj.id) {
				ldm_JWplayers[i].state = obj.newstate;
			}
			else {
				if (ldm_JWplayers[i].state == "PLAYING") {
					var playerid = document.getElementById(ldm_JWplayers[i].who);
					playerid.sendEvent("PLAY", false);
					ldm_JWplayers[i].state = "STOPPED";
				}
			}
		}
	}
	else {
		for (var i=0; i<ldm_JWplayers.length; i++) {
			if (ldm_JWplayers[i].who == obj.id) {
				ldm_JWplayers[i].state = obj.newstate;
			}
		}
	}
};