<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

/**
* Initialise the image handling code
*/

function ldm_init_imagehandler() {
    global $LDM_imagehandler;
    global $vbulletin;

    if (!isset($LDM_imagehandler)) {
        require_once (DIR . '/includes/class_LDMimage.php');
        $LDM_imagehandler = LDM_Image::get_instance($vbulletin);
    }

}

/**
* Check if file/url contains a valid and processable image
*
* param		str		filename/url
* @return	int		1: recognised and OK; 0: not recognised; -1: recognised but invalid
*/

function ldm_can_handle_as_image($pic) {
    global $LDM_imagehandler;
    global $links_defaults;

    ldm_init_imagehandler();

	$pic_info = ldm_parse_url($pic);
    $pic_type = strtolower(file_extension($pic_info['path']));

	if (!$pic_info['scheme'] and !$pic_info['host']) {

        $imagetypes = explode(',', str_replace(" ", "", strtolower($links_defaults['image_filetypes'])));
    	if (!in_array($pic_type, $imagetypes)) {
    	    return 0;
    	}

    	$pic_clean = ldm_get_local_filename($pic);
        return $LDM_imagehandler->valid_format($pic_clean);
    }
	elseif (in_array($pic_info['scheme'], array( "http", "https", ))) {

        $imagetypes = explode(',', str_replace(" ", "", strtolower($links_defaults['image_filetypes'])));
    	if (!in_array($pic_type, $imagetypes)) {
    	    return 0;
    	}

		$pic_clean = $pic_info['scheme'].'://'.$pic_info['host'].preg_replace("/ /", "%20", trim($pic_info['path']));
        return $LDM_imagehandler->valid_format($pic_clean);

	}

    return 0;
}

/**
* Check if media file contains a valid and processable image in its tags
*
* param		str		filename/url
* @return	int		1: recognised and OK; 0: not recognised; -1: recognised but invalid
*/

function ldm_can_handle_as_mediaimage($pic) {
    global $links_defaults;

	$pic_info = ldm_parse_url($pic);
    $pic_type = strtolower(file_extension($pic_info['path']));

	if (!$pic_info['scheme'] and !$pic_info['host']) {

        $mediatypes = explode(',', str_replace(" ", "", strtolower($links_defaults['image_mediatypes'])));
    	if (in_array($pic_type, $mediatypes)) {
        	$pic_clean = ldm_get_local_filename($pic);
			$im = ldm_fetch_mediafile_image($pic_clean);
			if (!$im) {
			    return 0;
			}
			if (preg_match('#<html|<head|<body|<script#si', $im)) {
    			return -1;
    		}
    		return 1;
		}
    }

    return 0;
}

/**
*	Create a thumbnail image of the contents of an image file
*
* param		str		filename/url
* param		int		size
* @return	object	image
*/

function ldm_make_thumbnail($pic, $size) {
	global $LDM_environment;
    global $LDM_imagehandler;
    global $links_defaults;

    ldm_init_imagehandler();

	unset($imsrc);
	unset($thumb);
	unset($pic_type);

	$pic_info = ldm_parse_url($pic);
    $pic_type = strtolower(file_extension($pic_info['path']));

	($hook = vBulletinHook::fetch_hook('ldm_make_thumb')) ? eval($hook) : false;

	if (isset($thumb)) {
		return $thumb;
	}

	if (!$pic_info['scheme'] and !$pic_info['host']) {

		$pic_clean = ldm_get_local_filename($pic);

        $mediatypes = explode(',', str_replace(" ", "", strtolower($links_defaults['image_mediatypes'])));
    	if (in_array(strtolower(file_extension($pic_info['path'])), $mediatypes)) {

			$imstring = ldm_fetch_mediafile_image($pic_clean);
			if (!$imstring) {
				return ldm_make_clear_thumbnail();
			}
            $imsrc = $LDM_imagehandler->fetch_image_from_string($imstring);

		} else {

        	if ($LDM_imagehandler->valid_format($pic_clean)<=0) {
		        return ldm_make_clear_thumbnail();
	        }

            $imsrc = $LDM_imagehandler->fetch_image($pic_clean);

        }

	}
	elseif (in_array($pic_info['scheme'], array( "http", "https", ))) {

        $mediatypes = explode(',', str_replace(" ", "", strtolower($links_defaults['image_mediatypes'])));
    	if (in_array(strtolower(file_extension($pic_info['path'])), $mediatypes)) {
		    return ldm_make_clear_thumbnail();
		}

		$pic_clean = $pic_info['scheme'].'://'.$pic_info['host'].preg_replace("/ /", "%20", trim($pic_info['path']));

        if ($LDM_imagehandler->valid_format($pic_clean)<=0) {
		    return ldm_make_clear_thumbnail();
	    }

		if ($LDM_environment['curl_available']) {
			$conn = @curl_init();
			@curl_setopt($conn, CURLOPT_URL, $pic_clean);
			@curl_setopt($conn, CURLOPT_TIMEOUT, 30);
			@curl_setopt($conn, CURLOPT_FOLLOWLOCATION, true);
			@curl_setopt($conn, CURLOPT_MAXREDIRS, 5);
			@curl_setopt($conn, CURLOPT_HEADER, 0);
			@curl_setopt($conn, CURLOPT_RETURNTRANSFER, true);
			@curl_setopt($conn, CURLOPT_SSL_VERIFYPEER, false);
			$imstring = @curl_exec($conn);
			$error = @curl_error($conn);
			@curl_close($conn);

		}
		elseif ($LDM_environment['allow_url_fopen']) {
			$conn = @fopen($pic_clean, "rb");
			if ($conn) {
				$imstring = "";
				while ($rec = fread($conn, READ_BUFFER)) {
					$imstring .= $rec;
				}
				@fclose($conn);
			}
			$error = "fopen";
		}

		if ($imstring) {
            $imsrc = $LDM_imagehandler->fetch_image_from_string($imstring);
		}

	}

    unset($im);

    if (isset($imsrc)) {
        if ($LDM_imagehandler->fetch_size($imsrc, $swidth, $sheight)) {
            if ($size>0) {
            	$twidth = ($swidth >= $sheight ? (int) ($size) : (int) ($size*$swidth/$sheight));
            	if ($twidth>$swidth) {
	            	$twidth = $swidth;
        		}
            	$theight = (int) ($twidth*($sheight/$swidth));
            }
            else {
                $twidth = $swidth;
                $theight = $sheight;
            }

            $LDM_imagehandler->resize_image($im, $imsrc, $swidth, $sheight, $twidth, $theight);
        }
    }

    if (isset($im)) {
	    return $im;
	}

	return ldm_make_clear_thumbnail();

}

/**
*	Extract image from media file tags
*
* param		str		filename/url
* @return	object	image
*/

function ldm_fetch_mediafile_image($FileName) {
	@include_once('getid3/getid3.php');
	if (defined('GETID3_VERSION')) {
		$getID3 = new getID3;
		$ThisFileInfo = $getID3->analyze($FileName);
		if (isset($ThisFileInfo['id3v2']['APIC'][0]['data'])) {
			return $ThisFileInfo['id3v2']['APIC'][0]['data'];
		}
	}
	return 0;
}

/**
*	Output thumbnail
*
* param		object	image
*/

function ldm_output_thumbnail($thumb) {
    global $LDM_imagehandler;

	if (isset($LDM_imagehandler)) {
	    $LDM_imagehandler->process_for_output($thumb);
    	$LDM_imagehandler->output($thumb);
    }

}

/**
*	Save thumbnail to file
*
* param		object	image
* param		str     directory
* return    str     filename or blank if error
*/

function ldm_save_thumbnail($thumb, $path) {
	global $links_defaults;
    global $LDM_imagehandler;
	global $vbulletin;

	if (!$thumb) {
	    return "";
    }

	$userid = intval($vbulletin->userinfo['userid']);
	$path = ldm_make_filename($path, implode('/', preg_split('//', $userid,  -1, PREG_SPLIT_NO_EMPTY)));

	$fullpath = ldm_get_local_filename($path, 0);
	if (!ldm_create_directory($fullpath, $links_defaults['secure_nullindexfile'])) {
			return ""; // can't create user directory
	}

	$lfile = ldm_make_filename($path, rand(1000,9999).TIMENOW.'.jpg');
	$fullfile = ldm_get_local_filename($lfile, 0);

    if ($LDM_imagehandler->save_image($thumb, $fullfile)) {
        return $lfile;
    }

    return "";

}

/**
*	Return a clear thumbnail
*
* return		object	image
*/

function ldm_make_clear_thumbnail() {
    global $LDM_imagehandler;

    ldm_init_imagehandler();
	return $LDM_imagehandler->fetch_image($url, 'clear.gif');
}

/**
*	Delete all cached thumbnails
*
*/

function ldm_clear_thumbnails() {
	global $vbulletin;

	$asb = $vbulletin->db->query_read("
		SELECT linkimgthumb
		FROM ".THIS_TABLE."linkslink
		WHERE linkimgthumb!=''
	");

	while ($row=$vbulletin->db->fetch_array($asb)) {
		$lfile = $row['linkimgthumb'];
		ldm_delete_thumb($lfile);
	}

	$asb = $vbulletin->db->query_write("
		UPDATE ".THIS_TABLE."linkslink
		SET
			linkimgthumb='',
			linkimgthumbsize = '0'
		WHERE linkimgthumb!=''
	");

}

?>
