<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// Based on code created by [tk] Software (Hamster Powered)
// See http://www.vbulletin.org/forum/showthread.php?threadid=210451
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

require_once(DIR . '/includes/class_image.php');

class LDM_Image {
	static $instance;

	function get_instance($registry) {
		if ($instance) {
		  return $instance;
		}
		else {
            $postfix = ($registry->options['imagetype'] ? $registry->options['imagetype'] : 'GD');
			eval('$instance =& LDM_Image_' . $postfix . '::get_instance($registry);');
			return $instance;
		}
	}
}

/**
* Abstracted image class
*/

class LDM_Image_Abstract {

	/**
	* Main data registry
	*
	* @var	vB_Registry
	*/
	var $registry = null;

	/**
	* Constructor
	* Don't allow direct construction of this abstract class
	* Sets registry
	*
	* @return	void
	*/

	function LDM_Image_Abstract(&$registry) {
		if (!is_subclass_of($this, 'LDM_Image_Abstract')) {
			trigger_error('Direct Instantiation of LDM_Image_Abstract prohibited.', E_USER_ERROR);
			return NULL;
		}

		$this->registry = &$registry;
	}

	/**
	* Public functions
	*/

    function fetch_image($url) {}
    function fetch_image_from_string($string) {}
    function save_image($himage, $url) {}

    function valid_format($url) {}

    function fetch_size($himage, &$width, &$height) {}

    function process_for_output($himage) {}
    function output($himage) {}

    function create_truecolor($imgwidth, $imgheight, $himage) {}
    function copy_image($hdst, $hsrc, $dstx, $dsty, $srcx, $srcy, $srcwidth, $srcheight) {}
    function resize_image($hsrc, $srcwidth, $srcheight, $dstwidth, $dstheight) {}

    function destroy_image($himage) {}

}

/**
* Image class for ImageMagick
*/

class LDM_Image_Magick extends LDM_Image_Abstract {
    var $vbimagemk;
    var $is_ani = false;
    static $images = array();

	function LDM_Image_Magick(&$registry) {
		parent::LDM_Image_Abstract($registry);
        $this->vbimagemk = new vb_Image_Magick($registry);
    }

    function get_instance($registry) {
        return new LDM_Image_Magick($registry);
    }

    function check_error(&$error) {
        if ($error = $this->vbimagemk->fetch_error()) {
            return 1;
        }
        return 0;
    }

	/**
	* Public functions
	*/

    function fetch_image($url) {
        $this->images[] .= $url;
        return count($this->images) - 1;
    }

    function fetch_image_from_string($string) {
        // write a temp file
        $tmpfname = tempnam("", 'LDM');
        $handle = fopen($tmpfname, "w");
        fwrite($handle, $string);
        fclose($handle);

        // determine the file type
        $args = '"'.$tmpfname.'"';
        $fileinfo = $this->vbimagemk->fetch_im_exec('identify', $args, true);

        if ($this->check_error($error)) {
            return NULL;
        }

        $fileinfo = explode(' ', $fileinfo[0]);
        $ext = $fileinfo[1];

        // rename the file to add extension
        rename($tmpfname, $tmpfname . '.' . $ext);
        $this->images[] .= $tmpfname . '.' . $ext;

        return count($this->images) - 1;
    }

    function save_image($himage, $url) {
        $args =  '"'.$this->images[$himage].'" "'.$url.'"';
        $this->vbimagemk->fetch_im_exec('convert', $args);
        if ($this->check_error($error)) {
            return 0;
        }
        return 1;
    }

    function valid_format($url) {
        $args = '"'.$url.'"';
        $fileinfo = $this->vbimagemk->fetch_im_exec('identify', $args, true);
        if (is_array($fileinfo)) {
            $response = str_replace("$url ", "", $fileinfo[0]);
            $ext = explode(' ', $response);
            $ext = strtolower($ext[0]);
            return 1;
        }
        return 0;
    }

    function fetch_size($himage, &$width, &$height) {
        // determine the file size
        $url = $this->images[$himage];
        $args = '"'.$url.'"';
        $fileinfo = $this->vbimagemk->fetch_im_exec('identify', $args, true);
        if ($this->check_error($error)) {
            return 0;
        }

        $response = str_replace("$url ", "", $fileinfo[0]);
        $size = explode(' ', $response);
        $size = strtolower($size[1]);

        $size = explode('x', $size);
        $width = $size[0];
        $height = $size[1];

        return 1;
    }

    function output($himage) {
        header('Cache-control: no-cache');
       	header('Expires: -1');
       	header('Content-disposition: inline; filename=' . $this->images[$himage]);
       	header('Content-transfer-encoding: binary');
       	$fileparts = explode(".", $this->images[$himage]);
       	header('Content-type: image/' . $fileparts[count($fileparts) - 1]);
        readfile($this->images[$himage]);
        $this->destroy_image($himage);
    }

    function create_truecolor($imgwidth, $imgheight, $imgdst) {
        // determine if we are dealing with an animated gif
        $args = '"'.$this->images[$imgdst].'"';
        $info = $this->vbimagemk->fetch_im_exec('identify', $args, true);
        if (count($info) > 1) {
            $this->is_ani = true;
        }

        // get the image type
        $fileparts = explode(".", $this->images[$imgdst]);
       	$ext = $fileparts[count($fileparts) - 1];

        // make a temp copy of the image to work with
        $tmpfname = tempnam("", 'LDM');
        rename($tmpfname, $tmpfname . '.' . $ext);
        $tmpfname .= '.' . $ext;
        copy($this->images[$imgdst], $tmpfname);

        // return the handle
        $this->images[] .= $tmpfname;
        return count($this->images) - 1;
    }

    function copy_image($hdst, $hsrc, $dstx, $dsty, $srcx, $srcy, $srcwidth, $srcheight) {
        if ($this->is_ani) {
            $args = '"'. $this->images[$hdst] .'"';
            $args .= ' -coalesce';
            $args .= ' -draw \'image over ' . $dstx . ',' . $dsty . ',0,0 "' . $this->images[$hsrc] . '"\'';
            $args .= ' -layers Optimize ' . '"'. $this->images[$hdst] . '"';
        }
        else {
            $args = '-page +0+0 ' . '"'. $this->images[$hdst] . '"';
            $args .= ' -page +' . $dstx . '+' . $dsty . ' ' . $this->images[$hsrc];
            $args .= ' -background transparent';
            $args .= ' -mosaic ' . '"' . $this->images[$hdst] . '"';
        }
        $this->vbimagemk->fetch_im_exec('convert', $args);
        if ($this->check_error($error)) {
            unset($hdst);
        }
    }

    function resize_image(&$hdst, $hsrc, $srcwidth, $srcheight, $dstwidth, $dstheight) {

        // force the resized image to be in .png format
        $ext = "png";

        // get filename to work with
        $tmpfname = tempnam("", 'LDM');
        @unlink($tmpfname . '.' . $ext);
        @rename($tmpfname, $tmpfname . '.' . $ext);
        $tmpfname .= '.' . $ext;
        $this->images[] = $tmpfname;
        $hdst = count($this->images) - 1;

        // resize the image
        $args =  '"'. $this->images[$hsrc] . '"';
        $args .= ' -flatten -resize ' . $dstwidth . 'x' . $dstheight . ' "' . $this->images[$hdst] . '"';
        $this->vbimagemk->fetch_im_exec('convert', $args);
        if ($this->check_error($error)) {
            unset($hdst);
        }
    }

    function destroy_image($himage) {
        if ($this->images[$himage]) {
            $str = strtolower($this->images[$himage]);
            if (stristr($str, '/temp') or stristr($str, '\temp') or stristr($str, '/tmp') or stristr($str, '\tmp')) {
                // only destroy images in temporary directories
                @unlink($this->images[$himage]);
            }
        }
    }

    function process_for_output($himage) {
        // do nothing - not necessary with ImageMagick
        return $himage;
    }
}

/**
* Image class for GD Image Library
*/

class LDM_Image_GD extends LDM_Image_Abstract {

	/**
	* Constructor. Sets up resizable types, extensions, etc.
	*
	* @return	void
	*/

	function LDM_Image_GD(&$registry) {
		parent::LDM_Image_Abstract($registry);
	}

    function get_instance($registry) {

        return new LDM_Image_GD($registry);

    }

    /**
	* Public functions
	*/

    function fetch_image($url) {
        @ini_set('memory_limit', -1);
        $size = @getimagesize($url);
        $mime = $size['mime'];
        if (strpos($mime, "jpeg") !== false) {
            $img = @imagecreatefromjpeg($url);
        }
        elseif (strpos($mime, "png") !== false) {
            $img = @imagecreatefrompng($url);
        }
        else {
            $img = @imagecreatefromgif($url);
        }

        return $img;
    }

    function fetch_image_from_string($string) {
        @ini_set('memory_limit', -1);
        return @imagecreatefromstring($string);
    }

    function valid_format($url) {

        // get the image type
        $fileparts = explode(".", $url);
       	$ext = strtolower($fileparts[count($fileparts) - 1]);

        if (in_array($ext,
            array('jpg', 'jpeg', 'gif', 'png',)
            )) {

    		if (!@getimagesize($url)) {
	    	    return -1;
		    }

            return 1;
        }

        return 0;

    }

    function save_image($himage, $url) {

        // get the image type
        $fileparts = explode(".", $url);
       	$ext = strtolower($fileparts[count($fileparts) - 1]);

        if ($ext=='jpg' or $ext=='jpeg') {
        	@imagejpeg($himage, $url);
        	return 1;
        }
        elseif ($ext=='png') {
        	@imagepng($himage, $url);
        	return 1;
        }
        elseif ($ext=='gif') {
        	@imagegif($himage, $url);
        	return 1;
        }
        return 0;
    }

    function fetch_size($himage, &$width, &$height) {
        if (!is_string($himage)) {
            $width = @imagesx($himage);
            $height = @imagesy($himage);
            return 1;
        }
        list($width, $height) = @getimagesize($himage);
        return 1;
    }

    function output($himage) {
// Always output in .png format
        $filename = preg_replace("/(.*)\.[a-z0-9]*/", "$1.png", $this->images[$himage]);
        header('Cache-control: no-cache');
       	header('Expires: -1');
       	header('Content-disposition: inline; filename=' . $filename);
       	header('Content-transfer-encoding: binary');
       	header('Content-type: image/png');
        imagepng($himage);
    }

    function create_truecolor($imgwidth, $imgheight, $imgdst) {
        $sprite = @imagecreatetruecolor($imgwidth, $imgheight);
        @imagealphablending($sprite, false);
        $transparent = @imagecolorallocatealpha($sprite, 0, 0, 0, 127);
        @imagecolortransparent($sprite, $transparent);
        @imagefill($sprite, 0, 0, $transparent);
        @imagecopy($sprite, $imgdst, 0, 0, 0, 0, $imgwidth, $imgheight);

        return $sprite;
    }

    function copy_image(&$hdst, $hsrc, $dstx, $dsty, $srcx, $srcy, $srcwidth, $srcheight) {
        @imagecopy($hdst, $hsrc, $dstx, $dsty, $srcx, $srcy, $srcwidth, $srcheight);
    }

    function resize_image(&$hdst, $hsrc, $srcwidth, $srcheight, $dstwidth, $dstheight) {
        @ini_set('memory_limit', -1);
        $hdst = @imagecreatetruecolor($dstwidth, $dstheight);
        @imagealphablending($hdst, false);
        $transparent = @imagecolorallocatealpha($hdst, 0, 0, 0, 127);
        @imagecolortransparent($hdst, $transparent);
        @imagefill($hdst, 0, 0, $transparent);
		@imagecopyresampled($hdst, $hsrc, 0, 0, 0, 0, $dstwidth, $dstheight, $srcwidth, $srcheight);
    }

    function destroy_image($himage) {
        @imagedestroy($himage);
    }

    function process_for_output($himage) {
        @imagealphablending($himage, true);
        @imagesavealpha($himage, true);
        return $himage;
    }
}

?>