<?php

/*======================================================================*\
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
\*======================================================================*/

error_reporting(E_ALL & ~E_NOTICE);

define('THIS_SCRIPT',  'local_links_spider');

// get special phrase groups
$phrasegroups = array(
	'local_links',
);

// pre-cache all templates used by this hack
$globaltemplates = array(
	'links_catjump',
	'links_catsortbit',
	'links_footer',
	'links_header',
	'links_navbar',
	'links_navbar_popups',
	'links_search_catselect',
);

// get special data templates from the datastore
$specialtemplates = array(
	'attachmentcache',
	'ldm_admin',
	'ldm_cats',
);

// pre-cache templates used by specific actions
$actiontemplates = array(
);

// fire up VBulletin backend
require_once('./global.php');

require_once(DIR . '/includes/local_links_init.php');
require_once(DIR . '/includes/local_links_include.php');
require_once(DIR . '/includes/local_links_misc.php');

$SPIDER_SCRIPT = THIS_SCRIPT;

$vbulletin->input->clean_array_gpc('r', array(
	'action'	=> TYPE_STR,
	'pp'		=> TYPE_INT,
	'page'		=> TYPE_INT,
	));

$this_action = ($vbulletin->GPC_exists['action'] ? $vbulletin->GPC['action'] : "spider");

if ($vbulletin->GPC_exists['pp']) {
	$perpage = $vbulletin->GPC['pp'];
}
else {
	$perpage = $vbulletin->userinfo['maxposts'];
	$checkmax = explode(',', $vbulletin->options['usermaxposts'] . ',' . $vbulletin->options['maxposts']);
	if ($perpage < 1 OR $perpage > max($checkmax)) {
		$perpage = $vbulletin->options['maxposts'];
	}
	$perpage = ($links_defaults['links_per_page']!=0 ? $links_defaults['links_per_page'] : $perpage);
}

$pagenumber = ($vbulletin->GPC_exists['page'] ? $vbulletin->GPC['page'] : 1);
$master_title = htmlspecialchars_uni(($links_defaults['database_name'] ? $links_defaults['database_name'] : $vbphrase['ll_links_database']));

function ldm_spiderme($url) {

	$urlInfo = ldm_parse_url($url);
	$sites = array();
	$contents = ldm_fetch_page($url);
	preg_match_all("#<a.*? href=\"([^\"]+)\"[^>]*>([^<]*)</a>#", $contents, $matches);

	foreach ($matches[1] as $k=>$m) {
		if ($m{0}=="#") {
			continue;
		}
		elseif ($m{0}=="/") {
			$sites[] = array("url"=>$urlInfo['scheme'].'://'.$urlInfo['host'].$m, "link"=>$matches[2][$k]);
		}
		else {
			$sites[] = array("url"=>$m , "link"=>$matches[2][$k]);
		}
	}

	return $sites;
}

if ($this_action == "spider") {

	$this_navigation_title = $master_title;
	construct_forum_jump();

	$vbulletin->input->clean_array_gpc('r', array(
		'linkid'	=> TYPE_INT,
		'catid'		=> TYPE_INT,
		));

	$navbits = array();
	$navbits[$LINKS_SCRIPT.'.php'.$vbulletin->session->vars['sessionurl_q']] = $master_title;
	$this_navigation_title = ldm_kill_bbcodes($vbphrase['ll_search'].' '.$master_title);
	$navbits[] = "Spider";
	$navbits = construct_navbits($navbits);

	eval('$navbar = "' . fetch_template('navbar') . '";');

	if ($links_defaults['category_jump_menu'] and count($linkscat)) {
		$catjumpbit = ldm_construct_category_list(array(0), "links_catjump", 0, "catid", "catid", 1);
	}

	$viewcatid = -2;
	$links_permissions["can_add_link"] = 0;
	$links_permissions["can_add_category"] = 0;
	$links_permissions["can_edit_category"] = 0;

	eval("\$ldmnavbar  = \"".fetch_template('links_navbar')."\";");
	eval("\$ldmnavbar_popups  = \"".fetch_template('links_navbar_popups')."\";");

	eval("\$output  = \"".fetch_template('links_header')."\";");

	$sites = array();
	cache_LDMicons();

	$linkid = $vbulletin->GPC['linkid'];
	$catid = $vbulletin->GPC['catid'];

	if ($linkid) {
		$row = $vbulletin->db->query_first("
			SELECT link.linkname AS linkname, link.linkurl AS linkurl
			FROM ".THIS_TABLE."linkslink AS link
			WHERE link.linkid='".$linkid."'
			LIMIT 1
			");
		$linkurl = $row['linkurl'];
		$linkname = $row['linkname'];
		if ($linkurl) {
			$sites = ldm_spiderme($linkurl);
		}
	}

	$istart = ($pagenumber-1)*$perpage;
	$ifin = $istart+$perpage;

	$page = "
<table class=\"tborder\" cellpadding=\"$stylevar[cellpadding]\" cellspacing=\"$stylevar[cellspacing]\" border=\"0\" width=\"100%\" align=\"center\">
<tbody>
<tr align=\"center\">
	<td class=\"tcat\" align=\"center\" colspan=\"2\">
	<strong>Spidering <a href=\"$LINKS_SCRIPT.php?".$vbulletin->session->vars['sessionurl']."action=jump&amp;id=$linkid\" target=\"_new\">$linkname</a></strong>
	</td>
</tr>
		";

	$k = -1;
	foreach ($sites as $thissite) {

		$k++;
		if ($k>=$ifin) {
			break;
		}
		elseif ($k<$istart) {
			continue;
		}

		$thisurl = $thissite['url'];
		if (strlen($thisurl)>32) {
			$thisurl_short = substr($thisurl, 0, 72).'...';
		}
		else {
			$thisurl_short = $thisurl;
		}
		$page .= "
<tr>
	<td class=\"alt1\" width=\"50%\">
	<span class=\"smallfont\">
		<a href=\"".$SPIDER_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=".$catid."&amp;linkid=".$linkid."&amp;url=".$thissite['url']."\">".
		(isset($ldm_icon_cache['spider']) ? ldm_get_imagebit($ldm_icon_cache['spider'], "Spider this link") : "[Spider this link]")."
		</a>
		<a href=\"".$thissite['url']."\" target=\"_new\" title=\"Visit URL\" >".$thisurl_short."</a>
	</span>
	</td>
	<td class=\"alt1\">
	<span class=\"smallfont\">
		".$thissite['link']."
	</span>
	</td>
</tr>
		";

	}

	$pagenav = construct_page_nav($pagenumber, $perpage, count($sites), $SPIDER_SCRIPT.".php?".$vbulletin->session->vars['sessionurl']."catid=".$catid."&amp;linkid=".$linkid, "&amp;pp=$perpage");

	$output .= $pagenav;
	$output .= "<br />" . $page;

	$output .= "
<tr align=\"center\">
	<td class=\"tfoot\" align=\"center\" colspan=\"2\">
	<a href=\"$LINKS_SCRIPT.php?".$vbulletin->session->vars['sessionurl']."linkid=$linkid\">".$vbphrase['ll_return']."</a></strong>
	</td>
</tr>
</tbody>
</table>
<br />
		";

	eval("\$output .= \"".fetch_template('links_footer')."\";");

	print_output($output);
	exit;
}

?>