<?php

/*======================================================================*\
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
\*======================================================================*/

//  Create the LDM admin settings that control the extra

function ldm_shadowbox_init() {
	global $links_defaults;

	if (
		!isset($links_defaults['shadowbox_title']) or

		!isset($links_defaults['shadowbox_active_jukebox']) or
		!isset($links_defaults['shadowbox_video_height']) or
		!isset($links_defaults['shadowbox_video_width']) or
		!isset($links_defaults['shadowbox_audio_filetypes']) or
		!isset($links_defaults['shadowbox_audio_height']) or
		!isset($links_defaults['shadowbox_audio_width']) or
		!isset($links_defaults['shadowbox_audio_displayimage']) or
		!isset($links_defaults['shadowbox_jukebox_template']) or
		!isset($links_defaults['shadowbox_playbit_template']) or

		!isset($links_defaults['shadowbox_active_imgmag']) or
		!isset($links_defaults['shadowbox_imgmag_height']) or
		!isset($links_defaults['shadowbox_imgmag_width']) or
		!isset($links_defaults['shadowbox_imgmag_template']) or

		!isset($links_defaults['shadowbox_border']) or

		!isset($links_defaults['shadowbox_background']) or
		!isset($links_defaults['shadowbox_close'])

		) {

		require_once(DIR . '/includes/local_links_admininclude.php');
		$seq = locate_LDMadminrow_space(17);

		require_LDMadminrow($seq++, 'shadowbox_title', 'Shadowbox', 'title', 1, 1);

		require_LDMadminrow($seq++, 'shadowbox_active_jukebox', '1', 'yesno', 1, 1, 'Enable Shadowbox Jukebox');
		require_LDMadminrow($seq++, 'shadowbox_video_height', ($links_defaults['musicbox_standalone_height'] ? $links_defaults['musicbox_standalone_height'] : 640), 'text', 1, 1, 'Shadowbox Video Player Height (px)');
		require_LDMadminrow($seq++, 'shadowbox_video_width', ($links_defaults['musicbox_standalone_width'] ? $links_defaults['musicbox_standalone_width'] : 800), 'text', 1, 1, 'Shadowbox Video Player Width (px)');
		require_LDMadminrow($seq++, 'shadowbox_audio_filetypes', 'wma, mp3, m4a, rm', 'text', 1, 1, 'Filetypes to handle as audio-only in Shadowbox');
		require_LDMadminrow($seq++, 'shadowbox_audio_height', ($links_defaults['musicbox_standalone_height'] ? $links_defaults['musicbox_standalone_height'] : 640), 'text', 1, 1, 'Shadowbox Audio Player Height (px)');
		require_LDMadminrow($seq++, 'shadowbox_audio_width', ($links_defaults['musicbox_standalone_width'] ? $links_defaults['musicbox_standalone_width'] : 800), 'text', 1, 1, 'Shadowbox Audio Player Width (px)');
		require_LDMadminrow($seq++, 'shadowbox_audio_displayimage', '0', 'yesno', 1, 1, 'Display linkbit image above player');
		require_LDMadminrow($seq++, 'shadowbox_jukebox_template', 'links_play_naked', '', 1, 1, 'Shadowbox Jukebox Template');
		require_LDMadminrow($seq++, 'shadowbox_playbit_template', 'links_playbit_naked', '', 1, 1, 'Shadowbox Playbit Template');

		require_LDMadminrow($seq++, 'shadowbox_active_imgmag', '1', 'yesno', 1, 1, 'Enable Shadowbox Image Magnifier');
		require_LDMadminrow($seq++, 'shadowbox_imgmag_height', ($links_defaults['link_imagemagsize'] ? $links_defaults['link_imagemagsize'] : 640), '', 1, 1, 'Shadowbox Image Page Height');
		require_LDMadminrow($seq++, 'shadowbox_imgmag_width', ($links_defaults['link_imagemagsize'] ? $links_defaults['link_imagemagsize'] : 640), '', 1, 1, 'Shadowbox Image Page Width');
		require_LDMadminrow($seq++, 'shadowbox_imgmag_template', 'links_imgpage', '', 1, 1, 'Shadowbox Image Magnifier Template');

		require_LDMadminrow($seq++, 'shadowbox_border', '30', '', 1, 1, 'Shadowbox Page Border (px)');
		require_LDMadminrow($seq++, 'shadowbox_background', '#000000', '', 1, 1, 'Background colour for inner Shadowbox window');

		require_LDMadminrow($seq++, 'shadowbox_close', '', 'close', 1, 1);

		$links_defaults = cache_LDMsettings(-1, 1);
	}

	$links_defaults['open_musicbox_newwindow'] = 1;

}

//  Patch entitybits

function ldm_shadowbox_getentitybit_jukebox($urlType, &$entitytitle, &$entityreltag, &$entitywindow) {
	global $links_defaults, $links_permissions;
	global $vbphrase;

	$links_defaults['shadowbox_audio_filetypes'] = str_replace(' ', '', $links_defaults['shadowbox_audio_filetypes']);
	$player_isaudio = in_array($urlType, explode(',', $links_defaults['shadowbox_audio_filetypes']));

	if ($links_permissions['can_play_musicbox']) {
		if ($player_isaudio) {
			$shadowbox_border = ($links_defaults['shadowbox_border'] ? $links_defaults['shadowbox_border'] : 20);
			$shadowbox_width = ($links_defaults['shadowbox_audio_width'] ? $links_defaults['shadowbox_audio_width'] : 800) + 2*$shadowbox_border;
			$shadowbox_height = ($links_defaults['shadowbox_audio_height'] ? $links_defaults['shadowbox_audio_height'] : 640) + 2*$shadowbox_border;
			$shadowbox_reltag = 'shadowbox[Jukebox];height='.$shadowbox_height.';width='.$shadowbox_width.';title= ;';
			$entityreltag = "rel=".$shadowbox_reltag;
			$entitytitle = '';
			$entitywindow = 'target="_top"';
			$GLOBALS['is_shadowbox'] = 1;
		}
		else {
			$shadowbox_border = ($links_defaults['shadowbox_border'] ? $links_defaults['shadowbox_border'] : 20);
			$shadowbox_width = ($links_defaults['shadowbox_video_width'] ? $links_defaults['shadowbox_video_width'] : 800) + 2*$shadowbox_border;
			$shadowbox_height = ($links_defaults['shadowbox_video_height'] ? $links_defaults['shadowbox_video_height'] : 640) + 2*$shadowbox_border;
			$shadowbox_reltag = 'shadowbox[Jukebox];height='.$shadowbox_height.';width='.$shadowbox_width.';title= ;';
			$entityreltag = "rel='".$shadowbox_reltag."'";
			$entitytitle = '';
			$entitywindow = 'target="_top"';
			$GLOBALS['is_shadowbox'] = 1;
		}
	}

}

function ldm_shadowbox_getentitybit_image($linkid, $entityid, &$entityimgmag) {
	global $links_defaults, $ldm_icon_cache;
	global $RESIZE_SCRIPT;
	global $vbulletin, $vbphrase;

	$shadowbox_border = ($links_defaults['shadowbox_border'] ? $links_defaults['shadowbox_border'] : 20);
	$shadowbox_width  = ($links_defaults['shadowbox_imgmag_width'] ? $links_defaults['shadowbox_imgmag_width'] : 800) + 2*$shadowbox_border;
	$shadowbox_height = ($links_defaults['shadowbox_imgmag_height'] ? $links_defaults['shadowbox_imgmag_height'] : 640) + 2*$shadowbox_border;

	$reltag_save = $links_defaults['reltag_image'];
	$links_defaults['reltag_image'] = 'rel="shadowbox[Gallery];height='.$shadowbox_height.';width='.$shadowbox_width.';title= ;"';
	$linkimg = 1;
	eval("\$entityimgmag = \"".fetch_template('links_imgmag')."\";");
	$entityimgmag = preg_replace('/size=/', 'shadowbox=1&size=', $entityimgmag);
	$links_defaults['reltag_image'] = $reltag_save;
	$GLOBALS['is_shadowbox'] = 1;

}

//  Patch linkbits

function ldm_shadowbox_getlinkbit_jukebox($linkname, $linkcatid, $musicbox_seo, $urlInfo, &$linkurljump, &$linktypebit) {
	global $links_defaults;
	global $vbphrase;

	$links_defaults['shadowbox_audio_filetypes'] = str_replace(' ', '', $links_defaults['shadowbox_audio_filetypes']);
	$player_isaudio = in_array($linkfiletype, explode(',', $links_defaults['shadowbox_audio_filetypes']));

	if ($player_isaudio) {
		$shadowbox_border = ($links_defaults['shadowbox_border']>0 ? $links_defaults['shadowbox_border'] : 20);
		$shadowbox_width = ($links_defaults['shadowbox_audio_width']>0 ? $links_defaults['shadowbox_audio_width'] : 800) + 2*$shadowbox_border;
		$shadowbox_height = ($links_defaults['shadowbox_audio_height']>0 ? $links_defaults['shadowbox_audio_height'] : 640) + 2*$shadowbox_border;
		$shadowbox_reltag = 'shadowbox[Jukebox];height='.$shadowbox_height.';width='.$shadowbox_width.';title= ;';
		$shadowbox_template = '<a href="'.$musicbox_seo.'" rel="'.$shadowbox_reltag.'" title="'.$vbphrase['ll_playme'].'">%s</a>';
		$linkurljump = ldm_process_permission(sprintf($shadowbox_template, $linkname), $linkname, $linkcatid);
		$linktypebit = ldm_get_typebit($urlInfo);
		$GLOBALS['is_shadowbox'] = 1;
	}
	else {
		$shadowbox_border = ($links_defaults['shadowbox_border']>0 ? $links_defaults['shadowbox_border'] : 20);
		$shadowbox_width = ($links_defaults['shadowbox_video_width']>0 ? $links_defaults['shadowbox_video_width'] : 800) + 2*$shadowbox_border;
		$shadowbox_height = ($links_defaults['shadowbox_video_height']>0 ? $links_defaults['shadowbox_video_height'] : 640) + 2*$shadowbox_border;
		$shadowbox_reltag = 'shadowbox[Jukebox];height='.$shadowbox_height.';width='.$shadowbox_width.';title= ;';
		$shadowbox_template = '<a href="'.$musicbox_seo.'" rel="'.$shadowbox_reltag.'" title="'.$vbphrase['ll_playme'].'">%s</a>';
		$linkurljump = ldm_process_permission(sprintf($shadowbox_template, $linkname), $linkname, $linkcatid);
		$linktypebit = ldm_get_typebit($urlInfo);
		$GLOBALS['is_shadowbox'] = 1;
	}

}

function ldm_shadowbox_getlinkbit_image(&$linkimgmag) {
	global $links_defaults;
	global $vbphrase;

	if (preg_match("/ rel=/", $linkimgmag)) {
		$shadowbox_border = ($links_defaults['shadowbox_border']>0 ? $links_defaults['shadowbox_border'] : 20);
		$shadowbox_width = ($links_defaults['shadowbox_imgmag_width']>0 ? $links_defaults['shadowbox_imgmag_width'] : 800) + 2*$shadowbox_border;
		$shadowbox_height = ($links_defaults['shadowbox_imgmag_height']>0 ? $links_defaults['shadowbox_imgmag_height'] : 640) + 2*$shadowbox_border;
		$linkimgmag = preg_replace(
				array(
					'/ rel="[^"]*"/',
					'/size=/',
				),
				array(
					'rel="shadowbox[Gallery];title= ;height='.$shadowbox_height.';width='.$shadowbox_width.'"',
					'shadowbox=1&size=',
				),
				$linkimgmag);
		$GLOBALS['is_shadowbox'] = 1;
	}

}

//  Incorporate the shadowbox javascripts

function ldm_shadowbox_placescripts($is_shadowbox, &$ldm_headtag_include) {
	global $stylevar;

	if ($is_shadowbox) {

		$shadowbox_language = substr($stylevar['languagecode'], 0, 2);
		if (!in_array($shadowbox_language, array('ar', 'de', 'en', 'es', 'fr', 'nl', 'zh'))) {
			$shadowbox_language = 'en';
		}

		$ldm_headtag_include .= "
<script type='text/javascript' src='clientscript/shadowbox/shadowbox-yui.js'></script>
<script type='text/javascript' src='clientscript/shadowbox/shadowbox.js'></script>
<script type='text/javascript'>

Shadowbox.loadSkin('classic', 'clientscript/shadowbox/skins');
Shadowbox.loadLanguage('$shadowbox_language', 'clientscript/shadowbox/lang');
Shadowbox.loadPlayer(['html', 'iframe'], 'clientscript/shadowbox/player');

YAHOO.util.Event.onDOMReady(Shadowbox.init);

</script>
		";

	}

}

function ldm_shadowbox_resizer() {
	global $vbulletin;
	global $links_defaults;
	global $RESIZE_SCRIPT;

	$vbulletin->input->clean_array_gpc('g', array(
		'catid'	=> TYPE_INT,
		'entityid'	=> TYPE_INT,
		'linkid'	=> TYPE_INT,
		'shadowbox'	=> TYPE_INT,
		));

	if ($vbulletin->GPC['shadowbox']==1 and $vbulletin->GPC_exists['linkid']) { // create an html page and embed the picture in it

		$shadowbox_border = ($links_defaults['shadowbox_border']>0 ? $links_defaults['shadowbox_border'] : 20);
		$shadowbox_width = ($links_defaults['shadowbox_imgmag_width']>0 ? $links_defaults['shadowbox_imgmag_width'] : 800) + 2*$shadowbox_border;
		$shadowbox_height = ($links_defaults['shadowbox_imgmag_height']>0 ? $links_defaults['shadowbox_imgmag_height'] : 640) + 2*$shadowbox_border;

		$pic_background = ($links_defaults['shadowbox_background'] ? $links_defaults['shadowbox_background'] : '#000000');

		$linkid = $vbulletin->GPC['linkid'];

		if ($vbulletin->GPC_exists['entityid']) {
			$entityid = $vbulletin->GPC['entityid'];
			$query = "
				SELECT link.linkid AS linkid, entity.entityvalue AS linkimg, '' AS linkimgthumb, 0 AS linkimgthumbsize
				FROM ".THIS_TABLE."linkslink AS link
				LEFT JOIN ".THIS_TABLE."linksentities AS entity
				ON link.linkid=entity.linkid
				WHERE link.linkid='".$linkid."'
				AND entity.entityid='".$entityid."'
				LIMIT 1
			";
		}
		else {
			$query = "
				SELECT linkid, linkimg, linkimgthumb, linkimgthumbsize
				FROM ".THIS_TABLE."linkslink AS link
				WHERE link.linkid='".$linkid."'
				LIMIT 1
			";
		}

		$rec = $vbulletin->db->query_first($query);
		$linkimg = $rec['linkimg'];

		$urlInfo = ldm_parse_url($linkimg);
		if ($urlInfo['host']) {

			$pic_source = $linkimg;
			$pic_margin_top = 20;

		}
		elseif (!$links_defaults['local_file_root']) {

			$pic_source = ldm_make_filename($links_defaults['local_file_root_prefix'], $linkimg);
			$pic_clean = ldm_get_local_filename($pic_source);
			$getimagesize = @getimagesize($pic_clean);
			if ($getimagesize) {
				if ($getimagesize[0]>=$getimagesize[1]) {
					$pic_width = $shadowbox_width - 2*$shadowbox_border;
					if ($pic_width<=0) {
						$pic_width = $shadowbox_width;
					}
					$pic_height = intval(($getimagesize[1]/$getimagesize[0])*$pic_width);
					$pic_margin_top = max($shadowbox_border, intval(($shadowbox_height - $pic_height)/4));
				}
				else {
					$pic_height = $shadowbox_height - 2*$shadowbox_border;
					if ($pic_height<=0) {
						$pic_height = $shadowbox_height;
					}
					$pic_width = intval(($getimagesize[0]/$getimagesize[1])*$pic_height);
					$pic_margin_top = $shadowbox_border;
				}
			}
			else {
				$pic_width = $shadowbox_width;
				$pic_margin_top = $shadowbox_border;
			}

		}
		else {

			$pic_source = array();
			$pic_source[] = 'linkid='.$linkid;
			if ($vbulletin->GPC_exists['catid']) {
				$pic_source[] = 'catid='.$vbulletin->GPC['catid'];
			}
			if ($vbulletin->GPC_exists['entityid']) {
				$pic_source[] = 'entityid='.$vbulletin->GPC['entityid'];
			}

			$pic_width = $shadowbox_width;
			$pic_margin_top = $shadowbox_border;

			$pic_source[] = 'size='.$pic_width;
			$pic_source = ldm_make_filename($vbulletin->options['bburl'],$RESIZE_SCRIPT).'.php?'.implode('&amp;', $pic_source).'&amp;shadowbox=2';

		}

		eval('$output = "' . fetch_template($links_defaults['shadowbox_imgmag_template']) . '";');
		echo $output;
		exit;
	}

	if ($vbulletin->GPC['shadowbox']==2 and $vbulletin->GPC_exists['linkid']) { // grab original file and dump it

		if ($vbulletin->GPC_exists['entityid']) {
			$entityid = $vbulletin->GPC['entityid'];
			$query = "
				SELECT link.linkid AS linkid, entity.entityvalue AS linkimg, '' AS linkimgthumb, 0 AS linkimgthumbsize
				FROM ".THIS_TABLE."linkslink AS link
				LEFT JOIN ".THIS_TABLE."linksentities AS entity
				ON link.linkid=entity.linkid
				WHERE link.linkid='".$linkid."'
				AND entity.entityid='".$entityid."'
				LIMIT 1
			";
		}
		else {
			$query = "
				SELECT linkid, linkimg, linkimgthumb, linkimgthumbsize
				FROM ".THIS_TABLE."linkslink AS link
				WHERE link.linkid='".$linkid."'
				LIMIT 1
			";
		}

		$rec = $vbulletin->db->query_first($query);
		$linkimg = $rec['linkimg'];

		$file = ldm_get_local_filename($rec['linkimg']);

		$fp = @fopen($file,'r');
		if ($fp) {
			$image = fread($fp, filesize($file));
			fclose($fp);
			@header("Content-type: image/jpeg");
			echo $image;
			unset($image);
			exit;
		}

	}

}

?>