<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. But by all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 10.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
/* ===========================================================================*/

error_reporting(E_ALL & ~E_NOTICE);

define('NOSHUTDOWNFUNC', 1);
define('SKIP_SESSIONCREATE', 1);
define('DIE_QUIETLY', 1);
define('THIS_SCRIPT', 'external');
define('CSRF_PROTECTION', true);

$phrasegroups = array(
	'local_links',
);

$globaltemplates = array();

$specialtemplates = array(
	'attachmentcache',
	'ldm_admin',
	'ldm_cats',
);

$actiontemplates = array();

require_once('./global.php');
require_once(DIR . '/includes/local_links_init.php');
require_once(DIR . '/includes/local_links_include.php');

require_once(DIR . '/includes/class_xml.php');
require_once(DIR . '/includes/class_bbcode_alt.php');


	$vbulletin->input->clean_array_gpc('r', array(
		'catid'		=> TYPE_STR,
		'hot'		=> TYPE_BOOL,
		'count'		=> TYPE_UINT,
	));

	if ($vbulletin->GPC['hot']) {
		$filter	= array("link.linkmoderate=0", "linkhits>0");
		$order	= "linkhits DESC";
	}
	else {
		$filter	= array("link.linkmoderate=0");
		$order	= "linkdate DESC";
	}

	if ($vbulletin->GPC['count']) {
		$limit = $vbulletin->GPC['count'];
	}
	else {
		$limit = (isset($links_defaults['links_seen_on_portal']) ? $links_defaults[links_seen_on_portal] : 10);
	}

	if ($vbulletin->GPC['catid']) {
		$catids = explode(',',$vbulletin->GPC['catid']);
		foreach ($catids as $k=>$v) {
			if (!is_numeric($catids[$k])) {
				unset($catids[$k]);
			}
		}
		$filter[] = "ltoc.catid IN (-1,".implode(',', $catids).')';
	}

	$limitfids = ldm_lookup_forum_protections($links_permissions['can_see_protected_links_on_portal']);
	$filter[] = "link.linkforum NOT IN (".implode(',', $limitfids).")";

	if (!intval($vbulletin->options['externalcache']) OR $vbulletin->options['externalcache'] > 1440) {
		$externalcache = 60;
	}
	else {
		$externalcache = $vbulletin->options['externalcache'];
	}

	$rsstitle = $vbulletin->options['bbtitle'];
	$rssicon = preg_match('#^http(s)?://#', $stylevar['imgdir_misc']) ?  $stylevar['imgdir_misc'] . '/rss.jpg' : $vbulletin->options['bburl'] . "/$stylevar[imgdir_misc]/rss.jpg";

// Take care - VB version specific - requires >=3.6
	$xml = new vB_XML_Builder($vbulletin);
// Take care - VB version specific

	$rsstag = array(
		'version'       => '2.0',
		'xmlns:dc'      => 'http://purl.org/dc/elements/1.1/',
		'xmlns:content' => 'http://purl.org/rss/1.0/modules/content/'
	);
	$master_title = ($links_defaults['database_name'] ? $links_defaults['database_name'] : $vbphrase['ll_links_database']);

	($hook = vBulletinHook::fetch_hook('ldm_rss2_start')) ? eval($hook) : false;

	$xml->add_group('rss', $rsstag);
	$xml->add_group('channel');

	$xml->add_tag('title', $rsstitle);
	$xml->add_tag('link', $vbulletin->options['bburl']);
	$xml->add_tag('description', $master_title);
	$xml->add_tag('language', $stylevar['languagecode']);
	$xml->add_tag('lastBuildDate', gmdate('D, d M Y H:i:s') . ' GMT');
	$xml->add_tag('generator', 'vBulletin');
	$xml->add_tag('ttl', $externalcache);

	$xml->add_group('image');
		$xml->add_tag('url', $rssicon);
		$xml->add_tag('title', $rsstitle);
		$xml->add_tag('link', $vbulletin->options['bburl']);
	$xml->close_group('image');

	$query = ldm_get_mainsql($filter, 0, 1, $order, $limit, 0, 0);
	$asb = $vbulletin->db->query_read($query);

	while ($row=$vbulletin->db->fetch_array($asb)) {

		($hook = vBulletinHook::fetch_hook('ldm_rss2_openitem')) ? eval($hook) : false;

		$xml->add_group('item');
		$xml->add_tag('title', unhtmlspecialchars($row['linkname']));
		$xml->add_tag('link', $vbulletin->options['bburl'] . "/".LINKS_SCRIPT.".php?"."catid=".$row['linkcatid'].'&linkid='.$row['linkid']);
		$xml->add_tag('pubDate', gmdate('D, d M Y H:i:s', $row['linkdate']) . ' GMT');


// Take care - VB version specific - requires >=3.6
		$plaintext_parser =& new vB_BbCodeParser_PlainText($vbulletin, fetch_tag_list());
		$plainmessage = $plaintext_parser->parse($row['linkdesc']);
		unset($plaintext_parser);
		$xml->add_tag('description', $plainmessage);
// Take care - VB version specific

		$xml->add_tag('category', $linkscat[$row['linkcatid']]["catname_clean"], array('domain' => $vbulletin->options['bburl'] . "/".LINKS_SCRIPT.".php?catid=".$row['linkcatid']));

		$xml->add_tag('dc:creator', unhtmlspecialchars($thread['linkusername']));
		if (isset($row['linkdoi'])) {
			$xml->add_tag('guid', $vbulletin->options['bburl'] . "/".LINKS_SCRIPT.".php?"."doi=".$row['linkdoi'], array('isPermaLink' => 'true'));
		}
		else {
			$xml->add_tag('guid', $vbulletin->options['bburl'] . "/".LINKS_SCRIPT.".php?"."catid=".$row['linkcatid'], array('isPermaLink' => 'true'));
		}

		($hook = vBulletinHook::fetch_hook('ldm_rss2_closeitem')) ? eval($hook) : false;

		$xml->close_group('item');
	}

	($hook = vBulletinHook::fetch_hook('ldm_rss2_postscan')) ? eval($hook) : false;

	$xml->close_group('channel');
	$xml->close_group('rss');

	$output .= $xml->output();

	@header('Content-Type: text/xml');
	@header('Expires: ' . gmdate('D, d M Y H:i:s') . ' GMT');
	@header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
	@header('Pragma: public');

// Take care - VB version specific - requires >=3.6
	echo $xml->fetch_xml_tag() . "\r\n";
	echo $output;

	unset($xml);
?>
