<?php

/* ===========================================================================*/
//
// This code is provided free on the basis that you do not claim that
// it is your own, sell it or use it as the basis for other products that you
// sell. By all means extend it, modify it, upgrade it, correct it,
// suggest improvements, call me an idiot, etc.
//
// (c) 2004/09
// Andrew Dearing
// European Industrial Research Management Association
// www.eirma.org
//
// v2.3.0, 01.06.2009
// For VB3.7.x and VB3.8.x
// see changes.txt for history
// v1.00, 1.3.2004
//
// 27.09.2008 - bug fixes
/* ===========================================================================*/

// ------------------------ Per Site Definitions ------------------------------

function ldm_flashsites() {

	return array(

"DailyMotion" => array(
	"pattern" => "#http://www.dailymotion.com/video/#i",
	"templatefunc" => "ldm_FlashSite_DailyMotion",
	"iconpattern" => "#www.dailymotion.com/video#",
	"icon" => "dailymotion",
	"recordhitnow" => 1,
	),

"ThatVideoSite" => array(
	"pattern" => "#http://www.thatvideosite.com/video/\d+#i",
	"templatefunc" => "ldm_FlashSite_thatvideosite",
	"iconpattern" => "#www.thatvideosite.com/video#",
	"icon" => "flv",
	"recordhitnow" => 1,
	),

"VSocial" => array(
	"pattern" => "#http://www.vsocial.com/video/\?d=([-\d]+)#i",
	"urlreplace" => "http://static.vsocial.com/flash/ups.swf?d=$1&a=1",
	"iconpattern" => "#www.vsocial.com/video#",
	"icon" => "vsocial",
	"recordhitnow" => 1,
	"template" => '
<embed
	src="$linkurl" wmode="transparent" style="height:{$player_height}px; width:{$player_width}px;" />
',
	),

// DailyMotion & ThatVideoSite embedding do not work; vSocial has limited use since it's a paid service

"Sharkle" => array(
	"pattern" => "#http://www.sharkle.com/video/\d+#i",
	"templatefunc" => "ldm_FlashSite_sharkle",
	"iconpattern" => "#www.sharkle.com/video#",
	"icon" => "sharkle",
	"recordhitnow" => 1,
	),

"MetaCafe" => array(
	"pattern" => "#http://www.metacafe.com/watch/([-\d]+)/([^/]+)/#i",
	"urlreplace" => "$1/$2.swf",
	"iconpattern" => "#www.metacafe.com/watch#",
	"icon" => "metacafe",
	"recordhitnow" => 1,
	"template" => '
<embed src="http://www.metacafe.com/fplayer/$linkurl" wmode="transparent" style="height:{$player_height}px; width:{$player_width}px;" />
',
	),

"Spike" => array(
	"pattern" => "#http://www.spike.com/video/.+/([-\d]+)#i",
	"urlreplace" => "$1",
	"iconpattern" => "#www.spike.com/video#",
	"icon" => "spike",
	"recordhitnow" => 1,
	"template" => '

<embed
	type="application/x-shockwave-flash"
	src="http://www.spike.com/efp"
	movie="$linkurl"
	width="$player_width"
	height="$player_height"
	wmode="transparent"
	quality="high"
	bgcolor="000000"
	name="efp"
	flashvars="flvbaseclip=$linkurl"
	allowFullScreen="true"
	allowScriptAccess="sameDomain"
	pluginspage="http://www.macromedia.com/go/getflashplayer" />
',
	),

"StreetFire" => array(
	"pattern" => "#http://videos.streetfire.net/video/([-a-zA-Z0-9]+)\.htm#i",
	"urlreplace" => "$1",
	"iconpattern" => "#videos.streetfire.net/video#",
	"icon" => "streetfire",
	"recordhitnow" => 1,
	"template" => '

<embed
	src="http://videos.streetfire.net/vidiac.swf"
	FlashVars="video=$linkurl"
	quality="high"
	bgcolor="#ffffff"
	width="$player_width"
	height="$player_height"
	wmode="transparent"
	name="ePlayer"
	align="middle"
	allowScriptAccess="sameDomain"
	type="application/x-shockwave-flash"
	pluginspage="http://www.macromedia.com/go/getflashplayer" />
',
	),

"Vidiac" => array(
	"pattern" => "#http://www.vidiac.com/.+/([-a-zA-Z0-9]+).htm#i",
	"urlreplace" => "$1",
	"iconpattern" => "#www.vidiac.com/#",
	"icon" => "flv",
	"recordhitnow" => 1,
	"template" => '

<embed
	src="http://www.vidiac.com/vidiac.swf"
	FlashVars="video=$linkurl"
	quality="high"
	bgcolor="#ffffff"
	width="$player_width"
	height="$player_height"
	wmode="transparent"
	name="ePlayer"
	align="middle"
	allowScriptAccess="sameDomain"
	type="application/x-shockwave-flash"
	pluginspage="http://www.macromedia.com/go/getflashplayer" />
',
	),

"Veoh" => array(
	"pattern" => "#http://www.veoh.com/videos/([a-z0-9]*)#i",
	"urlreplace" => "$1",
	"iconpattern" => "#www.veoh.com/videos#",
	"icon" => "veoh",
	"recordhitnow" => 1,
	"template" => '

<embed
	src="http://www.veoh.com/videodetails.swf?permalinkId=$linkurl&id=1&player=videodetails&videoAutoPlay=1"
	width="$player_width"
	height="$player_height"
	wmode="transparent"
	bgcolor="#000000"
	type="application/x-shockwave-flash"
	pluginspage="http://www.macromedia.com/go/getflashplayer" />
',
	),

"MySpace" => array(
	"pattern" => "#http://vids.myspace.com/index.cfm\?fuseaction=vids.individual&videoID=([0-9]+)#i",
	"urlreplace" => "$1",
	"iconpattern" => "#vids.myspace.com/index.cfm#",
	"icon" => "myspace",
	"recordhitnow" => 1,
	"template" => '

<embed
	src="http://lads.myspace.com/videos/vplayer.swf" type="application/x-shockwave-flash"
flashvars="e=http%3A//vids.myspace.com/index.cfm%3Ffuseaction%3Dvids.individual%26VideoID%3D$linkurl&culture=en-GB&a=1&ap=1&y=1&m=$linkurl&type=video"
	width="$player_width"
	height="$player_height"
	wmode="transparent"
	allowFullScreen="true"
	allowScriptAccess="sameDomain"
	quality="high"
	bgcolor="#000000"
	name="vplayer" />
',
	),

"PutFile" => array(
	"pattern" => "#http://media.putfile.com/(.+)#i",
	"urlreplace" => "$1",
	"iconpattern" => "#media.putfile.com/#",
	"icon" => "flv",
	"recordhitnow" => 1,
	"template" => '

<object
	type="application/x-shockwave-flash"
	data="http://feat.putfile.com/flow/putfile.swf?videoFile=$linkurl"
	height="$player_height"
	width="$player_width">
	<param name="wmode" value="transparent" />
	<param name="movie" value="http://feat.putfile.com/flow/putfile.swf?videoFile=$linkurl" />
<embed
	src="http://feat.putfile.com/flow/putfile.swf?videoFile=$linkurl"
	allowFullScreen="true"
	allowScriptAccess="sameDomain"
	align="middle"
	quality="high"
	height="$player_height"
	width="$player_width"
	wmode="transparent" />
	<em>If you can see this, then the site is down or Flash is not installed.</em>
</object>
',
	),

"Google" => array(
	"pattern" => "#http://video.google.com/videoplay\?docid=([-\d]+)#i",
	"urlreplace" => "http://video.google.com/googleplayer.swf?docid=$1",
	"iconpattern" => "#video.google.com/videoplay#",
	"icon" => "google",
	"recordhitnow" => 1,
	"template" => '

<object
	type="application/x-shockwave-flash"
	width="$player_width"
	height="$player_height"
	data="$linkurl">
	<param name="movie" value="$linkurl" />
	<param name="wmode" value="transparent" />
<embed
	movie="$linkurl"
	data="$linkurl"
	wmode="transparent"
	width="$player_width"
	height="$player_height"
	align="middle"
	bgcolor="#000000"
	allowFullScreen="true"
	allowScriptAccess="sameDomain"
	type="application/x-shockwave-flash"
	playerMode="normal"
	autoPlay="true"
	pluginspage="http://www.macromedia.com/go/getflashplayer" />
	<em>If you can see this, then the site is down or Flash is not installed.</em>
</object>
',
	),

"YouTube" => array(
    "pattern" => "#http://([a-z]+.youtube|youtube)\.com/watch\?v=([\w-]+)#i",
    "urlreplace" => "http://$1.com/v/$2",
	"iconpattern" => "#[a-z]+.youtube.com/watch#",
	"icon" => "youtube",
	"recordhitnow" => 1,
	"template" => '

<object
	type="application/x-shockwave-flash"
	width="$player_width"
	height="$player_height"
	data="$linkurl">
	<param name="movie" value="$linkurl" />
	<param name="wmode" value="transparent" />
<embed
	movie="$linkurl"
	data="$linkurl"
	wmode="transparent"
	width="$player_width"
	height="$player_height"
	align="middle"
	bgcolor="#000000"
	allowFullScreen="true"
	allowScriptAccess="sameDomain"
	type="application/x-shockwave-flash"
	playerMode="normal"
	autoPlay="true"
	pluginspage="http://www.macromedia.com/go/getflashplayer" />
	<em>If you can see this, then the site is down or you don"t have Flash installed.</em>
</object>
',
	),
	);
}

// ------------------------ Sit-specific handlers --------------------------------------

function ldm_FlashSite_DailyMotion($linkurl) {
	require_once(DIR . '/includes/local_links_misc.php');
	$content = ldm_fetch_page($linkurl);

	if (preg_match('#\<input id="video_player_embed_code_text" (.+?)\/\>#i', $content, $match)) {
		$tostrip = preg_replace('#value="([^"]+)"#i', '\1', $match[1]);
		$tostrip = html_entity_decode($tostrip);
		$tostrip = preg_replace('#.*(\<object.*object\>).*#i', '\1', $tostrip);
		$tostrip = preg_replace("#\<(param|embed)#i", "\n<$1", $tostrip);
		$tostrip = str_replace('"', '\"', $tostrip);
		return html_entity_decode($tostrip);
	}
	return "";
}

function ldm_FlashSite_thatvideosite($linkurl) {
	require_once(DIR . '/includes/local_links_misc.php');
	$content = ldm_fetch_page($linkurl);
	if (preg_match("#(<embed src='http://thatvideosite.voxcdn.com/.*?</embed>)#i", $content, $match)) {
		return $match[1];
	}
	return "";
}

function ldm_FlashSite_sharkle($linkurl) {
	require_once(DIR . '/includes/local_links_misc.php');
	$content = ldm_fetch_page($linkurl);
	if (preg_match("#(<embed.*?http://www.sharkle.com/externalPlayer.*?</embed>)#i", $content, $match)) {
		return $match[1];
	}
	return "";
}

// ------------------------ General Code --------------------------------------

function ldm_FlashSite_id($playerid, $linkid, $linkurl, $filetype) {

	$flashsites = ldm_flashsites();

	foreach ($flashsites as $thissite) {
		if (preg_match($thissite['pattern'], $linkurl)) {
			return $playerid;
		}
	}

	return -1;
}

function ldm_FlashSite_bit($playerid, $linkid, $linkurl) {
	global $ldm_players, $LINK_OK, $STREAM_SCRIPT;
	global $vbulletin;

	$flashsites = ldm_flashsites();
	$url = "";
	$template = "";

	$thisplayer = $ldm_players[$playerid];
	$thisplayer_vars = (isset($thisplayer['vars']) ? $thisplayer['vars'] : "");
	foreach ($thisplayer["vars"] as $thisvar=>$thisval) {
		${$thisvar} = $thisval;
	}

	$recordhitnow = 0;
	foreach ($flashsites as $thissite) {
		if (preg_match($thissite['pattern'], $linkurl)) {
			if ($thissite['templatefunc']) {
				$templatefunc = $thissite['templatefunc'];
				$template = $templatefunc($linkurl);
			}
			elseif ($thissite['usetemplate']) {
				$template = fetch_template($thissite['usetemplate']);
			}
			elseif ($thissite['template']) {
				$template = str_replace("\\'", "'", addslashes($thissite['template']));
			}
			if ($thissite['urlpatchfunc']) {
				$urlpatchfunc = $thissite['urlpatchfunc'];
				$linkurl = $urlpatchfunc($linkurl);
			}
			elseif ($thissite['urlreplace']) {
				$linkurl = preg_replace($thissite['pattern'], $thissite['urlreplace'], $linkurl);
			}
			if ($thissite["vars"]) {
				foreach ($thissite["vars"] as $thisvar=>$thisval) {
					${$thisvar} = $thisval;
				}
			}
			$recordhitnow = $thissite['recordhitnow'];
			break;
		}
	}

// Over-ride instruction to stream if force_redirect is set to non-zero value
	$howtostream = (isset($thisplayer['player_stream']) ? $thisplayer['player_stream'] : "url");
	if ($howtostream=="stream") {
		if (ldm_lookup_setting($catid, 'force_redirect')>0) {
			$howtostream = "url";
		}
	}

	$player_stream = $linkurl;

	$thisplayer_urlencode = (isset($thisplayer['urlencode']) ? $thisplayer['urlencode'] : "");
	if ($thisplayer_urlencode) {
		$player_stream = urlencode($player_stream);
	}

	if ($recordhitnow) {
		$hit = ldm_record_hit($linkid, $linkurl, $LINK_OK); // currently do not try to track bandwidth
	}

	eval("\$playerbit_player = \"$template\";");

	return $playerbit_player;

}

function ldm_FlashSite_headbit($playerid, $linkid, $linkurl) {
	global $ldm_players, $LINK_OK;
	global $vbulletin;

	$flashsites = ldm_flashsites();
	$url = "";
	$template = "";

	$recordhitnow = 0;
	foreach ($flashsites as $thissite) {
		if (preg_match($thissite['pattern'], $linkurl)) {
			if ($thissite['useheadertemplate']) {
				$template = fetch_template($thissite['useheadertemplate']);
			}
			elseif ($thissite['headertemplate']) {
				$template = str_replace("\\'", "'", addslashes($thissite['template']));
			}
			break;
		}
	}

	$thisplayer = $ldm_players[$playerid];
	$thisplayer_vars = (isset($thisplayer['vars']) ? $thisplayer['vars'] : "");
	foreach ($thisplayer["vars"] as $thisvar=>$thisval) {
		${$thisvar} = $thisval;
	}

	eval("\$playerbit_header = \"$template\";");

	return $playerbit_header;

}

function ldm_FlashSite_typebit($linkurl) {
	$flashsites = ldm_flashsites();

	foreach ($flashsites as $thissite) {
		if (preg_match($thissite['iconpattern'], $linkurl)) {
			return $thissite['icon'];
		}
	}

	return "";
}

?>