<?php

require_once('./global.php');
require_once(DIR . '/includes/local_links_init.php');
require_once(DIR . '/includes/local_links_bitcache.php');

($hook = vBulletinHook::fetch_hook('ldm_vba_tot_module')) ? eval($hook) : false;

$pageident = "ldmtot";
$cachebit = "LDM_vba_".$pageident;

if (!ldm_fetch_cachedbit($cachebit, $totals, $nhits)) { // nhits is just used as a dummy argument

    $rec = intval($mod_options["portal_ldm_tot_days_seen"]);

    if ($rec) {
	    $NUMDAYS = $rec;
    	$start = TIMENOW - $NUMDAYS*24*60*60; // 30 days
    } elseif ($vbulletin->userinfo['lastvisit']) {
	    $start = $vbulletin->userinfo['lastvisit'];
    	$NUMDAYS = round((TIMENOW-$start)/(24*60*60));
    } else {
	    $NUMDAYS = 30;
    	$start = TIMENOW - $NUMDAYS*24*60*60; // 30 days
    }

    $rec = $vbulletin->db->query_first("
	    	SELECT COUNT(catid) AS cats
		    FROM ".THIS_TABLE."linkscat
		    ");
    $rec_cats = $rec['cats'];

    $rec = $vbulletin->db->query_first("
	    	SELECT COUNT(linkid) AS links
		    FROM ".THIS_TABLE."linkslink
	    	");
    $rec_links = $rec['links'];

    $rec = $vbulletin->db->query_first("
	    	SELECT COUNT(linkid) AS links
		    FROM ".THIS_TABLE."linkslink
    		WHERE linkdate>=".intval($start)
	    	);
    $rec_linksnew = $rec['links'];

    $rec = $vbulletin->db->query_first("
	    	SELECT COUNT(lrate) AS comments
		    FROM ".THIS_TABLE."linksrate
		    WHERE ltime>=".intval($start)
		    );
    $rec_comments = $rec['comments'];

    $rec = $vbulletin->db->query_first("
		SELECT COUNT(dlid) AS hits, SUM(bytes) AS tbytes
		FROM ".THIS_TABLE."linksdownloads
		WHERE usertime>=".intval($start)."
		AND linkid>0
		");
    $rec_hits = $rec['hits'];

    if (!$rec['tbytes']) {
	    $rec_served = '0 K'.$vbphrase['bytes'];
    } elseif ($rec['tbytes']<1024) {
	    $rec_served = $rec['tbytes'].' '.$vbphrase['bytes'];
    } else {
	    $rec['tbytes'] = $rec['tbytes']/1024;
	    if ($rec['tbytes']<1024) {
		    $rec_served = intval(round($rec['tbytes'])).' K'.$vbphrase['bytes'];
	    } else {
		    $rec['tbytes'] /= 1024;
		    if ($rec['tbytes']<10) {
			    $rec_served = round($rec['tbytes'], 2).' M'.$vbphrase['bytes'];
		    }
		    elseif ($rec['tbytes']<1024) {
			    $rec_served = round($rec['tbytes'], 1).' M'.$vbphrase['bytes'];
		    }
		    elseif ($rec['tbytes']<10240) {
			    $rec_served = round($rec['tbytes']/1024, 2).' G'.$vbphrase['bytes'];
		    }
		    else {
			    $rec_served = round($rec['tbytes']/1024, 1).' G'.$vbphrase['bytes'];
		    }
    	}
    }

    $collapseobj_custom_ldm_tot = $vbcollapse['collapseobj_custom_ldm_tot'];
    $collapseimg_custom_ldm_tot = $vbcollapse['collapseimg_custom_ldm_tot'];

    eval('$totals = "' . fetch_template('adv_portal_custom_ldm_tot') . '";');

    ldm_store_cachedbit($cachebit, $totals, count($totals));

}

$home[$mods['modid']]['content'] .= $totals;

?>
