<?php

// vbadvanced module which list the most recently reviewed entries in the database, naming the submitter rather than the reviewer

require_once('./global.php');
require_once(DIR . '/includes/local_links_init.php');
require_once(DIR . '/includes/local_links_include.php');
require_once(DIR . '/includes/local_links_bitcache.php');

($hook = vBulletinHook::fetch_hook('ldm_vba_newly_reviewed_module')) ? eval($hook) : false;

$pageident = "ldmreviews";
$cachebit = "LDM_vba_".$pageident;

if (!ldm_fetch_cachedbit($cachebit, $links, $nhits)) {

    $categories = "";

    if ($mod_options['portal_ldm_newly_reviewed_showcategories']) {
	    $categories = preg_replace("/[^0-9,]/", "", $mod_options['portal_ldm_newly_reviewed_showcategories']);
    }

    if ($mod_options['portal_ldm_newly_reviewed_showsubcats']) {
	    $catparents = explode(',', $categories);
    	foreach ($GLOBALS['linkscat'] as $thiscat) {
	    	$cplist = explode(',', $thiscat['parentlist']);
		    foreach ($catparents as $cp) {
			    if (in_array($cp, $cplist)) {
				    $categories .= ",".$thiscat['catid'];
    			}
	    	}
    	}
    }

    $query = "
	    SELECT
		lrate.ltime AS lwhenrated, lrate.linkvote AS linkvote,
		links.linkid AS linkid, links.linkname AS linkname, links.linkstatus AS linkstatus,
		links.linkuserid AS linkuserid, links.linkusername AS linkusername,
		ltoc.catid AS catid,
		lcat.catname AS linkcatname
	    FROM ".THIS_TABLE."linksrate AS lrate
	    LEFT JOIN ".THIS_TABLE."linkslink AS links
	    ON lrate.linkid=links.linkid
	    LEFT JOIN ".THIS_TABLE."linksltoc AS ltoc
	    ON lrate.linkid=ltoc.linkid
	    LEFT JOIN ".THIS_TABLE."linkscat AS lcat
	    ON ltoc.catid=lcat.catid
	    ";

    if ($categories) {
	    $query .= "
		    WHERE ltoc.catid IN (" . $categories . ")
		    ";
    }

    $query .= "
	    ORDER BY lrate.ltime DESC
    	LIMIT ".intval($mod_options["portal_ldm_newly_reviewed_showentries"])."
	    ";

    $links = "";
    $nhits = 0;
    $asb = $vbulletin->db->query_read($query);
    while ($rec = $vbulletin->db->fetch_array($asb)) {
	    $linkid = $rec['linkid'];
    	$catid = $rec['catid'];
    	$linkname = $rec['linkname'];
    	$linkuserid = $rec['linkuserid'];
    	$linkusername = $rec['linkusername'];
    	$linkcatname = $rec['linkcatname'];
    	$linkstatus = $rec['linkstatus'];
    	$linkvote = ($rec['linkvote'] ? $rec['linkvote'] : 0);
    	$linkhits = ldm_get_imagebit($stylevar['imgdir_rating'].'/rating_'.$linkvote.'.gif', $linkvote);
		$linkshortname = fetch_trimmed_title(ldm_kill_bbcodes($linkname), $links_defaults['length_shortdesc'], 1);
    	$linkurlshortlink = ldm_get_url_atag(-1, $catid, $linkid, $linkshortname);
    	eval("\$links .= \"".fetch_template("adv_portal_custom_ldm_newly_reviewed_one")."\";");
        $nhits++;
    }

    ldm_store_cachedbit($cachebit, $links, $nhits);
}

$collapseobj_custom_ldm_newly_reviewed = $vbcollapse['collapseobj_custom_ldm_newly_reviewed'];
$collapseimg_custom_ldm_newly_reviewed = $vbcollapse['collapseimg_custom_ldm_newly_reviewed'];

eval('$home[$mods[\'modid\']][\'content\'] .= "' . fetch_template('adv_portal_custom_ldm_newly_reviewed') . '";');

?>
