<?php

// VBadvanced module to list newest categories

require_once('./global.php');
require_once(DIR . '/includes/local_links_init.php');
require_once(DIR . '/includes/local_links_include.php');
require_once(DIR . '/includes/local_links_vbafunc.php');
require_once(DIR . '/includes/local_links_bitcache.php');

($hook = vBulletinHook::fetch_hook('ldm_vba_newcats_module')) ? eval($hook) : false;

$pageident = "ldmnewcats";
$pagenumber = max(intval($_REQUEST[$pageident]), 1);
$cachebit = "LDM_vba_".$pageident."_".$pagenumber;

if (!ldm_fetch_cachedbit($cachebit, $cats, $ncats)) {

    $limitfids = ldm_lookup_forum_protections($links_permissions['can_see_protected_links_on_portal']);
    $sort = 'N';

    $maxcat = intval($mod_options["portal_ldm_newcats_showentries"]);
    $numcol = intval($mod_options["portal_ldm_newcats_showperrow"]);

    if (!isset($linkscat)) {
	    $cattree = $GLOBALS['linkscat'];
    }
    else {
	    $cattree = $linkscat;
    }

    $catlist = str_replace(" ", "", $mod_options["portal_ldm_newcats_showcategories"]);
    if ($catlist) {
        $catlist = explode(",", str_replace(" ", "", $mod_options["portal_ldm_newcats_showcategories"]));
        $ncats = count($catlist);
    }
    else {
        $catlist = array();
        $ncats = count($cattree);
    }

    $startat = ($pagenumber-1)*$maxcat + 1;
    $endat   = $startat + $maxcat - 1;

    $links_permissions['can_edit_category'] = 0;

    if (!function_exists('ldm_newcats_cmp')) {
	    function ldm_newcats_cmp($a, $b) {
		    global $cat_list;
		    return ($a['catdate']<$b['catdate']) ? 1 : -1;
	    }
    }

    usort($cattree, "ldm_newcats_cmp");

    $catlistarray = array();
    $numcat = 0;
    foreach ($cattree AS $lc) {
        if (count($catlist) and !in_array($lc['catid'], $catlist)) {
            continue;
        }
	    $numcat++;
	    if ($numcat<$startat) {
	        continue;
	    }
	    if ($numcat>$endat) {
	        break;
	    }
	    ldm_get_categorybits($catlistarray, 'adv_portal_custom_ldm_newcats_one', 'links_subcatbit', $lc['catid'], 0, 0);
    }
    $cats = ldm_map_listbit_to_vba_grid($catlistarray, $numcol);

    ldm_store_cachedbit($cachebit, $cats, $ncats);

}

if ($mod_options["portal_ldm_newcats_showpagenav"]) {
	$ldm_thesegot = array();
	foreach ($_GET as $thisget=>$thisgot) {
		if ($thisget!=$pageident and preg_match("/^(pageid|ldm)/", $thisget)) {
			$ldm_thesegot[] = "$thisget=$thisgot";
		}
	}
	$ldm_script = "";
	if (count($ldm_thesegot)) {
		$ldm_script = "&amp;".implode('&amp;', $ldm_thesegot);
	}
	$ldm_pagenavpages = $GLOBALS['vbulletin']->options['pagenavpages'];
	$GLOBALS['vbulletin']->options['pagenavpages'] = 2;
	$ldm_newcats_pagenav = construct_page_nav($pagenumber, $mod_options["portal_ldm_newcats_showentries"], $ncats, $_SERVER['PHP_SELF'].'?', $ldm_script);
	$ldm_newcats_pagenav = preg_replace("/page=/", $pageident."=", $ldm_newcats_pagenav);
	$ldm_newcats_pagenav = preg_replace("/<td.*?<a name=\"PageNav\"><.a><.td>/", "", $ldm_newcats_pagenav);
	$GLOBALS['vbulletin']->options['pagenavpages'] = $ldm_pagenavpages;
}

$colspan = 2*$mod_options["portal_ldm_newcats_showperrow"]-1;
$mods['colspan'] = $colspan;

$collapseobj_custom_ldm_new_cats = $vbcollapse['collapseobj_custom_ldm_new_cats'];
$collapseimg_custom_ldm_new_cats = $vbcollapse['collapseimg_custom_ldm_new_cats'];

eval('$home[$mods[\'modid\']][\'content\'] .= "' . fetch_template('adv_portal_custom_ldm_newcats') . '";');
unset($cats, $catlistarray, $collapseobj_custom_ldm_cats, $collapseimg_custom_ldm_cats);

?>
