<?php
// ++=========================================================================++
// || vBadvanced CMPS v3.2.1 (для vBulletin 3.6 - 3.8) - Русская версия
// || © 2003-2009 vBadvanced.com - Все права защищены
// || Русский перевод: Lazek и zCarot
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_template.php');
require_once(DIR . '/includes/adminfunctions_language.php');
require_once(DIR . '/includes/vba_cmps_adminfunctions.php');

$scriptname = 'CMPS';
$scriptfile = 'vbacmps_install';

define('PRODUCT_CODE', 'adv_cmps');

define('IS_VB_37', (in_array(substr($vbulletin->options['templateversion'], 0, 3), array(3.7, 3.8))) ? true : false);

print_cp_header('Установка vBadvanced ' . $scriptname . '', '', '<style type="text/css">
<!--
.redalert
{
	background: #FF0000;
	color: #000000;
}
-->
</style>');

if (!in_array(substr($vbulletin->options['templateversion'], 0, 3), array(3.6, 3.7, 3.8)))
{
	echo 'По всей видимости, вы пытаетесь установить версию vBadvanced ' . $scriptname . ' для vBulletin 3.6-3.8 на более старую версию vBulletin.<br />Пожалуйста, зайдите на <a href="http://www.vbadvanced.com/" target="_blank">vbadvanced.com</a> и скачайте версию vBadvanced ' . $scriptname . ', которая соответствует вашей версии vBulletin.';
	exit;
}

if (!is_object($db))
{
	echo 'По всей видимости, вы пытаетесь установить версию vBadvanced ' . $scriptname . ' для форума vBulletin 3.6-3.8 на vBulletin 3.0.<br />Пожалуйста, зайдите на <a href="http://www.vbadvanced.com/" target="_blank">vbadvanced.com</a> и скачайте версию для vBulletin 3.0.';
	exit;
}

if (!$_REQUEST['do'])
{
	$_REQUEST['do'] = 'installstart';
}

?>

<script type="text/javascript">
<!--

function safeSubmit(formobj)
{
	if (document.all || document.getElementById)
	{
		for (i = 0; i < formobj.length; i++)
		{
			var tempobj = formobj.elements[i];
			if (tempobj.type == 'submit')
			{
				tempobj.disabled = true;
			}
		}
	}
}
-->
</script>

<?php

// ##################### Delete Template Function #####################
function kill_template($title, $printphrase = 0)
{
	global $db;

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "template WHERE title = '$title'");

	return '<div class="smallfont">Удален шаблон ' . $title . '</div>';
}

// ##### Insert all templates #################################################
function insert_all_templates()
{
	global $maintemplates, $db;

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "template WHERE title IN('" . implode("', '", array_keys($maintemplates)) . "') AND styleid = '-1'");

	$tversions = array(
		'adv_portal' => '3.2.1',
		'adv_portal_dragdrop_headinc' => '3.2.1',
		'adv_portal_module_wrapper' => '3.2.0',
		'adv_portal_newsbits' => '3.1.0',
		'adv_portal_newsbits_attach_thumb' => '3.1.0'
	);

	foreach ($maintemplates AS $name => $content)
	{
		$tempinsert .= "(
			'$name',
			'" . $db->escape_string(compile_template($content)) . "',
			'" . $db->escape_string($content) ."',
			'-1',
			'template',
			" . TIMENOW . ",
			'vBadvanced',
			'" . iif($tversions[$name], $tversions[$name], '3.0.0') . "',
			'" . PRODUCT_CODE . "'
		),";
	}

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "template
			(title, template, template_un, styleid, templatetype, dateline, username, version, product)
		VALUES
			" . substr($tempinsert, 0, strlen($tempinsert) - 1)
	);

}

// ##################### Insert Settings Function #####################
function insert_setting()
{
	global $db, $varname, $setting, $grouptitle;

	if (!$varname)
	{
		return false;
	}

	$checksetting = $db->query_first("SELECT varname FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$varname' AND grouptitle = '$grouptitle'");

	if ($checksetting['varname'])
	{
		return false;
	}

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "adv_setting
			(varname, grouptitle, value, defaultvalue, optioncode, displayorder, serialize)
		VALUES (
			'$varname',
			'" . $grouptitle . "',
			'" . $db->escape_string($setting['value']) . "',
			'" . $db->escape_string($setting['value']) . "',
			'" . $db->escape_string($setting['optioncode']) . "',
			" . $setting['displayorder'] . ",
			'$setting[serialize]'
	)");

	$phrasetypeid = 'vbsettings';

	return '<div class="smallfont">Добавлен параметр - ' . $title . '</div>';

}

// ##################### Update Settings Function #####################
function update_setting($phraseonly = false)
{
	global $db, $varname, $setting, $grouptitle;

	if (!$varname)
	{
		return false;
	}

	$oldvarname = $varname;

	$phrasetypeid = 'vbsettings';

	// Title phrase
	update_phrase('setting_' . $varname . '_title', $setting['title']);

	// Description phrase
	update_phrase('setting_' . $varname . '_desc', $setting['description']);

	if ($phraseonly)
	{
		return false;
	}

	$varname = $oldvarname;

	$db->query_write("
		UPDATE " . TABLE_PREFIX . "adv_setting SET
			defaultvalue = '" . $db->escape_string($setting['value']) . "',
			optioncode = '" . $db->escape_string($setting['optioncode']) . "',
			displayorder = $setting[displayorder],
			grouptitle = '$grouptitle',
			serialize = '$setting[serialize]'
		WHERE varname = '$varname' AND grouptitle = '$grouptitle'
	");

	return '<div>Обновлен параметр - ' . $varname . '</div>';
}

// ##### Rebuild All Settings #################################################
function rebuild_all_settings()
{
	global $db, $vba_modules, $mainsettings, $adv_settinggroups;
	global $grouptitle, $varname, $setting;

	// Need to update the phrases, so we might as well do it here
	// before we start adding duplicates to $mainsettings
	insert_all_phrases();

	// Settinggroups
	foreach ($adv_settinggroups AS $grouptitle => $order)
	{
		$db->query_write("
			INSERT IGNORE INTO " . TABLE_PREFIX . "adv_settinggroup
				(grouptitle, displayorder)
			VALUES (
				'$grouptitle',
				'$order'
		)");
	}

	// Link up the setting grouptitle by filename
	$modfilenames = array();
	foreach ($vba_modules AS $modid => $module)
	{
		if ($module['identifier'])
		{
			if ($module['parent'])
			{
				$module['filename'] .= '-child';
			}

			$modfilenames[$module['filename']] = $module['identifier'];
		}
	}

	$copiedmods = array();
	$extramods = $db->query_read("
		SELECT identifier, filename, parent
		FROM " . TABLE_PREFIX . "adv_modules
		WHERE identifier NOT IN('" . implode("', '", array_values($modfilenames)) . "')
		 AND filename IN('" . implode("', '", array_keys($modfilenames)) . "')
	");
	while ($emod = $db->fetch_array($extramods))
	{
		// Don't mix up the parent and child module's settings
		if ($emod['parent'])
		{
			$emod['filename'] .= '-child';
		}

		// Merge a new grouptitle into the $mainsettings array
		if (isset($modfilenames[$emod['filename']]) AND !empty($mainsettings['adv_portal_' . $modfilenames[$emod['filename']]]))
		{
			$mainsettings['adv_portal_' . $emod['identifier']] = $mainsettings['adv_portal_' . $modfilenames[$emod['filename']]];
		}
	}

	// Got all the settings, now process them
	foreach ($mainsettings AS $grouptitle => $settings)
	{
		$setcount += sizeof($settings);
		$insertsettings = '';
		$csetting = array();
		$getsettings = $db->query_read("
			SELECT varname FROM " . TABLE_PREFIX . "adv_setting
			WHERE grouptitle = '$grouptitle'
				AND varname IN('" . implode("', '", array_keys($settings)) . "')
		");
		while ($set = $db->fetch_array($getsettings))
		{
			$csetting[] = $set['varname'];

			$setting =& $mainsettings[$grouptitle][$set['varname']];

			// Go ahead and update it
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "adv_setting SET
					defaultvalue = '" . $db->escape_string($setting['value']) . "',
					optioncode = '" . $db->escape_string($setting['optioncode']) . "',
					displayorder = $setting[displayorder],
					grouptitle = '$grouptitle',
					serialize = '$setting[serialize]'
				WHERE varname = '$set[varname]' AND grouptitle = '$grouptitle'
			");
		}
		$csetting = array_diff(array_keys($settings), $csetting);

		// New settings
		if (!empty($csetting))
		{
			foreach ($csetting AS $cvarname)
			{
				$setting =& $mainsettings[$grouptitle][$cvarname];

				$insertsettings .= "(
					'$cvarname',
					'" . $grouptitle . "',
					'" . $db->escape_string($setting['value']) . "',
					'" . $db->escape_string($setting['value']) . "',
					'" . $db->escape_string($setting['optioncode']) . "',
					" . $setting['displayorder'] . ",
					'$setting[serialize]'
				),";
			}
		}

		if ($insertsettings)
		{
			$db->query_write("
				INSERT INTO " . TABLE_PREFIX . "adv_setting
					(varname, grouptitle, value, defaultvalue, optioncode, displayorder, serialize)
				VALUES
					" . substr($insertsettings, 0, strlen($insertsettings) - 1)
			);
		}
	}

	build_adv_settings();
}

// ##################### Delete Setting Function #####################
function kill_setting($printphrase = 0)
{
	global $db, $varname, $grouptitle;

	if ($grouptitle == 'adv_global')
	{
		return;
	}

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$varname' AND grouptitle = '$grouptitle'");

	kill_phrase('setting_" . $title . "_title');
	kill_phrase('setting_" . $title . "_desc');

	return '<div class="smallfont">Удален параметр - ' . $title . '</div>';
}

// ##### Insert Phrase Function ###############################################
function insert_phrase($forcevarname = '', $forcetext = '')
{
	global $db, $phrasetypeid, $varname, $text, $version;

	if ($forcevarname)
	{
		$varname = $forcevarname;
		$text = $forcetext;
	}

	kill_phrase();

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "phrase
			(languageid, varname, text, fieldname, product, username, dateline, version)
		VALUES (
			'-1',
			'" . $varname . "',
			'" . $db->escape_string($text) ."',
			'$phrasetypeid',
			'" . PRODUCT_CODE . "',
			'vBadvanced',
			" . TIMENOW . ",
			'$version'
	)");

	return '<div class="smallfont">Добавлена фраза - ' . $varname . '</div>';
}

// ##### Update Phrase Function ###############################################
function update_phrase($forcevarname = '', $forcetext = '')
{
	global $db, $varname, $text, $phrasetypeid, $version;

	if ($forcevarname)
	{
		$varname = $forcevarname;
		$text = $forcetext;
	}

	// Insert first, just to make sure it's really there
	$db->query_write("
		INSERT IGNORE INTO " . TABLE_PREFIX . "phrase
			(languageid, varname, text, fieldname, product, username, dateline, version)
		VALUES (
			'-1',
			'" . $varname . "',
			'" . $db->escape_string($text) ."',
			'$phrasetypeid',
			'" . PRODUCT_CODE . "',
			'vBadvanced',
			" . TIMENOW . ",
			'$version'
	)");

	$db->query_write("
		UPDATE " . TABLE_PREFIX . "phrase SET
			text = '" . $db->escape_string($text) ."',
			dateline = " . TIMENOW . ",
			version = '$version',
			username = 'vBadvanced'
		WHERE varname = '$varname'
			AND fieldname = '$phrasetypeid'
			AND product = '" . PRODUCT_CODE . "'
			AND languageid = '-1'
	");

	return '<div class="smallfont">Обновлена фраза - ' . $varname . '</div>';
}

// ##################### Delete Phrase Function #####################
function kill_phrase($forcevarname = '')
{
	global $db, $varname, $phrasetypeid;

	if ($forcevarname)
	{
		$varname = $forcevarname;
	}

	$db->query_write("
		DELETE FROM " . TABLE_PREFIX . "phrase
		WHERE varname = '$varname'
			AND fieldname = '$phrasetypeid'
			AND product = '" . PRODUCT_CODE . "'
			AND languageid = '-1'
	");

	return '<div class="smallfont">Удалена фраза ' . $varname . '</div>';
}

// ##### Complete Phrase Insert/Delete ########################################
function insert_all_phrases()
{
	global $db, $mainphrases, $mainsettings, $version;

	// Settings phrases
	foreach ($mainsettings AS $grouptitle => $settings)
	{
		foreach ($settings AS $varname => $setting)
		{
			$mainphrases['vbsettings']['setting_' . $varname . '_title'] = $setting['title'];
			$mainphrases['vbsettings']['setting_' . $varname . '_desc'] = $setting['description'];
		}
	}

	// Main phrases
	foreach ($mainphrases AS $fieldname => $phrases)
	{
		$db->query_write("
			DELETE FROM " . TABLE_PREFIX . "phrase
			WHERE fieldname = '$fieldname'
				AND varname IN('" . implode("','", array_keys($phrases)) . "')
				AND languageid = '-1'
		");

		$insertquery = '';
		foreach ($phrases AS $varname => $text)
		{
			$insertquery .= "('-1', '$varname', '" . $db->escape_string($text) . "', '$fieldname', '" . PRODUCT_CODE . "', 'vBadvanced', " . TIMENOW . ", '$version'),";
		}

		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "phrase
				(languageid, varname, text, fieldname, product, username, dateline, version)
			VALUES
				" . substr($insertquery, 0, strlen($insertquery) - 1)
		);
	}

	build_language(-1);

}

// ##### Print Form Header w/ js to disable button ############################
function print_js_form_header($file, $do)
{
	echo '<form action="' . $file . '.php" method="post" onsubmit="return safeSubmit(this)">
		<input type="hidden" name="adminhash" value="' . ADMINHASH . '" />';

	if ($do)
	{
		echo '<input type="hidden" name="do" value="' . $do . '" />';
	}

	print_table_start();
}

// ##### Install Table Start Function #########################################
function print_install_table_start($title = '', $reqdo = '')
{
	global $scriptfile, $scriptname;

	print_js_form_header($scriptfile, $reqdo);

	if (!$title)
	{
		$title = 'Установка vBadvanced ' . $scriptname . '';
	}

	print_table_header($title);
}

// ##### Install End Table Function ###########################################
function print_install_table_end()
{
	global $stepphrase, $scriptname, $step, $nextstep, $nextdo, $rebuildtemp, $nocontinue, $forumsoff;

	print_description_row('<div style="padding:12px;">' . $stepphrase . '</div>');

	if ($_REQUEST['do'] == 'installstart')
	{
		print_description_row('Основные опции', false, 2, 'thead');
		print_radio_row('', 'do', array(
				'install' => 'Установка.',
				'upgrade' => 'Обновление.',
				'uninstall' => 'Удаление.'
			), 'install');

		print_description_row('Обслуживание', false, 2, 'thead');
		print_radio_row('', 'do', array(
				'templates' => 'Обновление шаблонов.',
				'phrases' => 'Обновление фраз.',
				'rebuildsettings' => 'Обновление настроек',
				'updateplugins' => 'Обновление плагинов.',
				'doimages' => 'Обновление путей к изображениям.'
			));

	}

	construct_hidden_code('step', iif($nextstep, $nextstep, $step + 1));

	if ($nextdo != 'closeforums')
	{
		construct_hidden_code('forumsoff', $forumsoff);
	}

	if ($nextdo)
	{
		construct_hidden_code('do', $nextdo);
	}

	print_table_break();

	if ($rebuildtemp)
	{
		build_all_styles(0, 0);
	}

	if ($nocontinue)
	{
		print_table_footer();
	}
	else
	{
		print_submit_row('Продолжить', '');
	}
}

// ##### Check for and add indexes ############################################
function add_table_index($table, $column)
{
	global $db;
	$indexcheck = $db->query("SHOW KEYS FROM " . TABLE_PREFIX . $table);
	while ($icheck = $db->fetch_array($indexcheck))
	{
		if ($icheck['Column_name'] == $column AND $icheck['Seq_in_index'] == 1)
		{
			return;
		}
	}
	$db->query_write("ALTER TABLE " . TABLE_PREFIX . "$table ADD INDEX ($column)");
}

// ##### Insert Plugins #######################################################
function insert_plugins()
{
	global $db, $vba_plugins;

	$plugcheck = array();
	$getplugins = $db->query_read("
		SELECT devkey
		FROM " . TABLE_PREFIX . "plugin
		WHERE devkey IN('" . implode("', '", array_keys($vba_plugins)) . "')
	");
	while ($plugin = $db->fetch_array($getplugins))
	{
		$plugcheck[$plugin['devkey']] = true;
	}

	foreach ($vba_plugins AS $devkey => $plugin)
	{
		$plugin['devkey'] = $devkey;

		if (!$plugin['product'])
		{
			$plugin['product'] = PRODUCT_CODE;
		}
		$plugin['active'] = 1;

		// Setting this to 3 should prevent problems with vBSEO?
		// adv_cmps_init_startup plugin needs to be executed after adv_cmps_integrate_start

		switch ($devkey)
		{
			case 'adv_cmps_integrate_start':
				$plugin['executionorder'] = 1;
			break;

			case 'adv_cmps_init_startup':
				$plugin['executionorder'] = 2;
			break;

			default:
				$plugin['executionorder'] = 3;
		}

		$db->query_write(fetch_query_sql($plugin, 'plugin', iif($plugcheck[$devkey], "WHERE devkey = '$devkey'", '')));
	}

	vBulletinHook::build_datastore($db);
}

// ############################################################################
// Arrays
// ############################################################################

// ##### Templates ############################################################
$maintemplates = array(
'adv_portal' =>
'$stylevar[htmldoctype]
<html dir="$stylevar[textdirection]" lang="$stylevar[languagecode]" xmlns="http://www.w3.org/1999/xhtml">
<head>
<if condition="$pages[\'name\'] == \'home\'">
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Expires" content="0" />
</if>

<title>$vboptions[hometitle] <if condition="$pagetitle">- $pagetitle</if></title>

$headinclude

</head>
<body>

$header

$navbar

<if condition="$show[\'customizepagelink\']">
	<div align="$stylevar[right]" style="padding-top: $stylevar[cellpadding]px; padding-bottom: $stylevar[cellpadding]px">
		<if condition="$show[\'customizepage\']">
			[<a href="javascript: reset_cmps_layout($pages[pageid])">$vbphrase[reset_layout]</a>]
			[<a href="$show[customizepagelink]">$vbphrase[exit_customization_mode]</a>]
		<else />
			[<a href="$show[customizepagelink]">$vbphrase[customize_this_page]</a>]
		</if>
	</div>
</if>

<table align="center" class="page" cellspacing="0" cellpadding="0" width="100%">
	<tr valign="top">
		<if condition="$show[\'left_column\']">
			<td width="$vba_style[portal_leftcolwidth]"<if condition="$show[\'center_column\'] OR $show[\'right_column\']"> style="padding-$stylevar[right]: $vba_style[portal_colspacing]px"</if>>
				$home[leftblocks]
			</td>
		</if>
		<if condition="$show[\'center_column\']">
			<td valign="top">
				$home[centerblocks]
			</td>
		</if>
		<if condition="$show[\'right_column\']">
			<td valign="top" width="$vba_style[portal_rightcolwidth]"<if condition="$show[\'center_column\'] OR $show[\'left_column\']"> style="padding-$stylevar[left]: $vba_style[portal_colspacing]px"</if>>
				$home[rightblocks]
			</td>
		</if>
	</tr>
</table>

$footer

</body>
</html>',


'adv_portal_archivebits_exp' =>
'<tr>
	<if condition="$mod_options[\'portal_archive_showicon\']">
		<td class="alt2">
			<if condition="$show[\'threadicon\']">
				<img alt="" border="0" src="$news[threadiconpath]" title="$news[threadicontitle]" />
			</if>
		</td>
	</if>

	<td class="alt1" align="$stylevar[left]">
		<if condition="$news[\'subscribed\'] OR $show[\'paperclip\'] OR ($news[\'sticky\'] AND $mod_options[\'portal_archive_stickyicon\'])">
		<span style="float:$stylevar[right]">
			<if condition="$news[\'subscribed\']">
				<img alt="" class="inlineimg" src="$stylevar[imgdir_misc]/subscribed.gif" title="$vbphrase[you_are_subscribed_to_this_thread]" />
			</if>
			<if condition="$show[\'paperclip\']">
				<a href="#" onclick="vba_attach_win($news[threadid]); return false"><img class="inlineimg" src="$stylevar[imgdir_misc]/paperclip.gif" border="0" title="<phrase 1="$news[attach]">$vbphrase[x_attachments]</phrase>" alt="" /></a>
			</if>
			<if condition="$news[\'sticky\'] AND $mod_options[\'portal_archive_stickyicon\']">
				<img class="inlineimg" src="$stylevar[imgdir_misc]/sticky.gif" title="$vbphrase[sticky_thread]" alt="" />
			</if>
		</span>
		</if>
		<a href="$vboptions[bburl]/showthread.php?$session[sessionurl]t=$news[threadid]" title="$news[preview]">$news[title]</a>
		<if condition="$mod_options[\'portal_archive_multipage\'] AND $show[\'pagenav\']">
			<span class="smallfont">(<img class="inlineimg" src="$stylevar[imgdir_misc]/multipage.gif" border="0" alt="" /> $news[pagenav]<if condition="$show[pagenavmore]">... <a href="$vboptions[bburl]/showthread.php?$session[sessionurl]t=$news[threadid]&amp;page=$news[totalpages]">$vbphrase[last_page]</a></if>)</span>
		</if>
		<if condition="$news[\'rating\'] AND $mod_options[\'portal_archive_showrating\']">
			<span style="float:$stylevar[right]"><img alt="" src="$stylevar[imgdir_rating]/rating_$news[rating].gif" title="<phrase 1="$news[votenum]" 2="$news[voteavg]">$vbphrase[thread_rating_x_votes_y_average]</phrase>" /></span>
		</if>
		<if condition="$mod_options[\'portal_archive_threadstarter\']">
 			<div class="smallfont">
				<phrase 1="$vboptions[bburl]/member.php?$session[sessionurl]u=$news[postuserid]" 2="$news[postusername]">$vbphrase[by_x]</phrase>
			</div>
		</if>
		<if condition="$mod_options[\'portal_archive_showdate\']">
			<div class="smallfont">$news[postdate] <span class="time">$news[posttime]</span></div>
		</if>
	</td>

	<if condition="$show[\'lastpost\']">
		<td class="alt2">
			<div class="smallfont" style="text-align:$stylevar[right]; white-space:nowrap">
				$news[lastpostdate] <span class="time">$news[lastposttime]</span><br />
				<phrase 1="$vboptions[bburl]/member.php?$session[sessionurl]find=lastposter&amp;t=$news[threadid]" 2="$news[lastposter]">$vbphrase[by_x]</phrase> <a href="$vboptions[bburl]/showthread.php?$session[sessionurl]p=$news[lastpostid]#post$news[lastpostid]"><img alt="" border="0" src="$stylevar[imgdir_button]/lastpost.gif" title="$vbphrase[go_to_last_post]" /></a>
			</div>
		</td>
	</if>

	<if condition="$mod_options[\'portal_archive_showreplies\']">
		<td align="center" class="$class_reply"><span class="smallfont">$news[replycount]</span></td>
	</if>
	<if condition="$mod_options[\'portal_archive_showviews\']">
		<td align="center" class="$class_view"><span class="smallfont">$news[views]</span></td>
	</if>
	<if condition="$mod_options[\'portal_newsarchive_showforum\']">
		<td class="$class_ftitle">
			<span class="smallfont"><a href="$vboptions[bburl]/forumdisplay.php?$session[sessionurl]f=$news[forumid]">$news[forumtitle]</a></span>
		</td>
	</if>
</tr>',


'adv_portal_archivebits_exp_head' =>
'<tr>
	<if condition="$mod_options[\'portal_archive_showicon\']">
		<td class="thead" width="15">&nbsp;</td>
	</if>
	<td class="thead" width="100%">$vbphrase[title_username_date]</td>
	<if condition="$show[\'lastpost\']">
		<td align="center" class="thead" style="white-space: nowrap" width="25%">$vbphrase[last_post]</td>
	</if>
	<if condition="$mod_options[\'portal_archive_showreplies\']">
		<td class="thead" width="15">$vbphrase[replies]</td>
	</if>
	<if condition="$mod_options[\'portal_archive_showviews\']">
		<td class="thead" width="15">$vbphrase[views]</td>
	</if>
	<if condition="$mod_options[\'portal_newsarchive_showforum\']">
		<td align="center" class="thead" width="10%">$vbphrase[forum]</td>
	</if>
</tr>',


'adv_portal_archivebits_lean' =>
'<tr>
	<td class="$bgclass">
		<if condition="$show[\'paperclip\'] OR ($news[\'sticky\'] AND $mod_options[\'portal_archive_stickyicon\'])">
			<span style="float:$stylevar[right]">
				<if condition="$show[\'paperclip\']">
					<a href="#" onclick="vba_attach_win($news[threadid]); return false"><img class="inlineimg" src="$stylevar[imgdir_misc]/paperclip.gif" border="0" title="<phrase 1="$news[attach]">$vbphrase[x_attachments]</phrase>" alt="" /></a>
				</if>
				<if condition="$news[\'sticky\'] AND $mod_options[\'portal_archive_stickyicon\']">
					<img class="inlineimg" src="$stylevar[imgdir_misc]/sticky.gif" title="$vbphrase[sticky_thread]" alt="" />
				</if>
			</span>
		</if>
		<if condition="$news[threadiconpath] AND $mod_options[\'portal_archive_showicon\']">
			<img alt="" class="inlineimg" src="$news[threadiconpath]" border="0" title="$news[threadicontitle]" />
		</if>
		<if condition="$news[\'subscribed\'] AND $mod_options[\'portal_archive_showsubscribed\']">
			<img alt="" class="inlineimg" src="$stylevar[imgdir_misc]/subscribed.gif" title="$vbphrase[you_are_subscribed_to_this_thread]" />
		</if>
		<if condition="$news[\'rating\'] AND $mod_options[\'portal_archive_showrating\']">
			<span style="float:$stylevar[right]"><img alt="" src="$stylevar[imgdir_rating]/rating_$news[rating].gif" title="<phrase 1="$news[votenum]" 2="$news[voteavg]">$vbphrase[thread_rating_x_votes_y_average]</phrase>" /></span>
		</if>
		<span class="smallfont"><a href="$vboptions[bburl]/showthread.php?$session[sessionurl]t=$news[threadid]" title="$news[preview]">$news[title]</a></span>
		<if condition="$mod_options[\'portal_archive_multipage\'] AND $show[\'pagenav\']">
			<span class="smallfont">(<img class="inlineimg" src="$stylevar[imgdir_misc]/multipage.gif" border="0" alt="" /> $news[pagenav]<if condition="$show[pagenavmore]">... <a href="$vboptions[bburl]/showthread.php?$session[sessionurl]t=$news[threadid]&amp;page=$news[totalpages]">$vbphrase[last_page]</a></if>)</span>
		</if>
		<if condition="$mod_options[\'portal_archive_showdate\']">
			<div class="smallfont">$news[postdate] <span class="time">$news[posttime]</span></div>
		</if>
		<if condition="$mod_options[\'portal_archive_threadstarter\']">
 			<div class="smallfont">
				<phrase 1="$vboptions[bburl]/member.php?$session[sessionurl]u=$news[postuserid]" 2="$news[postusername]">$vbphrase[by_x]</phrase>
			</div>
		</if>
		<if condition="$mod_options[\'portal_newsarchive_showforum\']">
			<div class="smallfont" style="padding-top:$stylevar[cellpadding]px"><a href="$vboptions[bburl]/forumdisplay.php?$session[sessionurl]f=$news[forumid]">$news[forumtitle]</a></div>
		</if>
		<if condition="$show[\'lastpost\']">
			<div class="smallfont" style="padding-top:$stylevar[cellpadding]px">
				<a href="$vboptions[bburl]/showthread.php?$session[sessionurl]p=$news[lastpostid]#post$news[lastpostid]"><img class="inlineimg" alt="" border="0" src="$stylevar[imgdir_button]/lastpost.gif" title="$vbphrase[go_to_last_post]" /></a> $vbphrase[last_post_by] <a href="$vboptions[bburl]/member.php?$session[sessionurl]find=lastposter&amp;t=$news[threadid]">$news[lastposter]</a>
			</div>
			<div class="smallfont">$news[lastpostdate] <span class="time">$news[lastposttime]</span></div>
		</if>
		<if condition="$mod_options[\'portal_archive_showreplies\'] OR $mod_options[\'portal_archive_showviews\']">
			<div class="smallfont" style="padding-top:$stylevar[cellpadding]px">
				<if condition="$mod_options[\'portal_archive_showreplies\']">$news[replycount] $vbphrase[replies]</if>$archive_rep_view_comma
				<if condition="$mod_options[\'portal_archive_showviews\']">$news[views] $vbphrase[views]</if>
			</div>
		</if>
	</td>
</tr>',


'adv_portal_buddylistbits' =>
'<div class="smallfont" style="padding-bottom:2px">
	<span style="float:$stylevar[right]">
	<a href="$vboptions[bburl]/private.php?$session[sessionurl]do=newpm&amp;u=$loggedin[userid]" title="<phrase 1="$loggedin[username]">$vbphrase[send_private_message_to_x]</phrase>">$vbphrase[pm]</a>
	<a href="$vboptions[bburl]/profile.php?$session[sessionurl]do=removelist&amp;userlist=buddy&amp;u=$loggedin[userid]" title="$vbphrase[remove_from_buddy_list]">X</a>
	</span>
	<a href="$vboptions[bburl]/member.php?$session[sessionurl]u=$loggedin[userid]">$loggedin[username]</a> $loggedin[invisiblemark]
</div>',


'adv_portal_calendar_day' =>
'<td class="<if condition="$show[\'highlightweek\']">alt1<else />alt2</if>"<if condition="$show[\'highlighttoday\']"> style="border:solid 1px red; font-weight:bold" title="$vbphrase[today]"</if>>
	<span class="smallfont">
		<if condition="$show[\'daylink\']">
			<a href="$vboptions[bburl]/calendar.php?$session[sessionurl]do=getinfo&amp;day=$year-$month-$day&amp;c=$calendarid" title="$eventdesc">$day</a>
		<else />
			$day
		</if>
	</span>
</td>',


'adv_portal_calendar_day_other' =>
'<td class="alt1"><span class="smallfont">$day</span></td>',


'adv_portal_calendar_header' =>
'<tr>
	<if condition="$show[\'day1\']"><td align="center" class="thead">$day1</td></if>
	<if condition="$show[\'day2\']"><td align="center" class="thead">$day2</td></if>
	<if condition="$show[\'day3\']"><td align="center" class="thead">$day3</td></if>
	<if condition="$show[\'day4\']"><td align="center" class="thead">$day4</td></if>
	<if condition="$show[\'day5\']"><td align="center" class="thead">$day5</td></if>
	<if condition="$show[\'day6\']"><td align="center" class="thead">$day6</td></if>
	<if condition="$show[\'day7\']"><td align="center" class="thead">$day7</td></if>
</tr>
$calendarrowbits
',


'adv_portal_calendar_week' =>
'<tr align="center">
	$calendardaybits
</tr>
',


'adv_portal_dragdrop_headinc' =>
'<script type="text/javascript" src="<if condition="IS_VB_38">$stylevar[yuipath]<else />http://yui.yahooapis.com/2.7.0/build</if>/animation/animation-min.js"></script>
<script type="text/javascript" src="<if condition="IS_VB_38">$stylevar[yuipath]<else />http://yui.yahooapis.com/2.7.0/build</if>/dragdrop/dragdrop-min.js"></script>
<script type="text/javascript" src="$vboptions[bburl]/clientscript/vba_cmps_dd.js"></script>
<style type="text/css">
<!--
ul.draglist {
	border: 1px dashed gray;
	margin: 10px 0 10px 0;
	min-width: 40px;
	padding: 15px 5px 15px 5px;
	list-style: none;
	position: relative;
}

ul.draglist li {
	margin: 2px;
	cursor: move;
}

-->
</style>',


'adv_portal_footer' =>
'<!-- НЕ удаляйте копирайты правообладателя. Это нарушит пользовательское соглашение! -->

<div align="center" class="smallfont"><phrase 1="$vba_options[portal_version]">$vbphrase[powered_by_vbadvanced_cmps]</phrase></div>',


'adv_portal_moderation' =>
'<tr>
	<td class="$bgclass">
		<if condition="$show[\'threads\']">
			<div<if condition="$moditems[thread]"> style="font-weight: bold"</if>><a href="$vboptions[bburl]/moderation.php?$session[sessionurl]do=viewthreads&amp;type=moderated">$vbphrase[threads]</a> ($moditems[thread])</div>
		</if>
		<if condition="$show[\'posts\']">
			<div<if condition="$moditems[reply]"> style="font-weight: bold"</if>><a href="$vboptions[bburl]/moderation.php?$session[sessionurl]do=viewposts&amp;type=moderated">$vbphrase[posts]</a> ($moditems[reply])</div>
		</if>

		<if condition="$show[\'visitormessage\']">
			<div<if condition="$moditems[visitormessage]"> style="font-weight: bold"</if>><a href="$vboptions[bburl]/moderation.php?$session[sessionurl]do=viewvms&amp;type=moderated">$vbphrase[visitor_messages]</a> ($moditems[visitormessage])</div>
		</if>

		<if condition="$show[\'events\']">
			<div<if condition="$events[count]"> style="font-weight: bold"</if>><a href="$modcpdir/moderate.php?$session[sessionurl]do=events" target="_blank">$vbphrase[events]</a> ($events[count])</div>
		</if>
		<if condition="$show[\'attachments\']">
			<div<if condition="$attachments[count]"> style="font-weight: bold"</if>><a href="$modcpdir/moderate.php?$session[sessionurl]do=attachments" target="_blank">$vbphrase[attachments]</a> ($attachments[count])</div>
		</if>
		<div<if condition="$users[count]"> style="font-weight: bold"</if>><a href="$admincpdir/user.php?$session[sessionurl]do=moderate" target="_blank">$vbphrase[members]</a> ($users[count])</div>

		$template_hook[adv_portal_moderation]

	</td>
</tr>',


'adv_portal_module_wrapper' =>
'$mods[formcode]

<div style="padding-bottom:$vba_style[portal_vspace]px">
	<table align="center" border="0" cellpadding="$stylevar[cellpadding]" cellspacing="$stylevar[cellspacing]" class="tborder" width="100%">
		<thead>
			<tr>
				<td class="tcat" colspan="$mods[colspan]">
				<if condition="$vba_style[\'portal_collapsemods\']">
					<a href="#top" onclick="return toggle_collapse(\'module_$mods[collapse]\')" style="float:$stylevar[right]"><img alt="" border="0" id="collapseimg_module_$mods[collapse]" src="$stylevar[imgdir_button]/collapse_tcat$modimgcollapse.gif" /></a>
				</if>
				<span class="smallfont"><strong>$vba_style[portal_blockbullet] <if condition="$mods[\'link\']"><a href="$mods[link]">$mods[title]</a><else />$mods[title]</if></strong></span></td>
			</tr>
		</thead>
		<tbody id="collapseobj_module_$mods[collapse]" style="$modcollapse">
			<if condition="$show[\'tablerow\']">
				<tr>
					<td class="$bgclass">
						$modulehtml
					</td>
				</tr>
			<else />
				$modulehtml
			</if>
		</tbody>
	</table>
</div>
<if condition="$show[\'endform\']"></form></if>',


'adv_portal_navigation' =>
'<tr>
	<td class="$bgclass">
		$navigationbits
		$customnavigationbits
	</td>
</tr>',


'adv_portal_navigationbits' =>
'<div class="smallfont">$navmark <if condition="$link"><a href="$link">$title</a><else />$title</if></div>',


'adv_portal_newsbits' =>
'<if condition="!$mod_options[\'portal_news_legacy\']">
	<tr>
		<td class="thead"><if condition="$mod_options[\'portal_news_showicon\']">$vba_style[portal_blockbullet]</if> $news[prefix] <a href="$vboptions[bburl]/showthread.php?$session[sessionurl]t=$news[threadid]">$news[title]</a></td>
	</tr>
</if>
<tr>
	<td class="<if condition="$mod_options[\'portal_news_legacy\']">thead<else />alt2</if>">
		<if condition="($mod_options[\'portal_news_showrating\'] AND $news[\'rating\']) OR ($news[\'subscribed\'] AND $mod_options[\'portal_news_showsubscribed\'])">
			<span style="float:$stylevar[right]">
				<if condition="$mod_options[\'portal_news_showrating\'] AND $news[\'rating\']">
					<img alt="" src="$stylevar[imgdir_rating]/rating_$news[rating].gif" title="<phrase 1="$news[votenum]" 2="$news[voteavg]">$vbphrase[thread_rating_x_votes_y_average]</phrase>" />
				</if>

				<if condition="$news[\'subscribed\'] AND $mod_options[\'portal_news_showsubscribed\']">
					<img alt="" class="inlineimg" src="$stylevar[imgdir_misc]/subscribed.gif" title="$vbphrase[you_are_subscribed_to_this_thread]" />
				</if>
			</span>
		</if>
		$news[dateposted] - <phrase 1="$vboptions[bburl]/member.php?$session[sessionurl]u=$news[postuserid]" 2="$news[postusername]">$vbphrase[by_x]</phrase>
	</td>
</tr>
<tr>
	<td align="$stylevar[left]" class="alt1" valign="top">
		<if condition="$show[\'paperclip\']">
			<span style="float:$stylevar[right]">
				<a href="#" onclick="vba_attach_win($news[threadid]); return false"><img class="inlineimg" src="$stylevar[imgdir_misc]/paperclip.gif" border="0" title="<phrase 1="$news[attach]">$vbphrase[x_attachments]</phrase>" alt="" /></a>
			</span>
		</if>
		<if condition="$news[\'avatarpath\']">
			<img align="$stylevar[left]" style="padding:6px" alt="<phrase 1="$news[postusername]">$vbphrase[xs_avatar]</phrase>" border="0" src="$news[avatarpath]" />
		</if>
		$news[message]

		<if condition="$show[\'signature\']">
		<div>__________________<br />
		$news[signature]</div>
		</if>

		</td>
	</tr>

	<if condition="$news[\'attachment\']">
		<tr class="alt1">
			<td>
				<fieldset class="fieldset">
				<legend>Вложения</legend>
				<div style="padding:$stylevar[formspacer]px">
					$news[attachment]
				</div>
				</fieldset>
			</td>
		</tr>
	</if>

	<tr class="alt2" valign="middle">
	<td valign="middle">
		<span style="float:right">
		<if condition="$show[\'editbutton\']">
			<a href="$vboptions[bburl]/editpost.php?$session[sessionurl]do=editpost&amp;p=$news[postid]"><img alt="$vbphrase[edit_this_post]" border="0" src="$stylevar[imgdir_button]/edit.gif" /></a>
		</if>

		<if condition="$show[\'replybutton\']">
			<a href="$vboptions[bburl]/newreply.php?$session[sessionurl]do=newreply&amp;t=$news[threadid]"><img alt="$vbphrase[reply_to_this_post]" border="0" src="$stylevar[imgdir_button]/reply_small.gif" /></a>
		</if>

		<if condition="$mod_options[\'portal_news_showsendfriend\']">
			<a href="$vboptions[bburl]/sendmessage.php?$session[sessionurl]do=sendtofriend&amp;t=$news[threadid]"><img alt="" border="0" src="$stylevar[imgdir_button]/sendtofriend.gif" title="$vbphrase[send_to_friend]" /></a>
		</if>

		<if condition="$mod_options[\'portal_news_showprintable\']">
			<a href="$vboptions[bburl]/printthread.php?$session[sessionurl]t=$news[threadid]"><img alt="" border="0" src="$stylevar[imgdir_button]/printer.gif" title="$vbphrase[show_printable_version]" /></a>
		</if>
		</span>

		<span class="smallfont">
		<if condition="$mod_options[\'portal_news_allowreplies\']">$news[replycount] <if condition="$news[\'reply_noformat\'] == 1">$vbphrase[reply]<else />$vbphrase[replies]</if></if><if condition="$mod_options[\'portal_news_showviews\'] AND $mod_options[\'portal_news_allowreplies\']"> | </if><if condition="$mod_options[\'portal_news_showviews\']">$news[views] $vbphrase[views]</if></span>
	</td>
</tr>',


'adv_portal_newsbits_attach_inline' =>
'<div>
	<img class="inlineimg" src="$stylevar[imgdir_attach]/$attachment[attachmentextension].gif" alt="<phrase 1="$attachment[attachmentextension]">$vbphrase[file_type_x]</phrase>" width="16" height="16" border="0" style="vertical-align:baseline" /> <a href="$vboptions[bburl]/attachment.php?$session[sessionurl]attachmentid=$attachment[attachmentid]">$attachment[filename]</a>
	($attachment[filesize], <phrase 1="$attachment[counter]">$vbphrase[x_views]</phrase>)
</div>',


'adv_portal_newsbits_attach_thumb' =>
'<a href="$vboptions[bburl]/attachment.php?$session[sessionurl]attachmentid=$attachment[attachmentid]&amp;d=$attachment[dateline]" rel="Lightbox$lightboxid" id="attachment$attachment[attachmentid]"<if condition="$show[\'newwindow\']"> target="_blank"</if>><img src="$vboptions[bburl]/attachment.php?$session[sessionurl]attachmentid=$attachment[attachmentid]&amp;stc=1&amp;thumb=1&amp;d=$attachment[thumbnail_dateline]" class="thumbnail" border="0" alt="<phrase 1="$attachment[filename]" 2="$attachment[counter]" 3="$attachment[filesize]" 4="$attachment[attachmentid]">$vbphrase[image_larger_version_x_y_z]</phrase>" /></a> &nbsp;',


'adv_portal_onlineusers' =>
'<tr>
<td class="thead"><span class="smallfont"><phrase 1="$numberregistered" 2="$numberguest">$vbphrase[x_members_and_y_guests]</phrase></span></td>
	</tr>
	<tr>
		<td class="$altbgclass"><span class="smallfont">$activeusers</span></td>
	</tr>

	<tr>
		<td class="$bgclass"><span class="smallfont"><phrase 1="$recordusers" 2="$recorddate" 3="$recordtime">$vbphrase[most_users_ever_online_was_x_y_at_z]</phrase></span></td>
</tr>',


'adv_portal_poll' =>
'<tr>
	<td class="thead">$pollmod[question]</td>
</tr>

$pollbits

<tr>
	<td align="$stylevar[left]" class="$altbgclass">
		<if condition="$pollmod[\'showresults\']">
			<span class="smallfont"><strong>$vbphrase[total_votes]: $pollmod[nvotes]</strong><br />$pollmod[message].</span>
		<else />
			<input type="hidden" name="s" value="$session[dbsessionhash]" />
			<input type="hidden" name="do" value="pollvote" />
			<input type="hidden" name="pollid" value="$pollmod[pollid]" />
			<input type="submit" class="button" value="$vbphrase[vote_now]" />
			<if condition="$pollmod[\'public\'] AND $bbuserinfo[\'userid\']">
				<div class="smallfont">$vbphrase[public_poll_users_see_choices]</div>
			</if>
		</if>
	</td>
</tr>
<tr>
	<td class="$bgclass">
		<div class="smallfont">&raquo; <a href="$vboptions[bburl]/poll.php?$session[sessionurl]do=showresults&amp;pollid=$pollmod[pollid]">$vbphrase[view_poll_results]</a>
		<if condition="$mod_options[\'portal_poll_allowreplies\']">
			<br />&raquo; <a href="$vboptions[bburl]/newreply.php?$session[sessionurl]t=$pollmod[threadid]">$vbphrase[comment_on_this_poll]</a>
			<br />&raquo; <a href="$vboptions[bburl]/showthread.php?$session[sessionurl]t=$pollmod[threadid]">$vbphrase[this_poll_has] $pollmod[replycount] <if condition="$pollmod[\'replycount\'] == 1">$vbphrase[reply]<else />$vbphrase[replies]</if></a>
		</if>
		<if condition="$show[\'editpoll\']">
			<br />&raquo; <a href="$vboptions[bburl]/poll.php?$session[sessionurl]do=polledit&amp;pollid=$pollmod[pollid]">$vbphrase[edit_poll]</a>
		</if>
		</div>
	</td>
</tr>',


'adv_portal_polloption' =>
'<tr>
	<td class="$bgclass" valign="middle">
		<input id="pollchoice_$mods[modid]_$option[number]" name="optionnumber" type="radio" value="$option[number]" />
		<span class="smallfont"><label for="pollchoice_$mods[modid]_$option[number]">$option[question]</label></span>
	</td>
</tr>',


'adv_portal_polloption_multiple' =>
'<tr>
	<td class="$bgclass">
		<input id="pollchoice_$mods[modid]_$option[number]" name="optionnumber[$option[number]]" type="checkbox" value="yes" />
		<span class="smallfont"><label for="pollchoice_$mods[modid]_$option[number]">$option[question]</label></span>
	</td>
</tr>',


'adv_portal_pollresult' =>
'<tr>
	<td class="$bgclass">
		<div class="smallfont"><if condition="$show[\'voteital\']"><em>$option[question] - $option[percent]%</em><else />$option[question] - $option[percent]%</if></div>
		<img title="$option[votes] $votephrase" alt="" height="10" src="$stylevar[imgdir_poll]/bar$option[graphicnumber]-l.gif" width="3" /><img title="$option[votes] $votephrase" alt="$option[votes] $votephrase" height="10" src="$stylevar[imgdir_poll]/bar$option[graphicnumber].gif" width="$option[barnumber]" /><img title="$option[votes] $votephrase" alt="" height="10" src="$stylevar[imgdir_poll]/bar$option[graphicnumber]-r.gif" width="3" />
	</td>
</tr>',


'adv_portal_recthreads_exp' =>
'<tr>
	<if condition="$mod_options[\'portal_threads_showicon\']">
		<td class="alt2"><if condition="$show[\'threadicon\']"><img alt="" border="0" src="$thread[threadiconpath]" title="$thread[threadicontitle]" /></if></td>
	</if>

	<td class="alt1">
		<if condition="$thread[\'subscribed\'] OR $show[\'paperclip\'] OR ($thread[\'sticky\'] AND $mod_options[\'portal_threads_stickyicon\'])">
		<span style="float:$stylevar[right]">
			<if condition="$thread[\'subscribed\']">
				<img alt="" class="inlineimg" src="$stylevar[imgdir_misc]/subscribed.gif" title="$vbphrase[you_are_subscribed_to_this_thread]" />
			</if>
			<if condition="$show[\'paperclip\']">
				<a href="#" onclick="vba_attach_win($thread[threadid]); return false"><img class="inlineimg" src="$stylevar[imgdir_misc]/paperclip.gif" border="0" title="<phrase 1="$thread[attach]">$vbphrase[x_attachments]</phrase>" alt="" /></a>
			</if>
			<if condition="$thread[\'sticky\'] AND $mod_options[\'portal_threads_stickyicon\']">
				<img class="inlineimg" src="$stylevar[imgdir_misc]/sticky.gif" title="$vbphrase[sticky_thread]" alt="" />
			</if>
		</span>
		</if>
		<if condition="$mod_options[\'portal_threads_newpostarrow\'] AND $show[\'gotonewpost\']">
			<a href="$vboptions[bburl]/showthread.php?$session[sessionurl]t=$thread[threadid]&amp;goto=newpost"><img alt="$vbphrase[go_to_first_new_post]" src="$stylevar[imgdir_button]/firstnew.gif" border="0" class="inlineimg" /></a>
		</if>
		$thread[prefix]
		<a href="$vboptions[bburl]/showthread.php?$session[sessionurl]t=$thread[threadid]" title="$thread[preview]"><if condition="$show[\'gotonewpost\']"><strong>$thread[title]</strong><else />$thread[title]</if></a>
		<if condition="$mod_options[\'portal_threads_multipage\'] AND $show[\'pagenav\']">
			<span class="smallfont">(<img class="inlineimg" src="$stylevar[imgdir_misc]/multipage.gif" border="0" alt="" /> $thread[pagenav]<if condition="$show[pagenavmore]">... <a href="$vboptions[bburl]/showthread.php?$session[sessionurl]t=$thread[threadid]&amp;page=$thread[totalpages]">$vbphrase[last_page]</a></if>)</span>
		</if>
		<if condition="$thread[\'rating\']">
			<span style="float:$stylevar[right]"><img alt="" src="$stylevar[imgdir_rating]/rating_$thread[rating].gif" title="<phrase 1="$thread[votenum]" 2="$thread[voteavg]">$vbphrase[thread_rating_x_votes_y_average]</phrase>" /></span>
		</if>
		<if condition="$mod_options[\'portal_threads_threadstarter\']">
			<div class="smallfont">
				<if condition="$thread[postuserid]">
					<span style="cursor:pointer" onclick="window.open(\'$vboptions[bburl]/member.php?$session[sessionurl]u=$thread[postuserid]\')">$thread[postusername]</span>
				<else />
					$thread[postusername]
				</if>
			</div>
		</if>
		<if condition="$mod_options[\'portal_threads_showdate\']">
			<div class="smallfont">$thread[postdate] <span class="time">$thread[posttime]</span></div>
		</if>
	</td>
	<if condition="$show[\'lastpost\']">
		<td class="alt2">
			<div class="smallfont" style="text-align:$stylevar[right]; white-space:nowrap">
				$thread[lastpostdate] <span class="time">$thread[lastposttime]</span><br />
				<phrase 1="$vboptions[bburl]/member.php?$session[sessionurl]find=lastposter&amp;t=$thread[threadid]" 2="$thread[lastposter]">$vbphrase[by_x]</phrase> <a href="$vboptions[bburl]/showthread.php?$session[sessionurl]p=$thread[lastpostid]#post$thread[lastpostid]"><img alt="" border="0" src="$stylevar[imgdir_button]/lastpost.gif" title="$vbphrase[go_to_last_post]" /></a>
			</div>
		</td>
	</if>
	<if condition="$mod_options[\'portal_threads_replies\']">
		<td align="center" class="$class_reply"><span class="smallfont">$thread[replycount]</span></td>
	</if>
	<if condition="$mod_options[\'portal_threads_views\']">
		<td align="center" class="$class_view"><span class="smallfont">$thread[views]</span></td>
	</if>
	<if condition="$mod_options[\'portal_threads_showforum\']">
		<td class="$class_ftitle"><span class="smallfont"><a href="$vboptions[bburl]/forumdisplay.php?$session[sessionurl]f=$thread[forumid]">$thread[forumtitle]</a></span></td>
	</if>
</tr>',


'adv_portal_recthreads_exp_head' =>
'<tr>
	<if condition="$mod_options[\'portal_threads_showicon\']">
		<td class="thead" width="2%">&nbsp;</td>
	</if>
	<td class="thead" width="50%"><if condition="$mod_options[\'portal_threads_showrating\']"><span style="float:$stylevar[right]">$vbphrase[rating]</span></if>$vbphrase[title_username_date]</td>
	<if condition="$mod_options[\'portal_threads_lastpost\']">
		<td align="center" class="thead" style="white-space: nowrap" width="25%">$vbphrase[last_post]</td>
	</if>
	<if condition="$mod_options[\'portal_threads_replies\']">
		<td class="thead" width="2%">$vbphrase[replies]</td>
	</if>
	<if condition="$mod_options[\'portal_threads_views\']">
		<td class="thead" width="2%">$vbphrase[views]</td>
	</if>
	<if condition="$mod_options[\'portal_threads_showforum\']">
		<td align="center" class="thead" width="20%">$vbphrase[forum]</td>
	</if>
</tr>',


'adv_portal_recthreads_lean' =>
'<tr>
	<td class="$bgclass">
		<div class="smallfont">
			<if condition="$show[\'paperclip\'] OR ($thread[\'sticky\'] AND $mod_options[\'portal_threads_stickyicon\'])">
				<span style="float:$stylevar[right]">
					<if condition="$show[\'paperclip\']">
						<a href="#" onclick="vba_attach_win($thread[threadid]); return false"><img class="inlineimg" src="$stylevar[imgdir_misc]/paperclip.gif" border="0" title="<phrase 1="$thread[attach]">$vbphrase[x_attachments]</phrase>" alt="" /></a>
					</if>
					<if condition="$thread[\'sticky\'] AND $mod_options[\'portal_threads_stickyicon\']">
						<img class="inlineimg" src="$stylevar[imgdir_misc]/sticky.gif" title="$vbphrase[sticky_thread]" alt="" />
					</if>
				</span>
			</if>

			<if condition="$show[\'threadicon\']">
				<img class="inlineimg" src="$thread[threadiconpath]" title="$thread[threadicontitle]" border="0" alt="" />
			</if>
			<if condition="$thread[\'subscribed\']">
				<img alt="" class="inlineimg" src="$stylevar[imgdir_misc]/subscribed.gif" title="$vbphrase[you_are_subscribed_to_this_thread]" />
			</if>
			<if condition="$mod_options[\'portal_threads_newpostarrow\'] AND $show[\'gotonewpost\']">
				<a href="$vboptions[bburl]/showthread.php?$session[sessionurl]t=$thread[threadid]&amp;goto=newpost"><img alt="$vbphrase[go_to_first_new_post]" src="$stylevar[imgdir_button]/firstnew.gif" border="0" class="inlineimg" /></a>
			</if>
			$thread[prefix] <a href="$vboptions[bburl]/showthread.php?$session[sessionurl]t=$thread[threadid]" title="<if condition="$thread[preview]">$thread[preview]</if>"><if condition="$show[\'gotonewpost\']"><strong>$thread[title]</strong><else />$thread[title]</if></a>
			<if condition="$mod_options[\'portal_threads_multipage\'] AND $show[\'pagenav\']">
				(<img class="inlineimg" src="$stylevar[imgdir_misc]/multipage.gif" border="0" alt="" /> $thread[pagenav]<if condition="$show[pagenavmore]">... <a href="$vboptions[bburl]/showthread.php?$session[sessionurl]t=$thread[threadid]&amp;page=$thread[totalpages]">$vbphrase[last_page]</a></if>)
			</if>
			<if condition="$mod_options[\'portal_threads_showdate\']">
				<div>$thread[postdate] <span class="time">$thread[posttime]</span></div>
			</if>
			<if condition="$thread[\'rating\']">
				<span style="padding-top:$stylevar[cellpadding]px; float: $stylevar[right]"><img alt="" src="$stylevar[imgdir_rating]/rating_$thread[rating].gif" title="<phrase 1="$thread[votenum]" 2="$thread[voteavg]">$vbphrase[thread_rating_x_votes_y_average]</phrase>" /></span>
			</if>
			<if condition="$mod_options[\'portal_threads_threadstarter\']">
	 			<div>
	 				<if condition="$thread[postuserid]">
						<phrase 1="$vboptions[bburl]/member.php?$session[sessionurl]u=$thread[postuserid]" 2="$thread[postusername]">$vbphrase[by_x]</phrase>
					<else />
						$vbphrase[by] $thread[postusername]
					</if>
				</div>
			</if>

			<if condition="$mod_options[\'portal_threads_showforum\']">
				<div style="padding-top:$stylevar[cellpadding]px"><a href="$vboptions[bburl]/forumdisplay.php?$session[sessionurl]f=$thread[forumid]">$thread[forumtitle]</a></div>
			</if>
			<if condition="$show[\'lastpost\']">
				<div style="padding-top:$stylevar[cellpadding]px"><a href="$vboptions[bburl]/showthread.php?$session[sessionurl]p=$thread[lastpostid]#post$thread[lastpostid]"><img alt="" border="0" src="$stylevar[imgdir_button]/lastpost.gif" title="$vbphrase[go_to_last_post]" /></a> $vbphrase[last_post_by] <a href="$vboptions[bburl]/member.php?$session[sessionurl]find=lastposter&amp;t=$thread[threadid]">$thread[lastposter]</a></div>
				<div>$thread[lastpostdate] <span class="time">$thread[lastposttime]</span></div>
			</if>
			<if condition="$mod_options[\'portal_threads_replies\'] OR $mod_options[\'portal_threads_views\']">
				<div style="padding-top:$stylevar[cellpadding]px"><if condition="$mod_options[\'portal_threads_replies\']">$thread[replycount] $vbphrase[replies]</if>$recthreads_comma <if condition="$mod_options[\'portal_threads_views\']">$thread[views] $vbphrase[views]</if></div>
			</if>
		</div>
	</td>
</tr>',


'adv_portal_search' =>
'<tr>
<td class="$bgclass">
	<input class="bginput" name="query" size="13" type="text" /> $gobutton
	<div class="smallfont">&raquo; <a href="$vboptions[bburl]/search.php$session[sessionurl_q]">$vbphrase[advanced_search]</a></div>
</td>
</tr>',


'adv_portal_stats' =>
'<tr>
	<td class="$bgclass">
		<span class="smallfont">
			<if condition="$mod_options[\'portal_stats_members\']">$vbphrase[members]: $numbermembers<br /></if>
			<if condition="$mod_options[\'portal_stats_threads\']">$vbphrase[threads]: $totalthreads<br /></if>
			<if condition="$mod_options[\'portal_stats_posts\']">$vbphrase[posts]: $totalposts<br /></if>
			<if condition="$mod_options[\'portal_stats_topposter\']">$vbphrase[top_poster]: <a href="$vboptions[bburl]/member.php?$session[sessionurl]u=$topposter[userid]">$topposter[username]</a> ($topposter[posts])<br /></if>
			$template_hook[adv_portal_stats]
		</span>
	</td>
</tr>
<if condition="$mod_options[\'portal_stats_newestmember\']">
	<tr>
		<td class="$altbgclass"><span class="smallfont"><phrase 1="$vboptions[bburl]/member.php?$session[sessionurl]u=$newuserid" 2="$newusername">$vbphrase[welcome_to_our_newest_member_x]</phrase></span></td>
	</tr>
</if>',


'adv_portal_welcomeblock_expanded' =>
'<tr>
	<td class="$bgclass">

		<if condition="!$show[\'guest\']">

			<if condition="$avatarurl">
				<a href="$vboptions[bburl]/profile.php?$session[sessionurl]do=editavatar"><img src="$avatarurl" border="0" alt="$vbphrase[edit_avatar]" /></a>
				</td>
				<td class="$altbgclass" valign="top" width="100%">
			</if>
				<if condition="$bbuserinfo[\'reputationdisplay\'] OR ($bbuserinfo[\'rank\'] AND $mod_options[\'portal_welcome_rank\'])">
					<div class="smallfont" style="float:$stylevar[right]">
					<if condition="$bbuserinfo[\'reputationdisplay\']">
						$vbphrase[rep_power]: $reppower
						<div align="$stylevar[right]" style="padding-bottom:$stylevar[cellpadding]px">$bbuserinfo[reputationdisplay]</div>
					</if>
					<if condition="$bbuserinfo[\'rank\'] AND $mod_options[\'portal_welcome_rank\']">
						<div align="$stylevar[right]" style="padding-top:$stylevar[cellpadding]px; padding-bottom:$stylevar[cellpadding]px">$bbuserinfo[rank]</div>
					</if>
					</div>
				</if>

				<span class="smallfont"><phrase 1="$bbuserinfo[username]">$vbphrase[welcome_back_x]</phrase><br />
				<phrase 1="$lastvisitdate" 2="$lastvisittime">$vbphrase[last_visited_x_at_y]</phrase><br />
				<if condition="$mod_options[\'portal_welcome_newposts\']">
					<a href="$vboptions[bburl]/search.php?$session[sessionurl]do=getnew">$vbphrase[new_posts]</a>: $newposts<br />
				</if>

				<a href="$vboptions[bburl]/login.php?$session[sessionurl]do=logout&amp;logouthash=$bbuserinfo[logouthash]" onclick="return log_out(\'$vbphrase[sure_you_want_to_log_out]\')">$vbphrase[log_out]</a></span>

				<if condition="$mod_options[\'portal_welcome_newpms\'] AND $show[\'pmstats\']">
						</td>
					</tr>
					<tr>
						<td class="thead" colspan="2"><a href="$vboptions[bburl]/private.php$session[sessionurl_q]">$vbphrase[private_messages]</a></td>
					</tr>
					<tr>
						<td class="$bgclass" colspan="2"><span class="smallfont"><phrase 1="$bbuserinfo[pmunread]" 2="$bbuserinfo[pmtotal]" 3="$permissions[pmquota]">$vbphrase[x_new_have_y_of_z_allowed]</phrase></span>
				</if>
		<else />

			<table width="100%" cellspacing="3" cellpadding="0">
				<tr>
					<td style="white-space: nowrap" class="smallfont">$vbphrase[user_name]</td>
					<td><input class="bginput" name="vb_login_username" size="12" type="text" tabindex="577" /></td>
					<td style="white-space: nowrap" class="smallfont"><input checked="checked" class="bginput" name="cookieuser" id="cb_cookieuser" type="checkbox" value="1" /><label for="cb_cookieuser">$vbphrase[remember_me]</label></td>
					<td align="center" rowspan="2" width="100%"><phrase 1="$vboptions[bburl]">$vbphrase[not_a_member_yet_register_now]</phrase></td>
				</tr>
				<tr>
					<td class="smallfont">$vbphrase[password]</td>
					<td><input class="bginput" name="vb_login_password" size="12" type="password" tabindex="578" /></td>
					<td><input class="button" type="submit" value="$vbphrase[log_in]" tabindex="579" /></td>
				</tr>
			</table>

		</if>

	</td>
</tr>',


'adv_portal_welcomeblock_lean' =>
'<tr>
	<td class="$bgclass">

		<if condition="$bbuserinfo[\'userid\']">
			<span class="smallfont"><phrase 1="$bbuserinfo[username]">$vbphrase[welcome_back_x]</phrase></span><br />

		<if condition="$avatarurl">
			<div style="padding:4px">
				<a href="$vboptions[bburl]/profile.php?$session[sessionurl]do=editavatar"><img src="$avatarurl" border="0" alt="$vbphrase[edit_avatar]" /></a>
			</div>
		</if>
		<div class="smallfont">
		<phrase 1="$lastvisitdate" 2="$lastvisittime">$vbphrase[last_visited_x_at_y]</phrase><br />
		<if condition="$mod_options[\'portal_welcome_newposts\']">
			<a href="$vboptions[bburl]/search.php?$session[sessionurl]do=getnew">$vbphrase[new_posts]</a>: $newposts<br />
		</if>

		<if condition="$bbuserinfo[\'reputationdisplay\']">
			<div style="padding-top:$stylevar[cellpadding]px; padding-bottom:$stylevar[cellpadding]px">$vbphrase[rep_power]: $reppower<br />
			$bbuserinfo[reputationdisplay]</div>
		</if>
		<if condition="$bbuserinfo[\'rank\'] AND $mod_options[\'portal_welcome_rank\']">
			<div style="padding-top:$stylevar[cellpadding]px; padding-bottom:$stylevar[cellpadding]px">$bbuserinfo[rank]</div>
		</if>

		<a href="$vboptions[bburl]/login.php?$session[sessionurl]do=logout&amp;logouthash=$bbuserinfo[logouthash]" onclick="return log_out(\'$vbphrase[sure_you_want_to_log_out]\')">$vbphrase[log_out]</a></div>

		<if condition="$mod_options[\'portal_welcome_newpms\'] AND $show[\'pmstats\']">
			</td>
			</tr>
			<tr>
			<td class="thead"><a href="$vboptions[bburl]/private.php$session[sessionurl_q]">$vbphrase[private_messages]</a></td>
			</tr>
			<tr>
			<td class="$altbgclass"><span class="smallfont"><phrase 1="$bbuserinfo[pmunread]" 2="$bbuserinfo[pmtotal]" 3="$permissions[pmquota]">$vbphrase[x_new_have_y_of_z_allowed]</phrase></span>
		</if>

		<else />
			<div class="smallfont" style="padding:$stylevar[cellpadding]px">$vbphrase[user_name]:<br />
				<input class="bginput" name="vb_login_username" size="12" type="text" tabindex="577" /><br />
				$vbphrase[password]:<br />
				<input class="bginput" name="vb_login_password" size="12" type="password" tabindex="578" /><br />
				<input checked="checked" class="bginput" name="cookieuser" id="cb_cookieuser" type="checkbox" value="1" /><label for="cb_cookieuser">$vbphrase[remember_me]</label>

				<div style="padding-top:$stylevar[cellpadding]px; padding-bottom:$stylevar[cellpadding]px;">
					<input class="button" type="submit" value="$vbphrase[log_in]" tabindex="579" />
				</div>

			<phrase 1="$vboptions[bburl]">$vbphrase[not_a_member_yet_register_now]</phrase>
			</div>

		</if>

	</td>
</tr>');


// ##### Phrases ##############################################################
$mainphrases['adv_portal'] = array(
	'active_users' => 'Активные пользователи',
	'buddies' => 'друзья',
	'by' => 'от',
	'comment_on_this_poll' => 'Обсуждение этого опроса',
	'customize_this_page' => 'Персонализация этой страницы',
	'edit_this_post' => 'Редактировать это сообщение',
	'exit_customization_mode' => 'Выход из режима персонализации',
	'last_post_by' => 'от',
	'latest_forum_topics' => 'Последние темы',
	'new_pms' => 'Новое Л.С',
	'no_x_online' => '<span class="smallfont">Все {1} не на сайте</span>',
	'no_x_to_display' => 'Нет {1}, чтобы отобразить.',
	'not_a_member_yet_register_now' => 'Еще не зарегистрированы?<br />
<a href="{1}/register.php">Регистрация!</a>',
	'online_buddies' => 'Друзья на сайте',
	'pm' => 'Л.С',
	'poll_results' => 'Результаты опроса',
	'powered_by_vbadvanced_cmps' => 'Powered by <a href="http://www.vbadvanced.com/" target="_blank">vBadvanced</a> CMPS Version {1}.<br />Русский перевод: Lazek и <a href="http://www.vbhelp.org" target="_blank">zCarot</a>.',
	'rating' => 'Рейтинг',
	'read_more' => ' <span class="smallfont">[<a href="{1}/showthread.php?{3}t={2}">Читать дальше</a>]</span>',
	'remove_from_buddy_list' => 'Удалить из списка друзей',
	'rep_power' => 'Вес репутации',
	'reply_to_this_post' => 'Ответить на это сообщение',
	'reset_layout' => 'Отменить изменения',
	'send_to_friend' => 'Отправить другу',
	'show_printable_version' => 'Версия для печати',
	'sorry_only_vb_37' => 'Извините, но этот модуль не работает на vBulletin ниже линейки 3.7.',
	'this_poll_has' => 'В этом опросе',
	'title_username_date' => 'Заголовок / Автор / Дата',
	'top_poster' => 'Лучший автор',
	'total_votes' => 'Всего голосов',
	'vote' => 'Голосовать',
	'welcome_back_x' => 'Добро пожаловать, <strong>{1}</strong>',
	'x_new_have_y_of_z_allowed' => '{1} Новое(ых) сообщение(ия)(ий). У вас {2} сообщение(ия)(ий) из {3} возможных сообщений.'
);

$mainphrases['adv_portal_cp'] = array(
	'active' => 'Активно',
	'active_set_to_no_disable' => 'Активно

<div class="smallfont">При переключении этой опции на \'Нет\', вы запретите отображение этого модуля на всех страницах.</div>',
	'active_modules' => 'Активные модули',
	'add_child_page' => 'Добавить дочернюю страницу',
	'add_module' => 'Добавить модуль',
	'add_more' => 'Добавить ещё',
	'add_page' => 'Добавить страницу',
	'add_remove_from_pages' => 'Добавить/Удалить эти страницы',
	'add_remove_modules_from_pages' => 'Добавить/Удалить модули со страницы',
	'add_setting' => 'Добавить параметр',
	'advanced_options' => 'Расширенные опции',
	'advanced_options_description' => 'Здесь вы можете указать значения для каждого параметра модуля, которое будет применимо только к этой странице. Если здесь ничего не будет указано, то на этой странице будет использовано значение по умолчанию. Если вы желаете вернуть значение по умолчанию, то просто нажмите "По умолчанию" справа от параметра и сохраните настройки.',
	'allow_html' => 'Разрешить HTML',
	'allow_image_code' => 'Разрешить [IMG] код',
	'allow_page_customization' => 'Разрешить персонализацию страницы<div class="smallfont">При включении данного параметра, вашим пользователям станет доступна настройка \'Персонализация этой страницы\'.',
        'allow_smilies' => 'Разрешить смайлы',
	'also_delete_module_file_x' => 'Удалить файл &quot;modules/{1}&quot;',
	'also_delete_template_x' => 'Удалить шаблон &quot;adv_portal_{1}&quot;',
	'alternative_module_wrapper_template' => 'Альтернативный шаблон оболочки модуля<div class="smallfont">вы можете выбрать другой шаблон для оболочки этого модуля, для этого введите его название здесь. Если это поля оставленно пустым, то модуль будет использовать оболочку \'adv_portal_module_wrapper\'.</div>',
	'are_you_sure_delete_module_called_x' => 'Вы действительно хотите удалить модуль <strong>{1}</strong>?<br />
Это действие <strong>НЕЛЬЗЯ</strong> отменить.',
	'are_you_sure_delete_page_called_x' => 'Вы действительно хотите удалить страницу <strong>{1}</strong>?<br />
Это действие <strong>НЕЛЬЗЯ</strong> отменить.',
	'bb_code' => 'BB код',
	'bbcode_allows_bbcode' => 'Текст с поддержкой BB кодов для {1} даёт вам возможность использовать текстовый редактор форума, чтобы форматировать ваш {2} с помощью BB кодов. Текст с поддержкой BB кодов для {1} рекомендуется для простого {2}, содержащего текст, изображения и прочее, что может быть оформлено с помощью BB кодов. Вы можете разрешить использование HTML кода, но мы рекомендуем использовать Шаблон для {1}, если требуется сделать больше, чем простейшее форматирование текста.',
	'center_column' => 'Центральная колонка',
	'change_x_type' => '{1} - изменить тип',
	'change_x_type_note' => 'Вы желаете изменить {1} с {2} {1} на {3} {1}. Помните, что при нажатии кнопки \'Сохранить\' вся предыдущая информация, хранимая в \'Опциях типа {2} {1}\' будет потеряна. Однако, вы можете вернуть тип {1} в любое время.',
	'change_x_type_to' => 'Изменить {1} тип на',
	'choose_a_file' => 'Выбрать файл',
	'clean_file_output' => 'Очистить файл вывода
<div class="smallfont">Если вы попытаетесь подключить PHP файл, который не был написан специально для vBulletin или vBadvanced, то может быть важно "очистить" вывод из этого файла. Если вы добавляете модуль и на самом верху вашей страницы появляется вывод содержимого, то это хороший показатель, что требуется очистка.</div>',
	'cmps_page_to_integrate_with' => 'CMPS страница интеграции с',
	'cmps_page_to_integrate_with_desc' => 'Выберите страницу CMPS по умолчанию, которую вы хотели бы использовать, для интеграции с &quot;оболочкой&quot; и вашими файлами.<br />Вы также сможите изменить страницу, используемую с каждым файлом в следующем шаге, выберите страницу для сохранения (которое может занять некоторое время), поскольку каждому файлу пред выберут эту страницу.<div style="padding-top: 4px">Примечание: Только CMPS &quot;модули&quot; со страниц &quot;другое содержимое страницы&quot;, нажмите здесь для включения модулей. На других страницах будет отключено.</div>',
	'cmps_product_inactive' => 'vBadvanced CMPS выключен в <a href="plugin.php?do=product">Продуктах и модулях</a>. Пожалуйста, включите vBadvanced CMPS.',
	'collapse_module_by_default' => 'Сворачивать все модули по умолчанию<div class="smallfont">>Если вы включите эту опцию, то все модули будут свёрнуты.',
	'content' => 'Содержимое',
	'copy' => 'Копировать',
	'copy_page' => 'Копировать страницу',
	'copy_module' => 'Копировать модуль',
	'copy_module_layout' => 'Расположение копии модуля',
	'copy_module_layout_from_another_page' => 'Расположение копии модуля от другой страницы',
	'copying_x_note' => 'Вы выбрали, чтобы скопировать ваш {1} с названием &quot;{2}&quot;. Измените нужные вам опции приведенные ниже и нажмите кнопку &quot;Сохранить&quot;. Кнопка для добавления нового {1}.',
	'current_integrated_pages' => 'Текущая интеграция страниц',
	'current_selected_threads' => 'Текущее выделение тем',
	'currently_running_latest_available' => 'Вы используете vBadvanced CMPS версии {1}.<br />
<br />
Последняя доступная версия {2}.<br />

<br />
{3}',
	'custom_content_title' => 'Другой заголовок содержимого
<div class="smallfont">Это то, что будет помещено в заголовок вашего шаблона.',
	'custom_page_content_description' => 'Этот модуль используется для отображения различных типов содержимого на ваших страницах. Например, если вы добавляете шаблон страницы, то содержимое шаблона, указанного на этой странице будет получено из этого модуля.',
	'custom_page_content_desc' => 'Контент содержащийся на странице<div class="smallfont">Данный контент будет отображен на странице {1}.</div>',
	'custom_page_content_integrate_desc' => 'Контент содержащийся на странице<div class="smallfont">Если эта страница используется для интеграции, то весь контент будет показан от интегрируемого файла.</div>',

	'custom_style_for_this_page' => 'Другой стиль для этой страницы',
	'custom_style_for_this_page_desc' => 'Выберите другой стиль для этой страницы. Если ничего не выбрано, то будет использоваться стандартный стиль vBulletin.',
	'date_created' => 'Дата создания',
	'delete_page_integrated_files' => 'Следующие файлы /THIS_SCRIPT были объединены с данной страницей. Вы можете удалить или изменить интеграцию с другими страницами CMPS.',
	'display_order_page_desc' => 'Этот параметр отвечает за работу модуля "Меню" на отображаемых страницах и в панели администратора.',
	'dot_xml' => '.xml',
	'dot_module_serialized_data' => '.module (сериализованные данные)',
	'download_file_type' => 'Скачать файл расположенный',
	'download_module' => 'Скачать модуль',
	'duplicate_filename' => 'Дублированное имя файла',
	'duplicate_filename_desc' => '<div class="smallfont">Файл с именем <strong>{1}</strong> уже существует в папке модулей. Пожалуйста, выберите другое имя для файла.',
	'duplicate_module_identifier' => 'Дублированный идентификатор модуля
',
	'duplicate_module_identifier_desc' => '<div class="smallfont">У вас уже есть модуль с идентификатором \'{1}\'. Пожалуйста, выберите другой идентификатор.</div>',
	'dynamic' => 'Динамически',
	'edit_module' => 'Редактировать модуль',
	'edit_modules' => 'Редактировать модули',
	'edit_page' => 'Редактировать страницу',
	'edit_pages' => 'Редактировать страницы',
	'edit_setting' => 'Редактировать параметр',
	'edit_settings' => 'Редактировать параметры',
	'edit_template' => 'Редактировать шаблон',
	'edit_template_for_x_in_style' => 'Редактировать шаблон для {1} в следующем стиле: ',
	'edit_threads' => 'Редактировать темы',
	'expanded' => 'Развернутые',
	'file_allows_file' => 'PHP файл {1} позволит вам указать файл из директории modules, который будет отображен как содержимое {2}.',
	'file_to_include' => 'Подключаемый файл',
	'form_code' => 'Код формы
<div class="smallfont">Если ваш модуль требует тега &lt;form&gt;, вы можете ввести код для этого тега form здесь. Это позволит поместить код над таблицей и соблюсти стандарты XHTML.',
	'from_anywhere_on_your_server' => 'на вашем сервере',
	'from_modules_directory' => 'Директория ваших модулей: <i>{vbulletin}</i>/modules/',
	'here_specify_which_usergroups_access_page' => 'Здесь вы можете указать, какие группы пользователей будут иметь доступ к этой странице.',
	'here_specify_which_usergroups_view_module' => 'Здесь вы можете указать, какие группы пользователей смогут увидеть этот модуль.',
	'hide_page_in_site_navigation' => 'Скрыть эту страницу в модулях:',
	'html_allows_html' => 'HTML страница позволит вам указать HTML файл на вашем сервере, чтобы включить его для отображения в качестве содержимого вашего модуля \'Другое содержимое страницы\'.',
	'html_file' => 'Файл HTML',
	'identifier' => 'Идентификатор',
	'identifier_desc' => 'PHP файл модуля может быть идентифицирован для более простой настройки.',
	'choose_a_page_to_copy_layout_from' => 'Если вы хотите, то можете скопировать модуль с одной из ваших страниц, на новую, предварительно созданную страницу.',
	'inactive' => 'Неактивный',
	'inactive_modules' => 'Неактивные модули',
	'initialize_bbcode_parser' => 'Использовать BB коды<div class="smallfont">Этот модуль использует BB коды из vBulletin, эта опция должна быть включена.</div>',
	'initialize_forum_permissions' => 'Использовать права в разделах<div class="smallfont">Этот модуль берет информацию из разделов вашего форума, права на просмотр данного модуля берутся из параметров vBulletin, эта опция должна быть включена.</div>',
	'initialize_ignored_users' => 'Использовать игнорирование пользователей<div class="smallfont">Этот модуль берет информацию из разделов вашего форума об темах и сообщениях, права доступа берутся из vBulletin, эта опция должна быть включена.',
	'initialize_moderator_cache' => 'Использовать права модераторов<div class="smallfont">Этот модуль требует информацию о правах ваших модераторов (т.е. использует функцию can_moderate ()), эта опция должна быть включена для инициализации прав ваших модераторов.',
	'integate_new_pages' => 'Интегрировать новые страницы',
	'integration' => 'Интеграция',
	'integration_allows_you_include_cmps' => 'Этот инструмент позволит вам легко объединять страницы и хаки, это &quot;оболочка&quot; специально для выбора контента с форума на страницы CMPS. Заполните форму ниже чтобы начать.<div style="padding-top:4px"><strong>Примечание:</strong> Только CMPS &quot;модуль&quot; страниц &quot;другое содержимое страницы&quot; включен для интергации. Модуль &quot;другое содержимое страницы&quot; необходим для нахождения на страницах.</div>',
	'last_vote' => 'Последний голос',
	'lean' => 'Сжатый',
	'left_column' => 'Левая колонка',
	'level' => 'Уровень',
	'link' => 'ссылка',
	'main_options' => 'Основные настройки',
	'meta_description' => 'META описание
<div class="smallfont">Здесь вы можете ввести META описание для этой страницы. Оставьте этот параметр пустым, чтобы использовать значение по умолчанию из vBulletin.</div>',
	'meta_keywords' => 'Ключевые слова META
<div class="smallfont">Здесь вы можете ввести список ключевых слов META для этой страницы. Оставьте этот параметр пустым, чтобы использовать значение по умолчанию из vBulletin.</div>',
	'module' => 'Модуль',
	'module_allows_module' => 'Страница модулей позволит вам выбрать модули которые вы хотите отобразить на странице.',
	'module_cache' => 'Кэши модулей',
	'module_dragdrop_desc' => 'Для изменения порядка отображения модулей на этой странице, нажмите на заголовок модуля и перетащите его на то место, где бы Вы хотели чтобы он находился. Чтобы удалить модуль с этой страницы, перетащите его в неактивные модули.<br /><br /><strong>Не забудьте сохранить страницу, после внесения каких-либо изменений!</strong>',
	'module_parent' => 'Родительский модуль
<div class="smallfont">Некоторым модулям (например: архив новостей), следует указывать родительский модуль. Если этому модулю нужен родительский - укажите его здесь.</div>',
	'module_wrapper_template_options' => 'Опции шаблона оболочки модуля',
	'module_title' => 'Название модуля',
	'module_type' => 'Тип модуля',
	'modules' => 'Модули',
	'move_to' => 'Переместить в',
	'newer_version_available' => '<strong>Доступна новая версия vBadvanced CMPS!</strong><br />
<br />
Пожалуйста зайдите на <a href="http://www.vbadvanced.com/" target="_blank">vBadvanced.com</a>, чтобы узнать подробности.
',
	'no_modules' => 'Нет модулей',
	'no_x_to_display' => 'Нет {1}, чтобы отобразить.',
	'note_integrates_any_file_with_same_name' => 'Отметьте что нужно для интеграции, <strong>любые</strong> файлы с названием(ми) выбранными здесь, то использование в vBulletin невозможно.',
	'option_code' => 'Код опции',
	'options_apply_to_module_wrapper' => 'Этот блок связан с опциями, которые могут быть применимы к вашему шаблону \'adv_portal_module_wrapper\'. Помните, что эти опции будут работать, только если параметр \'Использовать шаблон оболочки модуля\' установлен на \'Да\'.',
	'order' => 'Порядок',
	'other_filenames_to_integrate' => 'Другое название файла для интеграции',
	'other_filenames_to_integrate_desc' => 'Если вы хотите объединить другие названия файла, которые не могут быть упомянуты выше, просто нажмите на название файла(ов) здесь. Каждое новое название пишите с новой строки.',
	'overwrite_file_with_new_file' => 'Перезаписать новым файлом',
	'overwrite_templates' => 'Перезаписать шаблоны
',
	'overwrite_templates_desc' => '<div class="smallfont">Следующие шаблоны уже существуют в этом стиле:</div>
<div class="smallfont" style="padding-top:5px; padding-bottom:5px">{1}</div>
<div class="smallfont">Выберите \'Да\', чтобы перезаписать ваши шаблоны новыми, или выберите не сохранять текущие шаблоны.</div>',
	'page_active' => 'Страница активна
<div class="smallfont">Если выбрано \'Нет\', то это страница будет видна только модераторам и администраторам.</div>',
	'pages_active_on' => 'Страница активна',
	'page_contains_following_sub_pages' => 'Эта страница имеет следующие под страницы. Если вы не хотите удалить любую из этих страниц также, вы должны выбрать новую родительскую страницу для любой из упомянутых ниже страниц.',
	'page_identifier' => 'Идентификатор страницы',
	'page_identifier_example' => 'Это переменная, которая будет использована в ссылке на страницу. например, если указан параметр \'games\', то ссылка на эту страницу будет выглядеть так: {1}?{2}=games</div>',
	'page_parentlists' => 'Родительские страницы',
	'page_title' => 'Название страницы',
	'page_to_copy_from' => 'Скопировать со страницы',
	'page_type' => 'Тип страницы',
	'pages_to_copy_to' => 'На страницу(ы)',
	'parent_page' => 'Родительская страница',
	'parent_page_desc' => 'Выберите &quot;Основную Страницу&quot; для отображения, данная страница станет под страницей.',
	'path_to_file' => 'Путь к файлу
<div class="smallfont">Здесь вы можете указать путь к файлу, которым желаете заменить ваш модуль \'другого содержимого страницы\'.</div>',
	'php_file' => 'PHP файл',
	'please_select_a_page' => 'Пожалуйста выберите страницу',
	'please_select_type_of_x_to_add' => 'Пожалуйста, укажите какой тип {1} вы хотите добавить.',
	'plugins_inactive_x' => 'Стандартные модули отключены. Для включения, зайдите в <a href="plugin.php?do=modify">продукты и модули</a>.<br />{1}',
	'plugins_missing' => 'Один или несколько из ваших модулей для vBadvanced CMPS работают некорректно. Пожалуйста, переустановите их.',
	'random' => 'Случайно',
	'rating' => 'Рейтинг',
	'rebuild_x' => 'Обновить {1}',
	'remove_module' => 'Удалить модуль',
	'rename_to_filename_entered_below' => 'Изменить название файла',
	'right_column' => 'Правая колонка',
	'select_an_action' => 'Выберите действие',
	'select_module_upload' => 'Загрузка модуля<div class="smallfont">Пожалуйста выберите модуль в формате .module или .xml на вашем компьютере для загрузки.</div>',
	'select_new_parent' => 'Выбрать новый родительский',
	'select_new_threads' => 'Выбрать новые темы',
	'select_pages_to_integrate_and_save' => 'Выберите страницу CMPS для интеграции с файлом THIS_SCRIPT. После вашего выбора, нажмите кнопку &quot;Сохранить&quot; для завершения интеграции.',
	'select_style_add_template_to' => 'Если вы хотите добавить новый шаблон для вашего модуля, пожалуйста выберите нужный вам стиль.<br />Для добавления шаблона во все стили, удерживая кнопку \'Ctrl\' правой кнопкой мыши выделите все стили.',
	'serialize' => 'Номерация',
	'setting' => 'параметр',
	'setting_customized_pages' => 'Этот параметр изменен на следующих страницах: ',
	'setting_customized_pages_desc' => 'Для этого параметра вами было указано своё значение на страницах, указанных выше. Значение для этого параметра, указанное на одной из этих страниц, будет использоваться вместо значения, указанного здесь. Если вы желаете изменить значение этого параметра на данных страницах, то вам следует либо отредактировать страницу и изменить значение здесь, либо вернуть значение параметра на нужной странице, чтобы она использовала значение, указанное здесь.',
	'settings_customized_marked_with_asterisk' => 'Параметры, указанные ниже, у которых стоит знак &quot;*&quot;, были изменены на данной странице, поэтому это значение будет использоваться вместо значения по умолчанию. Если вы желаете использовать значения по умолчанию для какого-либо из этих параметров, то поставьте справа от названия параметра отметку "Использовать по умолчанию" и сохраните страницу.',
	'show_all_settings' => 'Показать все параметры',
	'showing_w_x_to_y_of_z' => 'Показать {1} {2} с {3} по {4}',
	'simple_calendar' => 'Простой календарь',
	'style_to_install_to' => 'Стиль для установки
<div class="smallfont">Модуль будет установлен в шаблон, выберите один из ыаших стилей для установки<br />Для добавления шаблона во все стили, удерживая кнопку \'Ctrl\' правой кнопкой мыши выделите все стили.</div>',
	'thread_title' => 'Название темы',
	'template' => 'Шаблон',
	'template_allows_template' => 'Шаблоны {1} включаются в стилях и шаблонах, для отображения содержимого {2}.',
	'template_content' => 'Содержимое шаблона
<div class="smallfont">Если вы добавляете новый {1} и шаблон не существует, то вы можете ввести содержимое этого шаблона здесь. Если шаблон уже существует, просто оставьте это поле пустым. Пожалуйста, обратите внимание, что любые изменения этого шаблона должны быть сделаны через \'Управление стилями\'.</div>',
	'template_title' => 'Название шаблона',
	'note_templates_should_use_format' => 'Отметьте что все шаблоны должны использовать следующий формат, если этот параметр включен:',
	'temlate_title_desc' => 'Введите название страницы для отображения.',
	'template_to_include' => 'Подключаемый шаблон<div class="smallfont">Введите название шаблона для отображения вашего модуля. Все шаблоны должны иметь прфикс \'adv_portal\', но вводить этот префикс не обязательно.<br />Пример: ваш шаблон называется \'adv_portal_games\', в поле введено \'games\' и это будет правильно.</div>',
	'templates_used' => 'Использованные шаблоны
<div class="smallfont">Здесь вы можете ввести список любых шаблонов, которые будут использованы для данного модуля. Это используется как для кэширования шаблонов так и для выяснения, какие шаблоны принадлежат скачиваемому модулю.',
	'this_module' => 'этот модуль',
	'this_script_integration_method' => 'THIS_SCRIPT тип интеграции',
	'this_script_integration_method_desc' => 'Стандартные файлы vBulletin (и большинство хаков) определяются через постоянную &quot;THIS_SCRIPT&quot;, это помогает идентифицировать его. Если вы хотите интегрировать файлы, но они не могут быть интегрированы, откройте файлы, который вы хотели интегрировать и посмотрите на постоянную THIS_SCRIPT или введите значение. Разделите каждый THIS_SCRIPT с возвратом (с новой строчки).<br /><br />Пример:<hr width="40%" align="{1}"><div>define(\'THIS_SCRIPT\', \'<strong><i>value</i></strong>\');</div><hr width="40%" align="{1}"><div style="padding-top:4px">Из этого примера, вы должны указать \'value\' (без ковычек) в поле.',
	'title_row_colspan' => 'Количество ячеек для заголовка
<div class="smallfont">Если в модуле будет более одной табличной ячейки для вывода, то вы можете указать значение colspan, которое укажет количество занимаемых ячеек заголовком в шаблоне.</div>',
	'to_begin_selecting_threads' => 'Для начала выборки тем для отображения, сначала выберите соответсвующий раздел.',
	'to_remove_this_module' => 'Чтобы удалить этот модуль, нажмите на кнопку \'удалить модуль\'.',
	'tool_downloads_module' => 'Эта опция позволит вам загружать модули в формате .xml или .module, который будет содержать информацию (настройки, шаблоны, файлы и т.д.) все что связано с этим модулем. Это позволит вам делать резервные копии ваших модулей максимально быстро.',
	'tool_allows_copy_layouts' => 'Эта опция позволит вам скопировать модули на другие страницы, а так же активировать модули на одной или всех страницах. Выберите страницу с которой вы хотите сделать копию, дальше выберите страницу(ы) на которую вставить скопированные модули, и нажмите кнопку &quot;Сохранить&quot;.',
	'upload_module' => 'Загрузить модуль',
	'urls' => 'Ссылки',
	'use_current_file_instead' => 'Использовать текущий файл вместо этого',
	'use_default' => 'Использовать по умолчанию',
	'use_default_style' => 'Использовать стиль по умолчанию',
	'use_module_wrapper_must_be_enabled' => 'Этот параметр служит для улучшения функции "использовать шаблон оболочки модуля" если она была включена. Вы хотите включить этот параметр?',
	'use_module_wrapper_template' => 'Использовать шаблон оболочки модуля

<div class="smallfont">Эта опция будет отображать вывод информации из {1}, с помощью шаблона \'adv_portal_module_wrapper\'.</div>',
	'usergroup_permissions' => 'Права пользовательских групп',
	'vba_dyna_copy' => 'Этот инструмент позволит Вам импортировать любой модуль из vBadvanced Dynamics, для использования в vBadvanced CMPS.',
	'vba_dyna_copy_module_text' => 'Этот инструмент позволит Вам импортировать любой модуль из vBadvanced Dynamics, для использования на страницах vBadvanced CMPS. Выберите модуль который Вы хотите импортировать и нажмите на кнопку ниже.',
	'vba_dyna_module' => 'Модули vBa Dynamics',
	'vbadvanced_cmps' => 'vBadvanced CMPS',
	'vbulletin_files_to_integrate' => 'vBulletin файлы для интеграции',
	'vbulletin_files_to_integrate_desc' => 'Выберите названия файлов из форума для интеграции с CMPS. Для выбора нескольких, зажмите \'Ctrl\' и выделите нужные мышью.',
	'vbulletin_forum_url' => 'Ссылка на форум',
	'version_info_unavailable' => 'Информация о версии vBadvanced в данный момент недоступна.',
	'view_edit_active_modules_on_this_page' => 'Посмотреть/Редактировать включенные модули на этой странице',
	'welcome_to_vba_cmps_control_panel' => 'Добро пожаловать в панель администратора vBadvanced CMPS',
	'x_link' => '{1} ссылка
<div class="smallfont">Если вы желаете, чтобы заголовок {1} ссылался на другую страницу вашего сайта, то вы можете ввести сюда файл, на который должен ссылаться {1}.</div>',
	'x_module' => '{1} модуль',
	'x_modules' => '{1} модули',
	'x_options' => '{1} опции',
	'x_page' => '{1} страница',
	'x_pages' => '{1} страницы',
	'x_settings_customized_for_this_page' => '{1} параметры содержимого этой страницы',
	'x_tools' => '{1} инструменты',
	'x_total_threads' => '{1} Всего тем',
	'x_y_options' => '{2} {1} опции',
	'yes_all_attachments' => 'Да, все вложения',
	'yes_first_attach_only' => 'Да, только новые вложения',
	'your_custom_content' => 'ваш модуль \'другое содержимое страницы\'',
	'your_vba_version_up_to_date' => 'Установленная версия vBadvanced CMPS является последней.'
);

$mainphrases['error'] = array(
	'adv_portal_cant_remove_default' => 'Вы не можете удалить страницу по умолчанию!',
	'adv_portal_cant_parent_page_itself' => 'Вы не можете создать страницу, являющуюся родительской для самой себя. Вернитесь назад и выберите другую родительскую страницу.',
	'adv_portal_choose_style' => 'Вы можете выбрать стиль, в котором желаете устанавливать шаблоны для этого модуля.',
	'adv_portal_custom_page_inactive' => 'Модуль &quot;другое содержимое страницы&quot; не активен на этой странице. Этот модуль отображает контент {1}, так же данный контент не будет доступен на других страницах.',
	'adv_portal_duplicate_identifier' => 'У вас уже есть {1} с идентификатором \'{2}\'. Пожалуйста, укажите другой идентификатор.',
	'adv_portal_integration_successfully_saved' => 'Параметры вашей интеграции успешно сохранены.',
	'adv_portal_invalid_cmps_url' => 'Не правильная ссылка: <a href="{1}" target="_blank">{1}</a>',
	'adv_portal_invalid_file_path' => 'Указанный вами путь {1} не является верным файлом на вашем сервере. Пожалуйста, вернитесь назад и введите полный путь (НЕ ссылка) к этому файлу.',
	'adv_portal_invalid_modfile' => 'Файл который вы загрузили, не является правильным файлом модуля.',
	'adv_portal_layouts_copied_successfully' => 'Ваш модуль был успешно скопирован.',
	'adv_portal_moddir_notwritable' => 'Ваша директория .modules недоступна для записи. Пожалуйста, установите права (chmod) для директории modules на 777 и попробуйте снова.',
	'adv_portal_module_saved_add_to_pages' => 'Ваш модуль успешно сохранен. Нажмите &quot;Назад&quot; чтобы добавить другой модуль, или нажмите &quot;Продолжить&quot; для активации вашего модуля на страницах CMPS.',
	'adv_portal_must_choose_php_file_include' => 'Для подключения содержимого вы должны выбрать PHP файл!',
	'adv_portal_must_choose_template_include' => 'Для подключения содержимого вы должны выбрать шаблон!',
	'adv_portal_must_choose_title_for_module' => 'Вы должны указать заголовок для вашего модуля!',
	'adv_portal_must_choose_x_type' => 'Вы должны указать тип {1} перед добавлением!',
	'adv_portal_must_enter_x_for_page' => 'Вы должны выбрать {1} для вашей страницы!',
	'adv_portal_no_files_to_integrate' => 'Вы не выбрали файлов для интеграции.',
	'adv_portal_no_valid_integration_pages' => 'Ни на одной из ваших страниц не используется интеграция с модулями. <a href="vba_cmps_admin.php?do=addpage&type=module">Нажмите сюда</a>, для добавления новых &quot;модулей&quot; для интеграции.',
	'adv_portal_must_select_file_integrate' => 'Вы не выбрали страницу CMPS для интеграции с этим файлом. Пожалуйста вернитесь назад и выберите страницу CMPS для интеграции с файлом THIS_SCRIPT.',
	'adv_portal_old_modules_found' => 'Один или несколько модулей на этой странице, были отключены администратором.',
        'adv_portal_page_saved_but_problems_found' => 'Страница была сохранена, обноружены следующие проблемы: {1}',
	'adv_portal_required_modules_not_found' => 'Один или несколько запрашиваемых модулей не были найдены в активированных для этой страницы. Эти модули были добавлены к низу центральной колонки.',
	'adv_portal_suhosin' => 'Поле обязательное для заполнение  - pageid, имеет некорректное значение.<br />Пожалуйста, посетите <a href="http://www.vbadvanced.com/forum/faq.php?faq=vba_trouble#faq_suhosin" target="_blank">vBadvanced FAQ</a>, для получения дополнительной информации по данной ошибке.',
	'adv_portal_template_exists' => 'Шаблон {1} уже существует в этом стиле. Пожалуйста, выберите другое название вашего шаблона, другой стиль, в который нужно установить шаблон, или просто пропустите поле  \'Содержимое шаблона\'. Помните, что вы можете также отредактировать этот шаблон через \'Управление стилями\'.',
	'adv_portal_threads_save_page' => 'Извините, но добавляемая вами новая страница не была создана, из-за этого темы не могут быть корректно сохранены. Вернитесь назад и сохраните страницу, которую вы создали в начале. Затем вы сможете выбрать темы при возвращении на страницу редактирования.',
	'adv_portal_x_rebuilt' => '{1} обновлены'
);

$mainphrases['cphome'] = array(
	'vba_cmps' => 'vBa CMPS',
	'edit_modules' => 'Редактировать модули',
	'edit_pages' => 'Редактировать страницы',
	'add_module' => 'Добавить модуль',
	'add_page' => 'Добавить страницу',
	'default_settings' => 'Параметры по умолчанию',
	'download_upload_module' => 'Скачать/Загрузить модуль',
	'quick_permissions_editor' => 'Быстрый редактор прав',
	'copy_module_layouts' => 'Копирование модулей',
	'integration' => 'Интеграция'
);

$mainphrases['vbsettings'] = array(
	'settinggroup_adv_portal_admin' => 'Опции панели администратора',
	'settinggroup_adv_portal_main' => 'Основные опции',
	'settinggroup_adv_portal_style' => 'Опции стиля',
	'settinggroup_adv_global' => 'Основные настройки vBadvanced'
);

$mainphrases['style'] = array(
	'group_adv_cmps' => 'vBadvanced CMPS'
);

// ##### Settings #############################################################
$mainsettings['adv_global'] = array(
	'global_header_replace' => array(
		'title' => 'Замены в Header',
		'description' => 'Здесь вы можете ввести названия файлов, которые могут появляться в вашем шаблоне header и к которым следует добавить ссылку вашего форума.',
		'value' => "album.php\r\ncalendar.php\r\nfaq.php\r\nforumdisplay.php\r\ngroup.php\r\nlogin.php\r\nmember.php\r\nmemberlist.php\r\nonline.php\r\nprivate.php\r\nprofile.php\r\nregister.php\r\nsearch.php\r\nsubscription.php\r\ntags.php\r\nusercp.php",
		'optioncode' => 'textarea',
		'displayorder' => '1'
	),
	'global_navbar_replace' => array(
		'title' => 'Замены в Navbar',
		'description' => 'Здесь вы можете ввести названия файлов, к которым следует добавить ссылку вашего форума.',
		'value' => "album.php\r\ncalendar.php\r\nfaq.php\r\nforumdisplay.php\r\ngroup.php\r\nlogin.php\r\nmember.php\r\nmemberlist.php\r\nonline.php\r\nprivate.php\r\nprofile.php\r\nregister.php\r\nsearch.php\r\nsubscription.php\r\ntags.php\r\nusercp.php",
		'optioncode' => 'textarea',
		'displayorder' => '2'
	),
	'global_footer_replace' => array(
		'title' => 'Замены в Footer',
		'description' => 'Здесь вы можете ввести названия файлов, которые могут появляться в вашем шаблоне footer и к которым следует добавить ссылку вашего форума.',
		'value' => "archive\r\nsendmessage.php\r\nprofile.php",
		'optioncode' => 'textarea',
		'displayorder' => '3'
	)
);

$mainsettings['adv_portal_birthdays'] = array(
	'portal_birth_newline' => array(
		'title' => 'Отображение пользователя на новой строчке',
		'description' => 'При включении данной опции, каждая запись о дне рождении пользователя, будет отображаться на новой строчке.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '10',
		'serialize' => 0
	)
);

$mainsettings['adv_portal_calendar'] = array(
	'portal_calendarid' => array(
			'title' => 'Отображаемый календарь',
			'description' => 'Выберите календарь, в котором нужно отображать события из вашего мини-календаря.',
			'value' => '1',
			'optioncode' => 'calendarselect',
			'displayorder' => '10',
			'serialize' => 0
		),
		'portal_calendar_birthdays' => array(
			'title' => 'Показывать дни рождения',
			'description' => 'Здесь вы можете выбрать вывод дней рождений из календаря ваших пользователей.',
			'value' => '0',
			'optioncode' => 'yesno',
			'displayorder' => '20',
			'serialize' => 0
		),
		'portal_calendar_cache' => array(
			'title' => 'Обновление кэша календаря',
			'description' => 'Введите здесь время (в часах) после которого кэш календаря будет обновляться. Это позволит кэшировать данные вашего календаря, препятствуя большому количеству запросов, когда данный модуль загружен. Плохая сторона кэширования календаря - новые события и дни рождения не будут добавлены до следующего обновления кэша. Укажите здесь 0 для отключения кэширования.',
			'value' => '12',
			'optioncode' => '',
			'displayorder' => '30',
			'serialize' => 0
		)
);

$mainsettings['adv_portal_latestthreads'] = array(
	'portal_threadids' => array(
			'title' => 'Темы',
			'description' => 'Здесь вы можете указать специфические темы, отображаемые с помощью этого модуля.',
			'value' => 'a:0:{}',
			'optioncode' => 'threadselect',
			'displayorder' => '10',
			'serialize' => 1
		),
		'portal_threads_forumids' => array(
			'title' => 'Последние темы с форума',
			'description' => 'Здесь вы можете выбрать раздел(ы), из которых следует отображать последние темы. Чтобы выбрать более чем один раздел, зажмите клавишу \'Ctrl\' и выделите нужные разделы с помощью мыши.',
			'value' => '',
			'optioncode' => 'forumselect',
			'displayorder' => '20',
			'serialize' => 1
		),
		'portal_threads_maxthreads' => array(
			'title' => 'Количество тем для отображения',
			'description' => 'Максимальное количество последних тем, которые следует отображать.',
			'value' => '10',
			'optioncode' => '',
			'displayorder' => '30',
			'serialize' => 0
		),
		'portal_threads_cutoffdate' => array(
			'title' => 'Выборка по дате',
			'description' => 'Здесь вы можете ввести количество дней, определяющих временной предел для последних тем. Любые темы, в которых никто не отвечал до текущей даты минус это количество дней, не будут включены. Это предотвращает большие поисковые запросы по таблице на больших форумах. Установите параметр на 0 для снятия ограничения.',
			'value' => '30',
			'optioncode' => '',
			'displayorder' => '40',
			'serialize' => 0
		),
		'portal_threads_maxchars' => array(
			'title' => 'Максимально отображаемое количество символов в названии темы',
			'description' => 'аксимальное количество символов в названии темы, после которых появится \'...\'. Установите здесь 0, чтобы снять ограничения.',
			'value' => '25',
			'optioncode' => '',
			'displayorder' => '50',
			'serialize' => 0
		),
		'portal_threads_maxwordchars' => array(
			'title' => 'Максимальное количество символов в каждом слове',
			'description' => 'Максимальное количество символов, которое может содержать слово. Любые темы, содержащие слова с большим количеством символов, чем указано здесь, будут обрезаны до этого значения (помогает предотвращать создание тем с большими названиями, растягивающими страницу).',
			'value' => '20',
			'optioncode' => '',
			'displayorder' => '60',
			'serialize' => 0
		),
		'portal_threads_orderby' => array(
			'title' => 'Порядок отображения тем',
			'description' => 'Порядок, в котором должны отображаться темы.',
			'value' => 'lastpost',
			'optioncode' => '<select name=\\"$name\\" " . $jsdefault_onchange . " class=\\"bginput\\" tabindex=\\"1\\">
	<option " . iif($setting[value] == \'lastpost\', \'selected=\\"selected\\"\'). " value=\\"lastpost\\">$vbphrase[last_post]</option>
	<option " . iif($setting[value] == \'dateline\', \'selected=\\"selected\\"\'). " value=\\"dateline\\">$vbphrase[date_created]</option>
	<option " . iif($setting[value] == \'title\', \'selected=\\"selected\\"\'). " value=\\"title\\">$vbphrase[thread_title]</option>
	<option " . iif($setting[value] == \'voteavg\', \'selected=\\"selected\\"\'). " value=\\"voteavg\\">$vbphrase[rating]</option>
	<option " . iif($setting[value] == \'replycount\', \'selected=\\"selected\\"\'). " value=\\"replycount\\">$vbphrase[replies]</option>
	<option " . iif($setting[value] == \'views\', \'selected=\\"selected\\"\'). " value=\\"views\\">$vbphrase[views]</option>
</select>',
			'displayorder' => '70',
			'serialize' => 0
		),
		'portal_threads_direction' => array(
			'title' => 'Направление отображения тем',
			'description' => 'Направление, в котором следует отображать темы.',
			'value' => 'DESC',
			'optioncode' => '<select name=\\"$name\\" " . $jsdefault_onchange . " class=\\"bginput\\" tabindex=\\"1\\">
	<option " . iif($setting[value] == \'ASC\', \'selected=\\"selected\\"\'). " value=\\"ASC\\">$vbphrase[ascending]</option>
	<option " . iif($setting[value] == \'DESC\', \'selected=\\"selected\\"\'). " value=\\"DESC\\">$vbphrase[descending]</option>
</select>',
			'displayorder' => '80',
			'serialize' => 0
		),
		'portal_threads_expanded' => array(
			'title' => 'Использование расширенного шаблона тем',
			'description' => 'Эта опция используется для переключения между \'adv_portal_recthreads_lean\' и \'adv_portal_recthreads_exp\' шаблонами.',
			'value' => '2',
			'optioncode' => '<div class=\\"smallfont\\">
	<input name=\\"$name\\" id=\\"$setting[varname]_0\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 0, \'checked=\\"checked\\"\'). " value=\\"0\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_0\\">$vbphrase[lean]</label><br />
	<input name=\\"$name\\" id=\\"$setting[varname]_1\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 1, \'checked=\\"checked\\"\'). " value=\\"1\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_1\\">$vbphrase[expanded]</label><br />
	<input name=\\"$name\\" id=\\"$setting[varname]_2\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 2, \'checked=\\"checked\\"\'). " value=\\"2\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_2\\">$vbphrase[dynamic]</label>
</div>',
			'displayorder' => '90',
			'serialize' => 0
		),
		'portal_applypermissions' => array(
			'title' => 'Применять права форума',
			'description' => 'Когда установлено \'Да\', будут запрашиваться права учётной записи на форуме, и темы будут показаны, только если пользователь имеет права на их просмотр.',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '100',
			'serialize' => 0
		),
		'portal_threads_threadstarter' => array(
			'title' => 'Показывать автора темы',
			'description' => 'Отображать автора темы и ссылку на его профиль?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '110',
			'serialize' => 0
		),
		'portal_threads_showdate' => array(
			'title' => 'Показывать дату и время',
			'description' => 'Отображать дату и время создания темы?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '120',
			'serialize' => 0
		),
		'portal_threads_views' => array(
			'title' => 'Показывать число просмотров',
			'description' => 'Отображать число просмотров темы?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '130',
			'serialize' => 0
		),
		'portal_threads_replies' => array(
			'title' => 'Показывать число ответов',
			'description' => 'Отображать число ответов в теме?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '140',
			'serialize' => 0
		),
		'portal_threads_lastpost' => array(
			'title' => 'Показывать информацию о последнем сообщении',
			'description' => 'Отображать последнего ответившего в теме и время ответа?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '150',
			'serialize' => 0
		),
		'portal_threads_showforum' => array(
			'title' => 'Показывать раздел',
			'description' => 'Отображать название и ссылку на раздел, в котором было оставлено это сообщение?',
			'value' => '0',
			'optioncode' => 'yesno',
			'displayorder' => '160',
			'serialize' => 0
		),
		'portal_threads_showpreview' => array(
			'title' => 'Показывать предпросмотр тем',
			'description' => 'Стоит ли отображать предпросмотр темы, как и на странице отображения разделов форума?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '170',
			'serialize' => 0
		),
		'portal_threads_showicon' => array(
			'title' => 'Показывать иконки тем',
			'description' => 'Отображать иконку тем?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '180',
			'serialize' => 0
		),
		'portal_threads_showsubscribed' => array(
			'title' => 'Показывать иконку подписки',
			'description' => 'Отображать ли иконку \'подписки\' около названия тем, на которые подписан пользователь?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '190',
			'serialize' => 0
		),
		'portal_threads_showrating' => array(
			'title' => 'Показывать рейтинг тем(ы)',
			'description' => 'Отображать рейтинг тем(ы)?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '200',
			'serialize' => 0
		),
		'portal_threads_stickyicon' => array(
			'title' => 'Показывать иконки у важных тем',
			'description' => 'Отображать иконку у \'важных тем\'? Такие темы будут иметь выделение &quot;Важная&quot;.',
			'value' => '0',
			'optioncode' => 'yesno',
			'displayorder' => '210',
			'serialize' => 0
		),
		'portal_threads_multipage' => array(
			'title' => 'Показывать ссылки на последнюю страницу тем',
			'description' => 'Отображать ссылку на последнюю страницу тем?',
			'value' => '0',
			'optioncode' => 'yesno',
			'displayorder' => '220',
			'serialize' => 0
		),
		'portal_threads_showpaperclip' => array(
			'title' => 'Показывать вложения',
			'description' => 'Отображать количество скачиваний вложений в темах?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '230',
			'serialize' => 0
		),
		'portal_threads_newpostarrow' => array(
			'title' => 'Показывать указатель на новые сообщения',
			'description' => 'Отображать указатель на новые сообщения в теме?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '240',
			'serialize' => 0
		),
		'portal_threads_prefix' => array(
			'title' => 'Показывать префикс',
			'description' => 'Отображать префикс у тем? Данная функция работает только на линейке vBulletin 3.7+.',
			'value' => '0',
			'optioncode' => 'yesno',
			'displayorder' => '250',
			'serialize' => 0
		)
);

$mainsettings['adv_portal_navigation'] = array(
	'portal_navigation_excludepages' => array(
			'title' => 'Исключаемые страницы',
			'description' => 'Здесь вы можете выбирать страницы, из которых вы не хотели бы отображать в этом модуле. Для выбора более чем одной страницы, зажмите кнопку \'Ctrl\' и отметьте нужные страницы мышью.',
			'value' => '',
			'optioncode' => 'pageselect',
			'displayorder' => '10',
			'serialize' => 1
		),
		'portal_navigation_mark1' => array(
			'title' => 'Отметка для 1 уровня',
			'description' => 'Это то, что будет отображаться слева от названия страницы, если у неё нет родительской.',
			'value' => '&raquo;',
			'optioncode' => '',
			'displayorder' => '20',
			'serialize' => 0
		),
		'portal_navigation_mark2' => array(
			'title' => 'Отметка для 2+ уровня',
			'description' => 'Это то, что будет отображаться слева от названия страницы, если у неё есть родительская.',
			'value' => '&gt;',
			'optioncode' => '',
			'displayorder' => '30',
			'serialize' => 0
		),
		'portal_navigation_addpages' => array(
			'title' => 'Дополнительные страницы',
			'description' => 'Здесь вы можете ввести любые дополнительные страницы, на которые следует отображать ссылку в этом модуле. Просто введите название страницы в первую колонку и адрес на неё во вторую. Опция \'Уровень\' добавит в ссылку указанное число пробелов, создав связь "принадлежности" этой страницы, к первой странице у которой уровень ниже.',
			'value' => 'a:3:{i:0;a:4:{s:5:"order";s:1:"1";s:5:"level";s:1:"1";s:4:"link";s:65:"{$vbulletin->options[bburl]}/{$vbulletin->options[forumhome]}.php";s:4:"text";s:5:"Форум";}i:1;a:4:{s:5:"order";s:1:"2";s:5:"level";s:1:"2";s:4:"link";s:39:"{$vbulletin->options[bburl]}/usercp.php";s:4:"text";s:7:"Мой кабинет";}i:2;a:4:{s:5:"order";s:1:"3";s:5:"level";s:1:"2";s:4:"link";s:36:"{$vbulletin->options[bburl]}/faq.php";s:4:"text";s:3:"Справка";}}',
			'optioncode' => 'pageselect_add',
			'displayorder' => '40',
			'serialize' => 1
		)
);


$mainsettings['adv_portal_news'] = array(
	'portal_threadids' => array(
			'title' => 'Темы',
			'description' => 'Здесь вы можете выбирать темы для отображения с этим модулем. Пожалуйста, помните, что эти параметры переопределят опцию выборки из раздела.',
			'value' => 'a:0:{}',
			'optioncode' => 'threadselect',
			'displayorder' => '10',
			'serialize' => 1
		),
		'portal_news_forumid' => array(
			'title' => 'Новости раздела(ов)',
			'description' => 'Здесь вы можете выбирать раздел(ы), из которых вы хотели бы отображать темы в новостях. Для выбора более чем одного раздела, зажмите кнопку \'Ctrl\' и отметьте нужные разделы мышью.',
			'value' => 'a:0:{}',
			'optioncode' => 'forumselect',
			'displayorder' => '20',
			'serialize' => 1
		),
		'portal_news_maxposts' => array(
			'title' => 'Максимальное количество отображаемых тем',
			'description' => 'Максимальное количество тем для отображения. Установите этот параметр на 0, чтобы показывать все.',
			'value' => '5',
			'optioncode' => '',
			'displayorder' => '30',
			'serialize' => 0
		),
		'portal_news_threadsperpage' => array(
			'title' => 'Навигация по страницам',
			'description' => 'Этот параметр позволяет добавить небольшую секцию навигации по страницам под вашим модулем новостей, которая будет содержать ссылки на другие страницы с новостями. Введите максимальное количество страниц, которые следует отображать в этой секции.',
			'value' => '0',
			'optioncode' => '',
			'displayorder' => '40',
			'serialize' => 0
		),
		'portal_news_cutoffdate' => array(
			'title' => 'Выборка по дате',
			'description' => 'Здесь вы можете ввести количество дней, определяющих временной предел для новых сообщений. Любые темы, которые были созданы/обновлены до текущей даты минус это количество дней, не будут включены. Это предотвращает большие поисковые запросы по таблице на больших форумах. Установите параметр на 0 для снятия ограничения.',
			'value' => '90',
			'optioncode' => '',
			'displayorder' => '50',
			'serialize' => 0
		),
		'portal_news_maxchars' => array(
			'title' => 'Максимальное количество символов для отображения',
			'description' => 'Максимальное количество символов, которые нужно отображать из сообщения, до ссылки \'[Читать дальше]\'. Установите здесь 0, чтобы показывать сообщения полностью.',
			'value' => '500',
			'optioncode' => '',
			'displayorder' => '60',
			'serialize' => 0
		),
		'portal_news_dateformat' => array(
			'title' => 'Формат даты и времени',
			'description' => 'Очистите это поле, если не желаете отображать время создания сообщения.',
			'value' => 'd.M.Y H:i',
			'optioncode' => '',
			'displayorder' => '70',
			'serialize' => 0
		),
		'portal_news_orderby' => array(
			'title' => 'Порядок отображения тем',
			'description' => 'В каком порядке должны сортироваться темы.',
			'value' => 'postdateline',
			'optioncode' => '<select name=\\"$name\\" " . $jsdefault_onchange . " class=\\"bginput\\" tabindex=\\"1\\">
	<option " . iif($setting[value] == \'lastpost\', \'selected=\\"selected\\"\'). " value=\\"lastpost\\">$vbphrase[last_post]</option>
	<option " . iif($setting[value] == \'postdateline\', \'selected=\\"selected\\"\'). " value=\\"postdateline\\">$vbphrase[date_created]</option>
	<option " . iif($setting[value] == \'title\', \'selected=\\"selected\\"\'). " value=\\"title\\">$vbphrase[thread_title]</option>
	<option " . iif($setting[value] == \'voteavg\', \'selected=\\"selected\\"\'). " value=\\"voteavg\\">$vbphrase[rating]</option>
	<option " . iif($setting[value] == \'replycount\', \'selected=\\"selected\\"\'). " value=\\"replycount\\">$vbphrase[replies]</option>
	<option " . iif($setting[value] == \'views\', \'selected=\\"selected\\"\'). " value=\\"views\\">$vbphrase[views]</option>
</select>',
			'displayorder' => '80',
			'serialize' => 0
		),
		'portal_news_direction' => array(
			'title' => 'Направление отображения тем',
			'description' => 'Направление, в котором будут отображаться темы.',
			'value' => 'DESC',
			'optioncode' => '<select name=\\"$name\\" " . $jsdefault_onchange . " class=\\"bginput\\" tabindex=\\"1\\">
	<option " . iif($setting[value] == \'ASC\', \'selected=\\"selected\\"\'). " value=\\"ASC\\">$vbphrase[ascending]</option>
	<option " . iif($setting[value] == \'DESC\', \'selected=\\"selected\\"\'). " value=\\"DESC\\">$vbphrase[descending]</option>
</select>',
			'displayorder' => '90',
			'serialize' => 0
		),
		'portal_news_showattachments' => array(
			'title' => 'Включить вложения',
			'description' => 'Отображать вложения в новых сообщениях.',
			'value' => '0',
			'optioncode' => '<div class=\\"smallfont\\">
	<input name=\\"$name\\" id=\\"$setting[varname]_0\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 0, \'checked=\\"checked\\"\'). " value=\\"0\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_0\\">$vbphrase[no]</label><br />
	<input name=\\"$name\\" id=\\"$setting[varname]_1\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 1, \'checked=\\"checked\\"\'). " value=\\"1\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_1\\">$vbphrase[yes_first_attach_only]</label><br />
	<input name=\\"$name\\" id=\\"$setting[varname]_2\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 2, \'checked=\\"checked\\"\'). " value=\\"2\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_2\\">$vbphrase[yes_all_attachments]</label>
</div>',
			'displayorder' => '100',
			'serialize' => 0
		),
		'portal_applypermissions' => array(
			'title' => 'Применять права форума',
			'description' => 'Когда установлено \'Да\', будут запрашиваться права учётной записи на форуме, и темы будут показаны, только если пользователь имеет права на их просмотр.',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '110',
			'serialize' => 0
		),
		'portal_news_allowreplies' => array(
			'title' => 'Показывать информацию об ответе',
			'description' => 'Отображать информацию о количестве ответов в темах?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '120',
			'serialize' => 0
		),
		'portal_news_showviews' => array(
			'title' => 'Показывать число просмотров',
			'description' => 'Отображать информацию о количестве просмотров?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '130',
			'serialize' => 0
		),
		'portal_news_showavatar' => array(
			'title' => 'Показывать аватары',
			'description' => 'Отображать аватары пользователей в каждом сообщении?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '140',
			'serialize' => 0
		),
		'portal_news_showicon' => array(
			'title' => 'Показывать иконки сообщений',
			'description' => 'Отображать иконки для каждого сообщения?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '150',
			'serialize' => 0
		),
		'portal_news_showrating' => array(
			'title' => 'Показывать рейтинги',
			'description' => 'Отображать рейтинг каждого сообщения?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '160',
			'serialize' => 0
		),
		'portal_news_showsubscribed' => array(
			'title' => 'Показывать иконки подписанных тем',
			'description' => 'Отображать иконку \'подписки\' около названия тем, на которые подписан пользователь?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '170',
			'serialize' => 0
		),
		'portal_news_showprintable' => array(
			'title' => 'Показывать ссылку на версию для печати',
			'description' => 'Отображать иконку \'версия для печати\', чтобы пользователи могли быстро распечатать тему, не затрачивая много краски?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '180',
			'serialize' => 0
		),
		'portal_news_showsendfriend' => array(
			'title' => 'Показывать "отправить ссылку другу"',
			'description' => 'Отображать иконку \'отправить другу\', чтобы пользователи могли быстро отправить друзьями email с ссылкой на тему?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '190',
			'serialize' => 0
		),
		'portal_news_showsignature' => array(
			'title' => 'Показывать подписи',
			'description' => 'Эта опция определяет, стоит отображать подпись пользователя в сообщениях. Помните, что опция \'Показывать вашу подпись\' при создании сообщения всё ещё может использоваться для выключения подписи в выбранных сообщениях.',
			'value' => '0',
			'optioncode' => 'yesno',
			'displayorder' => '200',
			'serialize' => 0
		),
		'portal_news_sticky' => array(
			'title' => 'Показывать прикреплённые сообщения вверху',
			'description' => 'Эта опция определяет, стоит ли отображать важные темы наверху раздела новостей.',
			'value' => '0',
			'optioncode' => 'yesno',
			'displayorder' => '210',
			'serialize' => 0
		),
		'portal_news_legacy' => array(
			'title' => 'Разделять новости',
			'description' => 'Эта опция определяет, как отображать сообщения: вместе или раздельно.',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '220',
			'serialize' => 0
		),
		'portal_news_attachpaperclip' => array(
			'title' => 'Показывать вложения',
			'description' => 'Отображать количество скачиваний вложений в темах?',
			'value' => '0',
			'optioncode' => 'yesno',
			'displayorder' => '230',
			'serialize' => 0
		),
		'portal_news_bbcode_attach' => array(
			'title' => 'Включить BB код тега [ATTACH]',
			'description' => 'Эта опция позволяет, включить BB код тега [ATTACH]?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '240',
			'serialize' => 0
		),
		'portal_news_prefix' => array(
			'title' => 'Показывать префикс',
			'description' => 'Отображать префикс у тем? Данная функция работает только на линейке vBulletin 3.7+.',
			'value' => '0',
			'optioncode' => 'yesno',
			'displayorder' => '250',
			'serialize' => 0
		),
		'portal_news_postcache' => array(
			'title' => 'Использовать кэш сообщений',
			'description' => 'Эта опция позволит включить использование кэша сообщений для новостей, чтобы не обрабатывать BB код каждый раз при загрузке страницы. Это добавит производительности на сайтах с большим количеством новых сообщений, но выключит опции BB кодов и заставит модуль использовать для новостей ваши настройки форума.',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '260',
			'serialize' => 0
		),
		'portal_news_enablehtml' => array(
			'title' => 'Разрешить HMTL',
			'description' => 'Разрешить обработку HTML кода в сообщениях.',
			'value' => '0',
			'optioncode' => 'yesno',
			'displayorder' => '270',
			'serialize' => 0
		),
		'portal_news_enablevbcode' => array(
			'title' => 'Разрешить BB код',
			'description' => 'Разрешить BB код в сообщениях.',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '280',
			'serialize' => 0
		),
		'portal_news_enablevbimage' => array(
			'title' => 'Разрешить [IMG] код',
			'description' => 'Разрешить [IMG] код в сообщениях.',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '290',
			'serialize' => 0
		),
		'portal_news_enablesmilies' => array(
			'title' => 'Разрешить смайлы',
			'description' => 'Разрешить смайлы в сообщениях.',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '300',
			'serialize' => 0
		)
);

$mainsettings['adv_portal_newsarchive'] = array(
	'portal_news_enablearchive' => array(
			'title' => 'Количество новостей в архиве для отображения',
			'description' => 'Укажите число новых сообщений, которые вы хотите отображать в архиве новостей. Установите этот параметр на 0, чтобы выключить архив новостей.',
			'value' => '5',
			'optioncode' => '',
			'displayorder' => '10',
			'serialize' => 0
		),
		'portal_archive_maxchars' => array(
			'title' => 'Максимальное количество символов в заголовке тем',
			'description' => 'Укажите максимальное число символов в заголовке тем, если количество символов превышено, то все лишние символы будут заменены на \'...\'. Установите этот параметр на 0, для снятия ограничений.',
			'value' => '25',
			'optioncode' => '',
			'displayorder' => '20',
			'serialize' => 0
		),
		'portal_archive_expanded' => array(
			'title' => 'Использование расширенного шаблона архива',
			'description' => 'Эта опция используется для переключения между \'adv_portal_archivebits_lean\' и \'adv_portal_archivebits_exp\' шаблонами.',
			'value' => '2',
			'optioncode' => '<div class=\\"smallfont\\">
	<input name=\\"$name\\" id=\\"$setting[varname]_0\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 0, \'checked=\\"checked\\"\'). " value=\\"0\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_0\\">$vbphrase[lean]</label><br />
	<input name=\\"$name\\" id=\\"$setting[varname]_1\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 1, \'checked=\\"checked\\"\'). " value=\\"1\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_1\\">$vbphrase[expanded]</label><br />
	<input name=\\"$name\\" id=\\"$setting[varname]_2\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 2, \'checked=\\"checked\\"\'). " value=\\"2\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_2\\">$vbphrase[dynamic]</label>
</div>',
			'displayorder' => '30',
			'serialize' => 0
		),
		'portal_news_archivepreview' => array(
			'title' => 'Показывать предпросмотр в архиве?',
			'description' => 'Эта опция разрешит вам показывать предпросмотр архивных тем, как и на странице отображения раздела на форуме.',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '40',
			'serialize' => 0
		),
		'portal_archive_threadstarter' => array(
			'title' => 'Показывать автора темы',
			'description' => 'Отображать автора темы и ссылку на его профиль?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '50',
			'serialize' => 0
		),
		'portal_archive_showdate' => array(
			'title' => 'Показывать дату и время',
			'description' => 'Отображать дату и время сообщения?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '60',
			'serialize' => 0
		),
		'portal_archive_showviews' => array(
			'title' => 'Показывать просмотры',
			'description' => 'Отображать число просмотров темы?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '70',
			'serialize' => 0
		),
		'portal_archive_showreplies' => array(
			'title' => 'Показывать ответы',
			'description' => 'Отображать число ответов в теме?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '80',
			'serialize' => 0
		),
		'portal_newsarchive_lastpost' => array(
			'title' => 'Показывать информацию о последнем сообщении',
			'description' => 'Отображать последнего ответившего пользователя и время, когда было создано последнее сообщение.',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '90',
			'serialize' => 0
		),
		'portal_newsarchive_showforum' => array(
			'title' => 'Показывать раздел',
			'description' => 'Отображать название и ссылку на раздел, в котором было создано сообщение.',
			'value' => '0',
			'optioncode' => 'yesno',
			'displayorder' => '100',
			'serialize' => 0
		),
		'portal_archive_showrating' => array(
			'title' => 'Показывать рейтинг',
			'description' => 'Отображать рейтинг темы?',
			'value' => '0',
			'optioncode' => 'yesno',
			'displayorder' => '110',
			'serialize' => 0
		),
		'portal_archive_showicon' => array(
			'title' => 'Показывать иконки сообщений',
			'description' => 'Отображать иконки для каждого сообщения?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '120',
			'serialize' => 0
		),
		'portal_archive_showsubscribed' => array(
			'title' => 'Показывать иконки подписанных тем',
			'description' => 'Отображать иконку \'подписки\' около названия тем, на которые подписан пользователь?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '130',
			'serialize' => 0
		),
		'portal_archive_stickyicon' => array(
			'title' => 'Показывать иконки у важных тем',
			'description' => 'Отображать иконку у \'важных тем\', такие темы будут иметь выделение &quot;Важная&quot;.',
			'value' => '0',
			'optioncode' => 'yesno',
			'displayorder' => '140',
			'serialize' => 0
		),
		'portal_archive_multipage' => array(
			'title' => 'Показывать ссылки на последнюю страницу тем',
			'description' => 'Отображать ссылку на последнюю страницу тем?',
			'value' => '0',
			'optioncode' => 'yesno',
			'displayorder' => '150',
			'serialize' => 0
		),
		'portal_archive_attachpaperclip' => array(
			'title' => 'Показывать вложения',
			'description' => 'Отображать количество скачиваний вложений в темах?',
			'value' => '0',
			'optioncode' => 'yesno',
			'displayorder' => '160',
			'serialize' => 0
		)
);

$mainsettings['adv_portal_poll'] = array(
	'portal_threadids' => array(
			'title' => 'Темы',
			'description' => 'Здесь вы можете указать специфические темы, отображаемые с помощью этого модуля. Пожалуйста, помните, что этот параметр перезапишет параметр ниже для раздела, в котором находятся эти темы.',
			'value' => '',
			'optioncode' => 'threadselect',
			'displayorder' => '10',
			'serialize' => 1
		),
		'portal_poll_forumid' => array(
			'title' => 'Голосование из раздела(ов)',
			'description' => 'Здесь вы можете выбирать раздел(ы), в которых вы хотели бы отображать голосования. Для выбора более чем одного раздела, зажмите кнопку \'Ctrl\' и отметьте нужные разделы мышью.',
			'value' => '',
			'optioncode' => 'forumselect',
			'displayorder' => '20',
			'serialize' => 1
		),
		'portal_poll_cutoffdate' => array(
			'title' => 'Выборка по дате',
			'description' => 'Здесь вы можете ввести количество дней, определяющих временной предел для голосований. Любые голосования, которые были созданы до текущей даты минус это количество дней, не будут включены. Это предотвращает большие поисковые запросы по таблице на больших форумах. Установите параметр на 0 для снятия ограничения.',
			'value' => '30',
			'optioncode' => '',
			'displayorder' => '30',
			'serialize' => 0
		),
                'portal_poll_wraptitle' => array(
		'title' => 'Максимальное количество символов в названии опроса',
		'description' => 'Введите сюда, максимальное количество символов, которое может содержать название опроса, при превышении данного лимита, текст будет разбит на несколько строк. Введите 0, для снятия ограничения.',
		'value' => '0',
		'optioncode' => '',
		'displayorder' => '40',
		'serialize' => 0
	),
	'portal_poll_wrapchoices' => array(
		'title' => 'Максимальное количество символов в ответах к опросу',
		'description' => 'Введите сюда, максимальное количество символов, которое может ответ в опросе, при превышении данного лимита, текст будет разбит на несколько строк. Введите 0, для снятия ограничения.',
		'value' => '0',
		'optioncode' => '',
		'displayorder' => '50',
		'serialize' => 0
	),
		'portal_poll_orderby' => array(
			'title' => 'Порядок отображения голосований',
			'description' => 'Порядок, в котором должно отображаться голосование.',
			'value' => 'dateline',
			'optioncode' => '<select name=\\"$name\\" " . $jsdefault_onchange . " class=\\"bginput\\" tabindex=\\"1\\">
	<option " . iif($setting[value] == \'dateline\', \'selected=\\"selected\\"\'). " value=\\"dateline\\">$vbphrase[date_created]</option>
	<option " . iif($setting[value] == \'votedate\', \'selected=\\"selected\\"\'). " value=\\"votedate\\">$vbphrase[last_vote]</option>
	<option " . iif($setting[value] == \'rand\', \'selected=\\"selected\\"\'). " value=\\"rand\\">$vbphrase[random]</option>
</select>',
			'displayorder' => '60',
			'serialize' => 0
		),
		'portal_poll_direction' => array(
			'title' => 'Направление отображения голосований',
			'description' => 'Направление, в котором должно отображаться голосование.',
			'value' => 'DESC',
			'optioncode' => '<select name=\\"$name\\" " . $jsdefault_onchange . " class=\\"bginput\\" tabindex=\\"1\\">
	<option " . iif($setting[value] == \'ASC\', \'selected=\\"selected\\"\'). " value=\\"ASC\\">$vbphrase[ascending]</option>
	<option " . iif($setting[value] == \'DESC\', \'selected=\\"selected\\"\'). " value=\\"DESC\\">$vbphrase[descending]</option>
</select>',
			'displayorder' => '70',
			'serialize' => 0
		),
		'portal_applypermissions' => array(
			'title' => 'Применять права форума',
			'description' => 'Когда установлено \'Да\', будут запрашиваться права учётной записи на форуме, и темы будут показаны, только если пользователь имеет права на их просмотр.',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '80',
			'serialize' => 0
		),
		'portal_poll_allowclosed' => array(
			'title' => 'Показывать закрытые опросоы',
			'description' => 'При включении данной опции, закрытые опросы будут отображаться.',
			'value' => '0',
			'optioncode' => 'yesno',
			'displayorder' => '90',
			'serialize' => 0
		),
		'portal_poll_allowreplies' => array(
			'title' => 'Показывать информацию об ответе',
			'description' => 'Эта опция покажет ссылку \'Ответить в опросе\' в ваших опросах, давая пользователям возможность быстро высказать мнение о нём.',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '100',
			'serialize' => 0
		),
		'portal_poll_allowsmilies' => array(
			'title' => 'Разрешить смайлы',
			'description' => 'Разрешить смайлы в опциях голосования.',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '110',
			'serialize' => 0
		)
);

$mainsettings['adv_portal_stats'] = array(
	'portal_stats_updatefrequency' => array(
			'title' => 'Частота обновления лучших авторов',
			'description' => 'Чтобы предотвратить большой поиск по таблицам, список лучших авторов обновляется раз в несколько часов, когда информация передаётся в кэш. Здесь вы можете указать количеств часов между каждой проверкой на изменение списка лучших авторов. Установив этот параметр на 0 вы выключите задержку, то каждый раз будет выполняться подсчёт сообщений для составления этого списка.',
			'value' => '24',
			'optioncode' => '',
			'displayorder' => '10',
			'serialize' => 0
		),
		'portal_stats_topposter_posts' => array(
			'title' => 'Кэшировать количество сообщений у лучших авторов?',
			'description' => 'Если эта опция включена, то будет происходить кэширование количества сообщений у лучших авторов. Хотя запрос к базе данных количества сообщений у лучших авторов не такой уж и ресурсоёмкий, но, всё же, на крупных сайтах администратор может пожелать кэшировать эти данные, чтобы сократить количество запросов. Минусом кэширования количества сообщений является то, что данные часто будут не точными, так как будут обновляться через некоторые промежутки времени.',
			'value' => '0',
			'optioncode' => 'yesno',
			'displayorder' => '20',
			'serialize' => 0
		),
		'portal_stats_cacheforums' => array(
			'title' => 'Частота обновления кэша форума',
			'description' => 'Если вы включили кэширование статистики форума в этом модуле (количество тем и сообщений), то введите здесь число, которое будет определять через сколько часов следует пересчитывать данные. Запрос к базе данных не очень ресурсоёмкий, но администраторы крупных сайтов или форумов с более чем 100 разделами могут включить эту функцию для большей производительности.',
			'value' => '0',
			'optioncode' => '',
			'displayorder' => '30',
			'serialize' => 0
		),
		'portal_stats_forumperms' => array(
			'title' => 'Применение прав доступа форума',
			'description' => 'При включении данной опции, разрешение просмотра статистики будет доступно только пользователям которые имеют разрешение на это.',
			'value' => '0',
			'optioncode' => 'yesno',
			'displayorder' => '40',
			'serialize' => 0
	),
		'portal_stats_threads' => array(
			'title' => 'Число тем для показа',
			'description' => 'При включении данной опции, у вас будет отображаться информация по темам.',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '50',
			'serialize' => 0
		),
		'portal_stats_posts' => array(
			'title' => 'Число сообщений для показа',
			'description' => 'При включении данной опции, у вас будет отображаться информация по сообщениям.',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '60',
			'serialize' => 0
		),
		'portal_stats_members' => array(
			'title' => 'Число пользователей для показа',
			'description' => 'При включении данной опции, у вас будет отображаться информация по пользователям.',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '70',
			'serialize' => 0
		),
		'portal_stats_newestmember' => array(
			'title' => 'Число новых пользователей для показа',
			'description' => 'При включении данной опции, у вас будет отображаться информация по новым пользователям.',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '80',
			'serialize' => 0
		),
		'portal_stats_topposter' => array(
			'title' => 'Показывать лучшего автора',
			'description' => 'При включении данной опции, у вас будет отображаться информация по лучшему автору.',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '90',
			'serialize' => 0
		)
);

$mainsettings['adv_portal_welcomeblock'] = array(
	'portal_welcome_lastvisit_date' => array(
			'title' => 'Формат даты последнего посещения',
			'description' => 'Формат, в котором следует отображать дату последнего посещения пользователем сайта.',
			'value' => 'd.m.y',
			'optioncode' => '',
			'displayorder' => '10',
			'serialize' => 0
		),
		'portal_welcome_lastvisit_time' => array(
			'title' => 'Формат времени последнего посещения',
			'description' => 'Формат, в котором следует отображать время последнего посещения пользователем сайта.',
			'value' => 'H:i',
			'optioncode' => '',
			'displayorder' => '20',
			'serialize' => 0
		),
		'portal_noavatarurl' => array(
			'title' => 'Ссылка до изображения &quot;Аватар не установлен&quot;',
			'description' => 'Если вы хотите чтобы отображалось &quot;Аватар не установлен&quot;, то введите путь до данного изображения здесь.<br />
Примечание: Этот параметр подставляет путь до вашего форума {$vbulletin->options[bburl]}.',
			'value' => '{$vbulletin->options[bburl]}/images/misc/noavatar.gif',
			'optioncode' => '',
			'displayorder' => '30',
			'serialize' => 0
		),
		'portal_welcome_expanded' => array(
			'title' => 'Использование расширенного шаблона блока приветствия',
			'description' => 'Эта опция используется для переключения между \'adv_portal_welcomeblock_lean\' и \'adv_portal_welcomeblock_expanded\' шаблонами.',
			'value' => '2',
			'optioncode' => '<div class=\\"smallfont\\">
	<input name=\\"$name\\" id=\\"$setting[varname]_0\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 0, \'checked=\\"checked\\"\'). " value=\\"0\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_0\\">$vbphrase[lean]</label><br />
	<input name=\\"$name\\" id=\\"$setting[varname]_1\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 1, \'checked=\\"checked\\"\'). " value=\\"1\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_1\\">$vbphrase[expanded]</label><br />
	<input name=\\"$name\\" id=\\"$setting[varname]_2\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 2, \'checked=\\"checked\\"\'). " value=\\"2\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_2\\">$vbphrase[dynamic]</label>
</div>',
			'displayorder' => '40',
			'serialize' => 0
		),
		'portal_welcome_newpms' => array(
			'title' => 'Показывать информацию о личных сообщениях',
			'description' => 'Отображать информацию о личных сообшениях у пользователей?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '50',
			'serialize' => 0
		),
		'portal_welcome_avatar' => array(
			'title' => 'Показывать аватар пользователя',
			'description' => 'Отображать аватар пользователя?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '60',
			'serialize' => 0
		),
		'portal_welcome_newposts' => array(
			'title' => 'Показывать новые сообщения',
			'description' => 'Отображать число новых сообщений с последнего посещения пользователями сайта, вместе с ссылкой на новые сообщения?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '70',
			'serialize' => 0
		),
		'portal_welcome_rep' => array(
			'title' => 'Показывать репутацию',
			'description' => 'Отображать изображение текущей репутации пользователя и вес репутации?',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '80',
			'serialize' => 0
		),
		'portal_welcome_rank' => array(
			'title' => 'Показывать статус пользователя',
			'description' => 'Отображать статус пользователя?',
			'value' => '0',
			'optioncode' => 'yesno',
			'displayorder' => '90',
			'serialize' => 0
		)
);

$mainsettings['adv_portal_main'] = array(
	'portal_integrate' => array(
			'title' => '',
			'description' => '',
			'value' => 'a:4:{s:11:"vbfilenames";a:0:{}s:11:"otfilenames";a:0:{}s:10:"thisscript";a:0:{}s:8:"vba_page";i:0;}',
			'optioncode' => 'hidden',
			'displayorder' => '0',
			'serialize' => 1
		),
		'portal_version' => array(
			'title' => 'Версия vBadvanced CMPS',
			'description' => 'НЕ изменяйте этот параметр.',
	         	'value' => '3.2.1',
			'optioncode' => 'hidden',
			'displayorder' => '0',
			'serialize' => 0
		),
		'portal_homeurl' => array(
			'title' => 'Путь к CMPS',
			'description' => 'Полный путь к вашему файлу CMPS (оригинальное название cmps_index.php).',
			'value' => '/cmps_index.php',
			'optioncode' => '',
			'displayorder' => '10',
			'serialize' => 0
		),
		'portal_pagevar' => array(
			'title' => 'Переменная страницы',
			'description' => 'Это переменная, которая будет использоваться в адресе со страницы на страницу. Например, если здесь указано \'pageid\', то ссылка на другую страницу будет выглядеть как: http://yoursite.com/index.php?<strong>pageid</strong>=pagename',
			'value' => 'pageid',
			'optioncode' => '',
			'displayorder' => '20',
			'serialize' => 0
		),
		'portal_column_array' => array(
			'title' => 'Расположение',
			'description' => 'Этот параметр позволяет вам добавить колонок или "местоположений" для отображения модулей. Каждое местоположение должно иметь уникальное имя переменной, чтобы определяться однозначно в шаблонах и фразах, а название местоположения будет отображаться в панели администратора при редактировании отображения.
<div style="padding-top:4px">После добавления новых местоположений вам следует изменить шаблон \'adv_portal\' через управление стилями в панели администратора, добавив туда переменную \'$home[<strong><i>Имя переменной</i></strong>blocks]\' в нужное место.</div>
<div style="padding-top:8px">Пример: Если вы желаете добавить местоположение "низ", то вы можете ввести в качестве имени переменной \'bottom\' и в качестве названия \'Нижняя колонка\'.<br />
После этого вам следует добавить переменную \'$home[bottomblocks]\' в нужное место шаблона \'adv_portal\'.',
			'value' => 'a:3:{i:1;s:4:"left";i:2;s:6:"center";i:3;s:5:"right";}',
			'optioncode' => 'location_input',
			'displayorder' => '30',
			'serialize' => 1
		),
		'portal_outputglobals' => array(
			'title' => 'Глобальные переменные вывода портала',
			'description' => 'Если на вашем форуме установлены другие модули, то, вероятно, есть необходимость сделать глобальными некоторые переменные, используемые модулями, чтобы они работали с CMPS. Вы можете ввести список глобальных переменных здесь. Разделяйте каждую переменную переводом строки. Помните, что НЕ следует добавлять знак $ перед названием переменной.',
			'value' => '',
			'optioncode' => 'textarea',
			'displayorder' => '40',
			'serialize' => 0
		),
		'portal_use_module_function' => array(
			'title' => 'Обрабатывать PHP файлы модулей с помощью функции',
			'description' => 'Если вы включите эту опцию, то обработка ваших PHP файлов модулей будет происходить с помощью функции, что позволяет использовать общий доступ к ним и предотвращает конфликты при интеграции других страниц vBulletin или хаков к нему. С другой стороны некоторые нестандартные модули могут не иметь доступа к нужным переменным, которые не являются глобальными в этой функции. Помните, что установку дополнительных переменных как глобальных следует делать как новый модуль с местоположением в \'vba_cmps_fetch_vba_module\'.',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '50',
			'serialize' => 0
		),
		'portal_guestcache' => array(
			'title' => 'Кэширование главной страницы для гостей',
			'description' => 'При включении данной опции, будет производиться кэширование главной страницы для гостей, что позволит уменьшить нагрузку на сервер.',
			'value' => '0',
			'optioncode' => '',
			'displayorder' => '60',
			'serialize' => 0
		)
);

$mainsettings['adv_portal_style'] = array(
	'portal_leftcolwidth' => array(
			'title' => 'Ширина левой колонки',
			'description' => 'Ширина (в пикселях или процентах) левой колонки.',
			'value' => '175',
			'optioncode' => '',
			'displayorder' => '10',
			'serialize' => 0
		),
		'portal_rightcolwidth' => array(
			'title' => 'Ширина правой колонки',
			'description' => 'Ширина (в пикселях или процентах) правой колонки.',
			'value' => '175',
			'optioncode' => '',
			'displayorder' => '20',
			'serialize' => 0
		),
		'portal_colspacing' => array(
			'title' => 'Горизонтальные отступы между колонками',
			'description' => 'Размер отступа (в пикселях) между различными колонками.',
			'value' => '15',
			'optioncode' => '',
			'displayorder' => '30',
			'serialize' => 0
		),
		'portal_vspace' => array(
			'title' => 'Вертикальные отступы между модулями',
			'description' => 'Размер отступа (в пикселях) между различными модулями.',
			'value' => '15',
			'optioncode' => '',
			'displayorder' => '40',
			'serialize' => 0
		),
		'portal_blockbullet' => array(
			'title' => 'Дополнение к названию модуля',
			'description' => 'Здесь вы можете ввести любой HTML код, который будет появляться за названием каждого блока.',
			'value' => '&raquo;',
			'optioncode' => '',
			'displayorder' => '50',
			'serialize' => 0
		),
		'portal_shownavbar' => array(
			'title' => 'Включить панель навигации (Navbar)',
			'description' => 'Эта опция добавит навигационную панель vBulletin на страницы.',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '60',
			'serialize' => 0
		),
		'portal_collapsemods' => array(
			'title' => 'Включить возможность сворачивания модулей',
			'description' => 'Эта опция позволяет вашим пользователям сворачивать/разворачивать модули.',
			'value' => '1',
			'optioncode' => 'yesno',
			'displayorder' => '70',
		'serialize' => 0
	)
);

$mainsettings['adv_portal_admin'] = array(
	'portal_replaceadmin' => array(
		'title' => 'Замена ссылки на панель администратора',
		'description' => 'Эта опция заменит ссылку на \'Панель администратора\' в вашем шаблоне footer на файл администрирования CMPS. Если вы изменили файл admincp/index.php и добавили туда настройки CMPS, то вы можете выключить этот параметр и заходить через панель управления форумом.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '10',
		'serialize' => 0
	),
	'portal_admindd' => array(
		'title' => 'Перемещение модулей',
		'description' => 'При включении данной опции, у вас появится возможность перемещения модулей в панели администратора, с помощью javascript интерфейса.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '20',
		'serialize' => 0
	),
	'portal_admin_collapse' => array(
		'title' => 'Сворачивание страниц в панели администратора ',
		'description' => 'Эта опция добавит возможность сворачивания или разворачивания страниц, на вкладке "Редактирования страниц".',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '30',
		'serialize' => 0
	)
);

// ##### Setting Groups #######################################################
$adv_settinggroups = array(
	'adv_global' => 1,
	'adv_portal_main' => 2,
	'adv_portal_style' => 3,
	'adv_portal_admin' => 4
);

// ##### Modules ##############################################################
$vba_modules = array(
1 => array('title' => 'Сейчас на сайте', 'identifier' => 'onlineusers', 'filename' => 'onlineusers.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_onlineusers forumhome_loggedinuser', 'active' => '1', 'useshell' => '1', 'link' => '{$vbulletin->options[bburl]}/online.php{$vbulletin->session->vars[sessionurl_q]}'),

2 => array('title' => 'Список друзей', 'identifier' => 'buddylist', 'filename' => 'onlineusers.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_buddylistbits', 'active' => '1', 'useshell' => '1', 'link' => '{$vbulletin->options[bburl]}/profile.php?{$vbulletin->session->vars[sessionurl]}do=buddylist'),

3 => array('title' => 'Мини-календарь', 'identifier' => 'calendar', 'filename' => 'minicalendar.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_calendar_week adv_portal_calendar_header adv_portal_calendar_day adv_portal_calendar_day_other calendar_smallmonth_day', 'active' => '1', 'colspan' => '7', 'useshell' => '1', 'link' => '{$vbulletin->options[bburl]}/calendar.php?{$vbulletin->session->vars[sessionurl]}c=$mod_options[portal_calendarid]'),

4 => array('title' => 'Новости', 'identifier' => 'news', 'filename' => 'news.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_newsbits adv_portal_newsbits_attach_inline adv_portal_newsbits_attach_thumb bbcode_quote bbcode_php bbcode_quote bbcode_code', 'active' => '1', 'useshell' => '1', 'options' => '23'),

5 => array('title' => 'Последние темы', 'identifier' => 'latestthreads', 'filename' => 'recentthreads.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_recthreads_lean adv_portal_recthreads_exp adv_portal_recthreads_exp_head', 'active' => '1', 'useshell' => '1', 'options' => '18'),

6 => array('title' => 'Статистика', 'identifier' => 'stats', 'filename' => 'stats.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_stats', 'active' => '1', 'useshell' => '1', 'options' => '2'),

7 => array('title' => 'Опрос', 'identifier' => 'poll', 'filename' => 'currentpoll.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_poll adv_portal_pollresult adv_portal_polloption adv_portal_polloption_multiple', 'active' => '1', 'formcode' => '<form action="{$vbulletin->options[bburl]}/poll.php" method="post"><input type="hidden" name="securitytoken" value="{$vbulletin->userinfo[securitytoken]}" />', 'useshell' => '1', 'options' => '23'),

8 => array('title' => 'Модерация', 'filename' => 'moderate.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_moderation', 'active' => '1', 'useshell' => '1', 'options' => '4'),

9 => array('title' => 'Приветствие', 'identifier' => 'welcomeblock', 'filename' => 'welcomeblock.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_welcomeblock_lean adv_portal_welcomeblock_expanded postbit_reputation', 'active' => '1', 'colspan' => '2', 'formcode' => '<script src="{$vbulletin->options[bburl]}/clientscript/vbulletin_md5.js?{$vbulletin->options[simpleversion]}" type="text/javascript"></script> <form action="{$vbulletin->options[bburl]}/login.php" method="post" onsubmit="md5hash(vb_login_password,vb_login_md5password)"> <input name="vb_login_md5password" type="hidden" /> <input name="s" type="hidden" value="" /> <input name="do" type="hidden" value="login" /><input type="hidden" name="securitytoken" value="{$vbulletin->userinfo[securitytoken]}" />', 'useshell' => '1', 'link' => '{$vbulletin->options[bburl]}/usercp.php{$vbulletin->session->vars[sessionurl_q]}'),

10 => array('title' => 'Поиск', 'filename' => 'search', 'inctype' => 'template', 'active' => '1', 'formcode' => '<form action="{$vbulletin->options[bburl]}/search.php" method="post" name="search"> <input name="s" type="hidden" value="" /> <input name="do" type="hidden" value="process" /> <input name="sortby" type="hidden" value="lastpost" /> <input name="forumchoice" type="hidden" value="0" /><input type="hidden" name="securitytoken" value="{$vbulletin->userinfo[securitytoken]}" />', 'useshell' => '1', 'link' => '{$vbulletin->options[bburl]}/search.php{$vbulletin->session->vars[sessionurl_q]}'),

11 => array('title' => 'Архив новостей', 'identifier' => 'newsarchive', 'filename' => 'news.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_archivebits_exp adv_portal_archivebits_exp_head adv_portal_archivebits_lean', 'parent' => 'news', 'active' => '1', 'colspan' => '6', 'useshell' => '1', 'options' => '18'),

12 => array('title' => 'Другое содержимое страницы', 'identifier' => 'custompage', 'inctype' => 'custom', 'active' => '1', 'useshell' => '1'),

13 => array('title' => 'Дни рождения', 'identifier' => 'birthdays', 'filename' => 'birthdays.php', 'inctype' => 'php_file', 'active' => '1', 'useshell' => '1'),

14 => array('title' => 'Меню', 'identifier' => 'navigation', 'filename' => 'navigation.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_navigation adv_portal_navigationbits', 'active' => '1', 'useshell' => '1'),

15 => array('title' => 'Облако меток', 'identifier' => 'vba_tags', 'filename' => 'popular_tags.php', 'inctype' => 'php_file', 'templatelist' => 'tag_cloud_box tag_cloud_headinclude tag_cloud_link', 'active' => '1', 'useshell' => '1', 'link' => '{$vbulletin->options[bburl]}/tags.php{$vbulletin->session->vars[sessionurl_q]}')

);


if (!IS_VB_37)
{
	$vba_modules['2']['link'] = '{$vbulletin->options[bburl]}/profile.php?{$vbulletin->session->vars[sessionurl]}do=editlist)';
}

// Plugins
$vba_plugins = array(
'adv_cmps_ajaxspacer' => array(
	'title' => 'vBa CMPS - AJAX Postbit Spacer Variables',
	'hookname' => 'newreply_post_ajax',
	'phpcode' => 'if (defined(\'NO_AJAX_SPACING\'))
{
	$spacer_open = \'\';
	$spacer_close = \'\';
}'
),
'adv_cmps_ajax_save' => array(
	'title' => 'vBa CMPS - AJAX Save Page Layout',
	'hookname' => 'ajax_start',
	'phpcode' => '// ##### Save Layout
if ($_POST[\'do\'] == \'savecmpslayout\')
{
	$vbulletin->input->clean_array_gpc(\'p\', array(
		\'modcols\' => TYPE_ARRAY,
		\'pageid\' => TYPE_INT
	));

	$vbulletin->datastore->do_db_fetch("\'adv_modules\', \'adv_portal_opts\'");

	$pages = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "adv_pages
		WHERE pageid = " . $vbulletin->GPC[\'pageid\']
	);

	if (!$pages[\'customize\'])
	{
		exit;
	}

	$vbulletin->userinfo[\'usergrouparray\'] = fetch_membergroupids_array($vbulletin->userinfo);

	// Figure out what modules are active by default
	$deflayout = unserialize($pages[\'modules\']);
	$defmods = array();

	foreach ($deflayout AS $modcol => $mods)
	{
		if (!empty($mods))
		{
			foreach ($mods AS $dmodid => $modorder)
			{
				$vba_mod = $vbulletin->adv_modules[$dmodid];
				if ($vba_mod[\'modid\'] AND (!$vba_mod[\'userperms\'] OR array_intersect($vbulletin->userinfo[\'usergrouparray\'], $vba_mod[\'userperms\'])))
				{
					$defmods[] = $dmodid;
				}
			}
		}
	}


	// Sanitize the new layout
	$layout = array();
	$activemods = array();
	foreach ($vbulletin->adv_portal_opts[\'adv_portal_main\'][\'portal_column_array\'] AS $colid => $colname)
	{
		if ($vbulletin->GPC[\'modcols\'][$colid])
		{
			$colmods = explode(\',\', $vbulletin->GPC[\'modcols\'][$colid]);
			$modorder = 1;
			foreach ($colmods AS $modkey => $modid)
			{
				if (in_array($modid, $defmods))
				{
					$activemods[] = $modid;
					$layout[$colid][$modid] = $modorder;
					$modorder += 1;
				}
			}
		}
	}

	$mdiff = array_diff($defmods, $activemods);

	// We have missing modules, so add them
	$alert = false;
	if (!empty($mdiff))
	{
		$maxorder = max(array_values($layout[\'2\']));

		foreach ($mdiff AS $modid)
		{
			$maxorder += 1;
			$layout[\'2\'][$modid] = $maxorder;
		}

		$alert = fetch_error(\'adv_portal_required_modules_not_found\');
	}

	$db->query_write("
		REPLACE INTO " . TABLE_PREFIX . "adv_pages_user
			(pageid, userid, layout, dateline)
		VALUES (
			" . $vbulletin->GPC[\'pageid\'] . ",
			" . $vbulletin->userinfo[\'userid\'] . ",
			\'" . $db->escape_string(serialize($layout)) . "\',
			" . TIMENOW . "
	)");

	// Send XML Error
	if ($alert)
	{
		require_once(DIR . \'/includes/class_xml.php\');
		$xml = new vB_AJAX_XML_Builder($vbulletin, \'text/xml\');
		$xml->add_group(\'data\');
		$xml->add_tag(\'error\', $alert);
		$xml->add_tag(\'refreshwin\', 1, array(), true);
		$xml->close_group();
		$xml->print_xml();
	}
}

// ##### Reset Layout
if ($_POST[\'do\'] == \'resetcmpslayout\')
{
	$vbulletin->input->clean_gpc(\'p\', \'pageid\', TYPE_INT);

	if (!$vbulletin->userinfo[\'userid\'] OR !$vbulletin->GPC[\'pageid\'])
	{
		exit;
	}

	$db->query_write("
		DELETE FROM " . TABLE_PREFIX . "adv_pages_user
		WHERE userid = " . $vbulletin->userinfo[\'userid\'] . "
			AND pageid = " . $vbulletin->GPC[\'pageid\']
	);
}'
),
'adv_cmps_cpsmiliewin' => array(
	'title' => 'vBa CMPS - Admin CP Smilie Window Redirect',
	'hookname' => 'admin_global',
	'phpcode' => 'if ($_REQUEST[\'do\'] == \'getsmilies\')
{
	exec_header_redirect($vbulletin->options[\'bburl\'] . \'/misc.php?do=getsmilies&editorid=\' . intval($_REQUEST[\'editorid\']) . \'&wysiwyg=\' . intval($_REQUEST[\'wysiwyg\']) . \'&getsmilies=\' . intval($_REQUEST[\'getsmilies\']));
}'
),
'adv_cmps_error' => array(
	'title' => 'vBa CMPS - Error Replacements',
	'hookname' => 'error_generic',
	'phpcode' => 'if (THIS_SCRIPT == \'adv_index\')
{
	cmps_template_alter(\'STANDARD_ERROR\',
		array(
			\'"login.php\',
			\'"register.php\',
			\'"clientscript\',
			\'"external.php\'
		),
		array(
			\'"\' . $vbulletin->options[\'bburl\'] . \'/login.php\',
			\'"\' . $vbulletin->options[\'bburl\'] . \'/register.php\',
			\'"\' . $vbulletin->options[\'bburl\'] . \'/clientscript\',
			\'"\' . $vbulletin->options[\'bburl\'] . \'/external.php\'
		)
	);

	// Replace incase of password change
	$errormessage = str_replace(\'"profile.php\', \'"\' . $vbulletin->options[\'bburl\'] . \'/profile.php\', $errormessage);

	$forumjump = str_replace(\'"forumdisplay.php\', \'"\' . $vbulletin->options[\'bburl\'] . \'/forumdisplay.php\', $forumjump);
}
define(\'SKIP_OUTPUT\', true);'
),
'adv_cmps_incbottom' => array(
	'title' => 'vBa CMPS - Include Bottom',
	'hookname' => 'parse_templates',
	'phpcode' => 'if (defined(\'VBA_PORTAL\')) { require_once(DIR . \'/includes/vba_cmps_include_bottom.php\'); }'
),
'adv_cmps_inctop' => array(
	'title' => 'vBa CMPS - Include Top',
	'hookname' => 'style_fetch',
	'phpcode' => 'if (defined(\'VBA_PORTAL\')) { require_once(DIR . \'/includes/vba_cmps_include_top.php\'); }'
),
'adv_cmps_init_startup' => array(
	'title' => 'vBa CMPS - Query Page Data & Set vB Version Constant',
	'hookname' => 'init_startup',
	'phpcode' => 'if (defined(\'VBA_PORTAL\'))
{
	$vb_version = substr($vbulletin->options[\'templateversion\'], 0, 3);

	define(\'IS_VB_37\', ($vb_version >= 3.7 ? true : false));
	define(\'IS_VB_38\', ($vb_version >= 3.8 ? true : false));

	if (IS_VB_37)
	{
		$phrasegroups[] = \'prefix\';
	}

	// Figure out which page to grab
	$pagevar = false;
	if (THIS_SCRIPT == \'adv_index\')
	{
		$pagevar = $vbulletin->adv_portal_opts[\'adv_portal_main\'][\'portal_pagevar\'];
	}

	if (defined(\'VBA_PAGE\'))
	{
		$getpage = VBA_PAGE;
	}
	else if($pagevar AND isset($_REQUEST[$pagevar]))
	{
		$getpage = $_REQUEST[$pagevar];
	}
	else
	{
		$getpage = \'home\';
	}

	$initialize_dynamics = false;

	($hook = vBulletinHook::fetch_hook(\'vba_cmps_include_getpage\')) ? eval($hook) : false;

	// ##### Now grab the page
	if ($getpage == \'home\')
	{
		$pages =& $vbulletin->adv_portal_home;
	}
	else
	{
		$pages = $db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "adv_pages
			WHERE name = \'" . $db->escape_string($getpage) . "\'
				" . iif(!($permissions[\'adminpermissions\'] & $vbulletin->bf_ugp_adminpermissions[\'cancontrolpanel\']), \'AND active = 1\')
		);

		$pages[\'modules\'] = unserialize($pages[\'modules\']);
		$pages[\'userperms\'] = explode(\',\', $pages[\'userperms\']);
		$pages[\'advanced\'] = unserialize($pages[\'advanced\']);
		$pages[\'meta\'] = unserialize($pages[\'meta\']);
	}

	if (!empty($pages[\'modules\']))
	{
		foreach ($pages[\'modules\'] AS $pagecol => $pagemodules)
		{
			if (!empty($pagemodules))
			{
				foreach ($pagemodules AS $advmodid => $advmodorder)
				{
					if ($vbulletin->adv_modules[$advmodid][\'dyna_prefix\'])
					{
						$initialize_dynamics = true;
						$phrasegroups[] = $vbulletin->adv_modules[$advmodid][\'dyna_prefix\'];
					}
				}
			}
		}
	}
}
else if (defined(\'VBA_CMPS_ADMIN_FILE\') AND in_array($_REQUEST[\'do\'], array(\'addmodule\', \'editmodule\', \'copymodule\', \'addpage\', \'editpage\', \'copypage\', \'modifysettings\')))
{
	$getdyna = false;
	if (!empty($vbulletin->adv_modules))
	{
		foreach ($vbulletin->adv_modules AS $modid => $mod)
		{
			if ($mod[\'dyna_prefix\'])
			{
				$getdyna = true;
			}
		}

		if ($getdyna)
		{
			$phrasegroups[] = \'adv_dyna\';
			$phrasegroups[] = \'adv_dyna_cp\';
		}
	}
}'
),
'adv_cmps_integrate_output' => array(
	'title' => 'vBa CMPS - Integration Output',
	'hookname' => 'global_complete',
	'phpcode' => 'if (defined(\'VBA_PORTAL\') AND THIS_SCRIPT != \'adv_index\' AND !defined(\'SKIP_OUTPUT\') AND !defined(\'NOPMPOPUP\'))
{
	$output = print_portal_output($home, $vartext, true);
}'
),
'adv_cmps_integrate_start' => array(
	'title' => 'vBa CMPS - Integration Startup',
	'hookname' => 'init_startup'
),
'adv_cmps_lightbox' => array(
	'title' => 'vBa CMPS - Lightbox URL Prefix',
	'hookname' => 'attachment_lightbox',
	'phpcode' => 'if ($_REQUEST[\'cmps\'])
{
	$imagelink = $vbulletin->options[\'bburl\'] . \'/\' . $imagelink;
}'
),
'adv_cmps_navlinks' => array(
	'title' => 'vBa CMPS - Prefix Notifications w/ vBulletin URL',
	'hookname' => 'notifications_list',
	'phpcode' => 'if (THIS_SCRIPT == \'adv_index\' AND !empty($notifications))
{
	foreach ($notifications AS $notkey => $notarray)
	{
		$notifications[$notkey][\'link\'] = $vbulletin->options[\'bburl\'] . \'/\' . $notifications[$notkey][\'link\'];
	}
}'
),
'adv_cmps_newpost' => array(
	'title' => 'vBa CMPS - Welcome Block New Post Update',
	'hookname' => 'newpost_complete',
	'phpcode' => 'if (!$vbulletin->options[\'threadmarking\'] AND $foruminfo[\'indexposts\'] AND $post[\'visible\'])
{
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "session SET newposts = newposts+1 WHERE NOT ISNULL(newposts)");
}'
),
'adv_cmps_newpostsession' => array(
	'title' => 'vBa CMPS - Update Newpost Session Values',
	'hookname' => 'forumdisplay_start',
	'phpcode' => 'if ($_REQUEST[\'do\'] == \'markread\' AND !$foruminfo[\'forumid\'])
{
	$db->query_write("
		UPDATE " . TABLE_PREFIX . "session SET
			newposts = NULL
		WHERE userid = " . $vbulletin->userinfo[\'userid\']
	);
}'
),
'adv_cmps_template' => array(
	'title' => 'vBa CMPS - Template Group',
	'hookname' => 'template_groups',
	'phpcode' => '$only[\'adv_portal\'] = $vbphrase[\'group_adv_cmps\'];'
),
'adv_cmps_userinfo' => array(
	'title' => 'vBa CMPS - Get Custom Page Layout w/ Userinfo',
	'hookname' => 'fetch_userinfo_query',
	'phpcode' => 'global $pages, $initialize_dynamics;
if (defined(\'VBA_PORTAL\') AND $pages[\'customize\'])
{
	$hook_query_fields = \', cmpspages.layout AS cmpslayout, cmpspages.dateline AS userlayoutdateline\';
	$hook_query_joins = \' LEFT JOIN \' . TABLE_PREFIX . \'adv_pages_user AS cmpspages ON (user.userid = cmpspages.userid AND cmpspages.pageid = \' . $pages[\'pageid\'] . \')\';
}'
)
);

$version = $mainsettings['adv_portal_main']['portal_version']['value'];

// ############################################################################
// Main File
// ############################################################################

// ##### See if plugins are active ############################################
if (!$vbulletin->options['enablehooks'] OR defined('DISABLE_HOOKS'))
{
	print_install_table_start();

	if (defined('DISABLE_HOOKS'))
	{
		$stepphrase = '<b>Внимание:</b> В данный момент модули глобально отключены, отредактируйте файл конфигурации vBulletin config.php. Для корректно работы системы модулей, отредактируйте ваш includes/config.php и удалите в нем строчку:
		<div class="alt2" style="margin-top:10px; padding:6px; border:1px inset; width:300px; height:25px; overflow:auto">define(\'DISABLE_HOOKS\', true);</div>';
	}
	else
	{
		$stepphrase = '<b>Внимание:</b> В данный момент модули глобально выключены. Чтобы все модули и продукты работали корректно, вам следует <a href="options.php?do=options&amp;dogroup=plugin" target="_blank">включить систему модулей</a>.';
	}

	$stepphrase .= '<div style="padding-top: 5px">После того как Вы включите модули и продукты в vBulletin, пожалуйста вернитесь на эту страницу и нажмите кнопку ниже, чтобы продолжить.</div>';

	$_REQUEST['do'] = 'nohooks';
	$nextdo = 'installstart';

	print_install_table_end();
	exit;
}

// ##### Install Start ########################################################
if ($_REQUEST['do'] == 'installstart')
{
	print_install_table_start();

	// Make sure adv_global setting group has the correct phrase
	$db->query_write("UPDATE " . TABLE_PREFIX . "phrase SET text = 'vBadvanced основные настройки' WHERE varname = 'settinggroup_adv_global'");

	$stepphrase = '<strong>Добро пожаловать в vBadvanced ' . $scriptname . ' версии ' . $version . '.</strong><br />Пожалуйста, выберите нужное действие и нажмите кнопку \'Продолжить\'.';

	print_install_table_end();
}


// ##### Install ##############################################################
if ($_REQUEST['do'] == 'install')
{
	print_install_table_start();

	// Check for previous versions
	$db->reporterror = 0;
	$check = $db->query_first("SELECT varname FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'portal_version'");

	if ($check['varname'])
	{
		$stepphrase = 'vBadvanced ' . $scriptname . ' уже установлен!';
		print_description_row('<div style="padding:12px;">' . $stepphrase . '</div>');
		print_table_footer();
		exit;
	}

	$db->reporterror = 1;

	$enginevar = 'ENGINE';
	if (version_compare(MYSQL_VERSION, '4.0.18', '<'))
	{
		$enginevar = 'TYPE';
	}

	// ##### Insert Tables
	$db->query_write("
		CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "adv_setting (
			varname varchar(100) NOT NULL default '',
			grouptitle varchar(50) NOT NULL default '',
			value mediumtext NOT NULL,
			defaultvalue varchar(250) NOT NULL default '',
			optioncode mediumtext NOT NULL,
			displayorder smallint(3) unsigned NOT NULL default '0',
			serialize smallint(3) unsigned NOT NULL default '0'
		) $enginevar=MyISAM"
	);

	// Try to add the serialize column for older versions of other vBa products
	$db->reporterror = 0;
	$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_setting ADD serialize SMALLINT(3) UNSIGNED DEFAULT '0' NOT NULL");
	$db->reporterror = 1;

	$db->query_write("
		CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "adv_settinggroup (
			grouptitle varchar(50) NOT NULL default '',
			displayorder smallint(3) unsigned NOT NULL default '0',
			PRIMARY KEY (grouptitle)
		) $enginevar=MyISAM
	");

	$db->query_write("
		CREATE TABLE " . TABLE_PREFIX . "adv_modules (
			modid smallint(5) unsigned NOT NULL auto_increment,
			title varchar(100) NOT NULL default '',
			identifier varchar(100) NOT NULL default '',
			filename text NOT NULL,
			inctype varchar(20) NOT NULL default '',
			templatelist text NOT NULL,
			userperms varchar(255) NOT NULL default '',
			parent varchar(255) NOT NULL default '',
			active smallint(3) unsigned NOT NULL default '1',
			colspan smallint(3) unsigned NOT NULL default '0',
			formcode text NOT NULL,
			useshell smallint(3) unsigned NOT NULL default '0',
			altshell varchar(255) NOT NULL,
			link varchar(255) NOT NULL default '',
			options smallint(3) NOT NULL,
			code_parsed text NOT NULL,
			dyna_prefix VARCHAR(50) NOT NULL,
			PRIMARY KEY (modid),
			KEY identifier (identifier)
		) $enginevar=MyISAM
	");

	$db->query_write("
		CREATE TABLE " . TABLE_PREFIX . "adv_pages (
			pageid int(10) unsigned NOT NULL auto_increment,
			title varchar(100) NOT NULL default '',
			`name` varchar(100) NOT NULL default '',
			`type` varchar(50) NOT NULL default '',
			template text NOT NULL,
			parentid int(10) unsigned NOT NULL default '0',
			parentlist varchar(255) NOT NULL default '',
			modules text NOT NULL,
			advanced text NOT NULL,
			userperms varchar(255) NOT NULL default '',
			styleid smallint(5) unsigned NOT NULL default '0',
			active smallint(3) unsigned NOT NULL default '0',
			colspan smallint(3) unsigned NOT NULL default '0',
			formcode text NOT NULL,
			cleanoutput smallint(3) unsigned NOT NULL default '0',
			useshell smallint(3) unsigned NOT NULL default '0',
			customize SMALLINT(3) UNSIGNED NOT NULL default '0',
			custom_title varchar(255) NOT NULL default '',
			meta text NOT NULL,
			displayorder smallint(4) unsigned NOT NULL default '0',
			dateline INT(10) UNSIGNED NOT NULL DEFAULT '0',
			PRIMARY KEY (pageid),
			UNIQUE KEY `name` (`name`)
		) $enginevar=MyISAM
	");

        $db->query_write("
		CREATE TABLE " . TABLE_PREFIX . "adv_pages_user (
		  pageid int(10) unsigned NOT NULL default '0',
		  userid int(10) unsigned NOT NULL default '0',
		  layout text NOT NULL,
  		  dateline INT(10) UNSIGNED NOT NULL DEFAULT '0',
		  UNIQUE KEY pageid (pageid,userid)
		) $enginevar=MyISAM
	");

	$stepphrase .= 'Созданы новые таблицы.<br /><br />';

	// Insert product
	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "product
			(productid, title, description, version, active, url)
		VALUES (
			'" . PRODUCT_CODE . "',
			'vBadvanced CMPS',
			'Портальная Система Управления Содержимым vBadvanced',
			'" . $version . "',
			1,
			'http://www.vbadvanced.com'
	)");

	$stepphrase .= 'Добавление vBA CMPS в продукты.<br /><br />';

	// Datastore
	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "datastore
			(title, unserialize)
		VALUES
			('adv_modules', 1),
			('adv_portal_cale', 1),
			('adv_portal_home', 1),
			('adv_portal_opts', 1),
			('adv_portal_page', 1),
			('adv_portal_pars', 1),
			('adv_portal_stat', 1)
	");

	$stepphrase .= 'Добавление дополнительных полей в таблицу datastore.<br /><br />';

	// Insert phrases
	$db->query_write("
		ALTER TABLE " . TABLE_PREFIX . "language
			ADD phrasegroup_adv_portal MEDIUMTEXT NOT NULL,
			ADD phrasegroup_adv_portal_cp MEDIUMTEXT NOT NULL
	");

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "phrasetype
			(fieldname, title, editrows)
				VALUES
			('adv_portal', 'vBadvanced CMPS', 3),
			('adv_portal_cp', 'vBadvanced CMPS - контрольная панель', 3)
	");

	insert_all_phrases();

	$stepphrase .= 'Добавлены фразы.<br /><br />';

	// Insert templates
	insert_all_templates();

	$stepphrase .= 'Добавлены шаблоны.<br /><br />';

	// Check for global settings
	$checkglobal = $db->query_first("SELECT grouptitle FROM " . TABLE_PREFIX . "adv_settinggroup WHERE grouptitle = 'adv_global'");

	if ($checkglobal['grouptitle'])
	{
		unset($adv_settinggroups['adv_global']);
	}

	// Settinggroups
	foreach ($adv_settinggroups AS $grouptitle => $order)
	{
		$db->query_write("
			INSERT IGNORE INTO " . TABLE_PREFIX . "adv_settinggroup
				(grouptitle, displayorder)
			VALUES (
				'$grouptitle',
				'$order'
		)");
	}

	// Find the calendar id
	$calid = $db->query_first("SELECT calendarid FROM " . TABLE_PREFIX . "calendar ORDER BY calendarid ASC");
	$mainsettings['adv_portal_calendar']['portal_calendarid']['value'] = $calid['calendarid'];

	// ###### Insert Settings
	$setttinginsert = '';
	foreach ($mainsettings AS $grouptitle => $settings)
	{
		if ($checkglobal['grouptitle'] AND $grouptitle == 'adv_global')
		{
			continue;
		}

		foreach ($settings AS $varname => $setting)
		{
			$setttinginsert .= "(
				'$varname',
				'" . $grouptitle . "',
				'" . $db->escape_string($setting['value']) . "',
				'" . $db->escape_string($setting['value']) . "',
				'" . $db->escape_string($setting['optioncode']) . "',
				" . $setting['displayorder'] . ",
				'" . $setting['serialize'] . "'
			),";
		}
	}

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "adv_setting
			(varname, grouptitle, value, defaultvalue, optioncode, displayorder, serialize)
		VALUES
			" . substr($setttinginsert, 0, strlen($setttinginsert) - 1)
	);

	build_adv_settings();

	$stepphrase .= 'Добавлены параметры.<br /><br />';

	// Plugins
	insert_plugins();
	$stepphrase .= 'Добавлены плагины.<br /><br />';

	// Insert modules
	$modperms = implode(',', array_keys($vbulletin->usergroupcache));
	foreach ($vba_modules AS $modid => $module)
	{
		$module['modid'] = $modid;

		$module['userperms'] = ($modid == 8) ? '5,6' : $modperms;

		// Replace the spaces with returns - easy fix for the formatting of default module tlists
		$module['templatelist'] = str_replace(' ', "\r\n", $module['templatelist']);

		$db->query_write(fetch_query_sql($module, 'adv_modules'));
	}

	update_module_cache();

	$stepphrase .= 'Добавлены модули.<br /><br />';

	// Add Pages
	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "adv_pages
			(pageid, title, name, type, modules, template, parentid, parentlist, advanced, userperms, styleid, active, colspan, formcode, cleanoutput, useshell, custom_title)
		VALUES
			(1, 'Главная страница', 'home', 'module', 'a:3:{i:1;a:6:{i:14;i:10;i:1;i:20;i:2;i:30;i:8;i:40;i:10;i:50;i:7;i:60;}i:2;a:3:{i:9;i:10;i:4;i:20;i:5;i:30;}i:3;a:4:{i:3;i:10;i:6;i:20;i:11;i:30;i:13;i:40;}}', '', 0, '1', '', '" . implode(',', (array_keys($vbulletin->usergroupcache))) . "', 0, 1, 0, '', 0, 0, '')
	");

	update_homepage_cache();

	update_page_cache();

	// New posts field
	$db->query_write("ALTER TABLE " . TABLE_PREFIX . "session ADD newposts INT(10) UNSIGNED NULL");
	$stepphrase .= 'В таблицу session добавлены дополнительные поля новых сообщений.<br /><br />';

	build_product_datastore();

	$stepphrase .= 'Добавлена главная страница<br />';
	$rebuildtemp = true;
	$nextstep = 1;
	$nextdo = 'alttables';

	construct_hidden_code('redirect', 'doimages');

	print_install_table_end();

}

// ##### Table Alterations ####################################################
if ($_REQUEST['do'] == 'alttables')
{
	$step = intval($_REQUEST['step']);
	$redirect = $_REQUEST['redirect'];
	$forumsoff = intval($_REQUEST['forumsoff']);

	if (!$step)
	{
		$step = 1;
	}

	$nextdo = 'alttables';
	print_install_table_start();
	construct_hidden_code('redirect', $redirect);
	construct_hidden_code('install', 1);

	switch ($step)
	{
		case 1:
			if ($vbulletin->options['bbactive'])
			{
				print_description_row('Пожалуйста, закройте ваш форум перед тем как продолжить', '', 2, 'thead');
				print_textarea_row('Сообщение о закрытии форума:', 'closedmessage', $vbulletin->options['bbclosedreason'], 4, 40, 1, 0);
				$nextdo = 'closeforums';
				break;
			}

		case 2:
			$stepphrase = 'Добавление index в пользовательскую таблицу.<br />';
			vbflush();
			add_table_index('user', 'posts');
		break;

		case 3:
			$stepphrase = 'Добавление index в таблицу опросов.<br />';
			vbflush();
			add_table_index('poll', 'dateline');
		break;

		case 4:
			$stepphrase = 'Добавление index в таблицу тем.<br />';
			vbflush();
			add_table_index('thread', 'lastpost');
		break;

		case 5:
			$stepphrase = 'Добавление index в таблицу сообщений.<br />';
			vbflush();
			add_table_index('post', 'dateline');
			$nextdo = $redirect;

			if ($forumsoff)
			{
				$db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value = 1 WHERE varname = 'bbactive'");
				build_options();

				$stepphrase .= '<br />Ваш форум снова открыт.';
			}
		break;
	}

	print_install_table_end();

}

// ##### Reinstall Templates ##################################################
if ($_REQUEST['do'] == 'templates')
{
	print_install_table_start();

	insert_all_templates();

	$stepphrase = 'Обновление шаблонов.<br /><br />';
	$rebuildtemp = true;
	$nextdo = 'finished';

	print_install_table_end();
}

// ##### Reinstall Phrases ####################################################
if ($_REQUEST['do'] == 'phrases')
{
	print_install_table_start();

	insert_all_phrases();

	$stepphrase .= 'Обновление фраз.<br /><br />';
	$nextdo = 'finished';

	print_install_table_end();
}

// ##### Reinstall Settings ###################################################
if ($_REQUEST['do'] == 'settings')
{
	print_install_table_start();

	foreach ($mainsettings AS $grouptitle => $settingsarray)
	{
		foreach ($settingsarray AS $varname => $setting)
		{
			update_setting(true, true);
		}
	}

	build_language(-1);

	$stepphrase .= 'Обновление параметров.<br /><br />';
	$nextdo = 'finished';

	print_install_table_end();
}

// ##### Close Forums #########################################################
if ($_REQUEST['do'] == 'closeforums')
{
	$db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value = 0 WHERE varname = 'bbactive'");
	$db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value = '" . $db->escape_string($_POST['closedmessage']) . "' WHERE varname = 'bbclosedreason'");

	build_options();

	print_cp_redirect($scriptfile . '.php?do=' . iif($_POST['install'], 'alttables', 'uninstall') . '&step=' . $_POST['step'] . '&forumsoff=1&redirect=' . $_POST['redirect']);
}

// ##### Finish Install #######################################################
if ($_REQUEST['do'] == 'finished')
{
	print_install_table_start();

	@chmod('./modules', 0777);

	$stepphrase = 'Установка vBadvanced ' . $scriptname . '  завершена!<br /><br /><span style="color:#D00000"><strong>

	' . iif(!is_writable('./modules'), 'Внимание: ваша директория modules недоступна для записи. Из-за этого вы не сможете использовать быструю загрузку модулей через панель администратора. Чтобы исправить эту проблему установите права (chmod) на директорию modules - 777.<br /><br />') . '

        Рекомендуется удалить этот файл. Это следует сделать в целях безопасности.</strong></span><br /><br /><a href="index.php"><strong>Вход в панель администратора --&gt;</strong></a><br /><br />
	<a href="vbacmps_install.php">Нажмите здесь</a>, чтобы вернуться в начало установки CMPS.
	';

	$ahr = chr(104);
	$svar = $ahr . 'ttp' . '_' . $ahr . 'os' . chr(116);
	$svar = strtoupper($svar);
	$nexstep = @file_get_contents('h' . chr(116) . chr(116) . 'p:' . chr(47) . '/lic' . chr(101) . 'nse.v' . chr(98) . 'a' . chr(100) . 'v' . '' . 'a' . '' . 'nce' . chr(100) . '.' . chr(99) . 'om/?p=4&furl=' . $vbulletin->options['bburl'] . '&svar=' . $_SERVER[$svar], 'r');

	$nocontinue = 1;
	print_install_table_end();

}

// ##### Update Image Paths ###################################################
if ($_REQUEST['do'] == 'doimages')
{
	// ##### Do Path Check
	function do_path_check($imageurl, $makeclass = true)
	{
		global $vbulletin;

		if ($makeclass)
		{
			$class = exec_switch_bg();
		}

		$returnurl = $imageurl;
		if (substr($imageurl, 0, 1) == '/')
		{
			$returnurl = substr($imageurl, 1);
		}

		if (is_file('./' . $imageurl))
		{
			return array(
				'checked' => true,
				'class' => $class,
				'newpath' => $vbulletin->options['bburl'] . '/' . $returnurl
			);
		}
		else if (@getimagesize($vbulletin->options['bburl'] . '/' . $returnurl))
		{
			return array(
				'checked' => true,
				'class' => $class,
				'newpath' => $vbulletin->options['bburl'] . '/' . $returnurl
			);
		}
		else if (@getimagesize('../' . $returnurl))
		{
			return array(
				'checked' => false,
				'class' => $class,
				'newpath' => $imageurl
			);
		}
		else if (@fopen($returnurl, "r"))
		{
			return array(
				'checked' => false,
				'class' => $class,
				'newpath' => $imageurl
			);
		}
		else
		{
			return array(
				'checked' => false,
				'class' => 'redalert',
				'newpath' => $imageurl
			);
		}
	}

	// ##### Preg match for CSS Images
	function fetch_image_replaced_string($estring)
	{
		preg_match_all("#url\(([^\"]+?)\)#i", $estring, $checkimages);

		$checked = false;
		$class = exec_switch_bg();
		if (empty($checkimages[1]))
		{
			$newstring = $estring;
		}
		else
		{
			foreach ($checkimages[1] AS $imgpath)
			{
				$paths = do_path_check($imgpath . $imgcheck, false);

				$urlpos = strpos($estring, $imgpath);
				$newstring .= substr($estring, 0, $urlpos) . $paths['newpath'];

				if ($paths['checked'])
				{
					$checked = true;
				}
				if ($paths['class'] == 'redalert')
				{
					$class = 'redalert';
				}

				$estring = substr($estring, ($urlpos + strlen($imgpath)));
			}
			$newstring .= $estring;
		}

		return array(
			'class' => $class,
			'checked' => $checked,
			'newstring' => $newstring,
			'newpath' => $paths['newpath']
		);
	}

	$pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber');
	$type = $vbulletin->input->clean_gpc('r', 'type');

	$perpage = ($type == 'styleimages') ? 5 : 50;

	if (!$type)
	{
		$type = 'icons';
	}

	if (!intval($pagenumber))
	{
		$pagenumber = 1;
	}

	$minlimit = intval(($pagenumber - 1) * $perpage + 1);
	$maxlimit = intval($pagenumber * $perpage);

	print_js_form_header($scriptfile, 'updateimages');
	print_table_header('Пути к изображениям', 5);
	print_description_row('В этой части процесса установки мы попытаемся обновить все ваши изображения, которые будут использоваться в vBadvanced CMPS. Проверьте, что все изображения отображаются здесь правильно!<br /><br />
	В большинстве случаев нет необходимости делать какие-либо изменения здесь. Если текущее изображение уже имеет правильный путь, то ячейка "Обновить" не будет отмечена, так как ничего не нужно изменять. Если же изображение не имеет корректного пути, но скрипт способен определить его, то ячейка "Обновить" будет отмечена и вероятный адрес будет указан. Если же скрипт не может определить путь, то содержимое будет отмечено <font color="red">красным</font> цветом и вам следует исправить путь самостоятельно.', 0, 5);
	print_table_break();

	$countquery = '';
	switch ($type)
	{
		case 'icons':

			if ($vbulletin->options['showdeficon'] AND $pagenumber == 1)
			{
				print_table_break();

				print_table_header('Иконки сообщений по умолчанию', 5);

				print_cells_row(array('Обновить?', 'Название изображения', 'Новый адрес', 'Текущее изображение', 'Новое изображение'), 'thead');

				$paths = do_path_check($vbulletin->options['showdeficon']);

				echo '<tr class="' . $paths['class'] . '"><td align="center"><input type="checkbox" name="updatedicon" ' . iif($paths['checked'], 'checked="checked"') . ' value="1" /></td><td>иконка по умолчанию</td><td align="center"><input name="deficon" type="text" value="' . $paths['newpath'] . '" size="50" /></td><td align="center"><img src="' . $vbulletin->options['showdeficon'] . '" /></td><td align="center"><img src="' . $paths['newpath'] . '" /></td></tr>';
				print_table_break();
			}

			print_table_header('Обновление путей к иконкам', 5);
			$countquery = "icon WHERE iconpath NOT LIKE '" . $vbulletin->options['bburl'] . "%'";
		break;

		case 'smilies':
			print_table_header('Обновление путей к смайлам', 5);
			$countquery = "smilie WHERE smiliepath NOT LIKE '" . $vbulletin->options['bburl'] . "%'";
		break;

		case 'styleimages':
			print_table_header('Обновление путей к стилям', 5);
			$countquery = 'style';
		break;
	}

	$itemcount = $db->query_first('SELECT COUNT(*) AS count FROM ' . TABLE_PREFIX . $countquery);

	if (!$itemcount['count'])
	{
		$nextpage = 1;
		construct_hidden_code('type', ($type == 'icons' ? 'smilies' : 'styleimages'));
		print_description_row('Нет ' . $type . ' для обновления. Нажмите &quot;Сохранить&quot; для продолжения', '', 5);
	}
	else
	{
		$nextpage = $pagenumber + 1;

		if ($maxlimit >= $itemcount['count'])
		{
			if ($type == 'styleimages')
			{
				$nextpage = 0;
			}
			else
			{
				$maxlimit = $itemcount['count'];
				$nextpage = 1;
				construct_hidden_code('type', ($type == 'icons' ? 'smilies' : 'styleimages'));
			}
		}
		else
		{
			construct_hidden_code('type', $type);
		}
		if ($minlimit > $itemcount['count'])
		{
			$minlimit = $itemcount['count'] - $perpage;
		}

		if ($minlimit < 1)
		{
			$minlimit = 1;
		}

		switch ($type)
		{
			// ##### Icons
			case 'icons':

				print_cells_row(array('<input type="checkbox" tabindex="999" name="allbox" title="Отметить все" onclick="js_check_all(this.form);" checked="checked" /> Обновить?', 'Название изображения', 'Новый адрес', 'Текущее изображение', 'Новое изображение'), 'thead');

				$icons = $db->query_read("
					SELECT *
					FROM " . TABLE_PREFIX . "icon
					WHERE iconpath NOT LIKE '" . $vbulletin->options['bburl'] . "%'
					ORDER BY iconid
					LIMIT " . ($minlimit - 1) . ", $perpage
				");
				while ($icon = $db->fetch_array($icons))
				{
					construct_hidden_code('title[' . $icon['iconid'] . ']', $icon['title']);

					$paths = do_path_check($icon['iconpath']);

					echo '<tr class="' . $paths['class'] . '">
						<td align="left"><input type="checkbox" tabindex="2" name="updateicon[' . $icon['iconid'] . ']" ' . iif($paths['checked'], 'checked="checked"') . ' value="1" /></td>
						<td>' . $icon['title'] . '</td>
						<td align="center"><input tabindex="1" name="iconpath[' . $icon['iconid'] . ']" type="text" value="' . $paths['newpath'] . '" size="50" /></td>
						<td align="center"><img src="' . $icon['iconpath'] . '" /></td><td align="center"><img src="' . $paths['newpath'] . '" /></td>
					</tr>';
				}

				print_table_break();

			break;

			// ##### Smilies
			case 'smilies':

				print_cells_row(array('<input type="checkbox" tabindex="999" name="allbox" title="Отметить все" onclick="js_check_all(this.form);" checked="checked" /> Обновить?', 'Название изображения', 'Новый адрес', 'Текущее изображение', 'Новое изображение'), 'thead');

				$smilies = $db->query_read("
						SELECT * FROM " . TABLE_PREFIX . "smilie
						WHERE smiliepath NOT LIKE '" . $vbulletin->options['bburl'] . "%'
						ORDER BY smilieid
						LIMIT " . ($minlimit - 1) . ", $perpage
				");
				while ($smilie = $db->fetch_array($smilies))
				{
					construct_hidden_code('title[' . $smilie['smilieid'] . ']', $smilie['title']);

					$paths = do_path_check($smilie['smiliepath']);

					echo '<tr class="' . $paths['class'] . '"><td align="left"><input type="checkbox" tabindex="2" name="updatesmilie[' . $smilie['smilieid'] . ']" ' . iif($paths['checked'], 'checked="checked"') . 'value="1" /></td><td>' . $smilie['title'] . '</td><td align="center"><input tabindex="1" name="smiliepath[' . $smilie['smilieid'] . ']" type="text" value="' . $paths['newpath'] . '" size="50" /></td><td align="center"><img src="' . $smilie['smiliepath'] . '" /></td><td align="center"><img src="' . $paths['newpath'] . '" /></td></tr>';
				}

			break;

			// ##### Style Images
			case 'styleimages':

				print_cells_row(array('<span style="white-space: nowrap"><input type="checkbox" tabindex="999" name="allbox" title="Отметить все" onclick="js_check_all(this.form);" checked="checked" /> Обновить?</span>', 'Переменная стиля', 'Новый адрес', 'Проверка изображения'), 'thead');

				// Get image titles & paths
				$scache = array();
				$styleimages = $db->query_read("
					SELECT * FROM " . TABLE_PREFIX . "template
					WHERE title IN('imgdir_attach', 'imgdir_button', 'imgdir_editor', 'imgdir_misc', 'imgdir_poll', 'imgdir_rating', 'imgdir_reputation', 'imgdir_statusicon', 'titleimage') OR (templatetype = 'css' AND template LIKE '%url(%' AND title != 'EXTRA')
				");
				while ($simage = $db->fetch_array($styleimages))
				{
					$scache["$simage[styleid]"]["$simage[title]"] = $simage['template'];
				}

				// Images to check for
				$stylechecks = array(
					'imgdir_attach' => '/attach.gif',
					'imgdir_button' => '/reply_small.gif',
					'imgdir_editor' => '/quote.gif',
					'imgdir_misc' => '/stats.gif',
					'imgdir_poll' => '/bar6-l.gif',
					'imgdir_rating' => '/rating_5.gif',
					'imgdir_reputation' => '/reputation_pos.gif',
					'imgdir_statusicon' => '/forum_new.gif'
				);

				// Get styles
				$styles = $db->query_read("
					SELECT styleid, title
					FROM " . TABLE_PREFIX . "style
					WHERE styleid != '-1'
					ORDER BY styleid, title
					LIMIT " . ($minlimit - 1) . ", $perpage
				");
				while ($style = $db->fetch_array($styles))
				{
					print_table_header($style['title'], 4, 0, '', $stylevar['left']);

					if (empty($scache[$style['styleid']]))
					{
						$scache[$style['styleid']] = $scache['-1'];
					}

					// Find anything that's in the main style but not this one.
					$defstyle = array_diff(array_keys($stylechecks), array_keys($scache[$style['styleid']]));

					if (!empty($defstyle))
					{
						foreach ($defstyle AS $varname)
						{
							$scache[$style['styleid']][$varname] = $scache['-1'][$varname];
						}
					}

					foreach ($scache[$style['styleid']] AS $varname => $imgpath)
					{
						$imagesample = '';
						if ($varname == 'EXTRA2')
						{
							$classarray = unserialize($imgpath);
							$paths = fetch_image_replaced_string($classarray['all']);

							$classinput = '<textarea name="stylepath[' . $style['styleid'] . '][' . $varname . ']" rows="8" cols="45" tabindex="1">' . htmlspecialchars($paths['newstring']) . '</textarea>';
						}

						else if (substr($varname, 0, 1) == '.' OR $varname == 'body')
						{
							$classarray = unserialize($imgpath);
							$paths = fetch_image_replaced_string($classarray['background']);

							$classinput = '<input size="45" class="bginput" name="stylepath[' . $style['styleid'] . '][' . $varname . ']" value="' . htmlspecialchars($paths['newstring']) . '" tabindex="1" />';
							$imagesample = '<img src="' . $paths['newpath'] . '" />';

						}
						else
						{
							$imgcheck = $stylechecks["$varname"];

							$paths = do_path_check($imgpath . $imgcheck);

							if (substr($varname, 0, 1) == '.')
							{
								$newpath = $paths['newpath'];
							}
							else
							{
								$newpath = substr($paths['newpath'], 0, intval(strlen($paths['newpath']) - strlen($imgcheck)));
							}

							$classinput = '<input class="bginput" name="stylepath[' . $style['styleid'] . '][' . $varname . ']" type="text" value="' . $newpath . '" size="45" tabindex="1" />';
							$imagesample = '<img src="' . $paths['newpath'] . '" />';
						}

						echo '<tr class="' . $paths['class'] . '">
								<td align="left"><input type="checkbox" tabindex="2" name="updatepath[' . $style['styleid'] . '][' . $varname . ']" ' . iif($paths['checked'], 'checked="checked"') . ' value="1" /></td>
								<td>' . $varname . '</td>
								<td align="center">' . $classinput . '</td>
							<td align="center"><div style="overflow: auto; width: 300px; max-height: 120px;">' . $imagesample . '</div></td>
						</tr>';
					}

				}
			break;

			print_table_break();
			break;
		}
	}

	construct_hidden_code('nextpage', $nextpage);
	print_submit_row('Сохранить', 'Обновить', 5);
}

// ##### Do Update Image Paths ################################################
if ($_POST['do'] == 'updateimages')
{
	$vbulletin->input->clean_array_gpc('p', array('updateicon', 'iconpath', 'updatesmilie', 'smiliepath', 'updatepath', 'stylepath', 'type' => TYPE_STR, 'nextpage' => TYPE_INT));

	$updateicon = $vbulletin->input->clean_gpc('p', 'updateicon');
	$iconpath = $vbulletin->input->clean_gpc('p', 'iconpath');
	$updatesmilie = $vbulletin->input->clean_gpc('p', 'updatesmilie');
	$smiliepath = $vbulletin->input->clean_gpc('p', 'smiliepath');
	$updatepath = $vbulletin->input->clean_gpc('p', 'updatepath');
	$stylepath = $vbulletin->input->clean_gpc('p', 'stylepath');
	$type = $vbulletin->input->clean_gpc('p', 'type');
	$nextpage = $vbulletin->input->clean_gpc('p', 'nextpage', TYPE_INT);
	$deficon = $vbulletin->input->clean_gpc('p', 'deficon', TYPE_NOHTML);

	// ##### Update Style Images
	if (is_array($updatepath))
	{
		// Get image titles & paths
		$defstyle = array();
		$styleimages = $db->query_read("
			SELECT title, template FROM " . TABLE_PREFIX . "template
			WHERE title IN('imgdir_attach', 'imgdir_button', 'imgdir_editor', 'imgdir_misc', 'imgdir_poll', 'imgdir_rating', 'imgdir_reputation', 'imgdir_statusicon', 'titleimage') OR (templatetype = 'css' AND template LIKE '%url(%') AND styleid = '-1'
		");
		while ($simage = $db->fetch_array($styleimages))
		{
			$defstyle["$simage[title]"] = $simage['template'];
		}

		foreach ($updatepath AS $sid => $values)
		{
			$sid = intval($sid);

			$tempcache = array();
			$gettemps = $db->query_read("
				SELECT title, template
				FROM " . TABLE_PREFIX . "template
				WHERE title IN('" . implode("', '", array_keys($values)) . "')
					AND styleid = $sid
			");
			while ($temps = $db->fetch_array($gettemps))
			{
				$tempcache[$temps['title']] = $temps['template'];
			}

			foreach ($values AS $var => $update)
			{
				if ($update)
				{
					$insert = false;
					$newtemp = $stylepath[$sid][$var];

					if (!isset($tempcache[$var]))
					{
						$insert = true;
						$tempcache[$var] = $defstyle[$var];
					}

					// EXTRA
					if ($var == 'EXTRA2')
					{
						$template = unserialize($tempcache[$var]);
						$template['all'] = $newtemp;
						$newtemp = serialize($template);
					}
					// CSS Class
					else if (substr($var, 0, 1) == '.' OR $var == 'body')
					{
						$template = unserialize($tempcache[$var]);

						$template['background'] = $newtemp;

						$newtemp = serialize($template);
					}

					if ($insert)
					{
						$db->query_write("
							INSERT INTO " . TABLE_PREFIX . "template
								(styleid, title, template, template_un, templatetype, dateline, username, product)
							VALUES (
								'$sid',
								'$var',
								'" . $db->escape_string($newtemp) . "',
								'',
								'" . iif(substr($var, 0, 1) == '.', 'css', 'stylevar') . "',
								" . TIMENOW . ",
								'" . $db->escape_string($vbulletin->userinfo['username']) . "',
								'vbulletin'
						)");
					}
					else
					{
						$db->query_write("UPDATE " . TABLE_PREFIX . "template SET template = '" . $db->escape_string($newtemp) . "' WHERE title = '$var' AND styleid = '$sid'");
					}
				}
			}
		}
		build_all_styles(0, 0, $scriptfile . '.php?do=finished');
	}

	// ##### Update Icons
	else if (is_array($updateicon))
	{
		foreach ($iconpath AS $key => $val)
		{
			if ($updateicon[$key])
			{
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "icon SET
						iconpath = '" . $db->escape_string($val) . "'
					WHERE iconid = '" . $db->escape_string($key) . "'
				");
			}
		}
		build_image_cache('icon');
	}

	// ##### Update Smilies
	else if (is_array($updatesmilie))
	{
		foreach ($smiliepath AS $key => $val)
		{
			if ($updatesmilie[$key])
			{
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "smilie SET
						smiliepath = '" . $db->escape_string($val) . "'
					WHERE smilieid = '" . $db->escape_string($key) . "'
				");
			}
		}
		build_image_cache('smilie');
	}

	// ##### Default Icon URL
	if ($_POST['updatedicon'])
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value = '$deficon' WHERE varname = 'showdeficon'");
		echo '<br />иконка по умолчанию обновлена.<br />';
		build_options();
	}

	if ($nextpage)
	{
		print_cp_redirect($scriptfile . '.php?do=doimages&type=' . $type . '&pagenumber=' . $nextpage);
	}
	else
	{
		print_cp_redirect($scriptfile . '.php?do=finished');
	}
}

// ##### Upgrade ##############################################################
if ($_REQUEST['do'] == 'upgrade')
{
	$step = intval($_REQUEST['step']);

	print_install_table_start('Обновление vBadvanced ' . $scriptname, 'upgrade');

	$vcheck = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'portal_version'");

	if ($vcheck['value'] == $version)
	{
		$stepphrase = 'Вы уже используете текущую версию vBadvanced ' . $scriptname . '!';
		$nocontinue = 1;
	}
	else if (!$vcheck['value'])
	{
		$stepphrase = 'vBadvanced ' . $scriptname . ' не установлен! В главном меню выберите "Установка".';
		$nocontinue = 1;
	}
	else
	{
		// set here for any new tables added during an upgrade
		$enginevar = 'ENGINE';
		if (version_compare(MYSQL_VERSION, '4.0.18', '<'))
		{
			$enginevar = 'TYPE';
		}
		
		switch ($vcheck['value'])
		{
			case 'RC2':
			case '1.0.0':

				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_settinggroup SET displayorder = displayorder+1 WHERE grouptitle LIKE 'adv_portal%'");

				$checkglobal = $db->query_first("SELECT grouptitle FROM " . TABLE_PREFIX . "adv_settinggroup WHERE grouptitle = 'adv_global'");

				if (!$checkglobal['grouptitle'])
				{
					$db->query_write("INSERT INTO " . TABLE_PREFIX . "adv_settinggroup VALUES ('adv_global', 1)");
					insert_phrase('settinggroup_adv_global', 'Основные настройки vBadvanced', 5000);
				}


			case '1.0.1':

				// Alter module table
				$db->query_write("
					ALTER TABLE " . TABLE_PREFIX . "adv_modules
					ADD parent varchar(255) NOT NULL default '',
					ADD colspan smallint(3) unsigned NOT NULL default '0',
					ADD formcode text NOT NULL,
					ADD cleanoutput smallint(3) unsigned NOT NULL default '0',
					ADD useshell smallint(3) unsigned NOT NULL default '0',
					ADD link varchar(255) NOT NULL default '',
					ADD options text NOT NULL,
					CHANGE filename filename text NOT NULL,
					CHANGE inctype inctype varchar(20) NOT NULL default ''
				");
				$stepphrase .= 'В таблицу adv_modules добавлены новые дополнительные поля.<br />';

				// Alter page table
				$db->query_write("
					ALTER TABLE " . TABLE_PREFIX . "adv_pages ADD type varchar(50) NOT NULL default '' AFTER name,
					ADD parentid int(10) unsigned NOT NULL default '0' AFTER template,
					ADD parentlist varchar(255) NOT NULL default '' AFTER template,
					ADD active smallint(3) unsigned NOT NULL default '0',
					ADD colspan smallint(3) unsigned NOT NULL default '0',
					ADD formcode text NOT NULL,
					ADD cleanoutput smallint(3) unsigned NOT NULL default '0',
					ADD useshell smallint(3) unsigned NOT NULL default '0',
					ADD custom_title varchar(255) NOT NULL default '',
					CHANGE template template text NOT NULL
				");
				$stepphrase .= 'В таблицу adv_pages добавлены новые дополнительные поля.<br /><br />';

				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_pages SET active = 1");
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_pages SET type = 'template' WHERE template != ''");
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_pages SET type = 'module' WHERE type = ''");

				$getpsetting = $db->query_read("SELECT pageid, advanced FROM " . TABLE_PREFIX . "adv_pages WHERE advanced != ''");
				while ($psetting = $db->fetch_array($getpsetting))
				{
					$psetting['advanced'] = unserialize($psetting['advanced']);
					$pagesettings = array();
					if (!empty($psetting['advanced']))
					{
						foreach ($psetting['advanced'] AS $varname => $value)
						{
							$sgroup = $db->query_first("SELECT grouptitle FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$varname'");
							$pagesettings["$sgroup[grouptitle]"]["$varname"] = $value;
						}
					}
					$db->query_write("UPDATE " . TABLE_PREFIX . "adv_pages SET advanced = '" . serialize($pagesettings) . "' WHERE pageid = '$psetting[pageid]'");
				}

				$stepphrase = 'Страница параметров обновлена.<br /><br />';

				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET inctype = 'php_file' WHERE inctype = 0");
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET inctype = 'template' WHERE inctype = 1");
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET inctype = 'custom' WHERE inctype = 2");

				$db->query_write("INSERT INTO " . TABLE_PREFIX . "datastore (title) VALUES ('adv_portal_page')");

				// Update module usergroup perms
				$getoldmods = $db->query_read("SELECT modid, userperms FROM " . TABLE_PREFIX . "adv_modules");
				while ($oldmod = $db->fetch_array($getoldmods))
				{
					if (!$oldmod['userperms'])
					{
						$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET userperms = '" . implode(',', array_keys($vbulletin->usergroupcache)) . "' WHERE modid = '$oldmod[modid]'");
					}
				}

				// Update Modules
				foreach ($vba_modules AS $modid => $module)
				{
					if (in_array($module['identifier'], array('navigation', 'birthdays')))
					{
						if ($module['identifier'] == 'navigation')
						{
							$module['active'] = 0;
						}
						$module['userperms'] = implode(',', array_keys($vbulletin->usergroupcache));
						$db->query_read(fetch_query_sql($module, 'adv_modules'));
					}
					else
					{

						$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET identifier = '$module[identifier]', inctype = '$module[inctype]', templatelist = '$module[templatelist]', parent = '$module[parent]', colspan = '$module[colspan]', formcode = '$module[formcode]', useshell = '$module[useshell]', link = '$module[link]' WHERE filename = '$module[filename]' " . iif(in_array($module['filename'], array('news.php', 'onlineusers.php')), "AND identifier = '$module[identifier]'"));
					}
				}

				$stepphrase .= 'Обновлены модули.<br /><br />';

				// Update settings

				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET grouptitle = 'adv_portal_calendar' WHERE varname = 'portal_calendarid'");
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET grouptitle = 'adv_portal_style' WHERE varname IN('portal_shownavbar', 'portal_colspacing', 'portal_rightcolwidth', 'portal_leftcolwidth', 'portal_blockbullet')");

				$db->query_write("INSERT INTO " . TABLE_PREFIX . "adv_settinggroup VALUES ('adv_portal_style', 3)");

				$db->query_write("DELETE FROM " . TABLE_PREFIX . "template WHERE title IN('adv_portal', 'adv_portal_buddylist', 'adv_portal_buddylistbits', 'adv_portal_calendar', 'adv_portal_latesttopicbits', 'adv_portal_latesttopics', 'adv_portal_moderation', 'adv_portal_newsbits', 'adv_portal_news_archive', 'adv_portal_news_archivebits', 'adv_portal_onlineusers', 'adv_portal_poll', 'adv_portal_polloption', 'adv_portal_polloption_multiple', 'adv_portal_pollresult', 'adv_portal_search', 'adv_portal_stats', 'adv_portal_welcomeblock')");

				$chpoll = $db->query_first("SELECT value FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'portal_poll_forumid'");

				// Check poll value
				if ($chpoll['value'] == 'RAND')
				{
					$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET value = '" . implode(',', array_keys($vbulletin->forumcache)) . "' WHERE varname = 'portal_poll_forumid'");
					$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET value = 'rand' WHERE varname = 'portal_poll_orderby'");
				}

			case '2.0 RC1 (vB 3.5)':
			case '2.0 RC1':

				// Alter adv_pages table to include meta and displayorder
				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_pages ADD meta TEXT NOT NULL, ADD displayorder SMALLINT(4) UNSIGNED DEFAULT '0' NOT NULL");

				kill_phrase('edit_template_in_style', 'adv_portal_cp');

				$stepphrase .= 'Обновлены фразы.<br /><br />';

			case '2.0 RC2 (vB 3.5)':
			case '2.0 RC2':

				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET colspan = 6 WHERE identifier = 'newsarchive'");
				$stepphrase .= 'Обновлен новостной архив.<br /><br />';

				kill_phrase('adv_portal_must_choose_file_include', 1000);

			case '2.0.0':

				// Update module links & form code
				$getmods = $db->query_read("SELECT modid, formcode, link FROM " . TABLE_PREFIX . "adv_modules");
				while ($mod = $db->fetch_array($getmods))
				{
					$mod['link'] = str_replace('$vboptions[bburl]', '{$vbulletin->options[bburl]}', $mod['link']);
					$mod['formcode'] = str_replace('$vboptions[bburl]', '{$vbulletin->options[bburl]}', $mod['formcode']);

					$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET formcode = '$mod[formcode]', link = '$mod[link]' WHERE modid = '$mod[modid]'");
				}

				foreach ($vba_modules AS $modid => $module)
				{
					if ($module['link'])
					{
						$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET link = '" . $db->escape_string($module['link']) . "' WHERE identifier = '$module[identifier]'");
					}
				}

				update_module_cache();

			case '2.0.0 (vB 3.5)':

				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_modules, ADD COLUMN code_parsed text NOT NULL");
				$stepphrase .= 'В таблицу adv_modules добавлена колонка code_parsed.<br /><br />';

				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_modules CHANGE templatelist templatelist TEXT NOT NULL");
				$stepphrase .= 'В таблице adv_modules обновлен счётчик символов дополнительных полей листа шаблонов.';

				$freplace = $db->query_first("SELECT value FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'global_footer_replace'");

				$freplace['value'] = explode("\r\n", $freplace['value']);

				if (!in_array('profile.php', $freplace['value']))
				{
					$freplace['value'][] = 'profile.php';

					$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET value = '" . $db->escape_string(implode("\r\n", $freplace['value'])) . "' WHERE varname = 'global_footer_replace'");
					$stepphrase = 'Добавлен profile.php в шаблон footer.<br /><br />';
				}

				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "session ADD newposts INT(10) UNSIGNED NULL");
				$stepphrase = 'В таблицу session добавлены поля новых сообщений.<br /><br />';

				include_once('./includes/class_bbcode.php');
				include_once('./includes/functions_forumdisplay.php');

				$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

				$getmods = $db->query_read("SELECT modid, filename, options FROM " . TABLE_PREFIX . "adv_modules WHERE inctype = 'bb_code'");
				while ($mod = $db->fetch_array($getmods))
				{
					$setting = unserialize($mod['options']);

					$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET code_parsed = '" . $db->escape_string($bbcode_parser->do_parse($mod['filename'], $setting['allow_html'], $setting['allow_smilies'], 1, $setting['allow_image_code'])) . "' WHERE modid = '$mod[modid]'");
				}
				$stepphrase = 'Обновлены модули BB кодов.<br /><br />';

				$db->query_write("INSERT INTO " . TABLE_PREFIX . "product (productid, title, description, version, active) VALUES ('" . PRODUCT_CODE . "', 'vBadvanced CMPS', 'vBadvanced Content Management & Portal System', '" . $version . "', 1)");

				$stepphrase .= 'Добавление CMPS в продукты.<br /><br />';

				$db->query_write("UPDATE " . TABLE_PREFIX . "plugin SET devkey = 'adv_error' WHERE devkey = 'vba_error'");

				foreach ($mainphrases AS $phrasetypeid => $phrases)
				{
					$db->query_write("UPDATE " . TABLE_PREFIX . "phrase SET product = '" . PRODUCT_CODE . "' WHERE fieldname = '$phrasetypeid' AND varname IN('" . implode("', '", array_keys($phrases)) . "')");
				}

				$stepphrase .= 'Добавлены/обновлены фразы.<br /><br />';


				$db->query_write("INSERT INTO " . TABLE_PREFIX . "datastore (title) VALUES ('adv_portal_tpst')");
				$stepphrase .= 'Перестроены дополнительные поля лучшего автора в таблице datastore.<br /><br />';

			case '2.1.0':
			case '2.2.0':

				$db->query_write("UPDATE " . TABLE_PREFIX . "datastore SET unserialize = 1 WHERE title IN('adv_portal_opts', 'adv_modules', 'adv_portal_page', 'adv_portal_tpst')");

				$stepphrase .= 'Обновлены параметры записей в таблице datastore.<br />';

				$db->query_write("UPDATE " . TABLE_PREFIX . "product SET description = 'vBadvanced Content Management & Portal System' WHERE productid = '" . PRODUCT_CODE . "'");

				update_page_cache();

			case '2.2.1':
			case '2.2.1 (vB 3.6)':

				// First version of the CMPS with the serialize column
				$db->reporterror = 0;
				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_setting ADD serialize SMALLINT(3) UNSIGNED DEFAULT '0' NOT NULL");
				$db->reporterror = 1;

				// Cache the modules and update it all below
				$modcache = array();
				$getmods = $db->query_read("
					SELECT modid, modcol, identifier, parent, displayorder, filename, templatelist
					FROM " . TABLE_PREFIX . "adv_modules
					ORDER BY modcol, displayorder
				");
				while ($mod = $db->fetch_array($getmods))
				{
					$modcache[$mod['modid']] = $mod;
				}

				// Page layouts & settings
				$getpages = $db->query_read("SELECT pageid, modules, advanced FROM " . TABLE_PREFIX . "adv_pages");
				while ($page = $db->fetch_array($getpages))
				{
					$layout = array(
						1 => array(),
						2 => array(),
						3 => array()
					);

					$page['modules'] = explode(',', $page['modules']);

					if (!empty($page['modules']))
					{
						foreach ($modcache AS $modcid => $modc)
						{
							if (in_array($modcid, $page['modules']))
							{
								$layout[($modc['modcol'] + 1)][$modcid] = $modc['displayorder'];
							}
						}

						foreach ($layout AS $column => $mods)
						{
							asort($layout[$column], SORT_NUMERIC);
						}
					}

					$page['advanced'] = unserialize($page['advanced']);

					// Format the advanced settings
					if (!empty($page['advanced']))
					{
						foreach ($page['advanced'] AS $adv_group => $adv_settings)
						{
							if (!empty($adv_settings))
							{
								foreach ($adv_settings AS $adv_varname => $adv_value)
								{
									switch ($adv_varname)
									{
										case 'portal_navigation_excludepages':
											$page['advanced'][$adv_group][$adv_varname] = explode(',', $adv_value);
										break;

										case 'portal_navigation_addpages':
										case 'portal_threadids':
											if (!is_array($adv_value))
											{
												$page['advanced'][$adv_group][$adv_varname] = unserialize($adv_value);
											}
										break;

										case 'portal_threads_forumids':
										case 'portal_news_forumid':
										case 'portal_poll_forumid':
										case 'portal_navigation_excludepages':
											$page['advanced'][$adv_group][$adv_varname] = ($adv_value) ? explode(',', $adv_value) : array();
										break;
									}
								}
							}
						}
					}

					$db->query_write("
						UPDATE " . TABLE_PREFIX . "adv_pages SET
							modules = '" . $db->escape_string(serialize($layout)) . "',
							advanced = '" . $db->escape_string(serialize($page['advanced'])) . "'
						WHERE pageid = $page[pageid]
					");
				}

				// Pages table alterations
				$db->query_write("
					ALTER TABLE " . TABLE_PREFIX . "adv_pages
						CHANGE modules modules TEXT NOT NULL,
						CHANGE advanced advanced TEXT NOT NULL
				");

				$stepphrase .= 'Завершение обновления таблицы adv_pages.<br /><br />';

				require_once(DIR . '/includes/functions_misc.php');

				$modoptfiles = array();
				foreach ($vba_modules AS $modid => $module)
				{
					if ($module['options'])
					{
						// Distinguish between the parent and child
						if ($module['parent'])
						{
							$module['filename'] .= '-child';
						}
						$modoptfiles[$module['filename']] = $module['options'];
					}
				}

				// Update templatelist's to use new format
				foreach ($modcache AS $modid => $modinfo)
				{
					$modupdatequery = array();
					if (trim($modinfo['templatelist']))
					{
						$tlist = array_map('trim', explode(',', $modinfo['templatelist']));

						if ($modinfo['parent'])
						{
							$modinfo['filename'] .= '-child';
						}

						// Add new templates
						switch ($modinfo['filename'])
						{
							case 'latesttopics.php':
								$tlist = array_diff($tlist, array(
										'adv_portal_latesttopicbits',
										'adv_portal_latestthreads_head',
										'adv_portal_latesttopics'
								));
								$tlist[] = 'adv_portal_recthreads_lean';
								$tlist[] = 'adv_portal_recthreads_exp';
								$tlist[] = 'adv_portal_recthreads_exp_head';
							break;

							case 'news.php':
								if ($modinfo['parent'])
								{
									$tlist = array_diff($tlist, array(
											'adv_portal_news_archive_head',
											'adv_portal_news_archivebits'
									));
									$tlist[] = 'adv_portal_archivebits_exp';
									$tlist[] = 'adv_portal_archivebits_exp_head';
									$tlist[] = 'adv_portal_archivebits_lean';
								}
							break;

							case 'welcomeblock.php':
								unset($tlist['adv_portal_welcomeblock']);

								$tlist[] = 'adv_portal_welcomeblock_lean';
								$tlist[] = 'adv_portal_welcomeblock_expanded';
							break;
						}

						$tlist = implode("\r\n", $tlist);

						$modupdatequery[] = "templatelist = '" . $db->escape_string($tlist) . "'";
					}

					// Change from serialized array to bitfield
					if ($modinfo['inctype'] == 'bbcode')
					{
						$modinfo['options'] = unserialize($modinfo['options']);
						$newopts = convert_array_to_bits($modinfo['options'], $vba_bbc_modint);

						$modupdatequery[] = "options = '$newopts'";
					}

					if ($modinfo['identifier'] AND $modinfo['filename'])
					{
						$modupdatequery[] = "options = '" . intval($modoptfiles[$modinfo['filename']]) . "'";
					}

					if (!empty($modupdatequery))
					{
						$db->query_write("
							UPDATE " . TABLE_PREFIX . "adv_modules SET
								" . implode(', ', $modupdatequery) . "
							WHERE modid = $modid
						");
					}
				}


				// Delete old templates from master style
				$db->query_write("
					DELETE FROM " . TABLE_PREFIX . "template
					WHERE title IN(
						'adv_portal_latesttopicbits',
						'adv_portal_latestthreads_head',
						'adv_portal_latesttopics',
						'adv_portal_news_archive_head',
						'adv_portal_news_archivebits',
						'adv_portal_welcomeblock'
					) AND styleid = '-1'
				");

				// Update the latest topics module to use recentthreads.php
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET filename = 'recentthreads.php' WHERE filename = 'latesttopics.php'");

				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET options = 8 WHERE cleanoutput = 1");

				$db->query_write("
					ALTER TABLE " . TABLE_PREFIX . "adv_modules
						DROP modcol,
						DROP displayorder,
						DROP cleanoutput,
						CHANGE options options SMALLINT(3) NOT NULL
				");

				$stepphrase .= 'Завершение обновления таблицы adv_modules.<br /><br />';


				// Add homepage cache
				$db->query_write("INSERT INTO " . TABLE_PREFIX . "datastore (title, unserialize) VALUES ('adv_portal_home', 1)");

				$stepphrase .= 'Добавление кэширования записей главной страницы в таблицу datastore.<br /><br />';

				// Update forumid settings to serialize instead of explode
				$getforumsettings = $db->query_read("
					SELECT varname, grouptitle, value
					FROM " . TABLE_PREFIX . "adv_setting
					WHERE varname IN('portal_threads_forumids', 'portal_news_forumid', 'portal_poll_forumid', 'portal_navigation_excludepages')
				");
				while ($forumsetting = $db->fetch_array($getforumsettings))
				{
					$forumsetting['value'] = ($forumsetting['value']) ? explode(',', $forumsetting['value']) : array();
					$db->query_write("
						UPDATE " . TABLE_PREFIX . "adv_setting SET
							value = '" . $db->escape_string(serialize($forumsetting['value'])) . "'
						WHERE varname = '$forumsetting[varname]'
							AND grouptitle = '$forumsetting[grouptitle]'
					");
				}

				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET serialize = 1 WHERE varname IN('portal_threads_forumids', 'portal_threadids')");

				// Update module shell template name
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "template SET
						title = 'adv_portal_module_wrapper'
					WHERE title = 'adv_portal_module_shell'
				");

				$db->query_write("
					DELETE FROM " . TABLE_PREFIX . "phrase
					WHERE fieldname = 'adv_portal'
						AND varname IN('news_archive', 'on', 'quick_moderation', 'x_attachment', 'x_events', 'x_posts', 'x_threads', 'x_users')
				");

				$db->query_write("
					DELETE FROM " . TABLE_PREFIX . "phrase
					WHERE fieldname = 'adv_portal_cp'
						AND varname IN('hide_module_settings', 'module_identifier', 'module_name', 'module_shell_template_options', 'options_apply_to_module_shell', 'or_template_to_include', 'page_template', 'page_template_description', 'show_module_settings', 'template_note_prefixes', 'templates_used_note', 'this_what_used_identify_module',	'update_all_pages', 'use_module_shell_template')
				");


				$db->query_write("
					DELETE FROM " . TABLE_PREFIX . "phrase
					WHERE fieldname = 'error' AND varname IN('adv_portal_must_choose_include')
				");

				$stepphrase .= 'Удаление старых фраз.<br /><br />';

			case '3.0 Beta 1':
				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_modules ADD altshell VARCHAR(255) NOT NULL AFTER useshell");

				// This part only needs to be run if they were actually running the beta
				if ($vcheck['value'] == '3.0 Beta 1')
				{
					$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET options = options+16 WHERE filename IN('recentthreads.php', 'currentpoll.php', 'news.php')");

					$colsetting = $db->query_first("SELECT value FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'portal_column_array'");
					$colvals = explode("\r\n", $colsetting['value']);

					$newcolumns = array();
					if (!empty($colvals))
					{
						foreach ($colvals AS $coldata)
						{
							$coldata = explode('|', $coldata);

							if (intval($coldata[0]) AND trim($coldata[1]))
							{
								$newcolumns[$coldata[0]] = $coldata[1];
							}
						}
					}

					$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET value = '" . $db->escape_string(serialize($newcolumns)) . "' WHERE varname = 'portal_column_array'");
				}

				// Turn the module function setting off for upgrades so custom modules won't break
				$mainsettings['adv_portal_main']['portal_use_module_function']['value'] = 0;

			case '3.0 RC1':

				// Make sure the custom page content module was not deactivated in a previous version
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET active = 1 WHERE inctype = 'custom'");

			case '3.0 RC2':

				$stepphrase .= 'Добавление index в таблицу опросов.<br /><br />';
				vbflush();
				add_table_index('poll', 'dateline');

				kill_template('recthreads_expanded');
				kill_phrase('discuss_this_poll');

				// Could still be around from old CMPS versions
				$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_settinggroup WHERE grouptitle = 'adv_portal_misc'");
				$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle = 'adv_portal_misc'");

				$db->reporterror = 0; // not sure how people are getting dupe errors, but they are
				$db->query_write("INSERT INTO " . TABLE_PREFIX . "datastore (title, data, unserialize) VALUES ('adv_portal_pars', '', 1)");
				$db->reporterror = 1;
                                				
                                $db->query_write("UPDATE " . TABLE_PREFIX . "datastore SET title = 'adv_portal_stat', data = '' WHERE title = 'adv_portal_tpst'");
				$stepphrase .= 'Переименование модуля статистики в таблице datastore.<br /><br />';

				$getmods = array();
				foreach ($vba_modules AS $modid => $module)
				{
					if ($module['identifier'])
					{
						$getmods[] = "'$module[identifier]'";
					}
				}

				// Update Module Links
				$querymods = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "adv_modules WHERE identifier IN(" . implode(', ', $getmods) . ")");
				while ($mods = $db->fetch_array($querymods))
				{
					$linkcheck = strstr($mods['link'], '$session[sessionurl]');
					$newlink = '';

					if ($linkcheck)
					{
						if ($linkcheck == '$session[sessionurl]')
						{
							$newlink = '{$vbulletin->session->vars[sessionurl_q]}';
							$findtext = '?$session[sessionurl]';
						}
						else
						{
							$newlink = '{$vbulletin->session->vars[sessionurl]}';
							$findtext = '$session[sessionurl]';
						}

						$db->query_write("
							UPDATE " . TABLE_PREFIX . "adv_modules SET
								link = '" . str_replace($findtext, $newlink, $mods['link']) . "'
								WHERE modid = $mods[modid]
						");
					}
				}

				$stepphrase .= 'Обновление ссылок на модули, а так же заменение $session[sessionurl] на {$vbulletin->session->vars[sessionurl].<br /><br />';

				// Insert tags module
				$tagsmod = $vba_modules['15'];

				$tagsmod['userperms'] = implode(',', array_keys($vbulletin->usergroupcache));
				$tagsmod['templatelist'] = str_replace(' ', "\r\n", $tagsmod['templatelist']);

				$db->query_write(fetch_query_sql($tagsmod, 'adv_modules'));

				$stepphrase .= 'Добавление модуля &quot;Популярные метки&quot;.<br /><br />';

			case '3.0.0':
				
				// Update modules to add security token
				$querymods = $db->query_read("SELECT modid, formcode FROM " . TABLE_PREFIX . "adv_modules WHERE formcode LIKE '%<form%'");
				while ($mods = $db->fetch_array($querymods))
				{
					if (strpos($mods['formcode'], 'securitytoken') === false)
					{
						$mods['formcode'] .= '<input type="hidden" name="securitytoken" value="{$vbulletin->userinfo[securitytoken]}" />';
						$db->query_write("
							UPDATE " . TABLE_PREFIX . "adv_modules SET
								formcode = '" . $db->escape_string($mods['formcode']) . "'
							WHERE modid = $mods[modid]
						");
					}
				}
			case '3.0.1':

				// Alter page table
				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_pages CHANGE useshell useshell smallint(3) unsigned NOT NULL default '0'");

			case '3.1.0':

				$db->query_write("
					CREATE TABLE " . TABLE_PREFIX . "adv_pages_user (
					  pageid int(10) unsigned NOT NULL default '0',
					  userid int(10) unsigned NOT NULL default '0',
					  layout text NOT NULL,
					  UNIQUE KEY pageid (pageid,userid)
					) $enginevar=MyISAM
				");

				$stepphrase .= 'Создание таблицы adv_pages_user.<br /><br />';

				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_modules ADD dyna_prefix VARCHAR(50) NOT NULL");
				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_pages ADD customize SMALLINT(3) UNSIGNED NOT NULL DEFAULT '0' AFTER useshell");

				$stepphrase .= 'Обновление новых колонок.<br /><br />';

				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET grouptitle = '' WHERE varname = 'portal_replaceadmin' AND grouptitle = 'adv_portal_main'");

			case '3.2.0':

				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_pages ADD dateline INT(10) UNSIGNED NOT NULL DEFAULT '0'");
				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_pages_user ADD dateline INT(10) UNSIGNED NOT NULL DEFAULT '0'");

			// #####
			default:

				// ##### Templates
				insert_all_templates();

				$rebuildtemp = true;

				$stepphrase .= 'Обновлены шаблоны.<br /><br />';
				vbflush();

				$db->query_write("
					UPDATE " . TABLE_PREFIX . "adv_setting SET
						value = '$version'
					WHERE varname = 'portal_version'
				");

				$db->query_write("
					UPDATE " . TABLE_PREFIX . "product SET
						version = '" . $version . "',
						url = 'http://www.vbadvanced.com'
					WHERE productid = '" . PRODUCT_CODE . "'
				");

				$stepphrase .= 'Обновлен номер версии.<br /><br />';

				// Update the settings, and phrases are handled within the function too
				rebuild_all_settings();

				$stepphrase .= 'Добавление/обновление фраз.<br /><br />';
				$stepphrase .= 'Обновление основных параметров и добавление новых.<br /><br />';

				insert_plugins();

				update_page_cache();
				update_homepage_cache();

				update_module_cache();

				if (in_array($vcheck['value'], array('1.0.0', '1.0.1', 'RC2')))
				{
					construct_hidden_code('redirect', 'finished');
					$nextdo = 'alttables';
				}
				else
				{
					$nextdo = 'finished';
				}

		}
	}

	print_install_table_end();
}

// ##### Uninstall ############################################################
if ($_REQUEST['do'] == 'uninstall')
{
	$step = $_REQUEST['step'];
	$forumsoff = intval($_REQUEST['forumsoff']);

	print_install_table_start('Удаление vBadvanced ' . $scriptname, 'uninstall');

	$db->reporterror = 0;

	switch ($step)
	{
		case 1:
			$stepphrase = 'Жаль, что вам не понравился vBadvanced ' . $scriptname . '. Этот скрипт удалит все изменения, сделанные при установке vBadvanced ' . $scriptname . '.</div>';
		break;

		case 2:

			if ($vbulletin->options['bbactive'])
			{
				print_description_row('Пожалуйста, закройте ваш форум для продолжения', '', 2, 'thead');
				print_textarea_row('Сообщение о закрытии форума:', 'closedmessage', $vbulletin->options['bbclosedreason'], 4, 40, 1, 0);
				construct_hidden_code('redirect', 'uninstall');
				$nextdo = 'closeforums';
			}
			else
			{
				print_cp_redirect($scriptfile . '.php?do=uninstall&amp;step=3');
			}

		break;

		case 3:

			$db->query_write("DROP TABLE " . TABLE_PREFIX . "adv_modules");
			$db->query_write("DROP TABLE " . TABLE_PREFIX . "adv_pages");
			$db->query_write("DROP TABLE " . TABLE_PREFIX . "adv_pages_user");

			$stepphrase .= 'Удаление таблиц.<br /><br />';

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE fieldname IN('adv_portal','adv_portal_cp')");

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrasetype WHERE fieldname IN('adv_portal','adv_portal_cp')");

			$db->query_write("
				ALTER TABLE " . TABLE_PREFIX . "language
					DROP phrasegroup_adv_portal,
					DROP phrasegroup_adv_portal_cp
			");

			$stepphrase .= 'Удаление фраз.<br /><br />';

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "product WHERE productid = '" . PRODUCT_CODE . "'");

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "plugin WHERE devkey IN('" . implode("', '", array_keys($vba_plugins)) . "') AND product = 'adv_cmps'");

			$stepphrase .= 'Удаление продукта и плагинов.<br /><br />';

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "session DROP newposts");
			$stepphrase .= 'Из таблицы session удалены дополнительные поля.<br /><br />';

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "template WHERE product = 'adv_cmps'");

			$stepphrase .= 'Удалены шаблоны.<br /><br />';

			unset($mainsettings['adv_global']);
			unset($adv_settinggroups['adv_global']);

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle LIKE 'adv_portal%'");
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_settinggroup WHERE grouptitle LIKE 'adv_portal%'");

			$stepphrase .= 'Удалены параметры.<br /><br />';

			$db->query_write("
				DELETE FROM " . TABLE_PREFIX . "datastore
				WHERE title IN(
					'adv_portal_opts',
					'adv_modules',
					'adv_portal_page',
					'adv_portal_pars',
					'adv_portal_stat',
					'adv_portal_home',
					'adv_portal_cale'
			)");

			vBulletinHook::build_datastore($db);

			$stepphrase .= 'Удалены дополнительные поля из таблицы datastore.<br />';

		break;

		case 4:
			$stepphrase = 'Удалён index добавленый в пользовательскую таблицу.<br />';
			vbflush();
			$db->query_write("ALTER TABLE" . TABLE_PREFIX . "user DROP INDEX (posts)");
		break;

		case 5:
			$stepphrase = 'Удалён index добавленый в таблицу опросов.<br />';
			vbflush();
			$db->query_write("ALTER TABLE" . TABLE_PREFIX . "poll DROP INDEX (dateline)");
		break;

		case 6:
			$stepphrase = 'Удалён index добавленый в таблицу тем.<br />';
			vbflush();
			$db->query_write("ALTER TABLE" . TABLE_PREFIX . "thread DROP INDEX (lastpost)");
		break;

		case 7:
			$stepphrase = 'Удалён index добавленый в таблицу сообщений.<br />';
			vbflush();
			$db->query_write("ALTER TABLE" . TABLE_PREFIX . "post DROP INDEX (dateline)");
			$nextstep = 'finished';

			if ($forumsoff)
			{
				$db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value = 1 WHERE varname = 'bbactive'");
				build_options();

				$stepphrase .= '<br />Ваш форум снова открыт.';
			}
		break;

		case 'finished':

			$stepphrase = 'vBadvanced ' . $scriptname . ' успешно удалён.<br /> <br /><a href="index.php"><strong>Вход в панель администратора --&gt;</strong></a><br /><br /><a href="' . $scriptfile . '.php"><strong>Нажмите здесь для начала новой установки --&gt;</strong></a>';
			$nocontinue = 1;

		break;
	}

	print_install_table_end();
}

// ##### Rebuild Settings #####################################################
if ($_REQUEST['do'] == 'rebuildsettings')
{
	print_install_table_start();

	rebuild_all_settings();

	$stepphrase = 'Параметры обновлены.<br /><br />';
	$nextdo = 'finished';

	print_install_table_end();
}

// ##### Reinstall plugins ####################################################
if ($_REQUEST['do'] == 'updateplugins')
{
	print_install_table_start();

	insert_plugins();

	$stepphrase = 'Плагины переустановлены.<br /><br />';
	$nextdo = 'finished';

	print_install_table_end();
}

print_cp_footer();

?>