<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBCMS Version 2.6.8
|| # ------------------------------------------------------------------ # ||
|| # Copyright  2002 - 2009 Reuter & Bloe GbR.                          ||
|| # ------------------- VBCMS IS NOT FREE SOFTWARE ------------------- # ||
|| # http://www.vbdesigns.de | http://www.vbdesigns.de/license.html     # ||
|| ###################################################################### ||
\*========================================================================*/
if(!class_exists('vBCMS_fetch_components'))
{
        exit;
}

/**
* Class to do data handle payment operations for vBCMS products
*
* @package	vBCMS 2.6.8
* @version	$Revision: 1628 $
* @date		$Date: 2009-09-21 19:14:56 +0200 (Mo, 21. Sep 2009) $
*/
class sofortueberweisung extends vbcms_payments
{
	/**
	* For the description of the objects see /includes/class_vbcms_payments.php
	*
	* @var	mixed
	*/
	var $name = 'sofortberweisung.de';
	var $host = 'https://www.payment-network.com/';
	var $formurl = 'https://www.sofortueberweisung.de/payment/start';
	var $allowed_countrys = 'DE';
	var $success_message = true;
	/**
	* Constructor - checks that the registry object has been passed correctly.
	*
	* @param	(ref)  vB_Registry	Instance of the vBulletin data registry object.
	*/
	function sofortueberweisung(&$registry, $additional = '')
	{
		// Set registry and db object
		parent::vbcms_payments($registry);
		$this->redirect = true;

		if($additional)
		{
			$this->handle_additional($additional);
		}                
	}

	/**
	* Verify the payment.
	*
	* @return boolean
	*
	*/
	function check_payment()
	{
			$this->registry->input->clean_array_gpc('r', array(
				'transaction'            => TYPE_STR,
				'user_id'       => TYPE_INT,
				'project_id'       => TYPE_INT,
				'sender_holder'            => TYPE_STR,
				'sender_account_number'            => TYPE_STR,
				'sender_bank_code'            => TYPE_STR,
				'sender_bank_name'                      => TYPE_STR,
				'sender_bank_bic'			           => TYPE_STR,
				'sender_iban'            => TYPE_STR,
				'sender_country_id'            => TYPE_STR,
				'recipient_holder'            => TYPE_STR,
				'recipient_account_number'            => TYPE_STR,
				'recipient_bank_code'            => TYPE_STR,
				'recipient_bank_name'            => TYPE_STR,
				'recipient_bank_bic'           => TYPE_STR,
				'recipient_iban'            => TYPE_STR,
				'recipient_country_id'            => TYPE_STR,
				'international_transaction'       => TYPE_INT,
				'amount'             => TYPE_STR,
				'currency_id'            => TYPE_STR,
				'reason_1'            => TYPE_STR,
				'reason_2'            => TYPE_STR,
				'security_criteria'       => TYPE_INT,
				'user_variable_0'            => TYPE_STR,
				'user_variable_1'            => TYPE_STR,
				'user_variable_2'            => TYPE_STR,
				'user_variable_3'            => TYPE_STR,
				'user_variable_4'            => TYPE_STR,
				'user_variable_5'            => TYPE_STR,
				'email_sender'            => TYPE_STR,
				'email_recipient'           => TYPE_STR,
				'created'            => TYPE_STR,
				'hash'           => TYPE_STR
			));
			
			$field = unserialize($this->settings['field']);
			
			$data = array (
				$this->registry->GPC['transaction'],      
				$this->registry->GPC['user_id'],     
				$this->registry->GPC['project_id'],      
				$this->registry->GPC['sender_holder'],         
				$this->registry->GPC['sender_account_number'],    
				$this->registry->GPC['sender_bank_code'],           
				$this->registry->GPC['sender_bank_name'],                   
				$this->registry->GPC['sender_bank_bic'],			           
				$this->registry->GPC['sender_iban'],
				$this->registry->GPC['sender_country_id'],
				$this->registry->GPC['recipient_holder'],
				$this->registry->GPC['recipient_account_number'],           
				$this->registry->GPC['recipient_bank_code'],           
				$this->registry->GPC['recipient_bank_name'],          
				$this->registry->GPC['recipient_bank_bic'],        
				$this->registry->GPC['recipient_iban'],          
				$this->registry->GPC['recipient_country_id'],          
				$this->registry->GPC['international_transaction'],      
				$this->registry->GPC['amount'],          
				$this->registry->GPC['currency_id'],      
				$this->registry->GPC['reason_1'],     
				$this->registry->GPC['reason_2'],   
				$this->registry->GPC['security_criteria'],
				$this->registry->GPC['user_variable_0'],   
				$this->registry->GPC['user_variable_1'],          
				$this->registry->GPC['user_variable_2'],
				$this->registry->GPC['user_variable_3'],
				$this->registry->GPC['user_variable_4'],
				$this->registry->GPC['user_variable_5'],
				$this->registry->GPC['created'],
				utf8_decode($field['secret'])
			);

			$data_implode = implode('|', $data);
			
		    $hash = sha1($data_implode);	

			if ($hash == $this->registry->GPC['hash'])
			{
				$this->paymentinfo = $this->registry->db->query_first("
					SELECT *
					FROM " . TABLE_PREFIX . "vbcmsprodsorder
					WHERE ordernumber = " . intval($this->registry->GPC['reason_1']) . "
				");	

				if (!empty($this->paymentinfo))
				{
					if(doubleval($this->paymentinfo['price']) == doubleval($this->registry->GPC['amount']))
					{
						$this->status = true;
					}
					else
					{
						$this->error = 'invalid_payment_amount ' .doubleval($this->paymentinfo['price']) .' ' .doubleval($this->registry->GPC['amount']);
					}
				}	
				else
				{
					$this->error = 'No Paymentinfo';
				}
			}			
			else
			{
				$this->error = 'invalid_payment_request ' . $hash .' ' . $this->registry->GPC['hash'] . ' ' . $data_implode;
			}
			return $this->status;
	}

	/**
	* Generate the form fields when we need.
	*/
	function fetch_userinput($input, $checkinput = false)
	{
			return false;
	}

	/**
	* Generate the hidden fields when we need.
	*/
	function generate_hiddenfields(&$input)
	{
			$this->hidden .= '
					<input type="hidden" name="payment[name]" value="' . get_class($this) . '" />
			';
			return $this->hidden;
	}
	/**
	* Install the modul.
	*/
	function install()
	{
			$this->db->query_write("
					INSERT INTO " . TABLE_PREFIX . "vbcmspayments
					(id, name, field, currency, active, classname, countrys, defaultcheck)
					VALUES
					(
					'',
					'" . $this->db->escape_string(get_class($this)) . "',
					'" . $this->db->escape_string('a:3:{s:7:"user_id";s:0:"";s:10:"project_id";s:0:"";s:6:"secret";s:0:"";}') . "',
					'" . $this->db->escape_string('EUR') . "',
					1,
					'" . $this->db->escape_string(get_class($this)) . "',
					'" . $this->db->escape_string($this->allowed_countrys) . "',
					0
					)
			");
	}

	/**
	* Uninstall the modul.
	*/
	function uninstall()
	{
			$this->db->query_write("
					DELETE FROM " . TABLE_PREFIX . "vbcmspayments WHERE classname = '" . get_class($this) . "'
			");
	}
  	/**
	* Handle the additional fields from the module
	*
	* @param   string with the serialized array from the database
	*
	*/
	function handle_additional($val)
	{
		return false;
	}
	
  	/**
	* Handle the additional fields from the module
	*
	* @param   string with the serialized array from the database
	*
	*/
	function fetch_hash($field_array, $info, $paymentinfo)
	{
		$data = array(
			$field_array['user_id'], // user_id
			$field_array['project_id'], // project_id
			'', // sender_holder
			'', // sender_account_number
			'', // sender_bank_code
			$info['customerinfos']['scountry'], // sender_country_id
			$info['end_cost_num'], // amount
			$paymentinfo['currency'], // currency_id, Pflichtparameter bei Hash-Berechnung
			$info['ordernumber'],// reason_1
			'', // reason_2
			'', // user_variable_0
			'', // user_variable_1
			'', // user_variable_2
			'', // user_variable_3
			'', // user_variable_4
			'', // user_variable_5
			$field_array['secret'] // project_password
		); 
		$data_implode = implode('|', $data);
		$hash = sha1($data_implode);	
		return $hash;
	}	
	
	
	/**
	* Checkout formfield
	*
	* @param	array with needed infos
	*/   
	function checkout_formfield($info)
	{
		global $vbphrase, $vbcms_global;
		
		// Development
		// $this->formurl = 'https://www.sandbox.paypal.com/cgi-bin/webscr';
		
		$paymentinfo = $this->db->query_first_slave("SELECT currency, field FROM " . TABLE_PREFIX . "vbcmspayments WHERE classname = '" . get_class($this) . "'");
		$field_array = unserialize($paymentinfo['field']);

		return '
			<script type="text/javascript">
			myvar = "";
			timeout = 0;
			function dorefresh()
			{
				document.w_form.submit();
			}
			</script>
			<form name="w_form" action="' . $this->formurl . '" method="post">
			<input type="hidden" name="user_id" value="' . $field_array['user_id'] . '" />
			<input type="hidden" name="project_id" value="' . $field_array['project_id'] . '" />
			<input type="hidden" name="amount" value="' . $info['end_cost_num'] . '" />
			<input type="hidden" name="reason_1" value="' . $info['ordernumber'] . '" />
			<input type="hidden" name="currency_id" value="' . $paymentinfo['currency'] . '" />	
			<input type="hidden" name="sender_country_id" value="' . $info['customerinfos']['scountry'] . '" />	
			<input type="hidden" name="hash" value="' . $this->fetch_hash($field_array, $info, $paymentinfo) . '" />
			<div style="text-align:center;"><input  type="submit" value="' . $vbphrase['vbcms_payment_' . get_class($this) . '_button_pay'] . '" /></div><br />	

			' . $vbphrase['vbcms_payment_' . get_class($this) . '_thankyou_message'] . '<br/>

			<br/><div style="text-align:center;"><input type="submit" value="' . $vbphrase['vbcms_payment_' . get_class($this) . '_button_pay'] . '" /></div>
			</form>
			<script type="text/javascript">
			dorefresh();
			</script>			
		';
	}		
}

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # SVN: $RCSfile$ - $Revision: 1628 $
|| ####################################################################
\*======================================================================*/
?>