<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBCMS Version 2.6.8
|| # ------------------------------------------------------------------ # ||
|| # Copyright  2002 - 2009 Reuter & Bloe GbR.                          ||
|| # ------------------- VBCMS IS NOT FREE SOFTWARE ------------------- # ||
|| # http://www.vbdesigns.de | http://www.vbdesigns.de/license.html     # ||
|| ###################################################################### ||
\*========================================================================*/
if(!class_exists('vBCMS_fetch_components'))
{
        exit;
}

/**
* Class to do data handle payment operations for vBCMS products
*
* @package	vBCMS 2.6.8
* @version	$Revision: 1517 $
* @date		$Date: 2009-04-29 10:06:27 +0200 (Mi, 29. Apr 2009) $
*/
class creditcard extends vbcms_payments
{
        /**
    	* For the description of the objects see /includes/class_vbcms_payments.php
    	*
    	* @var	mixed
    	*/
        var $name = 'Creditcard';
        var $host = '';
        var $formurl = '';

        var $allowed_cards = array();

        /**
        * Constructor - checks that the registry object has been passed correctly.
        *
        * @param	(ref)  vB_Registry	Instance of the vBulletin data registry object.
        */
        function creditcard(&$registry, $additional = '')
        {
	            // Set registry and db object
                parent::vbcms_payments($registry);

                if($additional)
                {
                	$this->handle_additional($additional);
                }
        }

        /**
        * Verify the payment.
        *
        * @param    int     the paymentid
        *
        */
        function check_payment($paymentid)
        {
                return true;
        }

        /**
        * Generate the form fields and check the input when we need.
        *
        * @param   sring  form field
        * @param   bool   validate the user input
        *
        * @return  string with the form field
        */
        function fetch_userinput($input, $checkinput = false)
        {
                global $vbphrase;

                $startdate = explode(',', vbdate('j,n,Y', strtotime('-1 month'), false, false));
				$startdate['day'] = $startdate[0];
				$startdate['year'] = $startdate[2];

				$enddate = explode(',', vbdate('j,n,Y', TIMENOW, false, false));
				$enddate['day'] = $enddate[0];
		        $enddate['year'] = $enddate[2];

		        $sel[1] = 'selected="selected"';

		        while($i++ <= 12)
		        {
		        	$sele["$i"] = ($i == $enddate[1] ? ' selected="selected"' : '');
		        }

                if ($checkinput)
                {
					if (is_array($input['forms'][get_class($this)]))
					{
						$startdate = $enddate = array();
						foreach($input['forms'][get_class($this)] AS $key => $val)
						{
							if (!$val)
							{
									$this->error('vbcms_payment_' . get_class($this). '_errors_no_' . $key);
							}
							else
							{
								if ($key === 'day_start' OR $key === 'year_start' OR $key === 'month_start')
								{
									$startdate[$key] = $val;
								}
								else if ($key === 'day_end' OR $key === 'year_end' OR $key === 'month_end')
								{
									$enddate[$key] = $val;
								}
								else
								{
									$classname = 'verify_' . $key;
									$this->$classname($val);
								}
							}
						}
						$this->verify_date($startdate, $enddate);
					}
					else
					{
						$this->error('vbcms_payment_' . get_class($this). '_errors_no_input');
					}
					$sel[intval($input['forms'][get_class($this)]['month_start'])] = 'selected="selected"';
					$sele[intval($input['forms'][get_class($this)]['month_end'])] = 'selected="selected"';

					$startdate['day']  = intval($input['forms'][get_class($this)]['day_start']);
					$startdate['year'] = intval($input['forms'][get_class($this)]['year_start']);
					$enddate['day']    = intval($input['forms'][get_class($this)]['day_end']);
					$enddate['year']   = intval($input['forms'][get_class($this)]['year_end']);
                }

                $dates = '
                	<script type="text/javascript" src="' . (($this->registry->vbcmsoptions['vbcms_forumfolder']) ? $this->registry->vbcmsoptions['vbcms_forumfolder'] . '/' : '') . 'clientscript/vbulletin_date_picker.js"></script>
                	<br />
                	<div class="orderinfo">
					<div class="orderinfo_desc">' . $vbphrase['start_date'] . '</div>

                	<select name="payment[forms][' . get_class($this) . '][month_start]" tabindex="1" id="startdate_month">
                	<option value="1" ' . $sel[1] . ' >' . $vbphrase['january'] . '</option>
                	<option value="2" ' . $sel[2] . '>' . $vbphrase['february'] . '</option>
                	<option value="3" ' . $sel[3] . '>' . $vbphrase['march'] . '</option>
                	<option value="4" ' . $sel[4] . '>' . $vbphrase['april'] . '</option>
                	<option value="5" ' . $sel[5] . '>' . $vbphrase['may'] . '</option>
                	<option value="6" ' . $sel[6] . '>' . $vbphrase['june'] . '</option>
                	<option value="7" ' . $sel[7] . '>' . $vbphrase['july'] . '</option>
                	<option value="8" ' . $sel[8] . '>' . $vbphrase['august'] . '</option>
                	<option value="9" ' . $sel[9] . '>' . $vbphrase['september'] . '</option>
                	<option value="10" ' . $sel[10] . '>' . $vbphrase['october'] . '</option>
                	<option value="11" ' . $sel[11] . '>' . $vbphrase['november'] . '</option>
                	<option value="12" ' . $sel[12] . '>' . $vbphrase['december'] . '</option>
                	</select>
                	<input type="text" name="payment[forms][' . get_class($this) . '][day_start]" size="2" maxlength="2" class="bginput smallfont" value="' . $startdate['day'] . '" tabindex="1" id="startdate_date" />
                	<input type="text" name="payment[forms][' . get_class($this) . '][year_start]" size="4" maxlength="4" class="bginput smallfont" value="' . $startdate['year'] . '" tabindex="1" id="startdate_year" />

                	<div class="orderinfo">
					<div class="orderinfo_desc">' . $vbphrase['end_date'] . '</div>
                	<select name="payment[forms][' . get_class($this) . '][month_end]" tabindex="1" id="enddate_month">
                	<option value="1" ' . $sele[1] . '>' . $vbphrase['january'] . '</option>
                	<option value="2" ' . $sele[2] . '>' . $vbphrase['february'] . '</option>
                	<option value="3" ' . $sele[3] . '>' . $vbphrase['march'] . '</option>
                	<option value="4" ' . $sele[4] . '>' . $vbphrase['april'] . '</option>
                	<option value="5" ' . $sele[5] . '>' . $vbphrase['may'] . '</option>
                	<option value="6" ' . $sele[6] . '>' . $vbphrase['june'] . '</option>
                	<option value="7" ' . $sele[7] . '>' . $vbphrase['july'] . '</option>
                	<option value="8" ' . $sele[8] . '>' . $vbphrase['august'] . '</option>
                	<option value="9" ' . $sele[9] . '>' . $vbphrase['september'] . '</option>
                	<option value="10" ' . $sele[10] . '>' . $vbphrase['october'] . '</option>
                	<option value="11" ' . $sele[11] . '>' . $vbphrase['november'] . '</option>
                	<option value="12" ' . $sele[12] . '>' . $vbphrase['december'] . '</option>
                	</select>
                	<input type="text" name="payment[forms][' . get_class($this) . '][day_end]" size="2" maxlength="2" class="bginput smallfont" value="' . $enddate['day'] . '" tabindex="1" id="enddate_date" />
                	<input type="text" name="payment[forms][' . get_class($this) . '][year_end]" size="4" maxlength="4" class="bginput smallfont" value="' . $enddate['year'] . '" tabindex="1" id="enddate_year" />
			        </div>
                	<script type="text/javascript">
                	<!--
                	vBulletin.register_control("vB_DatePicker", "startdate_year", "startdate_", "' . $this->registry->userinfo['startofweek'] . '");
                	vBulletin.register_control("vB_DatePicker", "enddate_year", "enddate_", "' . $this->registry->userinfo['startofweek'] . '");
                	//-->
                	</script><br />
                ';

                return '<br />
                <div class="orderinfo">
				     <div class="orderinfo_desc">' . $vbphrase['vbcms_payment_creditcard_name'] . ':</div>
				     <input type="text" name="payment[forms][' . get_class($this) . '][name]" value="' . htmlspecialchars_uni($input['forms'][get_class($this)]['name']) . '" />
                </div>

                <div class="orderinfo">
				     <div class="orderinfo_desc">' . $vbphrase['vbcms_payment_creditcard_cardnumber'] . ':</div>
                     <input type="text" name="payment[forms][' . get_class($this) . '][number]" value="' . (($input['forms'][get_class($this)]['number']) ? htmlspecialchars_uni($input['forms'][get_class($this)]['number']) : '' ) . '" />
                </div>

                <div class="orderinfo">
				       <div class="orderinfo_desc">' . $vbphrase['vbcms_payment_creditcard_cvv'] . ':</div>
				       <input type="text" size="4" maxlength="4" name="payment[forms][' . get_class($this) . '][cvv]" value="' . (($input['forms'][get_class($this)]['cvv']) ? intval($input['forms'][get_class($this)]['cvv']) : '' ) . '" />
                </div>
                <div class="orderinfo">
				       <div class="orderinfo_desc">' . $vbphrase['vbcms_payment_creditcard_issue'] . ':</div>
				       <input type="text" size="2" maxlength="2" name="payment[forms][' . get_class($this) . '][issue]" value="' . (($input['forms'][get_class($this)]['issue']) ? intval($input['forms'][get_class($this)]['issue']) : '' ) . '" />
                </div>
                ' . $dates . '
                ';
        }

        /**
        * Generate the hidden fields when we need.
        * @param   sring  form input
        *
        * @return  string with the hidden forms
        */
        function generate_hiddenfields(&$input)
        {
                $this->hidden .= '
                	<input type="hidden" name="payment[forms][' . get_class($this) . '][month_start]" value="' . intval($input['forms'][get_class($this)]['month_start']) . '" />
					<input type="hidden" name="payment[forms][' . get_class($this) . '][day_start]" value="' . intval($input['forms'][get_class($this)]['day_start']) . '" />
					<input type="hidden" name="payment[forms][' . get_class($this) . '][year_start]" value="' . intval($input['forms'][get_class($this)]['year_start']) . '" />
					<input type="hidden" name="payment[forms][' . get_class($this) . '][month_end]" value="' . intval($input['forms'][get_class($this)]['month_end']) . '" />
					<input type="hidden" name="payment[forms][' . get_class($this) . '][day_end]" value="' . intval($input['forms'][get_class($this)]['day_end']) . '" />
					<input type="hidden" name="payment[forms][' . get_class($this) . '][year_end]" value="' . intval($input['forms'][get_class($this)]['year_end']) . '" />
					<input type="hidden" name="payment[forms][' . get_class($this) . '][name]" value="' . htmlspecialchars_uni($input['forms'][get_class($this)]['name']) . '" />
					<input type="hidden" name="payment[forms][' . get_class($this) . '][number]" value="' .  htmlspecialchars_uni($input['forms'][get_class($this)]['number']) . '" />
					<input type="hidden" name="payment[forms][' . get_class($this) . '][cvv]" value="' . intval($input['forms'][get_class($this)]['cvv']) . '" />
					<input type="hidden" name="payment[forms][' . get_class($this) . '][issue]" value="' . intval($input['forms'][get_class($this)]['issue']) . '" />
					<input type="hidden" name="payment[name]" value="' . get_class($this) . '" />
                ';
                return $this->hidden;
        }

        /**
        * Install the modul.
        */
        function install()
        {
                $this->db->query_write("
                        INSERT INTO " . TABLE_PREFIX . "vbcmspayments
                        (id, name, field, currency, active, classname, countrys, defaultcheck)
                        VALUES
                        (
                        '',
                        '" . $this->db->escape_string(get_class($this)) . "',
                        '" . $this->db->escape_string('a:1:{s:12:"allowedcards";s:17:"MA,AE,VI,DC,JC,DI";}') . "',
                        '" . $this->db->escape_string('EUR') . "',
                        1,
                        '" . $this->db->escape_string(get_class($this)) . "',
                        '" . $this->db->escape_string($this->allowed_countrys) . "',
                        0
                        )
                ");
        }

        /**
        * Uninstall the modul.
        */
        function uninstall()
        {
                $this->db->query_write("
                        DELETE FROM " . TABLE_PREFIX . "vbcmspayments WHERE classname = '" . get_class($this) . "'
                ");
        }
        
 	/**
	* Fetch the paymentinfo from the orders
	*
	* @param   string with the serialized array from the database
	*
	*/
	function fetch_paymentinfo($val)
	{
		global $vbphrase;
		$val = unserialize($val);
		return '<table>
			<tr>
				<td>
					' . $vbphrase['vbcms_payment_creditcard_name'] . ':
				</td>
				<td>
					' . $val['name'] . '
				</td>
			</tr>
				<tr>
				<td>		
					' . $vbphrase['vbcms_payment_creditcard_cardnumber'] . ' :
				</td>
				<td>		
					' . $val['number'] . '
				</td>
			</tr>
			<tr>
				<td>		
					' . $vbphrase['vbcms_payment_creditcard_cvv'] . ': 
				</td>
				<td>		
					' . $val['cvv'] . '
				</td>
			</tr>
			<tr>
				<td>		
					' . $vbphrase['vbcms_payment_creditcard_issue'] . ':  
				</td>
				<td>				
					' . $val['issue'] . '
				</td>
			</tr>
			<tr>
				<td>		
					' . $vbphrase['start_date'] . ': 
				</td>
				<td>		
					' . vbdate($this->registry->options['dateformat'], mktime(0, 0, 0, $val['month_start'], $val['day_start'], $val['year_start'])) . '
				</td>
			</tr>
			<tr>
				<td>			
					' . $vbphrase['end_date'] . ': 
				</td>
				<td>		
					' . vbdate($this->registry->options['dateformat'], mktime(0, 0, 0, $val['month_end'], $val['day_end'], $val['year_end'])) . '
				</td>
			</tr>
		</table>
		';
	}
	
 	/**
	* Handle the additional fields from the module
	*
	* @param   string with the serialized array from the database
	*
	*/
	function handle_additional($val)
	{
		$val = unserialize($val);
		$this->allowed_cards = explode(',', str_replace(' ', '', trim($val['allowedcards'])));
	}

	/**
	*
	*
	*
	*/
	function verify_date($start, $end)
	{
		$year_now = date('Y');
		$month_now = date('n');
		
		if ($end['year_end'] < $year_now)
		{
			$this->error('vbcms_payment_' . get_class($this). '_errors_not_valid_carddate');
			return false;			
		}
		else if ($end['year_end'] == $year_now AND $end['month_end'] < $month_now)
		{
			$this->error('vbcms_payment_' . get_class($this). '_errors_not_valid_carddate');
			return false;			
		}
		else
		{
			return true;	
		}
	}

	/**
	*
	*
	*
	*/
	function verify_name($val)
	{
		return true;
	}

	/**
	*
	*
	*
	*/
	function verify_number($val)
	{
		$val = preg_replace('/\s+/', '', trim($val));

		if($val === '')
		{
			$this->error('vbcms_payment_' . get_class($this). '_errors_not_valid_creditcard');
			return false;
		}

		if(preg_match('/^5[1-5][0-9]{14}$/', $val) AND in_array('MA', $this->allowed_cards))
		{
			return true;
		}
		else if (preg_match('/^3[47][0-9]{13}$/', $val) AND in_array('AE', $this->allowed_cards))
		{
			return true;
		}
		else if (preg_match('/^4[0-9]{12}([0-9]{3})?$/', $val) AND in_array('VI', $this->allowed_cards))
		{
			return true;
		}
		else if (preg_match('/^3(0[0-5]|[68][0-9])[0-9]{11}$/', $val) AND in_array('DC', $this->allowed_cards))
		{
			return true;
		}
		else if (preg_match('/^(3[0-9]{4}|2131|1800)[0-9]{11}/', $val) AND in_array('JC', $this->allowed_cards))
		{
			return true;
		}
		else if (preg_match('/^6011[0-9]{12}$/', $val) AND in_array('DI', $this->allowed_cards))
		{
			return true;
		}
		else
		{
            $this->error('vbcms_payment_' . get_class($this). '_errors_not_valid_creditcard');
			return false;
		}
	}

	/**
	*
	*
	*
	*/
	function verify_cvv($val)
	{
		$val = intval(preg_replace('/\s+/', '', trim($val)));
		// TO DO
		if($val === 0)
		{
			$this->error('vbcms_payment_' . get_class($this). '_errors_not_valid_cvv');
			return false;
		}
	}

	/**
	*
	*
	*
	*/
	function verify_issue($val)
	{
		$val = intval(preg_replace('/\s+/', '', trim($val)));
		// TO DO
		if($val === 0)
		{
			$this->error('vbcms_payment_' . get_class($this). '_errors_not_valid_issue');
			return false;
		}
	}

}

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # SVN: $RCSfile$ - $Revision: 1517 $
|| ####################################################################
\*======================================================================*/
?>