<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBCMS Version 2.6.8
|| # ------------------------------------------------------------------ # ||
|| # Copyright  2002 - 2009 Reuter & Bloe GbR.                          ||
|| # ------------------- VBCMS IS NOT FREE SOFTWARE ------------------- # ||
|| # http://www.vbdesigns.de | http://www.vbdesigns.de/license.html     # ||
|| ###################################################################### ||
\*========================================================================*/
if(!class_exists('vBCMS_fetch_components'))
{
        exit;
}

/**
* Class to do data handle payment operations for vBCMS products
*
* @package	vBCMS 2.6.8
* @version	$Revision: 1517 $
* @date		$Date: 2009-04-29 10:06:27 +0200 (Mi, 29. Apr 2009) $
*/
class banktransfer extends vbcms_payments
{
        /**
    	* For the description of the objects see /includes/class_vbcms_payments.php
    	*
    	* @var	mixed
    	*/
        var $name = 'Lastschrift (Debit note)';
        var $host = '';
        var $formurl = '';
        var $allowed_countrys = 'DE';

        /**
        * Constructor - checks that the registry object has been passed correctly.
        *
        * @param	(ref)  vB_Registry	Instance of the vBulletin data registry object.
        */
        function banktransfer(&$registry, $additional = '' )
        {
	            // Set registry and db object
                parent::vbcms_payments($registry);
                
                if($additional)
                {
                	$this->handle_additional($additional);
                }                           
        }

        /**
        * Verify the payment.
        *
        * @param    int     the paymentid
        * @param    string
        *
        */
        function check_payment($paymentid)
        {
                return true;
        }

        /**
        * Generate the and check form fields when we need.
        */
        function fetch_userinput($input, $checkinput = false)
        {
                global $vbphrase;
		        
		        $sel[1] = 'selected="selected"';
		        
                for ($i = 1; $i <= 12; $i++)
                {
                        $sele["$i"] = ($i == $enddate[1] ? ' selected="selected"' : '');
                }		        

                if ($checkinput)
                {
					if (is_array($input['forms'][get_class($this)]))
					{
						$startdate = $enddate = array();
						foreach($input['forms'][get_class($this)] AS $key => $val)
						{
							if (!$val)
							{
							    if (!in_array($key, array('bankiban', 'bankbic')))
							    {
									$this->error('vbcms_payment_' . get_class($this). '_errors_no_' . $key);
								}

							}
						}
					}
					else
					{
						$this->error('vbcms_payment_' . get_class($this). '_errors_no_input');
					}
                }

                return '<br />
                <div class="orderinfo">
				     <div class="orderinfo_desc">' . $vbphrase['vbcms_payment_banktransfer_bankname'] .  '</div>
				     <input type="text" name="payment[forms][' . get_class($this) . '][bankname]" value="' . htmlspecialchars_uni($input['forms'][get_class($this)]['bankname']) . '" />            
                </div>
                
                <div class="orderinfo">
				     <div class="orderinfo_desc">' . $vbphrase['vbcms_payment_banktransfer_bankuser'] .  '</div>
                     <input type="text" name="payment[forms][' . get_class($this) . '][bankuser]" value="' . htmlspecialchars_uni($input['forms'][get_class($this)]['bankuser']) . '" />
                </div>
                <div class="orderinfo">
 				     <div class="orderinfo_desc">' . $vbphrase['vbcms_payment_banktransfer_banknumber'] .  '</div>
                     <input type="text" name="payment[forms][' . get_class($this) . '][banknumber]" value="' . htmlspecialchars_uni($input['forms'][get_class($this)]['banknumber']) . '" />
                </div>
                <div class="orderinfo">
 				     <div class="orderinfo_desc">' . $vbphrase['vbcms_payment_banktransfer_bankaccount'] .  '</div>
                     <input type="text" name="payment[forms][' . get_class($this) . '][bankaccount]" value="' . htmlspecialchars_uni($input['forms'][get_class($this)]['bankaccount']) . '" />
                </div>  
                <div class="orderinfo">
 				     <div class="orderinfo_desc">' . $vbphrase['vbcms_payment_banktransfer_bankiban'] .  '</div>
                     <input type="text" name="payment[forms][' . get_class($this) . '][bankiban]" value="' . htmlspecialchars_uni($input['forms'][get_class($this)]['bankiban']) . '" />
                </div>
                <div class="orderinfo">
 				     <div class="orderinfo_desc">' . $vbphrase['vbcms_payment_banktransfer_bankbic'] .  '</div>
                     <input type="text" name="payment[forms][' . get_class($this) . '][bankbic]" value="' . htmlspecialchars_uni($input['forms'][get_class($this)]['bankbic']) . '" />
                </div>
                ';

        }

        /**
        * Generate the hidden fields when we need.
        */
        function generate_hiddenfields(&$input)
        {
                $this->hidden .= '
                        <input type="hidden" name="payment[name]" value="' . get_class($this) . '" />
                        <input type="hidden" name="payment[forms][' . get_class($this) . '][bankname]" value="' . htmlspecialchars_uni($input['forms'][get_class($this)]['bankname']) . '" />            
                        <input type="hidden" name="payment[forms][' . get_class($this) . '][bankuser]" value="' . htmlspecialchars_uni($input['forms'][get_class($this)]['bankuser']) . '" />
                        <input type="hidden" name="payment[forms][' . get_class($this) . '][banknumber]" value="' . htmlspecialchars_uni($input['forms'][get_class($this)]['banknumber']) . '" />
                        <input type="hidden" name="payment[forms][' . get_class($this) . '][bankaccount]" value="' . htmlspecialchars_uni($input['forms'][get_class($this)]['bankaccount']) . '" />
                        <input type="hidden" name="payment[forms][' . get_class($this) . '][bankiban]" value="' . htmlspecialchars_uni($input['forms'][get_class($this)]['bankiban']) . '" />
                        <input type="hidden" name="payment[forms][' . get_class($this) . '][bankbic]" value="' . htmlspecialchars_uni($input['forms'][get_class($this)]['bankbic']) . '" />
                ';
                return $this->hidden;
        }

        /**
        * Install the modul.
        */
        function install()
        {
                $this->db->query_write("
                        INSERT INTO " . TABLE_PREFIX . "vbcmspayments
                        (id, name, field, currency, active, classname, countrys, defaultcheck)
                        VALUES
                        (
                        '',
                        '" . $this->db->escape_string(get_class($this)) . "',
                        '" . $this->db->escape_string('') . "',
                        '" . $this->db->escape_string('EUR') . "',
                        1,
                        '" . $this->db->escape_string(get_class($this)) . "',
                        '" . $this->db->escape_string($this->allowed_countrys) . "',
                        0
                        )
                ");
        }

        /**
        * Uninstall the modul.
        */
        function uninstall()
        {
                $this->db->query_write("
                        DELETE FROM " . TABLE_PREFIX . "vbcmspayments WHERE classname=  '" . get_class($this) . "'
                ");
        }
 	/**
	* Fetch the paymentinfo from the orders
	*
	* @param   string with the serialized array from the database
	*
	*/
	function fetch_paymentinfo($val)
	{
		global $vbphrase;
		$val = unserialize($val);
		return '<table>
			<tr>
				<td>
					' . $vbphrase['vbcms_payment_banktransfer_bankname'] . '
				</td>
				<td>
					' . $val['bankname'] . '
				</td>
			</tr>
				<tr>
				<td>		
					' . $vbphrase['vbcms_payment_banktransfer_bankuser'] . '
				</td>
				<td>		
					' . $val['bankuser'] . '
				</td>
			</tr>
			<tr>
				<td>		
					' . $vbphrase['vbcms_payment_banktransfer_banknumber'] . '
				</td>
				<td>		
					' . $val['banknumber'] . '
				</td>
			</tr>
			<tr>
				<td>		
					' . $vbphrase['vbcms_payment_banktransfer_bankaccount'] . '
				</td>
				<td>				
					' . $val['bankaccount'] . '
				</td>
			</tr>
			<tr>
				<td>		
					' . $vbphrase['vbcms_payment_banktransfer_bankiban'] . '
				</td>
				<td>
					' . $val['bankiban'] . '
				</td>
			</tr>
			<tr>
				<td>			
					' . $vbphrase['vbcms_payment_banktransfer_bankbic'] . '
				</td>
				<td>
					' . $val['bankbic'] . '
				</td>
			</tr>
		</table>
		';
	}        
  	/**
	* Handle the additional fields from the module
	*
	* @param   string with the serialized array from the database
	*
	*/
	function handle_additional($val)
	{
		return false;
	}          
}

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # SVN: $RCSfile$ - $Revision: 1517 $
|| ####################################################################
\*======================================================================*/
?>