<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBCMS Version 2.6.8
|| # ------------------------------------------------------------------ # ||
|| # Copyright  2002 - 2009 Reuter & Bloe GbR.                          ||
|| # ------------------- VBCMS IS NOT FREE SOFTWARE ------------------- # ||
|| # http://www.vbdesigns.de | http://www.vbdesigns.de/license.html     # ||
|| # ------------------------------------------------------------------ # ||
|| # Warning: Change the file only if you know what you do!             # ||
|| # Warnung: ndern Sie die Datei nur, wenn Sie wissen was Sie tun!    # ||
|| ###################################################################### ||
\*========================================================================*/

function vbcms_prod_process_step_li($step)
{
	global $vbphrase;
	switch($step)
	{
		case 'step2':
		{
			$li = '<li class="step" title="' . $vbphrase['vbcms_prod_checkout_step1'] . '"><span>' . $vbphrase['vbcms_prod_checkout_step1'] . '</span></li><li class="step" title="' . $vbphrase['vbcms_prod_checkout_step2'] . '"><span>' . $vbphrase['vbcms_prod_checkout_step2'] . '</span></li>';
		}
		break;
		case 'step3':
		{
			$li = '<li class="step" title="' . $vbphrase['vbcms_prod_checkout_step1'] . '"><span>' . $vbphrase['vbcms_prod_checkout_step1'] . '</span></li><li class="step" title="' . $vbphrase['vbcms_prod_checkout_step2'] . '"><span>' . $vbphrase['vbcms_prod_checkout_step2'] . '</span></li><li class="step" title="' . $vbphrase['vbcms_prod_checkout_step3'] . '"><span>' . $vbphrase['vbcms_prod_checkout_step3'] . '</span></li>';		
		}
		break;
		case 'step4':
		{
			$li = '<li class="step" title="' . $vbphrase['vbcms_prod_checkout_step1'] . '"><span>' . $vbphrase['vbcms_prod_checkout_step1'] . '</span></li><li class="step" title="' . $vbphrase['vbcms_prod_checkout_step2'] . '"><span>' . $vbphrase['vbcms_prod_checkout_step2'] . '</span></li><li class="step" title="' . $vbphrase['vbcms_prod_checkout_step3'] . '"><span>' . $vbphrase['vbcms_prod_checkout_step3'] . '</span></li><li class="step" title="' . $vbphrase['vbcms_prod_thankyou'] . '"><span>' . $vbphrase['vbcms_prod_thankyou'] . '</span></li>';		
		}
		break;
		default:
		{
			$li = '<li class="step" title="' . $vbphrase['vbcms_prod_checkout_step1'] . '"><span>' . $vbphrase['vbcms_prod_checkout_step1'] . '</span></li>';		
		}
		break;
	}
	return $li;
}

function vbcms_prod_fetch_pdfcalculation_query(&$obj, $ismod = false, $orderid)
{
	global $vbcms_global, $orders_row, $content, $vbphrase;
	
	if ($ismod === true)
	{
		$where = '';
	}
	else
	{
		$where = "AND vbcmsprodsorder.userid = " . $obj->registry->userinfo['userid'] . " ";
	}
	
	$orders_row = $obj->db->query_first("
		SELECT vbcmsprodsorder.*, vbcmsprodsorder.id AS pid, vbcmsproduser.*,
		user.username, user.email
		FROM " . TABLE_PREFIX . "vbcmsprodsorder AS vbcmsprodsorder
		LEFT JOIN " . TABLE_PREFIX . "vbcmsproduser AS vbcmsproduser USING(userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user USING(userid)
			WHERE vbcmsprodsorder.id = " . $orderid . " $where
	");  
	
	if (!$orders_row['pid'])
	{
		print_no_permission();
	}
	$orders_row['ucountry'] = $orders_row['scountry'];
	
	$countrys =& vbcms_fetch_prodcountrys();
	$orders_row['scountry'] = $countrys['all'][$orders_row['scountry']];
	$orders_row['fcountry'] = $countrys['all'][$orders_row['fcountry']];
	$orders_row['rdate'] = vbdate($obj->registry->options['dateformat'], $orders_row['rememberdate'], true);
	$orders_row['rtime'] = vbdate($obj->registry->options['timeformat'], $orders_row['rememberdate']);		
	$orders_row['date'] = vbdate($obj->registry->options['dateformat'], $orders_row['datestamp'], true);
	$orders_row['time'] = vbdate($obj->registry->options['timeformat'], $orders_row['datestamp']);  
	
	$orders_row['fpayment']  = $vbphrase['vbcms_payment_' . $orders_row['payment'] . '_title'];
	$orders_row['fshipping'] = $vbphrase['vbcms_shipping_' . $orders_row['shipping'] . '_title'];
	
	
	$orderdetail = $obj->db->query_read_slave("
		SELECT 
		vbcmsprodsordered.*,
		vbcmsprods.catid, vbcmsprods.number, vbcmsprods.additional AS prod_additional, vbcmsprods.files,
		vbcmsprods.dlacc, vbcmsprods.dlupdate, vbcmsprods.dlupdateprice, vbcmsprods.tax, vbcmsprods.cost,
		vbcmsprods.sptimestart, vbcmsprods.sptimeend, vbcmsprods.specialprice,
		vbcmsprodslang.langtitle
		FROM " . TABLE_PREFIX . "vbcmsprodsordered AS vbcmsprodsordered
		LEFT JOIN " . TABLE_PREFIX . "vbcmsprods AS vbcmsprods ON (vbcmsprods.prodid = vbcmsprodsordered.prodid)
		LEFT JOIN " . TABLE_PREFIX . "vbcmsprodslang AS vbcmsprodslang ON (vbcmsprodslang.prodid = vbcmsprods.prodid AND vbcmsprodslang.langid = " . $vbcms_global['langid'] . ")
		WHERE vbcmsprodsordered.orderid = " . $orders_row['pid'] . " 
		ORDER by vbcmsprodsordered.id ASC
	");
	
	while($orderdetail_row = $obj->db->fetch_array($orderdetail))
	{
		$orderdetail_row['langtitle'] = (($orderdetail_row['deletetprod']) ? $orderdetail_row['deletetprod'] : $orderdetail_row['langtitle']);

		if(($orderdetail_row['sptimestart'] AND $orderdetail_row['sptimeend']) AND !(TIMENOW >= $orderdetail_row['sptimestart'] AND TIMENOW <= $orderdetail_row['sptimeend']))
		{
				$orderdetail_row['special_active'] = false;
		}else{
				$orderdetail_row['special_active'] = true;
		}
		if($orderdetail_row['specialprice'] > 0 AND $orderdetail_row['special_active'])
		{
				$orderdetail_row['cost'] = $orderdetail_row['specialprice'];
		}
		if($orderdetail_row['prodtype'] != 'update')
		{
			if ($orderdetail_row['additional'])
			{
				$orderdetail_row['additional'] = unserialize($orderdetail_row['additional']);

				if ($orderdetail_row['prod_additional'])
				{
					$orderdetail_row['prod_additional'] = unserialize($orderdetail_row['prod_additional']);
				}
				else
				{
					$orderdetail_row['prod_additional'] = true;
					$orderdetail_row['additional_rows'] = 'n/a';
				}
				
				foreach($orderdetail_row['additional'] AS $key => $val)
				{
					if ($orderdetail_row['prod_additional'] === true)
					{
						continue;
					}

					switch(substr(strstr($key, ':'), 1))
					{
						case 'select':
						case 'radio':
						{
							$orderdetail_row['additional_rows'][$key]['title'] = $orderdetail_row['prod_additional'][$key]['name'][$vbcms_global['langid']];
							$orderdetail_row['additional_rows'][$key]['desc'] .= $orderdetail_row['prod_additional'][$key]['desc'][$val][$vbcms_global['langid']] . ' ';
							$orderdetail_row['additional_rows'][$key]['price'] += $orderdetail_row['prod_additional'][$key]['price'][$val];							
						}
						break;
						case 'selectmore':
						case 'checkbox':
						{
							$orderdetail_row['additional_rows'][$key]['title'] = $orderdetail_row['prod_additional'][$key]['name'][$vbcms_global['langid']];
							foreach($val AS $val2)
							{
								$orderdetail_row['additional_rows'][$key]['desc'] .= $orderdetail_row['prod_additional'][$key]['desc'][$val2][$vbcms_global['langid']] . ' ';
								$orderdetail_row['additional_rows'][$key]['price'] += $orderdetail_row['prod_additional'][$key]['price'][$val2];
							} 
						}
						break;
					}			
				}
			}
		}
		else
		{
			$orderdetail_row['langtitle'] = 'Update: ' . $orderdetail_row['langtitle'];
			$orderdetail_row['files'] = '';
		}
		$content[] = $orderdetail_row;
	}
	$obj->db->free_result($orderdetail);
}


/**
* Fetch the costs, we use this code in many phpfiles
* It's also for the comming rabatts
*
* @ref	array     arraykey
*
*/
function vbcms_prod_fetch_displaycost(&$costarray)
{
	if ($costarray['tax'])
	{
	    $costarray['tax_original'] = $costarray['tax'];
		if($costarray['tax'] < 10)
		{
		    $costarray['tax'] = str_replace('.', '', $costarray['tax']);
			$costarray['tax'] = 0 . $costarray['tax'];
		}
		
		$costarray['cost_tax'] = $costarray['cost'] * "0.{$costarray['tax']}";
	}
	
	if(($costarray['sptimestart'] AND $costarray['sptimeend']) AND !(TIMENOW >= $costarray['sptimestart'] AND TIMENOW <= $costarray['sptimeend']))
	{
			$costarray['special_active'] = false;
	}else{
			$costarray['special_active'] = true;
	}

	if($costarray['specialprice'] > 0 AND $costarray['special_active'])
	{
			$costarray['special_isactive'] = true;
			$costarray['cost_tax_special'] = $costarray['specialprice'] * "0.{$costarray['tax']}";
			$costarray['special_cost'] = vb_number_format(round($costarray['specialprice'] + $costarray['cost_tax_special'], 2), 2);
	}
	$costarray['cost'] = vb_number_format(round($costarray['cost'] + $costarray['cost_tax'], 2), 2);
}

/**
* Fetch the catbits, we use this code in many phpfiles
*
* @ref	array     arraykey
*
*/
function vbcms_prod_fetch_catbit(&$prod_row, $i, &$reg)
{
	global $stylevar,$vbphrase;
	$prod_row['boxmargin'] = (!($i % 2)) ? 'margin-left:' . ($stylevar['cellpadding'] / 2) . 'px;' : 'margin-right:' . ($stylevar['cellpadding'] / 2) . 'px;';

	$prod_row['clearboth'] = (!($i % 2)) ? '' : '';		

	if ($prod_row['prodtype'] != 'download')
	{
			if ($prod_row['howcamp'] == 0)
			{
					$prod_row['dispoimg'] = '<img class="inlineimg" src="' . $stylevar['imgdir_misc'] . '/dispos_red.gif" alt="' . $vbphrase['vbcms_dispos_red'] . '" />';

			}
			else if($prod_row['howcamp'] <= 10)
			{

					$prod_row['dispoimg'] = '<img class="inlineimg" src="' . $stylevar['imgdir_misc'] . '/dispos_yellow.gif" alt="' . $vbphrase['vbcms_dispos_yellow'] . '" />';
			}
			else
			{
					$prod_row['dispoimg'] = '<img class="inlineimg" src="' . $stylevar['imgdir_misc'] . '/dispos_green.gif" alt="' . $vbphrase['vbcms_dispos_green'] . '" />';
			}
	}

	vbcms_prod_fetch_displaycost($prod_row);

	if (!empty($prod_row['images']))
	{
			foreach(explode('|', $prod_row['images']) AS $value)
			{
					$prod_row['image_src'] = $reg->vbcmsoptions['vbcms_forumfolder'] . $reg->vbcmsoptions['productsarea_savedir'] . '/thumbnail_images/' . $prod_row['prodid'] . 'thumb_' . $value;
					$prod_row['image_alt'] = $value;
					break;
			}
	}
	else
	{
			$prod_row['image_src'] = $stylevar['imgdir_misc'] . '/noprod.gif';
	}
	if(!function_exists('vbcms_clean_string'))
	{
			require_once(DIR . '/includes/vbcms_area_functions.php');
	}	
	$prod_row['seolangtitle'] = vbcms_clean_string(htmlspecialchars_uni($prod_row['langtitle']));
}

/**
* Rekursive Function for the products navigation
*
* @param	int     arraykey
* @param    int     depht
*
* @return   string  with formated <li> list
*
*/
function vbcms_fetch_prod_subcats($parentid = 0, $depth = 1)
{
        global $vbulletin, $permissions, $vbcms_global, $vbcmsoptions, $test;
        static $catcache;

        if($parentid == 0)
        {
                $catcache = array();
                foreach($vbulletin->vbcmsprodcats AS $catid => $cat)
                {
                        $catcache["$cat[sub]"]["$catid"] =& $vbulletin->vbcmsprodcats["$catid"];
                }
        }

        if(is_array($catcache["$parentid"]))
        {
                foreach($catcache["$parentid"] AS $key => $navibit)
                {
                        $catperms = $vbulletin->userinfo['vbcmsprodcatspermissions'][$navibit['catid']];

                        if(!($catperms & $vbulletin->bf_ugp_vbcmsprodcatspermissions['can_see_prodcats']) OR !($navibit['options'] & $vbulletin->bf_misc_VBCMSPRODUCTOPTIONS['active']))
		                {
			                    continue;
		                }

                        if($vbulletin->vbcmsoptions['productsarea_catseo'])
                        {
                                $seotitle = '&amp;name=' . vbcms_clean_string(htmlspecialchars_uni($navibit['langtitle']["$vbcms_global[langid]"]));
                        }

                        $navibit['img'] = (($navibit['catpicnav']) ? '<img style="vertical-align:middle; margin-right:3px;" src="' . $navibit['catpicnav'] . '" border="0" alt="" />' : '');

                        $navibit['title'] =& $navibit['langtitle']["$vbcms_global[langid]"];
                        
                        if (in_array($vbulletin->GPC['catid'], explode(',', $navibit['breads'])) AND $vbulletin->GPC['catid'] != $navibit['catid'])
                        {
                        	eval('$output .= "' . fetch_template('Portal_products_subcategorys') . '";');
                        }

                        if((!empty($vbulletin->GPC['catid']) AND in_array($vbulletin->GPC['catid'], explode(',', $navibit['parent']))) OR ($vbulletin->vbcmsoptions['vbcms_navprodmodullinks']))
                        {
                                $output .= vbcms_fetch_prod_subcats($navibit['catid'], $depth + 1);
                        }
                }
        }
        return $output;
}

/**
* Display the order card
*
* @param    ref    object
*
* @return   mixed
*/
function vbcms_fetch_card(&$obj)
{
	global $vbcms_global, $stylevar, $vbphrase, $vbcmsoptions, $session, $currency;

	require_once(DIR . '/includes/class_vbcmsproduct_card.php');
	$vbcmscard =& new vbcmscard($obj->registry, $vbcms_global);
	$vbcmscard->showbasketbit = false;
		
	$vbcmscard->fetch_card();
        
	$card =& $vbcmscard->cardinfo;

	if (!$card['counter'])
	{
		$card['display'] = 'display:none;';
	}
	eval('$vbcms_global[\'card\'] = "' . fetch_template('Portal_products_card') . '";');
}

/**
* Fetch the options infos from a catgory return array with infos or false
*
* @param	int     for the catid
* @param    bool    for usecache
*
* @return   mixed
*/
function vbcms_fetch_prod_options(&$catid, $chache = true)
{
        global $vbulletin;

        $catid = intval($catid);
        if (!$chache OR !isset($vbulletin->vbcmsprodcats["$catid"]))
        {
                $vbulletin->vbcmsprodcats["$catid"] = $vbulletin->db->query_first_slave("
                        SELECT
                        *
                        FROM " . TABLE_PREFIX . "vbcmsprodcats
                        WHERE catid = $catid
                ");
        }

        if(!$vbulletin->vbcmsprodcats["$catid"])
        {
                return false;
        }

        $vbulletin->vbcmsprodcats["$catid"]['options'] = intval($vbulletin->vbcmsprodcats["$catid"]['options']);

        foreach($vbulletin->bf_misc_VBCMSPRODUCTOPTIONS AS $optionname => $optionval)
        {
                $vbulletin->vbcmsprodcats["$catid"]["$optionname"] = (($vbulletin->vbcmsprodcats["$catid"]['options'] & $optionval) ? 1 : 0);
        }

        return $vbulletin->vbcmsprodcats["$catid"];
}

/**
* Rekursive Function for the products navigation
*
* @param	int     arraykey
* @param    int     depht
*
* @return   string  with formated <li> list
*
*/
function vbcms_fetch_prodcats_onhome($parentid = 0, $depth = '    ', $count = 0)
{
        global $vbulletin, $vbphrase, $vbcms_global;
        static $catcache, $first;

        if($parentid == 0)
        {
                $catcache = array();
                foreach($vbulletin->vbcmsprodcats AS $catid => $cat)
                {
                        $catcache["$cat[sub]"]["$catid"] =& $vbulletin->vbcmsprodcats["$catid"];
                }
        }

        if(is_array($catcache["$parentid"]))
        {
                usort($catcache["$parentid"], 'vbcms_sortarray');

                if(!$count)
                {
                      $bo = array(0 => '<b>', 1 => '</b>');
                }else{
                      $bo = array(0 => '<span class="smallfont">', 1 => '</span>');
                }

                if(!$count)
                {
                        $counter = 1;
                        foreach($catcache["$parentid"] AS $key => $d)
                        {
                                $catperms = $vbulletin->userinfo['vbcmsprodcatspermissions'][$d['catid']];

                                if($i == $breaker)
                                {
                                        $breaker = $i + $vbulletin->vbcmsoptions['productsarea_categorysstart_break'];
                                }
                                $i++;

                                $counter = ($i == $breaker AND !$count) ? $counter + 1 : $counter;
                        }
                        unset($breaker, $i, $catperms, $d);

                }

                foreach($catcache["$parentid"] AS $key => $d)
                {
                        if($i == $breaker)
                        {
                               $breaker = $i + $vbulletin->vbcmsoptions['productsarea_categorysstart_break'];
                        }
                        $i++;

                        if(!$first)
                        {
                               $output .= '<td class="list_product_cats" width="'. round((100 / $counter)) . '%">';
                               $first = true;
                        }

                        $catperms = $vbulletin->userinfo['vbcmsprodcatspermissions'][$d['catid']];

                        if(!($catperms & $vbulletin->bf_ugp_vbcmsprodcatspermissions['can_see_prodcats']) OR !($d['options'] & $vbulletin->bf_misc_VBCMSPRODUCTOPTIONS['active']))
		                {
			                    continue;
		                }
                        $GLOBALS['seecats'] = true;

                        $output .= "\r" . $depth . '<ul class="ul_products">'. "\r";
                        $output .= $depth . '<li class="li_products"><a name="cat' . $d['catid'] . '"></a> <a href="' . $vbulletin->vbcmsoptions['vbcms_url'] . $vbulletin->vbcmsoptions['vbcms_filename'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'area=' . $vbcms_global['area'] . '&amp;do=showcat&amp;catid=' . $d['catid'] . '" >' . $bo[0] . $d['langtitle']["$vbcms_global[langid]"] . $bo[1] . '</a>'. "\r" . $depth;

                        if(!$count AND $vbulletin->vbcmsoptions['productsarea_categorysstart_desc'])
                        {
                                $output .= $depth . '<br /><span class="smallfont">' . $d['langdesc']["$vbcms_global[langid]"] . '</span>';
                        }

                        if($count < $vbulletin->vbcmsoptions['productsarea_categorysstart_depth'])
                        {
                                $output .= vbcms_fetch_prodcats_onhome($d['catid'], "$depth    ", $count + 1);
                        }
                        $output .= "\r" . $depth . '</li>';
                        $output .= "\r" . $depth . '</ul>'. "\r";
                        $output .= ($i == $breaker AND !$count) ? '</td><td class="list_product_cats" width="'. round((100 / $counter)) . '%">' : '';
                }
        }
        return $output;
}

/**
* Recursive function to make output the categorys fo administration
*
* @param	int     for the parentid
* @param    string  for the depthmark
*
* @return   string  with contenttables
*/
function construct_adminprodcategorys($parentid = 0, $depth = false)
{
        global $vbulletin, $vbphrase, $catcache, $vbcms_global;

        if (!$vbulletin->ivbcmsprodcats["$parentid"])
        {
                return false;
        }

        foreach($vbulletin->ivbcmsprodcats["$parentid"] as $catid)
        {
                $d = $vbulletin->vbcmsprodcats["$catid"];

                if($depth)
                {


                }else{
                        $bo = array(0 => '<b>', 1 => '</b>');
                        $output .= '
                                <tr>
                                      <td class="thead" width="100%">
                                          ' . $vbphrase['vbcms_cat'] . '
                                      </td>
                                      <td class="thead" align="center">
                                     ' . $vbphrase['controls'] . '
                                      </td>
                                      <td class="thead" align="center">
                                     ' . $vbphrase['vbcms_admin_display_order'] . '
                                      </td>

                                </tr>
                        ';
                }
                $act = (!($d['options'] & $vbulletin->bf_misc_VBCMSPRODUCTOPTIONS['active'])) ? 'style="text-decoration:line-through;color: #FF0000; font-weight:bold;"' : '';
                $output .= '
                        <tr>
                              <td class="alt1">
                                    <a name="cat' . $d['catid'] . '"></a>' . $depth . $bo[0] .'<a ' . $act . ' href="' . $vbulletin->vbcmsoptions['vbcms_url'] . $vbulletin->vbcmsoptions['vbcms_filename'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'area=' . $vbcms_global['area'] . '&amp;do=manage&amp;show=editcat&amp;catid=' . $d['catid'] . '">' . $d['langtitle']["$vbcms_global[langid]"] . '</a>' . $bo[1] . '
                              </td>
                              <td class="alt2" align="center" nowrap="nowrap">
                                    <select name="catselect' . $d['catid'] . '" onchange="cat_jump(' . $d['catid'] . ');" >
                                            <option value="catedit">' . $vbphrase['vbcms_linksadmin_catedit'] . '</option>
                                            <option value="catview">' . $vbphrase['vbcms_linksadmin_catview'] . '</option>
                                            <option value="catdelete">' . $vbphrase['vbcms_linksadmin_catdelete'] . '</option>
                                            <option value="cataddsub">' . $vbphrase['vbcms_linksadmin_cataddsub'] . '</option>
                                            <option value="catperms">' . $vbphrase['view_permissions'] . '</option>
                                            <option value="productsadd">' . $vbphrase['vbcms_products_admin_addproduct'] . '</option>
                                    </select><input type="button" class="button" value="' . $vbphrase['go'] . '" onclick="cat_jump(' . $d['catid'] . ');" />
                              </td>
                              <td class="alt1" align="center">
                                    <input type="text" size="1" name="position_def[' . $d['catid'] . ']" value="' . $d['position'] . '" />
                              </td>

                        </tr>';
                $output .= construct_adminprodcategorys($catid, $depth . '- - ');
        }

        return $output;
}

/**
* Recursive function to make output the permissions
*
* @param	int     for the parentid
* @param    string  for the depthmark
*
* @return   string  with HTML formatted <ul> list
*/
function vbcms_list_prodcatpermissions($parentid = 0, $depth = '    ')
{
        global $vbulletin, $vbphrase, $vbcms_global, $catinfo;
        static $catcache;

        if($parentid == 0)
        {
                $catcache = array();
                foreach($vbulletin->vbcmsprodcats AS $catid => $cat)
                {
                        $catcache["$cat[sub]"]["$catid"] =& $vbulletin->vbcmsprodcats["$catid"];
                }
        }

        if(is_array($catcache["$parentid"]))
        {
                foreach($catcache["$parentid"] AS $key => $d)
                {
                        $output .= "\r" . $depth . '<ul>'. "\r";

                        $output .= $depth . '<li><a name="cat' . $d['catid'] . '"></a> <a href="' . $vbulletin->vbcmsoptions['vbcms_url'] . $vbulletin->vbcmsoptions['vbcms_filename'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'area=' . $vbcms_global['area'] . '&amp;do=manage&amp;show=editcat&amp;catid=' . $d['catid'] . '" ><b>' . $d['langtitle']["$vbcms_global[langid]"] . '</b></a> <span class="smallfont">( [<a href="' . $vbulletin->vbcmsoptions['vbcms_url'] . $vbulletin->vbcmsoptions['vbcms_filename'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'area=' . $vbcms_global['area'] . '&amp;do=manage&amp;show=permission_reset&amp;catid=' . $d['catid'] . '" >' . $vbphrase['reset'] . '</a>] )</span>'. "\r" . $depth . '<ul>';

                        foreach($vbulletin->usergroupcache AS $usergroupid => $usergroup)
                        {
                                if($vbulletin->vbcmsprodperms[$d['catid']][$usergroupid])
                                {
                                        $mark = array(0 => 'style="color:#FF0000;"');

                                        if($vbulletin->vbcmsprodperms[$d['catid']]['sub'])
                                        {
                                                $mark = array(0 => 'style="color:#E59700;"');
                                        }
                                }else{
                                        $mark = array();
                                }

                                $output .= "\r" . '<li ' . $mark[0] . '><span class="smallfont">[<a ' . $mark[0] . ' href="' . $vbulletin->vbcmsoptions['vbcms_url'] . $vbulletin->vbcmsoptions['vbcms_filename'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'area=' . $vbcms_global['area'] . '&amp;do=manage&amp;show=permissions_edit&amp;catid=' . $d['catid'] . '&amp;usergroupid=' . $usergroupid . '">' . $vbphrase['edit'] . '</a>] ' . $usergroup['title'] . '</span></li>';
                        }

                        $output .= "\r" . $depth . '</ul><br />';

                        $output .= vbcms_list_prodcatpermissions($key, "$depth    ");

                        $output .= "\r" . $depth . '</li>';
                        $output .= "\r" . $depth . '</ul>'. "\r";

                        if(!$d['sub'])
                        {
                                $output .= "\r" . $depth . '<hr size="1" />';
                        }
                }
        }
        return $output;
}

/**
* Make the ivbcmslinkscat and put the counters in the vbcmsprodcats array
*
* @param   boolean   put counters in the catcache or not
* @param   boolean   at moment nothing
*
*
*/
function vbcms_cache_prodcats($counters = 0, $userid = 0)
{
        global $vbulletin, $vbcms_global;

        if($counters)
        {
                if($userid)
                {
                        $query = "";
                }else{
                        $query = "
                                SELECT
                                catid, lastprodid, catpic, prodcount, pollcount,
                                lastprodtitle, lastproduserid, lastprodusername,
                                lastproddate, lastpollid, lastpollprodid, lastpolltitle, lastpolluserid,
                                lastpollusername, lastpolldate
                                FROM " . TABLE_PREFIX . "vbcmsprodcats

                        ";
                }
        }
        if($query !== null)
        {
                $catquer = $vbulletin->db->query_read_slave($query);
                if($vbulletin->db->num_rows($catquer))
                {
                        while($catrow = $vbulletin->db->fetch_array($catquer))
                        {
                                if(empty($vbulletin->vbcmsprodcats["$catrow[catid]"]))
                                {
								        $vbulletin->vbcmsprodcats["$catrow[catid]"] = $catrow;
                                }else{
								        $vbulletin->vbcmsprodcats["$catrow[catid]"] = $catrow + $vbulletin->vbcmsprodcats["$catrow[catid]"];
								}
                        }
                        $vbulletin->db->free_result($catquer);
                }
        }

        $vbulletin->ivbcmsprodcats = array();

        foreach($vbulletin->vbcmsprodcats AS $catid => $cat)
        {
                $cat['sub'] = intval($cat['sub']);
                $vbulletin->ivbcmsprodcats["$cat[sub]"]["$catid"] = $catid;
        }
}

/**
* Function to put the linkscatpermissions in the $vbulletin->userinfo array
*
* @param	ref     userinfo
*
* @return   array   userinfo + permissions
*/
function vbcms_fetch_prodcatpermissions(&$user)
{
        global $vbulletin;
        foreach($vbulletin->vbcmsprodcats AS $catid => $cat)
        {
                foreach($vbulletin->usergroupcache AS $key => $value)
                {
                        // Default Catpermissions from the usergroupcache
                        $vbulletin->vbcmsprodcats["$catid"]['permissions']["$key"] = $value['vbcmsprodcatspermissions'];

                        // Specified Catpermissions
                        if(isset($vbulletin->vbcmsprodperms["$catid"]["$key"]))
                        {
                                foreach(explode(',', $cat['parent']) AS $realid)
                                {
                                        if(!$vbulletin->vbcmsprodperms["$realid"]["$key"])
                                        {
                                                $vbulletin->vbcmsprodcats["$realid"]['permissions']["$key"] = $vbulletin->vbcmsprodperms["$catid"]["$key"];
                                                $vbulletin->vbcmsprodperms["$realid"]["$key"] = $vbulletin->vbcmsprodperms["$catid"]["$key"];
                                                $vbulletin->vbcmsprodperms["$realid"]['sub'] = 1;
                                        }
                                }
                                $vbulletin->vbcmsprodcats["$catid"]['permissions']["$key"] = $vbulletin->vbcmsprodperms["$catid"]["$key"];
                        }
                }
        }

	    $groupids = fetch_membergroupids_array($user);

        foreach($vbulletin->vbcmsprodcats AS $catid => $cat)
        {
                if(!isset($user['vbcmsprodcatspermissions']["$catid"]))
                {
					$user['vbcmsprodcatspermissions']["$catid"] = 0;
                }
                foreach($groupids AS $usergroupid)
		        {
                        $user['vbcmsprodcatspermissions']["$catid"] |= $vbulletin->vbcmsprodcats["$catid"]['permissions']["$usergroupid"];
                }
        }
        return $user['permissions'];
}

function &vbcms_fetch_adminliclasses($arr = array())
{
    // DEFAULT CLASSES
	$classes = array(
		'default',
		'managecats',
		'addcat',
		'addproduct',
		'editcat',
		'editproduct',
		'permissions',
		'payments',
		'shippings',
		'orderstatus',
		'editstatus',		
		'addstatus',
		'orders',
		'search',
		'search_results',
		'statistic',
		'top_prods',
		'top_user'
	);
	$classes = array_merge($arr, $classes);
	return $classes;
}

/**
* Function to put the linkscatpermissions in the $vbulletin->userinfo array
*
*/
function &vbcms_fetch_prodcountrys()
{
        $country_array = array(
                'all' => array(
                         'US' => 'United States',
                         'GB' => 'United Kingdom',
                         'AF' => 'Afghanistan',
                         'AL' => 'Albania',
                         'DZ' => 'Algeria',
                         'AS' => 'American Samoa',
                         'AD' => 'Andorra',
                         'AO' => 'Angola',
                         'AI' => 'Anguilla',
                         'AQ' => 'Antarctica',
                         'AG' => 'Antigua And Barbuda',
                         'AR' => 'Argentina',
                         'AM' => 'Armenia',
                         'AW' => 'Aruba',
                         'AU' => 'Australia',
                         'AT' => 'Austria',
                         'AZ' => 'Azerbaijan',
                         'BS' => 'Bahamas',
                         'BH' => 'Bahrain',
                         'BD' => 'Bangladesh',
                         'BB' => 'Barbados',
                         'BY' => 'Belarus',
                         'BE' => 'Belgium',
                         'BZ' => 'Belize',
                         'BJ' => 'Benin',
                         'BM' => 'Bermuda',
                         'BT' => 'Bhutan',
                         'BO' => 'Bolivia',
                         'BA' => 'Bosnia And Herzegowina',
                         'BW' => 'Botswana',
                         'BV' => 'Bouvet Island',
                         'BR' => 'Brazil',
                         'IO' => 'British Indian Ocean Territory',
                         'BN' => 'Brunei Darussalam',
                         'BG' => 'Bulgaria',
                         'BF' => 'Burkina Faso',
                         'BI' => 'Burundi',
                         'KH' => 'Cambodia',
                         'CM' => 'Cameroon',
                         'CA' => 'Canada',
                         'CV' => 'Cape Verde',
                         'KY' => 'Cayman Islands',
                         'CF' => 'Central African Republic',
                         'TD' => 'Chad',
                         'CL' => 'Chile',
                         'CN' => 'China',
                         'CX' => 'Christmas Island',
                         'CC' => 'Cocos (Keeling) Islands',
                         'CO' => 'Colombia',
                         'KM' => 'Comoros',
                         'CG' => 'Congo',
                         'CK' => 'Cook Islands',
                         'CR' => 'Costa Rica',
                         'HR' => 'Croatia',
                         'CU' => 'Cuba',
                         'CY' => 'Cyprus',
                         'CZ' => 'Czech Republic',
                         'DK' => 'Denmark',
                         'DJ' => 'Djibouti',
                         'DM' => 'Dominica',
                         'DO' => 'Dominican Republic',
                         'TL' => 'East Timor',
                         'EC' => 'Ecuador',
                         'EG' => 'Egypt',
                         'SV' => 'El Salvador',
                         'GQ' => 'Equatorial Guinea',
                         'ER' => 'Eritrea',
                         'EE' => 'Estonia',
                         'ET' => 'Ethiopia',
                         'FK' => 'Falkland Islands',
                         'FO' => 'Faroe Islands',
                         'FJ' => 'Fiji',
                         'FI' => 'Finland',
                         'FR' => 'France',
                         'GF' => 'French Guiana',
                         'PF' => 'French Polynesia',
                         'TF' => 'French Southern Territories',
                         'GA' => 'Gabon',
                         'GM' => 'Gambia',
                         'GE' => 'Georgia',
                         'DE' => 'Germany',
                         'GH' => 'Ghana',
                         'GI' => 'Gibraltar',
                         'GR' => 'Greece',
                         'GL' => 'Greenland',
                         'GD' => 'Grenada',
                         'GP' => 'Guadeloupe',
                         'GU' => 'Guam',
                         'GT' => 'Guatemala',
                         'GN' => 'Guinea',
                         'GW' => 'Guinea-bissau',
                         'GY' => 'Guyana',
                         'HT' => 'Haiti',
                         'HM' => 'Heard And Mc Donald Islands',
                         'HN' => 'Honduras',
                         'HK' => 'Hong Kong',
                         'HU' => 'Hungary',
                         'IS' => 'Iceland',
                         'IN' => 'India',
                         'ID' => 'Indonesia',
                         'IR' => 'Iran',
                         'IQ' => 'Iraq',
                         'IE' => 'Ireland',
                         'IL' => 'Israel',
                         'IT' => 'Italy',
                         'JM' => 'Jamaica',
                         'JP' => 'Japan',
                         'JO' => 'Jordan',
                         'KZ' => 'Kazakhstan',
                         'KE' => 'Kenya',
                         'KI' => 'Kiribati',
                         'KW' => 'Kuwait',
                         'KG' => 'Kyrgyzstan',
                         'LA' => 'Lao',
                         'LV' => 'Latvia',
                         'LB' => 'Lebanon',
                         'LS' => 'Lesotho',
                         'LR' => 'Liberia',
                         'LY' => 'Libyan Arab Jamahiriya',
                         'LI' => 'Liechtenstein',
                         'LT' => 'Lithuania',
                         'LU' => 'Luxembourg',
                         'MO' => 'Macau',
                         'MK' => 'Macedonia',
                         'MG' => 'Madagascar',
                         'MW' => 'Malawi',
                         'MY' => 'Malaysia',
                         'MV' => 'Maldives',
                         'ML' => 'Mali',
                         'MT' => 'Malta',
                         'MH' => 'Marshall Islands',
                         'MQ' => 'Martinique',
                         'MR' => 'Mauritania',
                         'MU' => 'Mauritius',
                         'YT' => 'Mayotte',
                         'MX' => 'Mexico',
                         'FM' => 'Micronesia',
                         'MD' => 'Moldova',
                         'MC' => 'Monaco',
                         'MN' => 'Mongolia',
                         'MS' => 'Montserrat',
                         'MA' => 'Morocco',
                         'MZ' => 'Mozambique',
                         'MM' => 'Myanmar',
                         'NA' => 'Namibia',
                         'NR' => 'Nauru',
                         'NP' => 'Nepal',
                         'NL' => 'Netherlands',
                         'AN' => 'Netherlands Antilles',
                         'NC' => 'New Caledonia',
                         'NZ' => 'New Zealand',
                         'NI' => 'Nicaragua',
                         'NE' => 'Niger',
                         'NG' => 'Nigeria',
                         'NU' => 'Niue',
                         'NF' => 'Norfolk Island',
                         'KP' => 'North Korea',
                         'MP' => 'Northern Mariana Islands',
                         'NO' => 'Norway',
                         'OM' => 'Oman',
                         'PK' => 'Pakistan',
                         'PW' => 'Palau',
                         'PA' => 'Panama',
                         'PG' => 'Papua New Guinea',
                         'PY' => 'Paraguay',
                         'PE' => 'Peru',
                         'PH' => 'Philippines',
                         'PN' => 'Pitcairn',
                         'PL' => 'Poland',
                         'PT' => 'Portugal',
                         'PR' => 'Puerto Rico',
                         'QA' => 'Qatar',
                         'RE' => 'Reunion',
                         'RO' => 'Romania',
                         'RU' => 'Russian Federation',
                         'RW' => 'Rwanda',
                         'KN' => 'Saint Kitts And Nevis',
                         'LC' => 'Saint Lucia',
                         'VC' => 'Saint Vincent And The Grenadines',
                         'WS' => 'Samoa',
                         'SM' => 'San Marino',
                         'ST' => 'Sao Tome And Principe',
                         'SA' => 'Saudi Arabia',
                         'SN' => 'Senegal',
                         'CS' => 'Serbia And Montenegro',
                         'SC' => 'Seychelles',
                         'SL' => 'Sierra Leone',
                         'SG' => 'Singapore',
                         'SK' => 'Slovakia',
                         'SI' => 'Slovenia',
                         'SB' => 'Solomon Islands',
                         'SO' => 'Somalia',
                         'ZA' => 'South Africa',
                         'GS' => 'South Georgia',
                         'KR' => 'South Korea',
                         'ES' => 'Spain',
                         'LK' => 'Sri Lanka',
                         'SD' => 'Sudan',
                         'SR' => 'Suriname',
                         'SJ' => 'Svalbard And Jan Mayen Islands',
                         'SZ' => 'Swaziland',
                         'SE' => 'Sweden',
                         'CH' => 'Switzerland',
                         'SY' => 'Syria',
                         'TW' => 'Taiwan',
                         'TJ' => 'Tajikistan',
                         'TZ' => 'Tanzania',
                         'TH' => 'Thailand',
                         'TG' => 'Togo',
                         'TK' => 'Tokelau',
                         'TO' => 'Tonga',
                         'TT' => 'Trinidad And Tobago',
                         'TN' => 'Tunisia',
                         'TR' => 'Turkey',
                         'TM' => 'Turkmenistan',
                         'TC' => 'Turks And Caicos Islands',
                         'TV' => 'Tuvalu',
                         'UG' => 'Uganda',
                         'UA' => 'Ukraine',
                         'AE' => 'United Arab Emirates',
                         'UM' => 'United States Minor Outlying Islands',
                         'UY' => 'Uruguay',
                         'UZ' => 'Uzbekistan',
                         'VU' => 'Vanuatu',
                         'VA' => 'Vatican City State (Holy See)',
                         'VE' => 'Venezuela',
                         'VN' => 'Viet Nam',
                         'VG' => 'Virgin Islands (British)',
                         'VI' => 'Virgin Islands (US)',
                         'WF' => 'Wallis And Futuna Islands',
                         'EH' => 'Western Sahara',
                         'YE' => 'Yemen',
                         'ZM' => 'Zambia',
                         'ZW' => 'Zimbabwe'
                ),
                'eukeys' => array(
                         'BE',
                         'BG',
                         'DK',
                         'DE',
                         'EE',
                         'FI',
                         'FR',
                         'GR',
                         'IE',
                         'IT',
                         'LV',
                         'LT',
                         'LU',
                         'MT',
                         'NL',
                         'PL',
                         'AT',
                         'PT',
                         'SE',
                         'SK',
                         'SI',
                         'ES',
                         'CZ',
                         'HU',
                         'GB',
                         'CY',
                         'RO'
                 )
        );
        return $country_array;
}

/**
* Fetch the options infos from a catgory return array with infos or false
*
* @param	str     for the searchphrases
* @param    int     for labguageid
*
* @return   not
*/
function vbcms_download_prod_modulphrases($like = '', $langid = -1)
{
        global $vbulletin, $vbphrase;

        if ($vbulletin->GPC['languageid'] == -1)
        {
                $language['title'] = $vbphrase['master_language'];
        }else{
                $language = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "language WHERE languageid = " . $langid);
        }

        $title = str_replace('"', '\"', $language['title']);
        $version = str_replace('"', '\"', $vbulletin->options['templateversion']);

        require_once(DIR . '/includes/adminfunctions_language.php');
        $phrasetypes = fetch_phrasetypes_array(false);

        $phrases = array();
        $getphrases = $vbulletin->db->query_read("
                SELECT
                phrase.varname, phrase.text, phrase.fieldname, phrase.languageid,
                phrase.username, phrase.dateline, phrase.version
                FROM " . TABLE_PREFIX . "phrase AS phrase
                " . (($vbulletin->GPC['dolanguageid'] != -1) ? "LEFT JOIN " . TABLE_PREFIX . "phrase AS phrase2 ON (phrase.varname = phrase2.varname AND phrase2.languageid = -1 AND phrase.fieldname = phrase2.fieldname)" : "") . "
                WHERE phrase.languageid IN (" . $langid .  ", 0)
                        AND phrase.product = '" . $vbulletin->db->escape_string('vbcms') . "'
                        AND phrase.varname LIKE '" . $vbulletin->db->escape_string($like) . "%'
                ORDER BY phrase.languageid, phrase.fieldname, phrase.varname
        ");
        while($getphrase = $vbulletin->db->fetch_array($getphrases))
        {
                $phrases["$getphrase[fieldname]"]["$getphrase[varname]"] = $getphrase;
        }
        unset($getphrase);
        $vbulletin->db->free_result($getphrases);

        if(empty($phrases))
        {
                echo('No Phrases found in this Language');
                exit;
        }

        require_once(DIR . '/includes/class_xml.php');
        $xml = new vB_XML_Builder($vbulletin);

        $xml->add_group('language', array('name' => $title, 'vbversion' => $version, 'product' => 'vbcms', 'type' => iif($vbulletin->GPC['dolanguageid'] == -1, 'master', iif($vbulletin->GPC['just_phrases'], 'phrases', 'custom'))));

        if($langid != -1)
        {
                $xml->add_group('settings');
                $ignorefields = array('languageid', 'title', 'userselect');
                foreach ($language AS $fieldname => $value)
                {
                        if (substr($fieldname, 0, 12) != 'phrasegroup_' AND !in_array($fieldname, $ignorefields))
                        {
                                $xml->add_tag($fieldname, $value, array(), true);
                        }
                }
                $xml->close_group();
        }

        foreach ($phrases AS $_fieldname => $typephrases)
        {
                $xml->add_group('phrasetype', array('name' => $phrasetypes["$_fieldname"]['title'], 'fieldname' => $_fieldname));
                foreach ($typephrases AS $phrase)
                {
                        $attributes = array(
                                'name' => $phrase['varname']
                        );

                        if($phrase['dateline'])
                        {
                                $attributes['date'] = $phrase['dateline'];
                        }
                        if($phrase['username'])
                        {
                                $attributes['username'] = $phrase['username'];
                        }
                        if ($phrase['version'])
                        {
                                $attributes['version'] = htmlspecialchars_uni($phrase['version']);
                        }

                        $xml->add_tag('phrase', $phrase['text'], $attributes, true);
                }
                $xml->close_group();
        }

        $xml->close_group();

        $doc = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\r\n\r\n";

        $doc .= $xml->output();
        $xml = null;

        $size = strlen($doc);
        header("Expires: Mon, 26 Nov 1962 00:00:00 GMT");
        header("Last-Modified: " . gmdate("D,d M Y H:i:s") . " GMT");
        header("Cache-Control: no-cache, must-revalidate");
        header("Pragma: no-cache");
        header("Content-Type: application/octet-stream");
        header("Content-Length: $size");
        header("Content-disposition: attachment; filename = " . $like . '.xml');
	    echo ($doc);
}



/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # SVN: $RCSfile$ - $Revision: 1653 $
|| ####################################################################
\*======================================================================*/
?>