<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBCMS Version 2.6.8
|| # ------------------------------------------------------------------ # ||
|| # Copyright  2002 - 2009 Reuter & Bloe GbR.                          ||
|| # ------------------- VBCMS IS NOT FREE SOFTWARE ------------------- # ||
|| # http://www.vbdesigns.de | http://www.vbdesigns.de/license.html     # ||
|| ###################################################################### ||
\*========================================================================*/

error_reporting(E_ALL & ~E_NOTICE & ~8192);
if (!is_object($vbulletin->db))
{
	exit;
}

$mysqlversion = $vbulletin->db->query_first("SELECT version() AS version");
define('MYSQL_VERSION', $mysqlversion['version']);
$enginetype = (version_compare(MYSQL_VERSION, '4.0.18', '<')) ? 'TYPE' : 'ENGINE';
$tabletype = (version_compare(MYSQL_VERSION, '4.1', '<')) ? 'HEAP' : 'MEMORY';

$aggtable = "vbcms_taggregate_temp_$nextitem[nextrun]";

$vbulletin->db->query_write("
	CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "$aggtable (
		prodid INT UNSIGNED NOT NULL DEFAULT '0',
		ordercount INT UNSIGNED NOT NULL DEFAULT '0',
		KEY prodid (prodid)
	) $enginetype = $tabletype");

if ($vbulletin->options['usemailqueue'] == 2)
{
	$vbulletin->db->lock_tables(array(
		 $aggtable     => 'WRITE',
		 'vbcmsprodupdatecount' => 'WRITE'
	));
}

$vbulletin->db->query_write("
	INSERT INTO ". TABLE_PREFIX ."$aggtable
		SELECT prodid, COUNT(*) AS ordercount
		FROM " . TABLE_PREFIX . "vbcmsprodupdatecount
		GROUP BY prodid
");

if ($vbulletin->options['usemailqueue'] == 2)
{
	$vbulletin->db->unlock_tables();
}
/* Small race condition but better than lots of IO wait for a DELETE query */
$vbulletin->db->query_write("TRUNCATE TABLE " . TABLE_PREFIX . "vbcmsprodupdatecount");

$vbulletin->db->query_write(
	"UPDATE " . TABLE_PREFIX . "vbcmsprods AS vbcmsprods,". TABLE_PREFIX . "$aggtable AS aggregate
	SET vbcmsprods.ordercount = vbcmsprods.ordercount + aggregate.ordercount
	WHERE vbcmsprods.prodid = aggregate.prodid
");

// Delete Temporary Card from the guests
$vbulletin->db->query_write("
	DELETE FROM " . TABLE_PREFIX . "vbcmsprodscard
 	WHERE time < " . intval(TIMENOW - 900) . " AND userid = ''
");

$status = $setting = array();

$setting_quer = $vbulletin->db->query_read_slave("SELECT * FROM " . TABLE_PREFIX . "vbcmssettings");

while ($setting_row = $vbulletin->db->fetch_array($setting_quer))
{
	$setting[$setting_row['varname']] = $setting_row;
}
$vbulletin->db->free_result($setting_quer);

$status_quer = $vbulletin->db->query_read_slave("SELECT id FROM " . TABLE_PREFIX . "vbcmsprodsstatus WHERE changeuser = 1");
while ($status_row = $vbulletin->db->fetch_array($status_quer))
{
	$status[] = $status_row['id'];
}
$vbulletin->db->free_result($status_quer);

// Change Users UsergroupID after a order
if ($setting['productsarea_usergroupafter_order']['value'] > 0 AND $status)
{
    // Check orders form 2 Months it's better for the performance 
	$orders = $vbulletin->db->query_read("
		SELECT 
		vbcmsprodsorder.userid, user.usergroupid  
		FROM " . TABLE_PREFIX . "vbcmsprodsorder AS vbcmsprodsorder
		LEFT JOIN " . TABLE_PREFIX . "user AS user USING(userid)
		WHERE 
			vbcmsprodsorder.status IN(" . implode(',', $status) . ") 
			AND user.usergroupid <> " . $setting['productsarea_usergroupafter_order']['value'] . "
			AND vbcmsprodsorder.datestamp > " . intval(TIMENOW - 5259486) . "
	");
	
	while ($orders_row = $vbulletin->db->fetch_array($orders))
	{
		if(!in_array($orders_row['usergroupid'], explode(',', $setting['productsarea_usergroupafter_order_exclude']['value'])))
		{
			$userdata =& datamanager_init('User', $vbulletin, ERRTYPE_SILENT);
			$userdata->adminoverride = true;
			$userinfo = fetch_userinfo($orders_row['userid']);
			$userdata->set_existing($userinfo);
			$userdata->set('usergroupid', $setting['productsarea_usergroupafter_order']['value']);
			$userdata->save();
		}
	}
	$vbulletin->db->free_result($orders);
}

$vbulletin->db->query_write("DROP TABLE IF EXISTS " . TABLE_PREFIX . $aggtable);

log_cron_action('', $nextitem, 1);


/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # SVN: $RCSfile$ - $Revision: 1600 $
|| ####################################################################
\*======================================================================*/
?>