<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBCMS Version 2.6.8
|| # ------------------------------------------------------------------ # ||
|| # Copyright  2002 - 2009 Reuter & Bloe GbR.                          ||
|| # ------------------- VBCMS IS NOT FREE SOFTWARE ------------------- # ||
|| # http://www.vbdesigns.de | http://www.vbdesigns.de/license.html     # ||
|| ###################################################################### ||
\*========================================================================*/

if(!class_exists('vB_DataManager'))
{
	exit;
}

/**
* Class to do data save/delete operations for vBCMS Productsorders
*
* @package	vBCMS 2.6.8
* @version	$Revision: 1588 $
* @date		$Date: 2009-07-02 18:24:41 +0200 (Do, 02. Jul 2009) $
*/
class vB_DataManager_vbcmsproduct_order extends vB_DataManager
{
	/**
	* Array of recognised and required fields for vbcmsprods, and their types
	*
	* @var	array
	*/
	var $validfields = array(
		'id'             => array(TYPE_UINT,        REQ_INCR,   VF_METHOD,  'verify_nonzero'),
		'userid'         => array(TYPE_UINT,        REQ_NO,     VF_METHOD),
		'ordernumber'    => array(TYPE_UINT,        REQ_NO),
		'datestamp'      => array(TYPE_UINT,        REQ_NO),
		'orderhash'      => array(TYPE_STR,         REQ_NO,     VF_METHOD),
		'price'          => array(TYPE_STR,         REQ_NO,     VF_METHOD),
		'amounttotal'    => array(TYPE_UINT,        REQ_NO),
		'payment'        => array(TYPE_NOHTML,      REQ_NO),
		'paymentinfo'    => array(TYPE_ARRAY,       REQ_NO,     VF_METHOD),		
		'shipping'       => array(TYPE_NOHTML,      REQ_NO),		
		'status'         => array(TYPE_UINT,        REQ_NO),
		'ipaddress'      => array(TYPE_NOHTML,      REQ_AUTO),
		'country'        => array(TYPE_NOHTML,      REQ_NO),		
		'remember'       => array(TYPE_UINT,        REQ_NO),
		'rememberdate'   => array(TYPE_UINT,        REQ_NO),
		'message'        => array(TYPE_STR,         REQ_NO),
		'taxarr'         => array(TYPE_ARRAY,       REQ_NO,     VF_METHOD),	
                
	);

	/**
	* Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
	* For example: var $bitfields = array('options' => 'bf_misc_useroptions', 'permissions' => 'bf_misc_moderatorpermissions')
	*
	* @var	array
	*/
	var $bitfields = array();

	/**
	* The main table this class deals with
	*
	* @var	string
	*/
	var $table = 'vbcmsprodsorder';

	/**
	* Array to store stuff to save to vbcmsprodsorder table
	*
	* @var	array
	*/
	var $vbcmsprodsorder = array();

	/**
	* Condition template for update query
	*
	* @var	array
	*/
	var $condition_construct = array('id = %1$d', 'id');
	var $proddetails = array();
	/**
	* Constructor - checks that the registry object has been passed correctly.
	*
	* @param	vB_Registry	Instance of the vBulletin data registry object - expected to have the database object as one of its $this->db member.
	* @param	integer		One of the ERRTYPE_x constants
	*/
	function vB_DataManager_vbcmsproduct_prods(&$registry, $errtype = ERRTYPE_STANDARD)
	{
		parent::vB_DataManager($registry, $errtype);

		($hook = vBulletinHook::fetch_hook('vbcms_prodorders_dmdata_start')) ? eval($hook) : false;
	}
	
	/**
	* Validates the taxarr
	*
	* @param	array
	*
	* @return	boolean 
	*/
	function verify_taxarr(&$taxarr)
	{	
		if ($taxarr)
		{
			$taxarr = serialize($taxarr);
		}
		return true;
	}
	
	/**
	* Validates the userid
	*
	* @param	string	intval
	*
	* @return	boolean (mixed)
	*/	
	function email_mods()
	{
		global $vbphrase, $vbcms_global;

		if(!$this->condition)
		{
			foreach($this->proddetails AS $key => $val)
			{
				if ($this->registry->vbcmsprodcats[$val['catid']]['neworderemail'])
				{
                	$catmails[] = $this->registry->vbcmsprodcats[$val['catid']]['neworderemail'];
                }
			}
			if ($catmails)
			{
				$catmails_link = implode(' ', $catmails);
			}
			
			$mods = $this->dbobject->query_read_slave("
				SELECT DISTINCT
				user.username, user.email, user.userid
				FROM " . TABLE_PREFIX . "usergroup AS usergroup
				LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.usergroupid = usergroup.usergroupid)
					WHERE usergroup.vbcmsprodcatspermissions & 256 AND user.email NOT IN('" . implode('\',\'', explode(' ', $catmails_link)) . "')
					" . (($this->registry->vbcmsoptions['productsarea_adminemails']) ? "AND user.email IN('" . implode('\',\'', explode(' ', $this->registry->vbcmsoptions['productsarea_adminemails'])) . "')" : '') . "
			");
			while($mods_row = $this->dbobject->fetch_array($mods))
			{
				$catmails_link .= ' ' . $mods_row['email'];
			}
			$this->dbobject->free_result($mods);

			$mailadresses = implode(',', $temp = explode(' ', $catmails_link));
			$kmessage = $this->info['kmessage'];
			$subject = construct_phrase($vbphrase['vbcms_prod_emailsubject_neworder'], $this->registry->options['bbtitle']);
			$message = construct_phrase($vbphrase['vbcms_prod_emailmessage_neworder'], (($this->registry->vbcmsoptions['vbcms_url']) ? 'http://' . $_SERVER["HTTP_HOST"] . $this->registry->vbcmsoptions['vbcms_url'] : $this->registry->options['bburl'] . '/')  . $this->registry->vbcmsoptions['vbcms_filename'] . '.php?area=' . $vbcms_global['area'] . '&do=orders', $this->registry->options['bbtitle'], $kmessage, $this->info['newordernumber']);
			
			vbmail($mailadresses, $subject, $message, true);		
		}
		
		return true;
	}
        
	/**
	* Validates the userid
	*
	* @param	string	intval
	*
	* @return	boolean (mixed)
	*/
	function verify_userid(&$userid)
	{
		return true;
	}
	
	/**
	* Validates the userid
	*
	* @param	string	intval
	*
	* @return	boolean (mixed)
	*/
	function verify_paymentinfo(&$paymentinfo)
	{
		if (!$this->condition AND $paymentinfo)
		{
			 $paymentinfo = serialize($paymentinfo);
		}
		return true;
	}
		
	/**
	* Validates the orderhash
	*
	* @param	string	intval
	*
	* @return	boolean (mixed)
	*/
	function verify_orderhash(&$orderhash)
	{
		$orderhash = htmlspecialchars_uni($orderhash);
		return true;
	}
	
	/**
	* Validates the price
	*
	* @param	string	intval
	*
	* @return	boolean (mixed)
	*/
	function verify_price(&$price)
	{
		$price = htmlspecialchars_uni($price);
		return true;
	}	
	
	/**
	* Any checks to run immediately before saving. If returning false, the save will not take place.
	*
	* @param	boolean	Do the query?
	*
	* @return	boolean	True on success; false if an error occurred
	*/
	function pre_save($doquery = true)
	{
		if($this->presave_called !== null)
		{
			return $this->presave_called;
		}

		$return_value = true;
		($hook = vBulletinHook::fetch_hook('vbcms_prodorders_dmdata_presave')) ? eval($hook) : false;
		
		if(!$this->condition)
		{        	
			if($this->fetch_field('ipaddress', 'vbcmsprodsorder') === null)
			{
				$this->set('ipaddress', ($this->registry->options['logip'] ? IPADDRESS : ''));	
			}    
			
			if($this->fetch_field('datestamp', 'vbcmsprodsorder') === null)
			{
				$this->set('datestamp', TIMENOW);
			}        	
		}		
		
		return $return_value;
	}

	/**
	* Additional data to update after a save call (such as denormalized values in other tables).
	* In batch updates, is executed for each record updated.
	*
	* @param	boolean	Do the query?
	*/
	function post_save_each($doquery = true)
	{
		// Nothing at the moment
		($hook = vBulletinHook::fetch_hook('vbcms_prodorders_dmdata_postsave')) ? eval($hook) : false;
		
		if (!$this->condition)
		{
			$this->email_mods();
		}	
	}

	function delete()
	{
		$ids = $this->dbobject->query_read("SELECT id, payment, shipping FROM " . TABLE_PREFIX . "vbcmsprodsorder WHERE " . $this->condition);

		while($ids_row = $this->dbobject->fetch_array($ids))
		{
			$this->dbobject->query_write("UPDATE " . TABLE_PREFIX . "vbcmsshippings SET orders = orders - 1 WHERE classname = '" . $this->dbobject->escape_string($ids_row['shipping']) . "'");
			$this->dbobject->query_write("UPDATE " . TABLE_PREFIX . "vbcmspayments  SET orders = orders - 1 WHERE classname = '" . $this->dbobject->escape_string($ids_row['payment']) . "'");				

			$condition .= ',' . intval($ids_row['id']);
		}
		$this->dbobject->free_result($ids);		
		
		$this->db_delete(TABLE_PREFIX, $this->table, $this->condition);	
		
	    $delete_details =& datamanager_init('vbcmsproduct_ordered_prods', $this->registry, ERRTYPE_ARRAY, 'vbcmsproduct_orders');
        $delete_details->set_condition('orderid IN(0' . $condition . ')');
        $delete_details->delete();
	}
}

/**
* Class to do data save/delete operations for vBCMS Productsorders
*
* @package	vBCMS 2.6.8
* @version	$Revision: 1588 $
* @date		$Date: 2009-07-02 18:24:41 +0200 (Do, 02. Jul 2009) $
*/
class vB_DataManager_vbcmsproduct_ordered_prods extends vB_DataManager
{
	/**
	* Array of recognised and required fields for vbcmsprods, and their types
	*
	* @var	array
	*/
	var $validfields = array(
		'id'             => array(TYPE_UINT,        REQ_INCR,   VF_METHOD,  'verify_nonzero'),
		'ordernumber'    => array(TYPE_UINT,        REQ_NO),
		'orderid'        => array(TYPE_UINT,        REQ_NO),
		'prodid'         => array(TYPE_UINT,        REQ_NO),
		'additional'     => array(TYPE_STR,         REQ_NO,     VF_METHOD),	
		'prodtype'       => array(TYPE_NOHTML,      REQ_NO),		
		'amount'         => array(TYPE_UINT,        REQ_NO),
		'updates'        => array(TYPE_INT,         REQ_NO),
		'updateids'      => array(TYPE_NOHTML,      REQ_NO)			
                
	);

	/**
	* Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
	* For example: var $bitfields = array('options' => 'bf_misc_useroptions', 'permissions' => 'bf_misc_moderatorpermissions')
	*
	* @var	array
	*/
	var $bitfields = array();

	/**
	* The main table this class deals with
	*
	* @var	string
	*/
	var $table = 'vbcmsprodsordered';

	/**
	* Array to store stuff to save to vbcmslinkscats table
	*
	* @var	array
	*/
	var $vbcmsprodsordered = array();

	/**
	* Condition template for update query
	*
	* @var	array
	*/
	var $condition_construct = array('id = %1$d', 'id');

	/**
	* Constructor - checks that the registry object has been passed correctly.
	*
	* @param	vB_Registry	Instance of the vBulletin data registry object - expected to have the database object as one of its $this->db member.
	* @param	integer		One of the ERRTYPE_x constants
	*/
	function vB_DataManager_vbcmsproduct_prods(&$registry, $errtype = ERRTYPE_STANDARD)
	{
		parent::vB_DataManager($registry, $errtype);

		($hook = vBulletinHook::fetch_hook('vbcms_prodorder_dmdata_start')) ? eval($hook) : false;
	}
	
	
	/**
	* Validates the price
	*
	* @param	string	intval
	*
	* @return	boolean (mixed)
	*/
	function verify_additional(&$price)
	{
		return true;
	}	
	
	/**
	* Any checks to run immediately before saving. If returning false, the save will not take place.
	*
	* @param	boolean	Do the query?
	*
	* @return	boolean	True on success; false if an error occurred
	*/
	function pre_save($doquery = true)
	{
		if($this->presave_called !== null)
		{
			return $this->presave_called;
		}

		$return_value = true;
		($hook = vBulletinHook::fetch_hook('vbcms_prodorder_dmdata_presave')) ? eval($hook) : false;
		
		return $return_value;
	}

	/**
	* Additional data to update after a save call (such as denormalized values in other tables).
	* In batch updates, is executed for each record updated.
	*
	* @param	boolean	Do the query?
	*/
	function post_save_each($doquery = true)
	{
		// Nothing at the moment
		($hook = vBulletinHook::fetch_hook('vbcms_prodorder_dmdata_postsave')) ? eval($hook) : false;
	}

	function delete()
	{
	    // Counter Update
		$co = $this->dbobject->query_read("SELECT prodid, amount FROM " . TABLE_PREFIX . "vbcmsprodsordered WHERE " . $this->condition . "");

		while($co_row = $this->dbobject->fetch_array($co))
		{
			$this->dbobject->query_write("UPDATE " . TABLE_PREFIX . "vbcmsprods SET ordercount = ordercount - $co_row[amount] WHERE prodid = $co_row[prodid]");				
		}
		$this->dbobject->free_result($co);
		
		$this->db_delete(TABLE_PREFIX, $this->table, $this->condition);
	}
}

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # SVN: $RCSfile$ - $Revision: 1588 $
|| ####################################################################
\*======================================================================*/
?>