<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBCMS Version 2.7.0
|| # ------------------------------------------------------------------ # ||
|| # Copyright  2002 - 2009 Reuter & Bloe GbR.                          ||
|| # ------------------- VBCMS IS NOT FREE SOFTWARE ------------------- # ||
|| # http://www.vbdesigns.de | http://www.vbdesigns.de/license.html     # ||
|| ###################################################################### ||
\*========================================================================*/
if(!class_exists('vBCMS_fetch_components'))
{
        exit;
}

/**
* Class to do data handle payment operations for vBCMS products
*
* @package	vBCMS 2.7.0
* @version	$Revision: 1619 $
* @date		$Date: 2009-09-15 14:30:23 +0200 (Di, 15. Sep 2009) $
*/
class paypal extends vbcms_payments
{
	/**
	* For the description of the objects see /includes/class_vbcms_payments.php
	*
	* @var	mixed
	*/
	var $name = 'Paypal';
	var $host = 'http://www.paypal.com';
	var $formurl = 'https://www.paypal.com/cgi-bin/webscr';

	/**
	* Constructor - checks that the registry object has been passed correctly.
	*
	* @param	(ref)  vB_Registry	Instance of the vBulletin data registry object.
	*/
	function paypal(&$registry, $additional = '')
	{
		// Set registry and db object
		parent::vbcms_payments($registry);
		$this->redirect = true;

		if($additional)
		{
			$this->handle_additional($additional);
		}                
	}

	/**
	* Verify the payment.
	*
	* @param    int     the paymentid
	* @param    string
	*
	*/
	function check_payment()
	{
		$this->registry->input->clean_array_gpc('p', array(
			'item_number'    => TYPE_STR,
			'business'       => TYPE_STR,
			'receiver_email' => TYPE_STR,
			'tax'            => TYPE_STR,
			'txn_type'       => TYPE_STR,
			'payment_status' => TYPE_STR,
			'mc_currency'    => TYPE_STR,
			'mc_gross'       => TYPE_STR,
			'txn_id'         => TYPE_STR
		));
		
		$this->order_id = intval($this->registry->GPC['item_number']);
		
		$query[] = 'cmd=_notify-validate';
		foreach($_POST AS $key => $val)
		{
			$query[] = $key . '=' . urlencode ($val);
		}
		$query = implode('&', $query);
		
		$header = "POST /cgi-bin/webscr HTTP/1.0\r\n";
		$header .= "Host: www.paypal.com\r\n";
		$header .= "Content-Type: application/x-www-form-urlencoded\r\n";
		$header .= "Content-Length: " . strlen($query) . "\r\n\r\n";
		if ($fp = fsockopen('www.paypal.com', 80, $errno, $errstr, 15))
		{
			socket_set_timeout($fp, 15);
			fwrite($fp, $header . $query);
			while (!feof($fp))
			{
				$result = fgets($fp, 1024);
				if (strcmp($result, 'VERIFIED') == 0)
				{
					break;
				}
			}
			fclose($fp);
		}
		
		$field_array = unserialize($this->settings['fields']);

		if ($result == 'VERIFIED' AND (strtolower($this->registry->GPC['business']) == strtolower($field_array['email'])))
		{
			$this->paymentinfo = $this->registry->db->query_first("
				SELECT *
				FROM " . TABLE_PREFIX . "vbcmsprodsorder
				WHERE ordernumber = " . intval($this->registry->GPC['item_number']) . "
			");
			
			if (!empty($this->paymentinfo))
			{
				if (($this->registry->GPC['txn_type'] == 'web_accept') AND $this->registry->GPC['payment_status'] == 'Completed')
				{
					if(doubleval($this->paymentinfo['price']) == doubleval($this->registry->GPC['mc_gross']))
					{
						$this->status = true;
					}
					else
					{
						$this->error = 'invalid_payment_amount';
					}
				}
				else
				{
					$this->error = 'Your Payment Status is not completed, it is <b>' . $this->registry->GPC['payment_status'] . '</b>';
				}
			}
		}
		else
		{
			$this->error = 'invalid_payment_request';
		}
		return $this->status;
		
	}

        /**
        * Generate the form fields when we need.
        */
        function fetch_userinput($input, $checkinput = false)
        {
                return false;
        }

        /**
        * Generate the hidden fields when we need.
        */
        function generate_hiddenfields(&$input)
        {
                $this->hidden .= '
                        <input type="hidden" name="payment[name]" value="' . get_class($this) . '" />
                ';
                return $this->hidden;
        }
        /**
        * Install the modul.
        */
        function install()
        {
                $this->db->query_write("
                        INSERT INTO " . TABLE_PREFIX . "vbcmspayments
                        (id, name, field, currency, active, classname, countrys, defaultcheck)
                        VALUES
                        (
                        '',
                        '" . $this->db->escape_string(get_class($this)) . "',
                        '" . $this->db->escape_string('a:1:{s:5:"email";s:0:"";}') . "',
                        '" . $this->db->escape_string('EUR') . "',
                        1,
                        '" . $this->db->escape_string(get_class($this)) . "',
                        '" . $this->db->escape_string($this->allowed_countrys) . "',
                        1
                        )
                ");
        }

        /**
        * Uninstall the modul.
        */
        function uninstall()
        {
                $this->db->query_write("
                        DELETE FROM " . TABLE_PREFIX . "vbcmspayments WHERE classname = '" . get_class($this) . "'
                ");
        }
  	/**
	* Handle the additional fields from the module
	*
	* @param   string with the serialized array from the database
	*
	*/
	function handle_additional($val)
	{
		return false;
	}
	
	/**
	* Checkout formfield
	*
	* @param	array with needed infos
	*/   
	function checkout_formfield($info)
	{
		global $vbphrase, $vbcms_global;
		
		// Development
		// $this->formurl = 'https://www.sandbox.paypal.com/cgi-bin/webscr';
		
		$paymentinfo = $this->db->query_first_slave("SELECT currency, field FROM " . TABLE_PREFIX . "vbcmspayments WHERE classname = '" . get_class($this) . "'");
		$field_array = unserialize($paymentinfo['field']);

		return '
			<script type="text/javascript">
			myvar = "";
			timeout = 7;
			function dorefresh()
			{
				window.status=myvar;
				myvar = myvar + " .";
				timerID = setTimeout("dorefresh();", 300);
				if (timeout > 0)
				{
					timeout -= 1;
				}
				else
				{
					clearTimeout(timerID);
					window.status="";
					document.w_form.submit();
				}
			}
			dorefresh();
			</script>
			<form name="w_form" action="' . $this->formurl . '" method="post">
			<input type="hidden" name="cmd" value="_xclick">

			<input type="hidden" name="no_note" value="1" />
			<input type="hidden" name="no_shipping" value="2" />
			<input type="hidden" name="business" value="' . $field_array['email'] . '" />
			<input type="hidden" name="item_number" value="' . $info['ordernumber'] . '" />
			<input type="hidden" name="item_name" value="' . $info['productname'] . '" />
			<input type="hidden" name="amount" value="' . $info['end_cost_num'] . '" />
			<input type="hidden" name="currency_code" value="' . $paymentinfo['currency'] . '" />
			<input type="hidden" name="first_name" value="' . $info['customerinfos']['sname'] . '" />
			<input type="hidden" name="last_name" value="' . $info['customerinfos']['ssurname'] . '" />
			<input type="hidden" name="email" value="' . $this->registry->userinfo['email'] . '" />
			<input type="hidden" name="custom" value="' . $this->registry->userinfo['username'] . '" />
			<input type="hidden" name="address1" value="' . $info['customerinfos']['sstreet'] . '" />
			<input type="hidden" name="city" value="' . $info['customerinfos']['scity'] . '" />
			<input type="hidden" name="country" value="' . $info['customerinfos']['scountry'] . '" />
			<input type="hidden" name="state" value="' . $info['customerinfos']['scountry'] . '" />
			<input type="hidden" name="return" value="' . $this->registry->options['bburl'] . ((!$this->registry->vbcmsoptions['vbcms_url']) ? '/' : '') . $this->registry->vbcmsoptions['vbcms_url'] . $this->registry->vbcmsoptions['vbcms_filename'] . '.php?' . $this->registry->session->vars['sessionurl_js'] . 'area=' . $vbcms_global['area'] . '&do=paymentgate&method=paypal" /> 
			<input type="hidden" name="notify_url" value="' . $this->registry->options['bburl'] . ((!$this->registry->vbcmsoptions['vbcms_url']) ? '/' : '') . $this->registry->vbcmsoptions['vbcms_url'] . $this->registry->vbcmsoptions['vbcms_filename'] . '.php?' . $this->registry->session->vars['sessionurl_js'] . 'area=' . $vbcms_global['area'] . '&do=paymentgate&method=paypal" /> 
			<input type="hidden" name="zip" value="' . $info['customerinfos']['splz'] . '" />
			<input type="hidden" name="night_phone_a" value="' . $info['customerinfos']['stel'] . '" />		

			<div style="text-align:center;"><input  type="submit" value="' . $vbphrase['vbcms_payment_paypal_button_pay'] . '" /></div><br />	

			' . $vbphrase['vbcms_payment_' . get_class($this) . '_thankyou_message'] . '<br/>

			<br/><div style="text-align:center;"><input type="submit" value="' . $vbphrase['vbcms_payment_paypal_button_pay'] . '" /></div>
			</form>
		';
	}		
}

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # SVN: $RCSfile$ - $Revision: 1619 $
|| ####################################################################
\*======================================================================*/
?>