<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBCMS Version 2.7.0
|| # ------------------------------------------------------------------ # ||
|| # Copyright  2002 - 2009 Reuter & Bloe GbR.                          ||
|| # ------------------- VBCMS IS NOT FREE SOFTWARE ------------------- # ||
|| # http://www.vbdesigns.de | http://www.vbdesigns.de/license.html     # ||
|| ###################################################################### ||
\*========================================================================*/
if(!class_exists('vBCMS_fetch_components'))
{
        exit;
}

/**
* Class to do data handle payment operations for vBCMS products
*
* @package	vBCMS 2.7.0
* @version	$Revision: 1619 $
* @date		$Date: 2009-09-15 14:30:23 +0200 (Di, 15. Sep 2009) $
*/
class moneybookers extends vbcms_payments
{
        /**
    	* For the description of the objects see /includes/class_vbcms_payments.php
    	*
    	* @var	mixed
    	*/
        var $name = 'Moneybookers';
        var $host = 'http://www.moneybookers.com';
        var $formurl = 'https://www.moneybookers.com/app/payment.pl';

        /**
        * Constructor - checks that the registry object has been passed correctly.
        *
        * @param	(ref)  vB_Registry	Instance of the vBulletin data registry object.
        */
        function moneybookers(&$registry, $additional = '')
        {
	            // Set registry and db object
                parent::vbcms_payments($registry);
                $this->redirect = true;
                
                if($additional)
                {
                	$this->handle_additional($additional);
                }                
        }

        /**
        * Verify the payment.
        *
        * @param    int     the paymentid
        * @param    string
        *
        */
        function check_payment($paymentid)
        {
			$this->registry->input->clean_array_gpc('p', array(
				'pay_to_email'           => TYPE_STR,
				'merchant_id'            => TYPE_STR,
				'transaction_id'         => TYPE_STR,
				'mb_transaction_id'      => TYPE_UINT,
				'status'                 => TYPE_STR,
				'md5sig'                 => TYPE_STR,
				'amount'                 => TYPE_STR,
				'currency'               => TYPE_STR,
				'mb_amount'              => TYPE_STR,
				'mb_currency'            => TYPE_STR,
			));

			$this->order_id = intval($this->registry->GPC['mb_transaction_id']);
			
			$hash = strtoupper(md5($this->registry->GPC['merchant_id'] . $this->registry->GPC['transaction_id'] . strtoupper(md5(strtolower($this->settings['mbsecret']))) . $this->registry->GPC['mb_amount'] . $this->registry->GPC['mb_currency'] . $this->registry->GPC['status']));

			if (strtolower($this->registry->GPC['pay_to_email']) == strtolower($this->settings['mbemail']) AND $hash == $this->registry->GPC['md5sig'])
			{
				if ($this->registry->GPC['status'] == 2)
				{
					$this->paymentinfo = $this->registry->db->query_first("
						SELECT *
						FROM " . TABLE_PREFIX . "vbcmsprodsorder
						WHERE ordernumber = " . intval($this->registry->GPC['mb_transaction_id']) . "
					");	
					
					if (!empty($this->paymentinfo))
					{
						if(doubleval($this->paymentinfo['price']) == doubleval($this->registry->GPC['amount']))
						{
							$this->status = true;
						}
						else
						{
							$this->error = 'invalid_payment_amount';
						}
					}					
				}
				else
				{
					$this->error = 'Your Payment Status is not completed, it is <b>' . $this->registry->GPC['payment_status'] . '</b>';
				}
			}			
			else
			{
				$this->error = 'invalid_payment_request';
			}
			return $this->status;
        }

        /**
        * Generate the form fields when we need.
        */
        function fetch_userinput($input, $checkinput = false)
        {
                return false;
        }

        /**
        * Generate the hidden fields when we need.
        */
        function generate_hiddenfields(&$input)
        {
                $this->hidden .= '
                        <input type="hidden" name="payment[name]" value="' . get_class($this) . '" />
                ';
                return $this->hidden;
        }

        /**
        * Install the modul.
        */
        function install()
        {
                $this->db->query_write("
                        INSERT INTO " . TABLE_PREFIX . "vbcmspayments
                        (id, name, field, currency, active, classname, countrys, defaultcheck)
                        VALUES
                        (
                        '',
                        '" . $this->db->escape_string(get_class($this)) . "',
                        '" . $this->db->escape_string('a:2:{s:5:"email";s:0:"";s:6:"secret";s:0:"";}') . "',
                        '" . $this->db->escape_string('EUR') . "',
                        1,
                        '" . $this->db->escape_string(get_class($this)) . "',
                        '" . $this->db->escape_string($this->allowed_countrys) . "',
                        0
                        )
                ");
        }

        /**
        * Uninstall the modul.
        */
        function uninstall()
        {
                $this->db->query_write("
                        DELETE FROM " . TABLE_PREFIX . "vbcmspayments WHERE classname=  '" . get_class($this) . "'
                ");
        }
  	/**
	* Handle the additional fields from the module
	*
	* @param   string with the serialized array from the database
	*
	*/
	function handle_additional($val)
	{
		return false;
	} 
	
	/**
	* Checkout formfield
	*
	* @param	array with needed infos
	*/   
	function checkout_formfield($info)
	{
		global $vbphrase, $vbcms_global;
		
		$paymentinfo = $this->db->query_first_slave("SELECT currency, field FROM " . TABLE_PREFIX . "vbcmspayments WHERE classname = '" . get_class($this) . "'");
		$field_array = unserialize($paymentinfo['field']);	
		
		// Development
		// $this->formurl = 'http://www.moneybookers.com/app/test_payment.pl';
		
		return '
			<script type="text/javascript">
			myvar = "";
			timeout = 7;
			function dorefresh()
			{
				window.status=myvar;
				myvar = myvar + " .";
				timerID = setTimeout("dorefresh();", 300);
				if (timeout > 0)
				{
					timeout -= 1;
				}
				else
				{
					clearTimeout(timerID); 
					window.status="";
					document.w_form.submit();
				}
			}
			dorefresh();
			</script>
			<form action="' . $this->formurl . '" method="post" target="_blank">
			<input type="hidden" name="pay_to_email" value="' . $field_array['email'] . '">
			<input type="hidden" name="transaction_id" value="' . $info['ordernumber'] . '" />
			<input type="hidden" name="pay_from_email" value="w' . $this->registry->userinfo['email'] . '" />
			
			<input type="hidden" name="language value="' . $info['customerinfos']['scountry'] . '" />
			<input type="hidden" name="return_url" value="' . $this->registry->options['bburl'] . ((!$this->registry->vbcmsoptions['vbcms_url']) ? '/' : '') . $this->registry->vbcmsoptions['vbcms_url'] . $this->registry->vbcmsoptions['vbcms_filename'] . '.php?' . $this->registry->session->vars['sessionurl_js'] . 'area=' . $vbcms_global['area'] . '&do=paymentgate&method=moneybookers" />
			<input type="hidden" name="cancel_url" value="' . $this->registry->options['bburl'] . ((!$this->registry->vbcmsoptions['vbcms_url']) ? '/' : '') . $this->registry->vbcmsoptions['vbcms_url'] . $this->registry->vbcmsoptions['vbcms_filename'] . '.php?' . $this->registry->session->vars['sessionurl_js'] . 'area=' . $vbcms_global['area'] . '" />
            <input type="hidden" name="status_url" value="' . $this->registry->options['bburl'] . ((!$this->registry->vbcmsoptions['vbcms_url']) ? '/' : '') . $this->registry->vbcmsoptions['vbcms_url'] . $this->registry->vbcmsoptions['vbcms_filename'] . '.php?' . $this->registry->session->vars['sessionurl_js'] . 'area=' . $vbcms_global['area'] . '&do=paymentgate&method=moneybookers" />
			<input type="hidden" name="amount" value="' . $info['end_cost_num'] . '">
			<input type="hidden" name="currency" value="' . $paymentinfo['currency'] . '">
			
			<input type="hidden" name="detail1_description" value="Ordernumber:">
			<input type="hidden" name="detail1_text" value="' . $info['ordernumber'] . '">
			
			<input type="hidden" name="detail2_description" value="Product" />
			<input type="hidden" name="detail2_text" value="' . $info['productname'] . '" />

			<input type="hidden" name="firstname" value="' . $info['customerinfos']['sname'] . '" />
			<input type="hidden" name="lastname" value="' . $info['customerinfos']['ssurname'] . '" />
			<input type="hidden" name="address" value="' . $info['customerinfos']['sstreet'] . '" />
			<input type="hidden" name="city" value="' . $info['customerinfos']['scity'] . '" />
			<input type="hidden" name="state" value="' . $info['customerinfos']['scountry'] . '" />
			<input type="hidden" name="phone_number" value="' . $info['customerinfos']['stel'] . '" />
			<input type="hidden" name="postal_code" value="' . $info['customerinfos']['splz'] . '" />

			<div style="text-align:center;"><input  type="submit" value="' . $vbphrase['vbcms_payment_moneybookers_button_pay'] . '" /></div><br />	

			' . $vbphrase['vbcms_payment_' . get_class($this) . '_thankyou_message'] . '<br/>

			<br/><div style="text-align:center;"><input type="submit" value="' . $vbphrase['vbcms_payment_moneybookers_button_pay'] . '" /></div>
			</form>
		';
	}	
}

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # SVN: $RCSfile$ - $Revision: 1619 $
|| ####################################################################
\*======================================================================*/
?>