<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBCMS Version 2.7.0
|| # ------------------------------------------------------------------ # ||
|| # Copyright  2002 - 2009 Reuter & Bloe GbR.                          ||
|| # ------------------- VBCMS IS NOT FREE SOFTWARE ------------------- # ||
|| # http://www.vbdesigns.de | http://www.vbdesigns.de/license.html     # ||
|| ###################################################################### ||
\*========================================================================*/

if(!class_exists('vBCMS_fetch_components'))
{
        exit;
}

/**
* Class to do fetch the vbcms card
*
* @package	vBCMS 2.7.0
* @version	$Revision: 1672 $
* @date		$Date: 2009-11-09 10:33:05 +0100 (Mo, 09. Nov 2009) $
*/
class vbcmscard 
{
        /**
        * Array for the card information
        *
        * @var	array
        */
        var $cardinfo = array();
        var $cardinfo_detail = array();
        
        /**
        * Boolean for the basketbit template
        *
        * @var	bool
        */        
        var $showbasketbit = true;
        var $showbasketbit_small = false;
        
        /**
        * String with the basketbit
        *
        * @var	string
        */        
        var $basketbit = '';
        
        /**
        * Boolean when we need shipping
        *
        * @var	bool
        */        
        var $needshipping = false;        
       
        /**
        * Constructor - checks that the registry object has been passed correctly.
        *
        * @param	vB_Registry	Instance of the vBulletin data registry object - expected to have the database object as one of its $this->db member.
        * @param	array		
        */
        function vbcmscard(&$registry, &$opt)
	    {
	            // Set registry and db object
                if(is_object($registry))
                {
                        $this->registry =& $registry;

                        if(is_object($registry->db))
                        {
                                $this->db =& $registry->db;
                        }else{
                                trigger_error('Database object is not an object', E_USER_ERROR);
                        }
                }else{
                        trigger_error('Registry object is not an object', E_USER_ERROR);
                }
                $this->opt = $opt;
        }

        /**
        * Fetch the card
        *
        * @return	 bool
        */
        function fetch_card($country = '')
        {
                global $vbphrase, $stylevar, $bbuserinfo, $vbcmsoptions, $vbcms_global; // Needed for the Portal_products_basketbit template
                
                $small_basket = $this->showbasketbit_small;
                
                $needtax = true;
                if ($country)
                {
					if (!function_exists('vbcms_fetch_prodcountrys'))
					{
						include(DIR . '/includes/vbcms_product_functions.php');
					}
                
					$country_array =& vbcms_fetch_prodcountrys();
					
					if (in_array($this->registry->vbcmsoptions['productsarea_salescounty'], $country_array['eukeys']) AND !in_array($country, $country_array['eukeys']))
					{
						$needtax = false;
					}
                }
                
				if($this->registry->userinfo['userid'])
				{
						$where = 'vbcmsprodscard.userid = ' . $this->registry->userinfo['userid'];

				}else if($this->opt['orderhash']){

						$where = "vbcmsprodscard.orderhash = '" . $this->db->escape_string($this->opt['orderhash']) . "'";
				}else{
						$where = "vbcmsprodscard.orderhash = '" . $this->db->escape_string($this->registry->session->vars['dbsessionhash']) . "'";
				}

				$card = array();
				$currency = explode(' ', $this->registry->vbcmsoptions['productsarea_currency']);

				$card_quer = $this->db->query_read_slave("
						SELECT
						vbcmsprodscard.*, vbcmsprods.tax, vbcmsprods.weight, vbcmsprods.cost, vbcmsprods.additional AS additional_prod,
						vbcmsprods.catid, vbcmsprods.sptimestart, vbcmsprods.sptimeend, vbcmsprods.specialprice, vbcmsprods.prodtype,
						vbcmsprodslang.langtitle
						FROM " . TABLE_PREFIX . "vbcmsprodscard AS vbcmsprodscard
						LEFT JOIN " . TABLE_PREFIX . "vbcmsprods AS vbcmsprods ON (vbcmsprods.prodid = vbcmsprodscard.prodid)
						LEFT JOIN " . TABLE_PREFIX . "vbcmsprodslang AS vbcmsprodslang ON (vbcmsprodslang.prodid = vbcmsprodscard.prodid AND vbcmsprodslang.langid = " . $this->opt['langid'] . ")
						WHERE $where 
				");

				while($card_row = $this->db->fetch_array($card_quer))
				{
				        if($card_row['prodtype'] == 'normal')
				        {
				                $this->needshipping = true;
				        }
				        
						if(($card_row['sptimestart'] AND $card_row['sptimeend']) AND !(TIMENOW >= $card_row['sptimestart'] AND TIMENOW <= $card_row['sptimeend']))
						{
							   $card_row['special_active'] = false;
						}else{
							   $card_row['special_active'] = true;
						}

						if($card_row['specialprice'] > 0 AND $card_row['special_active'])
						{
						       $card_row['cost_original'] = $card_row['cost'];
							   $card_row['cost'] = $card_row['specialprice'];
						}				
				
						if($card_row['tax'] AND $needtax)
						{
						        $card['tax_original'] = $card_row['tax_original'] = $card_row['tax'];
						        
								if($card_row['tax'] < 10)
								{
									$card_row['tax'] = str_replace('.', '', $card_row['tax']);
									$card_row['tax'] = 0 . $card_row['tax'];
								}						
								
								$card_row['cost_tax'] = $card_row['cost'] * "0.{$card_row['tax']}";
						        $card['tax'] = $card_row['tax'];								
						}
						
						$card['counter']++;
                        $card['amount_counter'] += $card_row['amount'];
                        $card['prodname'] = $card_row['langtitle'];
						if($card_row['additional'])
						{
								$card_row['additional_prod'] = unserialize($card_row['additional_prod']);

								foreach(unserialize($card_row['additional']) AS $key => $value)
								{
										if(!is_array($value))
										{
												$card_row['additional_cost'] += $card_row['additional_prod'][$key]['price'][$value];
												if ($card_row['tax'] AND $needtax)
												{
													$card_row['additional_taxp'] = round($card_row['additional_prod'][$key]['price'][$value] * "0.{$card_row['tax']}", 2);
												}													
												$card_row['additional_desc'] .= $card_row['additional_prod'][$key]['desc'][$value][$vbcms_global['langid']] . ' ' . (($card_row['additional_prod'][$key]['price'][$value]) ? '+' . ($card_row['additional_prod'][$key]['price'][$value]+$card_row['additional_taxp']) . $currency[1] : '' ) . '<br />';

										}else{
												foreach($value AS $key2 => $value2)
												{
														$card_row['additional_cost'] += $card_row['additional_prod'][$key]['price'][$value2];
														if ($card_row['tax'] AND $needtax)
														{
															$card_row['additional_taxp'] = round($card_row['additional_prod'][$key]['price'][$value2] * "0.{$card_row['tax']}", 2);
														}						
														$card_row['additional_desc'] .= $card_row['additional_prod'][$key]['desc'][$value2][$vbcms_global['langid']] . ' ' . (($card_row['additional_prod'][$key]['price'][$value2]) ? '+' . ($card_row['additional_prod'][$key]['price'][$value2]+$card_row['additional_taxp']) . $currency[1] : '' ) . '<br />';
												}
										}
								}
								
								if ($card_row['tax'] AND $needtax)
						        {
									$card_row['additional_tax'] = $card_row['additional_cost'] * "0.{$card_row['tax']}";
								}
						}

						
                        /* TO DO Die Rabatte falls vorhanden berechnen
                        if(1)
                        {
                        }*/
                        
						$card_row['cost_width_add'] = vb_number_format(round(($card_row['cost'] + $card_row['additional_cost']), 2) * $card_row['amount'], 2);
						$card_row['cost_width_add_end'] = vb_number_format(round(($card_row['cost'] + $card_row['cost_tax'] + $card_row['additional_tax'] + $card_row['additional_cost']), 2) * $card_row['amount'], 2) ;
						
						$card_row['end_tax_end'] = vb_number_format(round(($card_row['cost_tax'] + $card_row['additional_tax']), 2) * $card_row['amount'], 2);

						if($this->showbasketbit)
						{
						        eval('$this->basketbit .= "' . fetch_template('Portal_products_basketbit') . '";');
						}
						
						$this->cardinfo_detail[$card_row['id']] = $card_row;
						
						$card['prods_kg'] +=  ($card_row['weight'] * $card_row['amount']);
						$card['end_tax'] += ($card_row['cost_tax'] + $card_row['additional_tax']) * $card_row['amount'];
						$card['end_cost_float'] += ($card_row['cost'] + $card_row['cost_tax'] + $card_row['additional_tax'] + $card_row['additional_cost']) * $card_row['amount'];
						$card['end_cost'] += round(($card_row['cost'] + $card_row['cost_tax'] + $card_row['additional_tax'] + $card_row['additional_cost']), 2) * $card_row['amount'];

				}
				$this->db->free_result($card_quer);
				$this->cardinfo = $card;
				$this->cardinfo['end_cost_float'] = $card['end_cost_float'];
				$this->cardinfo['end_tax_float'] = $card['end_tax'];	
                $this->cardinfo['end_tax'] = vb_number_format(round($card['end_tax'], 2), 2);
                $this->cardinfo['end_cost_num'] = $card['end_cost'];            
                $this->cardinfo['end_cost'] = vb_number_format(round($card['end_cost'], 2), 2);
				
				if(!$card['counter'])
				{
						return false;
				}else{
				        return true;
				}
        }
}

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # SVN: $RCSfile$ - $Revision: 1541 $
|| ####################################################################
\*======================================================================*/
?>