<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBCMS Version 2.7.0
|| # ------------------------------------------------------------------ # ||
|| # Copyright  2002 - 2009 Reuter & Bloe GbR.                          ||
|| # ------------------- VBCMS IS NOT FREE SOFTWARE ------------------- # ||
|| # http://www.vbdesigns.de | http://www.vbdesigns.de/license.html     # ||
|| ###################################################################### ||
\*========================================================================*/

if(!class_exists('vB_DataManager'))
{
        exit;
}
@ignore_user_abort(true);

/**
* Class to do data save/delete operations for vBCMS Products
*
* @package	vBCMS 2.7.0
* @version	$Revision: 1566 $
* @date		$Date: 2009-06-08 21:36:07 +0200 (Mo, 08. Jun 2009) $
*/
class vB_DataManager_vbcmsproduct_prods extends vB_DataManager
{
        /**
        * Array of recognised and required fields for vbcmsprods, and their types
        *
        * @var	array
        */
        var $validfields = array(
                'prodid'           => array(TYPE_UINT,       REQ_INCR,   VF_METHOD,  'verify_nonzero'),
                'number'           => array(TYPE_STR,        REQ_NO,     VF_METHOD),
                'position'         => array(TYPE_INT,        REQ_NO),
                'catid'            => array(TYPE_UINT,       REQ_YES,    VF_METHOD),
                'cost'             => array(TYPE_STR,        REQ_YES,    VF_METHOD,  'verify_pricestr'),
                'specialprice'     => array(TYPE_STR,        REQ_YES,    VF_METHOD,  'verify_pricestr'),
                'tax'              => array(TYPE_NOHTML,     REQ_YES),
                'additional'       => array(TYPE_ARRAY,      REQ_NO,     VF_METHOD),
                'timestart'        => array(TYPE_STR,        REQ_NO,     VF_METHOD,  'verify_timestr'),
                'timeend'          => array(TYPE_STR,        REQ_NO,     VF_METHOD,  'verify_timestr'),
                'sptimestart'      => array(TYPE_STR,        REQ_NO,     VF_METHOD,  'verify_timestr'),
                'sptimeend'        => array(TYPE_STR,        REQ_NO,     VF_METHOD,  'verify_timestr'),
                'licensenumber'    => array(TYPE_STR,        REQ_NO,     VF_METHOD),    // at the moment placeholder
                'prodtype'         => array(TYPE_STR,        REQ_NO),
                'fexpenses'        => array(TYPE_INT,        REQ_NO),
                'howcamp'          => array(TYPE_INT,        REQ_NO,     VF_METHOD,  'verify_pricestr'),
                'weight'           => array(TYPE_STR,        REQ_NO),
                'dlacc'            => array(TYPE_INT,        REQ_NO),
                'dlupdate'         => array(TYPE_INT,        REQ_NO),
                'dlupdateprice'    => array(TYPE_STR,        REQ_NO,     VF_METHOD,  'verify_pricestr'),
                'images'           => array(TYPE_ARRAY,      REQ_NO,     VF_METHOD),
                'files'            => array(TYPE_ARRAY,      REQ_NO,     VF_METHOD),
                'date'             => array(TYPE_INT,        REQ_AUTO),
                'userid'           => array(TYPE_INT,        REQ_AUTO),
                'ordercount'       => array(TYPE_INT,        REQ_NO),
                'html'             => array(TYPE_INT,        REQ_NO),
                'deliverytime'     => array(TYPE_NOHTML,     REQ_NO)
        );

        /**
        * Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
        * For example: var $bitfields = array('options' => 'bf_misc_useroptions', 'permissions' => 'bf_misc_moderatorpermissions')
        *
        * @var	array
        */
        var $bitfields = array();

        /**
        * The main table this class deals with
        *
        * @var	string
        */
        var $table = 'vbcmsprods';

        /**
        * Array to store stuff to save to vbcmslinkscats table
        *
        * @var	array
        */
        var $vbcmsprods = array();

        /**
        * Condition template for update query
        *
        * @var	array
        */
        var $condition_construct = array('prodid = %1$d', 'prodid');

        /**
        * Constructor - checks that the registry object has been passed correctly.
        *
        * @param	vB_Registry	Instance of the vBulletin data registry object - expected to have the database object as one of its $this->db member.
        * @param	integer		One of the ERRTYPE_x constants
        */
        function vB_DataManager_vbcmsproduct_prods(&$registry, $errtype = ERRTYPE_STANDARD)
        {
                parent::vB_DataManager($registry, $errtype);

                ($hook = vBulletinHook::fetch_hook('vbcms_prod_dmdata_start')) ? eval($hook) : false;
        }

        /**
        * Validates multiple titles an descriptions for the languages
        *
        * @param     array     with titleinfos
        * @param     array     with descriptioninfos
        *
        * @return	 boolean   Returns
        */
        function verify_inputlang_arrays(&$title)
        {
                global $vbcms_global;

                if(empty($title[$vbcms_global['langid']]))
                {
                        $this->error('l_add_error_title');
                        return false;
                }
                return true;
        }

        /**
        * Validates the articlenumber
        *
        * @param	string
        *
        * @return	boolean
        */
        function verify_number(&$number)
        {
                $number = htmlspecialchars_uni($number);
                return true;
        }

        /**
        * Validates upload images
        *
        * @param	array	$_FILES  images
        *
        * @return	boolean
        */
        function verify_images(&$uploadimages)
        {
                $thumbsize = $info = array();
                $thumbsize['width']  =& $this->registry->vbcmsoptions['productsarea_thumbwidth'];
                $thumbsize['height'] =& $this->registry->vbcmsoptions['productsarea_thumbheight'];

                $info['original_dir']      = '/original_images/';
                $info['thumbnail_dir']     = '/thumbnail_images/';
                $info['thumbnailname']     = 'thumb_';
                $info['existingid']        =& $this->existing['prodid'];

                //delete existing image from ajax request
                if($this->condition AND $this->info['delimages'])
                {

                       foreach(explode('|', $this->existing['images']) AS $value)
                       {
                               if($this->info['delimage'] != $value)
                               {
                                       $newstr[] = $value;
                               }
                       }

                       if(is_array($newstr))
                       {
                               $uploadimages = implode('|', $newstr);
                       }else{
                               $uploadimages = '';
                       }
                       if(@file_exists(DIR . $this->registry->vbcmsoptions['productsarea_savedir'] . $info['original_dir'] . $this->existing['prodid'] . $this->info['delimage']))
					   {
					           @unlink(DIR . $this->registry->vbcmsoptions['productsarea_savedir'] . $info['original_dir'] . $this->existing['prodid'] . $this->info['delimage']);
					   }
                       if(@file_exists(DIR . $this->registry->vbcmsoptions['productsarea_savedir'] . $info['thumbnail_dir'] . $this->existing['prodid'] . $info['thumbnailname'] . $this->info['delimage']))
					   {
					           @unlink(DIR . $this->registry->vbcmsoptions['productsarea_savedir'] . $info['thumbnail_dir'] . $this->existing['prodid'] . $info['thumbnailname'] . $this->info['delimage']);
					   }
                       return true;
                }

                $cou = 1;
                foreach($uploadimages['name'] AS $image)
                {
                        $temp['name'] = $uploadimages['name']["$cou"];
                        $temp['tmp_name'] = $uploadimages['tmp_name']["$cou"];
                        $cou++;

                        if(!empty($temp['name']))
                        {
                              $upload[] = vbcms_save_imgupload($temp, $this->fetch_field('catid', 'vbcmsprods'), 'products', $thumbsize, $this->registry->vbcmsoptions['productsarea_savedir'], $info);

                        }else{
                              continue;
                        }
                }

                if($this->condition AND is_array($upload))
                {
                        $update = implode('|', $upload);
                        $uploadimages = (!empty($this->existing['images'])) ? $this->existing['images'] . '|' . $update : $update;
                        return true;
                }

                if(is_array($upload))
                {
                        $uploadimages = implode('|', $upload);
                }else{
                        $uploadimages = (!empty($this->existing['images'])) ? $this->existing['images'] : '';
                }
                return true;
        }

         /**
        * Validates upload files for a download product
        *
        * @param	array	$_FILES  files
        *
        * @return	boolean
        */
        function verify_files(&$uploadfiles)
        {
                $info['existingid'] =& $this->existing['prodid'];
                
                if ($this->info['sfiles'])
                {
					if($this->condition AND is_array($uploadfiles))
					{
							$update = implode('|', $uploadfiles);
							$uploadfiles = (!empty($this->existing['files'])) ? $this->existing['files'] . '|' . $update : $update;
							return true;
					}
					$uploadfiles = implode('|', $uploadfiles);
                	return true;
                }

                if($this->condition AND $this->info['delfiles'])
                {
                       //delete existing image
                       foreach(explode('|', $this->existing['files']) AS $value)
                       {
                               if($this->info['delfile'] != $value)
                               {
                                       $newstr[] = $value;
                               }
                       }

                       if(is_array($newstr))
                       {
                               $uploadfiles = implode('|', $newstr);
                       }else{
                               $uploadfiles = '';
                       }

                       if(@file_exists(DIR . $this->registry->vbcmsoptions['productsarea_savedirfiles'] . $this->existing['prodid'] . $this->info['delfile']))
					   {
					           @unlink(DIR . $this->registry->vbcmsoptions['productsarea_savedirfiles'] . $this->existing['prodid'] . $this->info['delfile']);
					   }
                       return true;
                }

                foreach($uploadfiles['name'] AS $image)
                {
                        $temp['name'] = $uploadfiles['name']["$cou"];
                        $temp['tmp_name'] = $uploadfiles['tmp_name']["$cou"];
                        $cou++;

                        if(!empty($temp['name']))
                        {
                              $upload[] = vbcms_save_fileupload($temp, $this->fetch_field('catid', 'vbcmsprods'), 'products', $this->registry->vbcmsoptions['productsarea_savedirfiles'], $this->registry->vbcmsoptions['productsarea_fileupload_filetypes'], $info);

                        }else{
                              continue;
                        }
                }

                if($this->condition AND is_array($upload))
                {
                        $update = implode('|', $upload);
                        $uploadfiles = (!empty($this->existing['files'])) ? $this->existing['files'] . '|' . $update : $update;
                        return true;
                }

                if(is_array($upload))
                {
                        if($upload[0] == 'VBCMS_NOTALLOWEDFILETYPE')
                        {
                                $uploadfiles = '';
                        }else{
                                $uploadfiles = implode('|', $upload);
                        }
                }else{
                        $uploadfiles = (!empty($this->existing['files'])) ? $this->existing['files'] : '';
                }
                return true;
        }


        /**
        * Make a timestamp from a string
        *
        * @param	string
        *
        * @return	true
        */
        function verify_timestr(&$timestr)
        {
                $timestr = intval(vbcms_make_timestamp($timestr));
                return true;
        }

        /**
        * Replace , with . for decimal price
        *
        * @param	string
        *
        * @return	true
        */
        function verify_pricestr(&$pricestr)
        {
                $str = htmlspecialchars_uni(str_replace(',', '.', $pricestr));
                return true;
        }

        /**
        * Update counter, when we set the product in a other category
        *
        * @param	int 	catid
        *
        * @return	boolean
        */
        function verify_catid(&$catid)
        {
        		global $vbphrase;
                if($this->registry->vbcmsprodcats[$catid]['options'] & $this->registry->bf_misc_VBCMSPRODUCTOPTIONS['iscat'])
                {
                	echo $vbphrase['vbcms_prod_prodnotina_cat'];
                	exit;
                }

                if($this->condition AND $catid != $this->existing['catid'])
                {
                        $this->set_info('rebuild_counter', true);
                        $this->set_info('new_catid', $catid);
                }
                return true;
        }

        /**
        * Make the license superkey for a product
        *
        * @param	string
        *
        * @return	boolean
        */
        function verify_licensenumber(&$licensenumber)
        {
                // noting to do at the moment
                $licensenumber =& $licensenumber;
        }

        /**
        * Make a serialized string from the additional product options
        *
        * @param	array
        *
        * @return	boolean
        */
        function verify_additional(&$additional)
        {
                if($additional AND is_array($additional))
                {
                        $additional = serialize($additional);
                }else{
                        $additional = '';
                }
                return true;
        }

        /**
        * Any checks to run immediately before saving. If returning false, the save will not take place.
        *
        * @param	boolean	Do the query?
        *
        * @return	boolean	True on success; false if an error occurred
        */
        function pre_save($doquery = true)
        {
                if($this->presave_called !== null)
                {
                        return $this->presave_called;
                }

                $return_value = true;
                ($hook = vBulletinHook::fetch_hook('vbcms_prod_dmdata_presave')) ? eval($hook) : false;

                $this->presave_called = $return_value;

                if($this->fetch_field('date', 'vbcmsprods') === null)
                {
                        $this->set('date', TIMENOW);
                }

                if($this->fetch_field('userid', 'vbcmsprods') === null)
                {
                        $this->set('userid', $this->registry->userinfo['userid']);
                }

                return $return_value;
        }

        /**
        * Additional data to update after a save call (such as denormalized values in other tables).
        * In batch updates, is executed for each record updated.
        *
        * @param	boolean	Do the query?
        */
        function post_save_each($doquery = true)
        {
                // Nothing at the moment
                ($hook = vBulletinHook::fetch_hook('vbcms_prod_dmdata_postsave')) ? eval($hook) : false;
        }

        /**
        * Additional data to update after a save call (such as denormalized values in other tables).
        * In batch updates, is executed once after all records are updated.
        *
        * @param	boolean	Do the query?
        */
        function post_save_once($doquery = true)
        {
                $catdata =& datamanager_init('vbcmsproduct_cats', $this->registry);

                $catarr = array();
                $catarr = $this->dbobject->query_first_slave("
                        SELECT
                        c.*
                        FROM " . TABLE_PREFIX . "vbcmsprodcats AS c
                             WHERE  c.catid = " . $this->fetch_field('catid', 'vbcmsprods') . "
                ");
                if(!$this->condition)
                {
                        $catdata->set_existing($catarr);
                        $catdata->set_info('make_no_cache', true);
                        $catdata->set('prodcount', 'prodcount + 1', false);
                        $catdata->set('lastprodid', $this->fetch_field('prodid'));
                        $catdata->set('lastproddate', $this->fetch_field('date'));
                        $catdata->save();
                }

                if($this->info['rebuild_counter'])
                {
                        $this->rebuild_counter($this->existing['catid']);
                        $this->rebuild_counter($this->info['new_catid']);
                }
        }

        /**
        * rebuld the counters
        *
        * @param    int    categoryID
        */
        function rebuild_counter($catid)
        {
                $catarr = $prodcount = $proddate = array();

                $catarr    = $this->dbobject->query_first_slave("SELECT c.* FROM " . TABLE_PREFIX . "vbcmsprodcats AS c WHERE  c.catid = " . $catid . "");
                $prodcount = $this->dbobject->query_first_slave("SELECT COUNT(prodid) AS prods FROM " . TABLE_PREFIX . "vbcmsprods WHERE  catid = " . $catid . " ");
                $proddate  = $this->dbobject->query_first_slave("SELECT prodid, date FROM " . TABLE_PREFIX . "vbcmsprods WHERE  catid = " . $catid . " ORDER BY date DESC");

                $catdata =& datamanager_init('vbcmsproduct_cats', $this->registry);
				$catdata->set_existing($catarr);
				$catdata->set_info('make_no_cache', true);
				$catdata->set('prodcount', $prodcount['prods'], true, false);
				$catdata->set('lastprodid', $proddate['prodid'], true, false);
				$catdata->set('lastproddate', $proddate['date'], true, false);
                $catdata->save();

                return true;
        }

        /**
        * Save multiple titles an descriptions for the languages
        *
        * @param     array with titleinfos
        * @param     array with short descriptioninfos
        * @param     array with descriptioninfos
        * @param     int the insertid for insertquery
        */
        function save_language_arrays($title, $description, $message, $insertid = 0)
        {
                $queryset = $querywhere = $queryinto = $queryvalues = '';
                ($hook = vBulletinHook::fetch_hook('vbcms_prod_dmdata_language_start')) ? eval($hook) : false;

                if($this->condition)
                {
                        foreach($this->registry->languagecache AS $language)
                        {
                                if($havelang = $this->dbobject->query_first("SELECT * FROM " . TABLE_PREFIX . "vbcmsprodslang WHERE prodid = " . $this->fetch_field('prodid') . " AND langid = " . intval($language['languageid']) . ""))
                                {
                                        $this->dbobject->query_write("
                                                UPDATE " . TABLE_PREFIX . "vbcmsprodslang
                                                SET
                                                   langtitle = '" . $this->dbobject->escape_string($title["$language[languageid]"]) . "',
                                                   langdesc = '" . $this->dbobject->escape_string($description["$language[languageid]"]) . "',
                                                   langmessage = '" . $this->dbobject->escape_string($message["$language[languageid]"]) . "'
                                                $queryset
                                                WHERE prodid = " . $this->fetch_field('prodid') . " AND langid = " . intval($language['languageid']) . " $querywhere
                                        ");
                                }else{
                                        $this->dbobject->query_write("
                                                INSERT
                                                INTO " . TABLE_PREFIX . "vbcmsprodslang
                                                        (id, langtitle, langdesc, langmessage, langid, prodid $queryinto)
                                                VALUES
                                                        ('', '" . $this->dbobject->escape_string($title["$language[languageid]"]) . "', '" . $this->dbobject->escape_string($description["$language[languageid]"]) . "', '" . $this->dbobject->escape_string($message["$language[languageid]"]) . "', " . intval($language['languageid']) . ", " . intval($insertid) . ")
                                        ");
                                }
                        }
                }else{
                        foreach($this->registry->languagecache AS $language)
                        {
                                $lang_query[] = "('', '" . $this->dbobject->escape_string($title["$language[languageid]"]) . "', '" . $this->dbobject->escape_string($description["$language[languageid]"]) . "', '" . $this->dbobject->escape_string($message["$language[languageid]"]) . "', " . intval($language['languageid']) . ", " . intval($insertid) . " $queryvalues)";
                        }
                        // Build Language entrys
                        $this->dbobject->query_write("
                                INSERT
                                INTO " . TABLE_PREFIX . "vbcmsprodslang
                                      (id, langtitle, langdesc, langmessage, langid, prodid $queryinto)
                                VALUES
                                      " . implode(',', $lang_query) . "
                        ");
                }

                ($hook = vBulletinHook::fetch_hook('vbcms_prod_dmdata_language_end')) ? eval($hook) : false;

                return true;
        }

        /**
        * Deletes a products and its associated data from the database
        */
        function delete()
        {
			$prods = $this->dbobject->query_read("
					SELECT
					* FROM " . TABLE_PREFIX . "vbcmsprods
						WHERE " . $this->condition
			);

			$info['original_dir']      = '/original_images/';
			$info['thumbnail_dir']     = '/thumbnail_images/';
			$info['thumbnailname']     = 'thumb_';
                
        	while($prods_row = $this->registry->db->fetch_array($prods))
			{
				if ($prods_row['images'])
				{
					$prods_row['images_arr'] = explode('|', $prods_row['images']);
					
					foreach($prods_row['images_arr'] AS $val)
					{
                       if (@file_exists(DIR . $this->registry->vbcmsoptions['productsarea_savedir'] . $info['original_dir'] . $prods_row['prodid'] . $val))
					   {
					   		@unlink(DIR . $this->registry->vbcmsoptions['productsarea_savedir'] . $info['original_dir'] . $prods_row['prodid'] . $val);
					   }
                       if (@file_exists(DIR . $this->registry->vbcmsoptions['productsarea_savedir'] . $info['thumbnail_dir'] . $prods_row['prodid'] . $info['thumbnailname'] . $val))
					   {
					   		@unlink(DIR . $this->registry->vbcmsoptions['productsarea_savedir'] . $info['thumbnail_dir'] . $prods_row['prodid'] . $info['thumbnailname'] . $val);
					   }					
					}
				}
				
				if ($prods_row['files'])
				{
					$prods_row['files_arr'] = explode('|', $prods_row['files']);
					foreach($prods_row['files_arr'] AS $val)
					{
                       if(@file_exists(DIR . $this->registry->vbcmsoptions['productsarea_savedirfiles'] . $prods_row['prodid'] . $val))
					   {
					   		@unlink(DIR . $this->registry->vbcmsoptions['productsarea_savedirfiles'] . $prods_row['prodid'] . $val);
					   }					
					}
				}
				$prodids[] = $prods_row['prodid'];

			}
			if ($prodids)
			{
				$condition = implode(',', $prodids);
	
        		$this->db_delete(TABLE_PREFIX, $this->table, 'prodid IN ('. $condition .')');
        		$this->db_delete(TABLE_PREFIX, 'vbcmsprodslang', 'prodid IN ('. $condition .')');
        		$this->db_delete(TABLE_PREFIX, 'vbcmsprodsreviews', 'prodid IN ('. $condition .')');
        	}
        }
}

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # SVN: $RCSfile$ - $Revision: 1566 $
|| ####################################################################
\*======================================================================*/
?>