<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBCMS Version 2.7.0
|| # ------------------------------------------------------------------ # ||
|| # Copyright  2002 - 2009 Reuter & Bloe GbR.                          ||
|| # ------------------- VBCMS IS NOT FREE SOFTWARE ------------------- # ||
|| # http://www.vbdesigns.de | http://www.vbdesigns.de/license.html     # ||
|| ###################################################################### ||
\*========================================================================*/

if(!class_exists('vB_DataManager'))
{
        exit;
}

require_once(DIR . '/includes/adminfunctions.php');

/**
* Class to do data save/delete operations for vBCMS Linkscategories
*
* @package	vBCMS 2.7.0
* @version	$Revision: 1472 $
* @date		$Date: 2009-04-02 15:42:43 +0200 (Do, 02. Apr 2009) $
*/
class vB_DataManager_vbcmsproduct_cats extends vB_DataManager
{
        /**
        * Array of recognised and required fields for vbcmslinkscats, and their types
        *
        * @var	array
        */
        var $validfields = array(
                'catid'            => array(TYPE_UINT,       REQ_INCR,  VF_METHOD, 'verify_nonzero'),
                'styleid'          => array(TYPE_INT,        REQ_NO,    'if ($data == 0) { $data = 0; } return true;'),
                'options'          => array(TYPE_ARRAY_BOOL, REQ_AUTO),
                'position'         => array(TYPE_INT,        REQ_NO),
                'prodcount'        => array(TYPE_INT,        REQ_NO),
                'lastprodid'       => array(TYPE_INT,        REQ_NO),
                'lastproduserid'   => array(TYPE_INT,        REQ_NO),
                'lastprodusername' => array(TYPE_STR,        REQ_NO),
                'lastprodtitle'    => array(TYPE_STR,        REQ_NO),
                'lastproddate'     => array(TYPE_INT,        REQ_NO),
                'pollcount'        => array(TYPE_INT,        REQ_NO),
                'lastpollid'       => array(TYPE_INT,        REQ_NO),
                'lastpollprodid'   => array(TYPE_INT,        REQ_NO),
                'lastpolltitle'    => array(TYPE_STR,        REQ_NO),
                'lastpolluserid'   => array(TYPE_INT,        REQ_NO),
                'lastpollusername' => array(TYPE_STR,        REQ_NO),
                'lastpolldate'     => array(TYPE_INT,        REQ_NO),
                'neworderemail'    => array(TYPE_STR,        REQ_NO,    VF_METHOD, 'verify_emaillist'),
                'sub'              => array(TYPE_INT,        REQ_NO,    VF_METHOD),
                'parent'           => array(TYPE_STR,        REQ_NO),
                'breads'           => array(TYPE_STR,        REQ_NO),
                'catpic'           => array(TYPE_STR,        REQ_NO),
                'catpicnav'        => array(TYPE_STR,        REQ_NO)
        );

        /**
        * Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
        * For example: var $bitfields = array('options' => 'bf_misc_useroptions', 'permissions' => 'bf_misc_moderatorpermissions')
        *
        * @var	array
        */
        var $bitfields = array('options' => 'bf_misc_VBCMSPRODUCTOPTIONS');

        /**
        * The main table this class deals with
        *
        * @var	string
        */
        var $table = 'vbcmsprodcats';

        /**
        * Array to store stuff to save to vbcmslinkscats table
        *
        * @var	array
        */
        var $vbcmsprodcats = array();

        /**
        * Condition template for update query
        *
        * @var	array
        */
        var $condition_construct = array('catid = %1$d', 'catid');

        /**
        * Constructor - checks that the registry object has been passed correctly.
        *
        * @param	vB_Registry	Instance of the vBulletin data registry object - expected to have the database object as one of its $this->db member.
        * @param	integer		One of the ERRTYPE_x constants
        */
        function vB_DataManager_vbcmsproduct_cats(&$registry, $errtype = ERRTYPE_STANDARD)
        {
                parent::vB_DataManager($registry, $errtype);

                ($hook = vBulletinHook::fetch_hook('vbcms_prodcat_dmdata_start')) ? eval($hook) : false;
        }

        /**
        * Validates multiple titles an descriptions for the languages
        *
        * @param     array     with titleinfos
        * @param     array     with descriptioninfos
        *
        * @return	 boolean   Returns
        */
        function verify_inputlang_arrays(&$title)
        {
                global $vbcms_global;

                if(empty($title[$vbcms_global['langid']]))
                {
                        $this->error('l_add_error_title');
                        return false;
                }
                return true;
        }

        /**
        * Validates a space-separated list of email addresses, prevents duplicates etc.
        *
        * @param	string	Whitespace-separated list of email addresses
        *
        * @return	boolean
        */
        function verify_emaillist(&$emails)
        {
                $emaillist = array();

                foreach(preg_split('#\s+#s', $emails, -1, PREG_SPLIT_NO_EMPTY) AS $email)
                {
                        if ($this->verify_email($email))
                        {
                                $emaillist["$email"] = $email;
                        }
                }

                $emails = implode(' ', $emaillist);

                return true;
        }

        /**
        * Verifies that the parent category specified exists and is a valid parent for this category
        *
        * @param	integer	Parent category ID
        *
        * @return	boolean	Returns true if the parent id is valid, and the parent forum specified exists
        */
        function verify_sub(&$parentid)
        {
                if($parentid AND $parentid == $this->fetch_field('catid'))
                 {
                         $this->error('vbcms_cant_cat_to_self');
                         return false;
 
                 }else if($parentid == 0){
 
                         $parentid = 0;
                         return true;
 
                 }else if($this->condition !== null){
 
                         return $this->is_subcat_of($this->fetch_field('catid'), $parentid);
                 }else{
 
                         return true;
                }
        }

        /**
        * Verifies that a given category parent id is not one of its own children
        *
        * @param	integer	The ID of the current category
        * @param	integer	The ID of the category's proposed parentid
        *
        * @return	boolean	Returns true if the children of the given parent category does not include the specified forum... or something
        */
        function is_subcat_of($catid, $parentid)
        {
                $cache = $this->dbobject->query_first_slave("
                        SELECT
                        parent
                        FROM " . TABLE_PREFIX . "vbcmsprodcats
                             WHERE catid = " . $catid . "
                ");

                if(in_array($parentid, explode(',' , $cache['parent'])))
                {
                        $this->error('vbcms_cant_cat_to_child');
                        return false;
                }
                return true;
        }

        /**
        * Any checks to run immediately before saving. If returning false, the save will not take place.
        *
        * @param	boolean	Do the query?
        *
        * @return	boolean	True on success; false if an error occurred
        */
        function pre_save($doquery = true)
        {
                if($this->presave_called !== null)
                {
                        return $this->presave_called;
                }

                $return_value = true;
                ($hook = vBulletinHook::fetch_hook('vbcms_linkdata_presave')) ? eval($hook) : false;

                $this->presave_called = $return_value;
                return $return_value;
        }

        /**
        * Additional data to update after a save call (such as denormalized values in other tables).
        * In batch updates, is executed for each record updated.
        *
        * @param	boolean	Do the query?
        */
        function post_save_each($doquery = true)
        {
                // Nothing at the moment

                ($hook = vBulletinHook::fetch_hook('vbcms_prodcat_dmdata_postsave')) ? eval($hook) : false;
        }

        /**
        * Additional data to update after a save call (such as denormalized values in other tables).
        * In batch updates, is executed once after all records are updated.
        *
        * @param	boolean	Do the query?
        */
        function post_save_once($doquery = true)
        {
                if(empty($this->info['update_parents']))
                {
                        $this->update_parents();
                }
        }

        /**
        * Save multiple titles an descriptions for the languages
        *
        * @param     array with titleinfos
        * @param     array with descriptioninfos
        * @param     int the insertid for insertquery
        */
        function save_language_arrays($title, $description, $insertid = 0)
        {
                $queryset = $querywhere = $queryinto = $queryvalues = '';
                ($hook = vBulletinHook::fetch_hook('vbcms_prodcat_dmdata_language_start')) ? eval($hook) : false;

                if($this->condition)
                {
                        foreach($this->registry->languagecache AS $language)
                        {
                                if($havelang = $this->dbobject->query_first("SELECT * FROM " . TABLE_PREFIX . "vbcmsprodcatslang WHERE prodcatid = " . $this->fetch_field('catid') . " AND langid = " . intval($language['languageid']) . ""))
                                {
                                        $this->dbobject->query_write("
                                                UPDATE " . TABLE_PREFIX . "vbcmsprodcatslang
                                                SET
                                                   langtitle = '" . $this->dbobject->escape_string(convert_to_valid_html($title["$language[languageid]"])) . "',
                                                   langdesc = '" . $this->dbobject->escape_string(convert_to_valid_html($description["$language[languageid]"])) . "'
                                                $queryset
                                                WHERE prodcatid = " . $this->fetch_field('catid') . " AND langid = " . intval($language['languageid']) . " $querywhere
                                        ");
                                }else{
                                        $this->dbobject->query_write("
                                                INSERT
                                                INTO " . TABLE_PREFIX . "vbcmsprodcatslang
                                                        (id, langtitle, langdesc, langid, prodcatid $queryinto)
                                                VALUES
                                                        ('', '" . $this->dbobject->escape_string(convert_to_valid_html($title["$language[languageid]"])) . "', '" . $this->dbobject->escape_string(convert_to_valid_html($description["$language[languageid]"])) . "', " . intval($language['languageid']) . ", " . intval($insertid) . ")
                                        ");
                                }
                        }
                }else{
                        foreach($this->registry->languagecache AS $language)
                        {
                                $lang_query[] = "('', '" . $this->dbobject->escape_string(convert_to_valid_html($title["$language[languageid]"])) . "', '" . $this->dbobject->escape_string(convert_to_valid_html($description["$language[languageid]"])) . "', " . intval($language['languageid']) . ", " . intval($insertid) . " $queryvalues)";
                        }
                        // Build Language entrys
                        $this->dbobject->query_write("
                                INSERT
                                INTO " . TABLE_PREFIX . "vbcmsprodcatslang
                                      (id, langtitle, langdesc, langid, prodcatid $queryinto)
                                VALUES
                                      " . implode(',', $lang_query) . "
                        ");
                }

                ($hook = vBulletinHook::fetch_hook('vbcms_prodcat_dmdata_language_end')) ? eval($hook) : false;

                if(empty($this->info['make_no_cache']))
                {
                        $this->cache_prodcategorys();
                }

                return true;
        }

        /**
        * Cache the catgories as a serialized string in the datastore table.
        *
        */
        function cache_prodcategorys()
        {
                $cache         = array();
                $lang_row      = array();
                $lang_row_desc = array();

                $l_query = $this->dbobject->query_read_slave("
                       SELECT
                       langid, prodcatid, langtitle, langdesc
                       FROM " . TABLE_PREFIX . "vbcmsprodcatslang
                ");

                while($l_row = $this->dbobject->fetch_array($l_query))
                {
                        $lang_row["$l_row[prodcatid]"]["$l_row[langid]"] = $l_row['langtitle'];
                        $lang_row_desc["$l_row[prodcatid]"]["$l_row[langid]"] = $l_row['langdesc'];
                }
                $this->dbobject->free_result($l_query);

                $link_quer = $this->dbobject->query_read("
                        SELECT
                        catid, sub, parent, breads, styleid, position, options, neworderemail, catpicnav
                        FROM " . TABLE_PREFIX . "vbcmsprodcats
                        ORDER BY position ASC
                ");

                while($link_row = $this->dbobject->fetch_array($link_quer))
                {
                        if($lang_row["$link_row[catid]"])
                        {
                                $link_row['langtitle'] = $lang_row["$link_row[catid]"];
                                $link_row['langdesc']  = $lang_row_desc["$link_row[catid]"];
                        }

                        $cache["$link_row[catid]"] = $link_row;
                }
                $this->dbobject->free_result($link_quer);
                build_datastore('vbcmsprodcats', serialize($cache), 1);
        }

        /**
        * Updtate the parentfield
        *
        */
        function update_parents()
        {
                global $parent, $breads;

                $subs = array();
                $subs_quer = $this->dbobject->query_read_slave("
                        SELECT
                        *
                        FROM " . TABLE_PREFIX . "vbcmsprodcats
                ");

                while($subs_row = $this->dbobject->fetch_array($subs_quer))
                {
                        $subs[] = $subs_row;
                }
                $this->dbobject->free_result($subs_quer);

                if($subs[0])
                {
                        foreach($subs AS $key)
                        {
                                $parent = $breads = array();
                                $parent[] = $breads[] = $key['catid'];
                                $this->make_rekursive($subs, $key['catid']);
                                $this->make_breads($subs, $key['sub']);
                                $parent = array_unique($parent);
                                $setparent = implode(',', $parent);
                                $setbreads = implode(',', $breads);
                                $parentsql .= "WHEN $key[catid] THEN '$setparent'\n";
                                $breadssql .= "WHEN $key[catid] THEN '$setbreads'\n";
                        }

                        $this->dbobject->query_write("
                                UPDATE " . TABLE_PREFIX . "vbcmsprodcats SET
                                parent = CASE catid
                                     $parentsql
		        	        	ELSE parent
                                END
                        ");

                        $this->dbobject->query_write("
                                UPDATE " . TABLE_PREFIX . "vbcmsprodcats SET
                                breads = CASE catid
                                     $breadssql
		        	        	ELSE breads
                                END
                        ");
                }
        }

        /**
        * Recursive function to sort the parents
        *
        * @param	int     for the key
        * @param    int     for linkid
        *
        * @return   array   with options
        */
        function make_rekursive($each, $linkid)
        {
                global $parent;
                foreach($each AS $sub)
                {
                        if($sub['sub'] == $linkid)
                        {
                                $parent[] = $sub['catid'];
                                $parent = array_merge($parent, explode(',',$sub['parent']));
                                $this->make_rekursive($each, $sub['parent']);
                        }
                }
                return $parent;
        }
        /**
        * Recursive function to sort the breads
        *
        * @param	int     for the key
        * @param    int     for linkid
        *
        * @return   array   with options
        */
        function make_breads($each, $linkid)
        {
                global $breads;
                foreach($each AS $sub)
                {
                        if($sub['catid'] == $linkid)
                        {
                                $breads[] = $sub['catid'];
                                $this->make_breads($each, $sub['sub']);
                        }
                }
                return $breads;
        }
        /**
        * Deletes a category and its associated data from the database
        */
        function delete()
        {
                $categorys = array();
                $categorys = $this->dbobject->query_first("
                        SELECT
                        parent FROM " . TABLE_PREFIX . "vbcmsprodcats
                            WHERE " . $this->condition
                );

                $categorys = $categorys['parent'];

                if(empty($categorys))
                {
                         $this->error('vbcms_invalid_catid_specifed');
                }else{

                         $condition = "catid IN ($categorys)";
                         $condition_language = "prodcatid IN ($categorys)";


                         $this->db_delete(TABLE_PREFIX, 'vbcmsprodcatslang', $condition_language);
                         $this->db_delete(TABLE_PREFIX, 'vbcmsprodcats', $condition);
                         
        				 $prod =& datamanager_init('vbcmsproduct_prods', $this->registry);
        				 $prod->set_condition($condition);
        				 $prod->delete();
        				 
                         $this->cache_prodcategorys();
                         ($hook = vBulletinHook::fetch_hook('vbcms_prodcat_dmdata_delete')) ? eval($hook) : false;
                }
        }
}

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # SVN: $RCSfile$ - $Revision: 1472 $
|| ####################################################################
\*======================================================================*/
?>