<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBCMS Version 2.7.0
|| # ------------------------------------------------------------------ # ||
|| # Copyright  2002 - 2009 Reuter & Bloe GbR.                          ||
|| # ------------------- VBCMS IS NOT FREE SOFTWARE ------------------- # ||
|| # http://www.vbdesigns.de | http://www.vbdesigns.de/license.html     # ||
|| ###################################################################### ||
\*========================================================================*/

if(!class_exists('vB_DataManager'))
{
        exit;
}

require_once(DIR . '/includes/adminfunctions.php');

/**
* Class to do data save/delete operations for vBCMS Linkscategory Moderators
*
* @package	vBCMS 2.7.0
* @version	$Revision: 638 $
* @date		$Date: 2007-07-24 14:28:32 +0200 (Di, 24. Jul 2007) $
*/
class vB_DataManager_vbcmslinks_permissions extends vB_DataManager
{
        /**
        * Array of recognised and required fields for vbcmslinkscats, and their types
        *
        * @var	array
        */
        var $validfields = array(
                'catpermid'        => array(TYPE_UINT,       REQ_INCR, VF_METHOD, 'verify_nonzero'),
                'usergroupid'      => array(TYPE_INT,        REQ_YES,  VF_METHOD),
                'catid'            => array(TYPE_INT,        REQ_YES,  VF_METHOD),
                'perms'            => array(TYPE_ARRAY_BOOL, REQ_YES,  VF_METHOD)
        );

        /**
        * Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
        * For example: var $bitfields = array('options' => 'bf_misc_useroptions', 'permissions' => 'bf_misc_moderatorpermissions')
        *
        * @var	array
        */
        var $bitfields = array('perms' => 'bf_ugp_vbcmslinkscatspermissions');

        /**
        * The main table this class deals with
        *
        * @var	string
        */
        var $table = 'vbcmslinksperms';

        /**
        * Array to store stuff to save to vbcmslinkscats table
        *
        * @var	array
        */
        var $vbcmslinksperms = array();

        /**
        * Condition template for update query
        *
        * @var	array
        */
        var $condition_construct = array('catpermid = %1$d', 'catpermid');

        /**
        * Constructor - checks that the registry object has been passed correctly.
        *
        * @param	vB_Registry	Instance of the vBulletin data registry object - expected to have the database object as one of its $this->db member.
        * @param	integer		One of the ERRTYPE_x constants
        */
        function vB_DataManager_vbcmslinks_permissions(&$registry, $errtype = ERRTYPE_STANDARD)
        {
                parent::vB_DataManager($registry, $errtype);

                ($hook = vBulletinHook::fetch_hook('vbcms_linkmoderatorsdata_start')) ? eval($hook) : false;
        }
        /**
        * Verify that the category exist
        *
        * @param    integer ID of the catid
        *
        * @return	boolean	Returns true on success
        */
        function verify_catid(&$catid)
        {
                if(empty($catid))
                {
                        $this->error('vbcms_cat_is_invalid');
                        return false;
                }
                if(isset($this->registry->vbcmslinkscat["$catid"]))
		        {
                        return true;
                }else{
                        $this->error('vbcms_cat_is_invalid');
                        return false;
                }
        }

        /**
        * Verify that the user exist
        *
        * @param    integer ID of the usergroupid
        *
        * @return	boolean	Returns true on success
        */
        function verify_usergroupid(&$userid)
        {
                if(empty($userid))
                {
                        $this->error('vbcms_no_user_set');
                        return false;
                }
                return true;
        }
        /**
        * Converts an array of 1/0 options into the perms bitfield
        *
        * @param	array
        *
        * @return	boolean	Returns true on success
        */
        function verify_perms(&$perms)
        {
                require_once(DIR . '/includes/functions_misc.php');
                return $permissions = convert_array_to_bits($perms, $this->registry->bf_ugp_vbcmslinkscatspermissions);
        }
        /**
        * Any checks to run immediately before saving. If returning false, the save will not take place.
        *
        * @param	boolean	Do the query?
        *
        * @return	boolean	True on success; false if an error occurred
        */
        function pre_save($doquery = true)
        {
                if($this->presave_called !== null)
                {
                        return $this->presave_called;
                }
                $return_value = true;
                ($hook = vBulletinHook::fetch_hook('vbcms_linkmoderatorsdata_presave')) ? eval($hook) : false;

                $this->presave_called = $return_value;
                return $return_value;
        }

        /**
        * Additional data to update after a save call (such as denormalized values in other tables).
        * In batch updates, is executed for each record updated.
        *
        * @param	boolean	Do the query?
        */
        function post_save_each($doquery = true)
        {
                $this->cache_vbcms_permissions();
                ($hook = vBulletinHook::fetch_hook('vbcms_linkmoderatorsdata_postsave')) ? eval($hook) : false;
        }

        /**
        * Additional data to update after a save call (such as denormalized values in other tables).
        * In batch updates, is executed once after all records are updated.
        *
        * @param	boolean	Do the query?
        */
        function post_save_once($doquery = true)
        {
                // Nothing at moment
        }

        /**
        * Makes the permissioncache in the datastore table
        */
        function cache_vbcms_permissions()
        {
                $cache = array();
                $mod_quer = $this->dbobject->query_read("
                        SELECT
                        *
                        FROM " . TABLE_PREFIX . "vbcmslinksperms
                ");

                while($mod_row = $this->dbobject->fetch_array($mod_quer))
                {
                      $cache["$mod_row[catid]"]["$mod_row[usergroupid]"] = $mod_row['perms'];
                }
                $this->dbobject->free_result($mod_quer);
                build_datastore('vbcmslinksperms', serialize($cache), 1);
        }

        /**
        * Deletes a category and its associated data from the database
        */
        function delete($condition)
        {
                $this->dbobject->query_first("
                        DELETE FROM " . TABLE_PREFIX . "vbcmslinksperms
                            WHERE $condition
                ");
                $this->cache_vbcms_permissions();

                ($hook = vBulletinHook::fetch_hook('vbcms_linkdata_delete')) ? eval($hook) : false;
        }
}

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # SVN: $RCSfile$ - $Revision: 638 $
|| ####################################################################
\*======================================================================*/
?>