<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBCMS Version 2.7.0
|| # ------------------------------------------------------------------ # ||
|| # Copyright  2002 - 2009 Reuter & Bloe GbR.                          ||
|| # ------------------- VBCMS IS NOT FREE SOFTWARE ------------------- # ||
|| # http://www.vbdesigns.de | http://www.vbdesigns.de/license.html     # ||
|| ###################################################################### ||
\*========================================================================*/

error_reporting(E_ALL & ~E_NOTICE & ~8192);

define('GET_EDIT_TEMPLATES', true);

define('CVS_REVISION', '$RCSfile: vbcms_admin.php,v $ - $Revision: 1600 $');

if(function_exists('set_time_limit') AND ini_get('safe_mode') == '')
{
	@set_time_limit(0);
}

$phrasegroups = array(
        'portal_phrase',
        'threadmanage',
        'posting',
        'cphome',
        'timezone',
        'cpoption',
        'user',
        'cpuser',
        'holiday',
        'cppermission',
        'forum',
        'cpglobal',
        'portal_manag'
);

$specialtemplates = array(
        'smiliecache',
        'bbcodecache',
        'vbcmsoptions',
        'vbcmsportal',
        'vbcmsareas'
);

require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_vbcms.php');
require_once(DIR . '/includes/adminfunctions_template.php');
require_once(DIR . '/includes/adminfunctions_options.php');

if(!can_administer('canadminsettings'))
{
        print_cp_no_permission();
}
log_admin_action();

if (empty($_REQUEST['do']))
{
        $_REQUEST['do'] = 'default';
}

// =================[ Global needed variables ]============================

$vbulletin->input->clean_array_gpc('r', array(
        'varname' => TYPE_STR,
        'dogroup' => TYPE_STR,
));

$settingphrase = array();
$phrases = $db->query_read("
        SELECT
        varname, text
        FROM " . TABLE_PREFIX . "phrase
        WHERE fieldname = 'vbsettings'
             AND languageid IN(-1, 0, " . LANGUAGEID . ")
        ORDER BY languageid ASC
");
while($phrase = $db->fetch_array($phrases))
{
        $settingphrase["$phrase[varname]"] = $phrase['text'];
}
$db->free_result($phrases);
require_once(DIR . '/includes/class_bitfield_builder.php');

if(vB_Bitfield_Builder::build(false) !== false)
{
        $fetch_bitfields =& vB_Bitfield_Builder::init();
        if(sizeof($fetch_bitfields->datastore_total['ugp']) != sizeof($vbulletin->bf_ugp))
        {
                $fetch_bitfields->save($db);
                build_forum_permissions();
                define('CP_REDIRECT', $vbulletin->scriptpath);
                print_stop_message('rebuilt_bitfields_successfully');
        }
}else{
        echo "<strong>error</strong>\n";
        print_r(vB_Bitfield_Builder::fetch_errors());
}

// =================[ XML import module ]==================

if($_POST['do'] == 'upload_modulexml')
{
        $vbulletin->input->clean_array_gpc('p', array(
                'serverfile'       => TYPE_STR,
                'restore'          => TYPE_BOOL,
                'moduloverride'    => TYPE_BOOL,
                'templateoverride' => TYPE_BOOL,
                'settingsoverride' => TYPE_BOOL,
                'addfile'          => TYPE_BOOL,
                'activateareas'    => TYPE_BOOL
        ));

        $vbulletin->input->clean_array_gpc('f', array(
                'modulefile' => TYPE_FILE
        ));

        if(is_demo_mode())
        {
                print_cp_message('This function is disabled within demo mode');
        }
        // got an uploaded file?
        if(file_exists($vbulletin->GPC['modulefile']['tmp_name']))
        {
                $xml = file_read($vbulletin->GPC['modulefile']['tmp_name']);
                $name = $vbulletin->GPC['modulefile']['name'];

        }else if(file_exists($vbulletin->GPC['serverfile'])){

                $xml = file_read($vbulletin->GPC['serverfile']);
                $name = $vbulletin->GPC['serverfile'];
        }else{
                print_stop_message('no_file_uploaded_and_no_local_file_found');
        }

        xml_module_import($xml, $vbulletin->GPC['moduloverride'], $vbulletin->GPC['settingsoverride'], $vbulletin->GPC['templateoverride'], $vbulletin->GPC['addfile'], false, $vbulletin->GPC['activateareas']);

        define('CP_REDIRECT', 'vbcms_admin.php?do=editmodules#modul_position');
        print_stop_message('vbcms_x_import', $name);
}

// =================[ XML export module ]==================

if($_POST['do'] == 'download_modulexml')
{
        if(is_demo_mode())
        {
                print_cp_message('This function is disabled within demo mode');
        }

        $vbulletin->input->clean_array_gpc('p', array(
                'modulename'    => TYPE_STR,
                'template'      => TYPE_BOOL,
                'settings'      => TYPE_BOOL,
                'php_code'      => TYPE_BOOL,
        ));

        // make many arrays of infos we need
        $grouparray = array();
        $settinggroups = $db->query_read("
                SELECT
                *
                FROM " . TABLE_PREFIX . "vbcmssettinggroups
        ");
        while($groups_row = $db->fetch_array($settinggroups))
        {
                $grouparray["$groups_row[grouptitle]"] = $groups_row;
        }

        $setarray = array();
        $settings_query = $db->query_read("
                SELECT
                *
                FROM " . TABLE_PREFIX . "vbcmssettings
        ");
        while($settings_row = $db->fetch_array($settings_query))
        {
                $setarray["$settings_row[grouptitle]"]["$settings_row[varname]"] = $settings_row;
        }

        $temparray = array();
        $temp_query = $db->query_read("
                SELECT
                title, templatetype, dateline, version, username, template_un
                FROM " . TABLE_PREFIX . "template
                WHERE title LIKE 'Portal_%'
        ");
        while($temp_row = $db->fetch_array($temp_query))
        {
                $temparray["$temp_row[title]"][] = $temp_row;
        }

        // Start to generate the xml file
        require_once(DIR . '/includes/class_xml.php');
        $xml = new vB_XML_Builder($vbulletin);

        $xml->add_group('modules', array('product' => 'vbcms'));

        sort($vbulletin->vbcmsportal);

        foreach($vbulletin->vbcmsportal AS $modulid => $modul)
        {
	            if(($vbulletin->GPC['modulename'] == $modul['modulname']) OR (!$vbulletin->GPC['modulename']))
	            {
                        // Modules
                        $xml->add_group('modul',
                                array(
                                        'id' => $modul['id'],
                                        'name' => $modul['name'],
                                        'modulname' => $modul['modulname'],
                                        'moduletype' => $modul['moduletype'],
                                        'colum' => $modul['colum'],
                                        'position' => $modul['position'],
                                        'active' => $modul['active'],
                                        'user_groups' => $modul['user_groups'],
                                        'templates' => $modul['template'],
                                        'buffer' => $modul['buffer'],
                                        'htmlbbcodes' => $modul['htmlbbcodes']
                                )
                        );

                        $xml->add_tag('modulebbcode', $modul['modulebbcode']);

                        // Setting an settinggroups
                        if($vbulletin->GPC['settings'])
                        {
                                if($grouparray["$modul[modulname]"])
                                {
                                        $xml->add_group('settinggroup', array('name' => $modul['modulname'], 'display' => $grouparray["$modul[modulname]"]['display']));
                                        $xml->add_tag('settinggroup_phrase',  $settingphrase['settinggroup_' . $modul['modulname']]);
                                        foreach($setarray["$modul[modulname]"] AS $set => $setting)
                                        {
                                                $xml->add_group('setting', array('varname' => $setting['varname']));
                                                $xml->add_tag('grouptitle', $setting['grouptitle']);
                                                $xml->add_tag('value', $setting['value']);
                                                $xml->add_tag('defaultvalue', $setting['defaultvalue']);
                                                $xml->add_tag('optioncode', $setting['optioncode']);
                                                $xml->add_tag('displayorder', $setting['displayorder']);
                                                $xml->add_tag('volatile', $setting['volatile']);
                                                $xml->add_tag('product', $setting['product']);
                                                $xml->add_tag('phrase_desc', $settingphrase['setting_' . $setting['varname'] . '_desc']);
                                                $xml->add_tag('phrase_title', $settingphrase['setting_' . $setting['varname'] . '_title']);
                                                $xml->close_group();
                                        }
                                        $xml->close_group();
                                }
                        }

                        // Templates
                        if($vbulletin->GPC['template'])
                        {
                                foreach(explode(',', $modul['template']) AS $key => $templ)
                                {
                                        if($temparray["$templ"])
                                        {
                                                foreach($temparray["$templ"] AS $temps)
                                                {
                                                        $xml->add_group('template',
                                                                array(
                                                                        'name' => $temps['title'],
                                                                        'templatetype' => $temps['templatetype'],
                                                                        'date' => $temps['dateline'],
                                                                        'username' => $temps['username'],
                                                                        'version' => $temps['version']
                                                                )
                                                        );
                                                                $xml->add_tag('template_un', $temps['template_un']);
                                                        $xml->close_group();
                                                }

                                        }
                                }
                        }

                        if($vbulletin->GPC['php_code'])
                        {
                                $php_code = @file_get_contents(DIR . '/vbcms_global_modules/' . $modul['modulname'] . '.php');
                                $xml->add_group('file', array('filename' => $modul['modulname']));
                                        $xml->add_tag('file_content', $php_code);
                                $xml->close_group();
                        }
                        $xml->close_group();
                }
        }

        $xml->close_group();

        $doc = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\r\n\r\n";

        $doc .= $xml->output();
        $xml = null;

        require_once(DIR . '/includes/functions_file.php');
        file_download($doc, iif($vbulletin->GPC['modulename'], $vbulletin->GPC['modulename'] . '.xml', 'vbcms_modules.xml'), 'text/xml');
}

// =================[ XML import module ]==================

if($_POST['do'] == 'upload_areaxml')
{
        $vbulletin->input->clean_array_gpc('p', array(
                'serverfile'       => TYPE_STR,
                'restore'          => TYPE_BOOL,
                'areaoverride'     => TYPE_BOOL,
                'templateoverride' => TYPE_BOOL,
                'settingsoverride' => TYPE_BOOL,
                'addfile'          => TYPE_BOOL
        ));

        $vbulletin->input->clean_array_gpc('f', array(
                'areafile' => TYPE_FILE
        ));

        if(is_demo_mode())
        {
                print_cp_message('This function is disabled within demo mode');
        }

        if(file_exists($vbulletin->GPC['areafile']['tmp_name']))
        {
                $xml = file_read($vbulletin->GPC['areafile']['tmp_name']);
                $name = $vbulletin->GPC['areafile']['name'];

        }else if(file_exists($vbulletin->GPC['serverfile'])){

                $xml = file_read($vbulletin->GPC['serverfile']);
                $name = $vbulletin->GPC['serverfile'];
        }else{
                print_stop_message('no_file_uploaded_and_no_local_file_found');
        }

        xml_area_import($xml, $vbulletin->GPC['areaoverride'], $vbulletin->GPC['settingsoverride'], $vbulletin->GPC['templateoverride'], $vbulletin->GPC['addfile']);

        define('CP_REDIRECT', 'vbcms_admin.php?do=editareas');
        print_stop_message('vbcms_x_import', $name);
}

// =================[ XML export module ]==================

if($_POST['do'] == 'download_areaxml')
{
        if(is_demo_mode())
        {
                print_cp_message('This function is disabled within demo mode');
        }

        $vbulletin->input->clean_array_gpc('p', array(
                'areaname'      => TYPE_STR,
                'template'      => TYPE_BOOL,
                'settings'      => TYPE_BOOL,
                'php_code'      => TYPE_BOOL,
        ));

        // make many arrays of infos we need
        $grouparray = array();
        $settinggroups = $db->query_read("
                SELECT
                *
                FROM " . TABLE_PREFIX . "vbcmssettinggroups
        ");
        while($groups_row = $db->fetch_array($settinggroups))
        {
                $grouparray["$groups_row[grouptitle]"] = $groups_row;
        }

        $setarray = array();
        $settings_query = $db->query_read("
                SELECT
                *
                FROM " . TABLE_PREFIX . "vbcmssettings
        ");
        while($settings_row = $db->fetch_array($settings_query))
        {
                $setarray["$settings_row[grouptitle]"]["$settings_row[varname]"] = $settings_row;
        }

        $temparray = array();
        $temp_query = $db->query_read("
                SELECT
                title, templatetype, dateline, version, username, template_un
                FROM " . TABLE_PREFIX . "template
                WHERE title LIKE 'Portal_%'
        ");
        while($temp_row = $db->fetch_array($temp_query))
        {
                $temparray["$temp_row[title]"][] = $temp_row;
        }

        // Start to generate the xml file
        require_once(DIR . '/includes/class_xml.php');
        $xml = new vB_XML_Builder($vbulletin);

        $xml->add_group('areas', array('product' => 'vbcms'));

        sort($vbulletin->vbcmsareas);

        foreach($vbulletin->vbcmsareas AS $areaid => $area)
        {
	            if(($vbulletin->GPC['areaname'] == $area['include']) OR (!$vbulletin->GPC['areaname']))
	            {
                        // Area
                        $xml->add_group('area',
                                array(
                                        'id' => $area['id'],
                                        'areaname' => $area['areaname'],
                                        'include' => $area['include'],
                                        'modules' => $area['modules'],
                                        'usergroups' => $area['usergroups'],
                                        'active' => $area['active'],
                                        'useractive' => $area['useractive'],
                                        'templates' => $area['templates'],
                                        'style' => $area['style'],
                                        'buffer' => $area['buffer'],
                                        'metakey' => $area['metakey'],
                                        'metadesc' => $area['metadesc'],
                                        'datastore' => $area['datastore'],
                                        'phrasegroups' => $area['phrasegroups'],
                                        'link' => $area['link'],
                                        'customlinks' => $area['customlinks'],
                                        'position' => $area['position'],
                                        'toplink' => $area['toplink'],
                                        'leftcolum' => $area['leftcolum'],
                                        'rightcolum' => $area['rightcolum'],
                                        'titlephrase' => $area['titlephrase'], 
                                        'picnav' => $area['picnav']
                                        
                                )
                        );

                        // Setting an settinggroups
                        if($vbulletin->GPC['settings'])
                        {
                                if($grouparray["$area[include]"])
                                {
                                        $xml->add_group('settinggroup', array('name' => $area['include'], 'display' => $grouparray["$area[include]"]['display']));
                                        $xml->add_tag('settinggroup_phrase',  $settingphrase['settinggroup_' . $area['include']]);
                                        foreach($setarray["$area[include]"] AS $set => $setting)
                                        {
                                                $xml->add_group('setting', array('varname' => $setting['varname']));
                                                $xml->add_tag('grouptitle', $setting['grouptitle']);
                                                $xml->add_tag('value', $setting['value']);
                                                $xml->add_tag('defaultvalue', $setting['defaultvalue']);
                                                $xml->add_tag('optioncode', $setting['optioncode']);
                                                $xml->add_tag('displayorder', $setting['displayorder']);
                                                $xml->add_tag('volatile', $setting['volatile']);
                                                $xml->add_tag('product', $setting['product']);
                                                $xml->add_tag('phrase_desc', $settingphrase['setting_' . $setting['varname'] . '_desc']);
                                                $xml->add_tag('phrase_title', $settingphrase['setting_' . $setting['varname'] . '_title']);
                                                $xml->close_group();
                                        }
                                        $xml->close_group();
                                }
                        }

                        // Templates
                        if($vbulletin->GPC['template'])
                        {
                                foreach(explode(',', $area['templates']) AS $key => $templ)
                                {
                                        if($temparray["$templ"])
                                        {
                                                foreach($temparray["$templ"] AS $temps)
                                                {
                                                        $xml->add_group('template',
                                                                array(
                                                                        'name' => $temps['title'],
                                                                        'templatetype' => $temps['templatetype'],
                                                                        'date' => $temps['dateline'],
                                                                        'username' => $temps['username'],
                                                                        'version' => $temps['version']
                                                                )
                                                        );
                                                                $xml->add_tag('template_un', $temps['template_un']);
                                                        $xml->close_group();
                                                }

                                        }
                                }
                        }

                        if($vbulletin->GPC['php_code'])
                        {
                                $php_code = @file_get_contents(DIR . '/vbcms_areas/' . $area['include'] . '.php');
                                $actiontemp = @file_get_contents(DIR . '/vbcms_areas/' . $area['include'] . '_actiontemplates.php');
                                $xml->add_group('file', array('filename' => $area['include']));
                                        $xml->add_tag('file_content', $php_code);
                                $xml->close_group();
                                if($actiontemp)
                                {
                                        $xml->add_group('file_actions', array('actfilename' => $area['include'] . '_actiontemplates'));
                                                $xml->add_tag('act_content', $actiontemp);
                                        $xml->close_group();
                                }
                        }
                        $xml->close_group();
                }
        }

        $xml->close_group();

        $doc = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\r\n\r\n";

        $doc .= $xml->output();
        $xml = null;

        require_once(DIR . '/includes/functions_file.php');
        file_download($doc, iif($vbulletin->GPC['areaname'], $vbulletin->GPC['areaname'] . '.xml', 'vbcms_areas.xml'), 'text/xml');
}

// =================[ Add and edit a vBCMS area ]==================

if($_REQUEST['do'] == 'new_area' OR $_REQUEST['do'] == 'edit_area' OR $_REQUEST['do'] == 'copya')
{
        $vbulletin->input->clean_array_gpc('r', array(
                'varname'    => TYPE_STR
        ));

        $vbulletin->input->clean_array_gpc('p', array(
                'areaname'       => TYPE_STR,
                'file'           => TYPE_STR,
                'templates'      => TYPE_STR,
                'phpfile'        => TYPE_STR,
                'picnav'         => TYPE_STR,
                'modules'        => TYPE_ARRAY,
                'membergroup'    => TYPE_ARRAY,
                'areaactive'     => TYPE_INT,
                'memberyesno'    => TYPE_INT,
                'save'           => TYPE_INT,
                'areabuffer'     => TYPE_BOOL,
                'areastyle'      => TYPE_INT,
                'metakey'        => TYPE_STR,
                'metadesc'       => TYPE_STR,
                'datastore'      => TYPE_STR,
                'phrasegroups'   => TYPE_STR,
                'link'           => TYPE_BOOL,
                'customlinks'    => TYPE_STR,
                'linkarr'        => TYPE_ARRAY,
                'position'       => TYPE_INT,
                'toplink'        => TYPE_BOOL,
                'tableleftsize'  => TYPE_STR,
                'tablerightsize' => TYPE_STR,
                'titlephrase'    => TYPE_BOOL

        ));
        $my_linkarr = array();
        foreach($vbulletin->GPC['linkarr'] AS $mylinks)
        {
                if($mylinks['directory'])
                {
                      $my_linkarr[] = "$mylinks[level]," . trim($mylinks['directory']) . "," . trim(htmlspecialchars_uni($mylinks['linkname'])) . (($mylinks['phrase']) ? ",$mylinks[phrase]" : ",0") . "," . trim($mylinks['picnav']);
                }
        }

        $modularray =& htmlspecialchars_uni($vbulletin->GPC['modules']);
        $userarray  =& htmlspecialchars_uni($vbulletin->GPC['membergroup']);
        $put_file   =& htmlspecialchars_uni(trim(str_replace(strrchr($vbulletin->GPC['file'], '.'), '', $vbulletin->GPC['file'])));

        if(is_array($vbulletin->GPC['modules']))
        {
                $moduladd = implode(',', $vbulletin->GPC['modules']);
        }

        foreach($userarray AS $usereach)
        {
                $user_kom .= ',' . $usereach;
        }

        $usergroupadd = substr($user_kom, 1);

        $areaarray = array();

        if($_REQUEST['do'] == 'edit_area' AND !$vbulletin->GPC['save'] OR $_REQUEST['do'] == 'copya')
        {
                $areaarray = $db->query_first("
                        SELECT
                        *
                        FROM " . TABLE_PREFIX . "vbcmsareas
                        WHERE include = '" . $db->escape_string($vbulletin->GPC['varname']) . "'
                ");
                $membersarray = array('membergroupids' => $areaarray['usergroups']);

                print_cp_header(iif($_REQUEST['do'] == 'copya', $vbphrase['portal_copy_areas'] . ' ' . $areaarray['areaname'], (($vbphrase[$areaarray['areaname']]) ? $vbphrase[$areaarray['areaname']] : $areaarray['areaname']) . ' ' .strtolower($vbphrase['process'])));
                echo '<script type="text/javascript" src="../clientscript/vbulletin_cpoptions_scripts.js"></script>';
                print_vbcms_quicklinks('areas', 12);
                if($_REQUEST['do'] == 'edit_area')
                {
                        print_form_header('vbcms_admin', 'del_area');
                        construct_hidden_code('type', 'area');
                        construct_hidden_code('varname', $vbulletin->GPC['varname']);
                        print_table_header($vbphrase['vbcms_remove_this_area'] . ' &nbsp; &nbsp; <input type="submit" class="button" tabindex="1" value="' . $vbphrase['delete'] . '" />');
                        print_table_footer();
                }

                if($_REQUEST['do'] == 'copya')
                {
                        $copytemplate_arr = explode(',', $areaarray['templates']);

                        if(!preg_match('/[1-9]$/', $areaarray['include'], $match))
                        {
                                $match = array(0 => 1);
                                $firstmatch = true;
                                foreach($copytemplate_arr AS $replacement)
								{
								        if(preg_match('/^Portal_/', $replacement))
								        {
								                $replacearr[] = $replacement . $match[0];
								                $dbtemplatearr[] = "'$replacement'";
								                $settingsvarname[] = '/fetch_template\(\'' . $replacement . '\'\)/s';
								                $settingsvarname_new[]  = 'fetch_template(\'' . $replacement . $match[0] . '\')';
								        }else{
								                $replacearr[] = $replacement;
								        }
                                }
                                $copytemplate = implode(',', $replacearr);
                                $areaarray['include'] = $areaarray['include'] . $match[0];
                        }else{

                                $match[0] = $match[0] + 1;

                                foreach($copytemplate_arr AS $replacement)
								{
								        $replacement = preg_replace('/[1-9]$/', '', $replacement);
								        if(preg_match('/^Portal_/', $replacement))
								        {
								                $replacearr[] = $replacement . $match[0];
								                $dbtemplatearr[] = "'$replacement'";
								                $settingsvarname[] = '/fetch_template\(\'' . $replacement . ($match[0] - 1) . '\'\)/s';
								                $settingsvarname_new[]  = 'fetch_template(\'' . $replacement . $match[0] . '\')';
								        }else{
								                $replacearr[] = $replacement;
								        }
                                }
                                $copytemplate = implode(',', $replacearr);
                                $areaarray['include'] = preg_replace('/[1-9]$/', '', $areaarray['include']);
                                $areaarray['include'] = $areaarray['include'] . $match[0];
                        }

                        if($existmodule = $db->query_first("SELECT include FROM " . TABLE_PREFIX . "vbcmsareas WHERE include = '" . $db->escape_string($areaarray['include']) . "'"))
                        {
                                print_cp_redirect('vbcms_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=copya&varname=' . $areaarray['include']);
                        }

                }

                if(!$vbulletin->GPC['save'])
                {
                        print_form_header('vbcms_admin', iif($_REQUEST['do'] == 'copya', 'copya','edit_area'), false, true, 'vbcms_cpform');
                        construct_hidden_code('save', 1);
                        print_table_header(iif($_REQUEST['do'] == 'copya', $vbphrase['portal_copy_areas'] . ' ' . $areaarray['areaname'], $areaarray['areaname'] . ' ' .strtolower($vbphrase['process']) . '<span class="smallfont"> [<a href="vbcms_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=copya&amp;varname=' . $vbulletin->GPC['varname'] . '">' . $vbphrase['portal_copy_areas'] . '?]</a></span>'), 3);
                }

        }else if ($_REQUEST['do'] == 'new_area' AND !$vbulletin->GPC['save']){

                $membersarray = array('membergroupids' => implode(',', array_keys($vbulletin->usergroupcache)));
                print_cp_header($vbphrase['vbcms_add_area']);
                echo '<script type="text/javascript" src="../clientscript/vbulletin_cpoptions_scripts.js"></script>';

                print_form_header('vbcms_admin', 'new_area', false, true, 'vbcms_cpform');
                construct_hidden_code('save', 1);
                print_table_header($vbphrase['vbcms_add_area'], 3);
        }
        
        
        
        if(!$vbulletin->GPC['save'])
        {
        
                print_input_row($vbphrase['area_input_desc'], 'areaname', $areaarray['areaname']);
                print_yes_no_row($vbphrase['vbcms_area_titlephrase'], 'titlephrase', ($_REQUEST['do'] == 'new_area' ? 1 : $areaarray['titlephrase']));
                $handle = @opendir(DIR . '/vbcms_areas');
                while($file = @readdir($handle))
                {
                      if($file != '.' AND $file != '..' AND $file != 'index.html' AND preg_match('#^(.+).php$#siU', $file) AND !preg_match('#^(.+)_actiontemplates.php$#siU', $file))
                      {
                              $sel = iif($vbulletin->GPC['varname'] . '.php' == $file, 'selected="selected"');
                              $option_custom_content .= '<option value="' . $file . '" class="fjdpth1" ' . $sel . '>' . $file . '</option>';
                      }
                }
                @closedir($handle);

                print_label_row(
                        $vbphrase['choose_file'],
                        '<div id="ctrl_file"><select id="sel_file_1" name="file">
                                <option value="0">' . $vbphrase['p_man_customcontent_select'] . '</option>
                                ' . $option_custom_content . '
                         </select></div>',
                '', 'top', 'file', 20);
                print_input_row($vbphrase['p_man_position'], 'position', $areaarray['position'], true, 1);

                foreach($vbulletin->vbcmsportal AS $moduleselects)
                {

                        if($moduleselects['colum'] == 1)
                        {
                                $showmodules['left'] = true;
                                $module_left .= '<label for="modul' . $moduleselects['id'] . '" title="' . $moduleselects['name'] . '"><input id="modul' . $moduleselects['id'] . '" type="checkbox" name="modules[]" value="' . $moduleselects['id'] . '" ' . iif($_REQUEST['do'] == 'new_area', 'checked="checked"', iif(in_array($moduleselects['id'], explode(',', $areaarray['modules'])) , 'checked="checked"')) . ' /> <b>' . $moduleselects['name'] . '</b></label><br />';
                        }
                        if($moduleselects['colum'] == 0)
                        {
                                $showmodules['middle'] = true;
                                $module_middle .= '<label for="modul' . $moduleselects['id'] . '" title="' . $moduleselects['name'] . '"><input id="modul' . $moduleselects['id'] . '"  type="checkbox" name="modules[]" value="' . $moduleselects['id'] . '" ' . iif($_REQUEST['do'] == 'new_area', 'checked="checked"', iif(in_array($moduleselects['id'], explode(',', $areaarray['modules'])) , 'checked="checked"')) . ' /> <b>' . $moduleselects['name'] . '</b></label><br />';
                        }
                        if($moduleselects['colum'] == 2)
                        {
                                $showmodules['right'] = true;
                                $module_right .= '<label for="modul' . $moduleselects['id'] . '" title="' . $moduleselects['name'] . '"><input id="modul' . $moduleselects['id'] . '"  type="checkbox" name="modules[]" value="' . $moduleselects['id'] . '" ' . iif($_REQUEST['do'] == 'new_area', 'checked="checked"', iif(in_array($moduleselects['id'], explode(',', $areaarray['modules'])) , 'checked="checked"')) . ' /> <b>' . $moduleselects['name'] . '</b></label><br />';
                        }
                        $modulid_java[] = $moduleselects['id'];

                }

                print_label_row(
                        $vbphrase['vbcmsarea_modules'],
                        '
                        <script type="text/javascript">
                        <!--
                        function make_cecked(check)
                        {
                                modulid_java = new Array(' . implode(',', $modulid_java) . ');

                                for(var i = 0; i < modulid_java.length; i++)
                                {
                                        var x = modulid_java[i];

                                        if(check == true)
                                        {
                                                document.forms.vbcms_cpform.elements["modul" + x].checked = true;
                                        }else{
                                                document.forms.vbcms_cpform.elements["modul" + x].checked = false;
                                        }
                                }
                        }
                        //-->
                        </script>
                        <div id="ctrl_modules">
                               <table cellpadding="2" cellspacing="0" border="0" align="center" class="tborder">
                                     <tr>
                                           <td class="thead">' . $vbphrase['portal_admin_modulmove_left'] . '</td>
                                           <td class="thead">' . $vbphrase['portal_admin_modulmove_middle'] . '</td>
                                           <td class="thead">' . $vbphrase['portal_admin_modulmove_right'] . '</td>
                                     </tr>
                                     <tr valign="top">
                                           <td width="33%">
                                                 <table width="100%"><tr valign="top"><td><span class="smallfont">' . $module_left . '</span></td></tr></table>
                                           </td>
                                           <td width="33%">
                                                 <table width="100%"><tr valign="top"><td><span class="smallfont">' . $module_middle . '</span></td></tr></table>
                                           </td>
                                           <td width="33%">
                                                 <table width="100%"><tr valign="top"><td><span class="smallfont">' . $module_right . '</span></td></tr></table>
                                           </td>
                                     </tr>
                               </table>
                         </div>',
                '', 'top', 'modules[]', 20);

                print_textarea_row($vbphrase['portal_module_templateuse'], 'templates', iif($_REQUEST['do'] == 'copya', $copytemplate, $areaarray['templates']));
                if($_REQUEST['do'] == 'edit_area')
                {
                     $phpfile = file_get_contents(DIR . '/vbcms_areas/' . $areaarray['include'] . '.php');
                               
                     print_textarea_row($vbphrase['portal_module_phpfile'], 'phpfile', $phpfile);
                }
                
                print_yes_no_row($vbphrase['vbcms_area_toplinkactivated'], 'toplink', iif($_REQUEST['do'] == 'new_area', 1, $areaarray['toplink']));
                print_yes_no_row($vbphrase['vbcms_area_linkactivated'], 'link', iif($_REQUEST['do'] == 'new_area', 1, $areaarray['link']));
                print_input_row($vbphrase['vbcms_picnav'], 'picnav', $areaarray['picnav']);

                
                
                if($areaarray['customlinks'])
                {
                        foreach(explode('||', $areaarray['customlinks']) AS $custom)
                        {
                                $myt++;
                                $custom_komma = explode(',', $custom);
                                $my_links .= "<tr>
                                <td><input class=\"bginput\" type=\"text\" name=\"linkarr[$myt][level]\" size=\"1\" value=\"$custom_komma[0]\" /></td>
                                <td><input class=\"bginput\" type=\"text\" name=\"linkarr[$myt][directory]\" size=\"14\" value=\"$custom_komma[1]\" /></td>
                                <td><input class=\"bginput\" type=\"text\" name=\"linkarr[$myt][linkname]\" size=\"14\" value=\"$custom_komma[2]\" /></td>
                                <td nowrap=\"nowrap\">
                                <label for=\"linkarr[$myt][phrase][1]\"><input type=\"radio\" name=\"linkarr[$myt][phrase]\" id=\"linkarr[$myt][phrase][1]\" value=\"1\" " . (($custom_komma[3]) ? "checked=\"checked\""  : "") . " /> <span class=\"smallfont\">$vbphrase[okay]</span> </label>
                                <label for=\"linkarr[$myt][phrase][2]\"><input type=\"radio\" id=\"linkarr[$myt][phrase][2]\" name=\"linkarr[$myt][phrase]\" value=\"0\" " . ((!$custom_komma[3]) ? "checked=\"checked\""  : "") . "  /> <span class=\"smallfont\">$vbphrase[no] </span> </label>
                                </td>
                                <td><input class=\"bginput\" type=\"text\" name=\"linkarr[$myt][picnav]\" size=\"14\" value=\"$custom_komma[4]\" /></td>
                                \r\n</tr>";
                        }
                }

                for($i = 1; $i <= 4; $i++)
                {
                        $myt++;
                        $my_links .= "<tr>
                                <td><input class=\"bginput\" type=\"text\" name=\"linkarr[$myt][level]\" size=\"1\" value=\"0\" /></td>
                                <td><input class=\"bginput\" type=\"text\" name=\"linkarr[$myt][directory]\" size=\"14\" value=\"\" /></td>
                                <td><input class=\"bginput\" type=\"text\" name=\"linkarr[$myt][linkname]\" size=\"14\" value=\"\" /></td>
                                <td nowrap=\"nowrap\">
                                <label for=\"linkarr[$myt][phrase][1]\"><input type=\"radio\" name=\"linkarr[$myt][phrase]\" id=\"linkarr[$myt][phrase][1]\" value=\"1\" /> <span class=\"smallfont\">$vbphrase[okay]</span> </label>
                                <label for=\"linkarr[$myt][phrase][2]\"><input type=\"radio\" id=\"linkarr[$myt][phrase][2]\" name=\"linkarr[$myt][phrase]\" value=\"0\" checked=\"checked\"  /> <span class=\"smallfont\">$vbphrase[no] </span> </label>
                                </td>
                                <td><input class=\"bginput\" type=\"text\" name=\"linkarr[$myt][picnav]\" size=\"14\" value=\"\" /></td>
                                \r\n</tr>";
                }
                print_label_row(
                        $vbphrase['vbcms_area_customlinks'],
                        '<table cellpadding="2" cellspacing="0" border="0" class="tborder" width="100%"><tr><td class="thead">&nbsp;</td><td class="thead">' . $vbphrase['vbcms_admin_folder'] . '</td><td class="thead">' . $vbphrase['title'] . '</td><td class="thead" nowrap="nowrap">' . $vbphrase['vbcms_area_titlephrase'] . '</td><td class="thead" nowrap="nowrap">' . $vbphrase['icon'] . '</td></tr>' . $my_links . '</table>',
                '', 'top', 'linkarr', 20);

                print_description_row($vbphrase['vbcms_area_addition'], false, 2, 'optiontitle');

                print_input_row($vbphrase['vbcms_area_metakey'], 'metakey', $areaarray['metakey']);
                print_input_row($vbphrase['vbcms_area_metadesc'], 'metadesc', $areaarray['metadesc']);

                print_textarea_row($vbphrase['vbcms_area_datastorefetch'], 'datastore', $areaarray['datastore']);
                print_textarea_row($vbphrase['vbcms_area_phrasegroups'], 'phrasegroups', $areaarray['phrasegroups']);

                print_style_chooser_row('areastyle', $areaarray['style'], $vbphrase['use_default_style'], $vbphrase['vbcms_area_otherstyle'], 1);
                print_yes_no_row($vbphrase['vbcms_area_activated'], 'areaactive', iif($_REQUEST['do'] == 'new_area', 1, $areaarray['active']));
                print_yes_no_row($vbphrase['vbcms_area_areabuffer'], 'areabuffer', iif($_REQUEST['do'] == 'new_area', 0, $areaarray['buffer']));

                print_input_row($vbphrase['vbcms_area_leftcolum'], 'tableleftsize', iif($areaarray['leftcolum'], $areaarray['leftcolum'], '186px'));
                print_input_row($vbphrase['vbcms_area_rightcolum'], 'tablerightsize', iif($areaarray['rightcolum'], $areaarray['rightcolum'], '186px'));

                print_description_row($vbphrase['usergroups'], false, 2, 'optiontitle');
                print_yes_no_row($vbphrase['vbcms_area_members'], 'memberyesno', iif($_REQUEST['do'] == 'new_area', 1, $areaarray['useractive']));
                print_membergroup_row($vbphrase['portal_modul_ugroup'], 'membergroup', 2, $membersarray);

                construct_hidden_code('varname', $vbulletin->GPC['varname']);
                print_submit_row($vbphrase['save'], $vbphrase['reset'], 3);
        }

        //Save the area
        if($vbulletin->GPC['save'])
        {
                // Error no areaname
                if(empty($vbulletin->GPC['areaname']))
                {
                        print_stop_message('vbcms_acp_no_title');
                }

                if(is_demo_mode())
                {
                        print_cp_message('This function is disabled within demo mode');
                }

                if($_REQUEST['do'] == 'edit_area')
                {

                        if($vbulletin->GPC['link'] AND $put_file == 'vbcmsarea_content')
                        {
                                print_stop_message('vbcms_acp_content_no_link');
                        }
						if ($vbulletin->GPC['phpfile'])
						{
								if(@file_exists(DIR . '/vbcms_areas/' . $put_file . '.php'))
								{
										@unlink(DIR . '/vbcms_areas/' . $put_file . '.php');
								}

								if(!$fihac = @fopen(DIR . '/vbcms_areas/' . $put_file . '.php', "a"))
								{
										//print "Kann die Datei $filename nicht ffnen";
								}

								if(!@fwrite($fihac, $vbulletin->GPC['phpfile']))
								{
										//print "Kann in die Datei $filename nicht schreiben";
								}
								@fclose($fihac);
						}
                        $value = "
                                areaname = '" . $db->escape_string($vbulletin->GPC['areaname']) . "',
                                include = '" . $db->escape_string($put_file) . "',
                                modules = '" . $db->escape_string($moduladd) . "',
                                usergroups = '" . $db->escape_string($usergroupadd) . "',
                                active = " . $vbulletin->GPC['areaactive'] . ",
                                useractive = " . $vbulletin->GPC['memberyesno'] . ",
                                templates = '" . $db->escape_string($vbulletin->GPC['templates']) . "',
                                style = " . $vbulletin->GPC['areastyle'] . ",
                                buffer = " . $vbulletin->GPC['areabuffer'] . ",
                                metakey = '" . $db->escape_string($vbulletin->GPC['metakey']) . "',
								metadesc = '" . $db->escape_string($vbulletin->GPC['metadesc']) . "',
								datastore = '" . $db->escape_string($vbulletin->GPC['datastore']) . "',
                                phrasegroups = '" . $db->escape_string($vbulletin->GPC['phrasegroups']) . "',
                                link = " . $vbulletin->GPC['link'] . ",
                                customlinks = '" . $db->escape_string(implode('||', $my_linkarr)) . "',
                                position = " . $vbulletin->GPC['position'] . ",
                                toplink = " . $vbulletin->GPC['toplink'] . ",
                                leftcolum = '" . $db->escape_string($vbulletin->GPC['tableleftsize']) . "',
                                rightcolum = '" . $db->escape_string($vbulletin->GPC['tablerightsize']) . "',
                                titlephrase = " . $vbulletin->GPC['titlephrase'] . ",
                                picnav = '" . $db->escape_string($vbulletin->GPC['picnav']) . "'
                        ";
                        $where = "include = '" . $db->escape_string($vbulletin->GPC['varname']) . "'";
                        modules_move('vbcmsareas', $value, $where);
                        update_vbcms_areacache();
                        define('CP_REDIRECT', 'vbcms_admin.php?do=editareas');
 						if ($vbulletin->GPC['titlephrase'] AND $vbphrase[$vbulletin->GPC['areaname']])
						{
							$vbulletin->GPC['areaname'] = $vbphrase[$vbulletin->GPC['areaname']];
						} 
                        print_stop_message('vbcms_area_x_edit', $vbulletin->GPC['areaname']);


                }else{

                        $areaarrays = $db->query_first("
						        SELECT
								*
						        FROM " . TABLE_PREFIX . "vbcmsareas
						        WHERE include = '" . $db->escape_string(iif($_REQUEST['do'] == 'copya', $areaarray['include'], $put_file)) . "'
                        ");

                        if($areaarrays['include'])
                        {
                                 print_stop_message('vbcms_area_exist', $put_file);
                        }


                        $field  = "(id, areaname, include, modules, usergroups, active, useractive, templates, style, buffer, metakey, metadesc, datastore, phrasegroups, link, customlinks, position, toplink, leftcolum, rightcolum, titlephrase, picnav)";
                        $values = "(
                                   '',
                                   '" . $db->escape_string($vbulletin->GPC['areaname']) . "',
                                   '" . $db->escape_string(iif($_REQUEST['do'] == 'copya', $areaarray['include'], $put_file)) . "',
                                   '" . $db->escape_string($moduladd) . "',
                                   '" . $db->escape_string($usergroupadd) . "',
                                   " . $vbulletin->GPC['areaactive'] . ",
                                   " . $vbulletin->GPC['memberyesno'] . ",
                                   '" . $db->escape_string($vbulletin->GPC['templates']) . "',
                                   " . $vbulletin->GPC['areastyle'] . ",
                                   " . $vbulletin->GPC['areabuffer'] . ",
                                   '" . $db->escape_string($vbulletin->GPC['metakey']) . "',
                                   '" . $db->escape_string($vbulletin->GPC['metadesc']) . "',
								   '" . $db->escape_string($vbulletin->GPC['datastore']) . "',
                                   '" . $db->escape_string($vbulletin->GPC['phrasegroups']) . "',
                                   " . $vbulletin->GPC['link'] . ",
                                   '" . $db->escape_string(implode('||', $my_linkarr)) . "',
                                   " . $vbulletin->GPC['position'] . ",
                                   " . $vbulletin->GPC['toplink'] . ",
                                   '" . $db->escape_string($vbulletin->GPC['tableleftsize']) . "',
                                   '" . $db->escape_string($vbulletin->GPC['tablerightsize']) . "',
                                   " . $vbulletin->GPC['titlephrase'] . ",
                                   '" . $db->escape_string($vbulletin->GPC['picnav']) . "'
                                   )";
                        modules_add('vbcmsareas', $field, $values);
                        define('CP_REDIRECT', 'vbcms_admin.php?do=editareas');
                        update_vbcms_areacache();

                        // copy module all file, settings, module, module, phrases ...
                        if($_REQUEST['do'] == 'copya')
                        {
                                // Settings
                                $settingscache = array();
                                $settings = $db->query_read("
                                        SELECT
                                        setting.*, settinggroup.grouptitle, settinggroup.display
                                        FROM " . TABLE_PREFIX . "vbcmssettinggroups AS settinggroup
                                        LEFT JOIN " . TABLE_PREFIX . "vbcmssettings AS setting USING(grouptitle)
                                             WHERE settinggroup.grouptitle = '" . $db->escape_string(preg_replace('/[1-9]$/', '', $vbulletin->GPC['varname'])) . "'
                                        ORDER BY settinggroup.display, setting.displayorder
                                ");

                                while ($setting = $db->fetch_array($settings))
                                {
                                        $settingscache[]            = $setting;
                                        $settingsvarname[]          = '/\[\''  . $setting['varname'] . iif(!$firstmatch, ($match[0] - 1)) . '\'\]/s';
                                        $settingsvarname_template[] = '/\['  . $setting['varname'] . '\]/s';
                                }
                                $db->free_result($settings);

                                if($settingscache)
                                {
                                        $product_version = $full_product_info['vbcms']['version'];

                                        foreach($settingscache AS $insert)
                                        {
                                                $grouptitledb                   = $insert['grouptitle'];
                                                $newsettinggroup                = $insert['grouptitle'] . $match[0];
                                                $newsettinggroup_display        = $insert['display'];
                                                $settings_phrase_query[]        = "(-1, 'vbsettings', 'setting_" . $db->escape_string($insert['varname']) . $match[0] . "_title' , '" . $db->escape_string($settingphrase["setting_$insert[varname]_title"]) . "', 'vbcms', '" . $db->escape_string($vbulletin->userinfo['username']) . "', " . TIMENOW . ", '" . $db->escape_string($product_version) . "')";
                                                $settings_phrase_query[]        = "(-1, 'vbsettings', 'setting_" . $db->escape_string($insert['varname']) . $match[0] . "_desc' , '" . $db->escape_string($settingphrase["setting_$insert[varname]_desc"]) . "', 'vbcms', '" . $db->escape_string($vbulletin->userinfo['username']) . "', " . TIMENOW . ", '" . $db->escape_string($product_version) . "')";
                                                $settinsguer[]                  = "('" . $db->escape_string($insert['varname'] . $match[0]) . "', '" . $db->escape_string($insert['grouptitle'] . $match[0]) . "', '" . $db->escape_string($insert['value']) . "', '" . $db->escape_string($insert['defaultvalue']) . "', '" . $db->escape_string($insert['optioncode']) . "', " . intval($insert['displayorder']) . ", " . intval($insert['volatile']) . ", '" . $db->escape_string($insert['product']) . "')";
                                                $settingsvarname_new[]          = '[\'' . $insert['varname'] . $match[0] . '\']';
                                                $settingsvarname_new_template[] = '[' . $insert['varname'] . $match[0] . ']';
                                        }
                                        $settings_phrase_query[] .= "(-1, 'vbsettings', 'settinggroup_" . $db->escape_string($grouptitledb) . $match[0] . "' , '" . $db->escape_string($settingphrase["settinggroup_$grouptitledb"]) . "', 'vbcms', '" . $db->escape_string($vbulletin->userinfo['username']) . "', " . TIMENOW . ", '" . $db->escape_string($product_version) . "')";

                                        $db->query_write("
                                                INSERT INTO " . TABLE_PREFIX . "vbcmssettinggroups
                                                        (grouptitle, display, product)
                                                VALUES
                                                        (
                                                        '" . $db->escape_string($newsettinggroup) . "',
                                                        " . intval($newsettinggroup_display) . ",
                                                        'vbcms'
                                                        )
                                        ");
                                        $db->query_write("
                                                INSERT INTO " . TABLE_PREFIX . "vbcmssettings
                                                        (varname, grouptitle, value, defaultvalue, optioncode, displayorder, volatile, product )
                                                VALUES
                                                        " . implode(',', $settinsguer) . "
                                        ");
                                        $db->query_write("
                                                INSERT INTO " . TABLE_PREFIX . "phrase
                                                        (languageid, fieldname, varname, text, product, username, dateline, version)
                                                VALUES
                                                        " . implode(',', $settings_phrase_query) . "
                                        ");
                                        update_vbcms_optionscache();
                                }

                                $filestream = file_get_contents(DIR . '/vbcms_areas/' . $vbulletin->GPC['varname'] . '.php');
                                if($settingsvarname_new)
                                {
                                         $filestream = preg_replace($settingsvarname, $settingsvarname_new, $filestream);
                                }
                                if(@file_exists(DIR . '/vbcms_areas/' . $areaarray['include'] . '.php'))
                                {
                                        @unlink(DIR . '/vbcms_areas/' . $areaarray['include'] . '.php');
                                }

                                if(!$fih = @fopen(DIR . '/vbcms_areas/' . $areaarray['include'] . '.php', "a"))
                                {
                                               //print "Kann die Datei $filename nicht ffnen";
                                }

                                if(!@fwrite($fih, $filestream))
                                {
                                                //print "Kann in die Datei $filename nicht schreiben";
                                }
                                @fclose($fih);

                                  // templates
                                if($vbulletin->GPC['templates'])
                                {
                                        $templates_guer = $vbulletin->db->query_read("
                                                SELECT
                                                *
                                                FROM " . TABLE_PREFIX . "template
                                                WHERE title IN(" . implode(',', $dbtemplatearr) . ") AND styleid = -1
                                        ");
                                        while($templ = $vbulletin->db->fetch_array($templates_guer))
                                        {
                                                if($settingsvarname_template)
                                                {
                                                        $templ['template_un'] = preg_replace($settingsvarname_template, $settingsvarname_new_template, $templ['template_un']);
                                                }
                                                $tquerys[] = "(-1, '" . $vbulletin->db->escape_string($templ['templatetype']) . "', '" . $vbulletin->db->escape_string($templ['title'] . $match[0]) . "', '" . $vbulletin->db->escape_string(compile_template($templ['template_un'])) . "', '" . $vbulletin->db->escape_string($templ['template_un']) . "', " . TIMENOW . ", '" . $vbulletin->db->escape_string($templ['username']) . "', '" . $vbulletin->db->escape_string($templ['version']) . "', 'vbcms')";

                                        }
                                        $db->free_result($templates_guer);
                                        $vbulletin->db->query_write("
                                                REPLACE INTO " . TABLE_PREFIX . "template
                                                       (styleid, templatetype, title, template, template_un, dateline, username, version, product)
                                                VALUES
                                                       " . implode(',', $tquerys) . "
                                        ");

                                        echo "<p>&nbsp;</p>
                                        <blockquote><form><div class=\"tborder\">
                                        <div class=\"tcat\" style=\"padding:4px\" align=\"center\"><b>" . $vbphrase['rebuild_style_information'] . "</b></div>
                                        <div class=\"alt1\" style=\"padding:4px\">\n<blockquote>
                                        <p><b>" . construct_phrase($vbphrase['updating_style_information_for_x'], $title) . "</b></p>
                                        <ul class=\"lci\">\n";
                                        vbflush();

                                        build_style(-1,'', array());

                                        echo "</ul>\n<p><b>" . $vbphrase['done'] . "</b></p>\n</blockquote></div>
                                        </div></form></blockquote>
                                        ";
                                        vbflush();
                                }
                        }
						if ($vbulletin->GPC['titlephrase'] AND $vbphrase[$vbulletin->GPC['areaname']])
						{
							$vbulletin->GPC['areaname'] = $vbphrase[$vbulletin->GPC['areaname']];
						} 
                        print_stop_message('vbcms_area_x_add', $vbulletin->GPC['areaname']);
                }

        }

        // Let me see the setting from area
        if($_REQUEST['do'] == 'edit_area' AND !$vbulletin->GPC['save'] OR $_REQUEST['do'] == 'copya')
        {
                $settingscache = array();
                $settings = $db->query_read("
                        SELECT
                        setting.*, settinggroup.grouptitle
                        FROM " . TABLE_PREFIX . "vbcmssettinggroups AS settinggroup
                        LEFT JOIN " . TABLE_PREFIX . "vbcmssettings AS setting USING(grouptitle)
                        WHERE settinggroup.grouptitle = '" . $db->escape_string($vbulletin->GPC['varname']) . "'
                        ORDER BY settinggroup.display, setting.displayorder
                ");

                while ($setting = $db->fetch_array($settings))
                {
                        $settingscache["$setting[grouptitle]"]["$setting[varname]"] = $setting;
                        $grouptitlecache["$setting[grouptitle]"] = $setting['grouptitle'];
                }
                $db->free_result($settings);


                if($settingscache)
                {
                        print_form_header('vbcms_admin', 'dooptions', false, true, 'optionsform" onsubmit="return count_errors()');
                        construct_hidden_code('dogroup', $vbulletin->GPC['varname']);
                        construct_hidden_code('area_edit', 1);
                        vbcms_setting_group($vbulletin->GPC['varname'], $vbulletin->GPC['advanced']);
                        print_submit_row($vbphrase['save']);

                }else{

                        print_form_header('vbcms_admin', 'addsettinggroup', false, true, 'optionsform" onsubmit="return count_errors()');
                        print_table_header($vbphrase['add_new_setting_group']);
                        construct_hidden_code('varname', $vbulletin->GPC['varname']);
                        print_submit_row($vbphrase['add_new_setting_group'], '');

                }
		}
}

// =================[ Yesno message delete area or modules ]==================

if($_REQUEST['do'] == 'del_area' OR $_REQUEST['do'] == 'del_module')
{
        $vbulletin->input->clean_array_gpc('r', array(
                'type'       => TYPE_STR
        ));

        print_cp_header($vbphrase['confirm_deletion']);
        echo '<p>&nbsp;</p><p>&nbsp;</p>';
        switch($vbulletin->GPC['type'])
        {
                case 'area':
                {
                        $formdo = 'delarea';
                        $phrase = 'vbcms_delete_area_x';
                }
                break;
                case 'module':
                {
                        $formdo = 'delmodule';
                        $phrase = 'vbcms_delete_modul_x';
                }
                break;
                default:
                {
                }
                break;
        }
		print_form_header('vbcms_admin', $formdo);
        construct_hidden_code('type', $formdo);
        construct_hidden_code('varname', $vbulletin->GPC['varname']);
		print_table_header(construct_phrase($vbphrase['confirm_deletion_x'], $vbulletin->GPC['varname']));
		print_description_row("
				<div align=\"center\"><blockquote><br />
				" . construct_phrase($vbphrase[$phrase], $vbulletin->GPC['varname']) . "
				<br /></div></blockquote>\n\t");
		print_submit_row($vbphrase['yes'], 0, 2, $vbphrase['no']);

}

// =================[ Delete area or modules ]==================

if($_POST['do'] == 'delarea' OR $_POST['do'] == 'delmodule')
{
        if(is_demo_mode())
        {
                print_cp_message('This function is disabled within demo mode');
        }

        $vbulletin->input->clean_array_gpc('p', array(
                'type'       => TYPE_STR,
                'varname'    => TYPE_STR
        ));

        switch($vbulletin->GPC['type'])
        {
                // Kill areas
                case 'delarea':
                {
                        $db->query_write("
                                DELETE
                                FROM " . TABLE_PREFIX . "vbcmsareas
                                WHERE include = '" . $db->escape_string($vbulletin->GPC['varname']) . "'
                        ");
                        $redirect = 'vbcms_admin.php?do=editareas';
                        $message = 'vbcms_areadelete_successfully';
                }
                break;

                // Kill modules
                case 'delmodule':
                {
                        $db->query_write("
                                DELETE
                                FROM " . TABLE_PREFIX . "vbcmsglobalmodules
                                WHERE modulname = '" . $db->escape_string($vbulletin->GPC['varname']) . "'
                        ");
                        $redirect = 'vbcms_admin.php?do=editmodules#modul_position';
                        $message = 'vbcms_moduledelete_successfully';
                }
                break;
                default:
                {
                }
                break;
        }

        // Kill settings and phrases
        $settinggroup = $db->query_first("
              SELECT
              *
              FROM " . TABLE_PREFIX . "vbcmssettinggroups
              WHERE grouptitle = '" . $db->escape_string($vbulletin->GPC['varname']) . "'
        ");

        $setarray = array();
        $settings_query = $db->query_read("
              SELECT
              varname
              FROM " . TABLE_PREFIX . "vbcmssettings
              WHERE grouptitle = '$settinggroup[grouptitle]'
        ");
        while($settings_row = $db->fetch_array($settings_query))
        {
              $setarray[] = $db->escape_string($settings_row['varname']);
        }

        $db->query_write("
              DELETE
              FROM " . TABLE_PREFIX . "vbcmssettings
              WHERE varname IN ('" . implode("', '", $setarray) . "')
        ");
        $db->query_write("
              DELETE
              FROM " . TABLE_PREFIX . "vbcmssettinggroups
              WHERE grouptitle = '" . $db->escape_string($settinggroup['grouptitle']) . "'
        ");

        $phrase_array = array("settinggroup_$settinggroup[grouptitle]");
        foreach($setarray AS $setting_name)
        {
              $phrase_array[] = 'setting_' . $setting_name . '_title';
              $phrase_array[] = 'setting_' . $setting_name . '_desc';
        }

        $db->query_write("
              DELETE
              FROM " . TABLE_PREFIX . "phrase
              WHERE languageid IN (-1,0)
                   AND fieldname = 'vbsettings'
                   AND varname IN ('" . implode("', '", $phrase_array) . "')
        ");

        if($vbulletin->GPC['type'] == 'delarea')
        {
                update_vbcms_areacache();
        }else{
                update_vbcms_modulcache();
        }

        define('CP_REDIRECT', $redirect);
        print_stop_message($message);
}

// =================[ Add and edit a new (global) module ]==================

if($_REQUEST['do'] == 'newmodules' OR $_REQUEST['do'] == 'medit' OR $_REQUEST['do'] == 'copy')
{
        print_cp_header(iif($_REQUEST['do'] == 'copy', $vbphrase['portal_copy_modules'], iif($_REQUEST['do'] == 'newmodules', $vbphrase['portal_new_modules'], $vbphrase['portal_edit_modules'])), '', '<style type="text/css" id="vbulletin_css">.vbmenu_popup{background: #FFFFFF;color: #000000;border: 1px solid #0B198C;}</style>');
        //echo '<script type="text/javascript" src="' . $vbulletin->options['bburl'] . '/clientscript/vbulletin_menu.js?v=' . SIMPLE_VERSION  . '"></script> </head><body>';
        $vbulletin->input->clean_array_gpc('r', array(
                'mode'       => TYPE_STR
        ));

        $vbulletin->input->clean_array_gpc('p', array(
                'wysiwyg'	      => TYPE_BOOL,
                'modulbuffer'     => TYPE_BOOL,
                'add_modul'       => TYPE_STR,
                'modulname'       => TYPE_STR,
                'file'            => TYPE_STR,
                'pos'             => TYPE_INT,
                'contentcolum'    => TYPE_INT,
                'yesno'           => TYPE_INT,
                'message'         => TYPE_STR,
                'template'        => TYPE_STR,
                'phpfile'        => TYPE_STR,
                'ident'           => TYPE_STR,
                'membergroup'     => TYPE_ARRAY,
                'updateareas'     => TYPE_BOOL,
                'htmlbbcodes'     => TYPE_BOOL
        ));
        
        print_vbcms_quicklinks('module', 11);
        
        if(!$vbulletin->GPC['add_modul'] AND $_REQUEST['do'] != 'copy')
        {
		        print_form_header('vbcms_admin', 'del_module');
		        construct_hidden_code('type', 'module');
		        construct_hidden_code('varname', $vbulletin->GPC['varname']);
		        print_table_header($vbphrase['vbcms_remove_this_modul'] . ' &nbsp; &nbsp; <input type="submit" class="button" tabindex="1" value="' . $vbphrase['delete'] . '" />');
		        print_table_footer();
        }
        echo iif(!$vbulletin->GPC['add_modul'], iif($_REQUEST['do'] == 'newmodules',  '<div align="center">' . $vbphrase['vbcms_module_warning'] . '</div>'));

        $userarray =& htmlspecialchars_uni($vbulletin->GPC['membergroup']);

        foreach($userarray as $usereach)
        {
                $user_kom .= ',' . $usereach;
        }

        $usergroupadd = substr($user_kom, 1);

        $put_pos       =& $vbulletin->GPC['pos'];
        $put_yesno     =& $vbulletin->GPC['yesno'];
        $put_colum     =& $vbulletin->GPC['contentcolum'];
        $put_ident     =& htmlspecialchars_uni(trim($vbulletin->GPC['ident']));
        $put_modulname =& htmlspecialchars_uni(trim($vbulletin->GPC['modulname']));
        $put_template  =& htmlspecialchars_uni(trim($vbulletin->GPC['template']));
        $put_file      =& htmlspecialchars_uni(trim(str_replace(strrchr($vbulletin->GPC['file'], '.'), '', $vbulletin->GPC['file'])));

        if($vbulletin->GPC['wysiwyg'])
        {
                require_once(DIR . '/includes/functions_wysiwyg.php');
                $put_message = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);

        }else{

	            $put_message =& $vbulletin->GPC['message'];
       	}

        if($_REQUEST['do'] == 'medit' AND !$vbulletin->GPC['add_modul'] OR $_REQUEST['do'] == 'copy')
        {
                $modularray = $db->query_first("
						SELECT
						*
						FROM " . TABLE_PREFIX . "vbcmsglobalmodules
						WHERE modulname = '" . $db->escape_string($vbulletin->GPC['varname']) . "'
                ");
                $s_ar_a = false;
                $table_desc = $vbphrase['portal_edit_modules'] . '<span class="smallfont"> [<a href="vbcms_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=copy&amp;mode=' . $vbulletin->GPC['mode'] . '&varname=' . $vbulletin->GPC['varname'] . '">' . $vbphrase['portal_copy_modules'] . '?]</a></span>';

                if($_REQUEST['do'] == 'copy')
                {
                        $copytemplate_arr = explode(',', $modularray['template']);

                        if(!preg_match('/[1-9]$/', $modularray['modulname'], $match))
                        {
                                $match = array(0 => 1);
                                $firstmatch = true;
                                foreach($copytemplate_arr AS $replacement)
								{
								        if(preg_match('/^Portal_/', $replacement))
								        {
								                $replacearr[] = $replacement . $match[0];
								                $dbtemplatearr[] = "'$replacement'";
								                $settingsvarname[] = '/fetch_template\(\'' . $replacement . '\'\)/s';
								                $settingsvarname_new[]  = 'fetch_template(\'' . $replacement . $match[0] . '\')';
								        }else{
								                $replacearr[] = $replacement;
								        }
                                }
                                $copytemplate = implode(',', $replacearr);
                                $modularray['modulname'] = $modularray['modulname'] . $match[0];
                        }else{

                                $match[0] = $match[0] + 1;

                                foreach($copytemplate_arr AS $replacement)
								{
								        $replacement = preg_replace('/[1-9]$/', '', $replacement);
								        if(preg_match('/^Portal_/', $replacement))
								        {
								                $replacearr[] = $replacement . $match[0];
								                $dbtemplatearr[] = "'$replacement'";
								                $settingsvarname[] = '/fetch_template\(\'' . $replacement . ($match[0] - 1) . '\'\)/s';
								                $settingsvarname_new[]  = 'fetch_template(\'' . $replacement . $match[0] . '\')';
								        }else{
								                $replacearr[] = $replacement;
								        }
                                }
                                $copytemplate = implode(',', $replacearr);
                                $modularray['modulname'] = preg_replace('/[1-9]$/', '', $modularray['modulname']);
                                $modularray['modulname'] = $modularray['modulname'] . $match[0];
                        }

                        if($existmodule = $db->query_first("SELECT modulname FROM " . TABLE_PREFIX . "vbcmsglobalmodules WHERE modulname = '" . $db->escape_string($modularray['modulname']) . "'"))
                        {
                                print_cp_redirect('vbcms_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=copy&mode=' . $vbulletin->GPC['mode'] . '&varname=' . $modularray['modulname']);
                        }

                        $table_desc =& $vbphrase['portal_copy_modules'];
                        $s_ar_a = true;

                }

                $modact       =& $modularray['active'];
                $membersarray = array('membergroupids' => $modularray['user_groups']);

                echo '<form action="vbcms_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=' . iif($_REQUEST['do'] == 'copy', 'copy', 'medit') . '&amp;mode=' . $vbulletin->GPC['mode'] . '"  name="vbform" method="post" onsubmit="return vB_Editor[\'vB_Editor_001\'].prepare_submit(this.modulname.value, ' . $vbulletin->options['postminchars'] . ')">
				      <input type="hidden" name="add_modul" value="1" />
                ';

        }else if($_REQUEST['do'] == 'newmodules' AND !$vbulletin->GPC['add_modul']){

                $modularray   = array();
                $modact       = 1;
                $membersarray = array('membergroupids' => implode(',', array_keys($vbulletin->usergroupcache)));
                $table_desc   =& $vbphrase['portal_new_modules'];
                $s_ar_a = true;
                echo '<form action="vbcms_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=newmodules&amp;mode=' . $vbulletin->GPC['mode'] . '"  name="vbform" method="post" onsubmit="return vB_Editor[\'vB_Editor_001\'].prepare_submit(this.modulname.value, ' . $vbulletin->options['postminchars'] . ')" >
					  <input type="hidden" name="add_modul" value="1" />
                ';
        }

        // Array for position select
        $pos_select['0'] =& $vbphrase['p_man_content_middle'];
        $pos_select['1'] =& $vbphrase['p_man_content_left'];
        $pos_select['2'] =& $vbphrase['p_man_content_right'];

        if(!$vbulletin->GPC['add_modul'])
        {
                switch($vbulletin->GPC['mode'])
                {
                        case 'php_file':
                        {

                                $optarr = array();
                                $handle = @opendir(DIR . '/vbcms_global_modules');
                                while($file = @readdir($handle))
                                {
                                        if($file != '.' AND $file != '..' AND $file != "index.html" AND $file != 'vbcms_custom_content')
                                        {
                                                $optarr["$file"] = $file;
                                        }
                                }
                                @closedir($handle);
                                ksort($optarr);
								$optarr = array_merge(array($vbphrase['p_man_customcontent_select']), $optarr);


                                print_table_start();
                                print_table_header($table_desc, 3);

                                print_input_row($vbphrase['portal_modulename'], 'modulname', $modularray['name']);
                                print_select_row($vbphrase['choose_file'], 'file', $optarr, iif($_REQUEST['do'] == 'copy', preg_replace('/[1-9]$/is', '', $modularray['modulname']), $modularray['modulname']) . '.php');


                                
                                print_input_select_row($vbphrase['p_man_position'], 'pos', $modularray['position'], 'contentcolum', $pos_select , $modularray['colum'], '', 3);

                                print_textarea_row($vbphrase['portal_module_templateuse'], 'template', iif($_REQUEST['do'] == 'copy', $copytemplate, $modularray['template']));
                                if($_REQUEST['do'] == 'medit')
                                {
                                $phpfile = file_get_contents(DIR . '/vbcms_global_modules/' . $modularray['modulname'] . '.php');
                               
                                print_textarea_row($vbphrase['portal_module_phpfile'], 'phpfile', $phpfile);
                                }
                                print_yes_no_row($vbphrase['portal_module_activated'], 'yesno', $modact);
                                if($s_ar_a)
                                {
                                        print_yes_no_row($vbphrase['portal_module_updateareas'], 'updateareas', $modact);
                                }
                                print_yes_no_row($vbphrase['vbcms_area_areabuffer'], 'modulbuffer', iif($_REQUEST['do'] == 'newmodules', 0, $modularray['buffer']));

                                print_description_row($vbphrase['usergroups'], false, 2, 'optiontitle');
                                print_membergroup_row($vbphrase['portal_modul_ugroup'], 'membergroup', 2, $membersarray);

                        }
                        break;

                        case 'template':
                        {


                                print_table_start();
                                print_table_header($table_desc, 3);

                                print_input_row($vbphrase['portal_modulename'], 'modulname', $modularray['name']);
                                print_input_row($vbphrase['portal_moduleident'], 'ident', iif($modularray['modulname'], $modularray['modulname'], 'vbcmsmodul_'));
                                print_input_row($vbphrase['portal_module_template'], 'template', iif($modularray['template'], iif($_REQUEST['do'] == 'copy', $copytemplate, $modularray['template']), 'Portal_'));

                                print_input_select_row($vbphrase['p_man_position'], 'pos', $modularray['position'], 'contentcolum', $pos_select ,$modularray['colum'], '', 3);

                                print_yes_no_row($vbphrase['portal_module_activated'], 'yesno', $modact);
                                if($s_ar_a)
                                {
                                        print_yes_no_row($vbphrase['portal_module_updateareas'], 'updateareas', $modact);
                                }
                                print_description_row($vbphrase['usergroups'], false, 2, 'optiontitle');
                                print_membergroup_row($vbphrase['portal_modul_ugroup'], 'membergroup', 2, $membersarray);

                        }
                        break;

                        case 'bb_code':
                        {

                                print_table_start();
                                print_table_header($table_desc, 3);
                                print_input_row($vbphrase['portal_modulename'], 'modulname', $modularray['name']);
                                print_input_row($vbphrase['portal_moduleident'], 'ident', iif($modularray['modulname'], $modularray['modulname'], 'vbcmsmodul_'));

                                print_input_select_row($vbphrase['p_man_position'], 'pos', $modularray['position'], 'contentcolum', $pos_select ,$modularray['colum'], '', 3);

                                print_yes_no_row($vbphrase['portal_module_activated'], 'yesno', $modact);

                                if($s_ar_a)
                                {
                                        print_yes_no_row($vbphrase['portal_module_updateareas'], 'updateareas', $modact);
                                }
                                print_yes_no_row($vbphrase['portal_module_htmlbbcodes'], 'htmlbbcodes', $modularray['htmlbbcodes']);

                                $sel_template = $db->query_read("
                                        SELECT
                                        title, template
                                        FROM " . TABLE_PREFIX . "template

                                ");

                                while ($row_template = $db->fetch_array($sel_template))
                                {
                                        $vbulletin->templatecache["$row_template[title]"] = $row_template['template'];
                                }

                                $style = $db->query_first("
                                        SELECT
                                        *
                                        FROM " . TABLE_PREFIX . "style
                                        WHERE styleid = '" . $vbulletin->options['styleid'] . "'
								");
                                $stylevar = unserialize($style['stylevars']);

                                require_once(DIR . '/includes/functions_editor.php');
                                $editorid = construct_edit_toolbar($modularray['modulebbcode'], false, 'nonforum');
                                $messagearea = preg_replace('/src\=\"images|src\=&quot;images/s', 'src="' . $vbulletin->vbcmsoptions['vbcms_forumfolder'] . '/images', $messagearea);
                                $messagearea = preg_replace('/\(\'images/s', "('" . $vbulletin->vbcmsoptions['vbcms_forumfolder'] . '/images', $messagearea);
                                echo '
                                     <tr valign="top">
                                           <td class="alt2" width="100%" colspan="2">


                                                  ' . $messagearea = str_replace(
                                                         array(
                                                                 'clientscript'
                                                         ),
                                                         array(
                                                                 $vbulletin->vbcmsoptions['vbcms_forumfolder'] . '/clientscript'
                                                         ),
                                                         $messagearea
                                                 ) . '
                                           </td>
                                     </tr>
                                     ';

                                print_description_row($vbphrase['usergroups'], false, 2, 'optiontitle');
                                print_membergroup_row($vbphrase['portal_modul_ugroup'], 'membergroup', 2, $membersarray);



                                echo '<script type="text/javascript">
                                      <!--
	                                  // Main vBulletin Javascript Initialization
	                                  //vBulletin_init();
                                      //-->
                                      </script>
                                ';
                        }
                        break;

                        default:
                        {

                        }
                        break;
                }
                construct_hidden_code('varname', $vbulletin->GPC['varname']);

                print_submit_row($vbphrase['save'], $vbphrase['reset'], 3);
        }



        // SAVE
        if(!empty($vbulletin->GPC['add_modul']))
        {
                if(is_demo_mode())
                {
                        print_cp_message('This function is disabled within demo mode');
                }
                if(empty($put_modulname))
                {
                        print_stop_message('vbcms_acp_no_modultitle');
                }

                switch($vbulletin->GPC['mode'])
                {
                        case 'php_file':
                        {
                                if(empty($put_file))
                                {
                                        print_stop_message('vbcms_acp_no_modulfile');
                                }
                                $modultype = 'php_file';
                                if($_REQUEST['do'] == 'medit')
                                {
                                
										if ($vbulletin->GPC['phpfile'])
										{
												if(@file_exists(DIR . '/vbcms_global_modules/' . $put_file . '.php'))
												{
														@unlink(DIR . '/vbcms_global_modules/' . $put_file . '.php');
												}

												if(!$fihac = @fopen(DIR . '/vbcms_global_modules/' . $put_file . '.php', "a"))
												{
														//print "Kann die Datei $filename nicht ffnen";
												}

												if(!@fwrite($fihac, $vbulletin->GPC['phpfile']))
												{
														//print "Kann in die Datei $filename nicht schreiben";
												}
												@fclose($fihac);
										}
                                        $value = "
                                                name = '" . $db->escape_string($put_modulname) . "',
                                                modulname = '" . $db->escape_string($put_file) . "',
                                                moduletype = '$modultype',
                                                colum = $put_colum,
                                                position = $put_pos,
                                                active = $put_yesno,
                                                user_groups = '" . $db->escape_string($usergroupadd) . "',
                                                template = '" . $db->escape_string($put_template) . "',
                                                buffer = " . $vbulletin->GPC['modulbuffer'] . "
                                        ";
                                        $where = "modulname='" . $db->escape_string($vbulletin->GPC['varname']) . "'";

                                }else{

                                        $field  = "(id, name, modulname, moduletype, colum, position, active, user_groups, template, modulebbcode, buffer)";
                                        $values = "('', '" . $db->escape_string($put_modulname) . "', '" . $db->escape_string(iif($_REQUEST['do'] == 'copy', $modularray['modulname'], $put_file)) . "', '$modultype', $put_colum, $put_pos, $put_yesno, '" . $db->escape_string($usergroupadd) . "',  '" . $db->escape_string(iif($_REQUEST['do'] == 'copy', $copytemplate, $put_template)) . "', '', " . $vbulletin->GPC['modulbuffer'] . ")";
                                }
                        }
                        break;

                        case 'template':
                        {
                                if(empty($put_ident))
                                {
                                        print_stop_message('vbcms_acp_no_modulident');
                                }
                                $modultype = 'template';
                                if($_REQUEST['do'] == 'medit')
                                {
                                        $value = "
                                                name = '" . $db->escape_string($put_modulname) . "',
                                                modulname = '" . $db->escape_string($put_ident) . "',
                                                moduletype = '$modultype',
                                                colum = $put_colum,
                                                position = $put_pos,
                                                active = $put_yesno,
                                                user_groups = '" . $db->escape_string($usergroupadd) . "',
                                                template = '" . $db->escape_string($put_template) . "'
                                        ";
                                        $where = "modulname='" . $db->escape_string($vbulletin->GPC['varname']) . "'";

                                }else{

                                        $field  = "(id, name, modulname, moduletype, colum, position, active, user_groups, template, modulebbcode)";
                                        $values = "('', '" . $db->escape_string($put_modulname) . "', '" . $db->escape_string($put_ident) . "', '$modultype', '$put_colum', '$put_pos', '$put_yesno', '" . $db->escape_string($usergroupadd) . "', '" . $db->escape_string($put_template) . "', '')";

                                }

                        }
                        break;

                        case 'bb_code':
                        {
                                if(empty($put_ident))
                                {
                                        print_stop_message('vbcms_acp_no_modulident');
                                }

                                $modultype = 'bb_code';
                                if($_REQUEST['do'] == 'medit')
                                {
                                        $value = "
                                                name = '" . $db->escape_string($put_modulname) . "',
                                                modulname = '" . $db->escape_string($put_ident) . "',
                                                moduletype = '$modultype',
                                                colum = $put_colum,
                                                position = $put_pos,
                                                active = $put_yesno,
                                                user_groups = '" . $db->escape_string($usergroupadd) . "',
                                                modulebbcode = '" . $db->escape_string($put_message) . "',
                                                htmlbbcodes = " . $vbulletin->GPC['htmlbbcodes'] . "
                                        ";
                                        $where = "modulname='" . $db->escape_string($vbulletin->GPC['varname']) . "'";
                                        update_vbcms_modulcache();
                                }else{

                                        $field  = "(id, name, modulname, moduletype, colum, position, active, user_groups, template, modulebbcode, buffer, htmlbbcodes)";
                                        $values = "('', '" . $db->escape_string($put_modulname) . "', '" . $db->escape_string($put_ident) . "', '$modultype', '$put_colum', '$put_pos', '$put_yesno', '" . $db->escape_string($usergroupadd) . "', 'Portal_module_bbcode', '" . $db->escape_string($put_message) . "', '', " . $vbulletin->GPC['htmlbbcodes'] . ")";

                                }

                        }
                        break;

                        default:
                        {

                        }
                        break;
                }

                if($_REQUEST['do'] == 'medit')
                {
                        modules_move('vbcmsglobalmodules', $value, $where);
                        update_vbcms_modulcache();
                }else{

						$modarray = $db->query_first("
								SELECT
								*
								FROM " . TABLE_PREFIX . "vbcmsglobalmodules
								WHERE modulname = '" . $db->escape_string(iif($_REQUEST['do'] == 'copy', $modularray['modulname'], $put_file)) . "'
								     OR modulname = '" . $db->escape_string($put_ident) . "'
						");

						if($modarray['modulname'])
						{
								print_stop_message('vbcms_acp_modulextist');
                        }
                        $insertid = modules_add('vbcmsglobalmodules', $field, $values);
                        update_vbcms_modulcache();

                }

                if($vbulletin->GPC['updateareas'])
                {
                        $module = $db->query_read("
								SELECT
								id, modules
								FROM " . TABLE_PREFIX . "vbcmsareas
						");

						while($amodule = $db->fetch_array($module))
						{
								$db->query_write("
										UPDATE " . TABLE_PREFIX . "vbcmsareas
										SET
										   modules = '" . $db->escape_string($amodule['modules'] . ',' . $insertid) . "'
										WHERE id = " . $amodule['id'] . "
                                ");
						}
						$db->free_result($module);
						update_vbcms_areacache();

						$setting_forum = $db->query_first("
								SELECT
								varname, value
								FROM " . TABLE_PREFIX . "setting
								WHERE varname = 'forum_active_modules'
						");

						$db->query_write("
								UPDATE " . TABLE_PREFIX . "setting
								SET
								   value = '" . $db->escape_string($setting_forum['value'] . ',' . $insertid) . "'
								WHERE varname = '" . $setting_forum['varname'] . "'
						");
						build_options();
                }
                // copy module all file, settings, module, module, phrases ...
                if($_REQUEST['do'] == 'copy')
                {
                        // Settings
                        $settingscache = array();
                        $settings = $db->query_read("
                                SELECT
                                setting.*, settinggroup.grouptitle, settinggroup.display
                                FROM " . TABLE_PREFIX . "vbcmssettinggroups AS settinggroup
                                LEFT JOIN " . TABLE_PREFIX . "vbcmssettings AS setting USING(grouptitle)
                                     WHERE settinggroup.grouptitle = '" . $db->escape_string(preg_replace('/[1-9]$/', '', $vbulletin->GPC['varname'])) . "'
                                ORDER BY settinggroup.display, setting.displayorder
                        ");

                        while ($setting = $db->fetch_array($settings))
                        {
                                $settingscache[]            = $setting;
                                $settingsvarname[]          = '/\[\''  . $setting['varname'] . iif(!$firstmatch, ($match[0] - 1)) . '\'\]/s';
                                $settingsvarname_template[] = '/\['  . $setting['varname'] . '\]/s';
                        }
                        $db->free_result($settings);

                        if($settingscache)
                        {
                                $product_version = $full_product_info['vbcms']['version'];

                                foreach($settingscache AS $insert)
                                {
                                        $grouptitledb                   = $insert['grouptitle'];
                                        $newsettinggroup                = $insert['grouptitle'] . $match[0];
                                        $newsettinggroup_display        = $insert['display'];
                                        $settings_phrase_query[]        = "(-1, 'vbsettings', 'setting_" . $db->escape_string($insert['varname']) . $match[0] . "_title' , '" . $db->escape_string($settingphrase["setting_$insert[varname]_title"]) . "', 'vbcms', '" . $db->escape_string($vbulletin->userinfo['username']) . "', " . TIMENOW . ", '" . $db->escape_string($product_version) . "')";
                                        $settings_phrase_query[]        = "(-1, 'vbsettings', 'setting_" . $db->escape_string($insert['varname']) . $match[0] . "_desc' , '" . $db->escape_string($settingphrase["setting_$insert[varname]_desc"]) . "', 'vbcms', '" . $db->escape_string($vbulletin->userinfo['username']) . "', " . TIMENOW . ", '" . $db->escape_string($product_version) . "')";
                                        $settinsguer[]                  = "('" . $db->escape_string($insert['varname'] . $match[0]) . "', '" . $db->escape_string($insert['grouptitle'] . $match[0]) . "', '" . $db->escape_string($insert['value']) . "', '" . $db->escape_string($insert['defaultvalue']) . "', '" . $db->escape_string($insert['optioncode']) . "', " . intval($insert['displayorder']) . ", " . intval($insert['volatile']) . ", '" . $db->escape_string($insert['product']) . "')";
                                        $settingsvarname_new[]          = '[\'' . $insert['varname'] . $match[0] . '\']';
                                        $settingsvarname_new_template[] = '[' . $insert['varname'] . $match[0] . ']';
                                }
                                $settings_phrase_query[] .= "(-1, 'vbsettings', 'settinggroup_" . $db->escape_string($grouptitledb) . $match[0] . "' , '" . $db->escape_string($settingphrase["settinggroup_$grouptitledb"]) . "', 'vbcms', '" . $db->escape_string($vbulletin->userinfo['username']) . "', " . TIMENOW . ", '" . $db->escape_string($product_version) . "')";

                                $db->query_write("
                                        INSERT INTO " . TABLE_PREFIX . "vbcmssettinggroups
                                                (grouptitle, display, product)
                                        VALUES
                                                (
                                                '" . $db->escape_string($newsettinggroup) . "',
                                                " . intval($newsettinggroup_display) . ",
                                                'vbcms'
                                                )
                                ");
                                $db->query_write("
                                        INSERT INTO " . TABLE_PREFIX . "vbcmssettings
                                                (varname, grouptitle, value, defaultvalue, optioncode, displayorder, volatile, product )
                                        VALUES
                                                " . implode(',', $settinsguer) . "
                                ");
                                $db->query_write("
                                        INSERT INTO " . TABLE_PREFIX . "phrase
                                                (languageid, fieldname, varname, text, product, username, dateline, version)
                                        VALUES
                                                " . implode(',', $settings_phrase_query) . "
                                ");
                                update_vbcms_optionscache();
                        }
                        // file
                        if($vbulletin->GPC['mode'] == 'php_file')
                        {
                                  $filestream = file_get_contents(DIR . '/vbcms_global_modules/' . $vbulletin->GPC['varname'] . '.php');
                                  if($settingsvarname_new)
                                  {
                                          $filestream = preg_replace($settingsvarname, $settingsvarname_new, $filestream);
                                  }
                                  if(@file_exists(DIR . '/vbcms_global_modules/' . $modularray['modulname'] . '.php'))
                                  {
                                          @unlink(DIR . '/vbcms_global_modules/' . $modularray['modulname'] . '.php');
                                  }

                                  if(!$fih = @fopen(DIR . '/vbcms_global_modules/' . $modularray['modulname'] . '.php', "a"))
                                  {
                                                //print "Kann die Datei $filename nicht ffnen";
                                  }

                                  if(!@fwrite($fih, $filestream))
                                  {
                                                //print "Kann in die Datei $filename nicht schreiben";
                                  }
                                  @fclose($fih);
                        }
                        // templates
                        if($vbulletin->GPC['mode'] != 'bb_code')
                        {
                                  $templates_guer = $vbulletin->db->query_read("
                                            SELECT
                                            *
                                            FROM " . TABLE_PREFIX . "template
                                            WHERE title IN(" . implode(',', $dbtemplatearr) . ") AND styleid = -1
                                  ");
                                  while($templ = $vbulletin->db->fetch_array($templates_guer))
                                  {
                                            if($settingsvarname_template)
                                            {
                                                    $templ['template_un'] = preg_replace($settingsvarname_template, $settingsvarname_new_template, $templ['template_un']);
                                            }
                                            $tquerys[] = "(-1, '" . $vbulletin->db->escape_string($templ['templatetype']) . "', '" . $vbulletin->db->escape_string($templ['title'] . $match[0]) . "', '" . $vbulletin->db->escape_string(compile_template($templ['template_un'])) . "', '" . $vbulletin->db->escape_string($templ['template_un']) . "', " . TIMENOW . ", '" . $vbulletin->db->escape_string($templ['username']) . "', '" . $vbulletin->db->escape_string($templ['version']) . "', 'vbcms')";

                                  }
                                  $db->free_result($templates_guer);
                                  $vbulletin->db->query_write("
                                          REPLACE INTO " . TABLE_PREFIX . "template
                                                  (styleid, templatetype, title, template, template_un, dateline, username, version, product)
                                          VALUES
                                                  " . implode(',', $tquerys) . "
                                  ");

                                  echo "<p>&nbsp;</p>
                                        <blockquote><form><div class=\"tborder\">
                                        <div class=\"tcat\" style=\"padding:4px\" align=\"center\"><b>" . $vbphrase['rebuild_style_information'] . "</b></div>
                                        <div class=\"alt1\" style=\"padding:4px\">\n<blockquote>
                                        <p><b>" . construct_phrase($vbphrase['updating_style_information_for_x'], $title) . "</b></p>
                                        <ul class=\"lci\">\n";
                                  vbflush();

                                  build_style(-1,'', array());

                                  echo "</ul>\n<p><b>" . $vbphrase['done'] . "</b></p>\n</blockquote></div>
                                        </div></form></blockquote>
                                       ";
                                  vbflush();
                        }
                }

                define('CP_REDIRECT', 'vbcms_admin.php?do=editmodules');

                if($_REQUEST['do'] == 'medit')
                {
                        print_stop_message('vbcms_module_x_edit', $put_modulname);
                }else{
                        print_stop_message('vbcms_module_x_add', $put_modulname);
                }
        }

        // Let me see the setting from module
        if($_REQUEST['do'] == 'medit' AND !$vbulletin->GPC['add_modul'] OR $_REQUEST['do'] == 'copy')
        {
                $settingscache = array();
                $settings = $db->query_read("
                        SELECT
                        setting.*, settinggroup.grouptitle
                        FROM " . TABLE_PREFIX . "vbcmssettinggroups AS settinggroup
                        LEFT JOIN " . TABLE_PREFIX . "vbcmssettings AS setting USING(grouptitle)
                        WHERE settinggroup.grouptitle = '" . $db->escape_string($vbulletin->GPC['varname']) . "'
                        ORDER BY settinggroup.display, setting.displayorder
                ");

                while ($setting = $db->fetch_array($settings))
                {
                        $settingscache["$setting[grouptitle]"]["$setting[varname]"] = $setting;
                        $grouptitlecache["$setting[grouptitle]"] = $setting['grouptitle'];
                }
                $db->free_result($settings);


                if($settingscache)
                {
                        print_form_header('vbcms_admin', 'dooptions', false, true, 'optionsform" onsubmit="return count_errors()');
                        construct_hidden_code('dogroup', $vbulletin->GPC['varname']);
                        construct_hidden_code('modul_edit', 1);
                        construct_hidden_code('mode', $vbulletin->GPC['mode']);
                        vbcms_setting_group($vbulletin->GPC['varname'], $vbulletin->GPC['advanced']);
                        print_submit_row($vbphrase['save']);

                }else{

                        print_form_header('vbcms_admin', 'addsettinggroup', false, true, 'optionsform" onsubmit="return count_errors()');
                        construct_hidden_code('modulname', $vbulletin->GPC['varname']);
                        construct_hidden_code('modul_edit', 1);

                        print_table_header($vbphrase['add_new_setting_group']);
                        print_submit_row($vbphrase['add_new_setting_group'], '');

                }
		}
}

// =================[ Insert or edit settingroup ]==================

if($_REQUEST['do'] == 'editsettinggroup' OR $_REQUEST['do'] == 'addsettinggroup')
{
        $vbulletin->input->clean_array_gpc('r', array(
                'grouptitle' => TYPE_STR,
                'modulname' => TYPE_STR
        ));

        print_cp_header($vbphrase['add_new_setting_group']);

        if($_REQUEST['do'] == 'editsettinggroup')
        {
                $group = $db->query_first("
                        SELECT * FROM " . TABLE_PREFIX . "vbcmssettinggroups
                        WHERE grouptitle = '" . $db->escape_string($vbulletin->GPC['grouptitle']) . "'
                ");
                $phrase = $db->query_first("
                        SELECT text FROM " . TABLE_PREFIX . "phrase
                        WHERE languageid IN (-1,0) AND
                        fieldname = 'vbsettings' AND
                        varname = 'settinggroup_" . $db->escape_string($group['grouptitle']) . "'
                ");
                $group['title'] = $phrase['text'];
                $pagetitle = construct_phrase($vbphrase['x_y_id_z'], $vbphrase['setting_group'], $group['title'], $group['grouptitle']);
                $formdo = 'updategroup';

        }else{
                $ordercheck = $db->query_first("
                        SELECT display
                        FROM " . TABLE_PREFIX . "vbcmssettinggroups
                        ORDER BY display DESC
                ");
                $group = array(
                        'display' => $ordercheck['display'] + 10
                );
                $pagetitle = $vbphrase['add_new_setting_group'];
                $formdo = 'insertgroup';
        }

        print_form_header('vbcms_admin', $formdo);
        print_table_header($pagetitle);

        if($_REQUEST['do'] == 'editsettinggroup')
		{
                print_label_row($vbphrase['varname'], "<b>$group[grouptitle]</b>");
                construct_hidden_code('group[grouptitle]', $group['grouptitle']);
                construct_hidden_code('group[product]', 'vbcms');
        }else{
                if($vbulletin->GPC['modulname'])
                {
                       $group['grouptitle'] =& $vbulletin->GPC['modulname'];
                }

                if($vbulletin->GPC['varname'])
                {
                       $group['grouptitle'] =& $vbulletin->GPC['varname'];
                }
                print_input_row($vbphrase['varname'], 'group[grouptitle]', $group['grouptitle']);
                construct_hidden_code('group[product]', 'vbcms');
        }

        print_input_row($vbphrase['title'], 'group[title]', $group['title']);
        construct_hidden_code('oldproduct', $group['product']);
        print_input_row($vbphrase['display_order'], 'group[displayorder]', $group['display']);

        print_submit_row($vbphrase['save']);
}

// =================[ Insert or edit setting ]==================

if($_REQUEST['do'] == 'editsetting' OR $_REQUEST['do'] == 'addsetting')
{
        $vbulletin->input->clean_array_gpc('r', array(
                'grouptitle' => TYPE_STR
        ));

        if(is_demo_mode())
        {
                print_cp_message('This function is disabled within demo mode');
        }

        $settinggroups = array();
        $groups = $db->query_read("SELECT grouptitle FROM " . TABLE_PREFIX . "vbcmssettinggroups ORDER BY display");
        while($group = $db->fetch_array($groups))
        {
                $settinggroups["$group[grouptitle]"] = $settingphrase["settinggroup_$group[grouptitle]"];
        }

        if($_REQUEST['do'] == 'editsetting')
        {
				$setting = $db->query_first("
						SELECT
						*
						FROM " . TABLE_PREFIX . "vbcmssettings
						WHERE varname = '" . $db->escape_string($vbulletin->GPC['varname']) . "'
				");
				$phrases = $db->query_read("
						SELECT
						varname, text
						FROM " . TABLE_PREFIX . "phrase
						WHERE languageid = " . iif($setting['volatile'], -1, 0) . "
						     AND fieldname = 'vbsettings' AND varname IN ('setting_" . $db->escape_string($setting['varname']) . "_title', 'setting_" . $db->escape_string($setting['varname']) . "_desc')
				");
				while($phrase = $db->fetch_array($phrases))
				{
						if($phrase['varname'] == "setting_$setting[varname]_title")
						{
								$setting['title'] = $phrase['text'];

						}else if($phrase['varname'] == "setting_$setting[varname]_desc"){

								$setting['description'] = $phrase['text'];
						}
				}
				$pagetitle = construct_phrase($vbphrase['x_y_id_z'], $vbphrase['setting'], $setting['title'], $setting['varname']);
				$formdo = 'updatesetting';

		}else{

				$ordercheck = $db->query_first("
						SELECT
						displayorder
						FROM " . TABLE_PREFIX . "vbcmssettings
						WHERE grouptitle='" . $db->escape_string($vbulletin->GPC['grouptitle']) . "'
						ORDER BY displayorder DESC
				");
				$setting = array(
						'grouptitle' => $vbulletin->GPC['grouptitle'],
						'displayorder' => $ordercheck['displayorder'] + 10,
						'volatile' => iif($vbulletin->debug, 1, 0)
				);
				$pagetitle = $vbphrase['add_new_setting'];
				$formdo = 'insertsetting';
		}

		print_cp_header($pagetitle);
		print_form_header('vbcms_admin', $formdo);
		print_table_header($pagetitle);
		construct_hidden_code('product', 'vbcms');
		if($_REQUEST['do'] == 'editsetting')
		{
				construct_hidden_code('varname', $setting['varname']);

				print_label_row($vbphrase['varname'], "<b>$setting[varname]</b>");
		}else{

				print_input_row($vbphrase['varname'], 'varname', $setting['varname']);
		}
		print_select_row($vbphrase['setting_group'], 'grouptitle', $settinggroups, $setting['grouptitle']);
		print_input_row($vbphrase['title'], 'title', $setting['title']);
		print_textarea_row($vbphrase['description'], 'description', $setting['description'], 4, 50);
		print_textarea_row($vbphrase['option_code'], 'optioncode', $setting['optioncode'], 4, 50);
		print_textarea_row($vbphrase['default'], 'defaultvalue', $setting['defaultvalue'], 4, 50);

		print_input_row($vbphrase['display_order'], 'displayorder', $setting['displayorder']);

		if($vbulletin->debug)
		{
				print_yes_no_row($vbphrase['vbulletin_default'], 'volatile', $setting['volatile']);
		}else{

				construct_hidden_code('volatile', $setting['volatile']);
		}
		print_submit_row($vbphrase['save']);
}

// =================[ Save settinggroup ]==================

if($_POST['do'] == 'insertgroup')
{
        $vbulletin->input->clean_array_gpc('p', array(
                'group' => TYPE_ARRAY
        ));
        $db->query_write("
                INSERT INTO " . TABLE_PREFIX . "vbcmssettinggroups
                        (grouptitle, display, product)
                VALUES
                        (
                        '" . $db->escape_string($vbulletin->GPC['group']['grouptitle']) . "',
                        " . intval($vbulletin->GPC['group']['displayorder']) . ",
                        '" . $db->escape_string($vbulletin->GPC['group']['product']) . "'
                        )
        ");

        $full_product_info = fetch_product_list(true);
        $product_version = $full_product_info[$vbulletin->GPC['group']['product']]['version'];

        $languageid = iif($vbulletin->GPC['group']['volatile'], -1, 0);

        $db->query_write("
                INSERT INTO " . TABLE_PREFIX . "phrase
                        (languageid, fieldname, varname, text, product, username, dateline, version)
                VALUES
                        ($languageid,
                        'vbsettings',
                        'settinggroup_" . $db->escape_string($vbulletin->GPC['group']['grouptitle']) . "',
                        '" . $db->escape_string($vbulletin->GPC['group']['title']) . "',
                        '" . $db->escape_string($vbulletin->GPC['group']['product']) . "',
                        '" . $db->escape_string($vbulletin->userinfo['username']) . "',
                        " . TIMENOW . ",
                        '" . $db->escape_string($product_version) . "')
        ");


        $_POST['do'] = 'updategroup';
}

// =================[ Update settingroup ]==================

if ($_POST['do'] == 'updategroup')
{
        $vbulletin->input->clean_array_gpc('p', array(
                'group' => TYPE_ARRAY,
                'oldproduct' => TYPE_STR
        ));

        $db->query_write("
                UPDATE " . TABLE_PREFIX . "vbcmssettinggroups
                SET
                   display = " . intval($vbulletin->GPC['group']['displayorder']) . ",
                   product = '" . $db->escape_string($vbulletin->GPC['group']['product']) . "'
                WHERE grouptitle = '" . $db->escape_string($vbulletin->GPC['group']['grouptitle']) . "'
        ");

        $full_product_info = fetch_product_list(true);
        $product_version = $full_product_info[$vbulletin->GPC['group']['product']]['version'];

        $db->query_write("
                UPDATE " . TABLE_PREFIX . "phrase
                SET
                   text = '" . $db->escape_string($vbulletin->GPC['group']['title']) . "',
                   product = '" . $db->escape_string($vbulletin->GPC['group']['product']) . "',
                   username = '" . $db->escape_string($vbulletin->userinfo['username']) . "',
                   dateline = " . TIMENOW . ",
                   version = '" . $db->escape_string($product_version) . "'
                   WHERE languageid IN(-1, 0)
                        AND varname = 'settinggroup_" . $db->escape_string($vbulletin->GPC['group']['grouptitle']) . "'
        ");

        $settingnames = array();
        $phrasenames = array();

        $settings = $db->query_read("
                SELECT
                varname, product
                FROM " . TABLE_PREFIX . "vbcmssettings
                WHERE grouptitle = '" . $db->escape_string($vbulletin->GPC['group']['grouptitle']) . "'
                AND product = '" . $db->escape_string($vbulletin->GPC['oldproduct']) . "'
        ");
        while ($setting = $db->fetch_array($settings))
        {
                $settingnames[] = "'" . $db->escape_string($setting['varname']) . "'";
                $phrasenames[] = "'" . $db->escape_string('setting_' . $setting['varname'] . '_desc') . "'";
                $phrasenames[] = "'" . $db->escape_string('setting_' . $setting['varname'] . '_title') . "'";
        }
        if($db->num_rows($settings))
        {
                $full_product_info = fetch_product_list(true);
                $product_version = $full_product_info[$vbulletin->GPC['group']['product']]['version'];

                $q1 = "
                        UPDATE " . TABLE_PREFIX . "vbcmssettings
                        SET
                           product = '" . $db->escape_string($vbulletin->GPC['group']['product']) . "'
                        WHERE varname IN(
                        " . implode(",\n				", $settingnames) . ")
                ";
                $db->query_write($q1);

                $q2 = "
                        UPDATE " . TABLE_PREFIX . "phrase
                        SET
                        product = '" . $db->escape_string($vbulletin->GPC['group']['product']) . "',
                        username = '" . $db->escape_string($vbulletin->userinfo['username']) . "',
                        dateline = " . TIMENOW . ",
                        version = '" . $db->escape_string($product_version) . "'
                        WHERE varname IN(
	                        " . implode(",\n				", $phrasenames) . "
                            ) AND fieldname = 'vbsettings'
                ";
                $db->query_write($q2);
        }

        define('CP_REDIRECT', 'vbcms_admin.php?do=defaultoptions&amp;dogroup=' . $vbulletin->GPC['group']['grouptitle']);
        print_stop_message('saved_setting_group_x_successfully', $vbulletin->GPC['group']['title']);
}

// =================[ Save setting ]==================

if ($_POST['do'] == 'insertsetting')
{
        $vbulletin->input->clean_array_gpc('p', array(
                'varname'        => TYPE_STR,
                'grouptitle'     => TYPE_STR,
                'optioncode'     => TYPE_STR,
                'defaultvalue'   => TYPE_STR,
                'displayorder'   => TYPE_UINT,
                'volatile'       => TYPE_INT,
                'datatype'       => TYPE_STR,
                'validationcode' => TYPE_STR,
                'product'        => TYPE_STR,
                'blacklist'      => TYPE_BOOL,
                'title'          => TYPE_STR,
                'description'    => TYPE_STR,
                'oldproduct'     => TYPE_STR
        ));

        if(is_demo_mode())
        {
                print_cp_message('This function is disabled within demo mode');
        }

        if($s = $db->query_first("
                SELECT
                varname
                FROM " . TABLE_PREFIX . "vbcmssettings
                WHERE varname = '" . $db->escape_string($vbulletin->GPC['varname']) . "'
        "))
        {
                print_stop_message('there_is_already_setting_named_x', $vbulletin->GPC['varname']);
        }

        if(!preg_match('#^[a-z0-9_]+$#i', $vbulletin->GPC['varname'])) // match a-z, A-Z, 0-9, _ only
        {
                print_stop_message('invalid_phrase_varname');
        }

        $db->query_write("
                INSERT INTO " . TABLE_PREFIX . "vbcmssettings
                        (varname, value, product)
                VALUES
                        (
                        '" . $db->escape_string($vbulletin->GPC['varname']) . "',
                        '" . $db->escape_string($vbulletin->GPC['defaultvalue']) . "',
                        '" . $db->escape_string($vbulletin->GPC['product']) . "'
                        )
        ");

       $full_product_info = fetch_product_list(true);
       $product_version = $full_product_info['vbcms']['version'];

       $languageid = iif($vbulletin->GPC['volatile'], -1, 0);

       $db->query_write("
              INSERT INTO " . TABLE_PREFIX . "phrase
                     (languageid, fieldname, varname, text, product, username, dateline, version)
              VALUES
                     (
                     $languageid,
                     'vbsettings',
                     'setting_" . $db->escape_string($vbulletin->GPC['varname']) . "_title',
                     '" . $db->escape_string($vbulletin->GPC['title']) . "',
                     '" . $db->escape_string($vbulletin->GPC['product']) . "',
                     '" . $db->escape_string($vbulletin->userinfo['username']) . "',
                     " . TIMENOW . ",
                     '" . $db->escape_string($product_version) . "')
       ");

       $db->query_write("
              INSERT INTO " . TABLE_PREFIX . "phrase
                     (languageid, fieldname, varname, text, product, username, dateline, version)
              VALUES
                     (
                     $languageid,
                     'vbsettings',
                     'setting_" . $db->escape_string($vbulletin->GPC['varname']) . "_desc',
                     '" . $db->escape_string($vbulletin->GPC['description']) . "',
                     '" . $db->escape_string($vbulletin->GPC['product']) . "',
                     '" . $db->escape_string($vbulletin->userinfo['username']) . "',
                     " . TIMENOW . ",
                     '" . $db->escape_string($product_version) . "')
       ");

       $_POST['do'] = 'updatesetting';
}

// =================[ Update setting ]==================

if ($_POST['do'] == 'updatesetting')
{
       $vbulletin->input->clean_array_gpc('p', array(
              'varname'        => TYPE_STR,
              'grouptitle'     => TYPE_STR,
              'optioncode'     => TYPE_STR,
              'defaultvalue'   => TYPE_STR,
              'displayorder'   => TYPE_UINT,
              'volatile'       => TYPE_INT,
              'datatype'       => TYPE_STR,
              'validationcode' => TYPE_STR,
              'product'        => TYPE_STR,
              'blacklist'      => TYPE_BOOL,
              'title'          => TYPE_STR,
              'description'    => TYPE_STR,
              'oldproduct'     => TYPE_STR
       ));

       if(is_demo_mode())
       {
              print_cp_message('This function is disabled within demo mode');
       }

       $db->query_write("
              UPDATE " . TABLE_PREFIX . "vbcmssettings
              SET
                 grouptitle = '" . $db->escape_string($vbulletin->GPC['grouptitle']) . "',
                 optioncode = '" . $db->escape_string($vbulletin->GPC['optioncode']) . "',
                 defaultvalue = '" . $db->escape_string($vbulletin->GPC['defaultvalue']) . "',
                 displayorder = " . $vbulletin->GPC['displayorder'] . ",
                 volatile = " . $vbulletin->GPC['volatile'] . ",
                 product = '" . $db->escape_string($vbulletin->GPC['product']) . "'
              WHERE varname = '" . $db->escape_string($vbulletin->GPC['varname']) . "'
	   ");

       $newlang = iif($vbulletin->GPC['volatile'], -1, 0);

       $phrases = $db->query_read("
              SELECT
              varname, text, languageid, product
              FROM " . TABLE_PREFIX . "phrase
              WHERE languageid IN (-1,0)
                  AND fieldname = 'vbsettings'
                  AND varname IN ('setting_" . $db->escape_string($vbulletin->GPC['varname']) . "_title', 'setting_" . $db->escape_string($vbulletin->GPC['varname']) . "_desc')
       ");

       $full_product_info = fetch_product_list(true);
       $product_version = $full_product_info['vbcms']['version'];

       while($phrase = $db->fetch_array($phrases))
       {
              if ($phrase['varname'] == "setting_" . $vbulletin->GPC['varname'] . "_title")
              {
                     $q = "
                            UPDATE " . TABLE_PREFIX . "phrase
                            SET
                              languageid = " . iif($vbulletin->GPC['volatile'], -1, 0) . ",
                              text = '" . $db->escape_string($vbulletin->GPC['title']) . "',
                              product = '" . $db->escape_string($vbulletin->GPC['product']) . "',
                              username = '" . $db->escape_string($vbulletin->userinfo['username']) . "',
	                          dateline = " . TIMENOW . ",
                              version = '" . $db->escape_string($product_version) . "'
                            WHERE languageid = $phrase[languageid]
                                 AND varname = 'setting_" . $db->escape_string($vbulletin->GPC['varname']) . "_title'
                     ";
                     $db->query_write($q);
              }else if ($phrase['varname'] == "setting_" . $vbulletin->GPC['varname'] . "_desc"){
                     $q = "
                            UPDATE " . TABLE_PREFIX . "phrase
                            SET
                               languageid = " . iif($vbulletin->GPC['volatile'], -1, 0) . ",
                               text = '" . $db->escape_string($vbulletin->GPC['description']) . "',
	                           product = '" . $db->escape_string($vbulletin->GPC['product']) . "',
                               username = '" . $db->escape_string($vbulletin->userinfo['username']) . "',
                               dateline = " . TIMENOW . ",
                               version = '" . $db->escape_string($product_version) . "'
                            WHERE languageid = $phrase[languageid]
                                AND varname = 'setting_" . $db->escape_string($vbulletin->GPC['varname']) . "_desc'
                     ";
                     $db->query_write($q);
              }
       }

       update_vbcms_optionscache();

       define('CP_REDIRECT', 'vbcms_admin.php?do=defaultoptions&amp;dogroup=' . $vbulletin->GPC['grouptitle']);
       print_stop_message('saved_setting_x_successfully', $vbulletin->GPC['title']);
}

// =================[ Secure-message delete setting or settinggroup ]==================

if($_REQUEST['do'] == 'removegroup' OR $_REQUEST['do'] == 'removesetting')
{
        $vbulletin->input->clean_array_gpc('r', array(
                'grouptitle'    => TYPE_STR
        ));
        trim($vbulletin->GPC['grouptitle']);

        if(!$vbulletin->GPC['grouptitle'])
        {
                $vbulletin->GPC['grouptitle'] =& trim($vbulletin->GPC['varname']);
                $settingdelete = true;
        }

        print_cp_header($vbphrase['confirm_deletion']);
        echo '<p>&nbsp;</p><p>&nbsp;</p>';
		print_form_header('vbcms_admin', iif($settingdelete, 'delete_setting', 'delete_group'));
        construct_hidden_code(iif($settingdelete, 'setting', 'settinggroup'), $vbulletin->GPC['grouptitle']);
	    print_table_header(construct_phrase($vbphrase['confirm_deletion_x'], $vbulletin->GPC['grouptitle']));
		print_description_row("
					<div align=\"center\"><blockquote><br />
					" . construct_phrase($vbphrase["are_you_sure_want_to_delete_setting_x"], $vbulletin->GPC['grouptitle']) . "
					<br /></div></blockquote>\n\t");
		print_submit_row($vbphrase['yes'], 0, 2, $vbphrase['no']);
}

// =================[ delete setting ]==================

if ($_POST['do'] == 'delete_setting')
{
        $vbulletin->input->clean_array_gpc('p', array(
                'setting' => TYPE_STR
        ));

        $setting = $db->query_first("
                SELECT
                *
                FROM " . TABLE_PREFIX . "vbcmssettings
                WHERE varname = '" . $db->escape_string($vbulletin->GPC['setting']) . "'
        ");

        $db->query_write("
                DELETE FROM " . TABLE_PREFIX . "phrase
		        WHERE languageid IN (-1, 0)
		             AND fieldname = 'vbsettings'
		             AND varname IN ('setting_" . $db->escape_string($setting['varname']) . "_title', 'setting_" . $db->escape_string($setting['varname']) . "_desc')
        ");

        $db->query_write("
                DELETE FROM " . TABLE_PREFIX . "vbcmssettings
                WHERE varname = '" . $db->escape_string($setting['varname']) . "'
        ");

        update_vbcms_modulcache();
        define('CP_REDIRECT', 'vbcms_admin.php?do=defaultoptions');
        print_stop_message('deleted_setting_successfully');
}

// =================[ delete settinggroup ]==================

if($_POST['do'] == 'delete_group')
{
        $vbulletin->input->clean_array_gpc('p', array(
                'settinggroup'    => TYPE_STR
        ));

        $settinggroup = $db->query_first("
                SELECT
                *
                FROM " . TABLE_PREFIX . "vbcmssettinggroups
                WHERE grouptitle = '" . $db->escape_string($vbulletin->GPC['settinggroup']) . "'
        ");

        $setarray = array();
        $settings_query = $db->query_read("
                SELECT
                varname
                FROM " . TABLE_PREFIX . "vbcmssettings
                WHERE grouptitle = '$settinggroup[grouptitle]'
        ");
        while($settings_row = $db->fetch_array($settings_query))
        {
                $setarray[] = $db->escape_string($settings_row['varname']);
        }

        $db->query_write("
                DELETE
                FROM " . TABLE_PREFIX . "vbcmssettings
                WHERE varname IN ('" . implode("', '", $setarray) . "')
        ");
        $db->query_write("
                DELETE
                FROM " . TABLE_PREFIX . "vbcmssettinggroups
                WHERE grouptitle = '" . $db->escape_string($settinggroup['grouptitle']) . "'
        ");

        $phrase_array = array("settinggroup_$settinggroup[grouptitle]");
        foreach($setarray AS $setting_name)
        {
                $phrase_array[] = 'setting_' . $setting_name . '_title';
                $phrase_array[] = 'setting_' . $setting_name . '_desc';
        }

        $db->query_write("
                DELETE
                FROM " . TABLE_PREFIX . "phrase
                WHERE languageid IN (-1,0)
                     AND fieldname = 'vbsettings'
                     AND varname IN ('" . implode("', '", $phrase_array) . "')
        ");
        update_vbcms_modulcache();
        define('CP_REDIRECT', 'vbcms_admin.php?do=defaultoptions');
        print_stop_message('deleted_setting_group_successfully');


}

// =================[ Save setting input ]==================

if($_POST['do'] == 'dooptions')
{
        $vbulletin->input->clean_array_gpc('p', array(
                'setting'     => TYPE_ARRAY,
                'advanced'    => TYPE_BOOL,
                'makeimplode' => TYPE_INT,
                'dogroup'     => TYPE_STR,
                'mode'        => TYPE_STR,
                'modul_edit'  => TYPE_INT,
                'area_edit'   => TYPE_INT
        ));

        if(is_demo_mode())
        {
              print_cp_message('This function is disabled within demo mode');
        }

        if($vbulletin->GPC['makeimplode'] AND is_array($vbulletin->GPC['setting']))
        {
                foreach($vbulletin->GPC['setting'] AS $key => $value)
                {
                        if(is_array($vbulletin->GPC['setting']["$key"]))
                        {
                                $vbulletin->GPC['setting']["$key"] = implode(',', $vbulletin->GPC['setting']["$key"]);
                        }
                }
        }

        if(is_array($vbulletin->GPC['setting']))
		{
		        $pos_query = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "vbcmssettings");

                while ($pos_row = $db->fetch_array($pos_query))
                {
                        if(!isset($vbulletin->GPC['setting']["$pos_row[varname]"]))
                        {
                                continue;
                        }

                        $displayorder = $vbulletin->GPC['setting']["$pos_row[varname]"];

                        if($pos_row['value'] != $displayorder)
                        {
                                $db->query_write("
                                        UPDATE " . TABLE_PREFIX . "vbcmssettings
                                        SET
                                           value = '" . $db->escape_string($displayorder) . "'
                                        WHERE varname = '" . $db->escape_string($pos_row['varname']) . "'
                                ");
                        }
                }
		        update_vbcms_optionscache();

		        if($vbulletin->GPC['modul_edit'])
				{
				        define('CP_REDIRECT', 'vbcms_admin.php?do=medit&amp;mode=' . $vbulletin->GPC['mode'] . '&amp;varname=' . $vbulletin->GPC['dogroup'] . '#modulsetting_' . $vbulletin->GPC['dogroup']);

                }else if($vbulletin->GPC['area_edit']){

                        define('CP_REDIRECT', 'vbcms_admin.php?do=edit_area&amp;varname=' . $vbulletin->GPC['dogroup'] . '#modulsetting_' . $vbulletin->GPC['dogroup']);

				}else{
					    define('CP_REDIRECT', 'vbcms_admin.php?do=defaultoptions&amp;dogroup=' . $vbulletin->GPC['dogroup'] . '&amp;advanced= ' . $vbulletin->GPC['advanced']);
				}
	            print_stop_message('saved_setting_x_successfully', $vbulletin->GPC['title']);
        }

}

// =================[ Show settingpage ]==================

if($_REQUEST['do'] == 'defaultoptions')
{

		print_cp_header($vbphrase['vbcms_nav_settings']);
		echo '<script type="text/javascript" src="../clientscript/vbulletin_cpoptions_scripts.js"></script>';
        require_once(DIR . '/includes/adminfunctions_language.php');

        $vbulletin->input->clean_array_gpc('r', array(
                'advanced'    => TYPE_BOOL,
                'showmodules' => TYPE_BOOL,
                'mode'        => TYPE_STR
        ));

        $settingscache = array();
        $options = array('[all]' => '-- ' . $vbphrase['show_all_settings'] . ' --');
        $lastgroup = '';

        $settings = $db->query_read("
                SELECT setting.*, settinggroup.grouptitle
                FROM " . TABLE_PREFIX . "vbcmssettinggroups AS settinggroup
                LEFT JOIN " . TABLE_PREFIX . "vbcmssettings AS setting USING(grouptitle)
                " . iif($vbulletin->debug, '', 'WHERE settinggroup.display <> 0') . "
                ORDER BY settinggroup.display, setting.displayorder ASC
        ");

        while($setting = $db->fetch_array($settings))
        {
                $settingscache["$setting[grouptitle]"]["$setting[varname]"] = $setting;
                if($setting['grouptitle'] != $lastgroup)
                {
                        $grouptitlecache["$setting[grouptitle]"] = $setting['grouptitle'];

                        if(preg_match('#^vbcmsmodul_(.*)$#siU', $setting['grouptitle'], $matches))
                        {
                                $options["$vbphrase[vbcms_settingmodul_option]"]["$setting[grouptitle]"] = $settingphrase["settinggroup_$setting[grouptitle]"];

                        }else if(preg_match('#^vbcmsarea_(.*)$#siU', $setting['grouptitle'], $matches)){

                                $options["$vbphrase[vbcms_settingarea_option]"]["$setting[grouptitle]"] = $settingphrase["settinggroup_$setting[grouptitle]"];
                        }else{
                                $options["$vbphrase[vbcms_general_settings]"]["$setting[grouptitle]"] = $settingphrase["settinggroup_$setting[grouptitle]"];
                        }

                }
                $lastgroup = $setting['grouptitle'];
        }
        $altmode = 1;
        $linktext =& $vbphrase['expand_setting_groups'];

        $db->free_result($settings);

        $optionsmenu = "\n\t<select name=\"" . iif($vbulletin->GPC['expand'], 'varname', 'dogroup') . "\" class=\"bginput\" tabindex=\"1\" " . iif(empty($vbulletin->GPC['dogroup']), 'ondblclick="this.form.submit();" size="20"', 'onchange="this.form.submit();"') . " style=\"width:350px\">\n" . construct_select_options($options, iif($vbulletin->GPC['dogroup'], $vbulletin->GPC['dogroup'], '[all]')) . "\t</select>\n\t";

        print_form_header('vbcms_admin', 'defaultoptions', 0, 1, 'groupForm', '90%', '', 1, 'get');

        if(empty($vbulletin->GPC['dogroup'])) // show the big <select> with no options
        {
                print_table_header($vbphrase['vbcms_nav_settings']);
                print_label_row($vbphrase['settings_to_edit'] .
                        iif($vbulletin->debug OR $vbulletin->vbcmsoptions['vbcms_debug'],
                                '<br /><table><tr><td><fieldset><legend>Developer Options</legend>
                                <div style="padding: 2px"><a href="vbcms_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=addsettinggroup">' . $vbphrase['add_new_setting_group'] . '</a></div>
                                <!--<div style="padding: 2px"><a href="vbcms_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=files">' . $vbphrase['download_upload_settings'] . '</a></div>-->' .
                                '</fieldset></td></tr></table>'
                        ) .
                        "<!-- <p><a href=\"vbcms_admin.php?" . $vbulletin->session->vars['sessionurl'] . "do=defaultoptions&amp;expand=$altmode\">$linktext</a></p>
                        <p><a href=\"vbcms_admin.php?" . $vbulletin->session->vars['sessionurl'] . "do=backuprestore\">" . $vbphrase['backup_restore_settings'] . "</a>-->", $optionsmenu); // TO DO
                print_submit_row($vbphrase['edit_settings'], 0);

        }else{

                print_table_header("$vbphrase[setting_group] $optionsmenu <input type=\"submit\" value=\"$vbphrase[go]\" class=\"button\" tabindex=\"1\" />");
                print_table_footer();

                // show selected settings
                print_form_header('vbcms_admin', 'dooptions', false, true, 'optionsform" onsubmit="return count_errors()');
                construct_hidden_code('dogroup', $vbulletin->GPC['dogroup']);
                construct_hidden_code('advanced', $vbulletin->GPC['advanced']);

                if($vbulletin->GPC['dogroup'] == '[all]') // show all settings groups
                {
                        foreach($grouptitlecache AS $curgroup => $group)
                        {
                                vbcms_setting_group($curgroup, $vbulletin->GPC['advanced']);
                                print_description_row("<input type=\"submit\" class=\"button\" value=\" $vbphrase[save] \" tabindex=\"1\" title=\"" . $vbphrase['save_settings'] . "\" />", 0, 2, 'tfoot" style="padding:1px" align="right');
                                print_table_break(' ');
                        }

                }else{

                        vbcms_setting_group($vbulletin->GPC['dogroup'], $vbulletin->GPC['advanced']);
                }

                print_submit_row($vbphrase['save']);

                ?>
                <div id="error_output" style="font: 10pt courier new"></div>
                <script type="text/javascript">
                <!--
                var error_confirmation_phrase = "<?php echo $vbphrase['error_confirmation_phrase']; ?>";
                //-->
                </script>
                <script type="text/javascript" src="../clientscript/vbulletin_settings_validate.js"></script>
                <?php
        }
}

// ====================[ Sort areas vertiacaly ]==============================

if($_POST['do'] == 'position_areas')
{

        if(is_demo_mode())
        {
                print_cp_message('This function is disabled within demo mode');
        }

        $vbulletin->input->clean_array_gpc('p', array('position_def' => TYPE_ARRAY));

        if(is_array($vbulletin->GPC['position_def']))
        {
                $pos_query = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "vbcmsareas");
                while ($pos_row = $db->fetch_array($pos_query))
                {
                        if(!isset($vbulletin->GPC['position_def']["$pos_row[id]"]))
                        {
                                continue;
                        }

                        $displayorder = intval($vbulletin->GPC['position_def']["$pos_row[id]"]);

                        if($pos_row['position'] != $displayorder)
                        {
                                $db->query_write("
                                        UPDATE " . TABLE_PREFIX . "vbcmsareas
                                        SET
                                           position = $displayorder
                                        WHERE id = $pos_row[id]
                                 ");
                        }
                }
                update_vbcms_areacache();
                define('CP_REDIRECT', 'vbcms_admin.php?do=editareas');
                print_stop_message('saved_setting_x_successfully', $vbulletin->GPC['title']);
        }
}

// ====================[ Sort modules vertiacaly ]==============================

if($_POST['do'] == 'position')
{

        if(is_demo_mode())
        {
                print_cp_message('This function is disabled within demo mode');
        }

        $vbulletin->input->clean_array_gpc('p', array('position_def' => TYPE_ARRAY));

        if(is_array($vbulletin->GPC['position_def']))
        {
                $pos_query = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "vbcmsglobalmodules");
                while ($pos_row = $db->fetch_array($pos_query))
                {
                        if(!isset($vbulletin->GPC['position_def']["$pos_row[id]"]))
                        {
                                continue;
                        }

                        $displayorder = intval($vbulletin->GPC['position_def']["$pos_row[id]"]);

                        if($pos_row['position'] != $displayorder)
                        {
                                $db->query_write("
                                        UPDATE " . TABLE_PREFIX . "vbcmsglobalmodules
                                        SET
                                           position = $displayorder
                                        WHERE id = $pos_row[id]
                                 ");
                        }
                }
                update_vbcms_modulcache();
                define('CP_REDIRECT', 'vbcms_admin.php?do=editmodules');
                print_stop_message('saved_setting_x_successfully', $vbulletin->GPC['title']);
        }
}

// ======[ Move module to (left,middle or right) position ]===========

if($_REQUEST['do'] == 'move_modul')
{
        $vbulletin->input->clean_array_gpc('r', array(
                'id'       => TYPE_INT,
                'move_to'  => TYPE_INT
        ));
        if(is_demo_mode())
        {
              print_cp_message('This function is disabled within demo mode');
        }
        $field = "colum = " . $vbulletin->GPC['move_to'] . "";
        $where = "id = " . $vbulletin->GPC['id'] . "";

        modules_move('vbcmsglobalmodules', $field, $where);
        update_vbcms_modulcache();
        define('CP_REDIRECT', 'vbcms_admin.php?do=editmodules#modul_position');
	    print_stop_message('saved_setting_x_successfully', $vbulletin->GPC['title']);
}

// ====================[ Show default area page ]==============================

if($_REQUEST['do'] == 'editareas')
{
        print_cp_header($vbphrase['vbcms_nav_area']);
        
        print_vbcms_quicklinks('areas', 12); 
        
        print_form_header('vbcms_admin', 'new_area');
        print_table_header("$vbphrase[vbcms_add_area]  <input type=\"submit\" value=\"$vbphrase[go]\" class=\"button\" tabindex=\"1\" />");
        print_table_footer();

        print_form_header('vbcms_admin', 'position_areas');
        print_table_header($vbphrase['vbcms_nav_area'], 4);
        show_sorted_areas();
        print_submit_row($vbphrase['save_display_order'], $vbphrase['reset'], 4);
        print_table_footer();

        print_table_start();
        print_table_header($vbphrase['imexport_areas'], 3);
        echo '<tr valign="top">
                    <td class="thead" align="center">' . $vbphrase['import'] . '</td>
                    <td class="thead" align="center">' . $vbphrase['export'] . '</td>
              </tr>
              <tr valign="top">
                    <td class="alt1" width="50%">
                          <div align="center"><b><a href="vbcms_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=imexportareas&amp;mode=import">' . $vbphrase['import'] . '</a></b></div><br />
                          <fieldset class="fieldset">
                          <legend>' . $vbphrase['portal_new_modul_desc'] . '</legend>
                                ' . $vbphrase['vbcms_import_areas_desc'] . '
                          </fieldset>
                    </td>
                    <td class="alt2" width="50%">
                          <div align="center"><b><a href="vbcms_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=imexportareas&amp;mode=export">' . $vbphrase['export'] . '</a></b></div><br />
                          <fieldset class="fieldset">
                          <legend>' . $vbphrase['portal_new_modul_desc'] . '</legend>
                                ' . $vbphrase['vbcms_export_areas_desc'] . '
                          </fieldset>
                    </td>
              </tr>
        ';
        print_table_footer();
}

// ====================[ Im- or export areas ]==============================

if($_REQUEST['do'] == 'imexportareas')
{
        $vbulletin->input->clean_array_gpc('r', array(
                'mode'       => TYPE_STR
        ));

        switch($vbulletin->GPC['mode'])
        {
                // Import areas
                case 'import':
                {
                        print_cp_header($vbphrase['vbcms_areas'] . ': ' . $vbphrase['import']);
                        print_form_header('vbcms_admin', 'upload_areaxml', true);
                        print_table_header($vbphrase['vbcms_module'] . ': ' . $vbphrase['import'], 3);
                        print_upload_row($vbphrase['upload_xml_file'], 'areafile', 999999999);
                        print_input_row($vbphrase['import_xml_file'], 'serverfile', './install/vbcms_areas.xml');

                        print_yes_no_row($vbphrase['vbcms_xmlimport_addfile'], 'addfile', 0);
                        print_yes_no_row($vbphrase['vbcms_area_override'], 'areaoverride', 0);
                        print_yes_no_row($vbphrase['vbcms_areatemplate_override'], 'templateoverride', 0);
                        print_yes_no_row($vbphrase['vbcms_areasettings_override'], 'settingsoverride', 0);
                        print_submit_row($vbphrase['import']);
                        print_table_footer();
                }
                break;
                // Export areas
                case 'export':
                {
                        $selarr[] = '-- ' . $vbphrase['all'] . ' ' . $vbphrase['vbcms_areas'] . ' --';
                	    foreach($vbulletin->vbcmsareas AS $key => $area)
	                    {
	                              $selarr["$area[include]"] = $area['areaname'];
	                    }
                        print_cp_header($vbphrase['vbcms_areas'] . ': ' . $vbphrase['export']);
                        print_form_header('vbcms_admin', 'download_areaxml');
                        print_table_header($vbphrase['vbcms_areas'] . ': ' . $vbphrase['export'], 3);
                        print_select_row($vbphrase['vbcms_areas'], 'areaname', $selarr);

                        print_yes_no_row($vbphrase['vbcms_xmlexport_settings'], 'settings', 1);
                        print_yes_no_row($vbphrase['vbcms_xmlexport_templates'], 'template', 1);
                        print_yes_no_row($vbphrase['vbcms_xmlexport_phpcode'], 'php_code', 1);
                        print_submit_row($vbphrase['download']);
                        print_table_footer();
                }
                break;
                // Import and export areas
                default:
                {
                        print_cp_header($vbphrase['imexport_modules']);
                        $selarr[] = '-- ' . $vbphrase['all'] . ' ' . $vbphrase['vbcms_areas'] . ' --';
						foreach($vbulletin->vbcmsareas AS $key => $area)
						{
						        $selarr["$area[include]"] = $area['areaname'];
						}
                        print_form_header('vbcms_admin', 'download_areaxml');
                        print_table_header($vbphrase['vbcms_areas'] . ': ' . $vbphrase['export'], 3);
                        print_select_row($vbphrase['vbcms_areas'], 'areaname', $selarr);

                        print_yes_no_row($vbphrase['vbcms_xmlexport_settings'], 'settings', 1);
                        print_yes_no_row($vbphrase['vbcms_xmlexport_templates'], 'template', 1);
                        print_yes_no_row($vbphrase['vbcms_xmlexport_phpcode'], 'php_code', 1);
                        print_submit_row($vbphrase['download']);
                        print_table_footer();

                        print_form_header('vbcms_admin', 'upload_areaxml', true);
                        print_table_header($vbphrase['vbcms_module'] . ': ' . $vbphrase['import'], 3);
                        print_upload_row($vbphrase['upload_xml_file'], 'areafile', 999999999);
                        print_input_row($vbphrase['import_xml_file'], 'serverfile', './install/vbcms_areas.xml');

                        print_yes_no_row($vbphrase['vbcms_xmlimport_addfile'], 'addfile', 0);
                        print_yes_no_row($vbphrase['vbcms_area_override'], 'areaoverride', 0);
                        print_yes_no_row($vbphrase['vbcms_areatemplate_override'], 'templateoverride', 0);
                        print_yes_no_row($vbphrase['vbcms_areasettings_override'], 'settingsoverride', 0);
                        print_submit_row($vbphrase['import']);
                        print_table_footer();

                }
                break;
        }

}

// ====================[ Im- or export modules ]==============================

if($_REQUEST['do'] == 'imexportmodules')
{
        $vbulletin->input->clean_array_gpc('r', array(
                'mode'       => TYPE_STR
        ));

        switch($vbulletin->GPC['mode'])
        {
                // Import modules
                case 'import':
                {
                        print_cp_header($vbphrase['vbcms_module'] . ': ' . $vbphrase['import']);
                        print_form_header('vbcms_admin', 'upload_modulexml', true);
                        print_table_header($vbphrase['vbcms_module'] . ': ' . $vbphrase['import'], 3);
                        print_upload_row($vbphrase['upload_xml_file'], 'modulefile', 999999999);
                        print_input_row($vbphrase['import_xml_file'], 'serverfile', './install/vbcms_modules.xml');

                        print_yes_no_row($vbphrase['portal_module_updateareas'], 'activateareas', 1);
                        print_yes_no_row($vbphrase['vbcms_xmlimport_addfile'], 'addfile', 0);
                        print_yes_no_row($vbphrase['vbcms_module_override'], 'moduloverride', 0);
                        print_yes_no_row($vbphrase['vbcms_template_override'], 'templateoverride', 0);
                        print_yes_no_row($vbphrase['vbcms_settings_override'], 'settingsoverride', 0);
                        print_submit_row($vbphrase['import']);
                        print_table_footer();
                }
                break;
                // Export modules
                case 'export':
                {
                        $selarr[] = '-- ' . $vbphrase['all'] . ' ' . $vbphrase['vbcms_module'] . ' --';
                	    foreach($vbulletin->vbcmsportal AS $modulid => $modul)
	                    {
	                              $selarr["$modul[modulname]"] = $modul['name'];
	                    }
                        print_cp_header($vbphrase['vbcms_module'] . ': ' . $vbphrase['export']);
                        print_form_header('vbcms_admin', 'download_modulexml');
                        print_table_header($vbphrase['vbcms_module'] . ': ' . $vbphrase['export'], 3);
                        print_select_row($vbphrase['vbcms_module'], 'modulename', $selarr);

                        print_yes_no_row($vbphrase['vbcms_xmlexport_settings'], 'settings', 1);
                        print_yes_no_row($vbphrase['vbcms_xmlexport_templates'], 'template', 1);
                        print_yes_no_row($vbphrase['vbcms_xmlexport_phpcode'], 'php_code', 1);
                        print_submit_row($vbphrase['download']);
                        print_table_footer();
                }
                break;
                // Import and export modules
                default:
                {
                        print_cp_header($vbphrase['imexport_modules']);
                        $selarr[] = '-- ' . $vbphrase['all'] . ' ' . $vbphrase['vbcms_module'] . ' --';
                	    foreach($vbulletin->vbcmsportal AS $modulid => $modul)
	                    {
	                              $selarr["$modul[modulname]"] = $modul['name'];
	                    }
                        print_form_header('vbcms_admin', 'download_modulexml');
                        print_table_header($vbphrase['vbcms_module'] . ': ' . $vbphrase['export'], 3);
                        print_select_row($vbphrase['vbcms_module'], 'modulename', $selarr);

                        print_yes_no_row($vbphrase['vbcms_module_override'], 'settings', 1);
                        print_yes_no_row($vbphrase['vbcms_template_override'], 'template', 1);
                        print_yes_no_row($vbphrase['vbcms_settings_override'], 'php_code', 1);
                        print_submit_row($vbphrase['download']);
                        print_table_footer();

                        print_form_header('vbcms_admin', 'upload_modulexml', true);
                        print_table_header($vbphrase['vbcms_module'] . ': ' . $vbphrase['import'], 3);
                        print_upload_row($vbphrase['upload_xml_file'], 'modulefile', 999999999);
                        print_input_row($vbphrase['import_xml_file'], 'serverfile', './install/vbcms_modules.xml');

                        print_yes_no_row($vbphrase['portal_module_updateareas'], 'activateareas', 1);
                        print_yes_no_row($vbphrase['vbcms_xmlimport_addfile'], 'addfile', 0);
                        print_yes_no_row($vbphrase['vbcms_module_override'], 'moduloverride', 0);
                        print_yes_no_row($vbphrase['vbcms_template_override'], 'templateoverride', 0);
                        print_yes_no_row($vbphrase['vbcms_settings_override'], 'settingsoverride', 0);
                        print_submit_row($vbphrase['import']);
                        print_table_footer();

                }
                break;
        }

}

// ====================[ Show default module page ]==============================

if($_REQUEST['do'] == 'editmodules')
{
        //print_cp_header($vbphrase['portal_admin_modules']);
        print_cp_header($vbphrase['vbcms_nav_mods']);
        print_vbcms_quicklinks('module', 11);
        print_table_start();
        print_table_header($vbphrase['portal_new_modules'], 3);
        echo '<tr valign="top">
                    <td class="thead" align="center">' . $vbphrase['portal_new_modul_php'] . '</td>
                    <td class="thead" align="center">' . $vbphrase['portal_new_modul_template'] . '</td>
                    <td class="thead" align="center">' . $vbphrase['portal_new_modul_bbcode'] . '</td>
              </tr>
              <tr valign="top">
                    <td class="alt1" width="33%">
                          <div align="center"><b><a href="vbcms_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=newmodules&amp;mode=php_file">' . $vbphrase['portal_new_modul_php'] . '</a></b></div><br />
                          <fieldset class="fieldset">
                          <legend>' . $vbphrase['portal_new_modul_desc'] . '</legend>
                                ' . $vbphrase['portal_new_modul_php_desc'] . '
                          </fieldset>
                    </td>
                    <td class="alt2" width="33%">
                          <div align="center"><b><a href="vbcms_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=newmodules&amp;mode=template">' . $vbphrase['portal_new_modul_template'] . '</a></b></div><br />
                          <fieldset class="fieldset">
                          <legend>' . $vbphrase['portal_new_modul_desc'] . '</legend>
                                ' . $vbphrase['portal_new_modul_template_desc'] . '
                          </fieldset>
                    </td>
                    <td class="alt1" width="33%">
                          <div align="center"><b><a href="vbcms_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=newmodules&amp;mode=bb_code">' . $vbphrase['portal_new_modul_bbcode'] . '</a></b></div><br />
                          <fieldset class="fieldset">
                          <legend>' . $vbphrase['portal_new_modul_desc'] . '</legend>
                                ' . $vbphrase['portal_new_modul_bbcode_desc'] . '
                          </fieldset>
                    </td>
              </tr>
        ';
        print_table_footer();

        print_form_header('vbcms_admin', 'position');
        print_table_header($vbphrase['portal_admin_modules'] . '<a name="modul_position"></a>', 3);

        show_sorted_modules();

        print_submit_row($vbphrase['save_display_order'], $vbphrase['reset'], 3);
        print_table_footer();

        print_table_start();
        print_table_header($vbphrase['imexport_modules'], 3);
        echo '<tr valign="top">
                    <td class="thead" align="center">' . $vbphrase['import'] . '</td>
                    <td class="thead" align="center">' . $vbphrase['export'] . '</td>
              </tr>
              <tr valign="top">
                    <td class="alt1" width="50%">
                          <div align="center"><b><a href="vbcms_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=imexportmodules&amp;mode=import">' . $vbphrase['import'] . '</a></b></div><br />
                          <fieldset class="fieldset">
                          <legend>' . $vbphrase['portal_new_modul_desc'] . '</legend>
                                ' . $vbphrase['portal_import_modules_desc'] . '
                          </fieldset>
                    </td>
                    <td class="alt2" width="50%">
                          <div align="center"><b><a href="vbcms_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=imexportmodules&amp;mode=export">' . $vbphrase['export'] . '</a></b></div><br />
                          <fieldset class="fieldset">
                          <legend>' . $vbphrase['portal_new_modul_desc'] . '</legend>
                                ' . $vbphrase['portal_export_modules_desc'] . '
                          </fieldset>
                    </td>
              </tr>
        ';
        print_table_footer();
}

// ====================[ Show default vBCMS page ]==============================

if($_REQUEST['do'] == 'default')
{
        print_cp_header($vbphrase['vbcms_admin_start']);
        vbcmscp_default();
}

echo '<p align="center"><a href="http://www.vbsupport.org/forum/index.php">vBCMS&reg; ' . VBCMSVERSION . ', Copyright - NulleD By FintMax</a></p>';

print_cp_footer();

/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # SVN: $RCSfile$ - $Revision: 1600 $
|| ####################################################################
\*======================================================================*/
?>