<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBCMS Version 2.7.0
|| # ------------------------------------------------------------------ # ||
|| # Copyright  2002 - 2009 Reuter & Bloe GbR.                          ||
|| # ------------------- VBCMS IS NOT FREE SOFTWARE ------------------- # ||
|| # http://www.vbdesigns.de | http://www.vbdesigns.de/license.html     # ||
|| ###################################################################### ||
\*========================================================================*/

if(!class_exists('vB_DataManager'))
{
        exit;
}
require_once(DIR . '/includes/functions_newpost.php');

/**
* Base data manager for linkentrys and posts. Uninstantiable.
*
* @package	vBCMS 2.7.0
* @version	$Revision: 1653 $
* @date		$Date: 2009-10-26 15:57:40 +0100 (Mo, 26. Okt 2009) $
*/
class vB_DataManager_vbcmslinks_entrys extends vB_DataManager
{
        /**
        * Constructor - checks that the registry object has been passed correctly.
        *
        * @param	vB_Registry	Instance of the vBulletin data registry object - expected to have the database object as one of its $this->db member.
        * @param	integer		One of the ERRTYPE_x constants
        */
        function vB_DataManager_vbcmslinks_entrys(&$registry, $errtype = ERRTYPE_STANDARD)
        {
                if(!is_subclass_of($this, 'vB_DataManager_vbcmslinks_entrys'))
                {
                        trigger_error("Direct Instantiation of vB_DataManager_vbcmslinks_entrys class prohibited.", E_USER_ERROR);
                }
                parent::vB_DataManager($registry, $errtype);

                ($hook = vBulletinHook::fetch_hook('vbcms_linkentry_start')) ? eval($hook) : false;
        }
        /**
        * Validates the category
        *
        * @param	string	title
        *
        * @return	boolean (mixed)
        */
        function verify_catid(&$catid)
        {
                if($this->registry->vbcmslinkscat[$catid]['options'] & $this->registry->bf_misc_VBCMSLINKOPTIONS['iscat'])
                {
                        $this->error('vbcms_link_notin_cat');
                        return false;
                }
                return true;
        }
        /**
        * Validates the linktitle
        *
        * @param	string	title
        *
        * @return	boolean (mixed)
        */
        function verify_linktitle(&$linktitle)
        {
                $linktitle = trim(preg_replace('/&#(0*32|x0*20);/', ' ', $linktitle));

                if($this->info['linkentry'] AND empty($linktitle))
                {
                        $this->error('nosubject', $this->registry->options['postminchars']);
                        return false;
				}

                if($this->registry->vbcmsoptions['linksarea_titlelen'] AND $linktitle != $this->existing['linktitle'])
                {
                        if(($titlelen = vbstrlen($linktitle)) > $this->registry->vbcmsoptions['linksarea_titlelen'])
                        {
                               // title too long
                               $this->error('title_toolong', $titlelen, $this->registry->vbcmsoptions['linksarea_titlelen']);
                               return false;
                        }
                }
                if($this->condition AND $linktitle != $this->existing['linktitle'])
                {
                        $this->info['update_title'] = true;
                }

                // clean the linktitle no HTML no Shouting an censor
                $linktitle = htmlspecialchars_uni(fetch_no_shouting_text(fetch_censored_text($linktitle)));
                return true;
        }
        /**
        * Validates the linktitle
        *
        * @param	string	title
        *
        * @return	boolean (mixed)
        */
        function verify_userid(&$userid)
        {
                if($userid == $this->registry->userinfo['userid'])
                {
                        $this->info['user'] =& $this->registry->userinfo;
                        $return = true;

                }else if ($userinfo = $this->dbobject->query_first("SELECT * FROM " . TABLE_PREFIX . "user WHERE userid = $userid")){

                        $this->info['user'] =& $userinfo;
                        $return = true;
                }else{

                        $this->error('no_users_matched_your_query');
                        $return = false;
                }
                if($return == true)
                {
                        if(isset($this->validfields['username']))
                        {
                                $this->do_set('username', $this->info['user']['username']);

                        }else if (isset($this->validfields['postusername'])){

                                $this->do_set('postusername', $this->info['user']['username']);
                        }
                }
                return $return;
        }

        /**
        * Validates the pasted urls
        *
        * @param	string	Hyperlink
        *
        * @return	boolean (mixed)
        */
        function verify_linkurl(&$linkurl)
        {
                $linkurl = str_replace('&amp;', '&', $linkurl);

                if($linkurl === 'http://www.' OR $linkurl === '')
                {
                        $this->error('upload_invalid_url');
                        return false;
                }

                if(!$this->condition AND $existlink = $this->dbobject->query_first_slave("
                        SELECT link
                        FROM " . TABLE_PREFIX . "vbcmslinks
                               WHERE link = '" . $this->dbobject->escape_string($linkurl) . "'
                "))
                {
                        $this->error('vbcms_link_x_exist', $linkurl);
                        return false;

                }else if($this->existing['link'] != $linkurl AND $existlink = $this->dbobject->query_first_slave("
                        SELECT link
                        FROM " . TABLE_PREFIX . "vbcmslinks
                               WHERE link = '" . $this->dbobject->escape_string($linkurl) . "'
                ")){
                        $this->error('vbcms_link_x_exist', $linkurl);
                        return false;
                }

                if(!$score = preg_match('/^(http|https|ftp)\:\/\/([a-z0-9-\.]+)[a-z0-9-]+\.[a-z]{2,4}\b/', $linkurl, $match))
                {
                        $this->error('vbcms_not_valid_url', $linkurl);
                        return false;
                }

                return true;
        }

        /**
        * Validates the pasted urls for a banner from other site
        *
        * @param	string	Hyperlink
        *
        * @return	boolean (mixed)
        */
        function verify_banner(&$banner)
        {
                $banner['tmp_name'] = str_replace('&amp;', '&', $banner['tmp_name']);

                if($this->condition AND $this->info['delbanner'])
                {
					   if(@file_exists(DIR . $this->registry->vbcmsoptions['linksarea_savedir'] . '/' . $this->existing['banner']))
					   {
                               @unlink(DIR . $this->registry->vbcmsoptions['linksarea_savedir'] . '/' . $this->existing['banner']);
					   }
					   $this->do_set('banner', $banner['tmp_name']);
					   return false;
                }
                if($banner['tmp_name'] === '')
                {
                        return false;
                }

                $thumbsize = $info = array();
                $thumbsize['width']  =& $this->registry->vbcmsoptions['linksarea_thumbwidth'];
                $thumbsize['height'] =& $this->registry->vbcmsoptions['linksarea_thumbheight'];

                $info['original_dir']      = '/temp/';
                $info['thumbnail_dir']     = '/';
                $info['thumbnailname']     = '';
                $info['existingid']        =& $this->existing['linkid'];

                if($this->condition AND !empty($banner['tmp_name']))
                {
                       //delete existing banner
                       if(!empty($this->existing['banner']))
                       {
					           if(@file_exists(DIR . $this->registry->vbcmsoptions['linksarea_savedir'] . '/' . $this->existing['banner']))
					           {
                                       @unlink(DIR . $this->registry->vbcmsoptions['linksarea_savedir'] . '/' . $this->existing['banner']);
					           }
                       }
                }

                if(!$banner['is_url'])
                {
                        $banner = vbcms_save_imgupload($banner, $this->registry->GPC['catid'], 'linklist', $thumbsize, $this->registry->vbcmsoptions['linksarea_savedir'], $info);

                }else{

                        if(!$score = preg_match('/^(http|https|ftp)\:\/\/([a-z0-9-\.]+)[a-z0-9-]+\.[a-z]{2,4}\b/', $banner['tmp_name'], $match))
                        {
                                $this->error('vbcms_not_valid_url', $banner['tmp_name']);
                                return false;
                        }

                        if(ini_get('allow_url_fopen') == 0)
                        {
                                $this->error('upload_fopen_disabled');
                                return false;
                        }
                        preg_match('/[A-Za-z\.\_]+$/', $banner['tmp_name'], $res);
                        $banner['name'] = $res[0];
                        $banner = vbcms_save_imgupload($banner, $this->registry->GPC['catid'], 'linklist', $thumbsize, $this->registry->vbcmsoptions['linksarea_savedir'], $info, false);

                }
                return true;
        }


        /**
        * Validates the pasted urls
        *
        * @param	int
        *
        * @return	boolean (mixed)
        */
        function verify_active(&$active)
        {
                return true;
        }
        /**
        * Validates the pasted urls
        *
        * @param	int
        *
        * @return	boolean (mixed)
        */
        function email_mods($field)
        {
                global $vbphrase, $vbcms_global;

                if(!$this->condition)
                {
                        if($this->info['linkentry'] AND $catmails_link = $this->registry->vbcmslinkscat[$this->registry->GPC['catid']]['newlinkemail'])
                        {
                                $mods = $this->dbobject->query_read_slave("
                                        SELECT DISTINCT
                                        user.username, user.email, user.userid
                                        FROM " . TABLE_PREFIX . "vbcmslinksmoderators AS vbcmslinksmoderators
                                        LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = vbcmslinksmoderators.userid)
                                                WHERE catid = " . $this->info['cat']['catid'] . " AND perms & 256 AND user.email NOT IN('" . implode('\',\'', explode(' ' ,$catmails_link)) . "')
                                ");
                                while($mods_row = $this->dbobject->fetch_array($mods))
                                {
                                        $catmails_link .= ' ' . $mods_row['email'];
                                }
                                $this->dbobject->free_result($mods);

                                $mailadresses = implode(',', $temp = explode(' ', $catmails_link));
                                $subject = construct_phrase($vbphrase['vbcms_link_emailsubject_newlink'], $this->registry->options['bbtitle']);
                                $message = construct_phrase($vbphrase['vbcms_link_emailmessage_newlink'], (($this->registry->vbcmsoptions['vbcms_url']) ? 'http://' . $_SERVER["HTTP_HOST"] . $this->registry->vbcmsoptions['vbcms_url'] : $this->registry->options['bburl'] . '/')  . $this->registry->vbcmsoptions['vbcms_filename'] . '.php?area=' . $vbcms_global['area'] . '&do=showcat&catid=' . $this->info['cat']['catid'], $this->registry->options['bbtitle']);
                                vbmail($mailadresses, $subject, $message, true);
                        }
                        if($this->info['linkentry_post'] AND $catmails_post = $this->registry->vbcmslinkscat[$this->registry->GPC['catid']]['newlinkemail'])
                        {
                                $mods = $this->dbobject->query_read_slave("
                                        SELECT DISTINCT
                                        user.username, user.email, user.userid
                                        FROM " . TABLE_PREFIX . "vbcmslinksmoderators AS vbcmslinksmoderators
                                        LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = vbcmslinksmoderators.userid)
                                                WHERE catid = " . $this->info['cat']['catid'] . " AND perms & 512 AND user.email NOT IN('" . implode('\',\'', explode(' ' ,$catmails_post)) . "')
                                ");
                                while($mods_row = $this->dbobject->fetch_array($mods))
                                {
                                        $catmails_post .= ' ' . $mods_row['email'];
                                }
                                $this->dbobject->free_result($mods);
                                $mailadresses = implode(',', $temp = explode(' ', $catmails_post));
                                $subject = construct_phrase($vbphrase['vbcms_link_emailsubject_newpost'], $this->registry->options['bbtitle']);
                                $message = construct_phrase($vbphrase['vbcms_link_emailmessage_newpost'], (($this->registry->vbcmsoptions['vbcms_url']) ? 'http://' . $_SERVER["HTTP_HOST"] . $this->registry->vbcmsoptions['vbcms_url'] : $this->registry->options['bburl'] . '/')  . $this->registry->vbcmsoptions['vbcms_filename'] . '.php?area=' . $vbcms_global['area'] . '&do=showcat&catid=' . $this->info['cat']['catid'], $this->registry->options['bbtitle']);
                                vbmail($mailadresses, $subject, $message, true);
                        }
                }
                return true;
        }

        /**
        * Validates the description
        *
        * @param	string	description
        *
        * @return	boolean (mixed)
        */
        function verify_description(&$description)
        {
                if(empty($description) OR ($minlen = vbstrlen($description)) < $this->registry->vbcmsoptions['linksarea_linkdescminlen'])
                {
                        $this->error('tooshort', $this->registry->vbcmsoptions['linksarea_linkdescminlen']);
                        return false;
                }
                if($this->registry->vbcmsoptions['linksarea_linkdesclen'] AND $description != $this->existing['description'])
                {
                        if(($descriptionlen = vbstrlen($description)) > $this->registry->vbcmsoptions['linksarea_linkdesclen'])
                        {
                                $this->error('toolong', $titlelen, $this->registry->vbcmsoptions['linksarea_linkdesclen']);
                                return false;
                        }
                }
                if($this->info['parseurl'])
                {
                        $description = convert_url_to_bbcode($description);
                }

                require_once(DIR . '/includes/functions_login.php');
                $description = fetch_removed_sessionhash($description);
                $description = fetch_no_shouting_text($description);
                return true;
        }
        /**
        * Any checks to run immediately before saving. If returning false, the save will not take place.
        *
        * @param	boolean	Do the query?
        *
        * @return	boolean	True on success; false if an error occurred
        */
        function pre_save_linkentrys($doquery = true)
        {
                if(!$this->condition AND $this->info['linkentry'])
                {
                        if($this->fetch_field('userid', 'vbcmslinks') == 0 AND $this->fetch_field('username', 'vbcmslinks') == '')
                        {
                                $this->error('nousername');
                                return false;
                        }

                        if($this->fetch_field('date', 'vbcmslinks') === null)
                        {
                                $this->set('date', TIMENOW);
                        }

                        if($this->fetch_field('lastcomdate', 'vbcmslinks') === null)
                        {
                                $this->set('lastcomdate', TIMENOW);
                        }

                        if($this->fetch_field('ipaddress', 'vbcmslinks') === null)
                        {
                                $this->set('ipaddress', ($this->registry->options['logip'] ? IPADDRESS : ''));
                        }
                        return true;

                }else if(!$this->condition AND !$this->info['linkentry']){

                        if($this->fetch_field('userid', 'vbcmslinkscomments') == 0 AND $this->fetch_field('username', 'vbcmslinkscomments') == '')
                        {
                                $this->error('nousername');
                                return false;
                        }

                        if($this->fetch_field('date', 'vbcmslinkscomments') === null)
                        {
                                $this->set('date', TIMENOW);
                        }

                        if($this->fetch_field('ipaddress', 'vbcmslinkscomments') === null)
                        {
                                $this->set('ipaddress', ($this->registry->options['logip'] ? IPADDRESS : ''));
                        }
                        return true;
                }
                return true;
        }
        /**
        * Any checks to run immediately before saving. If returning false, the save will not take place.
        *
        * @param	boolean	Do the query?
        *
        * @return	boolean	True on success; false if an error occurred
        */
        function post_save_each_links()
        {
                if(!$this->condition)
                {
                        $catdata =& datamanager_init('vbcmslinks', $this->registry);
                        $catdata->set_existing($this->info['cat']);
                        $catdata->set_info('make_no_cache', true);
                        if($this->info['linkentry'])
                        {

                                if(!empty($this->info['user']['userid']))
                                {
	                                    $this->dbobject->query_write("
	                                            UPDATE " . TABLE_PREFIX . "user
	                                            SET vbcmslinksentrys = vbcmslinksentrys + 1
	                                                 WHERE userid = " . $this->info['user']['userid'] . "
	                                    ");
                                }
                                $catdata->set('linkscount', 'linkscount + 1', false);

                                if($this->vbcmslinks['active'] == 0)
                                {

                                        $catdata->set('lastlinkid', $this->fetch_field('linkid'));
                                        $catdata->set('lastlinktitle', $this->fetch_field('linktitle'));
                                        $catdata->set('lastlinkuserid', $this->fetch_field('userid'));
                                        $catdata->set('lastlinkusername', $this->fetch_field('username'));
                                        $catdata->set('lastlinkdate', $this->fetch_field('date'));
                                }
                        }else{

                                if(!empty($this->info['user']['userid']))
                                {
	                                    $this->dbobject->query_write("
	                                            UPDATE " . TABLE_PREFIX . "user
	                                            SET vbcmslinkscomments = vbcmslinkscomments + 1
	                                                 WHERE userid = " . $this->info['user']['userid'] . "
	                                    ");
                                }
                                $catdata->set('commentcount', 'commentcount + 1', false);

                                if($this->vbcmslinkscomments['active'] == 0)
                                {
                                        $catdata->set('lastcomid', $this->fetch_field('commentid'));
                                        $catdata->set('lastcomlinkid', $this->fetch_field('linkid'));
                                        $catdata->set('lastcomtitle', $this->fetch_field('commenttitle'));
                                        $catdata->set('lastcomuserid', $this->fetch_field('userid'));
                                        $catdata->set('lastcomusername', $this->fetch_field('username'));
                                        $catdata->set('lastcomdate', $this->fetch_field('date'));
                                }
                                $linkdata =& datamanager_init('linkentry', $this->registry, ERRTYPE_ARRAY, 'vbcmslinks_entrys');
                                $linkdata->set_existing($this->info['link']);
                                $linkdata->set('replycount', 'replycount + 1', false);
                                $linkdata->set('lastcomid', $this->fetch_field('commentid'));
                                $linkdata->set('lastcomuserid', $this->fetch_field('userid'));
                                $linkdata->set('lastcomusername', $this->fetch_field('username'));
                                $linkdata->set('lastcomdate', $this->fetch_field('date'));
                                $linkdata->save();
                        }
                        $catdata->save();

                }else if($this->info['update_title']){

                        $catdata =& datamanager_init('vbcmslinks', $this->registry);
                        $catdata->set_existing($this->info['cat']);
                        $catdata->set_info('update_parents', true);
                        $catdata->set_info('make_no_cache', true);

                        $infoarr = $this->dbobject->query_first_slave("
                                        SELECT lastcomid, lastlinkid
                                        FROM " . TABLE_PREFIX . "vbcmslinkscats
                                           WHERE catid = " . $this->info['cat']['catid'] . "
                        ");

                        if($this->info['linkentry'])
                        {
                                if($this->existing['linkid'] != $infoarr['lastlinkid'])
                                {
                                        return false;
                                }
                                $catdata->set('lastlinktitle', $this->fetch_field('linktitle'));
                        }else{

                                if($this->existing['commentid'] != $infoarr['lastcomid'])
                                {
                                        return false;
                                }
                                $catdata->set('lastcomtitle', $this->fetch_field('commenttitle'));
                        }
                        $catdata->save();
                }

                if($this->info['rebuild_counter'])
                {
                        $this->rebuild_counter($this->info['new_catid']);
                        $this->rebuild_counter($this->info['cat']['catid']);
                }

        }

        /**
        * Rebuilds the counter, when we have move links
        *
        * @param	interger	catid
        *
        * @return	boolean	    True
        */
        function rebuild_counter($catid)
        {
                $catinfo = $this->registry->vbcmslinkscat[$catid];
                $linkids = array();

                $linkscounter = $this->dbobject->query_first_slave("
                        SELECT
                        COUNT(*) AS linkstotal, SUM(replycount) AS commentstotal
		                FROM " . TABLE_PREFIX . "vbcmslinks
		                     WHERE catid = $catid
		        ");

		        $lastlinkinfo = $this->dbobject->query_first_slave("
                        SELECT
                        *
		                FROM " . TABLE_PREFIX . "vbcmslinks
		                     WHERE catid = $catid
		                          AND active = 0
		                ORDER BY date DESC
		        ");

		        $lastlinkinfo_ids = $this->dbobject->query_read_slave("
                        SELECT
                        linkid
		                FROM " . TABLE_PREFIX . "vbcmslinks
		                     WHERE catid = $catid
		                ORDER BY lastcomid DESC
		        ");

				while($links_row = $this->dbobject->fetch_array($lastlinkinfo_ids))
				{
		                $linkids[] = $links_row['linkid'];
                }
                $this->dbobject->free_result($lastlinkinfo_ids);

                if($linkids)
                {
		                $lastcommentinfo = $this->dbobject->query_first_slave("
                                SELECT
                                *
		                        FROM " . TABLE_PREFIX . "vbcmslinkscomments
		                             WHERE linkid IN(" . implode(',', $linkids) . ") AND active = 0
		                        ORDER BY date DESC

		                ");
		        }

                $catdata =& datamanager_init('vbcmslinks', $this->registry);

                $catdata->set_existing($catinfo);
                $catdata->set_info('update_parents', true);
                $catdata->set_info('make_no_cache', true);

                $catdata->set('linkscount', $linkscounter['linkstotal'], true, false);
                $catdata->set('lastlinkid', $lastlinkinfo['linkid'], true, false);
                $catdata->set('lastlinktitle', $lastlinkinfo['linktitle'], true, false);
                $catdata->set('lastlinkuserid', $lastlinkinfo['userid'], true, false);
                $catdata->set('lastlinkusername', $lastlinkinfo['username'], true, false);
                $catdata->set('lastlinkdate', $lastlinkinfo['date'], true, false);
                $catdata->set('commentcount', $linkscounter['commentstotal'], true, false);
                $catdata->set('lastcomid', $lastcommentinfo['commentid'], true, false);
                $catdata->set('lastcomlinkid', $lastcommentinfo['linkid'], true, false);
                $catdata->set('lastcomtitle', $lastcommentinfo['commenttitle'], true, false);
                $catdata->set('lastcomuserid', $lastcommentinfo['userid'], true, false);
                $catdata->set('lastcomusername', $lastcommentinfo['username'], true, false);
                $catdata->set('lastcomdate', $lastcommentinfo['date'], true, false);
                $catdata->save();

                return true;
        }
}

/**
* Class to do data save/delete operations for linkentrys
*
* @package	vBCMS 2.7.0
* @version	$Revision: 1653 $
* @date		$Date: 2009-10-26 15:57:40 +0100 (Mo, 26. Okt 2009) $
*/    
class vB_DataManager_linkentry extends vB_DataManager_vbcmslinks_entrys
{
        /**
        * Array of recognised and required fields for posts, and their types
        *
        * @var	array
        */
        var $validfields = array(
                'linkid'          => array(TYPE_UINT,   REQ_INCR,  'return ($data > 0);'),
                'linktitle'       => array(TYPE_STR,    REQ_YES,   VF_METHOD),
                'link'            => array(TYPE_NOHTML, REQ_YES,   VF_METHOD,    'verify_linkurl'),
                'banner'          => array(TYPE_ARRAY,  REQ_NO,    VF_METHOD),
                'description'     => array(TYPE_STR,    REQ_YES,   VF_METHOD),
                'active'          => array(TYPE_INT,    REQ_NO,    VF_METHOD),
                'open'            => array(TYPE_INT,    REQ_NO),
                'catid'           => array(TYPE_UINT,   REQ_YES,   VF_METHOD),
                'userid'          => array(TYPE_UINT,   REQ_NO,    VF_METHOD),
                'username'        => array(TYPE_STR,    REQ_NO,    VF_METHOD),
                'date'            => array(TYPE_INT,    REQ_AUTO),
                'ipaddress'       => array(TYPE_STR,    REQ_AUTO),
                'lastcomdate'     => array(TYPE_INT,    REQ_NO),
                'lastcomid'       => array(TYPE_UINT,   REQ_NO),
                'lastcomuserid'   => array(TYPE_UINT,   REQ_NO),
                'lastcomusername' => array(TYPE_STR,    REQ_NO),
                'replycount'      => array(TYPE_INT,    REQ_NO),
                'votenum'         => array(TYPE_INT,    REQ_NO),
                'votetotal'       => array(TYPE_INT,    REQ_NO),
                'hits'            => array(TYPE_INT,    REQ_NO),
                'hitsred'         => array(TYPE_INT,    REQ_NO),
                'croncheck'       => array(TYPE_INT,    REQ_NO)                
        );

        /**
        * Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
        *
        * @var	array
        */
        var $bitfields = array();

        /**
        * The main table this class deals with
        *
        * @var	string
        */
        var $table = 'vbcmslinks';

        /**
        * Condition template for update query
        * This is for use with sprintf(). First key is the where clause, further keys are the field names of the data to be used.
        *
        * @var	array
        */
        var $condition_construct = array('linkid = %1$d', 'linkid');

        /**
        * Array to store stuff to save to vbcmslinks table
        *
        * @var	array
        */
        var $vbcmslinks = array();

        /**
        * Constructor - checks that the registry object has been passed correctly.
        *
        * @param	vB_Registry	Instance of the vBulletin data registry object - expected to have the database object as one of its $this->db member.
        * @param	integer		One of the ERRTYPE_x constants
        */
        function vB_DataManager_linkentry(&$registry, $errtype = ERRTYPE_STANDARD)
        {
                parent::vB_DataManager_vbcmslinks_entrys($registry, $errtype);

                ($hook = vBulletinHook::fetch_hook('vbcms_linkentrydata_start')) ? eval($hook) : false;
        }
        /**
        * Any checks to run immediately before saving. If returning false, the save will not take place.
        *
        * @param	boolean	Do the query?
        *
        * @return	boolean	True on success; false if an error occurred
        */
        function pre_save($doquery = true)
        {
                if($this->presave_called !== null)
                {
                        return $this->presave_called;
                }
                if(!$this->pre_save_linkentrys($doquery))
                {
                        $this->presave_called = false;
                        return false;
                }
                $return_value = true;
                ($hook = vBulletinHook::fetch_hook('vbcms_linkentrydata_presave')) ? eval($hook) : false;

                $this->presave_called = $return_value;
                return $return_value;
        }
        /**
        * Additional data to update after a save call (such as denormalized values in other tables).
        * In batch updates, is executed for each record updated.
        *
        * @param	boolean	Do the query?
        */
        function post_save_each($doquery = true)
        {
		        $this->post_save_each_links($doquery);

                if(!$this->condition)
                {
                        $this->email_mods('newlinkmail');
                }

                ($hook = vBulletinHook::fetch_hook('vbcms_linkentrydata_save')) ? eval($hook) : false;
        }

        /**
        * Deletes a linkentry (public)
        *
        * @param	string  Condition construct
        *
        * @return	boolean
        */
        function delete($condition)
        {
                $userinfo = $catids = $lastcomments = array();

                $links = $this->dbobject->query_read("
				        SELECT
				        *
				        FROM " . TABLE_PREFIX . "vbcmslinks
				              WHERE " . $condition
				);

				while($links_row = $this->dbobject->fetch_array($links))
				{
				         $counter++;

                         $catids[$links_row['catid']]++;

                         $userinfo[$links_row['userid']]++;

                         if($links_row['lastcomid'] > 0)
                         {
                                 $lastcomments[] = $links_row['linkid'];
                         }
                         if(@file_exists(DIR . $this->registry->vbcmsoptions['linksarea_savedir'] . $links_row['banner']))
                         {
                                 @unlink(DIR . $this->registry->vbcmsoptions['linksarea_savedir'] . $links_row['banner']);
                         }
                }
                $this->dbobject->free_result($links);

                // Update counter for the category
                if(!empty($counter))
                {
                        foreach($catids AS $key => $count)
                        {
                                $this->dbobject->query_write("
				                       UPDATE " . TABLE_PREFIX . "vbcmslinkscats
					                   SET
					                     linkscount = linkscount - $count
					                   WHERE catid = " . $key . "
	                            ");
	                    }
                }

                // Update user links counter
                if(!empty($userinfo))
                {
                        foreach($userinfo AS $key => $com)
                        {
                                $sql .= "WHEN $key THEN vbcmslinksentrys - $com\n";
                        }

                        $this->dbobject->query_write("
				                UPDATE " . TABLE_PREFIX . "user SET
					            vbcmslinksentrys = CASE userid
					                 $sql
					            ELSE vbcmslinksentrys
                                END
	                    ");
	            }

                // Delete comments when existing
                if(!empty($lastcomments))
                {
                        $lastcomments = implode(',', $lastcomments);
                        $condition_comments = "linkid IN($lastcomments)";
                        $commentobj =& datamanager_init('linkentry_comments', $this->registry, ERRTYPE_SILENT, 'vbcmslinks_entrys');
                        $commentobj->set_info('cat', $key);
						$commentobj->delete($condition_comments, false, $catids);
                }

                $this->db_delete(TABLE_PREFIX, 'vbcmslinks', $condition);

                foreach($catids AS $key => $count)
                {
                        $this->rebuild_counter($key);
                }
                return true;
        }
}

/**
* Class to do data save/delete operations for linkentrys
*
* @package	vBCMS 2.7.0
* @version	$Revision: 1653 $
* @date		$Date: 2009-10-26 15:57:40 +0100 (Mo, 26. Okt 2009) $
*/
class vB_DataManager_linkentry_comments extends vB_DataManager_vbcmslinks_entrys
{
        /**
        * Array of recognised and required fields for posts, and their types
        *
        * @var	array
        */
        var $validfields = array(
                'commentid'      => array(TYPE_UINT,   REQ_INCR,  'return ($data > 0);'),
                'commenttitle'   => array(TYPE_STR,    REQ_YES,   VF_METHOD , 'verify_linktitle'),
                'description'    => array(TYPE_STR,    REQ_YES,   VF_METHOD),
                'linkid'         => array(TYPE_UINT,   REQ_NO),
                'active'         => array(TYPE_INT,    REQ_NO,    VF_METHOD),
                'userid'         => array(TYPE_UINT,   REQ_NO,    VF_METHOD),
                'username'       => array(TYPE_STR,    REQ_NO,    VF_METHOD),
                'date'           => array(TYPE_INT,    REQ_AUTO),
                'ipaddress'      => array(TYPE_STR,    REQ_AUTO)
        );

        /**
        * Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
        *
        * @var	array
        */
        var $bitfields = array();

        /**
        * The main table this class deals with
        *
        * @var	string
        */
        var $table = 'vbcmslinkscomments';

        /**
        * Condition template for update query
        * This is for use with sprintf(). First key is the where clause, further keys are the field names of the data to be used.
        *
        * @var	array
        */
        var $condition_construct = array('commentid = %1$d', 'commentid');

        /**
        * Array to store stuff to save to vbcmslinks table
        *
        * @var	array
        */
        var $vbcmslinkscomments  = array();

        /**
        * Constructor - checks that the registry object has been passed correctly.
        *
        * @param	vB_Registry	Instance of the vBulletin data registry object - expected to have the database object as one of its $this->db member.
        * @param	integer		One of the ERRTYPE_x constants
        */
        function vB_DataManager_linkentry_comments(&$registry, $errtype = ERRTYPE_STANDARD)
        {
                parent::vB_DataManager_vbcmslinks_entrys($registry, $errtype);

                ($hook = vBulletinHook::fetch_hook('vbcms_commententry_start')) ? eval($hook) : false;
        }
        /**
        * Any checks to run immediately before saving. If returning false, the save will not take place.
        *
        * @param	boolean	Do the query?
        *
        * @return	boolean	True on success; false if an error occurred
        */
        function pre_save($doquery = true)
        {
                if($this->presave_called !== null)
                {
                        return $this->presave_called;
                }

                if(!$this->pre_save_linkentrys($doquery))
                {
                        $this->presave_called = false;
                        return false;
                }
                $return_value = true;
                ($hook = vBulletinHook::fetch_hook('vbcms_commententry_presave')) ? eval($hook) : false;

                $this->presave_called = $return_value;
                return $return_value;
        }
        /**
        * Additional data to update after a save call (such as denormalized values in other tables).
        * In batch updates, is executed for each record updated.
        *
        * @param	boolean	Do the query?
        */
        function post_save_each($doquery = true)
        {
		        $this->post_save_each_links($doquery);

                if(!$this->condition)
                {
                        $this->email_mods('newcommentmail');
                }

                ($hook = vBulletinHook::fetch_hook('vbcms_commententry_save')) ? eval($hook) : false;
        }


        /**
        * Deletes a comment (public)
        *
        * @param	string  Condition construct
        * @param	boolean	nothing
        *
        * @return	boolean
        */
        function delete($condition, $updatelinks = true, $catids)
        {

                $counter_links = array();
                $com = $this->dbobject->query_read("
				        SELECT
				        *
				        FROM " . TABLE_PREFIX . "vbcmslinkscomments
				              WHERE " . $condition
				);

				while($com_row = $this->dbobject->fetch_array($com))
				{
                        $counter_links[$com_row['linkid']]['replycounter']++;
                        $userinfo[$com_row['userid']]++;
                }
                $this->dbobject->free_result($com);
                unset($com);

                // Update linksentry
                if(!empty($counter_links) AND $updatelinks)
                {
                        $com = $this->dbobject->query_read("
				                SELECT
				                *
				                FROM " . TABLE_PREFIX . "vbcmslinkscomments
				                     WHERE " . str_replace('IN', 'NOT IN', $condition) . " AND linkid IN(" . implode(',', array_keys($counter_links)) . ")
				                ORDER BY date ASC

				        ");

				        while($com_row = $this->dbobject->fetch_array($com))
				        {
                                $counter_links[$com_row['linkid']]['linkinfo'] = $com_row;
                        }
                        $this->dbobject->free_result($com);
                        unset($com);

                        foreach($counter_links AS $key => $value)
                        {
                                $this->dbobject->query_write("
				                        UPDATE " . TABLE_PREFIX . "vbcmslinks
					                    SET
					                       lastcomdate = " . intval($value['linkinfo']['date']) . ",
					                       lastcomid = " . intval($value['linkinfo']['commentid']) . ",
					                       lastcomuserid = " . intval($value['linkinfo']['userid']) . ",
					                       lastcomusername  = '" . $value['linkinfo']['username'] . "',
					                       replycount = replycount - " . intval($value['replycounter']) . "
					                    WHERE linkid = " . $key . "
	                            ");
	                    }
                }

                // Update user links counter
                if(!empty($userinfo))
                {
                        foreach($userinfo AS $key => $com)
                        {
                                $sql .= "WHEN $key THEN vbcmslinkscomments - $com\n";
                        }

                        $this->dbobject->query_write("
				                UPDATE " . TABLE_PREFIX . "user SET
					            vbcmslinkscomments = CASE userid
					                 $sql
					            ELSE vbcmslinkscomments
                                END
	                    ");
	            }

                $this->db_delete(TABLE_PREFIX, 'vbcmslinkscomments', $condition);

                if($updatelinks)
                {
                        foreach($catids AS $key => $count)
                        {
                                $this->rebuild_counter($count);
                        }
                }

                return true;
        }
}
/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # SVN: $RCSfile$ - $Revision: 1653 $
|| ####################################################################
\*======================================================================*/
?>