<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBCMS Version 1.2.2
|| #
|| # ------------------------------------------------------------------ # ||
|| # Copyright  2002 - 2007 Reuter & Bloe GbR.                          ||
|| # ------------------- VBCMS IS NOT FREE SOFTWARE ------------------- # ||
|| # http://www.vbdesigns.de | http://www.vbdesigns.de/license.html     # ||
|| # ------------------------------------------------------------------ # ||
|| # Warning: Change the file only if you know what you do!             # ||
|| # Warnung: ndern Sie die Datei nur, wenn Sie wissen, was Sie tun!   # ||
|| ###################################################################### ||
\*========================================================================*/

define('FPDF_FONTPATH', DIR . '/vbcms_areas/fpdf/font/');
require(DIR . '/vbcms_areas/fpdf/fpdf.php');

/**
* Class to handle the pdf output
*
* @package	vBCMS 1.2.2
* @version	$Revision: 799 $
* @date		$Date: 2007-10-02 12:38:13 +0200 (Di, 02 Okt 2007) $
*/
class vbcms_pdf extends FPDF
{
        var $vbmsfont_tag = '';
        var $vbcmsimage = array();
        var $linetag = 5;
        var $li = 0;
        var $ol = false;
        var $code = 0;
        var $pre = '';
        var $buffertext = array();
        var $divcenterbeginn = false;
        var $divI = false;
        var $divB = false;
        var $divsf = false;
        var $B = false;
        var $I = false;
        var $U = false;
        var $imgatag = '';
        var $licircle = '';
        var $blockquote = false;

        /**
        * Put some infos in the header of the pdf file
        *
        * @param	string	author name
        * @param	string	title
        * @param	string	unix timestamp
        *
        */
        function vbcms_pdfheader($autor = '', $title = '', $timestamp = false)
        {
                global $stylevar, $vbphrase, $vbulletin;
                $this->AddPage();
                $this->AliasNbPages();
                $this->SetTitle($title);
                $this->SetAuthor($autor);
                $this->SetCreator('FPDF '. FPDF_VERSION . ' AND vBCMS ' . VBCMSVERSION);
                $this->SetSubject($title);
                $this->Image(DIR . '/vbcms_areas/fpdf/vbcms_logo.jpg', '', '', '', '', '', $vbulletin->options['bburl']);
                $this->SetFont('Times', 'B', 14);
                $this->SetY(38);
                $this->Cell('',10,$title);
                $this->SetFont('Times','U', 9);
                $this->Cell('',10,  $vbphrase['p_write'] . ' ' . $vbphrase['p_von'] . ' ' . $autor . ' (' . $vbphrase['date'] . ': ' . date("d.m.Y", $timestamp) . ')', '', '', 'R');
        }

        /**
        * Put some infos in the footer of the pdf file
        *
        */
        function Footer()
        {
                global $vbphrase;
                $this->SetY(-15);
                $this->SetFont('Times', '', 8);
                $this->SetTextColor(0, 0, 0);
                $this->Cell(0, 4, $vbphrase['vbcms_page'] . ' ' . $this->PageNo() . '/{nb}', 0, 1, 'C');
                $this->SetTextColor(0, 0, 255);
                $this->Cell(0, 4, 'Powered by FPDF and vBCMS' . chr(174) . ' ' . VBCMSVERSION, 0, 0, 'C', 0, 'http://www.vbdesigns.de');
        }

        /**
        * Initialzize the Contentparser
        *
        * @param	string	with the Content with HTML CODE the be parse
        *
        */
        function vbcms_pdfcms($content = '')
        {
                global $stylevar, $vbphrase, $vbulletin;
                $this->SetFont('Times', '', 10);
                $this->SetY(48);
                $this->vbcms_pdfhtml($content);
        }

        /**
        * Open the HTML Tag an parse
        *
        * @param	string	Opentag
        * @param	string	infos
        */
        function vbcms_pdfopen_html($open = '', $res = '')
        {
                global $domain_tag, $center_text;

                switch($open)
                {
                        case 'img':
                        {
                                if(empty($this->vbcmsimage))
                                {
                                        $size = getimagesize($res[1]);
										$this->vbcmsimage[1] =& $size[0];
                                        $this->vbcmsimage[2] =& $size[1];
                                }

                                $this->SetY($this->GetY() + $this->linetag);
                                $this->Image($res[1], $this->GetX(), $this->GetY(), $this->vbcmsimage[1]/$this->k, $this->vbcmsimage[2]/$this->k, '', $this->imgatag);
	                            $this->SetY($this->GetY() + $this->vbcmsimage[2] / $this->k);

                        }
                        break;
                        case 'div':
                        {
                                if($res[1] == 'center')
                                {
                                        $this->divcenterbeginn = true;

                                }

                                if($res[1] == 'smallfont')
                                {
                                        $this->SetFont('Times', '', 9);
                                        $this->divsf = true;
                                }
                                if((str_replace(':', '', strtolower(strrchr($res[1], ':'))) == 'italic'))
                                {
                                        $this->vbcms_setfont_html('I', true);
                                        $this->divI = true;
                                }
                                if((str_replace(':', '', strtolower(strrchr($res[1], ':'))) == 'bold'))
                                {
                                        $this->vbcms_setfont_html('B', true);
                                        $this->divB = true;
                                }
                        }
                        break;
                        case 'blockquote':
                        {
                                $this->Ln(6);
                                $this->blockquote = true;
                        }
                        break;
                        case 'strong':
                        case 'b':
                        {
                                //$this->linetag *= 2;
                                $this->vbcms_setfont_html('B', true);
                        }
                        break;
                        case 'i':
                        {
                                $this->vbcms_setfont_html('I', true);
                        }
                        break;
                        case 'u':
                        {
                                $this->vbcms_setfont_html('U', true);
                        }
                        break;

                        break;
                        case 'ol':
                        case 'ul':
                        {
                                $this->Ln(4);
                        }
                        break;
                        case '<pre':
                        {
                                $this->Ln(2);
                                $this->Line($this->GetX() + 2, $this->GetY() + 6, $this->GetX() + 185, $this->GetY()+6);
                        }
                        break;
                        case 'codebox':
                        {
                                $this->Line($this->GetX() - 16, $this->GetY() + 6, $this->GetX() + 170, $this->GetY()+6);
                        }
                        break;
                        case 'li':
                        {
                                $this->Ln(2);
								if($this->li == 1)
								{
                                        $this->Write(5,'     ' . $this->licircle . ' ');
                                }
								if($this->li == 2)
								{
                                        $this->Write(5,'             ' . $this->licircle . ' ');
                                }
								if($this->li == 3)
								{
                                        $this->Write(5,'                     ' . $this->licircle . ' ');
                                }
								if($this->li == 4)
								{
                                        $this->Write(5,'                             ' . $this->licircle . ' ');
                                }
                        }
                        break;
                        case 'span':
                        {
                                $rgb = $this->vbcms_hexcol_to_rgb($res[1]);
                                $this->SetTextColor($rgb['r'], $rgb['g'], $rgb['b']);
                        }
                        case 'font':
                        {
                                $rgb = $this->vbcms_hexcol_to_rgb($res[1]);
                                $this->SetTextColor($rgb['r'], $rgb['g'], $rgb['b']);
                        }
                        break;
                        case 'a':
                        {
                                $this->SetTextColor(0, 0, 255);
                                $this->SetFont('Times', 'U', 10);

                                $this->Write(5, $domain_tag, $res[1]);
                                $this->SetTextColor(0, 0, 0);
                                $this->SetFont('Times', '', 10);
                        }
                        break;
                }
        }

        /**
        * Open the HTML Tag an parse
        *
        * @param	string	Closetag
        */
        function vbcms_pdfclose_html($close = '')
        {
                switch($close)
                {
                        case 'div':
                        {
                                if($this->divcenterbeginn)
                                {
                                        $this->divcenterbeginn = false;
                                        $this->SetLeftMargin(10);
                                        $this->buffertext = array();
                                }

                                if($this->divsf)
                                {
                                        $this->SetFont('Times', '', 10);
                                        $this->divsf = false;
                                }
                                if($this->divI)
                                {
                                        $this->vbcms_setfont_html('I');
                                        $this->divI = false;
                                }
                                if($this->divB)
                                {
                                        $this->vbcms_setfont_html('B');
                                        $this->divB = false;
                                }

                        }
                        break;
                        case 'blockquote':
                        {
                                  $this->Ln(4);
                                  $this->SetLeftMargin(10);
                                  $this->blockquote = false;
                        }
                        break;
                        case 'strong':
                        case 'b':
                        {
                                //$this->linetag = 5;
                                $this->vbcms_setfont_html('B');
                        }
                        break;
                        case 'i':
                        {
                                $this->vbcms_setfont_html('I');
                        }
                        break;
                        case 'u':
                        {
                                $this->vbcms_setfont_html('U');
                        }
                        break;

                        case 'ol':
                        case 'ul':
                        {
                                $this->Ln(4);

                        }
                        break;
                        case 'li':
                        {
                                $this->Ln(2);
                        }
                        break;
                        case 'pre':
                        {
                                $this->Ln(2);
                                $this->Line($this->GetX() + 2, $this->GetY()+6, $this->GetX()+185, $this->GetY()+6);
                        }
                        break;
                        case 'codebox':
                        {
                                $this->Line($this->GetX()+1, $this->GetY()-6, $this->GetX()+187, $this->GetY()-6);

                        }
                        break;
                        case 'span':
                        {
                                $this->SetTextColor(0, 0, 0);
                        }
                        break;
                        case 'font':
                        {
                                $this->SetTextColor(0, 0, 0);
                        }
                        break;
                        default:
                        {

                        }
                        break;
                }
        }

        /**
        * Convert a png, gif image to *.jpg
        *
        * @param	string	imagename
        */
        function vbcms_convert_gifpng($image = '')
        {
                $file = @file_get_contents($image);
                $img_name = preg_replace('/^(.+)\/|\.(.+)/i', '', $image);
		        $image = @imagecreatefromstring($file);
		        @imagejpeg($image, DIR . '/vbcms_areas/vbcms_custom_content/' . $img_name . '.jpg', 100);
		        @imagedestroy($image);
		        $size = getimagesize(DIR . '/vbcms_areas/vbcms_custom_content/' . $img_name . '.jpg');
				$this->vbcmsimage[1] =& $size[0];
                $this->vbcmsimage[2] =& $size[1];
                $this->vbcmsimage[0] = DIR . '/vbcms_areas/vbcms_custom_content/' . $img_name . '.jpg';
                return $this->vbcmsimage;
        }

        /**
        * Parse the Content
        *
        * @param	string	complete content
        */
        function vbcms_pdfhtml($html = '')
        {
                global $domain_tag, $center_text;
                $html = str_replace('&amp;', '&', $html);
                $split_html = preg_split('/<(.*)>/U', $html, -1, PREG_SPLIT_DELIM_CAPTURE);
                foreach($split_html AS $key => $del)
                {
                        $del = str_replace("&nbsp;", ' ', $del);

                        if(!(substr(trim($del), 0, 1) == '/') AND $del != ' ')
                        {
                                if($atag = preg_match('/^img\s|^strong|^font\s|^br \/|^span\s|^ul|^blockquote|^ol\s|^li\b|^code\s|\!--\s|<pre\s|<div\s|^div\s|^[a|b|i|u]\b/i', trim($del), $result))
                                {
								        if(trim($result[0]) == 'span')
								        {
                                                $del = preg_replace('/color\: \#000000\"/i', '', $del);
								                preg_match('/color\: (.*)\"/iU', $del, $results);
								                $del = '';
								        }
								        if(trim($result[0]) == 'font')
								        {
								                preg_match('/color\=\"(.*)\"/iU', $del, $results);
								                $del = '';
								        }
                                        if($result[0] == 'a')
                                        {
                                                preg_match('/\"(.*)\"/iU', $del, $results);
                                                $linkdesc = true;
                                                $domain_tag = $split_html[$key + 1];
                                                $this->imgatag = $results[1];
								                $del = '';
								        }
								        if(trim($result[0]) == 'div')
								        {
								                preg_match('/\="(.*)\"/iU', $del, $results);

								                $del = '';
								        }
								        if(trim($result[0]) == 'code')
								        {
								                $result[0] = 'codebox';
								                $this->code++;
								                $del = '';
								        }
								        if(trim($result[0]) == 'blockquote')
								        {
								                $blockquote++;
								                $del = '';
								        }
								        if(trim($result[0]) == '<div')
								        {
								                $del = '';
								        }
								        if(trim($result[0]) == '!--')
								        {
								                $del = '';
								        }
								        if(trim($result[0]) == '<pre')
								        {
								                $this->pre = preg_replace("/\<pre(.*)\>/si", "", $del);
								                $del = $this->pre;
								        }
								        if(trim($result[0]) == 'img')
								        {
								                preg_match('/src\=\"(.*)\"/iU', trim($del), $results);
                                                $img_name = preg_replace('/^(.+)\/|\.(.+)/i','', $results[1]);
                                                //Make a temp image for the gif and png problematik
                                                if((strtolower(strrchr($results[1], '.')) == '.gif') OR (strtolower(strrchr($results[1], '.')) == '.png'))
                                                {
                                                        $this->vbcms_convert_gifpng($results[1]);
                                                        $results[1] =& $this->vbcmsimage[0];
                                                }
                                                $del = '';
								        }
                                        if(trim($result[0]) == 'ul' OR trim($result[0]) == 'ol')
								        {
								                $this->li++;
                                                if(trim($result[0]) == 'ol')
                                                {
                                                        $this->ol = true;
                                                }else{
                                                        $this->ol = false;
                                                }
								        }

								        if(in_array($result[0], array('b','i','u', 'ul', 'ol ', 'li', 'strong')))
                                        {
                                                if($this->ol AND $result[0] == 'li')
								                {
								                        ($linumber != $this->li) ? $iol = 0 : $iol;
								                        $iol++;
								                        $this->licircle = $iol . '.';
                                                }else{
                                                        $this->licircle = '';
                                                }
                                                $results[1] = $del;
                                                $del = '';
								        }

                                }else{
                                        if($domain_tag == $del)
                                        {
                                                $del = '';
                                        }
                                        if($del == 'code')
										{
										        $del = '';
								        }
                                }

                                $this->vbcms_pdfopen_html(strtolower(trim($result[0])), $results);

                        }

                        if(substr(trim($del), 0, 1) == '/')
                        {
                                $this->vbcms_pdfclose_html(str_replace('/', '', strtolower(strrchr($del, '/'))));
                                $resend = str_replace('/', '', strtolower(strrchr($del, '/')));

                                if(str_replace('/', '', strtolower(strrchr($del, '/'))) == 'ul' OR str_replace('/', '', strtolower(strrchr($del, '/'))) == 'ol')
                                {
                                        $this->li--;
                                }
                                $linumber = $this->li;

                                if(str_replace('/', '', strtolower(strrchr($del, '/'))) == 'blockquote')
                                {
                                        $blockquote--;
                                }
                                if((str_replace('/', '', strtolower(strrchr($del, '/'))) == 'code') AND ($this->code == 1))
                                {
                                        $this->vbcms_pdfclose_html('codebox');
                                        $this->code--;
                                }

                                if((substr(trim($del), 0, 2) == '//') OR (substr(trim($del), 0, 2) == '/*'))
                                {
                                        //$del = '';
                                }else{
                                        $del = '';
                                        $this->imgatag = '';
                                }
                        }

                        if($this->code)
                        {
                                $del = str_replace("br /", "\n", $del);
                        }else{
                                $del = str_replace("br /", "", $del);
                        }

                        if($this->divcenterbeginn)
                        {
                                if(($this->w - $this->GetStringWidth($del)) / 2 > 0)
                                {
                                        $this->x = ($this->w - $this->GetStringWidth($del)) / 2;
                                        $this->lMargin = ($this->w - $this->GetStringWidth($del)) / 2;
                                }else{
                                        $this->x = 10;
                                        $this->lMargin = 10;
                                }
                        }
                        if($this->vbcmsimage[0])
                        {
                                @unlink(DIR . '/vbcms_areas/vbcms_custom_content/' . $img_name . '.jpg');
                                $this->vbcmsimage = array();
                        }

                        if($this->blockquote)
                        {
                                $this->SetLeftMargin($blockquote . 8);

                        }

                        $this->Write($this->linetag, html_entity_decode($del));
                }
        }

        /**
        * Parse b i u tags
        *
        * @param	string	tagname
        * @param	bool	active
        */
        function vbcms_setfont_html($set_tag = '', $all = false)
        {
                $this->$set_tag += ($all ? 1 : -1);
                $this->vbmsfont_tag = '';
                foreach(array('B','I','U') AS $font_type)
                {
                        if($this->$font_type > 0)
                        {
                                $this->vbmsfont_tag .= $font_type;
                        }
                }
                $this->SetFont('', $this->vbmsfont_tag);
        }

        /**
        * Convert a name color or ASCII Code to RGB
        *
        * @param	string	colorname or ASCII Code
        */
        function vbcms_hexcol_to_rgb($hex = '#000000')
        {
                switch(strtolower($hex))
                {
                        case 'black':
                        {
                                $hex = '#000000';
                        }
                        break;
                        case 'sienna':
                        {
                                $hex = '#A0522D';
                        }
                        break;
                        case 'darkolivegreen':
                        {
                                $hex = '#556B2F';
                        }
                        break;
                        case 'darkgreen':
                        {
                                $hex = '#006400';
                        }
                        break;
                        case 'darkslateblue':
                        {
                                $hex = '#483D8B';
                        }
                        break;
                        case 'navy':
                        {
                                $hex = '#000080';
                        }
                        break;
                        case 'indigo':
                        {
                                $hex = '#4B0082';
                        }
                        break;
                        case 'darkslategray':
                        {
                                $hex = '#2F4F4F';
                        }
                        break;
                        case 'darkred':
                        {
                                $hex = '#8B0000';
                        }
                        break;
                        case 'darkorange':
                        {
                                $hex = '#FF8C00';
                        }
                        break;
                        case 'olive':
                        {
                                $hex = '#808000';
                        }
                        break;
                        case 'green':
                        {
                                $hex = '#008000';
                        }
                        break;
                        case 'teal':
                        {
                                $hex = '#008080';
                        }
                        break;
                        case 'blue':
                        {
                                $hex = '#0000FF';
                        }
                        break;
                        case 'slategray':
                        {
                                $hex = '#708090';
                        }
                        break;
                        case 'dimgray':
                        {
                                $hex = '#696969';
                        }
                        break;
                        case 'red':
                        {
                                $hex = '#FF0000';
                        }
                        break;
                        case 'sandybrown':
                        {
                                $hex = '#F4A460';
                        }
                        break;
                        case 'yellowgreen':
                        {
                                $hex = '#9ACD32';
                        }
                        break;
                        case 'seagreen':
                        {
                                $hex = '#2E8B57';
                        }
                        break;
                        case 'mediumturquoise':
                        {
                                $hex = '#48D1CC';
                        }
                        break;
                        case 'royalblue':
                        {
                                $hex = '#4169E1';
                        }
                        break;
                        case 'purple':
                        {
                                $hex = '#800080';
                        }
                        break;
                        case 'gray':
                        {
                                $hex = '#808080';
                        }
                        break;
                        case 'magenta':
                        {
                                $hex = '#FF00FF';
                        }
                        break;
                        case 'orange':
                        {
                                $hex = '#FFA500';
                        }
                        break;
                        case 'yellow':
                        {
                                $hex = '#FFFF00';
                        }
                        break;
                        case 'lime':
                        {
                                $hex = '#00FF00';
                        }
                        break;
                        case 'cyan':
                        {
                                $hex = '#00FFFF';
                        }
                        break;
                        case 'deepskyblue':
                        {
                                $hex = '#00BFFF';
                        }
                        break;
                        case 'darkorchid':
                        {
                                $hex = '#9932CC';
                        }
                        break;
                        case 'silver':
                        {
                                $hex = '#C0C0C0';
                        }
                        break;
                        case 'pink':
                        {
                                $hex = '#FFC0CB';
                        }
                        break;
                        case 'wheat':
                        {
                                $hex = '#F5DEB3';
                        }
                        break;
                        case 'lemonchiffon':
                        {
                                $hex = '#FFFACD';
                        }
                        break;
                        case 'palegreen':
                        {
                                $hex = '#98FB98';
                        }
                        break;
                        case 'paleturquoise':
                        {
                                $hex = '#AFEEEE';
                        }
                        break;
                        case 'lightblue':
                        {
                                $hex = '#ADD8E6';
                        }
                        break;
                        case 'plum':
                        {
                                $hex = '#DDA0DD';
                        }
                        break;
                        case 'white':
                        {
                                $hex = '#FFFFFF';
                        }
                        break;
                        default:
                        {
                                $hex = $hex;
                        }
                        break;

                }
                $color = str_replace('#', '', $hex);
	            $rgbarray = array(
                        'r' => hexdec(substr($color, 0, 2)),
                        'g' => hexdec(substr($color, 2, 2)),
                        'b' => hexdec(substr($color, 4, 2))
                );
                return $rgbarray;
        }
}
/*======================================================================*\
|| ####################################################################
|| #
|| # SVN: $RCSfile$ - $Revision: 799 $
|| ####################################################################
\*======================================================================*/
?>