<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBCMS Version 1.2.2
|| #
|| # ------------------------------------------------------------------ # ||
|| # Copyright  2002 - 2007 Reuter & Bloe GbR.                          ||
|| # ------------------- VBCMS IS NOT FREE SOFTWARE ------------------- # ||
|| # http://www.vbdesigns.de | http://www.vbdesigns.de/license.html     # ||
|| # ------------------------------------------------------------------ # ||
|| # Warning: Change the file only if you know what you do!             # ||
|| # Warnung: ndern Sie die Datei nur, wenn Sie wissen was Sie tun!    # ||
|| ###################################################################### ||
\*========================================================================*/

/**
* Class to handle the vBCMS output
*
* @package	vBCMS 1.2.2
* @version	$Revision: 777 $
* @date		$Date: 2007-09-17 10:01:36 +0200 (Mo, 17 Sep 2007) $
* @Author   $Author: Christian $
*/
class vBCMS_fetch_components
{
        /**
        * vBulletin objects
        *
        * @var	vB_Registry
        * @var	vB_Database
        */
        var $registry = null;
        var $db       = null;

        /**
    	* List of Modules.
    	*
    	* @var	array
    	*/
        var $global_modules;

    	/**
    	* Array for the global Modules
    	*
    	* @var array
    	*/
        var $portal_array = array();

    	/**
    	* Put a string to the $portal_array, this is for the custom scripts (vBCMS_content, lexicon, linklist, etc.).
    	* The string can be sortet (vertical, horizontal and over or under the global modul)
    	*
    	* @var array
    	*/
        var $custom_string;

    	/**
    	* Set customboxposition for external module (Left|Right|Middle)
    	*
    	* @var int
    	*/
        var $custom_horizontal;

    	/**
    	* Set customboxposition for external module (vertical)
    	*
    	* @var int
    	*/
        var $custom_vertical;

    	/**
    	* Set customboxposition for external module when $custom_vertical == false (vertical)
    	*
    	* @var int
    	*/
        var $custom_no_vertical = false;

    	/**
    	* Set customboxposition for external module (over or under the module)
    	*
    	* @var int
    	*/
        var $custom_moduleposition;

    	/**
    	* Set customboxposition active
    	*
    	* @var int
    	*/
        var $custom_active = false;

    	/**
    	* Cancel the get_modules() function when no modules ordered and errors are true.
    	*
    	* @var bool
    	*/
        var $error = false;

    	/**
    	* The <body> element
    	* Example in showthread.php == <body onload="if (is_ie || is_moz) { fetch_object('currentPost').scrollIntoView(true); }">
    	* See method delete_content
    	*
    	* @var str
    	*/
        var $vbcms_bodytag = '<body>';

    	/**
    	* Metakeywords Objekt
    	*
    	* @var str
    	*/
        var $metakeywords = '';

    	/**
    	* Metadecription Objekt
    	*
    	* @var str
    	*/
        var $metadescription = '';

    	/**
    	* Metatitle Objekt
    	*
    	* @var str
    	*/
        var $metatitle = '';

     	/**
    	* Tableleftcolum Objekt
    	*
    	* @var str
    	*/
        var $tableleftcolum = '186px';

    	/**
    	* Tableleftcolum Objekt
    	*
    	* @var str
    	*/
        var $tablerightcolum = '186px';

    	/**
    	*
    	* Contsructor
    	*
        * @param    array $registry-> objekt
    	*
    	*/
        function vBCMS_fetch_components(&$registry)
	    {
	            // Set registry and db object
                if(is_object($registry))
                {
                        $this->registry =& $registry;

                        if(is_object($registry->db))
                        {
                                $this->db =& $registry->db;
                        }else{
                                trigger_error('Database object is not an object', E_USER_ERROR);
                        }
                }else{
                        trigger_error('Registry object is not an object', E_USER_ERROR);
                }
        }
    	/**
    	* Load the vBCMS area
    	*
        * @param    string   the request
    	*
    	* @return   bool mixed
    	*/
        function vbcms_area($request = false)
        {
                global $vbulletin, $vbcms, $db, $stylevar, $vbphrase, $vboptions, $vbcms_global, $permissions, $vbcmsoptions, $show;

                if($this->registry->vbcmsoptions['vbcms_globalvariables'])
                {
                         foreach(explode("\r\n", $this->registry->vbcmsoptions['vbcms_globalvariables']) AS $globalvariables)
                         {
                                 global ${$globalvariables};
                         }
                }

                ($hook = vBulletinHook::fetch_hook('load_vbcms_area_start')) ? eval($hook) : false;

                $request_error = '';
                foreach($this->registry->vbcmsareas AS $area)
                {
                        if($request == $area['include'])
                        {
                                $request_error =& $area['include'];

                                if(!$area['active'])
                                {
                                         $this->get_error_message($area['areaname'], 'script_no_active');
                                         return false;
                                }else{
                                        if($area['useractive'])
                                        {
                                                if(!is_member_of($this->registry->userinfo, explode(',', $area['usergroups'])))
                                                {
                                                        $this->get_error_message($area['areaname'], 'no_permission');
                                                        return false;
                                                }
                                        }

                                        //Global needed area functions
                                        include_once(DIR . '/includes/vbcms_area_functions.php');

                                        $this->metakeywords =& $area['metakey'];
                                        $this->metadescription =& $area['metadesc'];
                                        $this->metatitle =& $area['areaname'];

                                        $this->tableleftcolum =& $area['leftcolum'];
                                        $this->tablerightcolum =& $area['rightcolum'];

                                        $this->get_global_modules($area['modules'], true);

                                        if($area['buffer'])
                                        {
                                                @ob_start();
                                                require_once(DIR . '/vbcms_areas/' . $area['include'] . '.php');
                                                $outputbuffer = @ob_get_contents();
                                                @ob_end_clean();

                                                $this->get_custom_position($outputbuffer);
                                                $this->vbcms_output();
                                                unset($outputbuffer);

                                        }else{
                                                require_once(DIR . '/vbcms_areas/' . $area['include'] . '.php');
                                        }
                               }
                               break;
                               return true;
                        }
                }

                if(!$request_error)
                {
                       $this->get_error_message('', 'bad_request');
                       return false;
                }

                ($hook = vBulletinHook::fetch_hook('load_vbcms_area_end')) ? eval($hook) : false;

                unset($area, $request_error);
        }

    	/**
    	* Set the positon for not global modules (vBCMS_content, lexicon, linklist, etc.)
    	*
        * @param    string   with the content
        * @param    int      horizontal position (left == 1, middle == 0, right == 2)
        * @param    int      vertical position (is dependent from module id)
        * @param    int      put the customstring over or under the module (1 == over, 2 == under)
        * @param    boolean  this cleans the customstring ($header, $headinclude, $footer etc.)
    	*
    	*/
        function get_custom_position(&$mystring, $horizontal = 0, $vertical = false, $moduleposition = 1, $delete = false)
        {
                if($mystring)
                {
                        $this->custom_active = true;

                        if($delete == true)
                        {
                                $this->custom_string =& $this->delete_content($mystring);
                        }else{
                                $this->custom_string =& $mystring;
                        }

                        if($vertical == false)
                        {
                                $this->custom_no_vertical = true;
                                $this->custom_horizontal =& $horizontal;
                        }else{
                                $this->custom_horizontal =& $horizontal;
                                $this->custom_vertical =& $vertical;
                                $this->custom_moduleposition =& $moduleposition;
                        }
                        ($hook = vBulletinHook::fetch_hook('load_custom_position')) ? eval($hook) : false;
                }
        }

    	/**
    	* Set the moduleids (1,2,3,6 or whatever) and make break (error) when no modules are setting
    	*
        * @param    array   order modules
        * @param    boolean true or false for errors
    	*
    	* return    string with moduleids (1,2,3,6 or whatever) or boolean error
    	*/
        function get_global_modules($modules = '', $errors = false)
        {
                if(empty($modules) AND $errors)
                {
                        $this->error = true;
                        return $this->error;
                }else{
                        $this->global_modules = explode(',', $modules);
                        return $this->global_modules;
                }
                ($hook = vBulletinHook::fetch_hook('load_global_modules')) ? eval($hook) : false;
        }

    	/**
    	* Load modules and make output
    	*
        * @param    int   // TO DO
        * @param    int   // TO DO
    	* @param    int   // TO DO
    	*
    	* return    complete output with module and customstrings (superglobal)
    	*/
        function vbcms_output($modulid = false, $customposition = false, $isactive = false) // TO DO
        {
                global $vbulletin, $db, $vbphrase, $vbcollapse, $stylevar, $vboptions, $pmbox, $login, $navbits, $navbar, $show, $template_hook;
                global $header, $headinclude, $footer, $permissions, $perms, $gobutton, $forumbit, $foruminfo, $imodcache;
                global $portal_array, $module_row, $vbcms_global, $navlinks, $where, $vbcmsoptions, $modulprocess_start, $modulprocess_end;

                // Global some variables that set in the setting vbcms_globalvariables
                if($this->registry->vbcmsoptions['vbcms_globalvariables'])
                {
                         foreach(explode("\r\n", $this->registry->vbcmsoptions['vbcms_globalvariables']) AS $globalvariables)
                         {
                                 global ${$globalvariables};
                         }
                }

                ($hook = vBulletinHook::fetch_hook('load_vbcms_output_start')) ? eval($hook) : false;

                // Put infos in the $vbcms_global array
                $vbcms_global['bodytag']                  =& $this->vbcms_bodytag;
                $vbcms_global['left_colum']               = ((defined('SCRIPTGLOBAL')) ? $this->tableleftcolum : $vbulletin->options['vbcms_forum_leftcolum']);
                $vbcms_global['right_colum']              = ((defined('SCRIPTGLOBAL')) ? $this->tablerightcolum : $vbulletin->options['vbcms_area_rightcolum']);
                $vbcms_global['meta_keywords']            = '<meta name="keywords" content="' . (($this->metakeywords) ? $this->metakeywords : $this->registry->options['keywords']) . '" />';
                $vbcms_global['meta_description']         = '<meta name="description" content="' . (($this->metadescription) ? $this->metadescription : $this->registry->options['description']) . '" />';
                $vbcms_global['lt_modul_custom']          =& $isactive;
                $vbcms_global['lt_modul_custom_position'] =& $customposition;

                // Global permissions to view Polls, Forums, News for the modules
                $excl = $forumpermissions_v = array();
                foreach($this->registry->forumcache AS $forum)
                {
                        $forumpermissions_v[$forum["forumid"]] = fetch_permissions($forum['forumid']);

                        if((!($forumpermissions_v[$forum["forumid"]] & $this->registry->bf_ugp_forumpermissions['canview']) AND !$this->registry->options['showprivateforums']) OR !($forumpermissions_v[$forum["forumid"]] & $this->registry->bf_ugp_forumpermissions['canviewothers']))
                        {
                                 if($forum['forumid'])
                                 {
                                         $excl[] = $forum['forumid'];
                                 }
                        }
                }
                $vbcms_global['forumpermissions'] = implode(',', $excl);
                unset($forum, $forumpermissions_v, $excl);

                if($this->registry->userinfo['userid'] AND !in_array(THIS_SCRIPT, array('index', 'forumdisplay', 'search', 'moderator')))
                {
                        // Make the moderatorcache for can_moderate() function
                        include_once(DIR . '/includes/functions_forumlist.php');
                        cache_moderators($this->registry->userinfo['userid']);
                }

                if($this->error)
                {
                        if($this->custom_active AND $this->error)
                        {
                                // Later
                        }else{
                                eval(standard_error('Bitte geben Sie mindestens ein Modul an', $displayCommon));
                        }
                }

                include_once(DIR . '/includes/class_bbcode.php');
                $bbcode_class =& new vB_BbCodeParser($this->registry, fetch_tag_list());

                ($hook = vBulletinHook::fetch_hook('load_vbcms_output_process_start')) ? eval($hook) : false;

                if($vbulletin->debug)
                {
                        $modulprocess_start = explode(' ', microtime());
                        define('VBCMSMODUL_TIME', true);
                }

                include_once(DIR . '/includes/vbcms_module_functions.php');

                foreach($this->registry->vbcmsportal AS $module_row)
                {
                        $collapse    = $vbcollapse["collapseobj_module_" . $module_row['id'] . ""];
                        $collapseimg = $vbcollapse["collapseimg_module_" . $module_row['id']  . ""];

                        if($this->global_modules AND in_array($module_row['id'], $this->global_modules))
                        {
                                if(is_member_of($this->registry->userinfo, explode(',', $module_row['user_groups'])))
                                {
                                        $module_row['cansee_global_modules'] = true;
                                }

                                if($module_row['cansee_global_modules'] === true)
                                {
                                        if($module_row['colum'] == 1)
                                        {
                                                $vbcmsoptions['show_hide_grafic_left'] = true;
                                        }
                                        if($module_row['colum'] == 2)
                                        {
                                                $vbcmsoptions['show_hide_grafic_right'] = true;
                                        }

                                        if($module_row['moduletype'] == 'php_file')
                                        {
                                                if($module_row['buffer'])
                                                {
                                                        @ob_start();
                                                        require_once(DIR . '/vbcms_global_modules/' . $module_row['modulname'] . '.php');
                                                        $this->portal_array["$module_row[id]"]["$module_row[colum]"] = @ob_get_contents();
                                                        @ob_end_clean();
                                                }else{
                                                        require_once(DIR . '/vbcms_global_modules/' . $module_row['modulname'] . '.php');
                                                }

                                        }else if($module_row['moduletype'] == 'bb_code'){

                                                if($module_row['htmlbbcodes'])
                                                {
                                                        $module_row['modulebbcode'] = addslashes($module_row['modulebbcode']);
                                                        $module_row['modulebbcode'] = str_replace(array("\\'", "['","']"), array("'", "[", "]"),  $module_row['modulebbcode']);

                                                        eval('$module_row[modulebbcode] = "' . $module_row['modulebbcode']. '";');
                                                }else{
                                                        $module_row['modulebbcode'] = $bbcode_class->do_parse($module_row['modulebbcode']);
                                                }
                                                eval('$this->portal_array["$module_row[id]"]["$module_row[colum]"] = "' . fetch_template($module_row['template']) . '";');
                                                $this->portal_array["$module_row[id]"]["$module_row[colum]"] = str_replace('src="images/smilies/', 'src="' . $this->registry->vbcmsoptions['vbcms_forumfolder'] . '/images/smilies/', $this->portal_array["$module_row[id]"]["$module_row[colum]"]);
                                        }else{

                                                eval('$this->portal_array["$module_row[id]"]["$module_row[colum]"] = "' . fetch_template($module_row['template']) . '";');
                                        }
                                }
                        }
                }

                if($vbulletin->debug)
                {
                        $modulprocess_end = explode(' ', microtime());
                }

                unset($bbcode_class, $module_row, $collapse, $collapseimg);

                // ====================[ draw nav bar ]======================================

                if(!$navbits['lastelement'])
                {
                        if(!$vbcms_global['headtitle'])
                        {
                                $navbits[''] =& $this->metatitle;
                                $vbcms_global['headtitle'] =& $this->metatitle;
                        }else{
                                $navbits[''] =& $vbcms_global['headtitle'];
                        }
                }else{

                        $vbcms_global['headtitle'] = $navbits['lastelement'];
                }

                if($this->registry->vbcmsoptions['vbcms_navbar'] == 1 AND defined('SCRIPTGLOBAL'))
                {
                        $navbits = construct_navbits($navbits);
                        eval('$navbar = "' . fetch_template('navbar') . '";');
                }


                if($this->custom_active)
                {
                        // Keep Cool :-)
                        if($this->custom_no_vertical)
                        {
                                $set_over['custom']["$this->custom_horizontal"] =& $this->custom_string;
                                $this->portal_array = $set_over + $this->portal_array;
                        }else{
                                switch($this->custom_moduleposition)
                                {
                                        case 1:
                                        {
                                                $this->portal_array["$this->custom_vertical"]["$this->custom_horizontal"] = $this->custom_string . $this->portal_array["$this->custom_vertical"]["$this->custom_horizontal"];
                                        }
                                        break;
                                        case 2:
                                        {
                                                $this->portal_array["$this->custom_vertical"]["$this->custom_horizontal"] = $this->portal_array["$this->custom_vertical"]["$this->custom_horizontal"] . $this->custom_string;
                                        }
                                        break;
                                }
                        }
                }

                ($hook = vBulletinHook::fetch_hook('load_vbcms_output_process_end')) ? eval($hook) : false;

                foreach($this->portal_array AS $key => $modul)
                {
                        $vbcms_global['left_table']   .= $modul[1];
                        $vbcms_global['right_table']  .= $modul[2];
                        $vbcms_global['middle_table'] .= $modul[0];
                }

                ($hook = vBulletinHook::fetch_hook('load_vbcms_output_end')) ? eval($hook) : false;

                return eval('print_output("' . fetch_template('Portal_global') . '");');

        }

    	/**
    	* Clean the $output and set the vbcms_bodytag object.
    	*
        * @param	string   content
    	*/
        function delete_content(&$content)
        {
                global $vbulletin, $header, $navbar, $footer, $headinclude, $spacer_close, $spacer_open, $debughtml;

                preg_match('/\<body[^\>]*?\>/is', $content, $results);

                if(is_array($results))
                {
                        $this->vbcms_bodytag =& $results[0];
                }

                $content = preg_replace('/\<!DOCTYPE(.+)\<head\>|\<title(.+)title\>|\<\/head\>|\<body\>|\<body[^\>]*?\>|\<\!--start debug html(.+)end debug html--\>|\<!-- no cache headers(.+)end no cache headers --\>/is', '', $content);

                ($hook = vBulletinHook::fetch_hook('load_delete_content')) ? eval($hook) : false;

                return str_replace(array($header, $navbar, $footer, $headinclude, $spacer_close, $spacer_open, '</body>', '</html>'), '', $content . '<br />');
        }
    	/**
    	* Make a errormessage, when the area of vBCMS is not activated, or a user make a bad or false request.
    	*
        * @param	string scriptname
        * @param    string errortype
        *
        * return    a specificated errormessage in the frontend, for all users
    	*/
        function get_error_message($script = '', $errortype = '')
        {
                global $vbulletin, $vbphrase;

                ($hook = vBulletinHook::fetch_hook('load_error_message')) ? eval($hook) : false;

                switch($errortype)
                {
                        case 'script_no_active':
                        {
                                return eval(standard_error(fetch_error('vbcms_error_no_active_x', $script), $displayCommon));
                        }
                        break;
                        case 'bad_request':
                        {
                                return eval(standard_error(fetch_error('invalidid', $vbphrase['forum'], $this->registry->options['contactuslink'])));
                        }
                        break;
                        case 'no_permission':
                        {
                                return print_no_permission();
                        }
                        break;
                        default:
                        {

                        }
                        break;
                }
        }
}

/*======================================================================*\
|| ####################################################################
|| #
|| # SVN: $RCSfile$ - $Revision: 777 $
|| ####################################################################
\*======================================================================*/
?>