<?php
/**
* @package JFusion
* @subpackage Modules
* @author JFusion development team
* @copyright Copyright (C) 2008 JFusion. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

/**
* @package JFusion
* @subpackage Modules
*/
class modjfusionUserActivityHelper {
	function renderPluginAuto($jname, $config, $params) {
		//now check to see if the plugin is configured
	    $jdb =& JFactory::getDBO();
	    $query = 'SELECT status from #__jfusion WHERE name = ' . $jdb->Quote($jname);
	    $jdb->setQuery($query );

	    if ($jdb->loadResult() == 1) {
	        $forum =& JFusionFactory::getForum($jname);
	        $db =& JFusionFactory::getDatabase($jname);
			$joomlaUser =& JFactory::getUser();

	        if (JError::isError($db)) {
	            return JText::_('NO_DATABASE');
	        } else {
				if(!$joomlaUser->guest) {

	       			$PluginUser =& JFusionFactory::getUser($jname);
	       			$userinfo = $PluginUser->getUser($joomlaUser);

	       			//get the avatar of the logged in user
		            if ($config['avatar']) {
		            	$output = ($config["avatar_location"]=='left') ? "<div style='height:{$config["avatar_height"]}px; text-align:{$config['alignment']};'>\n<div style='float:left; margin-right:5px;'>" : "<div style='text-{$config['alignment']};'>\n<div>";

		       			// retrieve avatar
	    	            $avatarSrc =& $config['avatar_software'];
	    	            if($jname!='joomla_int' && $jname!='joomla_ext' && ($avatarSrc=='' || $avatarSrc=='jfusion')) {
	    	            	$avatar = $forum->getAvatar($userinfo->userid);
	    	            } elseif(!empty($avatarSrc) && $avatarSrc!='jfusion') {
	    	            	$avatar = JFusionFunction::getAltAvatar($avatarSrc, $joomlaUser->id);
	    	            }

						if(empty($avatar)) {
							$avatar = JFusionFunction::getJoomlaURL().'components/com_jfusion/images/noavatar.png';
						}

	            		$size = @getimagesize($avatar);
						$maxheight = $config['avatar_height'];
						$maxwidth = $config['avatar_width'];
		            	//size the avatar to fit inside the dimensions if larger
						if($size!==false && ($size[0] > $maxwidth || $size[1] > $maxheight)) {
							$wscale = $maxwidth/$size[0];
							$hscale = $maxheight/$size[1];
							$scale = min($hscale, $wscale);
							$w = floor($scale*$size[0]);
							$h = floor($scale*$size[1]);
						}
						elseif($size!==false) {
							//the avatar is within the limits
							$w = $size[0];
							$h = $size[1];
						} else {
							//getimagesize failed
							$w = $maxwidth;
							$h = $maxheight;
						}

						$avatar = "<img style='vertical-align:middle;' src='$avatar' height='{$h}' width='{$w}' alt='avatar' />";

						$output .= $avatar."</div>\n";
		            } else {
		            	$output = "<div style='text-align:{$config['alignment']};'>\n";
		            }

		            //get the PM count of the logged in user
		            if($config["pmcount"]) {
		            	$output .= "<div>\n";

		            	$url_pm = JFusionFunction::routeURL($forum->getPrivateMessageURL(),$config['itemid']);
		            	$pmcount = $forum->getPrivateMessageCounts($userinfo->userid);
						$pm  = JText::_('PM_START');
						$pm .= ' <a href="'.$url_pm.'">'.JText::sprintf('PM_LINK', $pmcount["total"]).'</a>';
	    				$pm .= JText::sprintf('PM_END', $pmcount["unread"]);

	    				$output .= $pm . "</div>\n";
		            }

		            //get the new message url
		            if($config['viewnewmessages']) {
		            	$output .= "<div>";
						$url_viewnewmessages = JFusionFunction::routeURL($forum->getViewNewMessagesURL(), $config['itemid']);

						$output .= "<a href='$url_viewnewmessages' target='{$config['new_window']}'>" . JText::_('VIEW_NEW_TOPICS') . "</a></div>\n";
		            }
					$output .= "</div>\n";
				} else {
					$output = $config['login_msg'];
				}

				return $output;
	        }
	    } else {
	        return JText::_('NOT_CONFIGURED');
	    }
	}

	function renderPluginMode($jname, $config, $view, $pluginParam) {
		$forum = JFusionFactory::getForum($jname);
		if(method_exists($forum, "renderUserActivityModule")) {
			return $forum->renderUserActivityModule($config, $view, $pluginParam);
		}
		return JText::_('NOT_IMPLEMENTED_YET');
	}
}
?>