<?php
/**
* @package JFusion
* @subpackage Views
* @author JFusion development team
* @copyright Copyright (C) 2008 JFusion. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.view');

/**
* Renders the main admin screen that shows the configuration overview of all integrations
* @package JFusion
*/

class jfusionViewplugineditor extends JView {

    function display($tpl = null)
    {
        //set jname as a global variable in order for elements to access it.
        global $jname;

        //find out the submitted name of the JFusion module
        $jname = JRequest::getVar('jname');

        if ($jname) {
        	//hides the main menu and disables the Joomla's navigation menu
			JRequest::setVar( 'hidemainmenu', 1 );
        	        	
			// Keep the idea of instanciate the parameters only with the parameters of the XML file from the plugin needed but with a centralized method (JFusionFactory::createParams)
			$parametersInstance = JFusionFactory::createParams($jname);
			$file = JPATH_ADMINISTRATOR .DS.'components'.DS.'com_jfusion'.DS.'plugins'.DS. $jname . DS.'jfusion.xml';
			$parametersInstance->loadSetupFile($file);
			$params = $parametersInstance->getParams();

			//prepare toolbar
		    $bar =& new JToolBar('My Toolbar' );
		    $bar->appendButton('Standard', 'save', JText::_('SAVE'), 'saveconfig', false, false );
		    $bar->appendButton('Standard', 'apply', JText::_('APPLY'), 'applyconfig', false, false );
		    $bar->appendButton('Standard', 'cancel', JText::_('CANCEL'), 'plugindisplay', false, false );
		    $toolbar = $bar->render();

		    //assign data to view
		    $this->assignRef('toolbar', $toolbar);
            $this->assignRef('params', $params);
            $this->assignRef('jname', $jname);

        	//output detailed configuration warnings for the plugin
			if(JFusionFunction::validPlugin($jname)) {
				$JFusionPlugin =& JFusionFactory::getAdmin($jname);
				$JFusionPlugin->debugConfig();
			}

			//render view
		    parent::display($tpl);
        } else {
            //report error
            JError::raiseWarning(500, JText::_('NONE_SELECTED'));
        }
    }
}