<?php

/**
 * @package JFusion_vBulletin
 * @author JFusion development team
 * @copyright Copyright (C) 2008 JFusion. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */

// no direct access
defined('_JEXEC' ) or die('Restricted access' );

global $name, $baseURL, $fullURL, $integratedURL, $vbsefmode;
/**
 * JFusion Public Class for vBulletin
 * For detailed descriptions on these functions please check the model.abstractpublic.php
 * @package JFusion_vBulletin
 */
class JFusionPublic_vbulletin extends JFusionPublic{

	function getJname()
	{
		return 'vbulletin';
	}

	function getRegistrationURL()
	{
		return 'register.php';
	}

	function getLostPasswordURL()
	{
		return 'login.php?do=lostpw';
	}

	function getLostUsernameURL()
	{
		return 'login.php?do=lostpw';
	}


   /************************************************
	 * Functions For JFusion Who's Online Module
	 ***********************************************/

	/**
	 * Returns a query to find online users
	 * Make sure columns are named as userid, username, username_clean (if applicable), name (of user), and email
	 */
	function getOnlineUserQuery($limit)
	{
		$limiter = (!empty($limit)) ? "LIMIT 0,$limit" : '';
		
		return "SELECT DISTINCT u.userid, u.username AS username, u.username AS name, u.email FROM #__user AS u INNER JOIN #__session AS s ON u.userid = s.userid WHERE s.userid != 0 $limiter";
	}

	/**
	 * Returns number of guests
	 * @return int
	 */
	function getNumberOnlineGuests()
	{
		$db =& JFusionFactory::getDatabase($this->getJname());
		$query = "SELECT COUNT(DISTINCT(host)) FROM #__session WHERE userid = 0";
		$db->setQuery($query);
		return $db->loadResult();
	}

	/**
	 * Returns number of logged in users
	 * @return int
	 */
	function getNumberOnlineMembers()
	{
		$db =& JFusionFactory::getDatabase($this->getJname());
		$query = "SELECT COUNT(DISTINCT(userid)) FROM #__session WHERE userid != 0";
		$db->setQuery($query);
		return $db->loadResult();
	}

	/************************************************
	* Functions For Frameless View
	************************************************/

	function getBuffer(&$jfdata)
	{
		global $vbsefmode, $vbJname, $vbsefenabled, $baseURL, $integratedURL, $hookFile;
		//define('_JFUSION_DEBUG',1);

		//check to make sure the frameless hook is installed
		$db =& JFusionFactory::getDatabase($this->getJname());
		$q = "SELECT active FROM #__plugin WHERE hookname = 'init_startup' AND title = 'JFusion Frameless Integration Plugin'";
		$db->setQuery($q);
		$active = $db->loadResult();
		if($active!='1') {
			JError::raiseWarning(500, JText::_('VB_FRAMELESS_HOOK_NOT_INSTALLED'));
			return null;
		}
		//have to clear this as it shows up in some text boxes
		unset($q);

		// Get some params
		$params =& JFusionFactory::getParams($this->getJname());
		$vbsefmode = $params->get('sefmode',0);
		$source_path = $params->get('source_path');
		$source_url = $params->get('source_url');
		$baseURL = $jfdata->baseURL;
		$integratedURL = $jfdata->integratedURL;
    	$config =& JFactory::getConfig();
		$vbsefenabled = $config->getValue('config.sef');
		$hookFile = JPATH_ADMINISTRATOR.DS.'components'.DS.'com_jfusion'.DS.'plugins'.DS.$this->getJname().DS.'hooks.php';

		if($vbsefmode) {
			//need to set the base tag as vB JS/ajax requires it to function
			$document	= JFactory::getDocument();
			$document->setBase($jfdata->baseURL);
		}

		//get the jname to be used in the hook file
		$vbJname = $this->getJname();

		//fix for some instances of vB redirecting
		$redirects = array('misc.php','ajax.php','attachment.php','sendmessage.php','clientscript');
		$uri =& JURI::getInstance();

		$url = $uri->toString();
		foreach($redirects as $r) {
			if(strpos($url,$r)!==false) {
				$url = $integratedURL . substr($url,strpos($url,$r));
				header("Location: $url");
				exit();
			}
		}

		//get the filename
		$jfile = JRequest::getVar('jfile');

		if(!$jfile) {
			//use the default index.php
			$jfile = 'index.php';
		}

		//combine the path and filename
		if (substr($source_path, -1) == DS) {
			$index_file = $source_path . $jfile;
		} else {
			$index_file = $source_path . DS . $jfile;
		}

		if ( ! is_file($index_file) ) {
			JError::raiseWarning(500, 'The path to the requested does not exist');
			return null;
		}

		//set the current directory to vBulletin
		chdir($source_path);

		// Get the output
		ob_start();

		//aaaahhh; basically everything global in vbulletin must be declared here for it to work  ;-{
		//did not include specific globals in admincp
		$vbGlobals = array(
			'_CALENDARHOLIDAYS'
			,'_CALENDAROPTIONS'
			,'_TEMPLATEQUERIES'
			,'ad_location'
			,'albumids'
			,'allday'
			,'altbgclass'
			,'attachementids'
			,'badwords'
			,'bb_view_cache'
			,'bgclass'
			,'birthdaycache'
			,'cache_postids'
			,'calendarcache'
			,'calendarids'
			,'calendarinfo'
			,'calmod'
			,'checked'
			,'checked'
			,'cmodcache'
			,'colspan'
			,'copyrightyear'
			,'count'
			,'counters'
			,'cpnav'
			,'curforumid'
			,'curpostid'
			,'curpostidkey'
			,'currentdepth'
			,'customfields'
			,'datastore_fetch'
			,'date1'
			,'date2'
			,'datenow'
			,'day'
			,'days'
			,'daysprune'
			,'db'
			,'defaultselected'
			,'DEVDEBUG'
			,'disablesmiliesoption'
			,'display'
			,'dotthreads'
			,'doublemonth'
			,'doublemonth1'
			,'doublemonth2'
			,'eastercache'
			,'editor_css'
			,'eventcache'
			,'eventdate'
			,'eventids'
			,'faqcache'
			,'faqjumpbits'
			,'faqlinks'
			,'faqparent'
			,'folder'
			,'folderid'
			,'foldernames'
			,'folderselect'
			,'footer'
			,'foruminfo'
			,'forumjump'
			,'forumpermissioncache'
			,'forumperms'
			,'forumrules'
			,'forumshown'
			,'frmjmpsel'
			,'gobutton'
			,'goodwords'
			,'header'
			,'headinclude'
			,'holiday'
			,'html_allowed'
			,'hybridposts'
			,'ifaqcache'
			,'ignore'
			,'imodcache'
			,'imodecache'
			,'inforum'
			,'infractionids'
			,'ipclass'
			,'ipostarray'
			,'istyles'
			,'jumpforumbits'
			,'jumpforumtitle'
			,'langaugecount'
			,'laspostinfo'
			,'lastpostarray'
			,'limitlower'
			,'limitupper'
			,'links'
			,'message'
			,'messagearea'
			,'messagecounters'
			,'messageid'
			,'mod'
			,'month'
			,'months'
			,'monthselected'
			,'morereplies'
			,'navclass'
			,'newpm'
			,'newthreads'
			,'notifications_menubits'
			,'notifications_total'
			,'onload'
			,'optionselected'
			,'p'
			,'p_two_linebreak'
			,'pagestarttime'
			,'pagetitle'
			,'parent_postids'
			,'parentassoc'
			,'parentoptions'
			,'parents'
			,'pda'
			,'period'
			,'permissions'
			,'permscache'
			,'perpage'
			,'phrasegroups'
			,'phrasequery'
			,'pictureids'
			,'pmbox'
			,'pmids'
			,'pmpopupurl'
			,'post'
			,'postarray'
			,'postattache'
			,'postids'
			,'postinfo'
			,'postorder'
			,'postparent'
			,'postusername'
			,'previewpost'
			,'project_forums'
			,'project_types'
			,'querystring'
			,'querytime'
			,'rate'
			,'ratescore'
			,'recurcriteria'
			,'reminder'
			,'replyscore'
			,'searchforumids'
			,'searchids'
			,'searchthread'
			,'searchthreadid'
			,'searchtype'
			,'selectedicon'
			,'selectedone'
			,'serveroffset'
			,'show'
			,'smilebox'
			,'socialgroups'
			,'spacer_close'
			,'spacer_open'
			,'strikes'
			,'style'
			,'stylecount'
			,'stylevar'
			,'subscribecounters'
			,'subscriptioncache'
			,'template_hook'
			,'templateassoc'
			,'tempusagecache'
			,'threadedmode'
			,'threadids'
			,'threadinfo'
			,'time1'
			,'time2'
			,'timediff'
			,'timenow'
			,'timerange'
			,'timezone'
			,'titlecolor'
			,'titleonly'
			,'today'
			,'usecategories'
			,'usercache'
			,'userids'
			,'vbcollapse'
			,'vBeditTemplate'
			,'vboptions'
			,'vbphrase'
			,'vbulletin'
			,'viewscore'
			,'wol_album'
			,'wol_attachement'
			,'wol_calendar'
			,'wol_event'
			,'wol_inf'
			,'wol_pm'
			,'wol_post'
			,'wol_search'
			,'wol_socialgroup'
			,'wol_thread'
			,'wol_user'
			,'year'
			);

			foreach($vbGlobals as $g)
			{
				//global the variable
				global $$g;
			}

			if(defined('_JFUSION_DEBUG')) {
				$_SESSION["jfvbdebug"] = array();
			}

			try {
				include_once($index_file);
			}
			catch(Exception $e) {
				$jfdata->buffer = ob_get_contents() ;
				ob_end_clean();
			}

			//change the current directory back to Joomla.
			chdir(JPATH_SITE);
	}

	function parseBody(&$data)
	{
		global $name, $baseURL, $fullURL, $integratedURL, $vbsefmode, $vbsefenabled;
		$name = $this->getJname();
		$baseURL = $data->baseURL;
		$fullURL = $data->fullURL;
		$integratedURL = $data->integratedURL;
		$params =& JFusionFactory::getParams($name);
		$vbsefmode = $params->get('sefmode',0);
    	$config =& JFactory::getConfig();
		$vbsefenabled = $config->getValue('config.sef');

		//fix for form actions
		//cannot use preg_replace here because it adds unneeded slashes which messes up JS
		$action_search	= '#action="(?!http)(.*?)"(.*?)>#mS';
		$data->body = preg_replace_callback($action_search,'fixAction',$data->body);

		//fix for the rest of the urls
		$url_search = '#href="(?!http)(.*?)"(.*?)>#mSs';
		$data->body = preg_replace_callback($url_search,'fixURL',$data->body);

		//$url_search = '#<link="(?!http)(.*?)"(.*?)>#mS';
		//$data->body = preg_replace_callback($url_search,'fixURL',$data->body);

		//convert relative urls in JS links
		$url_search = '#window.location=\'(?!http)(.*?)\'#mS';
		$data->body = preg_replace_callback($url_search, 'fixJS', $data->body);

		//convert relative links from images and js files into absolute links
		$include_search = "#(src=\"|background=\"|url\('|open_window\(\\\\'|window.open\('|window.open\(\"?)(?!http)(.*?)(\\\\',|',|\"|'\)|')#mS";
		$data->body = preg_replace_callback($include_search, 'fixInclude', $data->body);

		//we need to fix the cron.php file
		$data->body = preg_replace('#src="(.*)cron.php(.*)>#mS','src="'.$integratedURL.'cron.php$2>',$data->body);

		//if we have custom register and lost password urls and vBulletin uses an absolute URL, fixURL will not catch it
		$register_url = $params->get('register_url');
		if(!empty($register_url)) {
			$data->body = str_replace($integratedURL.'register.php',$register_url,$data->body);
		}
		$lostpassword_url = $params->get('lostpassword_url');
		if(!empty($lostpassword_url)) {
			$data->body = str_replace($integratedURL.'login.php?do=lostpw',$lostpassword_url,$data->body);
		}

		if($params->get('parseCSS',false)) {
			//we need to wrap the body in a div to prevent some CSS clashes
			$data->body = "<div id = 'framelessVb'>\n$data->body\n</div>";
		}

		if(defined('_JFUSION_DEBUG')) {
			$data->body .= "<pre><code>" . htmlentities(print_r($_SESSION["jfvbdebug"],true) ). "</code></pre>";
			$data->body .= "<pre><code>" . htmlentities(print_r($GLOBALS['vbulletin'],true) ). "</code></pre>";
		}
	}

	function parseHeader(&$data)
	{
		global $name, $baseURL, $fullURL, $integratedURL, $vbsefmode, $vbsefenabled;
		$name = $this->getJname();
		$baseURL = $data->baseURL;
		$fullURL = $data->fullURL;
		$integratedURL = $data->integratedURL;
		$params =& JFusionFactory::getParams($name);
		$vbsefmode = $params->get('sefmode',0);
    	$config =& JFactory::getConfig();
		$vbsefenabled = $config->getValue('config.sef');

		$js  = "<script type=\"text/javascript\">\n";
		$js .= "var vbSourceURL = '$integratedURL';\n";
		$js .= "</script>\n";

		//we need to find and change the call to vb's yahoo connection file to our own customized one
		//that adds the source url to the ajax calls
		$yuiURL = JFusionFunction::getJoomlaURL().'administrator/components/com_jfusion/plugins/'.$this->getJname();
		$data->header = preg_replace('#\<script type="text\/javascript" src="(.*?)(connection-min.js|connection.js)\?v=(.*?)"\>#mS',"$js <script type=\"text/javascript\" src=\"$yuiURL/yui/connection/connection.js?v=$3\">",$data->header);

		//convert relative links into absolute links
		$url_search = '#(src="|background="|href="|url\("|url\(\'?)(?!http)(.*?)("\)|\'\)|"?)#mS';
		$data->header = preg_replace_callback($url_search, 'fixInclude', $data->header);

		if($params->get('parseCSS',false)) {
			$css_search = '#<style type="text/css" id="vbulletin(.*?)">(.*?)</style>#ms';
			$data->header = preg_replace_callback($css_search,'fixCSS',$data->header);
		}
	}

	function getPathWay()
	{
		$mainframe = &JFactory::getApplication('site');
		$db =& JFusionFactory::getDatabase($this->getJname());
		$pathway = array();

		//let's get the jfile
		$jfile = JRequest::getVar('jfile');

		//we are viewing a forum
		if(JRequest::getVar('f',false)!==false) {
			$fid = JRequest::getVar('f');
			$query = "SELECT title, parentlist, parentid from #__forum WHERE forumid = $fid";
			$db->setQuery($query);
			$forum = $db->loadObject();

			if($forum->parentid!='-1') {
				$parents = array_reverse(explode(',',$forum->parentlist));
				foreach($parents as $p){
					if($p!="-1") {
						$query = "SELECT title from #__forum WHERE forumid = $p";
						$db->setQuery($query);
						$title = $db->loadResult();
						$crumb = new stdClass();
						$crumb->title = $title;
						$crumb->url = "forumdisplay.php?f=$p";
						$pathway[] = $crumb;
					}
				}
			} else {
				$crumb = new stdClass();
				$crumb->title = $forum->title;
				$crumb->url = "forumdisplay.php?f=$fid";
				$pathway[] = $crumb;
			}
		} elseif (JRequest::getVar('t',false)!==false) {
			$tid = JRequest::getVar('t');
			$query = "SELECT t.title AS thread, f.title AS forum, f.forumid, f.parentid, f.parentlist FROM #__thread AS t JOIN #__forum AS f ON t.forumid = f.forumid WHERE t.threadid = $tid";
			$db->setQuery($query);
			$result = $db->loadObject();

			if($result->parentid!='-1') {
				$parents = array_reverse(explode(',',$result->parentlist));
				foreach($parents as $p){
					if($p!="-1") {
						$query = "SELECT title from #__forum WHERE forumid = $p";
						$db->setQuery($query);
						$title = $db->loadResult();
						$crumb = new stdClass();
						$crumb->title = $title;
						$crumb->url = "forumdisplay.php?f=$p";
						$pathway[] = $crumb;
					}
				}
			} else {
				$crumb = new stdClass();
				$crumb->title = $result->forum;
				$crumb->url = "forumdisplay.php?f=$result->forumid";
				$pathway[] = $crumb;
			}

			$crumb = new stdClass();
			$crumb->title = $result->thread;
			$crumb->url = "showthread.php?t=$tid";
			$pathway[] = $crumb;
		} elseif(JRequest::getVar('p',false)!==false) {
			$pid = JRequest::getVar('p');
			$query = "SELECT t.title AS thread, f.title AS forum, f.forumid, f.parentid, f.parentlist FROM #__thread AS t JOIN #__forum AS f JOIN #__post AS p ON t.forumid = f.forumid AND t.threadid = p.threadid WHERE p.postid = $pid";
			$db->setQuery($query);
			$result = $db->loadObject();

			if($result->parentid!='-1') {
				$parents = array_reverse(explode(',',$result->parentlist));
				foreach($parents as $p){
					if($p!="-1") {
						$query = "SELECT title from #__forum WHERE forumid = $p";
						$db->setQuery($query);
						$title = $db->loadResult();
						$crumb = new stdClass();
						$crumb->title = $title;
						$crumb->url = "forumdisplay.php?f=$p";
						$pathway[] = $crumb;
					}
				}
			} else {
				$crumb = new stdClass();
				$crumb->title = $result->forum;
				$crumb->url = "forumdisplay.php?f=$result->forumid";
				$pathway[] = $crumb;
			}

			$crumb = new stdClass();
			$crumb->title = $result->thread;
			$crumb->url = "showthread.php?t=$tid";
			$pathway[] = $crumb;
		} elseif (JRequest::getVar('u',false)!==false) {
			if($jfile=="member.php") {
				// we are viewing a member's profile
				$uid = JRequest::getVar('u');
				$crumb = new stdClass();
				$crumb->title = 'Members List';
				$crumb->url = 'memberslist.php';
				$pathway[] = $crumb;

				$query = "SELECT username FROM #__user WHERE userid = $uid";
				$db->setQuery($query);
				$username = $db->loadResult();
				$crumb = new stdClass();
				$crumb->title = "$username's Profile";
				$crumb->url = "member.php?u=$uid";
				$pathway[] = $crumb;
			}
		} elseif($jfile=="search.php") {
			$crumb = new stdClass();
			$crumb->title = "Search";
			$crumb->url = "search.php";
			$pathway[] = $crumb;

			if(JRequest::getVar('do',false) !== false) {
				$do = JRequest::getVar('do');
				if($do=="getnew") {
					$crumb = new stdClass();
					$crumb->title = "New Posts";
					$crumb->url = "search.php?do=getnew";
					$pathway[] = $crumb;
				} elseif($do=="getdaily") {
					$crumb = new stdClass();
					$crumb->title = "Today's Posts";
					$crumb->url = "search.php?do=getdaily";
					$pathway[] = $crumb;
				}
			}
		} elseif($jfile=="private.php") {
			$crumb = new stdClass();
			$crumb->title = "User Control Panel";
			$crumb->url = "usercp.php";
			$pathway[] = $crumb;

			$crumb = new stdClass();
			$crumb->title = "Private Messages";
			$crumb->url = "private.php";
			$pathway[] = $crumb;
		} elseif($jfile=="usercp.php") {
			$crumb = new stdClass();
			$crumb->title = "User Control Panel";
			$crumb->url = "usercp.php";
			$pathway[] = $crumb;
		} elseif($jfile=="profile.php") {
			$crumb = new stdClass();
			$crumb->title = "User Control Panel";
			$crumb->url = "usercp.php";
			$pathway[] = $crumb;

			if(JRequest::getVar('do',false) !== false) {
				$crumb = new stdClass();
				$crumb->title = "Your Profile";
				$crumb->url = "profile.php?do=editprofile";
				$pathway[] = $crumb;
			}
		} elseif($jfile=="moderation.php") {
			$crumb = new stdClass();
			$crumb->title = "User Control Panel";
			$crumb->url = "usercp.php";
			$pathway[] = $crumb;

			if(JRequest::getVar('do',false) !== false) {
				$crumb = new stdClass();
				$crumb->title = "Moderator Tasks";
				$crumb->url = "moderation.php";
				$pathway[] = $crumb;
			}
		} elseif($jfile=="memberlist.php") {
			$crumb = new stdClass();
			$crumb->title = "Members List";
			$crumb->url = "memberslist.php";
			$pathway[] = $crumb;
		}

		return $pathway;
	}


	/************************************************
	 * For JFusion Search Plugin
	 ***********************************************/

	function cleanUpSearchText($text)
	{
		$text = JFusionFunction::parseCode($text,'html');
		return $text;
	}

	function getSearchQueryColumns()
	{
		$columns = new stdClass();
		$columns->title = "p.title";
		$columns->text = "p.pagetext";
		return $columns;
	}

	function getSearchQuery()
	{
		//need to return threadid, postid, title, text, created, section
		$query = 'SELECT p.userid, p.threadid, p.postid, f.forumid, CASE WHEN p.title = "" THEN CONCAT("Re: ",t.title) ELSE p.title END AS title, p.pagetext AS text,
					FROM_UNIXTIME(p.dateline, "%Y-%m-%d %h:%i:%s") AS created,
					CONCAT_WS( "/", f.title_clean, t.title ) AS section
					FROM #__post AS p
					INNER JOIN #__thread AS t ON p.threadid = t.threadid
					INNER JOIN #__forum AS f on f.forumid = t.forumid';
		return $query;
	}

	function getSearchCriteria(&$where)
	{
		$where .= " AND p.visible = 1";
	}

	function filterSearchResults(&$results)
	{
		$plugin =& JFusionFactory::getForum($this->getJname());
		$plugin->filterActivityResults($results, 0, 'forumid', true);
	}

	function getSearchResultLink($post)
	{
		$forum =& JFusionFactory::getForum($this->getJname());
		return $forum->getPostURL($post->threadid,$post->postid);
	}
}

function fixAction($matches)
{
	$url = $matches[1];
	$extra = $matches[2];

	if(defined('_JFUSION_DEBUG')) {
		$debug = array();
		$debug['original'] = $matches[0];
		$debug['url'] = $url;
		$debug['extra'] = $extra;
		$debug['function'] = 'fixAction';
	}

	$baseURL = JFusionFunction::getJoomlaURL() .'index.php';
	$url = htmlspecialchars_decode($url);
	$url_details = parse_url($url);
	$url_variables = array();
	parse_str($url_details['query'], $url_variables);

	if(defined('_JFUSION_DEBUG')) {
		$debug['url_variables'] = $url_variables;
	}

	//set the correct action and close the form tag
	$replacement = 'action=\''.$baseURL . '\'' . $extra . '>';

	//add which file is being referred to
	if ($url_variables['jfile']){
		//use the action file that was in jfile variable
		$jfile = $url_variables['jfile'];
		unset($url_variables['jfile']);
	} else {
		//use the action file from the action URL itself
		$jfile = basename($url_details['path']);
	}

	$replacement .= '<input type="hidden" name="jfile" value="'. $jfile . '"/>';

	//add a reference to JFusion
	$replacement .= '<input type="hidden" name="option" value="com_jfusion"/>';
	unset($url_variables['option']);

	//add a reference to the itemid if set
	$Itemid = JRequest::getVar('Itemid');
	if ($Itemid){
		$replacement .=  '<input type="hidden" name="Itemid" value="'.$Itemid . '"/>';
	}
	unset($url_variables['Itemid']);

	//add any other variables
	foreach ($url_variables as $key => $value){
		$replacement .=  '<input type="hidden" name="'. $key .'" value="'.$value . '"/>';
	}

	if(defined('_JFUSION_DEBUG')) {
		$debug['parsed']= $replacement;
		$_SESSION['jfvbdebug'][] = $debug;
	}

	return $replacement;
}


function fixURL($matches)
{
	global $name, $baseURL, $integratedURL, $vbsefmode, $vbsefenabled;

	$url = $matches[1];
	$extra = $matches[2];

	if(defined('_JFUSION_DEBUG')) {
		$debug = array();
		$debug['original'] = $matches[0];
		$debug['url']= $url;
		$debug['extra'] = $parts;
		$debug['function'] = 'fixURL';
	}

	$uri =& JURI::getInstance();
	$currentURL = $uri->toString();

	if((string) strpos($url, '#') === (string)0 && strlen($url) != 1) {
		$url = $currentURL.$url;
	}

	//we need to make some exceptions
	//absolute url, already parsed URL, JS function, or jumpto
	if(strpos($url,'http')!==false || strpos($url,$currentURL)!==false || ((string) strpos($url, '#') === (string)0 && strlen($url) == 1)) {
		$replacement = "href=\"$url\" $extra>";
		if(defined('_JFUSION_DEBUG')) {
			$debug['parsed'] = $replacement;
		}
		return $replacement;
	}

	//admincp, mocp, archive, printthread.php or attachment.php
	if (strpos($url,'admincp')!==false || strpos($url,'modcp')!==false || strpos($url,'archive')!==false || strpos($url,'printthread.php')!==false || strpos($url,'attachment.php')!==false) {
		$replacement = 'href="' . $integratedURL . $url . "\" $extra>";
		if(defined('_JFUSION_DEBUG')) {
			$debug['parsed'] = $replacement;
		}
		return $replacement;
	}

	//if the plugin is set as a slave, find the master and replace register/lost password urls
	if (strpos($url,'register.php')!==false) {
		$params =& JFusionFactory::getParams($name);
		if(!empty($params)) {
			$register_url = $params->get('register_url');
			if(!empty($register_url)) {
				$replacement = 'href="'.$register_url . '"' . $extra . '>';
				if(defined('_JFUSION_DEBUG')) {
					$debug['parsed'] = $replacement;
				}
				return $replacement;
			}
		}
	}

	if (strpos($url,'login.php?do=lostpw')!==false) {
		$params =& JFusionFactory::getParams($name);
		if(!empty($params)) {
			$lostpassword_url = $params->get('lostpassword_url');
			if(!empty($lostpassword_url)) {
				$replacement = 'href="'.$lostpassword_url . '"' . $extra . '>';
				if(defined('_JFUSION_DEBUG')) {
					$debug['parsed'] = $replacement;
				}
				return $replacement;
			}
		}
	}

	if (empty($vbsefenabled)){
		//non sef URls
		$url = str_replace('?', '&amp;', $url);
		$url = $baseURL . '&amp;jfile=' .$url;
	} else {
		if ($vbsefmode) {
			$url =  JFusionFunction::routeURL($url, JRequest::getVar('Itemid'));
		} else {
			//we can just append both variables
			$url = $baseURL . $url;
		}
	}

	//set the correct url and close the a tag
	$replacement = 'href="'.$url . '"' . $extra . '>';

	if(defined('_JFUSION_DEBUG')) {
		$debug['parsed'] = $replacement;
		$_SESSION["jfvbdebug"][] = $debug;
	}

	return $replacement;
}

function fixJS($matches)
{
	global $name, $baseURL, $integratedURL, $vbsefmode, $vbsefenabled;

	$url = $matches[1];

	if(defined('_JFUSION_DEBUG')) {
		$debug = array();
		$debug['original'] = $matches[0];
		$debug['url']= $url;
		$debug['function'] = 'fixJS';
	}

	if(strpos($url,'http')!==false) {
		if(defined('_JFUSION_DEBUG')) {
			$debug['parsed'] = "window.location='$url'";;
		}
		return "window.location='$url'";
	}

	if (empty($vbsefenabled)){
		//non sef URls
		$url = str_replace('?', '&', $url);
		$url = $baseURL . '&jfile=' .$url;
	} else {
		if ($vbsefmode) {
			$url =  JFusionFunction::routeURL($url, JRequest::getVar('Itemid'));
		} else {
			//we can just append both variables
			$url = $baseURL . $url;
		}
	}

	if(defined('_JFUSION_DEBUG')) {
		$debug['parsed'] = "window.location='$url'";;
		$_SESSION["jfvbdebug"][] = $debug;
	}

	return "window.location='$url'";;
}

function fixInclude($matches)
{
	global $integratedURL;

	$pre = $matches[1];
	$url = $matches[2];
	$post = $matches[3];

	$replacement = $pre . $integratedURL . $url . $post;

	if(defined('_JFUSION_DEBUG')) {
		$debug = array();
		$debug['original'] = $matches[0];
		$debug['pre'] = $pre;
		$debug['url'] = $url;
		$debug['post'] = $post;
		$debug['function'] = 'fixInclude';
		$debug['replacement'] = $replacement;
		$_SESSION['jfvbdebug'][] = $debug;
	}

	return $replacement;
}

function fixCSS($matches)
{
	if(defined('_JFUSION_DEBUG')) {
		$debug = array();
		$debug['function'] = 'fixCSS';
		$debug['original'] = $matches[0];
	}

	$css = $matches[2];

	//remove html comments
	$css = str_replace(array('<!--','-->'),'',$css);

	//remove PHP comments
	$css = preg_replace('#\/\*(.*?)\*\/#mSs','',$css);

	//strip newlines
	$css = str_replace("\r\n","",$css);

	//break up the CSS into styles
	$elements = explode('}',$css);
	//unset the last one as it is empty
	unset($elements[count($elements)-1]);

	$imports = array();

	//rewrite css
	foreach($elements as $k => $v) {
		//breakup each element into selectors and properties
		$element = explode("{", $v);
		//breakup the selectors
		$selectors = explode(",",$element[0]);
		foreach($selectors as $sk => $sv){
			//add vb framless container
			if(strpos($sv,'<!--')!==false) die(var_dump($sv));
			if($sv == 'body' || $sv == 'html' || $sv == '*'){
				$selectors[$sk] = "$sv #framelessVb";
			} elseif(strpos($sv,'@')===0) {
				$import = explode(';',$sv);
				$import = $import[0].';';
				$sv = substr($sv,strlen($import));
				if($sv == 'body' || $sv == 'html' || $sv == '*'){
					$selectors[$sk] = "$sv #framelessVb";
				} else {
					$selectors[$sk] = "#framelessVb $sv";
				}
				$selectors[$sk] - "framelessVb $sv";
				$imports[]=$import;
			} elseif(strpos($sv,'wysiwyg')===false) {
				$selectors[$sk] = "#framelessVb $sv";
			}
		}

		//reconstruct the element
		$elements[$k] = implode(', ', $selectors) . ' {' . $element[1] . '}';
	}

	//reconstruct the css
	$css = "<style type=\"text/css\" id=\"vbulletin{$matches[1]}\">\n".implode("\n",$imports)."\n".implode("\n",$elements)."\n</style>";

	if(defined('_JFUSION_DEBUG')) {
		$debug['parsed'] = $css;
		$_SESSION["jfvbdebug"] = $debug;
	}

	return $css;
}