<?php
/**
 * @package JFusion_dokuwiki
 * @author JFusion development team
 * @copyright Copyright (C) 2008 JFusion. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */

// no direct access
defined('_JEXEC' ) or die('Restricted access' );

/**
 * load the dokuwiki framework
 */
require_once(dirname(__FILE__).DS.'admin.php');
require_once(dirname(__FILE__).DS.'user.php');
require_once(dirname(__FILE__).DS.'auth'.DS.'plain.class.php');

/**
 * @package JFusion_dokuwiki
 */
class Dokuwiki {
	var $auth = null;
	var $io = null;

	function Dokuwiki()
	{
	    $this->auth = new doku_auth_plain();
	}

	function getJname()
	{
		return 'dokuwiki';
	}

	function &getInstance( )
	{
		static $instances;

		if (!isset( $instances )) {
			$instance	= new Dokuwiki();
			$instances = & $instance;
		}
		return $instances;
	}

	function getConf($path=false)
	{
	  	static $config;
	  	if ( is_array($config) ) return $config;

	  	if(!$path) {
			$params = JFusionFactory::getParams($this->getJname());
			$path = $params->get('source_path');
	  	}

		if (substr($path, -1) == DS) {
			$myfile[] = $path . 'conf'.DS.'dokuwiki.php';
			$myfile[] = $path . 'conf'.DS.'local.php';
			$myfile[] = $path . 'conf'.DS.'local.protected.php';
		} else {
			$myfile[] = $path . DS . 'conf'.DS.'dokuwiki.php';
			$myfile[] = $path . DS . 'conf'.DS.'local.php';
			$myfile[] = $path . DS . 'conf'.DS.'local.protected.php';
		}
		$conf=null;
	  	foreach($myfile as $key => $file) {
		  	if( file_exists($file) ) {
				require($file);
			} else if ( $key < 2 ) {
				JError::raiseWarning(500,JText::_('WIZARD_FAILURE').": ".$file." No files Founed ".JText::_('WIZARD_MANUAL'));
				return false;
		  	}
	  	}
	  	$config=$conf;
	 	if ( is_array($config) ) {
			return $config;
	  	} else {
			JError::raiseWarning(500,JText::_('WIZARD_FAILURE').": Array Expected, file error? ".JText::_('WIZARD_MANUAL'));
			return false;
	  	}
	}

	function getUserList($username=false,$full=false)
	{
		$list = $this->auth->getUserData();
		if ( !count($list) ) {
			JError::raiseWarning(500,"NO USER FOUNED");
			return false;
		}
		if ($full) return $list;
		else if ($username) return $list[$username];

		foreach($list as $key => $value) {
			$user = new stdClass;
			$user->username = $key;
			$user->email = $list[$key]['mail'];
			$userlist[] = $user;
		}
		return $userlist;
	}

	function getDefaultUsergroup()
	{
		$share = Dokuwiki::getInstance();
		$conf = $share->getConf();
		if ($conf['defaultgroup']) return $conf['defaultgroup'];
		if ($conf) return 'user';
		return;
	}
}
