<?php

/**
 * @package JFusion
 * @subpackage Models
 * @author JFusion development team
 * @copyright Copyright (C) 2008 JFusion. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */

// no direct access
defined('_JEXEC' ) or die('Restricted access' );

/**
* Abstract interface for all JFusion plugin implementations.
* @package JFusion
*/
class JFusionUser{

    /**
     * gets the userinfo from the JFusion integrated software. Definition of object:
     * $userinfo->userid
     * $userinfo->name
     * $userinfo->username
     * $userinfo->email
     * $userinfo->password (encrypted password)
     * $userinfo->password_salt (salt used to encrypt password)
     * $userinfo->block (0 if allowed to access site, 1 if user access is blocked)
     * $userinfo->registerdate
     * $userinfo->lastvisitdate
     * $userinfo->group_id
     * @param object $userinfo contains the object of the user
     * @return object userinfo Object containing the user information
     */
    function getUser($userinfo)
    {
        return 0;
    }

    /**
     * Returns the identifier and identifier_type for getUser
     * @param $userinfo object with user identifing information
     * @param $username_col Database column for username
     * @param $email_col Database column for email
     * @param $lowerEmail Boolean to lowercase emails for comparison
     * @return array($identifier, $identifier_type)
     */
    function getUserIdentifier(&$userinfo, $username_col, $email_col, $lowerEmail = true)
    {
    	$params = JFusionFactory::getParams($this->getJname());

    	//the discussion bot may need to override the identifier_type to prevent user hijacking by guests
    	$override = (defined('OVERRIDE_IDENTIFIER')) ? OVERRIDE_IDENTIFIER : 'default';

		$options = array('0','1','2');
    	if(in_array($override,$options)) {
    		$login_identifier = $override;
    	} else {
    		$login_identifier = $params->get('login_identifier',1);
    	}

		$identifier = $userinfo; // saves some codelines, only change if userinfo is an object

		switch ($login_identifier) {
		case 1:
		// username
			if (is_object($userinfo)) { $identifier = $userinfo->username; }
			$identifier_type = $username_col;
			break;
		case 2:
		// email
			if (is_object($userinfo)) { $identifier = $userinfo->email; }
			$identifier_type = $email_col;
			break;
		case 3:
		// username or email
			if (!is_object($userinfo)){
				$pattern = "^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$";
     			if (eregi($pattern, $identifier)){
					$identifier_type = $email_col;
				} else {
					$identifier_type = $username_col;
				}
			} else {
				$pattern = "^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$";
     			if (eregi($pattern, $userinfo->username)){
					$identifier_type = $email_col;
					$identifier = $userinfo->email;
				} else {
					$identifier_type = $username_col;
					$identifier = $userinfo->username;
				}
			}
			break;
		}

		if($lowerEmail && $identifier_type == $email_col) {
			$identifier_type = "LOWER($identifier_type)";
			$identifier = strtolower($identifier);
		}

		return array($identifier_type, $identifier);
    }

    /**
     * returns the name of this JFusion plugin
     * @return string name of current JFusion plugin
     */
    function getJname()
    {
        return '';
    }

     /**
     * Function that automatically logs out the user from the integrated software
     * $result['error'] (contains any error messages)
     * $result['debug'] (contains information on what was done)
     * @param object $userinfo Object containing the userinfo
     * @param array $options Array with the login options, such as remember_me
     * @return array result Array containing the result of the session destroy
     */
    function destroySession($userinfo, $options)
    {
    }

     /**
     * Function that automatically logs in the user from the integrated software
     * $result['error'] (contains any error messages)
     * $result['debug'] (contains information on what was done)
     * @param object $userinfo Object containing the userinfo
     * @param array $options Array with the login options, such as remember_me     *
     * @return array result Array containing the result of the session creation
     */
    function createSession($userinfo, $options)
    {
    }


     /**
     * Function that filters the username according to the JFusion plugin
     * @param string $username Username as it was entered by the user
     * @return string filtered username that should be used for lookups
     */
    function filterUsername($username)
    {
        return $username;
    }


     /**
     * Updates or creates a user for the integrated software. This allows JFusion to have external softwares as slave for user management
     * $result['error'] (contains any error messages)
     * $result['userinfo'] (contains the userinfo object of the integrated software user)
     * @param object $suserinfo Object containing the userinfo
     * @return array result Array containing the result of the user update
     */
    function updateUser($userinfo, $overwrite)
    {
        // Initialise some variables
        $db = & JFusionFactory::getDatabase($this->getJname());
        $params = JFusionFactory::getParams($this->getJname());
        $update_block = $params->get('update_block');
        $update_activation = $params->get('update_activation');
        $update_email = $params->get('update_email');
		$usergroup = $params->get('usergroup');

        $status = array();
        $status['debug'] = array();
        $status['error'] = array();

		//check to see if a valid $userinfo object was passed on
		if(!is_object($userinfo)){
			$status['error'][] = JText::_('NO_USER_DATA_FOUND');
			return $status;
		}

		//get the user
		$existinguser = $this->getUser($userinfo);

        if (!empty($existinguser)) {
        	$changed = false;
            //a matching user has been found
			$status['debug'][] = JText::_('USER_DATA_FOUND');
            if (strtolower($existinguser->email) != strtolower($userinfo->email)) {
			  $status['debug'][] = JText::_('EMAIL_CONFLICT');
              if ($update_email || $overwrite) {
			      $status['debug'][] = JText::_('EMAIL_CONFLICT_OVERWITE_ENABLED');
                  $this->updateEmail($userinfo, $existinguser, $status);
                  $changed = true;
              } else {
                //return a email conflict
			    $status['debug'][] = JText::_('EMAIL_CONFLICT_OVERWITE_DISABLED');
                $status['error'][] = JText::_('EMAIL') . ' ' . JText::_('CONFLICT').  ': ' . $existinguser->email . ' -> ' . $userinfo->email;
                $status['userinfo'] = $existinguser;
                return $status;
              }
            }

			if (!empty($userinfo->password_clear) && strlen($userinfo->password_clear) != 32){
				// add password_clear to existinguser for the Joomla helper routines
				$existinguser->password_clear=$userinfo->password_clear;
			    //check if the password needs to be updated
	    	    $model = JFusionFactory::getAuth($this->getJname());
        		$testcrypt = $model->generateEncryptedPassword($existinguser);
            	if ($testcrypt != $existinguser->password) {
                	$this->updatePassword($userinfo, $existinguser, $status);
                	$changed = true;
            	} else {
                	$status['debug'][] = JText::_('SKIPPED_PASSWORD_UPDATE') . ':' .  JText::_('PASSWORD_VALID');
            	}
        	} else {
            	$status['debug'][] = JText::_('SKIPPED_PASSWORD_UPDATE') . ': ' . JText::_('PASSWORD_UNAVAILABLE');
        	}

            //check the blocked status
            if ($existinguser->block != $userinfo->block) {
              if ($update_block || $overwrite) {
                  if ($userinfo->block) {
                      //block the user
                      $this->blockUser($userinfo, $existinguser, $status);
                      $changed = true;
                  } else {
                      //unblock the user
                      $this->unblockUser($userinfo, $existinguser, $status);
                      $changed = true;
                  }
              } else {
                //return a debug to inform we skiped this step
                $status['debug'][] = JText::_('SKIPPED_BLOCK_UPDATE') . ': ' . $existinguser->block . ' -> ' . $userinfo->block;
              }
            }

            //check the activation status
            if ($existinguser->activation != $userinfo->activation) {
              if ($update_activation || $overwrite) {
                  if ($userinfo->activation) {
                      //inactiva the user
                      $this->inactivateUser($userinfo, $existinguser, $status);
                      $changed = true;
                  } else {
                      //activate the user
                      $this->activateUser($userinfo, $existinguser, $status);
                      $changed = true;
                  }
              } else {
                //return a debug to inform we skiped this step
                $status['debug'][] = JText::_('SKIPPED_ACTIVATION_UPDATE') . ': ' . $existinguser->activation . ' -> ' . $userinfo->activation;
              }
            }

			//check for advanced usergroup sync
			$master = JFusionFunction::getMaster();
			if(!$userinfo->block && empty($userinfo->activation) && substr($usergroup, 0, 2) == 'a:' && $master->name != $this->getJname()){
				$usergroup = unserialize($usergroup);
				//find what the usergroup should be
				$correct_usergroup = $usergroup[$userinfo->group_id];

				//Is there other information stored in the usergroup?
				if(is_array($correct_usergroup)) {
					//use the first var in the array
					$keys = array_keys($correct_usergroup);
					$correct_usergroup = $correct_usergroup[$keys[0]];
				}

				if($correct_usergroup != $existinguser->group_id){
	                $this->updateUsergroup($userinfo, $existinguser, $status);
	                $changed = true;
				} else {
					$status['debug'][] = JText::_('SKIPPED_GROUP_UPDATE') . ':' .  JText::_('GROUP_VALID');
				}
			}

            // @todo - Update the user language with the current used in Joomla - To implement after the RC 1.1.2
            //$JLang = JFactory::getLanguage();
            if(!empty($userinfo->language) && !empty($existinguser->language) && $userinfo->language != $existinguser->language){ //|| $userinfo->language != $JLang->_lang
            	$this->updateUserLanguage($userinfo, $existinguser, $status);
            }

            if (empty($status['error'])) {
            	if($changed == true){
                	$status['action'] = 'updated';
                	//let's get updated information
                	$status['userinfo'] = $this->getUser($userinfo);
            	} else {
            		$status['action'] = 'unchanged';
            		$status['userinfo'] = $existinguser;
            	}
            } else {
            	$status['action'] = 'error';
            }
            return $status;

        } else {
			$status['debug'][] = JText::_('NO_USER_FOUND_CREATING_ONE');
            $this->createUser($userinfo, $status);
            if (empty($status['error'])) {
                $status['action'] = 'created';
            } else {
            	$status['action'] = 'error';
            }
            return $status;
        }
    }

     /**
     * Function that updates the user password
     * $status['error'] (contains any error messages)
     * $status['debug'] (contains information on what was done)
     * @param object $userinfo Object containing the new userinfo
     * @param object $existinguser Object containg the old userinfo
     * @param array status Array containing the errors and result of the function
     */
    function updatePassword($userinfo, &$existinguser, &$status)
    {
	    $status['debug'][] = 'updatePassword function not implemented';
    }

     /**
     * Function that updates the username
     * $status['error'] (contains any error messages)
     * $status['debug'] (contains information on what was done)
     * @param object $userinfo Object containing the new userinfo
     * @param object $existinguser Object containg the old userinfo
     * @param array status Array containing the errors and result of the function
     */
    function updateUsername($userinfo, &$existinguser, &$status)
    {
	    $status['debug'][] = 'updateUsername function not implemented';
    }

     /**
     * Function that updates the user email address
     * $status['error'] (contains any error messages)
     * $status['debug'] (contains information on what was done)
     * @param object $userinfo Object containing the new userinfo
     * @param object $existinguser Object containg the old userinfo
     * @param array status Array containing the errors and result of the function
     */
    function updateEmail($userinfo, &$existinguser, &$status)
    {
	    $status['debug'][] = 'updateEmail function not implemented';
    }

     /**
     * Function that updates the usergroup
     * $status['error'] (contains any error messages)
     * $status['debug'] (contains information on what was done)
     * @param object $userinfo Object containing the new userinfo
     * @param object $existinguser Object containg the old userinfo
     * @param array status Array containing the errors and result of the function
     */
    function updateUsergroup($userinfo, &$existinguser, &$status)
    {
	    $status['debug'][] = 'updateUsergroup function not implemented';
    }

     /**
     * Function that updates the blocks the user account
     * $status['error'] (contains any error messages)
     * $status['debug'] (contains information on what was done)
     * @param object $userinfo Object containing the new userinfo
     * @param object $existinguser Object containg the old userinfo
     * @param array status Array containing the errors and result of the function
     */
    function blockUser($userinfo, &$existinguser, &$status)
    {
	    $status['debug'][] = 'blockUser function not implemented';
    }

     /**
     * Function that unblocks the user account
     * $status['error'] (contains any error messages)
     * $status['debug'] (contains information on what was done)
     * @param object $userinfo Object containing the new userinfo
     * @param object $existinguser Object containg the old userinfo
     * @param array status Array containing the errors and result of the function
     */
    function unblockUser($userinfo, &$existinguser, &$status)
    {
	    $status['debug'][] = 'unblockUser function not implemented';
    }

     /**
     * Function that activates the users account
     * $status['error'] (contains any error messages)
     * $status['debug'] (contains information on what was done)
     * @param object $userinfo Object containing the new userinfo
     * @param object $existinguser Object containg the old userinfo
     * @param array status Array containing the errors and result of the function
     */
    function activateUser($userinfo, &$existinguser, &$status)
    {
	    $status['debug'][] = 'activateUser function not implemented';
    }

     /**
     * Function that inactivates the users account
     * $status['error'] (contains any error messages)
     * $status['debug'] (contains information on what was done)
     * @param object $userinfo Object containing the new userinfo
     * @param object $existinguser Object containg the old userinfo
     * @param array status Array containing the errors and result of the function
     */
    function inactivateUser($userinfo, &$existinguser, &$status)
    {
	    $status['debug'][] = 'inactivate function not implemented';
    }

     /**
     * Function that creates a new user account
     * $status['error'] (contains any error messages)
     * $status['debug'] (contains information on what was done)
     * @param object $userinfo Object containing the new userinfo
     * @param array status Array containing the errors and result of the function
     */
    function createUser($userinfo, &$status)
    {
    }

    /**
     * Function that deterimes if the plugin allows user deletion
     * $status['error'] (contains any error messages)
     * $status['debug'] (contains information on what was done)
     * @param object $userinfo Object containing the existing userinfo
     * @return array status Array containing the errors and result of the function
     */
   	function deleteUserEnabled($userinfo)
   	{
   		//Force joomla_int's deleteUser()
		if($this->getJname()=='joomla_int') {
			$status = $this->deleteUser($userinfo);
		} else {
	   		$params =& JFusionFactory::getParams($this->getJname());

			if($params->get('allow_delete_users',false)) {
				$status = $this->deleteUser($userinfo);
			} else {
				$status = array();
				$status['debug'] = JText::_('ALLOW_USER_DELETE_DISABLED');
				$status['error'] = array();
			}
		}

		return $status;
	}

     /**
     * Function that deletes a user account
     * $status['error'] (contains any error messages)
     * $status['debug'] (contains information on what was done)
     * @param object $userinfo Object containing the existing userinfo
     * @return array status Array containing the errors and result of the function
     */
    function deleteUser($userinfo)
    {
    	//setup status array to hold debug info and errors
        $status = array();
        $status['debug'] = array();
        $status['error'] = array();

        $status['error'][] = JText::_('DELETE_FUNCTION_MISSING');

        return $status;
    }

    /**
     * Function that update the language of a user
     * @todo - to implement after the RC 1.1.2
     *
     * @param object $existinguser Object containing the existing userinfo
     * @param object $lang Object JLanguage containing the current language of Joomla
     * @return array status Array containing the errors and result of the function
     */
    function updateUserLanguage($existinguser, $lang, &$status){

    	$status['debug'][] = 'Update user language method not implemented';
    }


     /**
     * Function that that is used to keep sessions alive
     */
    function keepAlive()
    {
    }
}