<?php

/**
* @package JFusion
* @subpackage Models
* @author JFusion development team
* @copyright Copyright (C) 2008 JFusion. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

// no direct access
defined('_JEXEC' ) or die('Restricted access' );

/**
* Abstract interface for all JFusion functions that are accessed through the Joomla administrator interface
* @package JFusion
*/
class JFusionAdmin{

    /**
* returns the name of this JFusion plugin
* @return string name of current JFusion plugin
*/
    function getJname()
    {
        return '';
    }

    /**
* Returns the a list of users of the integrated software
* @return array List of usernames/emails
*/
    function getUserList()
    {
        return 0;
    }

    /**
* Returns the the number of users in the integrated software. Allows for fast retrieval total number of users for the usersync
* @return integer Number of registered users
*/
    function getUserCount()
    {
        return 0;
    }

    /**
* Returns the a list of usersgroups of the integrated software
* @return array List of usergroups
*/
    function getUsergroupList()
    {
        return 0;
    }

    /**
* Function used to display the default usergroup in the JFusion plugin overview
* @return string Default usergroup name
*/
    function getDefaultUsergroup()
    {
        return '';
    }

    /**
* Checks if the software allows new users to register
* @return boolean True if new user registration is allowed, otherwise returns false
*/
    function allowRegistration()
    {
        $result = true;
        return $result;
    }

    /**
* returns the name of user table of integrated software
* @return string table name
*/
    function getTablename()
    {
        return '';
    }

    /**
* Function finds config file of integrated software and automatically configures the JFusion plugin
* @param string $softwarePath path to root of integrated software
* @return object JParam JParam objects with ne newly found configuration
*/
    function setupFromPath($softwarePath)
    {
        return 0;
    }

    function checkConfig()
    {
		$status = array();
		$jname = $this->getJname();
        //for joomla_int check to see if the source_url does not equal the default
		$params = JFusionFactory::getParams($jname);
        if ($jname == 'joomla_int') {
            $source_url = $params->get('source_url');
            if (!empty($source_url)) {
                $status['config'] = 1;
                $status['message'] = JText::_('GOOD_CONFIG');
                return $status;
            } else {
                $status['config'] = 0;
                $status['message'] = JText::_('NOT_CONFIGURED');
                return $status;
            }
        }

        $db = JFusionFactory::getDatabase($jname);
        $jdb =& JFactory::getDBO();

        if (JError::isError($db) || !$db || !method_exists($jdb,'setQuery')) {
            $status['config'] = 0;
            $status['message'] = JText::_('NO_DATABASE');
            return $status;
        } else {
            //added check for missing files of copied plugins after upgrade
            $admin_file = JPATH_ADMINISTRATOR .DS.'components'.DS.'com_jfusion'.DS.'plugins'.DS.$jname.DS.'admin.php';
            if (!file_exists($admin_file)) {
                $status['config'] = 0;
                $status['message'] = JText::_('NO_FILES');
                return $status;
            }

            $source_path = $params->get('source_path');
            if ( !is_dir ( $source_path) ) {
                $status['config'] = 0;
                $status['message'] = JText::_('SOURCE_PATH_NOT_FOUND');
                return $status;
            }

            //get the user table name
            $tablename = $this->getTablename();

            // lets check if the table exists, now using the Joomla API
			$table_list = $db->getTableList();
			$table_prefix = $db->getPrefix();
			if (array_search($table_prefix . $tablename,$table_list) == false) {
	            $status['config'] = 0;
    	        $status['message'] = JText::_('NO_TABLE');
        	    return $status;
			} else {
                $status['config'] = 1;
                $status['message'] = JText::_('GOOD_CONFIG');
                return $status;
			}
        }
    }

    function debugConfig()
    {
    	//get registration status
		$new_registration  = $this->allowRegistration();

		$jname = $this->getJname();

        //get the data about the JFusion plugins
        $db = & JFactory::getDBO();
        $query = 'SELECT * from #__jfusion WHERE name = ' . $db->Quote($jname);
        $db->setQuery($query );
        $plugin = $db->loadObject();

		//output a warning to the administrator if the allowRegistration setting is wrong
		if ($new_registration && $plugin->slave == '1'){
   			JError::raiseNotice(0, $jname . ': ' . JText::_('DISABLE_REGISTRATION'));
		}
		if (!$new_registration && $plugin->master == '1'){
   			JError::raiseNotice(0, $jname . ': ' . JText::_('ENABLE_REGISTRATION'));
		}

  		//most dual login problems are due to incorrect cookie domain settings
		//therefore we should check it and output a warning if needed.
		$params = JFusionFactory::getParams($this->getJname());
		$cookie_domain = $params->get('cookie_domain');
		$correct_array = explode('.' , html_entity_decode($_SERVER['SERVER_NAME']));

		//check for domain names with double extentions
		if(isset($correct_array[count($correct_array)-2]) && isset($correct_array[count($correct_array)-1])){
			//domain array
			$domain_array = array('com','net','org','co','me');
			if(in_array($correct_array[count($correct_array)-2],$domain_array)){
				$correct_domain =  '.' . $correct_array[count($correct_array)-3]. '.' . $correct_array[count($correct_array)-2] . '.' .$correct_array[count($correct_array) -1];
			} else {
				$correct_domain = '.' . $correct_array[count($correct_array)-2] . '.' .$correct_array[count($correct_array) -1];
			}

			if (($correct_domain != $cookie_domain)&& !($this->allow_empty_cookie_domain ())){
	   			JError::raiseNotice(0, $jname . ': ' . JText::_('BEST_COOKIE_DOMAIN') . ' ' . $correct_domain);
			}
		}

		//also check the cookie path as it can intefere with frameless
		$params = JFusionFactory::getParams($this->getJname());
		$cookie_path = $params->get('cookie_path');
		if (($correct_domain != $cookie_domain) && !($this->allow_empty_cookie_path ())) {
	   		JError::raiseNotice(0, $jname . ': ' . JText::_('BEST_COOKIE_PATH') . ' /');
		}

    	//check that master plugin does not have advanced group mode data stored
    	$master = JFusionFunction::getMaster();
    	$params =& JFusionFactory::getParams($jname);
    	if(!empty($master) && $master->name == $jname && substr($params->get('usergroup'), 0, 2) == 'a:'){
			JError::raiseWarning(0, $jname . ': ' . JText::_('ADVANCED_GROUPMODE_ONLY_SUPPORTED_FORSLAVES'));
    	}
    	// allow additional checking of the configuration
    	$this->debugConfigExtra();
    }

	function allow_empty_cookie_path(){
		return false;
	}

	function allow_empty_cookie_domain() {
		return false;
	}

	function debugConfigExtra(){

	}

    function usergroup($name, $value, $node, $control_name)
    {
    	$jname = $this->getJname();

		//get the master plugin to be throughout
    	$master = JFusionFunction::getMaster();

    	$advanced = 0;
		//detect is value is a serialized array
		if(substr($value, 0, 2) == 'a:'){
			$value = unserialize($value);
			//use advanced only if this plugin is not set as master
			if($master->name!=$this->getJname()) {
				$advanced = 1;
			}
		}

		if(JFusionFunction::validPlugin($this->getJname())) {
            $usergroups = $this->getUsergroupList();
            if (!empty($usergroups)) {
             	$simple_usergroup  = "<table style=\"width:100%; border:0\">";
               	$simple_usergroup .= "<tr><td>".JText::_('DEFAULT_USERGROUP') . "</td><td>" . JHTML::_('select.genericlist', $usergroups, $control_name.'['.$name.']', '',	'id', 'name', $value) . "</td></tr>";
               	$simple_usergroup .= "</table>";
				//escape single quotes to prevent JS errors
				$simple_usergroup = str_replace("'","\'",$simple_usergroup);               	
            } else {
                $simple_usergroup = '';
            }
        } else {
			return JText::_('SAVE_CONFIG_FIRST');
        }


		//check to see if current plugin is a slave
		$db = & JFactory::getDBO();
		$query = 'SELECT slave FROM #__jfusion WHERE name = ' . $db->Quote($jname);
		$db->setQuery($query);
		$slave = $db->loadResult();

	    $list_box = '<select onchange="usergroupSelect(this.selectedIndex);">';
		if($advanced == 1){
			$list_box .= '<option value="0" selected="selected">Simple</option>';
		} else {
			$list_box .= '<option value="0">Simple</option>';
		}

		if ($slave == 1){
        	//allow usergroup sync
			if($advanced == 1){
				$list_box .= '<option selected="selected" value="1">Avanced</option>';
			} else {
				$list_box .= '<option value="1">Avanced</option>';
			}

			//prepare the advanced options
			$JFusionMaster = JFusionFactory::getAdmin($master->name);
            $master_usergroups = $JFusionMaster->getUsergroupList();

			$advanced_usergroup = "<table class=\"usergroups\">";
			if($advanced == 1){
	           	foreach ($master_usergroups as $master_usergroup){
	           		$advanced_usergroup .= "<tr><td>".$master_usergroup->name . '</td>';
	           		$advanced_usergroup .= '<td>' . JHTML::_('select.genericlist', $usergroups, $control_name.'['.$name.']['.$master_usergroup->id.']', '',	'id', 'name', $value[$master_usergroup->id]) . '</td></tr>';

            	}
			} else {
            	foreach ($master_usergroups as $master_usergroup){
            		$advanced_usergroup .= "<tr><td>".$master_usergroup->name . '</td>';
					$advanced_usergroup .= '<td>' . JHTML::_('select.genericlist', $usergroups, $control_name.'['.$name.']['.$master_usergroup->id.']', '',	'id', 'name', '') . '</td></tr>';
            	}
			}
			$advanced_usergroup .= "</table>";
			//escape single quotes to prevent JS errors
			$advanced_usergroup = str_replace("'","\'",$advanced_usergroup);
		} else {
			$advanced_usergroup = '';
		}

		$list_box .= '</select>';

    	?><script Language="JavaScript">
function usergroupSelect(option)
{
var myArray = new Array();
myArray[0] = '<?php echo $simple_usergroup;?>';
myArray[1] = '<?php echo $advanced_usergroup;?>';
	document.getElementById("JFusionUsergroup").innerHTML = myArray[option];
}
</script>
    	<?php

		if($advanced == 1){
			return JText::_('USERGROUP'). ' '. JText::_('MODE'). ': '.$list_box . '<br/><div id="JFusionUsergroup">'. $advanced_usergroup. '</div>';
		} else {
			return JText::_('USERGROUP'). ' '. JText::_('MODE'). ': '.$list_box . '<br/><div id="JFusionUsergroup">'. $simple_usergroup. '</div>';
		}

    }

    /**
* Function returns the path to the modfile
* @param string $filename file name
* @param int &$error error number
* @param string &$reason error reason
* @return string $mod_file path and file of the modfile.
*/
    function getModFile($filename, &$error,&$reason)
    {
    	//check to see if a path is defined
        $params = JFusionFactory::getParams($this->getJname());
        $path = $params->get('source_path');
        if(empty($path)){
        	$error = 1;
        	$reason = JText::_('SET_PATH_FIRST');
        }
        //check for trailing slash and generate file path
        if (substr($path, -1) == DS) {
            $mod_file = $path . $filename;
        } else {
            $mod_file = $path .DS. $filename;
        }
        //see if the file exists
		if (!file_exists($mod_file) && $error == 0){
        	$error = 1;
        	$reason = JText::_('NO_FILE_FOUND');
		}
		return $mod_file;
    }
}
