<?php
/**
* @package JFusion
* @subpackage Elements
* @author JFusion development team
* @copyright Copyright (C) 2008 JFusion. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

/**
* Defines the custom param element
* @package JFusion
*/
class JElementJFusionCustomParam extends JElement
{
	/**
	 * Element name
	 *
	 * @access	protected
	 * @var		string
	 */
	var	$_name = 'JFusionCustomParam';

	function fetchElement($name, $value, &$node, $control_name)
	{
        global $jname;
		if ($jname){
			//load the custom param output
            $JFusionPlugin = JFusionFactory::getAdmin($jname);
            if(method_exists($JFusionPlugin,$name)){
	            $output = $JFusionPlugin->{$name}($name, $value, $node, $control_name);
    	        return $output;
            } else {
				return 'Undefined function:'.$name.' in plugin:' . $jname;
            }
        } else {
            return 'Programming error: You must define global $jname before the JParam object can be rendered';
        }
	}
}