<?php
/**
* @package JFusion
* @subpackage System_Plugin
* @author JFusion development team
* @copyright Copyright (C) 2008 JFusion. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

// no direct access
defined ( '_JEXEC' ) or die ( 'Restricted access' );

/**
 * Load the JFusion framework
 */
jimport ( 'joomla.plugin.plugin' );
require_once (JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_jfusion' . DS . 'models' . DS . 'model.factory.php');
require_once (JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_jfusion' . DS . 'models' . DS . 'model.jfusion.php');

/**
 * JFusion User class
 * @package JFusion
 */
class plgSystemJfusion extends JPlugin {

	/**
	 * Constructor
	 *
	 * For php4 compatability we must not use the __constructor as a constructor for plugins
	 * because func_get_args ( void ) returns a copy of all passed arguments NOT references.
	 * This causes problems with cross-referencing necessary for the observer design pattern.
	 *
	 * @access	protected
	 * @param	object	$subject The object to observe
	 * @param 	array   $config  An array that holds the plugin configuration
	 * @since	1.0
	 */
	function plgSystemJfusion(& $subject, $config) {
		
		parent::__construct ( & $subject, $config );
	
	}

	function onAfterInitialise() {
		
		ob_start ();
		
		global $mainframe;
		
		$status = array ();
		$status ['debug'] = array ();
		$status ['error'] = array ();
		
		$JLang = &JFactory::getLanguage ();
		$session = &JFactory::getSession ();
		$oldlang = $session->get ( 'oldlang' );
		
		//only call keepAlive if in the frontend
		if($mainframe->isSite()) {
			//for master if not joomla_int
			$master = JFusionFunction::getMaster();
	    	if(!empty($master) && $master->name != 'joomla_int') {
				$JFusionUser = JFusionFactory::getUser($master->name);
	    		$JFusionUser->keepAlive();
	    	}

	    	//slave plugins
		    $plugins = JFusionFunction::getPlugins();
	    	foreach($plugins as $plugin) {
	    		$JFusionUser = JFusionFactory::getUser($plugin->name);
	    		$JFusionUser->keepAlive();
	    	}
		}
		
		/** 
		 * Joomla Object language with the current information about the language loaded
		 * In the purpose to reduce the load charge of Joomla and the communication with the others
		 * integrated software the script is realized once the language is changed
		 **/
		if (! isset ( $oldlang ) || $oldlang != $JLang->_lang) {
			$session->set ( 'oldlang', $JLang->_lang );
			
			// The instance of the user is not obligatory. Without to be logged, the user can change the language of the integrated softwares
			// if those implement it.
			$userinfo = &JFactory::getUser ();
			
			$master = JFusionFunction::getMaster ();
			$JFusionMasterPublic = JFusionFactory::getPublic ( $master->name );
			if (method_exists ( $JFusionMasterPublic, 'setLanguageFrontEnd' )) {
				$status = $JFusionMasterPublic->setLanguageFrontEnd ( $userinfo );
				
				if (! empty ( $status ['error'] )) {
					//could not set the language
					JFusionFunction::raiseWarning ( $master->name . ' ' . JText::_ ( 'SET_LANGUAGEFRONTEND_ERROR' ), $status ['error'], 1 );
				}
			}
			else {
				$status ['debug'] [] = JText::_ ( 'METHOD_NOT_IMPLEMENTED' ) . ": " . $master->name;
			}
			
			$slaves = JFusionFunction::getSlaves ();
			foreach ( $slaves as $slave ) {
				$JFusionSlavePublic = JFusionFactory::getPublic ( $slave->name );
				if (method_exists ( $JFusionSlavePublic, 'setLanguageFrontEnd' )) {
					$status = $JFusionSlavePublic->setLanguageFrontEnd ( $userinfo );
					
					if (! empty ( $status ['error'] )) {
						//could not set the language
						JFusionFunction::raiseWarning ( $slave->name . ' ' . JText::_ ( 'SET_LANGUAGEFRONTEND_ERROR' ), $status ['error'], 1 );
					}
				}
				else {
					$status ['debug'] [] = JText::_ ( 'METHOD_NOT_IMPLEMENTED' ) . ": " . $slave->name;
				}
			}
		}
		//stop output buffer
		ob_end_clean ();
	}
}