<?php
/**
* @package JFusion_vBulletin
* @author JFusion development team
* @copyright Copyright (C) 2008 JFusion. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

// no direct access
defined('_JEXEC' ) or die('Restricted access' );

/**
 * JFusion Forum Class for vBulletin
 * For detailed descriptions on these functions please check the model.abstractforum.php
 * @package JFusion_vBulletin
 */
class JFusionForum_vbulletin extends JFusionForum
{
	var $joomla_globals;

	function JFusionForum_vbulletin()
	{
		//get the params object
	    $this->params = JFusionFactory::getParams($this->getJname());
	}

	function vBulletinInit()
	{
		//only initialize the vb framework if it has not already been done
		if(!defined('VB_AREA'))
		{
			//get the params object
	        $this->params = JFusionFactory::getParams($this->getJname());

			//load the vbulletin framework
			define('VB_AREA','External');
			define('SKIP_SESSIONCREATE', 1);
			define('SKIP_USERINFO', 1);
			define('NOPMPOPUP',1);
			define('CWD', $this->params->get('source_path'));

			if(file_exists(CWD))
			{
				require_once(CWD.'/includes/init.php');

				//force into global scope
				$GLOBALS["vbulletin"] =& $vbulletin;
				$GLOBALS["db"] =& $vbulletin->db;

				return true;
			}
			else
			{
				JError::raiseWarning(500, JText::_('SOURCE_PATH_NOT_FOUND'));
				return false;
			}
		}
		else
		{
			return true;
		}
	}

    function getJname()
    {
        return 'vbulletin';
    }

	function checkThreadExists(&$dbparams, &$contentitem, &$existingthread, $forumid)
	{
	    $status = array();
        $status['debug'] = array();
        $status['error'] = array();

		//set the timezone to UTC
		date_default_timezone_set('UTC');

		//backup Joomla's global scope
		$this->backupGlobals();

		if(!empty($existingthread))
		{
			//datetime post was last updated
			$postModified = $existingthread->modified;
			//datetime content was last updated
			$contentModified = strtotime($contentitem->modified);

			//check to make sure the thread still exists in the software
			$jdb = & JFusionFactory::getDatabase($this->getJname());
			$query = "SELECT COUNT(*) FROM #__thread WHERE forumid = {$existingthread->forumid} AND threadid = {$existingthread->threadid} AND firstpostid = {$existingthread->postid}";
			$jdb->setQuery($query);
			if($jdb->loadResult()==0)
			{
				//the thread no longer exists in the software!!  recreate it
				$this->createThread($dbparams, $contentitem, $forumid, $status);
            	if (empty($status['error'])) {
                	$status['action'] = 'created';
            	}

                //restore Joomla's global scope
				$this->restoreGlobals();

            	return $status;
			}
			elseif($contentModified > $postModified)
			{
				//update the post if the content has been updated
				$this->updateThread($dbparams, $existingthread, $contentitem, $status);
				if (empty($status['error'])) {
                	$status['action'] = 'updated';
            	}

                //restore Joomla's global scope
				$this->restoreGlobals();

            	return $status;
			}
		}
	    else
	    {
	    	//thread does not exist; create it
            $this->createThread($dbparams, $contentitem, $forumid, $status);
            if (empty($status['error'])) {
                $status['action'] = 'created';
            }

			//restore Joomla's global scope
			$this->restoreGlobals();

            return $status;
        }
	}

    function getThread($threadid)
    {
		$db =& JFusionFactory::getDatabase($this->getJname());
		$query = "SELECT threadid, forumid, firstpostid AS postid FROM #__thread WHERE threadid = $threadid";
		$db->setQuery($query);
		$results = $db->loadObject();
		return $results;
    }

	function createThread(&$dbparams, &$contentitem, $forumid, &$status)
	{
		//initialize vb framework
		if(!$this->vBulletinInit()) return null;

		//TODO create error notices if required params are empty

		$userid = $dbparams->get("default_userid");
		$firstPost = $dbparams->get("first_post");

		//strip title of all html characters
		$title = trim(strip_tags($contentitem->title));

		//set what should be posted as the first post
		if($firstPost=="articleLink") {
			//create link
			$forumText = $dbparams->get("first_post_link_text");
			if($dbparams->get("first_post_link_type") == 'image') {
				$forumText = "<img src='$forumText'>";
			}
			$text = $this->prepareText(JFusionFunction::createJoomlaArticleURL($contentitem,$forumText));
		} elseif($firstPost=="articleIntro") {
			//prepare the text for posting
			$text = $this->prepareText($contentitem->introtext)."</br></br>";

			//create link
			$forumText = $dbparams->get("first_post_link_text");
			if($dbparams->get("first_post_link_type") == 'image') {
				$forumText = "<img src='$forumText'>";
			}
			$text .= $this->prepareText(JFusionFunction::createJoomlaArticleURL($contentitem,$forumText));
		} else {
			//prepare the text for posting
			$text = $this->prepareText($contentitem->introtext . $contentitem->fulltext);
		}

		require_once (CWD . "/includes/functions.php");

		$timestamp = $dbparams->get('use_content_created_date',false) ? strtotime($contentitem->created) : time();

		$threaddm =& datamanager_init('Thread_FirstPost', $GLOBALS["vbulletin"], ERRTYPE_SILENT, 'threadpost');
		$foruminfo = fetch_foruminfo($forumid);
		$threaddm->set_info('forum', $foruminfo);
		$threaddm->set('forumid', $foruminfo['forumid']);
		$threaddm->set('userid', $userid);
		$threaddm->set('title', $title);
		$threaddm->set('pagetext',trim($text));
		$threaddm->set('allowsmilie', 1);
		$threaddm->set('ipaddress', $_SERVER["REMOTE_ADDR"]);
		$threaddm->set('visible', 1);
		$threaddm->set('dateline', $timestamp);
		$threaddm->pre_save();
		if(!empty($threaddm->errors)){
			$status["error"] = array_merge($status["error"], $threaddm->errors);
		} else {
			$threadid = $threaddm->save();
			$postid = $threaddm->fetch_field('firstpostid');

			//save the threadid to the lookup table
			JFusionFunction::updateForumLookup($contentitem->id, $forumid, $threadid, $postid, $this->getJname());
		}
	}

	function createQuickReply(&$dbparams,$showGuestInputs)
	{
		$html = '';
		if($showGuestInputs) {
			$html .= "<table><tr><td>".JText::_('USERNAME') .":</td><td><input name='guest_username' value='' class='inputbox'/></td></tr>";
			$question = $dbparams->get('captcha_question');
			if(!empty($question)) {
				$html .= "<tr><td>$question:</td><td><input name='captcha_answer' value='' class='inputbox'/></td></tr>";
			}
			$html .= "</table><br>";
		}
	   	$html .= "<textarea name='quickReply' class='inputbox'></textarea><br>";
	   	$html .= "<div style='width:100%; text-align:right;'><input type='submit' value='Submit'/></div>";
	   	return $html;
	}

	function createPost(&$dbparams, &$ids, &$contentitem, &$userinfo)
	{
		$status = array();
		$status["error"] = array();

		if($userinfo->guest) {
			$captcha_answer = JRequest::getVar('captcha_answer', '', 'POST');
			if($captcha_answer != $dbparams->get('captcha_answer')) {
				$status["error"][] = JText::_('CAPTCHA_INCORRECT');
				return $status;
			} else {
				$userinfo->username = JRequest::getVar('guest_username', '', 'POST');
				$userinfo->userid = 0;

				//check to see if user exists to prevent user hijacking
				$JFusionUser = JFusionFactory::getUser($this->getJname());
				define('OVERRIDE_IDENTIFIER',3);
				$existinguser = $JFusionUser->getUser($userinfo);
				if(!empty($existinguser)) {
					$status["error"][] = JText::_('USERNAME_IN_USE');
					return $status;
				}
			}
		}

		$guest = $userinfo->guest;

		$text = JRequest::getVar('quickReply', false, 'POST');

		if(!empty($text)) {
			//backup Joomla's global scope
			$this->backupGlobals();

			$text = $this->prepareText($text);

			//initialize the vb framework
			if(!$this->vBulletinInit()) return null;

			require_once (CWD . "/includes/functions.php");

			$threadinfo = verify_id('thread', $ids->threadid, 0, 1);
			$foruminfo = fetch_foruminfo($threadinfo['forumid'], false);
			$postinfo = array();
	    	$postinfo['threadid'] = $threadinfo['threadid'];
	    	$postinfo['ipaddress'] = $_SERVER["REMOTE_ADDR"];
			$postinfo['dateline'] = time();

			$postdm =& datamanager_init('Post', $GLOBALS["vbulletin"], ERRTYPE_SILENT, 'threadpost');
			$postdm->set_info('forum', $foruminfo);
			$postdm->set_info('thread', $threadinfo);
			$userinfo = $this->convertUserData($userinfo);
			$postdm->set_info('user',$userinfo);
			$postdm->set('userid', $userinfo['userid']);
			if($guest) {
				$postdm->set('username', $userinfo['username']);
			}
			$postdm->setr('parentid', $ids->postid);
			$postdm->setr('threadid', $ids->threadid);
			$postdm->setr('pagetext', $text);
			$postdm->set('title', "Re: {$this->prepareText($threadinfo['title'])}");

			$postdm->set('visible', 1);
			$postdm->set('allowsmilie', 1);

			$postdm->pre_save();
			if(!empty($postdm->errors)){
				$status["error"] = array_merge($status["error"], $postdm->errors);
			} else {
				$id = $postdm->save();
			}

			//restore Joomla's global scope
			$this->restoreGlobals();

			return $status;
		}
	}

	function updateThread( &$dbparams, &$existingthread, &$contentitem, &$status)
	{
		//initialize the vb framework
		if(!$this->vBulletinInit()) return null;

		$forumid =& $existingthread->forumid;
		$threadid =& $existingthread->threadid;
		$postid =& $existingthread->postid;

		$firstPost = $dbparams->get("first_post");

		//strip title of all html characters
		$title = trim(strip_tags($contentitem->title));

		//set what should be posted as the first post
		if($firstPost=="articleLink") {
			//create link
			$forumText = $dbparams->get("first_post_link_text");
			if($dbparams->get("first_post_link_type") == 'image') {
				$forumText = "<img src='$forumText'>";
			}
			$text = $this->prepareText(JFusionFunction::createJoomlaArticleURL($contentitem,$forumText));
		} elseif($firstPost=="articleIntro") {
			//prepare the text for posting
			$text = $this->prepareText($contentitem->introtext)."</br></br>";

			//create link
			$forumText = $dbparams->get("first_post_link_text");
			if($dbparams->get("first_post_link_type") == 'image') {
				$forumText = "<img src='$forumText'>";
			}
			$text .= $this->prepareText(JFusionFunction::createJoomlaArticleURL($contentitem,$forumText));
		} else {
			//prepare the text for posting
			$text = $this->prepareText($contentitem->introtext . $contentitem->fulltext);
		}

		require_once (CWD . "/includes/functions.php");

		$threadinfo = verify_id('thread', $threadid, 0, 1);
		$foruminfo = fetch_foruminfo($threadinfo['forumid'], false);
		$postinfo = array();
		$postinfo['postid'] = $postid;
    	$postinfo['threadid'] =$threadinfo['threadid'];
    	$postinfo['ipaddress'] = $_SERVER["REMOTE_ADDR"];
		$postinfo['dateline'] = time();

		$postdm =& datamanager_init('Post', $GLOBALS["vbulletin"], ERRTYPE_SILENT, 'threadpost');
		$postdm->set_existing($postinfo);
		$postdm->set_info('forum', $foruminfo);
		$postdm->set_info('thread', $threadinfo);
		$postdm->setr('pagetext', $text);
		$postdm->setr('title',$title);
		$postdm->pre_save();
		if(!empty($postdm->errors)){
			$status["error"] = array_merge($status["error"], $postdm->errors);
		} else {
			$postdm->save();

			//update the lookup table
			JFusionFunction::updateForumLookup($contentitem->id, $forumid, $threadid, $postid, $this->getJname());
		}
	}

	function prepareText($text,$prepareForJoomla=false)
	{
		if($prepareForJoomla===false) {
			//first thing is to remove all joomla plugins
			preg_match_all('/\{(.*)\}/U',$text,$matches);

			//find each thread by the id
			foreach($matches[1] AS $plugin) {
				//replace plugin with nothing
				$text = str_replace('{'.$plugin.'}',"",$text);
			}
			$text = html_entity_decode($text);
			$text = JFusionFunction::parseCode($text,'bbcode',true);
		} else {
			$text = JFusionFunction::parseCode($text,'html');
		}
		return $text;
	}

	function getPosts(&$dbparams, &$existingthread)
	{
		$threadid =& $existingthread->threadid;
		$postid =& $existingthread->postid;

		//set the query
		$limit_posts = $dbparams->get("limit_posts");
		$limit = empty($limit_posts) || trim($limit_posts)==0 ? "" :  "LIMIT 0,$limit_posts";
		$sort = $dbparams->get("sort_posts");

		$where = "WHERE a.threadid = {$threadid} AND a.postid != {$postid} AND a.visible = 1";
		$query = "SELECT a.postid , a.username, a.userid, CASE WHEN a.userid = 0 THEN 1 ELSE 0 END AS guest, a.title, a.dateline, a.pagetext, a.threadid FROM `#__post` as a INNER JOIN `#__thread` as b ON a.threadid = b.threadid $where ORDER BY a.dateline $sort $limit";

		$jdb = & JFusionFactory::getDatabase($this->getJname());
		$jdb->setQuery($query);
		$posts = $jdb->loadObjectList();

		return $posts;
	}

	function getReplyCount(&$existingthread)
	{
		$db =& JFusionFactory::getDatabase($this->getJname());
		$query = "SELECT replycount FROM #__thread WHERE threadid = {$existingthread->threadid}";
		$db->setQuery($query);
		$result = $db->loadResult();
		return $result;
	}

	function getDiscussionColumns()
	{
		$columns = new stdClass();
		$columns->userid = "userid";
		$columns->username = "username";
		$columns->dateline = "dateline";
		$columns->posttext = "pagetext";
		$columns->posttitle = "title";
		$columns->postid = "postid";
		$columns->threadid = "threadid";
		$columns->guest = "guest";
		return $columns;
	}

	function getThreadURL($threadid)
    {
        return  'showthread.php?t=' . $threadid;
    }

    function getPostURL($threadid, $postid)
    {
        return  'showthread.php?p='.$postid.'#post' . $postid;
    }

    function getProfileURL($uid)
    {
        return  'member.php?u='.$uid;
    }

	function getPrivateMessageCounts($userid)
    {
        // initialise some objects
        $jdb = & JFusionFactory::getDatabase($this->getJname());

        $query = 'SELECT pmtotal,pmunread FROM #__user WHERE userid = '.$userid;
        $jdb->setQuery($query);
        $vbPMData = $jdb->loadObject();

        $pmcount['total'] = $vbPMData->pmtotal;
        $pmcount['unread'] = $vbPMData->pmunread;

        return $pmcount;
    }

    function getPrivateMessageURL()
    {
        return 'private.php';
    }

   function getViewNewMessagesURL()
   {
      return 'search.php?do=getnew';
   }

   function getAvatar($userid)
   {
        if ($userid) {
        	$db =& JFusionFactory::getDatabase($this->getJname());
        	$query = "SELECT varname, value FROM #__setting WHERE varname = 'usefileavatar' OR varname = 'avatarurl'";
        	$db->setQuery($query);
        	$settings = $db->loadObjectList();
        	foreach($settings as $s) {
        		${$s->varname} = $s->value;
        	}

        	if($usefileavatar) {
        		//avatars are saved to the filesystem
        		$query = "SELECT avatarrevision FROM #__user WHERE userid = $userid";
        		$db->setQuery($query);
        		$avatarrevision = $db->loadResult();
        		$url = $this->params->get('source_url').$avatarurl."/avatar{$userid}_{$avatarrevision}.gif";
        	} else {
        		//avatars are saved in the database
            	$url = $this->params->get('source_url').'image.php?u='.$userid .'&amp;dateline='. time() ;
        	}

            return $url;

        } else {
            return 0;
        }
    }

	function getActivityQuery($usedforums, $result_order, $result_limit)
	{
		$usedforums = $this->filterForumList($usedforums);

		//if no ther were no forums passed, the entire list is called and filtered in filterForumList
		//however if for some reason filterForumList fails, set forumid to 0 to prevent anything from showing protecting private forums
		$where = (!empty($usedforums)) ? 'WHERE a.forumid IN (' . implode(',',$usedforums) .') AND b.visible = 1' : 'WHERE a.forumid = 0 AND b.visible = 1';
		//going to give a large limit here as otherwise large boards will return a very large number of results
		//not using $result_limit here as the filtering process takes place after the results are retrieved
		$end = $result_order . " LIMIT 0,100";

		$query = array(
			//LAT with first post info
			LAT.'0' => "SELECT a.threadid, a.lastpostid AS postid, b.username, b.userid, CASE WHEN b.userid = 0 THEN 1 ELSE 0 END AS guest, a.title AS subject, b.dateline, a.forumid FROM `#__thread` as a INNER JOIN `#__post` as b ON a.firstpostid = b.postid $where ORDER BY a.lastpost $end",
			//LAT with lastest post info
			LAT.'1' => "SELECT a.threadid, a.lastpostid AS postid, b.username, b.userid, CASE WHEN b.userid = 0 THEN 1 ELSE 0 END AS guest, a.title AS subject, b.dateline, a.forumid FROM `#__thread` as a INNER JOIN `#__post` as b ON a.lastpostid = b.postid $where ORDER BY a.lastpost $end",
			LCT => "SELECT a.threadid, b.postid, b.username, b.userid, CASE WHEN b.userid = 0 THEN 1 ELSE 0 END AS guest, a.title AS subject, b.dateline, b.pagetext AS body, a.forumid FROM `#__thread` as a INNER JOIN `#__post` as b ON a.firstpostid = b.postid $where ORDER BY a.dateline $end",
			LCP => "SELECT b.threadid, b.postid, b.username, b.userid, CASE WHEN b.userid = 0 THEN 1 ELSE 0 END AS guest, CASE WHEN b.title = '' THEN CONCAT(\"Re: \",a.title) ELSE b.title END AS subject, b.dateline, b.pagetext AS body, a.forumid FROM `#__thread` as a INNER JOIN `#__post` AS b ON a.threadid = b.threadid $where ORDER BY b.dateline $end"
		);

		return $query;
	}

    function getForumList($objectList = true)
    {
        //get the connection to the db
        $db = JFusionFactory::getDatabase($this->getJname());

        $query = 'SELECT forumid as id, title_clean as name FROM #__forum ORDER BY forumid';
        $db->setQuery($query );
        $results = $db->loadObjectList();

    	if(!$objectList) {
    		$array = array();
			foreach($results as $r) {
				$array[] = $r->id;
			}
			$results = $array;
    	}
        return $results;
    }

	function getForumPermissions($userid='find')
	{
		static $forumPerms, $groupPerms;

		if(empty($forumPerms)) {

			if($userid=='find') {
				//get the joomla user
			    $JoomlaUser =& JFactory::getUser();

			    //get the vb user
			    if(!$JoomlaUser->guest) {
			    	$user = JFusionFunction::lookupUser($this->getJname(), $JoomlaUser->id);
			    	if(!empty($user)) {
			    		$userid = $user->userid;
			    	} else {
			    		//oops, something has failed
			    		$userid = 0;
			    	}
			    } else {
			    	$userid = 0;
			    }
			}

	    	//define some permissions
	    	defined('CAN_VIEW_THREAD_CONTENT') OR define('CAN_VIEW_THREAD_CONTENT',524288);
	    	defined('CAN_VIEW_FORUM') OR define('CAN_VIEW_FORUM',1);
	    	defined('CAN_VIEW_OTHERS_THREADS') OR define('CAN_VIEW_OTHERS_THREADS',2);
	    	defined('CAN_SEARCH_FORUM') OR define('CAN_SEARCH_FORUM',4);

	    	//get the usergroup permissions
	   		$db =& JFusionFactory::getDatabase($this->getJname());
	   		if($userid!=0) {
	   			$query = "SELECT u.usergroupid AS gid, u.membergroupids, g.forumpermissions AS perms FROM #__user AS u INNER JOIN #__usergroup AS g ON u.usergroupid = g.usergroupid WHERE u.userid = '$userid'";
	   		} else {
	   			$query = "SELECT usergroupid AS gid, forumpermissions AS perms FROM #__usergroup WHERE usergroupid = '1'";
	   		}

	   		$db->setQuery($query);
	   		$usergroup = $db->loadObject();
			$groupPerms = $usergroup->perms;

			//merge the permissions of member groups
	   		if(!empty($usergroup->membergroupids)) {
	   			$membergroups = explode(',',$usergroup->membergroupids);
	   			$query = "SELECT forumpermissions FROM #__usergroup WHERE usergroupid IN ({$usergroup->membergroupids})";
	   			$db->setQuery($query);
	   			$perms = $db->loadObjectList();

	   			foreach($perms as $p) {
	   				//use which ever grants the greatest number of permissions
	   				if($p->forumpermissions > $groupPerms) {
	   					$groupPerms = $p->forumpermissions;
	   				}
	   			}
	   		}

	   		//get custom forum permissions
	   		$query = "SELECT p.forumpermissions, p.forumid, p.usergroupid, f.parentlist, f.childlist FROM #__forumpermission AS p INNER JOIN #__forum AS f ON p.forumid = f.forumid WHERE p.usergroupid = {$usergroup->gid} ORDER BY p.forumid";
	   		$db->setQuery($query);
	   		$perms = $db->loadObjectList('forumid');

	   		$tempPerms = array();
	   		if(is_array($perms)) {
	   			foreach($perms as $p) {
	   				$tempPerms[$p->forumid]['perms'] = $p->forumpermissions;
	   				$tempPerms[$p->forumid]['childlist'] = explode(',',$p->childlist,-1);
	   				$tempPerms[$p->forumid]['parentlist'] = array_reverse(explode(',',$p->parentlist,-1));
	   			}
	   		}

	   		//get custom forum permissions for member groups
	   		if(!empty($membergroups)) {
	   			$query = "SELECT p.forumpermissions, p.forumid, p.usergroupid, f.parentlist, f.childlist FROM #__forumpermission AS p INNER JOIN #__forum AS f ON p.forumid = f.forumid WHERE p.usergroupid IN ({$usergroup->membergroupids}) ORDER BY p.forumid";
	   			$db->setQuery($query);
	   			$perms = $db->loadObjectList('forumid');
	   			foreach($perms as $p) {
	   				if(!isset($tempPerms[$p->forumid])) {
	   					$tempPerms[$p->forumid]['perms'] = 0;
						$tempPerms[$p->forumid]['childlist'] = explode(',',$p->childlist,-1);
						$tempPerms[$p->forumid]['parentlist'] = array_reverse(explode(',',$p->parentlist,-1));
	   				}

	   				//use which ever grants the greatest number of permissions
	   				if($p->forumpermissions > $tempPerms[$p->forumid]['perms']) {
	   					$tempPerms[$p->forumid]['perms'] = $p->forumpermissions;
	   				}
	   			}
	   		}

	   		$forumPerms = array();
	   		//we need to copy parent's permissions to the children if the child does not have custom permissions
	   		foreach($tempPerms as $id => $attributes) {
	   			if(!array_key_exists($id,$forumPerms)) {
	   				$forumPerms[$id] = $tempPerms[$id]['perms'];
	   			}

	   			$parent = '';

	   			//the permissions are set by the top parent with custom params
	   			foreach($attributes['parentlist'] as $p) {
	   				if(array_key_exists($p,$tempPerms)) {
	   					$parent = $p;
	   					break;
	   				}
	   			}

	   			if(!empty($parent)) {
		   			foreach($attributes['childlist'] AS $c) {
		   				if(!array_key_exists($c,$tempPerms) && array_key_exists($parent,$tempPerms)) {
		   					$forumPerms[$c] = $tempPerms[$parent]['perms'];
		   				}
		   			}
		   		}
	   		}
		}

		return array($groupPerms, $forumPerms);
	}


    function filterActivityResults(&$results, $limit=0, $idKey='forumid', $search = false)
    {
    	//get the joomla user
	    $JoomlaUser =& JFactory::getUser();

	    //get the vb user
	    if(!$JoomlaUser->guest) {
	    	$user = JFusionFunction::lookupUser($this->getJname(), $JoomlaUser->id);
	    	if(!empty($user)) {
	    		$userid = $user->userid;
	    	} else {
	    		//oops, something has failed
	    		$userid = 0;
	    	}
	    } else {
	    	$userid = 0;
	    }

	    list($groupPerms, $forumPerms) = $this->getForumPermissions($userid);

	    //use a counter to keep track of number of results
	    $counter = 0;
	    
  	 	if(is_array($results)) {
    		foreach($results as $k => $r) {
   				$forumid = $r->$idKey;
				$counter++;
				
    			//use the custom forum permissions by default; if they are empty then use the groups permission
    			$perms = (isset($forumPerms[$forumid])) ? $forumPerms[$forumid] : $groupPerms;

    			//check permissions
    			if($search) {
    				if(!($perms & CAN_SEARCH_FORUM) || !($perms & CAN_VIEW_FORUM) || !($perms & CAN_VIEW_THREAD_CONTENT) || ($r->userid != $userid && !($perms & CAN_VIEW_OTHERS_THREADS))) {
    					unset($results[$k]);
    					$counter--;
    				}
    			} else {
    				if(!$perms & CAN_VIEW_FORUM || ($r->userid != $userid && !($perms & CAN_VIEW_OTHERS_THREADS))) {
    				//user does not have permission to view the forum or another user's thread
    					unset($results[$k]);
    					$counter--;
    				} elseif(!($perms & CAN_VIEW_THREAD_CONTENT)) {
    				//user cannot view posts within the thread
    					if(defined('ACTIVITY_MODE') && ACTIVITY_MODE == LCP) {
    					//in activity module and using latest created post mode so remove the entire post
    						unset($results[$k]);
    						$counter--;
    					} else {
						//in activity module and using the latest active topic or latest created topic mode so just empty the post body
    						$r->body = '';
    					}
    				}
    			}
    			
    			//if the limit has been met, remove the rest of the results
    			if(!empty($limit) && $counter == $limit) {
    				$results = array_slice($results,0,$limit);
    				break;
    			}
    		}
    	}
    }

    function filterForumList($forumids)
    {
    	list($groupPerms, $forumPerms) = $this->getForumPermissions();
    	
    	if(empty($forumids)) {
    		$forumids =  $this->getForumList(false);
    	} elseif(!is_array($forumids)) {
    		$forumids = explode(',',$forumids);
    	}

    	if(!empty($forumids)) {
	    	if(is_array($forumids)) {
	    		foreach($forumids as $k => $id) {
					//use the custom forum permissions by default; if they are empty then use the groups permission
	    			$perms = (isset($forumPerms[$id])) ? $forumPerms[$id] : $groupPerms;

		    		if(!$perms & CAN_VIEW_FORUM) {
			    		//user does not have permission to view the forum
	    				unset($forumids[$k]);
	    			}
	    		}
	    	}
    	}
    			
		if(is_array($forumids)) {
			$forumids = array_values($forumids);
		}
		
    	return $forumids;
    }

    //convert the existinguser variable into something vbulletin understands
    function convertUserData($existinguser)
    {
    	$userinfo = array(
    		'userid' => $existinguser->userid,
    		'username' => $existinguser->username,
   			'email' => $existinguser->email,
    		'password' => $existinguser->password
    	);

    	return $userinfo;
    }

   //backs up joomla's global scope
    function backupGlobals()
    {
    	$this->joomla_globals = $GLOBALS;
    }

    //restore joomla's global scope
    function restoreGlobals()
    {
    	if(is_array($this->joomla_globals)) {
    		$GLOBALS = $this->joomla_globals;
    		$this->joomla_globals = "";
    	}

    	//make sure Joomla's db object is still connected
    	JFusionFunction::reconnectJoomlaDb();
    }
}
?>