<?php

/**
* @package JFusion_SMF
* @author JFusion development team
* @copyright Copyright (C) 2008 JFusion. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

// no direct access
defined('_JEXEC' ) or die('Restricted access' );

/**
 * JFusion Forum Class for SMF 1.1.x
 * For detailed descriptions on these functions please check the model.abstractforum.php
 * @package JFusion_SMF
 */

class JFusionForum_smf extends JFusionForum
{

    function getJname()
    {
        return 'smf';
    }

    function getThreadURL($threadid)
    {
        return  'index.php?topic=' . $threadid;
    }

    function getPostURL($threadid, $postid)
    {
        return  'index.php?topic=' . $threadid . '.msg'.$postid.'#msg' . $postid;
    }

    function getProfileURL($uid)
    {
        return  'index.php?action=profile&u='.$uid;
    }

    function getPrivateMessageURL()
    {
        return 'index.php?action=pm';
    }

    function getViewNewMessagesURL()
    {
        return 'index.php?action=unread';
    }

    function getActivityQuery($usedforums, $result_order, $result_limit)
    {
        $where = (!empty($usedforums)) ? ' WHERE a.ID_BOARD IN (' . $usedforums .')' : '';
		$end = $result_order." LIMIT 0,".$result_limit;

		$query = array(
			//LAT with first post info
			LAT.'0' => "SELECT a.ID_TOPIC AS threadid, a.ID_LAST_MSG AS postid, b.posterName AS username, b.ID_MEMBER AS userid, b.subject AS subject, b.posterTime AS dateline FROM `#__topics` as a INNER JOIN `#__messages` as b ON a.ID_FIRST_MSG = b.ID_MSG INNER JOIN `#__messages` AS c ON a.ID_LAST_MSG = c.ID_MSG $where ORDER BY c.posterTime $end",
			//LAT with latest post info
			LAT.'1' => "SELECT a.ID_TOPIC AS threadid, a.ID_LAST_MSG AS postid, c.posterName AS username, c.ID_MEMBER AS userid, b.subject AS subject, c.posterTime AS dateline FROM `#__topics` as a INNER JOIN `#__messages` as b ON a.ID_FIRST_MSG = b.ID_MSG INNER JOIN `#__messages` AS c ON a.ID_LAST_MSG = c.ID_MSG $where ORDER BY c.posterTime $end",
			LCT => "SELECT a.ID_TOPIC AS threadid, b.ID_MSG AS postid, b.posterName AS username, b.ID_MEMBER AS userid, b.subject AS subject, b.body, b.posterTime AS dateline FROM `#__topics` as a INNER JOIN `#__messages` as b ON a.ID_FIRST_MSG = b.ID_MSG $where ORDER BY b.posterTime $end",
			LCP => "SELECT ID_TOPIC AS threadid, ID_MSG AS postid, posterName AS username, ID_MEMBER AS userid, subject AS subject, body, posterTime AS dateline FROM `#__messages` " . str_replace('a.ID_BOARD','ID_BOARD',$where) . " ORDER BY posterTime $end"
		);

        return $query;

    }
    function getForumList()
    {
        // initialise some objects
        $db = JFusionFactory::getDatabase($this->getJname());
        $query = 'SELECT ID_BOARD as id, name FROM #__boards';
        $db->setQuery($query );

        //getting the results
        return $db->loadObjectList();
    }

    function getPrivateMessageCounts($userid)
    {

        if ($userid) {

            // initialise some objects
            $db = JFusionFactory::getDatabase($this->getJname());

            // read unread count
            $db->setQuery('SELECT unreadMessages FROM #__members WHERE ID_MEMBER = '.$userid);
            $unreadCount = $db->loadResult();

            // read total pm count
            $db->setQuery('SELECT instantMessages FROM #__members WHERE ID_MEMBER = '.$userid);
            $totalCount = $db->loadResult();

            return array('unread' => $unreadCount, 'total' => $totalCount);
        }
        return array('unread' => 0, 'total' => 0);
    }

	function getAvatar($puser_id)
    {
		if ($puser_id) {
			// Get SMF Params and get an instance of the database
			$params = JFusionFactory::getParams($this->getJname());
			$db = JFusionFactory::getDatabase($this->getJname());
			// Load member params from database "mainly to get the avatar"
			$db->setQuery('SELECT * FROM #__members WHERE ID_MEMBER='.$puser_id);
			$db->query();
			$result = $db->loadObject();

			if (!empty($result)) {
				$url = '';
				// SMF has a wierd way of holding attachments. Get instance of the attachments table
				$db->setQuery('SELECT * FROM #__attachments WHERE ID_MEMBER='.$puser_id);
				$db->query();
				$attachment = $db->loadObject();
				// See if the user has a specific attachment ment for an avatar
				if(!empty($attachment) && $attachment->ID_THUMB == 0 && $attachment->ID_MSG == 0 && empty($result->avatar)) {
					$url = $params->get('source_url').'index.php?action=dlattach;attach='.$attachment->ID_ATTACH.';type=avatar';
				// If user didnt, check to see if the avatar specified in the first query is a url. If so use it.
				} else if(preg_match("/http(s?):\/\//",$result->avatar)){
					$url = $result->avatar;
				} else if($result->avatar) {
					// If the avatar specified in the first query is not a url but is a file name. Make it one
					$db->setQuery('SELECT * FROM #__settings WHERE variable = "avatar_url"');
					$avatarurl = $db->loadObject();
					// Check for trailing slash. If there is one DONT ADD ONE!
					if(substr($avatarurl->value, -1) == DS){
						$url = $avatarurl->value.$result->avatar;
					// I like redundancy. Recheck to see if there isnt a trailing slash. If there isnt one, add one.
					} else if(substr($avatarurl->value, -1) !== DS){
						$url = $avatarurl->value."/".$result->avatar;
					}
				}

				return $url;
			}
		}
	}

	function checkThreadExists(&$dbparams, &$contentitem, &$existingthread, $forumid)
	{
	    $status = array();
        $status['debug'] = array();
        $status['error'] = array();

		//set the timezone to UTC
		date_default_timezone_set('UTC');

		if(!empty($existingthread))
		{
			//check to make sure the thread still exists in the software
			$jdb = & JFusionFactory::getDatabase($this->getJname());
			$query = "SELECT COUNT(*) FROM #__messages WHERE ID_BOARD = {$existingthread->forumid} AND ID_TOPIC = {$existingthread->threadid} AND ID_MSG = {$existingthread->postid}";
			$jdb->setQuery($query);
			if($jdb->loadResult()==0)
			{
				//the thread no longer exists in the software!!  recreate it
				$this->createThread($dbparams, $contentitem, $forumid, $status);
            	if (empty($status['error'])) {
                	$status['action'] = 'created';
            	}

            	return $status;
			}
			elseif(strtotime($contentitem->modified) > $existingthread->modified)
			{
				//update the post if the content has been updated
				$this->updateThread($dbparams, $existingthread, $contentitem, $status);
				if (empty($status['error'])) {
                	$status['action'] = 'updated';
            	}

            	return $status;
			}
		}
	    else
	    {
	    	//thread does not exist; create it
            $this->createThread($dbparams, $contentitem, $forumid, $status);
            if (empty($status['error'])) {
                $status['action'] = 'created';
            }
            return $status;
        }
	}

     /**
     * Creates new thread and posts first post
     * @param object with discussion bot parameters
     * @param object $contentitem object containing content information
     * @param int Id of forum to create thread
     * @param array $status contains errors and status of actions
     */
	function createThread(&$dbparams, &$contentitem, $forumid, &$status)
	{
		//setup some variables
		$userid = $dbparams->get("default_userid");
		$firstPost = $dbparams->get("first_post");
		$jdb =& JFusionFactory::getDatabase($this->getJname());
		$subject = trim(strip_tags($contentitem->title));


		//set what should be posted as the first post
		if($firstPost=="articleLink") {
			//create link
			$forumText = $dbparams->get("first_post_link_text");
			if($dbparams->get("first_post_link_type") == 'image') {
				$forumText = "<img src='$forumText'>";
			}
			$text = $this->prepareText(JFusionFunction::createJoomlaArticleURL($contentitem,$forumText));
		} elseif($firstPost=="articleIntro") {
			//prepare the text for posting
			$text = $this->prepareText($contentitem->introtext)."</br></br>";

			//create link
			$forumText = $dbparams->get("first_post_link_text");
			if($dbparams->get("first_post_link_type") == 'image') {
				$forumText = "<img src='$forumText'>";
			}
			$text .= $this->prepareText(JFusionFunction::createJoomlaArticleURL($contentitem,$forumText));
		} else {
			//prepare the text for posting
			$text = $this->prepareText($contentitem->introtext . $contentitem->fulltext);
		}

		//the user information
		$query = "SELECT memberName, emailAddress FROM #__members WHERE ID_MEMBER = '$userid'";
		$jdb->setQuery($query);
		$smfUser = $jdb->loadObject();

		$timestamp = $dbparams->get('use_content_created_date',false) ? strtotime($contentitem->created) : time();

		$topic_row = new stdClass();

		$topic_row->isSticky = 0;
		$topic_row->ID_BOARD = $forumid;
		$topic_row->ID_FIRST_MSG = $topic_row->ID_LAST_MSG = 0;
		$topic_row->ID_MEMBER_STARTED = $topic_row->ID_MEMBER_UPDATED =  $userid;
		$topic_row->ID_POLL = 0;
		$topic_row->numReplies = 0;
		$topic_row->numViews = 0;
		$topic_row->locked = 0;

		if(!$jdb->insertObject('#__topics', $topic_row, 'ID_TOPIC' )){
			$status['error'] = $jdb->stderr();
			return;
		}
		$topicid = $jdb->insertid();

		$post_row = new stdClass();
		$post_row->ID_BOARD			= $forumid;
		$post_row->ID_TOPIC 		= $topicid;
		$post_row->posterTime		= $timestamp;
		$post_row->ID_MEMBER		= $userid;
		$post_row->ID_MSG_MODIFIED	= $userid;
		$post_row->subject			= $subject;
		$post_row->posterName		= $smfUser->memberName;
		$post_row->posterEmail		= $smfUser->emailAddress;
		$post_row->posterIP			= $_SERVER["REMOTE_ADDR"];
		$post_row->smileysEnabled	= 1;
		$post_row->modifiedTime		= 0;
		$post_row->modifiedName		= '';
		$post_row->body				= $text;
		$post_row->icon				= 'xx';

		if(!$jdb->insertObject('#__messages', $post_row, 'ID_MSG')) {
			$status['error'] = $jdb->stderr();
			return;
		}
		$postid = $jdb->insertid();

		$topic_row = new stdClass();

		$topic_row->ID_FIRST_MSG	= $postid;
		$topic_row->ID_LAST_MSG		= $postid;
		$topic_row->ID_TOPIC 		= $topicid;
		if(!$jdb->updateObject('#__topics', $topic_row, 'ID_TOPIC' )) {
			$status['error'] = $jdb->stderr();
			return;
		}

		$forum_stats = new stdClass();
		$forum_stats->ID_BOARD =  $forumid;

		$query = "SELECT m.posterTime FROM #__messages AS m INNER JOIN #__boards AS b ON b.ID_LAST_MSG = m.ID_MSG WHERE b.ID_BOARD = $forumid";
		$jdb->setQuery($query);
		$lastPostTime = (int) $jdb->loadResult();
		if($dbparams->get('use_content_created_date',false)) {
			//only update the last post for the board if it really is newer
			$updateLastPost = ($timestamp > $lastPostTime) ? true : false;
		} else {
			$updateLastPost = true;
		}

		if($updateLastPost) {
			$forum_stats->ID_LAST_MSG =  $postid;
			$forum_stats->ID_MSG_UPDATED =  $postid;
		}

		$query = "SELECT numTopics, numPosts FROM #__boards WHERE ID_BOARD = $forumid";
		$jdb->setQuery($query);
		$num = $jdb->loadObject();
		$forum_stats->numPosts =  $num->numPosts +1;
		$forum_stats->numTopics =  $num->numTopics +1;

		if(!$jdb->updateObject('#__boards', $forum_stats, 'ID_BOARD' )) {
			$status['error'] = $jdb->stderr();
			return;
		}

		if(!empty($topicid) && !empty($postid)) {
			//save the threadid to the lookup table
			JFusionFunction::updateForumLookup($contentitem->id, $forumid, $topicid, $postid, $this->getJname());
		}
	}

	 /**
     * Updates information in a specific thread/post
     * @param object with discussion bot parameters
     * @param object with existing thread info
     * @param object $contentitem object containing content information
     * @param array $status contains errors and status of actions
     */
	function updateThread(&$dbparams, &$existingthread, &$contentitem, &$status)
	{
		$threadid =& $existingthread->threadid;
		$forumid =& $existingthread->forumid;
		$postid =& $existingthread->postid;

		//setup some variables
		$firstPost = $dbparams->get("first_post");
		$jdb =& JFusionFactory::getDatabase($this->getJname());
		$subject = trim(strip_tags($contentitem->title));

		//set what should be posted as the first post
		if($firstPost=="articleLink") {
			//create link
			$forumText = $dbparams->get("first_post_link_text");
			if($dbparams->get("first_post_link_type") == 'image') {
				$forumText = "<img src='$forumText'>";
			}
			$text = $this->prepareText(JFusionFunction::createJoomlaArticleURL($contentitem,$forumText));
		} elseif($firstPost=="articleIntro") {
			//prepare the text for posting
			$text = $this->prepareText($contentitem->introtext)."</br></br>";

			//create link
			$forumText = $dbparams->get("first_post_link_text");
			if($dbparams->get("first_post_link_type") == 'image') {
				$forumText = "<img src='$forumText'>";
			}
			$text .= $this->prepareText(JFusionFunction::createJoomlaArticleURL($contentitem,$forumText));
		} else {
			//prepare the text for posting
			$text = $this->prepareText($contentitem->introtext . $contentitem->fulltext);
		}

		$timestamp = time();
		$userid = $dbparams->get('default_user');

		$query = "SELECT memberName FROM #__members WHERE ID_MEMBER = '$userid'";
		$jdb->setQuery($query);
		$smfUser = $jdb->loadObject();

		$post_row = new stdClass();
		$post_row->subject			= $subject;
		$post_row->body				= $text;
		$post_row->modifiedTime 	= $timestamp;
		$post_row->modifiedName 	= $smfUser->memberName;
		$post_row->ID_MSG_MODIFIED	= $userid;
		$post_row->ID_MSG 			= $postid;
		if(!$jdb->updateObject('#__messages', $post_row, 'ID_MSG')) {
			$status['error'] = $jdb->stderr();
		} else {
			//update the lookup table
			JFusionFunction::updateForumLookup($contentitem->id, $forumid, $threadid, $postid, $this->getJname());
		}
	}

	/**
	 * Returns HTML of a quick reply
	 * @param $dbparams object with discussion bot parameters
	 * @param boolean $showGuestInputs toggles whether to show guest inputs or not
	 * @return string of html
	 */
	function createQuickReply(&$dbparams,$showGuestInputs)
	{
		$html = '';
		if($showGuestInputs) {
			$html .= "<table><tr><td>".JText::_('USERNAME') .":</td><td><input name='guest_username' value='' class='inputbox'/></td></tr>";
			$html .= "<tr><td>".JText::_('EMAIL') ."</td><td><input name='guest_email' value='' class='inputbox'/></td></tr>";
			$question = $dbparams->get('captcha_question');
			if(!empty($question)) {
				$html .= "<tr><td>$question:</td><td><input name='captcha_answer' value='' class='inputbox'/></td></tr>";
			}
			$html .= "</table><br>";
		}
	   	$html .= "<textarea name='quickReply' class='inputbox'></textarea><br>";
	   	$html .= "<div style='width:100%; text-align:right;'><input type='submit' value='Submit'/></div>";
	   	return $html;
	}

	/**
	 * Creates a post from the quick reply
	 * @param object with discussion bot parameters
	 * @param $ids stdClass with thread id ($ids->threadid) and first post id ($ids->postid)
	 * @param $contentitem object of content item
	 * @param $userinfo object info of the forum user
	 * @return array with status
	 */
	function createPost(&$dbparams, &$ids, &$contentitem, &$userinfo)
	{
		$status = array();
		$status["error"] = false;

		if($userinfo->guest) {
			$captcha_answer = JRequest::getVar('captcha_answer', '', 'POST');
			if($captcha_answer != $dbparams->get('captcha_answer')) {
				$status["error"][] = JText::_('CAPTCHA_INCORRECT');
				return $status;
		} else {
				$userinfo->username = JRequest::getVar('guest_username', '', 'POST');
				$userinfo->email = JRequest::getVar('guest_email', '', 'POST');
				$userinfo->userid = 0;

				$pattern = "^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$";
				if(empty($userinfo->username) || empty($userinfo->email) || !eregi($pattern, $userinfo->email)) {
					$status['error'][] = JTEXT::_('GUEST_FIELDS_MISSING');
					return $status;
				} else {
					//check to see if user exists to prevent user hijacking
					$JFusionUser = JFusionFactory::getUser($this->getJname());
					define('OVERRIDE_IDENTIFIER',3);
					$existinguser = $JFusionUser->getUser($userinfo->username);
					if(!empty($existinguser)) {
						$status["error"][] = JText::_('USERNAME_IN_USE');
						return $status;
					}

					//check for email
					$existinguser = $JFusionUser->getUser($userinfo->email);
					if(!empty($existinguser)) {
						$status["error"][] = JText::_('EMAIL_IN_USE');
						return $status;
					}
				}
			}
		}

		//setup some variables
		$userid = $userinfo->userid;
		$jdb =& JFusionFactory::getDatabase($this->getJname());
		$text = JRequest::getVar('quickReply', false, 'POST');

		if(!empty($text)) {
			$text = $this->prepareText($text);

			//get some topic information
			$where = "WHERE t.ID_TOPIC = {$ids->threadid} AND m.ID_MSG = t.ID_FIRST_MSG";
			$query = "SELECT t.ID_FIRST_MSG , t.numReplies, m.subject FROM `#__messages` as m INNER JOIN `#__topics` as t ON t.ID_TOPIC = m.ID_TOPIC $where";

			$jdb->setQuery($query);
			$topic = $jdb->loadObject();

			//the user information
			if($userinfo->guest) {
				$smfUser = new stdClass();
				$smfUser->memberName = $userinfo->username;
				$smfUser->emailAddress = $userinfo->email;
			} else {
				$query = "SELECT memberName,emailAddress FROM #__members WHERE ID_MEMBER = '$userid'";
				$jdb->setQuery($query);
				$smfUser = $jdb->loadObject();
			}

			$timestamp = time();

			$post_row = new stdClass();
			$post_row->ID_BOARD			= $ids->forumid;
			$post_row->ID_TOPIC 		= $ids->threadid;
			$post_row->posterTime		= $timestamp;
			$post_row->ID_MEMBER		= $userid;
			$post_row->ID_MSG_MODIFIED	= $userid;
			$post_row->subject			= 'Re: '.$topic->subject;
			$post_row->posterName		= $smfUser->memberName;
			$post_row->posterEmail		= $smfUser->emailAddress;
			$post_row->posterIP			= $_SERVER["REMOTE_ADDR"];
			$post_row->smileysEnabled	= 1;
			$post_row->modifiedTime		= 0;
			$post_row->modifiedName		= '';
			$post_row->body				= $text;
			$post_row->icon				= 'xx';

			if(!$jdb->insertObject('#__messages', $post_row, 'ID_MSG')) {
				$status['error'] = $jdb->stderr();
				return $status;
			}
			$postid = $jdb->insertid();

			$topic_row = new stdClass();
			$topic_row->ID_LAST_MSG			= $postid;
			$topic_row->ID_MEMBER_UPDATED	= (int) $userid;
			$topic_row->numReplies			= $topic->numReplies + 1;
			$topic_row->ID_TOPIC			= $ids->threadid;
			if(!$jdb->updateObject('#__topics', $topic_row, 'ID_TOPIC' )) {
				$status['error'] = $jdb->stderr();
				return $status;
			}

			$forum_stats = new stdClass();
			$forum_stats->ID_LAST_MSG 		=  $postid;
			$forum_stats->ID_MSG_UPDATED	=  $postid;
			$query = "SELECT numPosts FROM #__boards WHERE ID_BOARD = {$ids->forumid}";
			$jdb->setQuery($query);
			$num = $jdb->loadObject();
			$forum_stats->numPosts = $num->numPosts + 1;
			$forum_stats->ID_BOARD 			= $ids->forumid;
			if(!$jdb->updateObject('#__boards', $forum_stats, 'ID_BOARD' )) {
				$status['error'] = $jdb->stderr();
				return $status;
			}
		}
		return $status;
	}

	/**
     * Retrieves the posts to be displayed in the content item if enabled
     * @param object with discussion bot parameters
     * @param int Id of thread
     * @param int Id of first post which is useful if you do not want the first post to be included in results
     * @return array or object Returns retrieved posts
     */
	function getPosts(&$dbparams, &$existingthread)
	{
		$threadid =& $existingthread->threadid;
		$postid =& $existingthread->postid;

		//set the query
		$limit_posts = $dbparams->get("limit_posts");
		$limit = empty($limit_posts) || trim($limit_posts)==0 ? "" :  "LIMIT 0,$limit_posts";
		$sort = $dbparams->get("sort_posts");

		$where = "WHERE ID_TOPIC = {$threadid} AND ID_MSG != {$postid}";
		$query = "SELECT ID_TOPIC , ID_MSG, posterName, ID_MEMBER, CASE WHEN ID_MEMBER = 0 THEN 1 ELSE 0 END AS guest, subject, posterTime, body FROM `#__messages` $where ORDER BY posterTime $sort $limit";

		$jdb = & JFusionFactory::getDatabase($this->getJname());
		$jdb->setQuery($query);
		$posts = $jdb->loadObjectList();


		return $posts;
	}

	function getReplyCount(&$existingthread)
	{
		$db =& JFusionFactory::getDatabase($this->getJname());
		$query = "SELECT numReplies FROM #__topics WHERE ID_TOPIC = {$existingthread->threadid}";
		$db->setQuery($query);
		$result = $db->loadResult();
		return $result;
	}

	/**
	 * Returns an object of columns used in createPostTable()
	 * Saves from having to repeat the same code over and over for each plugin
	 * For example:
	 * $columns->userid = "userid";
	 * $columns->username = "username";
	 * $columns->username_clean = "username_clean"; //if applicable for filtered usernames
	 * $columns->dateline = "dateline";
	 * $columns->posttext = "pagetext";
	 * $columns->posttitle = "title";
	 * $columns->postid = "postid";
	 * $columns->threadid = "threadid";
	 * @return object with column names
	 */
	function getDiscussionColumns()
	{
		$columns = new stdClass();
		$columns->userid = "ID_MEMBER";
		$columns->username = "posterName";
		$columns->dateline = "posterTime";
		$columns->posttext = "body";
		$columns->posttitle = "subject";
		$columns->postid = "ID_MSG";
		$columns->threadid = "ID_TOPIC";
		$columns->guest = "guest";
		return $columns;
	}

	/**
     * Prepares text before saving to db or presentint to joomla article
     * @param string Text to be modified
     * @param $prepareForJoomla boolean to indicate if the text is to be saved to software's db or presented in joomla article
     * @return string Modified text
     */
	function prepareText($text, $prepareForJoomla = false)
	{
		static $bbcode;

		if($prepareForJoomla===false) {
			//first thing is to remove all joomla plugins
			preg_match_all('/\{(.*)\}/U',$text,$matches);

			//find each thread by the id
			foreach($matches[1] AS $plugin) {
				//replace plugin with nothing
				$text = str_replace('{'.$plugin.'}',"",$text);
			}
 			if(!is_array($bbcode)) {
 				$bbcode = array();
 				//pattens to run in begening
				$bbcode[0][] = "#<a[^>]*href=['|\"](ftp://)(.*?)['|\"][^>]*>(.*?)</a>#si";
 				$bbcode[1][] = "[ftp=$1$2]$3[/ftp]";

				//pattens to run in end
				$bbcode[2][] = '#<table[^>]*>(.*?)<\/table>#si';
				$bbcode[3][] = '[table]$1[/table]';

				$bbcode[2][] = '#<tr[^>]*>(.*?)<\/tr>#si';
				$bbcode[3][] = '[tr]$1[/tr]';

				$bbcode[2][] = '#<td[^>]*>(.*?)<\/td>#si';
				$bbcode[3][] = '[td]$1[/td]';

				$bbcode[2][] = '#<strong[^>]*>(.*?)<\/strong>#si';
				$bbcode[3][] = '[b]$1[/b]';

				$bbcode[2][] = '#<(strike|s)>(.*?)<\/\\1>#sim';
				$bbcode[3][] = '[s]$2[/s]';
 			}

			$text = JFusionFunction::parseCode($text,'bbcode',false,$bbcode);
		} else {
			//remove phpbb's bbcode uids
			$text = preg_replace("#\[(.*?):(.*?)]#si","[$1]",$text);
			//decode html entities
			$text = html_entity_decode($text);
			//parse bbcode to html
			$text = JFusionFunction::parseCode($text,'html');
		}

		return $text;
	}

    function getThread($threadid)
    {
		$db =& JFusionFactory::getDatabase($this->getJname());
		$query = "SELECT ID_TOPIC AS threadid, ID_BOARD AS forumid, ID_FIRST_MSG AS postid FROM #__topics WHERE ID_TOPIC = $threadid";
		$db->setQuery($query);
		$results = $db->loadObject();
		return $results;
    }
}
