<?php

/**
 * @package JFusion_phpBB3
 * @author JFusion development team
 * @copyright Copyright (C) 2008 JFusion. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */

// no direct access
defined('_JEXEC' ) or die('Restricted access' );

/**
 * JFusion Forum Class for phpBB3
 * For detailed descriptions on these functions please check the model.abstractforum.php
 * @package JFusion_phpBB3
 */
class JFusionForum_phpbb3 extends JFusionForum
{
	var $joomlaGlobals;

    function getJname()
    {
        return 'phpbb3';
    }

    function getThreadURL($threadid)
    {
        return 'viewtopic.php?t=' . $threadid;
    }

    function getPostURL($threadid, $postid)
    {
        return 'viewtopic.php?p='.$postid.'#p' . $postid;
    }

    function getProfileURL($uid)
    {
        return 'memberlist.php?mode=viewprofile&u='.$uid;
    }

    function getPrivateMessageURL()
    {
        return 'ucp.php?i=pm&folder=inbox';
    }

    function getViewNewMessagesURL()
    {
        return 'search.php?search_id=newposts';
    }


    function getAvatar($puser_id)
    {
        if ($puser_id) {

            $dbparams = JFusionFactory::getParams($this->getJname());
            $db = JFusionFactory::getDatabase($this->getJname());

            $db->setQuery('SELECT user_avatar, user_avatar_type FROM #__users WHERE user_id='.$puser_id);
            $db->query();
            $result = $db->loadObject();

            if (!empty($result)) {
                if ($result->user_avatar_type == 1) {
                    // AVATAR_UPLOAD
                    $url = $dbparams->get('source_url').'download/file.php?avatar='.$result->user_avatar;
                } else if ($result->user_avatar_type == 3) {
                    // AVATAR_GALLERY
                    $db->setQuery("SELECT config_value FROM #__config WHERE config_name='avatar_gallery_path'");
                    $db->query();
                    $path = $db->loadResult();
                    if (!empty($path)) {
                        $url = $dbparams->get('source_url').$path.'/'.$result->user_avatar;
                    } else {
                        $url = '';
                    }
                } else if ($result->user_avatar_type == 2) {
                    // AVATAR REMOTE URL
                    $url = $result->user_avatar;
                } else {
                    $url = '';
                }
                return $url;
            }
        }
        return 0;
    }

    function getPrivateMessageCounts($puser_id)
    {

        if ($puser_id) {

            // read pm counts
            $db = JFusionFactory::getDatabase($this->getJname());

            // read unread count
            $db->setQuery('SELECT COUNT(msg_id)
			FROM #__privmsgs_to
			WHERE pm_unread = 1
			AND folder_id <> -2
			AND user_id = '.$puser_id);
            $unreadCount = $db->loadResult();

            // read total pm count
            $db->setQuery('SELECT COUNT(msg_id)
			FROM #__privmsgs_to
			WHERE folder_id NOT IN (-1, -2)
			AND user_id = '.$puser_id);
            $totalCount = $db->loadResult();

            return array('unread' => $unreadCount, 'total' => $totalCount);
        }
        return array('unread' => 0, 'total' => 0);
    }

    function getActivityQuery($usedforums, $result_order, $result_limit)
    {
		$where = (!empty($usedforums)) ? ' WHERE a.forum_id IN (' . $usedforums .')' : '';
		$end = $result_order." LIMIT 0,".$result_limit;

		$query = array(
			//LAT with first post info
			LAT.'0' => "SELECT a.topic_id AS threadid, a.topic_last_post_id AS postid, a.topic_first_poster_name AS username, a.topic_poster AS userid, CASE WHEN b.poster_id = 1 THEN 1 ELSE 0 END AS guest, a.topic_title AS subject, a.topic_time AS dateline, a.forum_id as forum_specific_id FROM `#__topics` as a INNER JOIN `#__posts` as b ON a.topic_first_post_id = b.post_id $where ORDER BY a.topic_last_post_time $end",
			//LAT with latest post info
			LAT.'1' => "SELECT a.topic_id AS threadid, a.topic_last_post_id AS postid, a.topic_last_poster_name AS username, a.topic_last_poster_id AS userid, CASE WHEN a.topic_last_poster_id = 1 THEN 1 ELSE 0 END AS guest, a.topic_title AS subject, a.topic_last_post_time AS dateline, a.forum_id as forum_specific_id FROM `#__topics` as a INNER JOIN `#__posts` as b ON a.topic_first_post_id = b.post_id $where ORDER BY a.topic_last_post_time $end",
			LCT => "SELECT a.topic_id AS threadid, a.topic_first_post_id AS postid, a.topic_first_poster_name AS username, a.topic_poster AS userid, CASE WHEN a.topic_poster = 1 THEN 1 ELSE 0 END AS guest, a.topic_title AS subject, b.post_text AS body, a.topic_time AS dateline, a.forum_id as forum_specific_id FROM `#__topics` as a INNER JOIN `#__posts` as b ON a.topic_first_post_id = b.post_id $where ORDER BY a.topic_time $end",
			LCP => "SELECT a.topic_id AS threadid, a.post_id AS postid, CASE WHEN a.poster_id = 1 AND a.post_username!='' THEN a.post_username ELSE b.username END AS username, a.poster_id AS userid, CASE WHEN a.poster_id = 1 THEN 1 ELSE 0 END AS guest, a.post_subject AS subject, a.post_text AS body, a.post_time AS dateline, a.forum_id as forum_specific_id FROM `#__posts` AS a INNER JOIN `#__users` AS b ON a.poster_id = b.user_id $where ORDER BY a.post_time $end"
		);

        return $query;
    }

    function getForumList()
    {
        //get the connection to the db

        $db = JFusionFactory::getDatabase($this->getJname());
        $query = 'SELECT forum_id as id, forum_name as name FROM #__forums
					WHERE forum_type = 1 ORDER BY left_id';
        $db->setQuery($query );

        //getting the results
        return $db->loadObjectList();
    }


    /************************************************
	 * Functions For JFusion Discussion Bot Plugin
	 ***********************************************/

    /**
     * Checks to see if a thread already exists for the content item and calls the appropriate function
     * @param object with discussion bot parameters
     * @param object $contentitem object containing content information
     * @return array Returns status of actions with errors if any
     */
	function checkThreadExists(&$dbparams, &$contentitem, &$existingthread, $forumid)
	{
		$status = array();
		$status['debug'] = array();
        $status['error'] = array();

		//set the timezone to UTC
		date_default_timezone_set('UTC');

		if(!empty($existingthread))
		{
			//datetime post was last updated
			$postModified = $existingthread->modified;
			//datetime content was last updated
			$contentModified = strtotime($contentitem->modified);

			//check to make sure the thread still exists in the software
			$jdb = & JFusionFactory::getDatabase($this->getJname());
			$query = "SELECT COUNT(*) FROM #__topics WHERE forum_id = {$existingthread->forumid} AND topic_id = {$existingthread->threadid} AND topic_first_post_id = {$existingthread->postid}";
			$jdb->setQuery($query);
			if($jdb->loadResult()==0)
			{
				//the thread no longer exists in the software!!  recreate it
				$this->createThread($dbparams, $contentitem, $forumid, $status);
            	if (empty($status['error'])) {
                	$status['action'] = 'created';
            	}
            	return $status;
			}
			elseif($contentModified > $postModified)
			{
				//update the post if the content has been updated
				$this->updateThread($dbparams, $existingthread, $contentitem, $status);
				if (empty($status['error'])) {
                	$status['action'] = 'updated';
            	}
            	return $status;
			}
		}
	    else
	    {
	    	//thread does not exist; create it
            $this->createThread($dbparams, $contentitem, $forumid, $status);
            if (empty($status['error'])) {
                $status['action'] = 'created';
            }
            return $status;
        }
	}

    /**
     * Retrieves thread information
     * @param int Id of specific thread
     * @return object Returns object with thread information
     * return the object with these three items
     * $result->forumid
     * $result->threadid (yes add it even though it is passed in as it will be needed in other functions)
     * $result->postid - this is the id of the first post in the thread
     */
    function getThread($threadid)
    {
		$db =& JFusionFactory::getDatabase($this->getJname());
		$query = "SELECT topic_id AS threadid, forum_id AS forumid, topic_first_post_id AS postid FROM #__topics WHERE topic_id = $threadid";
		$db->setQuery($query);
		$results = $db->loadObject();
		return $results;
    }

     /**
     * Creates new thread and posts first post
     * @param object with discussion bot parameters
     * @param object $contentitem object containing content information
     * @param int Id of forum to create thread
     * @param array $status contains errors and status of actions
     */
	function createThread(&$dbparams, &$contentitem, $forumid, &$status)
	{
		//setup some variables
		$userid = $dbparams->get("default_userid");
		$firstPost = $dbparams->get("first_post");
		$jdb =& JFusionFactory::getDatabase($this->getJname());
		$subject = trim(strip_tags($contentitem->title));

		//set what should be posted as the first post
		if($firstPost=="articleLink") {
			//create link
			$forumText = $dbparams->get("first_post_link_text");
			if($dbparams->get("first_post_link_type") == 'image') {
				$forumText = "<img src='$forumText'>";
			}
			$text = $this->prepareText(JFusionFunction::createJoomlaArticleURL($contentitem,$forumText));
		} elseif($firstPost=="articleIntro") {
			//prepare the text for posting
			$text = $this->prepareText($contentitem->introtext)."</br></br>";

			//create link
			$forumText = $dbparams->get("first_post_link_text");
			if($dbparams->get("first_post_link_type") == 'image') {
				$forumText = "<img src='$forumText'>";
			}
			$text .= $this->prepareText(JFusionFunction::createJoomlaArticleURL($contentitem,$forumText));
		} else {
			//prepare the text for posting
			$text = $this->prepareText($contentitem->introtext . $contentitem->fulltext);
		}

		//the user information
		$query = "SELECT username, username_clean, user_colour, user_permissions FROM #__users WHERE user_id = '$userid'";
		$jdb->setQuery($query);
		$phpbbUser = $jdb->loadObject();

		$timestamp = $dbparams->get('use_content_created_date',false) ? strtotime($contentitem->created) : time();

		$topic_row = new stdClass();
		$topic_row->topic_poster = $userid;
		$topic_row->topic_time = $timestamp;
		$topic_row->forum_id = $forumid;
		$topic_row->icon_id = false;
		$topic_row->topic_approved	= 1;
		$topic_row->topic_title = $subject;
		$topic_row->topic_first_poster_name	= $phpbbUser->username;
		$topic_row->topic_first_poster_colour = $phpbbUser->user_permissions;
		$topic_row->topic_type = 0;
		$topic_row->topic_time_limit = 0;
		$topic_row->topic_attachment = 0;

		if(!$jdb->insertObject('#__topics', $topic_row, 'topic_id' )){
			$status['error'] = $jdb->stderr();
			return;
		}
		$topicid = $jdb->insertid();

		require_once(JPATH_ADMINISTRATOR .DS.'components'.DS.'com_jfusion'.DS.'plugins'.DS.$this->getJname().DS.'bbcode_parser.php');
		$parser = new phpbb_bbcode_parser($text, $this->getJname());

		$post_row = new stdClass();
		$post_row->forum_id			= $forumid;
		$post_row->topic_id 		= $topicid;
		$post_row->poster_id		= $userid;
		$post_row->icon_id			= 0;
		$post_row->poster_ip		= $_SERVER["REMOTE_ADDR"];
		$post_row->post_time		= $timestamp;
		$post_row->post_approved	= 1;
		$post_row->enable_bbcode	= 1;
		$post_row->enable_smilies	= 1;
		$post_row->enable_magic_url	= 1;
		$post_row->enable_sig		= 1;
		$post_row->post_username	= $phpbbUser->username;
		$post_row->post_subject		= $subject;
		$post_row->post_text		= $parser->text;
		$post_row->post_checksum	= md5($parser->text);
		$post_row->post_attachment	= 0;
		$post_row->bbcode_bitfield	= $parser->bbcode_bitfield;
		$post_row->bbcode_uid		= $parser->bbcode_uid;
		$post_row->post_postcount	= 1;
		$post_row->post_edit_locked	= 0;

		if(!$jdb->insertObject('#__posts', $post_row, 'post_id')) {
			$status['error'] = $jdb->stderr();
			return;
		}
		$postid = $jdb->insertid();

		$topic_row = new stdClass();
		$topic_row->topic_first_post_id			= $postid;
		$topic_row->topic_last_post_id			= $postid;
		$topic_row->topic_last_post_time		= $timestamp;
		$topic_row->topic_last_poster_id		= (int) $userid;
		$topic_row->topic_last_poster_name		= $phpbbUser->username;
		$topic_row->topic_last_poster_colour	= $phpbbUser->user_colour;
		$topic_row->topic_last_post_subject		= (string) $subject;
		$topic_row->topic_id					= $topicid;
		if(!$jdb->updateObject('#__topics', $topic_row, 'topic_id' )) {
			$status['error'] = $jdb->stderr();
			return;
		}

		$query = "SELECT forum_last_post_time, forum_topics, forum_topics_real, forum_posts FROM #__forums WHERE forum_id = $forumid";
		$jdb->setQuery($query);
		$num = $jdb->loadObject();

		$forum_stats = new stdClass();

		if($dbparams->get('use_content_created_date',false)) {
			//only update the last post for the topic if it really is newer
			$updateLastPost = ($timestamp > $num->forum_last_post_time) ? true : false;
		} else {
			$updateLastPost = true;
		}

		if($updateLastPost) {
			$forum_stats->forum_last_post_id 		=  $postid;
			$forum_stats->forum_last_post_subject	= $jdb->Quote($subject);
			$forum_stats->forum_last_post_time 		=  $timestamp;
			$forum_stats->forum_last_poster_id 		=  (int) $userid;
			$forum_stats->forum_last_poster_name 	=  $phpbbUser->username;
			$forum_stats->forum_last_poster_colour 	= $phpbbUser->user_colour;
		}

		$forum_stats->forum_id 			= $forumid;
		$forum_stats->forum_topics 		= $num->forum_topics + 1;
		$forum_stats->forum_topics_real = $num->forum_topics_real + 1;
		$forum_stats->forum_posts 		= $num->forum_posts + 1;

		if(!$jdb->updateObject('#__forums', $forum_stats, 'forum_id' )) {
			$status['error'] = $jdb->stderr();
			return;
		}

		//update some stats
		$query = "UPDATE #__users SET user_posts = user_posts + 1 WHERE user_id = {$userid}";
		$jdb->setQuery($query);
		if(!$jdb->query()) {
			$status['error'] = $jdb->stderr();
		}

		$query = 'UPDATE #__config SET config_value = config_value + 1 WHERE config_name = \'num_topics\'';
		$jdb->setQuery($query);
		if(!$jdb->query()) {
			$status['error'] = $jdb->stderr();
		}

		if(!empty($topicid) && !empty($postid)) {
			//save the threadid to the lookup table
			JFusionFunction::updateForumLookup($contentitem->id, $forumid, $topicid, $postid, $this->getJname());
		}
	}


	/**
	 * Returns HTML of a quick reply
	 * @param $dbparams object with discussion bot parameters
	 * @param boolean $showGuestInputs toggles whether to show guest inputs or not
	 * @return string of html
	 */
	function createQuickReply(&$dbparams,$showGuestInputs)
	{
		$html = '';
		if($showGuestInputs) {
			$html .= "<table><tr><td>".JText::_('USERNAME') .":</td><td><input name='guest_username' value='' class='inputbox'/></td></tr>";
			$question = $dbparams->get('captcha_question');
			if(!empty($question)) {
				$html .= "<tr><td>$question:</td><td><input name='captcha_answer' value='' class='inputbox'/></td></tr>";
			}
			$html .= "</table><br>";
		}
	   	$html .= "<textarea name='quickReply' class='inputbox'></textarea><br>";
	   	$html .= "<div style='width:100%; text-align:right;'><input type='submit' value='Submit'/></div>";
	   	return $html;
	}

	 /**
     * Updates information in a specific thread/post
     * @param object with discussion bot parameters
     * @param object with existing thread info
     * @param object $contentitem object containing content information
     * @param array $status contains errors and status of actions
     */
	function updateThread(&$dbparams, &$existingthread, &$contentitem, &$status)
	{
		$threadid =& $existingthread->threadid;
		$forumid =& $existingthread->forumid;
		$postid =& $existingthread->postid;

		//setup some variables
		$firstPost = $dbparams->get("first_post");
		$jdb =& JFusionFactory::getDatabase($this->getJname());
		$subject = trim(strip_tags($contentitem->title));

		//set what should be posted as the first post
		if($firstPost=="articleLink") {
			//create link
			$forumText = $dbparams->get("first_post_link_text");
			if($dbparams->get("first_post_link_type") == 'image') {
				$forumText = "<img src='$forumText'>";
			}
			$text = $this->prepareText(JFusionFunction::createJoomlaArticleURL($contentitem,$forumText));
		} elseif($firstPost=="articleIntro") {
			//prepare the text for posting
			$text = $this->prepareText($contentitem->introtext)."</br></br>";

			//create link
			$forumText = $dbparams->get("first_post_link_text");
			if($dbparams->get("first_post_link_type") == 'image') {
				$forumText = "<img src='$forumText'>";
			}
			$text .= $this->prepareText(JFusionFunction::createJoomlaArticleURL($contentitem,$forumText));
		} else {
			//prepare the text for posting
			$text = $this->prepareText($contentitem->introtext . $contentitem->fulltext);
		}

		require_once(JPATH_ADMINISTRATOR .DS.'components'.DS.'com_jfusion'.DS.'plugins'.DS.$this->getJname().DS.'bbcode_parser.php');
		$parser = new phpbb_bbcode_parser($text, $this->getJname());

		$timestamp = time();
		$userid = $dbparams->get('default_user');

		$query = "SELECT post_edit_count FROM #__posts WHERE post_id = $postid";
		$jdb->setQuery($query);
		$count = $jdb->loadResult();

		$post_row = new stdClass();
		$post_row->post_subject		= $subject;
		$post_row->post_text		= $parser->text;
		$post_row->post_checksum	= md5($parser->text);
		$post_row->bbcode_bitfield	= $parser->bbcode_bitfield;
		$post_row->bbcode_uid		= $parser->bbcode_uid;
		$post_row->post_edit_time 	= $timestamp;
		$post_row->post_edit_reason = 'JFusion Discussion Bot '. JText::_('UPDATE');
		$post_row->post_edit_user	= $userid;
		$post_row->post_edit_count	= $count + 1;
		$post_row->post_id 			= $postid;
		if(!$jdb->updateObject('#__posts', $post_row, 'post_id')) {
			$status['error'] = $jdb->stderr();
		} else {
			//update the lookup table
			JFusionFunction::updateForumLookup($contentitem->id, $forumid, $threadid, $postid, $this->getJname());
		}
	}

	/**
	 * Creates a post from the quick reply
	 * @param object with discussion bot parameters
	 * @param $ids array with thread id ($ids["threadid"]) and first post id ($ids["postid"])
	 * @param $contentitem object of content item
	 * @param $userinfo object info of the forum user
	 * @return array with status
	 */
	function createPost(&$dbparams, &$ids, &$contentitem, &$userinfo)
	{
		$status = array();
		$status["error"] = false;

		if($userinfo->guest) {
			$captcha_answer = JRequest::getVar('captcha_answer', '', 'POST');
			if($captcha_answer != $dbparams->get('captcha_answer')) {
				$status["error"][] = JText::_('CAPTCHA_INCORRECT');
				return $status;
			} else {
				$userinfo->username = JRequest::getVar('guest_username', '', 'POST');
				$userinfo->userid = 1;

				//check to see if user exists to prevent user hijacking
				$JFusionUser = JFusionFactory::getUser($this->getJname());
				define('OVERRIDE_IDENTIFIER',3);
				$existinguser = $JFusionUser->getUser($userinfo);
				if(!empty($existinguser)) {
					$status["error"][] = JText::_('USERNAME_IN_USE');
					return $status;
				}
			}
		}
		//setup some variables
		$userid = $userinfo->userid;
		$jdb =& JFusionFactory::getDatabase($this->getJname());
		$text = JRequest::getVar('quickReply', false, 'POST');

		if(!empty($text)) {
			$text = $this->prepareText($text);

			require_once(JPATH_ADMINISTRATOR .DS.'components'.DS.'com_jfusion'.DS.'plugins'.DS.$this->getJname().DS.'bbcode_parser.php');
			$parser = new phpbb_bbcode_parser($text, $this->getJname());

			//get some topic information
			$query = "SELECT topic_title, topic_replies, topic_replies_real FROM #__topics WHERE topic_id = {$ids->threadid}";
			$jdb->setQuery($query);
			$topic = $jdb->loadObject();
			//the user information
			$query = "SELECT username, user_colour, user_permissions FROM #__users WHERE user_id = '$userid'";
			$jdb->setQuery($query);
			$phpbbUser = $jdb->loadObject();

			if($userinfo->guest && !empty($userinfo->username)) {
				$phpbbUser->username = $userinfo->username;
			}

			$timestamp = time();

			$post_row = new stdClass();
			$post_row->forum_id			= $ids->forumid;
			$post_row->topic_id 		= $ids->threadid;
			$post_row->poster_id		= $userid;
			$post_row->icon_id			= 0;
			$post_row->poster_ip		= $_SERVER["REMOTE_ADDR"];
			$post_row->post_time		= $timestamp;
			$post_row->post_approved	= 1;
			$post_row->enable_bbcode	= 1;
			$post_row->enable_smilies	= 1;
			$post_row->enable_magic_url	= 1;
			$post_row->enable_sig		= 1;
			$post_row->post_username	= $phpbbUser->username;
			$post_row->post_subject		= "Re: {$topic->topic_title}";
			$post_row->post_text		= $parser->text;
			$post_row->post_checksum	= md5($parser->text);
			$post_row->post_attachment	= 0;
			$post_row->bbcode_bitfield	= $parser->bbcode_bitfield;
			$post_row->bbcode_uid		= $parser->bbcode_uid;
			$post_row->post_postcount	= 1;
			$post_row->post_edit_locked	= 0;

			if(!$jdb->insertObject('#__posts', $post_row, 'post_id')) {
				$status['error'] = $jdb->stderr();
				return $status;
			}
			$postid = $jdb->insertid();

			$topic_row = new stdClass();
			$topic_row->topic_last_post_id			= $postid;
			$topic_row->topic_last_post_time		= $timestamp;
			$topic_row->topic_last_poster_id		= (int) $userid;
			$topic_row->topic_last_poster_name		= $phpbbUser->username;
			$topic_row->topic_last_poster_colour	= $phpbbUser->user_colour;
			$topic_row->topic_last_post_subject		= '';
			$topic_row->topic_replies				= $topic->topic_replies + 1;
			$topic_row->topic_replies_real 			= $topic->topic_replies_real + 1;
			$topic_row->topic_id					= $ids->threadid;
			if(!$jdb->updateObject('#__topics', $topic_row, 'topic_id' )) {
				$status['error'] = $jdb->stderr();
				return $status;
			}

			$query = "SELECT forum_posts FROM #__forums WHERE forum_id = {$ids->forumid}";
			$jdb->setQuery($query);
			$num = $jdb->loadObject();

			$forum_stats = new stdClass();
			$forum_stats->forum_last_post_id 		= $postid;
			$forum_stats->forum_last_post_subject	= '';
			$forum_stats->forum_last_post_time 		= $timestamp;
			$forum_stats->forum_last_poster_id 		= (int) $userid;
			$forum_stats->forum_last_poster_name 	= $phpbbUser->username;
			$forum_stats->forum_last_poster_colour 	= $phpbbUser->user_colour;
			$forum_stats->forum_posts				= $num->forum_posts + 1;
			$forum_stats->forum_id 					= $ids->forumid;
			$query = "SELECT forum_topics, forum_topics_real, forum_posts FROM #__forums WHERE forum_id = {$ids->forumid}";
			$jdb->setQuery($query);
			$num = $jdb->loadObject();
			$forum_stats->forum_topics = $num->forum_topics + 1;
			$forum_stats->forum_topics_real = $num->forum_topics_real + 1;
			$forum_stats->forum_posts = $num->forum_posts + 1;
			if(!$jdb->updateObject('#__forums', $forum_stats, 'forum_id' )) {
				$status['error'] = $jdb->stderr();
				return $status;
			}

			//update some stats
			$query = "UPDATE #__users SET user_posts = user_posts + 1 WHERE user_id = {$userid}";
			$jdb->setQuery($query);
			if(!$jdb->query()) {
				$status['error'] = $jdb->stderr();
			}

			$query = 'UPDATE #__config SET config_value = config_value + 1 WHERE config_name = \'num_posts\'';
			$jdb->setQuery($query);
			if(!$jdb->query()) {
				$status['error'] = $jdb->stderr();
			}
		}
		return $status;
	}

	/**
     * Prepares text before saving to db or presentint to joomla article
     * @param string Text to be modified
     * @param $prepareForJoomla boolean to indicate if the text is to be saved to software's db or presented in joomla article
     * @return string Modified text
     */
	function prepareText($text, $prepareForJoomla = false)
	{
		if($prepareForJoomla===false) {
			//first thing is to remove all joomla plugins
			preg_match_all('/\{(.*)\}/U',$text,$matches);

			//find each thread by the id
			foreach($matches[1] AS $plugin) {
				//replace plugin with nothing
				$text = str_replace('{'.$plugin.'}',"",$text);
			}
			$text = JFusionFunction::parseCode($text,'bbcode');

			//now we have to parse the bbcode into phpBB's crazy format

		} else {
			//remove phpbb's bbcode uids
			$text = preg_replace("#\[(.*?):(.*?)]#si","[$1]",$text);
			//decode html entities
			$text = html_entity_decode($text);


			if(strpos($text,'SMILIES_PATH')!==false) {
				//must convert smilies
				$db =& JFusionFactory::getDatabase($this->getJname());
				$query = "SELECT config_value FROM #__config WHERE config_name = 'smilies_path'";
				$db->setQuery($query);
				$smilie_path = $db->loadResult();
				$params =& JFusionFactory::getParams($this->getJname());
				$source_url = $params->get('source_url');
				$text = preg_replace('#<!-- s(.*?) --><img src="\{SMILIES_PATH\}\/(.*?)" alt="(.*?)" title="(.*?)" \/>#si',"[img]{$source_url}{$smilie_path}/$2[/img]",$text);
			}

			//parse bbcode to html
			$text = JFusionFunction::parseCode($text,'html');
		}
		return $text;
	}

	/**
	 * Returns an object of columns used in createPostTable()
	 * Saves from having to repeat the same code over and over for each plugin
	 * For example:
	 * $columns->userid = "userid";
	 * $columns->username = "username";
	 * $columns->username_clean = "username_clean"; //if applicable for filtered usernames
	 * $columns->dateline = "dateline";
	 * $columns->posttext = "pagetext";
	 * $columns->posttitle = "title";
	 * $columns->postid = "postid";
	 * $columns->threadid = "threadid";
	 * @return object with column names
	 */
	function getDiscussionColumns()
	{
		$columns = new stdClass();
		$columns->userid = "user_id";
		$columns->username = "username";
		$columns->username_clean = "username_clean";
		$columns->dateline = "post_time";
		$columns->posttext = "post_text";
		$columns->posttitle = "post_subject";
		$columns->postid = "post_id";
		$columns->threadid = "topic_id";
		$columns->guest = "guest";
		return $columns;
	}

	/**
     * Retrieves the posts to be displayed in the content item if enabled
     * @param object with discussion bot parameters
     * @param int Id of thread
     * @param int Id of first post which is useful if you do not want the first post to be included in results
     * @return array or object Returns retrieved posts
     */
	function getPosts(&$dbparams, &$existingthread)
	{
		$threadid =& $existingthread->threadid;
		$postid =& $existingthread->postid;

		//set the query
		$limit_posts = $dbparams->get("limit_posts");
		$limit = empty($limit_posts) || trim($limit_posts)==0 ? "" :  "LIMIT 0,$limit_posts";
		$sort = $dbparams->get("sort_posts");

		$where = "WHERE p.topic_id = {$threadid} AND p.post_id != {$postid} AND p.post_approved = 1";
		$query = "SELECT p.post_id , CASE WHEN p.poster_id = 1 THEN 1 ELSE 0 END AS guest, CASE WHEN p.poster_id = 1 AND p.post_username!='' THEN p.post_username ELSE u.username END AS username, u.username_clean, u.user_id, p.post_subject, p.post_time, p.post_text, p.topic_id FROM `#__posts` as p INNER JOIN `#__users` as u ON p.poster_id = u.user_id $where ORDER BY p.post_time $sort $limit";

		$jdb = & JFusionFactory::getDatabase($this->getJname());
		$jdb->setQuery($query);
		$posts = $jdb->loadObjectList();

		return $posts;
	}

	function getReplyCount(&$existingthread)
	{
		$db =& JFusionFactory::getDatabase($this->getJname());
		$query = "SELECT topic_replies FROM #__topics WHERE topic_id = {$existingthread->threadid}";
		$db->setQuery($query);
		$result = $db->loadResult();
		return $result;
	}
}