<?php
/**
* @package JFusion_Magento
* @author Henk Wevers
* @copyright Copyright (C) 2008 JFusion. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

// no direct access
defined('_JEXEC' ) or die('Restricted access' );

/**
 * load the factory
 */
//require_once dirname(__FILE__) . DS . 'factory.php';

/**
 * JFusion Admin class for Magento 1.1
 * For detailed descriptions on these functions please check the model.abstractadmin.php
 * @package JFusion_Magento
 */
class JFusionAdmin_magento extends JFusionAdmin{

    function getJname(){
        return 'magento';
    }

    function getTablename(){
        return 'admin_user';
    }

    function setupFromPath($forumPath){
        //check for trailing slash and generate file path
        if (substr($forumPath, -1) != DS) {
            $forumpath = $forumPath.DS;
        }
        $xmlfile = $forumpath.'app'.DS.'etc'.DS.'local.xml';
        if (file_exists($xmlfile)) {
   			$xml = JFactory::getXMLParser('Simple');
            if (!$xml->loadFile($xmlfile)) {
                unset($xml);
                JError::raiseWarning(500,JText::_('WIZARD_FAILURE'). " $xmlfile " . JText::_('WIZARD_MANUAL'));
	            $result = false;
    	        return $result;
            }

            //save the parameters into array
            $params = array();
            $params['database_host']     = (string)$xml->document->global[0]->resources[0]->default_setup[0]->connection[0]->host[0]->data();
            $params['database_name']     = (string)$xml->document->global[0]->resources[0]->default_setup[0]->connection[0]->dbname[0]->data();
            $params['database_user']     = (string)$xml->document->global[0]->resources[0]->default_setup[0]->connection[0]->username[0]->data();
            $params['database_password'] = (string)$xml->document->global[0]->resources[0]->default_setup[0]->connection[0]->password[0]->data();
            $params['database_prefix']   = (string)$xml->document->global[0]->resources[0]->db[0]->table_prefix[0]->data();
            $params['database_type']     = "mysql";
            $params['source_path']       = $forumpath;
            unset($xml);
            return $params;
        } else {
            JError::raiseWarning(500,JText::_('WIZARD_FAILURE'). " $xmlfile " . JText::_('WIZARD_MANUAL'));
            $result = false;
            return $result;
        }
    }

    function getUserList(){
        //getting the connection to the db
        $db = JFusionFactory::getDataBase($this->getJname());
        $query = 'SELECT email as username, email from #__customer_entity';
        $db->setQuery($query );

        //getting the results
        $userlist = $db->loadObjectList();

        return $userlist;
    }

    function getUserCount(){
        //getting the connection to the db
        $db = JFusionFactory::getDataBase($this->getJname());
        $query = 'SELECT count(*) from #__customer_entity';
        $db->setQuery($query );
        //getting the results
        $no_users = $db->loadResult();

        return $no_users;
    }

    function getUsergroupList(){
        //get the connection to the db
        $db = JFusionFactory::getDataBase($this->getJname());
        $query = 'SELECT customer_group_id as id, customer_group_code as name from #__customer_group;';
        $db->setQuery($query );

        //getting the results
        return $db->loadObjectList();
    }

    function getDefaultUsergroup(){
        $params = JFusionFactory::getParams($this->getJname());
        $usergroup_id = $params->get('usergroup');

        //we want to output the usergroup name
        $db = JFusionFactory::getDatabase($this->getJname());
        $query = 'SELECT customer_group_code from #__customer_group WHERE customer_group_id = ' . $usergroup_id;
        $db->setQuery($query );
        return $db->loadResult();
    }
    
	function allow_empty_cookie_path(){
		return true;
	}

	function allow_empty_cookie_domain() {
		return true;
	}

	function debugConfigExtra(){
		// see if we have an api user in Magento
		$jname = $this->getJname();
        $db = JFusionFactory::getDataBase($this->getJname());
        $query = 'SELECT count(*) from #__api_user';
        $db->setQuery($query );
        $no_users = $db->loadResult();
        if ($no_users <= 0){
       		JError::raiseWarning(0, $jname . ': ' . JText::_('MAGENTO_NEED_API_USER'));
        } else{
        	// check if we have valid parameters  for apiuser and api key
        	$params = JFusionFactory::getParams($this->getJname());
   			$apiuser = $params->get('apiuser');
   			$apikey = $params->get('apikey');
   			if (!$apiuser || !$apikey ){
     			JError::raiseWarning(0, $jname . '-plugin: ' . JText::_('MAGENTO_NO_API_DATA'));
   			} else {
   				//finally check if the apiuser and apikey are valid
   				$query = 'SELECT api_key FROM #__api_user WHERE username = ' . $db->Quote($apiuser);
        		$db->setQuery($query);
        		$api_key = $db->loadResult();
        		$hashArr = explode(':', $api_key);
        		$api_key =  $hashArr[0];
        		$api_salt = $hashArr[1];
        		if($api_salt) {
          			$params_hash = md5($api_salt.$apikey);
        		} else {
          			$params_hash = md5($apikey);
        		}
        		if ($params_hash != $api_key){
     				JError::raiseWarning(0, $jname . '-plugin: ' . JText::_('MAGENTO_WRONG_APIUSER_APIKEY_COMBINATION'));
        		}
   			}
        }

        // check the user_remote_addr security settings
        $query = "SELECT  value FROM #__core_config_data WHERE path = 'web/session/use_remote_addr'";
        $db->setQuery($query );
        if ($db->_errorNum == 0){
        	$value = $db->loadResult();
        	if ($value) {
  				JError::raiseWarning(0, $jname . ': ' . JText::_('MAGENTO_USE_REMOTE_ADDRESS_NOT_DISABLED'));
        	}
 		}
 		
 		// we need to have the curl library installed
 		if (!extension_loaded('curl')) {
      		JError::raiseWarning(0, $jname . ': ' . JText::_('CURL_NOTINSTALLED'));
 		}
 	}

    function allowRegistration(){
    	$result = true;
       	$params = JFusionFactory::getParams($this->getJname());
		$registration_disabled = $params->get('disabled_registration');
		if ($registration_disabled){$result = false;}
		return $result;
    }

}