<?php
/**
 * @package JFusion_dokuwiki
 * @author JFusion development team
 * @copyright Copyright (C) 2008 JFusion. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */

// no direct access
defined('_JEXEC' ) or die('Restricted access' );

/**
 * load the JFusion framework
 */
require_once(JPATH_ADMINISTRATOR .DS.'components'.DS.'com_jfusion'.DS.'models'.DS.'model.jfusion.php');
require_once(JPATH_ADMINISTRATOR .DS.'components'.DS.'com_jfusion'.DS.'models'.DS.'model.abstractadmin.php');
require_once( dirname(__FILE__).DS.'dokuwiki.php');

/**
 * JFusion plugin class for punBB
 * @package JFusion_punBB
 */
class JFusionAdmin_dokuwiki extends JFusionAdmin {

    function getJname()
    {
        return 'dokuwiki';
    }

    function checkConfig()
    {
        $status = array();

		$params = JFusionFactory::getParams($this->getJname());
		$share = Dokuwiki::getInstance();

        $source_path = $params->get('source_path');
		$config = $share->getConf($source_path);
        if (is_array($config)) {
            $status['config'] = 1;
			$status['message'] = JText::_('GOOD_CONFIG');
            return $status;
        } else {
            $status['config'] = 0;
			$status['message'] = JText::_('WIZARD_FAILURE');
            return $status;
        }
    }

    function setupFromPath($Path)
    {
        $share = Dokuwiki::getInstance();
         //try to open the file
         if ($config = $share->getConf($Path) === FALSE) {
            JError::raiseWarning(500,JText::_('WIZARD_FAILURE'). ": $Path " . JText::_('WIZARD_MANUAL'));
            return false;
         } else {
            $params = array();
            $params['cookie_name'] = $config['cookie_name'];
			$params['cookie_path'] = $config['cookie_path'];
			$params['cookie_domain'] = $config['cookie_domain'];
			$params['cookie_seed'] = $config['cookie_seed'];
			$params['cookie_secure'] = $config['cookie_secure'];
            $params['source_path'] = $Path;
            return $params;
        }
    }

    function getAvatar($userid)
    {
        return 0;
    }

    function getUserList()
    {
        $share = Dokuwiki::getInstance();
        $conf = $share->getConf();
        return $share->getUserList();
	}

    function getUserCount()
    {
        $share = Dokuwiki::getInstance();
//        $userlist = $this->getUserList();
        return $share->auth->getUserCount();
    }

    function getUsergroupList()
    {
        $default_group = new stdClass;
        $default_group->name = $default_group->id = JFusionAdmin_dokuwiki::getDefaultUsergroup();
        $UsergroupList[] = $default_group;
        return $UsergroupList;
    }

    function getDefaultUsergroup()
    {
        $share = Dokuwiki::getInstance();
        return $share->getDefaultUsergroup();
    }

    function allowRegistration()
    {
        $share = Dokuwiki::getInstance();
        $conf = $share->getConf();
        if (strpos($conf['disableactions'], 'register') !== false) {
            return false;
        } else {
            return true;
        }
    }

    function debugConfig()
    {
    	$jname = $this->getJname();

    	//get registration status
		$new_registration  = $this->allowRegistration();

        //get the data about the JFusion plugins
        $db = & JFactory::getDBO();
        $query = 'SELECT * from #__jfusion WHERE name = ' . $db->Quote($jname);
        $db->setQuery($query );
        $plugin = $db->loadObject();

		//output a warning to the administrator if the allowRegistration setting is wrong
		if ($new_registration && $plugin->slave == '1'){
   			JError::raiseNotice(0, $jname . ': ' . JText::_('DISABLE_REGISTRATION'));
		}
		if (!$new_registration && $plugin->master == '1'){
   			JError::raiseNotice(0, $jname . ': ' . JText::_('ENABLE_REGISTRATION'));
		}
    }

	function generateRedirectCode()
	{
        	$params = JFusionFactory::getParams($this->getJname());
        	$joomla_params = JFusionFactory::getParams('joomla_int');
		    $joomla_url = $joomla_params->get('source_url');
    		$joomla_itemid = $params->get('redirect_itemid');

			//create the new redirection code
			$redirect_code = '
//JFUSION REDIRECT START
//SET SOME VARS
$joomla_url = \''. $joomla_url . '\';
$joomla_itemid = ' . $joomla_itemid .';
	';
		    $redirect_code .= '
if(!defined(\'_JEXEC\'))';

		    $redirect_code .= '
{
	$QUERY_STRING = array_merge( $_GET,$_POST );
	if (!isset($QUERY_STRING[\'id\'])) $QUERY_STRING[\'id\'] = $ID;
	$QUERY_STRING = http_build_query($QUERY_STRING);
	$order = array(\'%3A\', \':\', \'/\');
	$QUERY_STRING = str_replace($order,\';\',$QUERY_STRING);
	$pattern = \'#do=(admin|login|logout)#\';
	if ( !preg_match( $pattern , $QUERY_STRING ) ) {
		$file = $_SERVER["SCRIPT_NAME"];
		$break = explode(\'/\', $file);
		$pfile = $break[count($break) - 1];
		$jfusion_url = $joomla_url . \'index.php?option=com_jfusion&Itemid=\' . $joomla_itemid . \'&jfile=\'.$pfile. \'&\' . $QUERY_STRING;
		header(\'Location: \' . $jfusion_url);
		exit;
	}
}
//JFUSION REDIRECT END
';
	return $redirect_code;
	}

    function enable_redirect_mod()
    {
    	$error = 0;
    	$error = 0;
    	$reason = '';
    	$mod_file = $this->getModFile('doku.php',$error,$reason);

		if($error == 0) {
			//get the joomla path from the file
			jimport('joomla.filesystem.file');
			$file_data = JFile::read($mod_file);
	      	preg_match_all('/\/\/JFUSION REDIRECT START(.*)\/\/JFUSION REDIRECT END/ms',$file_data,$matches);

			//remove any old code
			if(!empty($matches[1][0])){
		      	$search = '/\/\/JFUSION REDIRECT START(.*)\/\/JFUSION REDIRECT END/ms';
		      	$file_data = preg_replace($search,'',$file_data);

			}

			$redirect_code = $this->generateRedirectCode();

	      	$search = '/getID\(\)\;/si';
			$replace = 'getID();' . $redirect_code;
	      	$file_data = preg_replace($search,$replace,$file_data);
			JFile::write($mod_file, $file_data);
		}
    }

    function disable_redirect_mod()
    {
    	$error = 0;
    	$reason = '';
    	$mod_file = $this->getModFile('doku.php',$error,$reason);

		if($error == 0) {
			//get the joomla path from the file
			jimport('joomla.filesystem.file');
			$file_data = JFile::read($mod_file);
	      	$search = '/\/\/JFUSION REDIRECT START(.*)\/\/JFUSION REDIRECT END/si';
	      	$file_data = preg_replace($search,'',$file_data);
			JFile::write($mod_file, $file_data);
		}
    }

	function outputJavascript(){
?>
<script language="javascript" type="text/javascript">
<!--
function auth_mod(action) {
var form = document.adminForm;
form.customcommand.value = action;
form.action.value = 'apply';
submitform('saveconfig');
return;
}

//-->
</script>
<?php
	}

    function show_redirect_mod($name, $value, $node, $control_name)
    {
    	$error = 0;
    	$reason = '';
    	$mod_file = $this->getModFile('doku.php',$error,$reason);

		if($error == 0) {
			//get the joomla path from the file
			jimport('joomla.filesystem.file');
			$file_data = JFile::read($mod_file);
	      	preg_match_all('/\/\/JFUSION REDIRECT START(.*)\/\/JFUSION REDIRECT END/ms',$file_data,$matches);

			//compare it with our joomla path
			if(empty($matches[1][0])){
	        	$error = 1;
	        	$reason = JText::_('MOD_NOT_ENABLED');
			}
		}

		//add the javascript to enable buttons
		$this->outputJavascript();

		if ($error == 0){
			//return success
			$output = '<img src="components/com_jfusion/images/check_good.png" height="20px" width="20px">' . JText::_('REDIRECTION_MOD') . ' ' . JText::_('ENABLED');
			$output .= ' <a href="javascript:void(0);" onclick="return auth_mod(\'disable_redirect_mod\')">' . JText::_('MOD_DISABLE') . '</a>';
			$output .= ' <a href="javascript:void(0);" onclick="return auth_mod(\'enable_redirect_mod\')">' . JText::_('MOD_UPDATE') . '</a>';
			return $output;
		} else {
       		$output = '<img src="components/com_jfusion/images/check_bad.png" height="20px" width="20px">' . JText::_('REDIRECTION_MOD') . ' ' . JText::_('DISABLED') .': ' . $reason;
			$output .= ' <a href="javascript:void(0);" onclick="return auth_mod(\'enable_redirect_mod\')">' . JText::_('MOD_ENABLE') . '</a>';
			return $output;
		}
    }

    function usergroup($name, $value, $node, $control_name)
    {
    	$jname = $this->getJname();

		//get the master plugin to be throughout
    	$master = JFusionFunction::getMaster();

    	$advanced = 0;
		//detect is value is a serialized array
		if(substr($value, 0, 2) == 'a:'){
			$value = unserialize($value);
			//use advanced only if this plugin is not set as master
			if($master->name!=$this->getJname()) {
				$advanced = 1;
			}
		}

		if(JFusionFunction::validPlugin($this->getJname())) {
            $usergroups = $this->getUsergroupList();

			foreach($usergroups as $group) $g[] = $group->name;
			$comma_separated = implode(",", $g);

			$simple_value = $value;
            if ( is_array($simple_value)) $simple_value = $comma_separated;

            if (!empty($usergroups)) {
             	$simple_usergroup  = "<table style=\"width:100%; border:0\">";
				$simple_usergroup .= '<tr><td>'.JText::_('DEFAULT_USERGROUP') . '</td><td><input type="text" name="'.$control_name.'['.$name.']" value="'.$simple_value.'" class="inputbox" /></td></tr>';
               	$simple_usergroup .= "</table>";
            } else {
                $simple_usergroup = '';
            }
        } else {
			return JText::_('SAVE_CONFIG_FIRST');
        }


		//check to see if current plugin is a slave
		$db = & JFactory::getDBO();
		$query = 'SELECT slave FROM #__jfusion WHERE name = ' . $db->Quote($jname);
		$db->setQuery($query);
		$slave = $db->loadResult();

	    $list_box = '<select onchange="usergroupSelect(this.selectedIndex);">';
		if($advanced == 1){
			$list_box .= '<option value="0" selected="selected">Simple</option>';
		} else {
			$list_box .= '<option value="0">Simple</option>';
		}

		if ($slave == 1){
        	//allow usergroup sync
			if($advanced == 1){
				$list_box .= '<option selected="selected" value="1">Avanced</option>';
			} else {
				$list_box .= '<option value="1">Avanced</option>';
			}

			//prepare the advanced options
			$JFusionMaster = JFusionFactory::getAdmin($master->name);
            $master_usergroups = $JFusionMaster->getUsergroupList();

			$advanced_usergroup = "<table class=\"usergroups\">";

			if($advanced == 1){
	           	foreach ($master_usergroups as $master_usergroup){
	           		$advanced_usergroup .= "<tr><td>".$master_usergroup->name . '</td>';
					$advanced_usergroup .= '<td><input type="text" name="'.$control_name.'['.$name.']['.$master_usergroup->id.']" value="'.$value[$master_usergroup->id].'" class="inputbox" /></td></tr>';
            	}
			} else {
            	foreach ($master_usergroups as $master_usergroup){
            		$advanced_usergroup .= "<tr><td>".$master_usergroup->name . '</td>';
					$advanced_usergroup .= '<td><input type="text" name="'.$control_name.'['.$name.']['.$master_usergroup->id.']" value="'.$comma_separated.'" class="inputbox" /></td></tr>';
            	}
			}
			$advanced_usergroup .= "</table>";
		} else {
			$advanced_usergroup = '';
		}

		$list_box .= '</select>';

    	?><script Language="JavaScript">
function usergroupSelect(option)
{
var myArray = new Array();
myArray[0] = '<?php echo $simple_usergroup;?>';
myArray[1] = '<?php echo $advanced_usergroup;?>';
	document.getElementById("JFusionUsergroup").innerHTML = myArray[option];
}
</script>
    	<?php

		if($advanced == 1){
			return JText::_('USERGROUP'). ' '. JText::_('MODE'). ': '.$list_box . '<br/><div id="JFusionUsergroup">'. $advanced_usergroup. '</div>';
		} else {
			return JText::_('USERGROUP'). ' '. JText::_('MODE'). ': '.$list_box . '<br/><div id="JFusionUsergroup">'. $simple_usergroup. '</div>';
		}
    }
}
