<?php

/**
 * @package JFusion
 * @subpackage Models
 * @author JFusion development team
 * @copyright Copyright (C) 2008 JFusion. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */

// no direct access
defined('_JEXEC' ) or die('Restricted access' );

/**
 * load the JFusion framework
 */
require_once(JPATH_ADMINISTRATOR .DS.'components'.DS.'com_jfusion'.DS.'models'.DS.'model.jfusion.php');
require_once(JPATH_ADMINISTRATOR .DS.'components'.DS.'com_jfusion'.DS.'models'.DS.'model.curl.php');


/**
* Common Class for Joomla JFusion plugins
* @package JFusion
*/
class JFusionJplugin {

  function generateEncryptedPassword($userinfo)
  {
    jimport('joomla.user.helper');
    $crypt = JUserHelper::getCryptedPassword($userinfo->password_clear, $userinfo->password_salt);
    return $crypt;
  }

  function getTablename(){
    return 'users';
  }

  function getRegistrationURL(){
    return 'index.php?option=com_user&task=register';
  }

  function getLostPasswordURL(){
    return 'index.php?option=com_user&view=reset';
  }

  function getLostUsernameURL(){
    return 'index.php?option=com_user&view=remind';
  }

  function getUserList($jname)
  {
    $db = & JFusionFactory::getDatabase($jname);
    $query = 'SELECT username, email from #__users';
    $db->setQuery($query );
    $userlist = $db->loadObjectList();
    return $userlist;
  }

  function getUserCount($jname)
  {
    $db = & JFusionFactory::getDatabase($jname);
    $query = 'SELECT count(*) from #__users';
    $db->setQuery($query );

    //getting the results
    return $db->loadResult();
  }

  function getUsergroupList($jname)
  {
    $db = & JFusionFactory::getDatabase($jname);
    $query = 'SELECT id, name FROM #__core_acl_aro_groups WHERE name != "ROOT" AND name != "USERS"';
    $db->setQuery($query );

    //getting the results
    return $db->loadObjectList();
  }

  function getDefaultUsergroup($jname)
  {
    $params = JFusionFactory::getParams($jname);
    $db = & JFusionFactory::getDatabase($jname);
    $usergroup_id = $params->get('usergroup', 18);
    if(substr($usergroup_id, 0, 2) == 'a:'){
      return JText::_('ADVANCED_GROUP_MODE');
    } else {
      //we want to output the usergroup name
      $query = 'SELECT name from #__core_acl_aro_groups WHERE id = ' . $usergroup_id;
      $db->setQuery($query );
      return $db->loadResult();
    }
  }

  function allowRegistration($jname)
  {
    $db = & JFusionFactory::getDatabase($jname);
    $query = 'SELECT params FROM #__components WHERE `option` = \'com_users\'';
    $db->setQuery($query );
    $registry = new JRegistry();
    $registry->loadINI($db->loadResult());
    $params = $registry->toObject();

    if ($params->allowUserRegistration) {
      $result = true;
      return $result;
    } else {
      $result = false;
      return $result;
    }
  }

  function setupFromPath($path)
  {
    //check for trailing slash and generate file path
    if (substr($path, -1) == DS) {
      $configfile = $path . 'configuration.php';
    } else {
      $configfile = $path . DS. 'configuration.php';
    }

    if (($file_handle = @fopen($configfile, 'r')) === FALSE) {
      JError::raiseWarning(500,JText::_('WIZARD_FAILURE'). ": $myfile " . JText::_('WIZARD_MANUAL'));
      $result = false;
      return $result;
    } else {
      //parse the file line by line to get only the config variables
      //we can not directly include the config file as JConfig is already defined
      $file_handle = fopen($configfile, 'r');
      while (!feof($file_handle)) {
        $line = fgets($file_handle);
        if (strpos($line, '$')) {
          //extract the name and value, it was coded to avoid the use of eval() function
          $vars = split ("'", $line);
          $names = split ('var', $vars[0] );
          if(isset($vars[1]) && isset($names[1])){
            $name = trim($names[1], ' $=');
            $value = trim($vars[1], ' $=');
            $config[$name] = $value;
          }
        }
      }
      fclose($file_handle);
      //Save the parameters into the standard JFusion params format
      $params = array();
      $params['database_host'] = $config['host'];
      $params['database_name'] = $config['db'];
      $params['database_user'] = $config['user'];
      $params['database_password'] = $config['password'];
      $params['database_prefix'] = $config['dbprefix'];
      $params['database_type'] = $config['dbtype'];
      $params['source_path'] = $path;
      return $params;
    }
  }


  /**
   * Common code for user.php
   */

  function createSession($userinfo, $options,$jname)
  {
    global $ch;
    global $cookiearr;
    global $cookies_to_set;
    global $cookies_to_set_index;
    $cookiearr = array();
    $cookies_to_set = array();
    $cookies = array();
    $cookie= array();
    $curl_options = array();
    $status = array();
    $status['error'] = '';
    $status['debug'] = '';
    $cookies_to_set_index = 0;
    $params = JFusionFactory::getParams($jname);
    $source_url = $params->get('source_url');
    $login_url = $params->get('login_url');

    #prevent usererror by not supplying trailing forwardslash
    if (substr($source_url,-1) != "/") {
      $source_url = $source_url."/";
    }
    #prevent usererror by preventing a heading forwardslash
    ltrim($login_url,'/');

    $curl_options['post_url']  = $source_url.$login_url;
    $curl_options['formid']  = $params->get('loginform_id');
    $curl_options['username']  = $userinfo->username;
    $curl_options['password']  = $userinfo->password_clear;
    $curl_options['integrationtype']= $params->get('integrationtype');
    $curl_options['relpath']  = $params->get('relpath');
    $curl_options['hidden']  = $params->get('hidden');
    $curl_options['buttons']  = $params->get('buttons');
    $curl_options['override']  = $params->get('override');
    $curl_options['cookiedomain'] = $params->get('cookie_domain');
    $curl_options['cookiepath'] = $params->get('cookie_path');
    $curl_options['expires']  = $params->get('cookie_expires');
    $curl_options['input_username_id']= $params->get('input_username_id');
    $curl_options['input_password_id']= $params->get('input_password_id');
    $curl_options['secure']  = $params->get('secure');
    $curl_options['httponly']  = $params->get('httponly');
    $curl_options['verifyhost'] = 0;//$params->get('ssl_verifyhost');
    $status=JFusionCurl::RemoteLogin($curl_options);
    return $status;
  }

  function destroySession($userinfo, $options,$jname)
  {
    global $ch;
    global $cookiearr;
    global $cookies_to_set;
    global $cookies_to_set_index;
    $cookiearr = array();
    $cookies_to_set = array();
    $cookies = array();
    $cookie= array();
    $curl_options = array();
    $status = array();
    $status['error'] = '';
    $status['debug'] = '';
    $cookies_to_set_index = 0;

    $params = JFusionFactory::getParams($jname);
    $curl_options['post_url']= $params->get('source_url').$params->get('logout_url');
    $curl_options['cookiedomain']= $params->get('cookie_domain');
    $curl_options['cookiepath']= $params->get('cookie_path');
    $curl_options['leavealone']= $params->get('leavealone');
    $curl_options['secure']= $params->get('secure');
    $curl_options['httponly']= $params->get('httponly');
    $curl_options['verifyhost']= 0;//$params->get('ssl_verifyhost');
    $status = JFusionCurl::RemoteLogout($curl_options);
    return $status;
   }

  function getUser($userinfo, $jname)
  {
    $db = & JFusionFactory::getDatabase($jname);

    $JFusionUser = JFusionFactory::getUser($jname);
    list($identifier_type,$identifier) = $JFusionUser->getUserIdentifier($userinfo,'username','email');

    if ($jname == 'joomla_int' && $identifier_type=='username') {
		//first check the JFusion user table if the identifier_type = username
		$db->setQuery('SELECT b.id as userid, b.activation, a.username, b.name, b.password, b.email, b.block, b.usertype as group_name, b.gid as group_id, b.params FROM #__users as b INNER JOIN #__jfusion_users as a ON a.id = b.id WHERE a.username = ' . $db->Quote($identifier));
		$result = $db->loadObject();
				
		if (!$result) {
			//check directly in the joomla user table
			$db->setQuery('SELECT id as userid, activation, username, name, password, email, block, usertype as group_name, gid as group_id, params FROM #__users WHERE username = ' .$db->Quote($identifier));
			$result = $db->loadObject();
					
			if($result){
				//update the lookup table so that we don't have to do a double query next time
	           $query = 'REPLACE INTO #__jfusion_users (id, username) VALUES (' . $result->userid . ', ' . $db->Quote($identifier) . ')';
	           $db->setQuery($query);
	           if (!$db->query()) {
	                JError::raiseWarning(0,$db->stderr());
	           }  				
			}
		}
    } else {
      $db->setQuery('SELECT id as userid, activation, username, name, password, email, block, usertype as group_name, gid as group_id FROM #__users WHERE ' . $identifier_type . ' = ' .$db->Quote($identifier));
      $result = $db->loadObject();
    }

    if ($result) {
      //split up the password if it contains a salt
       //note we cannot use explode as a salt from another software may contain a colon which messes Joomla up
      if (strpos($result->password,':')!==false) {
        $saltStart = strpos($result->password,':');
        $result->password_salt = substr($result->password,$saltStart+1);
        $result->password = substr($result->password,0,$saltStart);
      }

      // Get the language of the user and store it as variable in the user object
	  // @todo - to implement after the RC 1.1.2
	  $user_params = new JParameter($result->params);
	  $JLang = JFactory::getLanguage();
	  $result->language = $user_params->get('language', $JLang->_lang);
	  unset($JLang);
			
      //unset the activation status if not blocked
      if($result->block == 0){
        $result->activation = '';
      }

      //unset the block if user is inactive
      if(!empty($result->block) && !empty($result->activation)){
        $result->block = 0;
      }
    }

    return $result;
  }

  function updateEmail($userinfo, &$existinguser, &$status,$jname)
  {
    $db = & JFusionFactory::getDatabase($jname);
    $query = 'UPDATE #__users SET email ='.$db->Quote($userinfo->email) .' WHERE id =' . $existinguser->userid;
    $db->setQuery($query);
    if (!$db->query()) {
      $status['error'][] = JText::_('EMAIL_UPDATE_ERROR') . $db->stderr();
    } else {
      $status['debug'][] = JText::_('EMAIL_UPDATE'). ': ' . $existinguser->email . ' -> ' . $userinfo->email;
    }
  }

  function updatePassword($userinfo, &$existinguser, &$status,$jname)
  {
    $db = & JFusionFactory::getDatabase($jname);
    if (!$userinfo->password_salt){$userinfo->password_salt= JUserHelper::genRandomPassword(32);}
    $userinfo->password = JUserHelper::getCryptedPassword($userinfo->password_clear, $userinfo->password_salt);
    $new_password = $userinfo->password . ':' . $userinfo->password_salt;
    $query = 'UPDATE #__users SET password =' . $db->Quote($new_password) . ' WHERE id =' . $existinguser->userid;
    $db->setQuery($query);
    if (!$db->query()) {
      $status['error'][] = JText::_('PASSWORD_UPDATE_ERROR'). $db->stderr();
    } else {
      $status['debug'][] = JText::_('PASSWORD_UPDATE') . ' ' . substr($existinguser->password,0,6) . '********';
    }
  }

  function blockUser($userinfo, &$existinguser, &$status,$jname)
  {
    //block the user
    $db = & JFusionFactory::getDatabase($jname);
    $query = 'UPDATE #__users SET block = 1 WHERE id =' . $existinguser->userid;
    if (!$db->query()) {
      $status['error'][] = JText::_('BLOCK_UPDATE_ERROR') . $db->stderr();
    } else {
      $status['debug'][] = JText::_('BLOCK_UPDATE'). ': ' . $existinguser->block . ' -> ' . $userinfo->block;
    }
  }

  function unblockUser($userinfo, &$existinguser, &$status,$jname)
  {
    //unblock the user
    $db = & JFusionFactory::getDatabase($jname);
    $query = 'UPDATE #__users SET block = 0 WHERE id =' . $existinguser->userid;
    $db->setQuery($query);
    $db->query();
    if (!$db->query()) {
      $status['error'][] = JText::_('BLOCK_UPDATE_ERROR') . $db->stderr();
    } else {
      $status['debug'][] = JText::_('BLOCK_UPDATE'). ': ' . $existinguser->block . ' -> ' . $userinfo->block;
    }
  }

  function activateUser($userinfo, &$existinguser, &$status,$jname)
  {
    //unblock the user
    $db = & JFusionFactory::getDatabase($jname);
    $query = 'UPDATE #__users SET block = 0, activation = \'\' WHERE id =' . $existinguser->userid;
    $db->setQuery($query);
    if (!$db->query()) {
      $status['error'][] = JText::_('ACTIVATION_UPDATE_ERROR') . $db->stderr();
    } else {
      $status['debug'][] = JText::_('ACTIVATION_UPDATE'). ': ' . $existinguser->activation . ' -> ' . $userinfo->activation;
    }
  }

  function inactivateUser($userinfo, &$existinguser, &$status,$jname)
  {
    //unblock the user
    $db = & JFusionFactory::getDatabase($jname);
    $query = 'UPDATE #__users SET block = 1, activation = '.$db->Quote($userinfo->activation) .' WHERE id =' . $existinguser->userid;
    $db->setQuery($query);
    $db->query();
    if (!$db->query()) {
      $status['error'][] = JText::_('ACTIVATION_UPDATE_ERROR') . $db->stderr();
    } else {
      $status['debug'][] = JText::_('ACTIVATION_UPDATE'). ': ' . $existinguser->activation . ' -> ' . $userinfo->activation;
    }
  }

  function filterUsername($username,$jname)
  {
    //check to see if additional username filtering need to be applied
    $params = JFusionFactory::getParams($jname);
    $added_filter = $params->get('username_filter');
    if ($added_filter && $added_filter != $jname) {
      $JFusionPlugin = JFusionFactory::getUser($added_filter);
      if(method_exists($JFusionPlugin, 'filterUsername')){
        $filteredUsername = $JFusionPlugin->filterUsername($username);
      }
    }
    
    //make sure the filtered username isn't empty
    $username = (!empty($filteredUsername)) ? $filteredUsername : $username;
    
    //define which characters which Joomla forbids in usernames
    $trans = array('&#60;' => '_', '&lt;' => '_', '&#62;' => '_', '&gt;' => '_', '&#34;' => '_', '&quot;' => '_', '&#39;' => '_', '&#37;' => '_', '&#59;' => '_', '&#40;' => '_', '&#41;' => '_', '&amp;' => '_', '&#38;' => '_', '<' => '_', '>' => '_', '"' => '_', '\'' => '_', '%' => '_', ';' => '_', '(' => '_', ')' => '_', '&' => '_');

    //remove forbidden characters for the username
    $username = strtr($username, $trans);

    //make sure the username is at least 3 characters long
    while (strlen($username) < 3) {
      $username .= '_';
    }
    
    return $username;
  }

  function updateUsername($userinfo, &$existinguser, &$status, $jname)
  {
    //generate the filtered integration username
    $db = & JFusionFactory::getDatabase($jname);

    $username_clean = JFusionJplugin::filterUsername($userinfo->username, $jname);
    $status['debug'][] = JText::_('USERNAME'). ': ' . $userinfo->username . ' -> ' .JText::_('FILTERED_USERNAME') . ':' . $username_clean;

    $query = 'UPDATE #__users SET username =' . $db->Quote($username_clean) . 'WHERE id =' . $existinguser->userid;
    $db->setQuery($query);
    if (!$db->query()) {
      //update failed, return error
      $status['error'][] = JText::_('USERNAME_UPDATE_ERROR'). ': ' . $db->stderr();
    } else {
      $status['debug'][] = JText::_('USERNAME_UPDATE') .': ' . $username_clean;
    }
    
    if($jname=='joomla_int') {
	    //update the lookup table
		$query = 'REPLACE INTO #__jfusion_users (id, username) VALUES (' . $existinguser->userid . ', ' . $db->Quote($userinfo->username) . ')';
		$db->setQuery($query);
		if (!$db->query()) {
			$status['error'][] = JText::_('USERNAME_UPDATE_ERROR'). ': ' . $db->stderr();
		} else {
			$status['debug'][] = JText::_('USERNAME_UPDATE') .': ' . $username_clean;
		}
    }
  }

  function createUser($userinfo, $overwrite, &$status,$jname)
  {
    $params = JFusionFactory::getParams($jname);

    //get the default user group and determine if we are using simple or advanced
    $usergroups = (substr($params->get('usergroup'), 0, 2) == 'a:') ? unserialize($params->get('usergroup')) : $params->get('usergroup',18);
    //check to make sure that if using the advanced group mode, $userinfo->group_id exists
    if(is_array($usergroups) && !isset($userinfo->group_id)) {
      $status['error'][] = JText::_('GROUP_UPDATE_ERROR'). ": " . JText::_('ADVANCED_GROUPMODE_MASTER_NOT_HAVE_GROUPID');
      return null;
    }

    //load the database
    $db = & JFusionFactory::getDatabase($jname);
    //joomla does not allow duplicate email addresses, check to see if the email is unique
    $query = 'SELECT id as userid, username, email from #__users WHERE email ='.$db->Quote($userinfo->email);
    $db->setQuery($query);
    $existinguser = $db->loadObject();

    if (empty($existinguser)) {
      //apply username filtering
      $username_clean = JFusionJplugin::filterUsername($userinfo->username, $jname);

      //now we need to make sure the username is unique in Joomla
      $db->setQuery('SELECT id FROM #__users WHERE username='.$db->Quote($username_clean));
      while ($db->loadResult()) {
        $username_clean .= '_';
        $db->setQuery('SELECT id FROM #__users WHERE username='.$db->Quote($username_clean));
      }
      $status['debug'][] = JText::_('USERNAME') .':'. $userinfo->username . ' ' . JText::_('FILTERED_USERNAME') .':'. $username_clean;

      //also store the salt if present
      if ($userinfo->password_salt) {
        $password = $userinfo->password . ':' . $userinfo->password_salt;
      } else {
        $password = $userinfo->password;
      }

      $instance = new JUser();
      $instance->set('name' , $userinfo->name );
      $instance->set('username' , $username_clean );
      $instance->set('password' , $password);
      $instance->set('email', $userinfo->email );
      $instance->set('block', $userinfo->block );
      $instance->set('activation' , $userinfo->activation );
      $instance->set('sendEmail' , 1 );

      //find out what usergroup the new user should have
      if(isset($userinfo->group_id)) {
        $gid = (is_array($usergroups)) ? $usergroups[$userinfo->group_id] : $usergroups;
        $isadmin = ($gid==24 || $gid==25) ? true : false;
      } else {
        //the $userinfo object was probably reconstructed in the user plugin and autregister = 1
        $gid = 18;
        $isadmin = false;
      }
      
      //work around the issue where joomla will not allow the creation of an admin or super admin if the logged in user is not a super admin
      if($isadmin) {
      	$gid = 18;
      }
      
      $query = 'SELECT name FROM #__core_acl_aro_groups WHERE id = ' . $gid;
      $db->setQuery($query);
      $usergroup = $db->loadResult();

      $instance->set('usertype' , $usergroup );
      $instance->set('gid', $gid );

      if ($jname == 'joomla_int'){
		
      	//store the username passed into this to prevent the user plugin from attempting to recreate users
      	$instance->set('original_username', $userinfo->username);
      	
        // save the user
        if (!$instance->save(false)) {
          //report the error
          $status = array();
          $status['error'] = $instance->getError();
          return $status;
        } else {
        	$createdUser = $instance->getProperties();
			$createdUser = (object) $createdUser;
			
        	//update the user's group to the correct group if they are an admin
        	if($isadmin) {
				$createdUser->userid = $createdUser->id;
				JFusionJplugin::updateUsergroup($userinfo, $createdUser, $status, $jname, false);
        	}
        	
        	//create a new entry in the lookup table
        	//if the credentialed username is available (from the auth plugin), store it; otherwise store the $userinfo's username
           $username = (!empty($userinfo->credentialed_username)) ? $userinfo->credentialed_username : $userinfo->username;
           $query = 'REPLACE INTO #__jfusion_users (id, username) VALUES (' . $createdUser->id . ', ' . $db->Quote($username) . ')';
           $db->setQuery($query);
           if (!$db->query()) {
                JError::raiseWarning(0,$db->stderr());
           }          
        }
      } else {
      	// joomla_ext
        // convert the Joomla userobject to a std object
        $user=$instance->getProperties();
        // get rid of internal properties
        unset ($user['password_clear']);
        unset ($user['aid']);
        unset ($user['guest']);
        // set the creationtime and lastaccess time
        $user['registerDate'] = date('Y-m-d H:i:s', time());
        $user= (object) $user;
        $user->id = NULL;
        if (!$db->insertObject('#__users', $user, 'id' )) {
          //return the error
          $status['error'][] = JText::_('USER_CREATION_ERROR') . $db->stderr();
          return;
        }
        //find out the new userid
        $query = 'SELECT id FROM #__users WHERE username =' . $db->Quote($username_clean);
        $db->setQuery($query);
        $userid = $db->loadResult();
        //add the user to the core_acl_aro
        $acl = array();
        $acl['section_value']='users';
        $acl['value']=$userid;
        $acl['order_value']=0;
        $acl['name']=$userinfo->name;
        $acl['hidden']=0;
        $acl= (object) $acl;
        $acl->id = NULL;
        if (!$db->insertObject('#__core_acl_aro', $acl, 'id' )) {
          //return the error
          $status['error'][] = JText::_('USER_CREATION_ERROR') . $db->stderr();
          return;
        }
        // find out the new aro id
        $aro_id = $db->insertid();
        // and finally add the user to the core_acl_groups_aro_map
        $query = 'INSERT INTO #__core_acl_groups_aro_map (group_id, aro_id) VALUES (' . $gid . ',' . $aro_id . ')';
        $db->setQuery($query);
        if (!$db->query()) {
          $status['error'][] = JText::_('USER_CREATION_ERROR') . $db->stderr();
        }
      }

      //check to see if the user exists now
      $joomla_user = JFusionJplugin::getUser($userinfo,$jname);

      if ($joomla_user) {
        //report back success
        $status['userinfo'] = $joomla_user;
        $status['debug'][] = JText::_('USER_CREATION');
        return;
      } else {
        $status['error'] = JText::_('COULD_NOT_CREATE_USER');
        return;
      }
    } else {
      //Joomla does not allow duplicate emails report error
      $status['debug'][] = JText::_('USERNAME') . ' ' . JText::_('CONFLICT').': ' . $existinguser->username . ' -> ' . $userinfo->username;
      if ($overwrite) {
        $status['debug'][] = JText::_('USERNAME_CONFLICT_OVERWITE_ENABLED');
        JFusionJplugin::updateUsername($userinfo, $existinguser, $status, $jname);
      } else {
        $status['debug'][] = JText::_('USERNAME_CONFLICT_OVERWITE_DISABLED');
        $status['error'] = JText::_('EMAIL_CONFLICT') . '. UserID: ' . $existinguser->userid . ' JFusionPlugin: ' . $jname;
      }

      $status['userinfo'] = $existinguser;
      return;
    }
  }

  function updateUser($userinfo, $overwrite,$jname){
    // Initialise some variables
    $params = JFusionFactory::getParams($jname);
    $db = & JFusionFactory::getDatabase($jname);
    $update_block = $params->get('update_block');
    $update_activation = $params->get('update_activation');
    $update_email = $params->get('update_email');
    $usergroup = $params->get('usergroup');
    $status = array();
    $status['debug'] = array();
    $status['error'] = array();

    //check to see if a valid $userinfo object was passed on
    if(!is_object($userinfo)){
      $status['error'][] = JText::_('NO_USER_DATA_FOUND');
      return $status;
    }

    //check to see if user exists
    $existinguser = JFusionJplugin::getUser($userinfo,$jname);

    if (!empty($existinguser)) {
      $changed = false;
      //a matching user has been found
      $status['debug'][] = JText::_('USER_DATA_FOUND');

      // email update?
      if (strtolower($existinguser->email) != strtolower($userinfo->email)) {
        $status['debug'][] = JText::_('EMAIL_CONFLICT');
        if ($update_email || $overwrite) {
          $status['debug'][] = JText::_('EMAIL_CONFLICT_OVERWITE_ENABLED');
          JFusionJplugin::updateEmail($userinfo, $existinguser, $status, $jname);
          $changed = true;
        } else {
          //return a email conflict
          $status['debug'][] = JText::_('EMAIL_CONFLICT_OVERWITE_DISABLED');
          $status['error'][] = JText::_('EMAIL') . ' ' . JText::_('CONFLICT').': ' . $existinguser->email . ' -> ' . $userinfo->email;
          $status['userinfo'] = $existinguser;
          return $status;
        }
      }

      // password update ?
      if (!empty($userinfo->password_clear) && strlen($userinfo->password_clear) != 32){
        //if not salt set, update the password
        $existinguser->password_clear = $userinfo->password_clear;
        //check if the password needs to be updated
        $model = JFusionFactory::getAuth($jname);
        $testcrypt = $model->generateEncryptedPassword($existinguser);
        if ($testcrypt != $existinguser->password) {
          JFusionJplugin::updatePassword($userinfo, $existinguser, $status,$jname);
        $changed = true;
        } else {
            $status['debug'][] = JText::_('SKIPPED_PASSWORD_UPDATE') . ': ' .JText::_('PASSWORD_VALID');
        }
      } else {
        $status['debug'][] = JText::_('SKIPPED_PASSWORD_UPDATE') . ': ' . JText::_('PASSWORD_UNAVAILABLE');
      }



      //block status update?
      if ($existinguser->block != $userinfo->block) {
        if ($update_block || $overwrite) {
          if ($userinfo->block) {
            //block the user
            JFusionJplugin::blockUser($userinfo, $existinguser, $status,$jname);
            $changed = true;
          } else {
            //unblock the user
            JFusionJplugin::unblockUser($userinfo, $existinguser, $status,$jname);
            $changed = true;
          }
        } else {
          //return a debug to inform we skiped this step
          $status['debug'][] = JText::_('SKIPPED_BLOCK_UPDATE') . ': ' . $existinguser->block . ' -> ' . $userinfo->block;
        }
        $status['debug'][] = JText::_('SKIPPED_BLOCK_UPDATE') . ': ' . $existinguser->block . ' -> ' . $userinfo->block;
      }

      //activation status update?
      if ($existinguser->activation != $userinfo->activation) {
        if ($update_activation || $overwrite) {
          if ($userinfo->activation) {
            //inactiva the user
            JFusionJplugin::inactivateUser($userinfo, $existinguser, $status,$jname);
            $changed = true;
          } else {
            //activate the user
            JFusionJplugin::activateUser($userinfo, $existinguser, $status,$jname);
            $changed = true;
          }
        } else {
          //return a debug to inform we skiped this step
          $status['debug'][] = JText::_('SKIPPED_EMAIL_UPDATE') . ': ' . $existinguser->email . ' -> ' . $userinfo->email;
        }
          $status['debug'][] = JText::_('SKIPPED_EMAIL_UPDATE') . ': ' . $existinguser->email . ' -> ' . $userinfo->email;
      }

      //check for advanced usergroup sync
      $master = JFusionFunction::getMaster();
      if(!$userinfo->block && empty($userinfo->activation) && substr($usergroup, 0, 2) == 'a:' && $master->name != $jname){
        $usergroup = unserialize($usergroup);
        //find what the usergroup should be
        $correct_usergroup = $usergroup[$userinfo->group_id];

        //Is there other information stored in the usergroup?
        if(is_array($correct_usergroup)) {
          //use the first var in the array
          $keys = array_keys($correct_usergroup);
          $correct_usergroup = $correct_usergroup[$keys[0]];
        }

        if($correct_usergroup != $existinguser->group_id){
          JFusionJplugin::updateUsergroup($userinfo, $existinguser, $status, $jname);
                  $changed = true;
        } else {
          $status['debug'][] = JText::_('SKIPPED_GROUP_UPDATE') . ':' .  JText::_('GROUP_VALID');
        }
      }
				
      // @todo - Update the user language with the current used in Joomla - To implement after the RC 1.1.2
      $JLang = JFactory::getLanguage ();
      if (empty ( $userinfo->language ) || $overwrite) $userinfo->language = $JLang->_lang;
      if ($userinfo->language != $existinguser->language) {
      	$this->updateUserLanguage ( $userinfo, $existinguser, $status, $jname );
      }
      else {
		//return a debug to inform we skiped this step
		$status ['debug'] [] = JText::_ ( 'LANGUAGE_NOT_UPDATED' ) . ': ' . $existinguser->email . ' '. $existinguser->language . ' -> ' . $userinfo->language;
      }
			
      if (empty($status['error'])) {
        if($changed == true){
          $status['action'] = 'updated';
          $status['userinfo'] = JFusionJplugin::getUser($userinfo,$jname);
        } else {
          $status['action'] = 'unchanged';
			$status['userinfo'] = $existinguser;
        }
      }
      return $status;
    } else {
      $status['debug'][] = JText::_('NO_USER_FOUND_CREATING_ONE');
      JFusionJplugin::createUser($userinfo, $overwrite, $status, $jname);
      if (empty($status['error'])) {
        $status['action'] = 'created';
      }
      return $status;
    }
  }

  function updateUsergroup($userinfo, &$existinguser, &$status, $jname, $fire_user_plugins = true)
  {
    //check to see if we have a group_id in the $userinfo, if not return
    if(!isset($userinfo->group_id)) {
      $status['error'][] = JText::_('GROUP_UPDATE_ERROR'). ": " . JText::_('ADVANCED_GROUPMODE_MASTER_NOT_HAVE_GROUPID');
      return null;
    }

    $db =& JFusionFactory::getDatabase($jname);
    $params = JFusionFactory::getParams($jname);
    $usergroups = unserialize($params->get('usergroup'));

    //make sure the group exists
    if(isset($usergroups[$userinfo->group_id])) {
      //find out what usergroup the new user should have
      $gid = $usergroups[$userinfo->group_id];
      $query = 'SELECT name FROM #__core_acl_aro_groups WHERE id = ' . $gid;
      $db->setQuery($query);
      $usertype = $db->loadResult();

      if(!empty($gid) && !empty($usertype)) {
      	//Fire the user plugin functions for joomla_int
      	if($jname=="joomla_int" && $fire_user_plugins) {
      		// Get the old user
			$old = new JUser($existinguser->userid);

			// Fire the onBeforeStoreUser event.
			JPluginHelper::importPlugin( 'user' );
			$dispatcher =& JDispatcher::getInstance();
			$dispatcher->trigger( 'onBeforeStoreUser', array( $old->getProperties(), false ) );      		
      	}
      	
      	
          //update the user table
          $query = "UPDATE #__users SET usertype = {$db->Quote($usertype)}, gid = {$gid}  WHERE id = {$existinguser->userid}";
          $db->setQuery($query);
          if(!$db->query()) {
            $status['error'][] = JText::_('GROUP_UPDATE_ERROR') . ': ' . $db->stderr();
          } else {
            //we have to update the acl table
            $query = "SELECT id FROM #__core_acl_aro WHERE value = " . $existinguser->userid;
            $db->setQuery($query);
            $aro_id = $db->loadResult();

            if(!empty($aro_id)) {
              $query = "UPDATE #__core_acl_groups_aro_map SET group_id = {$gid} WHERE aro_id = {$aro_id}";
              $db->setQuery($query);
              if(!$db->query()) {
                $status['error'][] = JText::_('GROUP_UPDATE_ERROR') . ': ' . $db->stderr();

                //update to acl table failed, attempt to revert changes to user table
                $query = "UPDATE #__users SET usertype = {$db->Quote($existinguser->group_name)}, gid = {$existinguser->group_id} WHERE id = {$existinguser->userid}";
                $db->setQuery($query);
                if(!$db->query()) {
                  $status['error'][] = JText::_('GROUP_UPDATE_ERROR') . ': ' . $db->stderr();
                }
              } else {
                $status['debug'][] = JText::_('GROUP_UPDATE'). ': ' . $existinguser->group_id . ' -> ' . $usergroups[$userinfo->group_id]; 
                
                //Fire the user plugin functions for joomla_int
                if($jname=='joomla_int' && $fire_user_plugins) {
					// Fire the onAftereStoreUser event
					$updated = new JUser($existinguser->userid);
					$dispatcher->trigger( 'onAfterStoreUser', array( $updated->getProperties(), false, true, '' ) );
                }
              }
            } else {
              $status['error'][] = JText::_('GROUP_UPDATE_ERROR') . ': ' . $db->stderr();
            }
         }
      }
    } else {
       $status['error'][] = JText::_('GROUP_UPDATE_ERROR') . ': ' . JText::_('ADVANCED_GROUPMODE_MASTERGROUP_NOTEXIST');
    }
  }

  /************************************************
   * Functions For JFusion Who's Online Module
   ***********************************************/

  function getOnlineUserQuery($limit)
  {
  	$limiter = (!empty($limit)) ? "LIMIT 0,$limit" : ''; 
    $query = 'SELECT DISTINCT u.id AS userid, u.username, u.name, u.email' .
    ' FROM #__users AS u INNER JOIN #__session AS s' .
    ' ON u.id = s.userid' .
    ' WHERE s.client_id = 0' .
    ' AND s.guest = 0 ' . $limiter;
    return $query;
  }

  function getNumberOnlineGuests()
  {
    $db=& JFactory::getDBO();
    $query = 'SELECT COUNT(*)' .
    ' FROM #__session' .
    ' WHERE guest = 1 AND usertype = "" AND client_id = 0';
    $db->setQuery($query);
    return $db->loadResult();
  }

  function getNumberOnlineMembers()
  {
    $db=& JFactory::getDBO();
    $query = 'SELECT COUNT(DISTINCT userid) AS c' .
    ' FROM #__session' .
    ' WHERE guest = 0 AND client_id = 0';
    $db->setQuery($query);

    return $db->loadResult();
  }

	/**
	 * Update the language front end param in the account of the user if this one changes it
	 * NORMALLY THE LANGUAGE SELECTION AND CHANGEMENT FOR JOOMLA IS PROVIDED BY THIRD PARTY LIKE JOOMFISH
	 * 
	 * @todo - to implement after the release 1.1.2
	 *
	 * @param object $userinfo
	 * @return array status
	 */
	function setLanguageFrontEnd($userinfo) {
		$status = array ();
		$status ['error'] = '';
		$status ['debug'] = '';
		
		$jname = $this->getJname ();
		$existinguser = (isset ( $userinfo )) ? JFusionJplugin::getUser ( $userinfo, $jname ) : null;
		
		// If the user is connected we change his account parameter in function of the language front end
		if ($existinguser) {
			
			$JLang = JFactory::getLanguage ();
			$userinfo->language = $JLang->_lang;
			JFusionJplugin::updateUserLanguage ( $userinfo, $existinguser, $status, $jname );
		
		}
		else {
			$status ['debug'] = JText::_ ( "NO_USER_DATA_FOUND" );
		}
		
		return $status;
	}

	/**
	 * Update the language user in his account when he logs in Joomla or
	 * when the language is changed in the frontend
	 *
	 * @see JFusionJplugin::updateUser
	 * @see JFusionPublic::setLanguageFrontEnd 
	 * 
	 * @param object $userinfo
	 * @param object $existinguser
	 * @param array $status
	 * @param string $jname
	 */
	function updateUserLanguage($userinfo, &$existinguser, &$status, $jname) {
		$db = & JFusionFactory::getDatabase ( $jname );
		$params = new JParameter ( $existinguser->params );
		$params->set ( 'language', $userinfo->language );
		
		$query = 'UPDATE #__users SET params =' . $db->Quote ( $params->toString () ) . ' WHERE id =' . $existinguser->userid;
		$db->setQuery ( $query );
		if (! $db->query ()) {
			$status ['error'] [] = JText::_ ( 'LANGUAGE_UPDATE_ERROR' ) . $db->stderr ();
		}
		else {
			$status ['debug'] [] = JText::_ ( 'LANGUAGE_UPDATE' ) . ' ' . $existinguser->language;
		}
	}
}