<?php

/**
 * @package JFusion
 * @subpackage Models
 * @author JFusion development team
 * @copyright Copyright (C) 2008 JFusion. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */

// no direct access
defined('_JEXEC' ) or die('Restricted access' );

/**
* Abstract interface for all JFusion functions that are accessed through the Joomla front-end
* @package JFusion
*/
class JFusionPublic{

    /**
     * returns the name of this JFusion plugin
     * @return string name of current JFusion plugin
     */
    function getJname()
    {
        return '';
    }

    /**
     * gets the visual html output from the plugin
     */
    function getBuffer(&$data)
    {
    }

    /**
     * function that parses the HTML body and fixes up URLs and form actions
     * @param string the HTML body output generated by getBuffer()
     * @param string $baseURL the base joomla URL to add variables to
     * @param string $fullURL the full URL to the current page
     * @param string $integratedURL the URL to the integrated software
     * @return object userinfo Object containing the user information
     */
    function parseBody(&$data)
    {
    }

    /**
     * function that parses the HTML header and fixes up URLs
     * @param string $buffer the output generated by getBuffer()
     * @param string $baseURL the base joomla URL to add variables to
     * @param string $fullURL the full URL to the current page
     * @param string $integratedURL the URL to the integrated software
     * @return object userinfo Object containing the user information
     */
    function parseHeader(&$data)
    {
    }

     /**
     * Returns the registration URL for the integrated software
     * @return string registration URL
     */
    function getRegistrationURL()
    {
        return '';
    }

     /**
     * Returns the lost password URL for the integrated software
     * @return string lost password URL
     */
    function getLostPasswordURL()
    {
        return '';
    }

     /**
     * Returns the lost username URL for the integrated software
     * @return string lost username URL
     */
    function getLostUsernameURL()
    {
        return '';
    }

     /**
     * Returns Array of stdClass title / url
     * @return object Db columns assigned to title and url links for pathway
     */
	function getPathWay()
	{
		$path = new stdClass();
		$path->title = '';
		$path->url = '';
		$pathway[] = $path;
		return null;
	}

	/************************************************
	 * Functions For JFusion Search Plugin
	 ***********************************************/

    /**
     * Retrieves the search results to be displayed.  Placed here so that plugins that do not use the database can retrieve and return results
     * @param $text string text to be searched
     * @param $phrase string how the search should be performed exact, all, or any
     * @param $pluginParam custom plugin parameters in search.xml
     * @param $itemid what menu item to use when creating the URL
     * @return array of results as objects
     * Each result should include:
     * $result->title = title of the post/article
     * $result->section = (optional) section of  the post/article (shows underneath the title; example is Forum Name / Thread Name)
     * $result->text = text body of the post/article
     * $result->href = link to the content (without this, joomla will not display a title)
     * $result->browsernav = 1 opens link in a new window, 2 opens in the same window
     * $result->created = (optional) date when the content was created
     */
	function getSearchResults(&$text, &$phrase, &$pluginParam, $itemid)
	{
		//initialize plugin database
		$db = & JFusionFactory::getDatabase($this->getJname());
		//get the query used to search
		$query = $this->getSearchQuery();

		//assign specific table colums to title and text
		$columns = $this->getSearchQueryColumns();

		//build the query
		if($phrase == 'exact') {
			$where = "(LOWER({$columns->title}) LIKE '%$text%') OR (LOWER({$columns->text}) like '%$text%')";
		} else {
			$words = explode (' ', $text);
			$wheres = array();
			foreach($words as $word) {
				$wheres[] = "(LOWER({$columns->title}) LIKE '%$word%') OR (LOWER({$columns->text}) like '%$word%')";
			}

			if($phrase == 'all') $separator = "AND";
			else $separator = "OR";

			$where = '(' . implode ( ") $separator (", $wheres) . ')';
		}

		//pass the where clause into the plugin in case it wants to add something
		$this->getSearchCriteria($where);

		$query .= " WHERE $where";

		$db->setQuery($query);
		$results = $db->loadObjectList();

		//pass results back to the plugin in case they need to be filtered
		$this->filterSearchResults($results);

		//load the results
		if(is_array($results)) {
			foreach($results as $result) {
				//add a link
				$href = JFusionFunction::routeURL($this->getSearchResultLink($result), $itemid, false);
				$result->href = $href;
				//open link in same window
				$result->browsernav = 2;
				//clean up the text such as removing bbcode, etc
				$result->text = $this->cleanUpSearchText($result->text);
				$result->title = $this->cleanUpSearchText($result->title);
				$result->section = $this->cleanUpSearchText($result->section);
			}
		}

		return $results;
	}

     /**
     * Assigns specific db columns to title and text of content retrieved
     * @return object Db columns assigned to title and text of content retrieved
     */
	function getSearchQueryColumns()
	{
		$columns = new stdClass();
		$columns->title = '';
		$columns->text = '';
		return $columns;
	}

	/**
	 * Generates SQL query for the search plugin that does not include where, limit, or order by
	 * @return string Returns query string
	 */
	function getSearchQuery()
	{
		return '';
	}

	/**
	 * Add on a plugin specific clause;
	 * @param $where reference to where clause already generated by search bot; add on plugin specific criteria
	 */
	function getSearchCriteria(&$where)
	{

	}

	/**
	 * Filter out results from the search ie forums that a user does not have permission to
	 * @param $results object list of search query results
	 */
	function filterSearchResults(&$results)
	{

	}

	/**
	 * Returns the URL for a post
	 * @param $vars mixed
	 * @return string with URL
	 */
	function getSearchResultLink($vars)
	{
		return '';
	}

	/**
	 * Cleans up the text before presented to user; useful for removing BB code, etc
	 * @param $text Text to be cleaned up
	 * @return Cleaned up text
	 */
	function cleanUpSearchText($text)
	{
		return $text;
	}

    /************************************************
	 * Functions For JFusion Who's Online Module
	 ***********************************************/

	/**
	 * Returns a query to find online users
	 * Make sure columns are named as userid, username, username_clean (if applicable), name (of user), and email
	 * @param $limit integer to use as a limiter for the number of results returned
	 */
	function getOnlineUserQuery($limit)
	{
		return '';
	}

	/**
	 * Returns number of guests
	 * @return int
	 */
	function getNumberOnlineGuests()
	{
		return 0;
	}

	/**
	 * Returns number of logged in users
	 * @return int
	 */
	function getNumberOnlineMembers()
	{
		return 0;
	}
	
	/**
	 * Set the language from Joomla to the integrated software
	 * @todo - To implement after the release RC 1.1.2
	 * 
	 * @param object $userinfo - it can be null if the user is not logged for example.
	 */
	function setLanguageFrontEnd($userinfo = null){
		
		$status = array();
        $status['error'] = '';
        $status['debug'] = JText::_( 'METHOD_NOT_IMPLEMENTED' );
		
		return $status;
	}
}