<?php
/**
* @package JFusion
* @subpackage Plugin_Discussbot
* @author JFusion development team
* @copyright Copyright (C) 2008 JFusion. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

// no direct access
defined('_JEXEC' ) or die('Restricted access' );

/**
* Load the JFusion framework
*/
jimport('joomla.plugin.plugin');
require_once(JPATH_ADMINISTRATOR .DS.'components'.DS.'com_jfusion'.DS.'models'.DS.'model.factory.php');
require_once(JPATH_ADMINISTRATOR .DS.'components'.DS.'com_jfusion'.DS.'models'.DS.'model.jfusion.php');

JPlugin::loadLanguage( 'plg_content_jfusion', JPATH_ADMINISTRATOR );

/**
* @package JFusion
*/
class plgContentJfusion extends JPlugin
{
	var $css = array();
	var $params = false;
	var $createThreadNow = true;
	var $generateContent = true;
	var $jname = '';
	var $mode = '';

	/**
	* Constructor
	*
	* For php4 compatability we must not use the __constructor as a constructor for
	* plugins because func_get_args ( void ) returns a copy of all passed arguments
	* NOT references. This causes problems with cross-referencing necessary for the
	* observer design pattern.
	*/
    function plgContentJfusion(& $subject, $config)
    {
        parent::__construct($subject, $config);

		//retrieve plugin software for discussion bot
		if($this->params===false) {
			$jPlugin =& JPluginHelper::getPlugin('content','jfusion');
        	$this->params = new JParameter( $jPlugin->params);
		}

		$jname =& $this->params->get('jname',false);

    	if($jname!==false) {
    		//determine what mode we are to operate in
			if($this->params->get("auto_create")) {
				$this->mode = 'auto';
				if($this->params->get('create_thread')=='reply') {
					$this->createThreadNow = false;
				}
			} else {
				$this->mode = 'manual';
			}
    	} else {
    		$this->generateContent = false;
    	}
    }

    function onAfterContentSave(&$contentitem, $isNew) {
    	$jname =& $this->params->get('jname', false);
    	$valid = $this->validateArticle($contentitem);

        //check to see if a valid $content object was passed on
		if(!is_object($contentitem)){
			JFusionFunction::raiseWarning($jname . ' ' . JText::_('DISCUSSBOT_ERROR'), JText::_('NO_CONTENT_DATA_FOUND'), 1);
			return false;
		}

		if(!empty($jname) && $valid) {
			$createThread =& $this->params->get('create_thread');
			$existingthread =& $this->getCreatedThread($contentitem->id, $jname);
			$JFusionForum =& JFusionFactory::getForum($jname);
			$forumid = $JFusionForum->getDefaultForum($this->params, $contentitem);

			if(($createThread=='load') ||
				($createThread=='new' && ($isNew || (!$isNew && !empty($existingthread)))) ||
				($createThread=='reply' && !empty($existingthread))) {

				$status = $JFusionForum->checkThreadExists($this->params, $contentitem, $existingthread, $forumid);
				if ($status['error']) {
					JFusionFunction::raiseWarning($plugin->name . ' ' .JText::_('FORUM') . ' ' .JText::_('UPDATE'), $status['error'],1);
				}
			}
		}
    }

    function onPrepareContent(&$contentitem, $options) {
    	$jname =& $this->params->get('jname',false);

		//check to see if a valid $content object was passed on
		if(!is_object($contentitem)){
			JFusionFunction::raiseWarning($jname . ' ' . JText::_('DISCUSSBOT_ERROR'), JText::_('NO_CONTENT_DATA_FOUND'), 1);
			return false;
		}

		//prevent any output by the plugins (this could prevent cookies from being passed to the header)
		ob_start();

        //if set to create a thread for new articles only, make sure the thread was created with onAfterContentSave
		if($this->params->get('create_thread') == 'new' && $this->mode == 'auto') {
			$existingthread =& $this->getCreatedThread($contentitem->id, $jname);
			if(empty($existingthread)) {
				$this->generateContent = false;
			}
		}

		if($this->generateContent &&  isset($contentitem->catid) && isset($contentitem->sectionid)) {
			//define some variables
			$JoomlaUser =& JFactory::getUser();
			$allowGuests =& $this->params->get("quickreply_allow_guests",0);
			$JFusionForum =& JFusionFactory::getForum($jname);

			/**
			 * First process any submitted quick replies
			 */

			if(($allowGuests || !$JoomlaUser->guest) && JRequest::getVar('jfusionForm'.$contentitem->id, false, 'POST')!==false && $this->params->get("enable_quickreply",false))	{
				$action = JRequest::getVar('action',false, 'POST');
				if(!empty($action)){
					//retrieve the userid from forum software
					if($allowGuests && $JoomlaUser->guest) {
						$userinfo = new stdClass();
						$userinfo->guest = 1;
					} else {
						$JFusionUser = JFusionFactory::getUser($jname);
						$userinfo = $JFusionUser->getUser($JoomlaUser);
						$userinfo->guest = 0;
					}

					if($action=='createThreadPost') {
						//thread has to be created first
						$forumid = JRequest::getVar('forumid',0, 'POST');
						if(empty($forumid)) {
							//for some reason the forumid didn't make it through so let's get it again
							$forumid = $JFusionForum->getDefaultForum($this->params, $contentitem);
						}

						$postedThread = '';
						$status = $JFusionForum->checkThreadExists($this->params, $contentitem, $postedThread, $forumid);
					    if ($status['error']) {
				    	    JFusionFunction::raiseWarning($plugin->name . ' ' .JText::_('FORUM') . ' ' .JText::_('UPDATE'), $status['error'],1);
				    	} else {
				    		//get the updated thread info
				    		$postedThread =& $this->getCreatedThread($contentitem->id, $jname, true);
				    	}
					} elseif($action=="createPost") {
						$postedThread = new stdClass();
						$postedThread->threadid = JRequest::getVar('threadid',0, 'POST');
						$postedThread->forumid = JRequest::getVar('forumid',0, 'POST');
						$postedThread->postid = JRequest::getVar('postid',0, 'POST');
					}

					//create the post
					if(!empty($postedThread->threadid)) {
						$status = $JFusionForum->createPost($this->params, $postedThread, $contentitem, $userinfo);
						if($status['error']){
							JFusionFunction::raiseWarning($jname . ' ' . JText::_('DISCUSSBOT_ERROR'), $status['error'],1);
						} else {
							$juri =& JURI::getInstance();
							$url = $juri->toString();

							header("Location: $url");
							exit();
						}
					} else {
						JFusionFunction::raiseWarning($jname . ' ' . JText::_('DISCUSSBOT_ERROR'), JText::_('THREADID_NOT_FOUND'),1);
					}
				}
			}

			/**
			 * Second, generate content
			 */

			$this->prepareContent($contentitem);
		}

		ob_end_clean();
		return true;
    }

    function prepareContent(&$contentitem)
    {
        $jname =& $this->params->get('jname');

		//get the jfusion forum object
		$JFusionForum =& JFusionFactory::getForum($jname);

		//create the thread if set to auto generate but only if the content is published and a user has been set
		if($this->mode=="auto") {
			//get the existing thread information
			$existingthread =& $this->getCreatedThread($contentitem->id, $jname);
			$userid =& $this->params->get("default_userid");
			if($contentitem->state && !empty($userid)) {
				//generate the thread/post if article meets criteria
				$valid = $this->validateArticle($contentitem);
				//get the default forum id
				$forumid = $JFusionForum->getDefaultForum($this->params, $contentitem);

				if($valid && !empty($forumid)) {
					if($this->createThreadNow) {
					    $status = $JFusionForum->checkThreadExists($this->params, $contentitem, $existingthread, $forumid);
					    if ($status['error']) {
				    	    JFusionFunction::raiseWarning($plugin->name . ' ' .JText::_('FORUM') . ' ' .JText::_('UPDATE'), $status['error'],1);
				    	} else {
				    		//get the updated thread info
				    		$existingthread =& $this->getCreatedThread($contentitem->id, $jname, true);
				    	}
					}

			    	$content = $this->getContent($contentitem, $existingthread, $jname);
					$contentitem->text .= $content;
				}
			}
	    }

    	//find any {jfusion_discuss...} to manually plug
		preg_match_all('/\{jfusion_discuss (.*)\}/U',$contentitem->text,$matches);

		foreach($matches[1] AS $id)
		{
			//get the existing thread information
			$existingthread = $JFusionForum->getThread($id);
			if(!empty($existingthread)) {
				$content = $this->getContent($contentitem, $existingthread, $jname);
				$contentitem->text = str_replace("{jfusion_discuss $id}",$content,$contentitem->text);
			} else {
				$contentitem->text = str_replace("{jfusion_discuss $id}",JText::_("THREADID_NOT_FOUND"),$contentitem->text);
			}
		}
    }

    function getContent(&$contentitem, &$existingthread, $jname)
    {
    	//if $existingthread is empty return nothing
    	if(empty($existingthread) && $this->createThreadNow) {
    		return '';
    	}

		//setup parameters
		$JFusionForum =& JFusionFactory::getForum($jname);
		$link_text =& $this->params->get("link_text");
		$link_type=& $this->params->get("link_type",'text');
		$linkHTML = ($link_type=='image') ? "<img src='$link_text'>" : $link_text;
		$linkTarget =& $this->params->get('link_target','_parent');
		$itemid =& $this->params->get("itemid");
		$noPostMsg =& $this->params->get("no_posts_msg");
		$mustLoginMsg =& $this->params->get("must_login_msg");
		$show_reply_num =& $this->params->get("show_reply_num");
		$allowGuests =& $this->params->get("quickreply_allow_guests",0);
		$JoomlaUser =& JFactory::getUser();
		//make sure the user exists in the software before displaying the quick reply
		$JFusionUser =& JFusionFactory::getUser($jname);
		$JFusionUserinfo = $JFusionUser->getUser($JoomlaUser);

		//load CSS
		if(empty($this->css)) {
			$this->loadDbCss();
		}

		$view = JRequest::getVar('view');

		$content = "<div style='float:none; display:block;'>";

		if(!empty($existingthread) && ($view=="article" || $this->params->get('always_show_link',false))) {
			if($show_reply_num) {
				$numPosts = $JFusionForum->getReplyCount($existingthread);
				$post = ($numPosts==1) ? "REPLY" : "REPLIES";
				$replyNum = '['.$numPosts.' '.JText::_($post).']';
			} else {
				$replyNum = '';
			}

			$threadid =& $existingthread->threadid;
			$urlstring_pre = JFusionFunction::routeURL($JFusionForum->getThreadURL($threadid), $itemid);
			$content .= '<div class="'.$this->css['threadLink'].'"><a href="'. $urlstring_pre . '" target="' . $linkTarget . '">' . $linkHTML . '</a> '.$replyNum.'</div>';
		}

		//let's only show quick replies and posts on the article view
		if($view=="article") {
			if(!empty($existingthread)) {
				//prepare quick reply box if enabled
				if($this->params->get("enable_quickreply")){
					$show = ($allowGuests || (!$JoomlaUser->guest && !empty($JFusionUserinfo))) ? "form" : "message";
					$replyForm  = "<div class='{$this->css["quickReplyHeader"]}'>{$this->params->get("quick_reply_header")}</div>\n";
					$replyForm .= "<div class='{$this->css["quickReply"]}'>\n";
				} else {
					$show = false;
				}

				if(!$JoomlaUser->guest && empty($JFusionUserinfo)) {
					$replyForm .=  $jname . ': ' . JText::_('USER_NOT_EXIST')."\n";
					$replyForm .= "</div>\n";
				} elseif($show=="form") {
					$replyForm .= "<form name='jfusionQuickReply{$contentitem->id}' method=post action='".JURI::current()."'>\n";
					$replyForm .= "<input type=hidden name='jfusionForm{$contentitem->id}' value='1'/>\n";
					$replyForm .= "<input type=hidden name='threadid' value='{$existingthread->threadid}'/>\n";
					$replyForm .= "<input type=hidden name='forumid' value='{$existingthread->forumid}'/>\n";
					$replyForm .= "<input type=hidden name='postid' value='{$existingthread->postid}'/>\n";
					$replyForm .= "<input type=hidden name='action' value='createPost'>\n";
					$showGuestInputs = ($allowGuests && $JoomlaUser->guest) ? true : false;
					$replyForm .= $JFusionForum->createQuickReply($this->params,$showGuestInputs)."</form>\n";
					$replyForm .= "</div>\n";
				} elseif($show=="message") {
					$replyForm .= $mustLoginMsg;
					$replyForm .= "</div>\n";
				}

				//add posts to content if enabled
				if($this->params->get("show_posts")) {
					//get the posts
					$posts = $JFusionForum->getPosts($this->params, $existingthread);

					$content  .= "<div class='{$this->css["postArea"]}'> \n";

					if($show!==false && $this->params->get("quickreply_location")=="above") {
						$content .= $replyForm;
					}

					if(!empty($posts)){
						$content .= $JFusionForum->createPostTable($this->params, $existingthread, $posts, $this->css);
					} elseif(!empty($noPostMsg)) {
						$content .= "<div class='{$this->css["noPostMsg"]}'> {$noPostMsg} </div>\n";
					}

					if($show!==false && $this->params->get("quickreply_location")=="below"){
						$content .= $replyForm;
					}

					$content .= "</div> \n";
				} elseif($show!==false){
					$content .= $replyForm;
				}
			} else {
				//prepare quick reply box if enabled
				if($this->params->get("enable_quickreply")){
					$show = ($allowGuests || (!$JoomlaUser->guest && !empty($JFusionUserinfo))) ? "form" : "message";
					$replyForm  = "<div class='{$this->css["quickReplyHeader"]}'>{$this->params->get("quick_reply_header")}</div>\n";
					$replyForm .= "<div class='{$this->css["quickReply"]}'>\n";
				} else {
					$show = false;
				}

				if(!$JoomlaUser->guest && empty($JFusionUserinfo)) {
					$replyForm .=  $jname . ': ' . JText::_('USER_NOT_EXIST')."\n";
					$replyForm .= "</div>\n";
				} elseif($show=="form") {
					$replyForm .= "<form name='jfusionQuickReply{$contentitem->id}' method=post action='".JURI::current()."'>\n";
					$replyForm .= "<input type=hidden name='jfusionForm{$contentitem->id}' value='1'/>\n";
					$replyForm .= "<input type=hidden name='forumid' value='{$existingthread->forumid}'/>\n";
					$replyForm .= "<input type=hidden name='action' value='createThreadPost'/>\n";
					$showGuestInputs = ($allowGuests && $JoomlaUser->guest) ? true : false;
					$replyForm .= $JFusionForum->createQuickReply($this->params,$showGuestInputs)."</form>\n";
					$replyForm .= "</div>\n";
				} elseif($show=="message") {
					$replyForm .= $mustLoginMsg;
					$replyForm .= "</div>\n";
				}

				if($show!==false) {
					$content .= $replyForm;
				}
			}
		}
		$content .= "</div>";
		return $content;
    }

    function loadDbCss()
    {
    	$defaultCSS = array();
    	$this->css = array();
		$this->css['threadLink'] = $this->params->get("cssClassThreadLink");
		$defaultCSS['threadLink'] = "font-size:12px; margin:5px;";

		$this->css['postArea'] = $this->params->get("cssClassPostArea");
		$defaultCSS['postArea'] = "width:100%; margin:10px;";

		$this->css['postHeader'] = $this->params->get("cssClassPostHeader");
		$defaultCSS['postHeader'] = "font-size:11px; color:#000000; font-weight:bold;";

		$this->css['postBody'] = $this->params->get("cssClassPostBody");
		$defaultCSS['postBody'] = "border:1px solid #eee; min-height: 90px;";

		$this->css['postTitle'] = $this->params->get("cssClassPostTitle");
		$defaultCSS['postTitle'] = "color:#000000; float:left; margin-right:4px;";

		$this->css['noPostMsg'] = $this->params->get("cssClassNoPostMsg");
		$defaultCSS['noPostMsg'] = "font-weight:bold;";

		$this->css['postUser'] = $this->params->get("cssClassPostUser");
		$defaultCSS['postUser'] = "";

		$this->css['userAvatar'] = $this->params->get("cssClassUserAvatar");
		$defaultCSS['userAvatar'] = "float:left; margin-right:5px;";

		$this->css['postDate'] = $this->params->get("cssClassPostDate");
		$defaultCSS['postDate'] = "font-size:9px;";

		$this->css['postText'] = $this->params->get("cssClassPostText");
		$defaultCSS['postText'] = "margin-top:5px;";

		$this->css['quickReply'] = $this->params->get("cssClassQuickReply");
		$defaultCSS['quickReply'][''] = "";
		$defaultCSS['quickReply']['textarea'] = "width:100%; height: 100px;";

		$this->css['quickReplyHeader'] = $this->params->get("cssClassQuickReplyHeader");
		$defaultCSS['quickReplyHeader'] = "font-weight:bold;";

		$css = "";
		foreach ($this->css AS $k => $v){
			if(empty($v)){
				$this->css[$k] = "jfDb" . ucfirst($k);
				if(is_array($defaultCSS[$k])) {
					$temp = $defaultCSS[$k];
					foreach($temp AS $k2 => $v2) {
						$css .= ".{$this->css[$k]} $k2 { $v2 }\n";
					}
				} else {
					$css .= ".{$this->css[$k]} { {$defaultCSS[$k]} }\n";
				}
			}
		}

		if(!empty($css)) {
			$css = "<style type=\"text/css\">\n".$css."</style>\n";
			$document =& JFactory::getDocument();
			$document->addCustomTag($css);
		}
	}

	function validateArticle(&$contentitem)
	{
    	$forumid = $this->params->get("default_forum",false);
		$sectionPairs = $this->params->get("pair_sections",false);
		$categoryPairs = $this->params->get("pair_categories",false);
		//section and category id of content
		$secid =& $contentitem->sectionid;
		$catid =& $contentitem->catid;

		//check to see if we have an uncategorized article
		if(empty($secid) && empty($catid)) {
			//does the admin want a thread generated?
			if($this->params->get('include_static',false)) {
				return true;
			} else {
				return false;
			}
		}

		//first we need to check to see if we at least one forum to work with
		if($forumid || $sectionPairs || $categoryPairs) {
	    	//check to see if there are sections/categories that are specifically included/excluded
	    	$sections =& $this->params->get("include_sections");
			$includeSections = empty($sections) ? false : explode(",",$sections);

			$categories =& $this->params->get("include_categories");
			$includeCategories = empty($categories) ? false : explode(",",$categories);

			$sections =& $this->params->get("exclude_sections");
			$excludeSections = empty($sections) ? false : explode(",",$sections);

			$categories =& $this->params->get("exclude_categories");
			$excludeCategories = empty($categories) ? false : explode(",",$categories);

			//there are section stipulations on what articles to include
			if($includeSections) {
				if($includeCategories) {
					//there are both specific sections and categories to include
					//check to see if this article is not in the selected sections and categories
					if(!in_array($secid,$includeSections) && !in_array($catid,$includeCategories)) $valid = false;
				} elseif($excludeCategories) {
					//exclude this article if it is in one of the excluded categories
					if(in_array($catid,$excludeCategories)) $valid = false;
				} elseif(in_array($secid,$includeSections)) {
					//there are only specific sections to include with no category stipulations
					$valid = true;
				} else  {
					//this article is not in one of the sections to include
					$valid = false;
				}
			} elseif($includeCategories) {
				//there are category stipulations on what articles to include but no section stipulations
		        //check to see if this article is not in the selected categories
				$valid = (!in_array($catid,$includeCategories)) ? false : true;
			} elseif($excludeSections) {
			    //there are section stipulations on what articles to exclude
				//check to see if this article is in the excluded sections
				$valid = (in_array($secid,$excludeSections)) ? false : true;
			} elseif($excludeCategories) {
				//there are category stipulations on what articles to exclude but no exclude stipulations on section
				//check to see if this article is in the excluded categories
				$valid = (in_array($catid,$excludeCategories)) ? false : true;
			} elseif($forumid!==false) {
				$valid = true;
			} else {
				$valid = false;
			}
		} else {
			$valid = false;
		}

		return $valid;
	}

	function getCreatedThread($contentid,$jname, $update = false) {
		static $thread_instance;

		if(!is_array($thread_instance)) {
			$thread_instance = array();
		}

		if(empty($thread_instance) || !isset($thread_instance[$contentid]) || $update) {
			$db =& JFactory::getDBO();
        	$query = "SELECT * FROM #__jfusion_forum_plugin WHERE contentid = '$contentid' AND jname = '$jname'";
        	$db->setQuery($query);
        	$thread_instance[$contentid] = $db->loadObject();
		}

        return $thread_instance[$contentid];
	}
}
?>