<?php
/**
* @package JFusion
* @subpackage Modules
* @author JFusion development team
* @copyright Copyright (C) 2009 JFusion. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*/

/**
* @package JFusion
*/
class modjfusionWhosOnlineHelper {
	function renderPluginAuto($jname, $config, $params) {
		//now check to see if the plugin is configured
	    $jdb =& JFactory::getDBO();
	    $query = 'SELECT status from #__jfusion WHERE name = ' . $jdb->Quote($jname);
	    $jdb->setQuery($query );

	    if ($jdb->loadResult() == 1) {
	        //get the itemid and jname to get any missing urls
		    $link_itemid = $config['itemid'];
		    if (is_numeric($link_itemid)) {
		        $menu = &JSite::getMenu();
		        $menu_param =& $menu->getParams($link_itemid);
		        $plugin_param = unserialize(base64_decode($menu_param->get('JFusionPluginParam')));
		        $link_jname = $plugin_param['jfusionplugin'];
		    } else {
		        $link_jname = $link_itemid;
		    }

		    if(JFusionFunction::validPlugin($link_jname)) {
		        $forum = JFusionFactory::getForum($link_jname);
		        $public = JFusionFactory::getPublic($jname);
		        $db = JFusionFactory::getDatabase($jname);

		        if (JError::isError($db)) {
		            return JText::_('NO_DATABASE');
		        } else {
					$output = '';

		            //show the number of people online if set to do so
					if($config["showmode"]==0 || $config["showmode"]==2){
						$numGuests = $public->getNumberOnlineGuests();
						$numMembers = $public->getNumberOnlineMembers();
	                	$output .= JText::_('WE_HAVE').'&nbsp;';
	                	if($numGuests==1) {
	                		$output .= JText::sprintf('GUEST','1');
	                	} elseif($numGuests==0 || $numGuests>1) {
	                		$output .= JText::sprintf('GUESTS',$numGuests) ;
	                	}

	    				$output .= '&nbsp;' . JText::_('AND') . '&nbsp;';

	                    if($numMembers==1) {
	                		$output .= JText::sprintf('MEMBER','1');
	                	} elseif($numMembers==0 || $numMembers>1) {
	                		$output .= JText::sprintf('MEMBERS',$numMembers);
	                	}
	                	$output .= '&nbsp;'.JText::_('ONLINE') . '<br />';
					}

			        $query = $public->getOnlineUserQuery($config["member_limit"]);
		            $db->setQuery($query);
		            $results = $db->loadObjectList();

	                if (JError::isError($db)) {
	                    return $db->stderr();
	                } else if (!$results) {
	                    $output .= JText::_('NO_USERS_ONLINE');
	                } else {
						$output .= "<ul>";
	                    // process result
						foreach($results as $result) {
							//assign the joomla_userid and jfusion_userid variables
							if($link_jname==$jname) {
								$jfusion_userid = $result->userid;
								 
								if($jname=='joomla_int') {
									//Joomla's userid is readily available
									$joomla_userid = $result->userid;
								} elseif(!empty($userlookup)) {
									//obtain the correct Joomla userid for the user
									$lookupUsername = (!empty($result->username_clean)) ? $result->username_clean : $result->username;						 	
								 	//find it in the lookup table
									$userlookup = JFusionFunction::lookupUser($link_jname, $result->userid, false, $lookupUsername);
									if(!empty($userlookup)) {								 	
								 		$joomla_userid = $userlookup->id;
									}
								}
							} else {
								//first, the userid of the JFusion plugin for the menu item must be obtained
								$JFusionUser =& JFusionFactory::getUser($link_jname);							
								$userinfo = $JFusionUser->getUser($result);
								
								if(!empty($userinfo)) {
									$jfusion_userid = $userinfo->userid;

									if($jname=="joomla_int") {
										//Joomla's userid is readily available									
										$joomla_userid = $result->userid;
									} else {
							 			$userlookup = JFusionFunction::lookupUser($link_jname, $userinfo->userid, false, $userinfo->username);
										if(!empty($userlookup)) {
											$joomla_id = $userlookup->id;
										}
									}								 	
								}
							}
								
							$name = ($config["name"]==1) ? $result->name : $result->username;
							if ($config['userlink']) {
								if($config['userlink_software']!='' && $config['userlink_software'] != 'jfusion' && $config["userlink_software"]!='custom' && !empty($joomla_userid)) {
									$user_url = JFusionFunction::getAltProfileURL($config['userlink_software'],$joomla_userid);
								} elseif ($config['userlink_software']=='custom' && !empty($config['userlink_custom'])  && !empty($joomla_userid)) {
									$user_url = $config['userlink_custom'].$joomla_userid;
								} else {
									$user_url = false;
								}

								if($user_url === false  && $link_jname!='joomla_int' && $link_jname!='joomla_ext') {
	  								$user_url = JFusionFunction::routeURL($forum->getProfileURL($jfusion_userid, $result->username), $config['itemid']);
	  							}

	  							$user = '<a href="'. $user_url . '">'.$name.'</a>';
	  						} else {
	  							$user = $name;
	  						}

							$avatar = '';
				            if ($config['avatar']) {
			    	            // retrieve avatar
			    	            $avatarSrc = $config['avatar_software'];
			    	            if($link_jname!='joomla_int' && $link_jname!='joomla_ext' && ($avatarSrc=='' || $avatarSrc=='jfusion')  && !empty($jfusion_userid)) {
									$avatar = $forum->getAvatar($jfusion_userid);
			    	            } elseif(!empty($avatarSrc) && $avatarSrc!='jfusion' && !empty($joomla_userid)) {
			    	            	$avatar = JFusionFunction::getAltAvatar($avatarSrc, $joomla_userid);
			    	            }

								if(empty($avatar)) {
									$avatar = JFusionFunction::getJoomlaURL().'components/com_jfusion/images/noavatar.png';
								}

					            $size = @getimagesize($avatar);
								$maxheight = $config['avatar_height'];
								$maxwidth = $config['avatar_width'];
				            	//size the avatar to fit inside the dimensions if larger
								if($size!==false && ($size[0] > $maxwidth || $size[1] > $maxheight)) {
									$wscale = $maxwidth/$size[0];
									$hscale = $maxheight/$size[1];
									$scale = min($hscale, $wscale);
									$w = floor($scale*$size[0]);
									$h = floor($scale*$size[1]);
								}
								elseif($size!==false) {
									//the avatar is within the limits
									$w = $size[0];
									$h = $size[1];
								} else {
									//getimagesize failed
									$w = $maxwidth;
									$h = $maxheight;
								}

								$avatar = "<img style='vertical-align:middle; margin:3px;' src='$avatar' height='$h' width='$w' alt='avatar' />";
				            }

	                        //put it all together for output
	                        $output .= '<li>'. $avatar . ' <b>'.$user.'</b></li>';
						}
					
			            $output .= "</ul>";
					}

					return $output;
		        }
		    } else {
		    	return JText::_('NO_MENU_ITEM');
		    }

	    } else {
	        return JText::_('NOT_CONFIGURED');
	    }
	}

	function renderPluginMode($jname, $config, $view, $pluginParam) {
		$forum = JFusionFactory::getForum($jname);
		if(method_exists($forum, "renderWhosOnlineModule")) {
			return $forum->renderWhosOnlineModule($config, $view, $pluginParam);
		}
		return JText::_('NOT_IMPLEMENTED_YET');
	}
}
?>